{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Displays a @GdkPaintable@.
-- 
-- picture>
--   \<source srcset=\"picture-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkPicture\" src=\"picture.png\">
-- \<\/picture>
-- 
-- Many convenience functions are provided to make pictures simple to use.
-- For example, if you want to load an image from a file, and then display
-- it, there’s a convenience function to do this:
-- 
-- 
-- === /c code/
-- >GtkWidget *widget = gtk_picture_new_for_filename ("myfile.png");
-- 
-- 
-- If the file isn’t loaded successfully, the picture will contain a
-- “broken image” icon similar to that used in many web browsers.
-- If you want to handle errors in loading the file yourself,
-- for example by displaying an error message, then load the image with
-- 'GI.Gdk.Objects.Texture.textureNewFromFile', then create the @GtkPicture@ with
-- 'GI.Gtk.Objects.Picture.pictureNewForPaintable'.
-- 
-- Sometimes an application will want to avoid depending on external data
-- files, such as image files. See the documentation of @GResource@ for details.
-- In this case, 'GI.Gtk.Objects.Picture.pictureNewForResource' and
-- 'GI.Gtk.Objects.Picture.pictureSetResource' should be used.
-- 
-- @GtkPicture@ displays an image at its natural size. See t'GI.Gtk.Objects.Image.Image'
-- if you want to display a fixed-size image, such as an icon.
-- 
-- == Sizing the paintable
-- 
-- You can influence how the paintable is displayed inside the @GtkPicture@
-- by changing [Picture:contentFit]("GI.Gtk.Objects.Picture#g:attr:contentFit"). See t'GI.Gtk.Enums.ContentFit'
-- for details. [Picture:canShrink]("GI.Gtk.Objects.Picture#g:attr:canShrink") can be unset to make sure
-- that paintables are never made smaller than their ideal size - but
-- be careful if you do not know the size of the paintable in use (like
-- when displaying user-loaded images). This can easily cause the picture to
-- grow larger than the screen. And [Widget:halign]("GI.Gtk.Objects.Widget#g:attr:halign") and
-- [Widget:valign]("GI.Gtk.Objects.Widget#g:attr:valign") can be used to make sure the paintable doesn\'t
-- fill all available space but is instead displayed at its original size.
-- 
-- == CSS nodes
-- 
-- @GtkPicture@ has a single CSS node with the name @picture@.
-- 
-- == Accessibility
-- 
-- @GtkPicture@ uses the [enum/@gtk@/.AccessibleRole.img] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Picture
    ( 

-- * Exported types
    Picture(..)                             ,
    IsPicture                               ,
    toPicture                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAlternativeText]("GI.Gtk.Objects.Picture#g:method:getAlternativeText"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanShrink]("GI.Gtk.Objects.Picture#g:method:getCanShrink"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getContentFit]("GI.Gtk.Objects.Picture#g:method:getContentFit"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFile]("GI.Gtk.Objects.Picture#g:method:getFile"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getKeepAspectRatio]("GI.Gtk.Objects.Picture#g:method:getKeepAspectRatio"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPaintable]("GI.Gtk.Objects.Picture#g:method:getPaintable"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAlternativeText]("GI.Gtk.Objects.Picture#g:method:setAlternativeText"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanShrink]("GI.Gtk.Objects.Picture#g:method:setCanShrink"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setContentFit]("GI.Gtk.Objects.Picture#g:method:setContentFit"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFile]("GI.Gtk.Objects.Picture#g:method:setFile"), [setFilename]("GI.Gtk.Objects.Picture#g:method:setFilename"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setKeepAspectRatio]("GI.Gtk.Objects.Picture#g:method:setKeepAspectRatio"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setPaintable]("GI.Gtk.Objects.Picture#g:method:setPaintable"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPixbuf]("GI.Gtk.Objects.Picture#g:method:setPixbuf"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResource]("GI.Gtk.Objects.Picture#g:method:setResource"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolvePictureMethod                    ,
#endif

-- ** getAlternativeText #method:getAlternativeText#

#if defined(ENABLE_OVERLOADING)
    PictureGetAlternativeTextMethodInfo     ,
#endif
    pictureGetAlternativeText               ,


-- ** getCanShrink #method:getCanShrink#

#if defined(ENABLE_OVERLOADING)
    PictureGetCanShrinkMethodInfo           ,
#endif
    pictureGetCanShrink                     ,


-- ** getContentFit #method:getContentFit#

#if defined(ENABLE_OVERLOADING)
    PictureGetContentFitMethodInfo          ,
#endif
    pictureGetContentFit                    ,


-- ** getFile #method:getFile#

#if defined(ENABLE_OVERLOADING)
    PictureGetFileMethodInfo                ,
#endif
    pictureGetFile                          ,


-- ** getKeepAspectRatio #method:getKeepAspectRatio#

#if defined(ENABLE_OVERLOADING)
    PictureGetKeepAspectRatioMethodInfo     ,
#endif
    pictureGetKeepAspectRatio               ,


-- ** getPaintable #method:getPaintable#

#if defined(ENABLE_OVERLOADING)
    PictureGetPaintableMethodInfo           ,
#endif
    pictureGetPaintable                     ,


-- ** new #method:new#

    pictureNew                              ,


-- ** newForFile #method:newForFile#

    pictureNewForFile                       ,


-- ** newForFilename #method:newForFilename#

    pictureNewForFilename                   ,


-- ** newForPaintable #method:newForPaintable#

    pictureNewForPaintable                  ,


-- ** newForPixbuf #method:newForPixbuf#

    pictureNewForPixbuf                     ,


-- ** newForResource #method:newForResource#

    pictureNewForResource                   ,


-- ** setAlternativeText #method:setAlternativeText#

#if defined(ENABLE_OVERLOADING)
    PictureSetAlternativeTextMethodInfo     ,
#endif
    pictureSetAlternativeText               ,


-- ** setCanShrink #method:setCanShrink#

#if defined(ENABLE_OVERLOADING)
    PictureSetCanShrinkMethodInfo           ,
#endif
    pictureSetCanShrink                     ,


-- ** setContentFit #method:setContentFit#

#if defined(ENABLE_OVERLOADING)
    PictureSetContentFitMethodInfo          ,
#endif
    pictureSetContentFit                    ,


-- ** setFile #method:setFile#

#if defined(ENABLE_OVERLOADING)
    PictureSetFileMethodInfo                ,
#endif
    pictureSetFile                          ,


-- ** setFilename #method:setFilename#

#if defined(ENABLE_OVERLOADING)
    PictureSetFilenameMethodInfo            ,
#endif
    pictureSetFilename                      ,


-- ** setKeepAspectRatio #method:setKeepAspectRatio#

#if defined(ENABLE_OVERLOADING)
    PictureSetKeepAspectRatioMethodInfo     ,
#endif
    pictureSetKeepAspectRatio               ,


-- ** setPaintable #method:setPaintable#

#if defined(ENABLE_OVERLOADING)
    PictureSetPaintableMethodInfo           ,
#endif
    pictureSetPaintable                     ,


-- ** setPixbuf #method:setPixbuf#

#if defined(ENABLE_OVERLOADING)
    PictureSetPixbufMethodInfo              ,
#endif
    pictureSetPixbuf                        ,


-- ** setResource #method:setResource#

#if defined(ENABLE_OVERLOADING)
    PictureSetResourceMethodInfo            ,
#endif
    pictureSetResource                      ,




 -- * Properties


-- ** alternativeText #attr:alternativeText#
-- | The alternative textual description for the picture.

#if defined(ENABLE_OVERLOADING)
    PictureAlternativeTextPropertyInfo      ,
#endif
    clearPictureAlternativeText             ,
    constructPictureAlternativeText         ,
    getPictureAlternativeText               ,
#if defined(ENABLE_OVERLOADING)
    pictureAlternativeText                  ,
#endif
    setPictureAlternativeText               ,


-- ** canShrink #attr:canShrink#
-- | If the @GtkPicture@ can be made smaller than the natural size of its contents.

#if defined(ENABLE_OVERLOADING)
    PictureCanShrinkPropertyInfo            ,
#endif
    constructPictureCanShrink               ,
    getPictureCanShrink                     ,
#if defined(ENABLE_OVERLOADING)
    pictureCanShrink                        ,
#endif
    setPictureCanShrink                     ,


-- ** contentFit #attr:contentFit#
-- | How the content should be resized to fit inside the @GtkPicture@.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    PictureContentFitPropertyInfo           ,
#endif
    constructPictureContentFit              ,
    getPictureContentFit                    ,
#if defined(ENABLE_OVERLOADING)
    pictureContentFit                       ,
#endif
    setPictureContentFit                    ,


-- ** file #attr:file#
-- | The @GFile@ that is displayed or 'P.Nothing' if none.

#if defined(ENABLE_OVERLOADING)
    PictureFilePropertyInfo                 ,
#endif
    clearPictureFile                        ,
    constructPictureFile                    ,
    getPictureFile                          ,
#if defined(ENABLE_OVERLOADING)
    pictureFile                             ,
#endif
    setPictureFile                          ,


-- ** keepAspectRatio #attr:keepAspectRatio#
-- | Whether the GtkPicture will render its contents trying to preserve the aspect
-- ratio.

#if defined(ENABLE_OVERLOADING)
    PictureKeepAspectRatioPropertyInfo      ,
#endif
    constructPictureKeepAspectRatio         ,
    getPictureKeepAspectRatio               ,
#if defined(ENABLE_OVERLOADING)
    pictureKeepAspectRatio                  ,
#endif
    setPictureKeepAspectRatio               ,


-- ** paintable #attr:paintable#
-- | The @GdkPaintable@ to be displayed by this @GtkPicture@.

#if defined(ENABLE_OVERLOADING)
    PicturePaintablePropertyInfo            ,
#endif
    clearPicturePaintable                   ,
    constructPicturePaintable               ,
    getPicturePaintable                     ,
#if defined(ENABLE_OVERLOADING)
    picturePaintable                        ,
#endif
    setPicturePaintable                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Picture = Picture (SP.ManagedPtr Picture)
    deriving (Eq)

instance SP.ManagedPtrNewtype Picture where
    toManagedPtr (Picture p) = p

foreign import ccall "gtk_picture_get_type"
    c_gtk_picture_get_type :: IO B.Types.GType

instance B.Types.TypedObject Picture where
    glibType = c_gtk_picture_get_type

instance B.Types.GObject Picture

-- | Type class for types which can be safely cast to `Picture`, for instance with `toPicture`.
class (SP.GObject o, O.IsDescendantOf Picture o) => IsPicture o
instance (SP.GObject o, O.IsDescendantOf Picture o) => IsPicture o

instance O.HasParentTypes Picture
type instance O.ParentTypes Picture = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Picture`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPicture :: (MIO.MonadIO m, IsPicture o) => o -> m Picture
toPicture = MIO.liftIO . B.ManagedPtr.unsafeCastTo Picture

-- | Convert 'Picture' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Picture) where
    gvalueGType_ = c_gtk_picture_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Picture)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Picture)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Picture ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePictureMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePictureMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolvePictureMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolvePictureMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolvePictureMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolvePictureMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolvePictureMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolvePictureMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolvePictureMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolvePictureMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolvePictureMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolvePictureMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePictureMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePictureMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolvePictureMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolvePictureMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolvePictureMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolvePictureMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolvePictureMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolvePictureMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolvePictureMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolvePictureMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolvePictureMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolvePictureMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolvePictureMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePictureMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePictureMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePictureMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolvePictureMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolvePictureMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolvePictureMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolvePictureMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolvePictureMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolvePictureMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolvePictureMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolvePictureMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolvePictureMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolvePictureMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolvePictureMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolvePictureMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolvePictureMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePictureMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolvePictureMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolvePictureMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolvePictureMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolvePictureMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolvePictureMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolvePictureMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolvePictureMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolvePictureMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePictureMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePictureMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolvePictureMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolvePictureMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolvePictureMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolvePictureMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolvePictureMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolvePictureMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolvePictureMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePictureMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePictureMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolvePictureMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolvePictureMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolvePictureMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolvePictureMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolvePictureMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolvePictureMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolvePictureMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePictureMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolvePictureMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolvePictureMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolvePictureMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolvePictureMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePictureMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePictureMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePictureMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolvePictureMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolvePictureMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolvePictureMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolvePictureMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolvePictureMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePictureMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolvePictureMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolvePictureMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolvePictureMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolvePictureMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolvePictureMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolvePictureMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePictureMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolvePictureMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolvePictureMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolvePictureMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolvePictureMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolvePictureMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolvePictureMethod "getAlternativeText" o = PictureGetAlternativeTextMethodInfo
    ResolvePictureMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolvePictureMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolvePictureMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolvePictureMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolvePictureMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolvePictureMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolvePictureMethod "getCanShrink" o = PictureGetCanShrinkMethodInfo
    ResolvePictureMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolvePictureMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolvePictureMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolvePictureMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolvePictureMethod "getContentFit" o = PictureGetContentFitMethodInfo
    ResolvePictureMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolvePictureMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolvePictureMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolvePictureMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePictureMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolvePictureMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolvePictureMethod "getFile" o = PictureGetFileMethodInfo
    ResolvePictureMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolvePictureMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolvePictureMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolvePictureMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolvePictureMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolvePictureMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolvePictureMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolvePictureMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolvePictureMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolvePictureMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolvePictureMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolvePictureMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolvePictureMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolvePictureMethod "getKeepAspectRatio" o = PictureGetKeepAspectRatioMethodInfo
    ResolvePictureMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolvePictureMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolvePictureMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolvePictureMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolvePictureMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolvePictureMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolvePictureMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolvePictureMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolvePictureMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolvePictureMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolvePictureMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolvePictureMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolvePictureMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolvePictureMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolvePictureMethod "getPaintable" o = PictureGetPaintableMethodInfo
    ResolvePictureMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolvePictureMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolvePictureMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolvePictureMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolvePictureMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolvePictureMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolvePictureMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePictureMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePictureMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolvePictureMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolvePictureMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolvePictureMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolvePictureMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolvePictureMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolvePictureMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolvePictureMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolvePictureMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolvePictureMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolvePictureMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolvePictureMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolvePictureMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolvePictureMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolvePictureMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolvePictureMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolvePictureMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolvePictureMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolvePictureMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolvePictureMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolvePictureMethod "setAlternativeText" o = PictureSetAlternativeTextMethodInfo
    ResolvePictureMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolvePictureMethod "setCanShrink" o = PictureSetCanShrinkMethodInfo
    ResolvePictureMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolvePictureMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolvePictureMethod "setContentFit" o = PictureSetContentFitMethodInfo
    ResolvePictureMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolvePictureMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolvePictureMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolvePictureMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePictureMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePictureMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolvePictureMethod "setFile" o = PictureSetFileMethodInfo
    ResolvePictureMethod "setFilename" o = PictureSetFilenameMethodInfo
    ResolvePictureMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolvePictureMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolvePictureMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolvePictureMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolvePictureMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolvePictureMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolvePictureMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolvePictureMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolvePictureMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolvePictureMethod "setKeepAspectRatio" o = PictureSetKeepAspectRatioMethodInfo
    ResolvePictureMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolvePictureMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolvePictureMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolvePictureMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolvePictureMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolvePictureMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolvePictureMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolvePictureMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolvePictureMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolvePictureMethod "setPaintable" o = PictureSetPaintableMethodInfo
    ResolvePictureMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolvePictureMethod "setPixbuf" o = PictureSetPixbufMethodInfo
    ResolvePictureMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePictureMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolvePictureMethod "setResource" o = PictureSetResourceMethodInfo
    ResolvePictureMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolvePictureMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolvePictureMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolvePictureMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolvePictureMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolvePictureMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolvePictureMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolvePictureMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolvePictureMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolvePictureMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePictureMethod t Picture, O.OverloadedMethod info Picture p) => OL.IsLabel t (Picture -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePictureMethod t Picture, O.OverloadedMethod info Picture p, R.HasField t Picture p) => R.HasField t Picture p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePictureMethod t Picture, O.OverloadedMethodInfo info Picture) => OL.IsLabel t (O.MethodProxy info Picture) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "alternative-text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@alternative-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' picture #alternativeText
-- @
getPictureAlternativeText :: (MonadIO m, IsPicture o) => o -> m (Maybe T.Text)
getPictureAlternativeText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "alternative-text"

-- | Set the value of the “@alternative-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' picture [ #alternativeText 'Data.GI.Base.Attributes.:=' value ]
-- @
setPictureAlternativeText :: (MonadIO m, IsPicture o) => o -> T.Text -> m ()
setPictureAlternativeText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "alternative-text" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@alternative-text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPictureAlternativeText :: (IsPicture o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructPictureAlternativeText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "alternative-text" (P.Just val)

-- | Set the value of the “@alternative-text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #alternativeText
-- @
clearPictureAlternativeText :: (MonadIO m, IsPicture o) => o -> m ()
clearPictureAlternativeText obj = liftIO $ B.Properties.setObjectPropertyString obj "alternative-text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data PictureAlternativeTextPropertyInfo
instance AttrInfo PictureAlternativeTextPropertyInfo where
    type AttrAllowedOps PictureAlternativeTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PictureAlternativeTextPropertyInfo = IsPicture
    type AttrSetTypeConstraint PictureAlternativeTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint PictureAlternativeTextPropertyInfo = (~) T.Text
    type AttrTransferType PictureAlternativeTextPropertyInfo = T.Text
    type AttrGetType PictureAlternativeTextPropertyInfo = (Maybe T.Text)
    type AttrLabel PictureAlternativeTextPropertyInfo = "alternative-text"
    type AttrOrigin PictureAlternativeTextPropertyInfo = Picture
    attrGet = getPictureAlternativeText
    attrSet = setPictureAlternativeText
    attrTransfer _ v = do
        return v
    attrConstruct = constructPictureAlternativeText
    attrClear = clearPictureAlternativeText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.alternativeText"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#g:attr:alternativeText"
        })
#endif

-- VVV Prop "can-shrink"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@can-shrink@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' picture #canShrink
-- @
getPictureCanShrink :: (MonadIO m, IsPicture o) => o -> m Bool
getPictureCanShrink obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "can-shrink"

-- | Set the value of the “@can-shrink@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' picture [ #canShrink 'Data.GI.Base.Attributes.:=' value ]
-- @
setPictureCanShrink :: (MonadIO m, IsPicture o) => o -> Bool -> m ()
setPictureCanShrink obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "can-shrink" val

-- | Construct a `GValueConstruct` with valid value for the “@can-shrink@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPictureCanShrink :: (IsPicture o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPictureCanShrink val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "can-shrink" val

#if defined(ENABLE_OVERLOADING)
data PictureCanShrinkPropertyInfo
instance AttrInfo PictureCanShrinkPropertyInfo where
    type AttrAllowedOps PictureCanShrinkPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PictureCanShrinkPropertyInfo = IsPicture
    type AttrSetTypeConstraint PictureCanShrinkPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PictureCanShrinkPropertyInfo = (~) Bool
    type AttrTransferType PictureCanShrinkPropertyInfo = Bool
    type AttrGetType PictureCanShrinkPropertyInfo = Bool
    type AttrLabel PictureCanShrinkPropertyInfo = "can-shrink"
    type AttrOrigin PictureCanShrinkPropertyInfo = Picture
    attrGet = getPictureCanShrink
    attrSet = setPictureCanShrink
    attrTransfer _ v = do
        return v
    attrConstruct = constructPictureCanShrink
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.canShrink"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#g:attr:canShrink"
        })
#endif

-- VVV Prop "content-fit"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ContentFit"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@content-fit@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' picture #contentFit
-- @
getPictureContentFit :: (MonadIO m, IsPicture o) => o -> m Gtk.Enums.ContentFit
getPictureContentFit obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "content-fit"

-- | Set the value of the “@content-fit@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' picture [ #contentFit 'Data.GI.Base.Attributes.:=' value ]
-- @
setPictureContentFit :: (MonadIO m, IsPicture o) => o -> Gtk.Enums.ContentFit -> m ()
setPictureContentFit obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "content-fit" val

-- | Construct a `GValueConstruct` with valid value for the “@content-fit@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPictureContentFit :: (IsPicture o, MIO.MonadIO m) => Gtk.Enums.ContentFit -> m (GValueConstruct o)
constructPictureContentFit val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "content-fit" val

#if defined(ENABLE_OVERLOADING)
data PictureContentFitPropertyInfo
instance AttrInfo PictureContentFitPropertyInfo where
    type AttrAllowedOps PictureContentFitPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PictureContentFitPropertyInfo = IsPicture
    type AttrSetTypeConstraint PictureContentFitPropertyInfo = (~) Gtk.Enums.ContentFit
    type AttrTransferTypeConstraint PictureContentFitPropertyInfo = (~) Gtk.Enums.ContentFit
    type AttrTransferType PictureContentFitPropertyInfo = Gtk.Enums.ContentFit
    type AttrGetType PictureContentFitPropertyInfo = Gtk.Enums.ContentFit
    type AttrLabel PictureContentFitPropertyInfo = "content-fit"
    type AttrOrigin PictureContentFitPropertyInfo = Picture
    attrGet = getPictureContentFit
    attrSet = setPictureContentFit
    attrTransfer _ v = do
        return v
    attrConstruct = constructPictureContentFit
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.contentFit"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#g:attr:contentFit"
        })
#endif

-- VVV Prop "file"
   -- Type: TInterface (Name {namespace = "Gio", name = "File"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' picture #file
-- @
getPictureFile :: (MonadIO m, IsPicture o) => o -> m (Maybe Gio.File.File)
getPictureFile obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "file" Gio.File.File

-- | Set the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' picture [ #file 'Data.GI.Base.Attributes.:=' value ]
-- @
setPictureFile :: (MonadIO m, IsPicture o, Gio.File.IsFile a) => o -> a -> m ()
setPictureFile obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "file" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@file@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPictureFile :: (IsPicture o, MIO.MonadIO m, Gio.File.IsFile a) => a -> m (GValueConstruct o)
constructPictureFile val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "file" (P.Just val)

-- | Set the value of the “@file@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #file
-- @
clearPictureFile :: (MonadIO m, IsPicture o) => o -> m ()
clearPictureFile obj = liftIO $ B.Properties.setObjectPropertyObject obj "file" (Nothing :: Maybe Gio.File.File)

#if defined(ENABLE_OVERLOADING)
data PictureFilePropertyInfo
instance AttrInfo PictureFilePropertyInfo where
    type AttrAllowedOps PictureFilePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PictureFilePropertyInfo = IsPicture
    type AttrSetTypeConstraint PictureFilePropertyInfo = Gio.File.IsFile
    type AttrTransferTypeConstraint PictureFilePropertyInfo = Gio.File.IsFile
    type AttrTransferType PictureFilePropertyInfo = Gio.File.File
    type AttrGetType PictureFilePropertyInfo = (Maybe Gio.File.File)
    type AttrLabel PictureFilePropertyInfo = "file"
    type AttrOrigin PictureFilePropertyInfo = Picture
    attrGet = getPictureFile
    attrSet = setPictureFile
    attrTransfer _ v = do
        unsafeCastTo Gio.File.File v
    attrConstruct = constructPictureFile
    attrClear = clearPictureFile
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.file"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#g:attr:file"
        })
#endif

-- VVV Prop "keep-aspect-ratio"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@keep-aspect-ratio@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' picture #keepAspectRatio
-- @
getPictureKeepAspectRatio :: (MonadIO m, IsPicture o) => o -> m Bool
getPictureKeepAspectRatio obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "keep-aspect-ratio"

-- | Set the value of the “@keep-aspect-ratio@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' picture [ #keepAspectRatio 'Data.GI.Base.Attributes.:=' value ]
-- @
setPictureKeepAspectRatio :: (MonadIO m, IsPicture o) => o -> Bool -> m ()
setPictureKeepAspectRatio obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "keep-aspect-ratio" val

-- | Construct a `GValueConstruct` with valid value for the “@keep-aspect-ratio@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPictureKeepAspectRatio :: (IsPicture o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPictureKeepAspectRatio val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "keep-aspect-ratio" val

#if defined(ENABLE_OVERLOADING)
data PictureKeepAspectRatioPropertyInfo
instance AttrInfo PictureKeepAspectRatioPropertyInfo where
    type AttrAllowedOps PictureKeepAspectRatioPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PictureKeepAspectRatioPropertyInfo = IsPicture
    type AttrSetTypeConstraint PictureKeepAspectRatioPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PictureKeepAspectRatioPropertyInfo = (~) Bool
    type AttrTransferType PictureKeepAspectRatioPropertyInfo = Bool
    type AttrGetType PictureKeepAspectRatioPropertyInfo = Bool
    type AttrLabel PictureKeepAspectRatioPropertyInfo = "keep-aspect-ratio"
    type AttrOrigin PictureKeepAspectRatioPropertyInfo = Picture
    attrGet = getPictureKeepAspectRatio
    attrSet = setPictureKeepAspectRatio
    attrTransfer _ v = do
        return v
    attrConstruct = constructPictureKeepAspectRatio
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.keepAspectRatio"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#g:attr:keepAspectRatio"
        })
#endif

-- VVV Prop "paintable"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Paintable"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@paintable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' picture #paintable
-- @
getPicturePaintable :: (MonadIO m, IsPicture o) => o -> m (Maybe Gdk.Paintable.Paintable)
getPicturePaintable obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "paintable" Gdk.Paintable.Paintable

-- | Set the value of the “@paintable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' picture [ #paintable 'Data.GI.Base.Attributes.:=' value ]
-- @
setPicturePaintable :: (MonadIO m, IsPicture o, Gdk.Paintable.IsPaintable a) => o -> a -> m ()
setPicturePaintable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "paintable" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@paintable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPicturePaintable :: (IsPicture o, MIO.MonadIO m, Gdk.Paintable.IsPaintable a) => a -> m (GValueConstruct o)
constructPicturePaintable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "paintable" (P.Just val)

-- | Set the value of the “@paintable@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #paintable
-- @
clearPicturePaintable :: (MonadIO m, IsPicture o) => o -> m ()
clearPicturePaintable obj = liftIO $ B.Properties.setObjectPropertyObject obj "paintable" (Nothing :: Maybe Gdk.Paintable.Paintable)

#if defined(ENABLE_OVERLOADING)
data PicturePaintablePropertyInfo
instance AttrInfo PicturePaintablePropertyInfo where
    type AttrAllowedOps PicturePaintablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PicturePaintablePropertyInfo = IsPicture
    type AttrSetTypeConstraint PicturePaintablePropertyInfo = Gdk.Paintable.IsPaintable
    type AttrTransferTypeConstraint PicturePaintablePropertyInfo = Gdk.Paintable.IsPaintable
    type AttrTransferType PicturePaintablePropertyInfo = Gdk.Paintable.Paintable
    type AttrGetType PicturePaintablePropertyInfo = (Maybe Gdk.Paintable.Paintable)
    type AttrLabel PicturePaintablePropertyInfo = "paintable"
    type AttrOrigin PicturePaintablePropertyInfo = Picture
    attrGet = getPicturePaintable
    attrSet = setPicturePaintable
    attrTransfer _ v = do
        unsafeCastTo Gdk.Paintable.Paintable v
    attrConstruct = constructPicturePaintable
    attrClear = clearPicturePaintable
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.paintable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#g:attr:paintable"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Picture
type instance O.AttributeList Picture = PictureAttributeList
type PictureAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("alternativeText", PictureAlternativeTextPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canShrink", PictureCanShrinkPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("contentFit", PictureContentFitPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("file", PictureFilePropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("keepAspectRatio", PictureKeepAspectRatioPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("paintable", PicturePaintablePropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
pictureAlternativeText :: AttrLabelProxy "alternativeText"
pictureAlternativeText = AttrLabelProxy

pictureCanShrink :: AttrLabelProxy "canShrink"
pictureCanShrink = AttrLabelProxy

pictureContentFit :: AttrLabelProxy "contentFit"
pictureContentFit = AttrLabelProxy

pictureFile :: AttrLabelProxy "file"
pictureFile = AttrLabelProxy

pictureKeepAspectRatio :: AttrLabelProxy "keepAspectRatio"
pictureKeepAspectRatio = AttrLabelProxy

picturePaintable :: AttrLabelProxy "paintable"
picturePaintable = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Picture = PictureSignalList
type PictureSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Picture::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Picture" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_new" gtk_picture_new :: 
    IO (Ptr Picture)

-- | Creates a new empty @GtkPicture@ widget.
pictureNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Picture
    -- ^ __Returns:__ a newly created @GtkPicture@ widget.
pictureNew  = liftIO $ do
    result <- gtk_picture_new
    checkUnexpectedReturnNULL "pictureNew" result
    result' <- (newObject Picture) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Picture::new_for_file
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Picture" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_new_for_file" gtk_picture_new_for_file :: 
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO (Ptr Picture)

-- | Creates a new @GtkPicture@ displaying the given /@file@/.
-- 
-- If the file isn’t found or can’t be loaded, the resulting
-- @GtkPicture@ is empty.
-- 
-- If you need to detect failures to load the file, use
-- 'GI.Gdk.Objects.Texture.textureNewFromFile' to load the file yourself,
-- then create the @GtkPicture@ from the texture.
pictureNewForFile ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.File.IsFile a) =>
    Maybe (a)
    -- ^ /@file@/: a @GFile@
    -> m Picture
    -- ^ __Returns:__ a new @GtkPicture@
pictureNewForFile file = liftIO $ do
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    result <- gtk_picture_new_for_file maybeFile
    checkUnexpectedReturnNULL "pictureNewForFile" result
    result' <- (newObject Picture) result
    whenJust file touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Picture::new_for_filename
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a filename" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Picture" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_new_for_filename" gtk_picture_new_for_filename :: 
    CString ->                              -- filename : TBasicType TFileName
    IO (Ptr Picture)

-- | Creates a new @GtkPicture@ displaying the file /@filename@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Picture.pictureNewForFile'.
-- See that function for details.
pictureNewForFilename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@filename@/: a filename
    -> m Picture
    -- ^ __Returns:__ a new @GtkPicture@
pictureNewForFilename filename = liftIO $ do
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    result <- gtk_picture_new_for_filename maybeFilename
    checkUnexpectedReturnNULL "pictureNewForFilename" result
    result' <- (newObject Picture) result
    freeMem maybeFilename
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Picture::new_for_paintable
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "paintable"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Paintable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPaintable`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Picture" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_new_for_paintable" gtk_picture_new_for_paintable :: 
    Ptr Gdk.Paintable.Paintable ->          -- paintable : TInterface (Name {namespace = "Gdk", name = "Paintable"})
    IO (Ptr Picture)

-- | Creates a new @GtkPicture@ displaying /@paintable@/.
-- 
-- The @GtkPicture@ will track changes to the /@paintable@/ and update
-- its size and contents in response to it.
pictureNewForPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Paintable.IsPaintable a) =>
    Maybe (a)
    -- ^ /@paintable@/: a @GdkPaintable@
    -> m Picture
    -- ^ __Returns:__ a new @GtkPicture@
pictureNewForPaintable paintable = liftIO $ do
    maybePaintable <- case paintable of
        Nothing -> return FP.nullPtr
        Just jPaintable -> do
            jPaintable' <- unsafeManagedPtrCastPtr jPaintable
            return jPaintable'
    result <- gtk_picture_new_for_paintable maybePaintable
    checkUnexpectedReturnNULL "pictureNewForPaintable" result
    result' <- (newObject Picture) result
    whenJust paintable touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Picture::new_for_pixbuf
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbuf`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Picture" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_new_for_pixbuf" gtk_picture_new_for_pixbuf :: 
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    IO (Ptr Picture)

{-# DEPRECATED pictureNewForPixbuf ["(Since version 4.12)","Use 'GI.Gtk.Objects.Picture.pictureNewForPaintable' and","  'GI.Gdk.Objects.Texture.textureNewForPixbuf' instead"] #-}
-- | Creates a new @GtkPicture@ displaying /@pixbuf@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Picture.pictureNewForPaintable',
-- See that function for details.
-- 
-- The pixbuf must not be modified after passing it to this function.
pictureNewForPixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) =>
    Maybe (a)
    -- ^ /@pixbuf@/: a @GdkPixbuf@
    -> m Picture
    -- ^ __Returns:__ a new @GtkPicture@
pictureNewForPixbuf pixbuf = liftIO $ do
    maybePixbuf <- case pixbuf of
        Nothing -> return FP.nullPtr
        Just jPixbuf -> do
            jPixbuf' <- unsafeManagedPtrCastPtr jPixbuf
            return jPixbuf'
    result <- gtk_picture_new_for_pixbuf maybePixbuf
    checkUnexpectedReturnNULL "pictureNewForPixbuf" result
    result' <- (newObject Picture) result
    whenJust pixbuf touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Picture::new_for_resource
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "resource path to play back"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Picture" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_new_for_resource" gtk_picture_new_for_resource :: 
    CString ->                              -- resource_path : TBasicType TUTF8
    IO (Ptr Picture)

-- | Creates a new @GtkPicture@ displaying the resource at /@resourcePath@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Picture.pictureNewForFile'.
-- See that function for details.
pictureNewForResource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@resourcePath@/: resource path to play back
    -> m Picture
    -- ^ __Returns:__ a new @GtkPicture@
pictureNewForResource resourcePath = liftIO $ do
    maybeResourcePath <- case resourcePath of
        Nothing -> return FP.nullPtr
        Just jResourcePath -> do
            jResourcePath' <- textToCString jResourcePath
            return jResourcePath'
    result <- gtk_picture_new_for_resource maybeResourcePath
    checkUnexpectedReturnNULL "pictureNewForResource" result
    result' <- (newObject Picture) result
    freeMem maybeResourcePath
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Picture::get_alternative_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_get_alternative_text" gtk_picture_get_alternative_text :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    IO CString

-- | Gets the alternative textual description of the picture.
-- 
-- The returned string will be 'P.Nothing' if the picture cannot be described textually.
pictureGetAlternativeText ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the alternative textual description of /@self@/.
pictureGetAlternativeText self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_picture_get_alternative_text self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PictureGetAlternativeTextMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsPicture a) => O.OverloadedMethod PictureGetAlternativeTextMethodInfo a signature where
    overloadedMethod = pictureGetAlternativeText

instance O.OverloadedMethodInfo PictureGetAlternativeTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureGetAlternativeText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureGetAlternativeText"
        })


#endif

-- method Picture::get_can_shrink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_get_can_shrink" gtk_picture_get_can_shrink :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    IO CInt

-- | Returns whether the @GtkPicture@ respects its contents size.
pictureGetCanShrink ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the picture can be made smaller than its contents
pictureGetCanShrink self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_picture_get_can_shrink self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data PictureGetCanShrinkMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPicture a) => O.OverloadedMethod PictureGetCanShrinkMethodInfo a signature where
    overloadedMethod = pictureGetCanShrink

instance O.OverloadedMethodInfo PictureGetCanShrinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureGetCanShrink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureGetCanShrink"
        })


#endif

-- method Picture::get_content_fit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ContentFit" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_get_content_fit" gtk_picture_get_content_fit :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    IO CUInt

-- | Returns the fit mode for the content of the @GtkPicture@.
-- 
-- See t'GI.Gtk.Enums.ContentFit' for details.
-- 
-- /Since: 4.8/
pictureGetContentFit ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> m Gtk.Enums.ContentFit
    -- ^ __Returns:__ the content fit mode
pictureGetContentFit self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_picture_get_content_fit self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data PictureGetContentFitMethodInfo
instance (signature ~ (m Gtk.Enums.ContentFit), MonadIO m, IsPicture a) => O.OverloadedMethod PictureGetContentFitMethodInfo a signature where
    overloadedMethod = pictureGetContentFit

instance O.OverloadedMethodInfo PictureGetContentFitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureGetContentFit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureGetContentFit"
        })


#endif

-- method Picture::get_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_get_file" gtk_picture_get_file :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    IO (Ptr Gio.File.File)

-- | Gets the @GFile@ currently displayed if /@self@/ is displaying a file.
-- 
-- If /@self@/ is not displaying a file, for example when
-- 'GI.Gtk.Objects.Picture.pictureSetPaintable' was used, then 'P.Nothing' is returned.
pictureGetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> m (Maybe Gio.File.File)
    -- ^ __Returns:__ The @GFile@ displayed by /@self@/.
pictureGetFile self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_picture_get_file self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.File.File) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PictureGetFileMethodInfo
instance (signature ~ (m (Maybe Gio.File.File)), MonadIO m, IsPicture a) => O.OverloadedMethod PictureGetFileMethodInfo a signature where
    overloadedMethod = pictureGetFile

instance O.OverloadedMethodInfo PictureGetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureGetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureGetFile"
        })


#endif

-- method Picture::get_keep_aspect_ratio
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_get_keep_aspect_ratio" gtk_picture_get_keep_aspect_ratio :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    IO CInt

{-# DEPRECATED pictureGetKeepAspectRatio ["(Since version 4.8)","Use 'GI.Gtk.Objects.Picture.pictureGetContentFit' instead. This will","  now return @FALSE@ only if [Picture:contentFit](\"GI.Gtk.Objects.Picture#g:attr:contentFit\") is","  @GTK_CONTENT_FIT_FILL@. Returns @TRUE@ otherwise."] #-}
-- | Returns whether the @GtkPicture@ preserves its contents aspect ratio.
pictureGetKeepAspectRatio ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the self tries to keep the contents\' aspect ratio
pictureGetKeepAspectRatio self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_picture_get_keep_aspect_ratio self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data PictureGetKeepAspectRatioMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPicture a) => O.OverloadedMethod PictureGetKeepAspectRatioMethodInfo a signature where
    overloadedMethod = pictureGetKeepAspectRatio

instance O.OverloadedMethodInfo PictureGetKeepAspectRatioMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureGetKeepAspectRatio",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureGetKeepAspectRatio"
        })


#endif

-- method Picture::get_paintable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Paintable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_get_paintable" gtk_picture_get_paintable :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    IO (Ptr Gdk.Paintable.Paintable)

-- | Gets the @GdkPaintable@ being displayed by the @GtkPicture@.
pictureGetPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> m (Maybe Gdk.Paintable.Paintable)
    -- ^ __Returns:__ the displayed paintable
pictureGetPaintable self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_picture_get_paintable self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Paintable.Paintable) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PictureGetPaintableMethodInfo
instance (signature ~ (m (Maybe Gdk.Paintable.Paintable)), MonadIO m, IsPicture a) => O.OverloadedMethod PictureGetPaintableMethodInfo a signature where
    overloadedMethod = pictureGetPaintable

instance O.OverloadedMethodInfo PictureGetPaintableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureGetPaintable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureGetPaintable"
        })


#endif

-- method Picture::set_alternative_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "alternative_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a textual description of the contents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_alternative_text" gtk_picture_set_alternative_text :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    CString ->                              -- alternative_text : TBasicType TUTF8
    IO ()

-- | Sets an alternative textual description for the picture contents.
-- 
-- It is equivalent to the \"alt\" attribute for images on websites.
-- 
-- This text will be made available to accessibility tools.
-- 
-- If the picture cannot be described textually, set this property to 'P.Nothing'.
pictureSetAlternativeText ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Maybe (T.Text)
    -- ^ /@alternativeText@/: a textual description of the contents
    -> m ()
pictureSetAlternativeText self alternativeText = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeAlternativeText <- case alternativeText of
        Nothing -> return FP.nullPtr
        Just jAlternativeText -> do
            jAlternativeText' <- textToCString jAlternativeText
            return jAlternativeText'
    gtk_picture_set_alternative_text self' maybeAlternativeText
    touchManagedPtr self
    freeMem maybeAlternativeText
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetAlternativeTextMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsPicture a) => O.OverloadedMethod PictureSetAlternativeTextMethodInfo a signature where
    overloadedMethod = pictureSetAlternativeText

instance O.OverloadedMethodInfo PictureSetAlternativeTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetAlternativeText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetAlternativeText"
        })


#endif

-- method Picture::set_can_shrink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "can_shrink"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "if @self can be made smaller than its contents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_can_shrink" gtk_picture_set_can_shrink :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    CInt ->                                 -- can_shrink : TBasicType TBoolean
    IO ()

-- | If set to 'P.True', the /@self@/ can be made smaller than its contents.
-- 
-- The contents will then be scaled down when rendering.
-- 
-- If you want to still force a minimum size manually, consider using
-- 'GI.Gtk.Objects.Widget.widgetSetSizeRequest'.
-- 
-- Also of note is that a similar function for growing does not exist
-- because the grow behavior can be controlled via
-- 'GI.Gtk.Objects.Widget.widgetSetHalign' and 'GI.Gtk.Objects.Widget.widgetSetValign'.
pictureSetCanShrink ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Bool
    -- ^ /@canShrink@/: if /@self@/ can be made smaller than its contents
    -> m ()
pictureSetCanShrink self canShrink = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let canShrink' = (P.fromIntegral . P.fromEnum) canShrink
    gtk_picture_set_can_shrink self' canShrink'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetCanShrinkMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPicture a) => O.OverloadedMethod PictureSetCanShrinkMethodInfo a signature where
    overloadedMethod = pictureSetCanShrink

instance O.OverloadedMethodInfo PictureSetCanShrinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetCanShrink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetCanShrink"
        })


#endif

-- method Picture::set_content_fit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "content_fit"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ContentFit" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the content fit mode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_content_fit" gtk_picture_set_content_fit :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    CUInt ->                                -- content_fit : TInterface (Name {namespace = "Gtk", name = "ContentFit"})
    IO ()

-- | Sets how the content should be resized to fit the @GtkPicture@.
-- 
-- See t'GI.Gtk.Enums.ContentFit' for details.
-- 
-- /Since: 4.8/
pictureSetContentFit ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Gtk.Enums.ContentFit
    -- ^ /@contentFit@/: the content fit mode
    -> m ()
pictureSetContentFit self contentFit = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let contentFit' = (fromIntegral . fromEnum) contentFit
    gtk_picture_set_content_fit self' contentFit'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetContentFitMethodInfo
instance (signature ~ (Gtk.Enums.ContentFit -> m ()), MonadIO m, IsPicture a) => O.OverloadedMethod PictureSetContentFitMethodInfo a signature where
    overloadedMethod = pictureSetContentFit

instance O.OverloadedMethodInfo PictureSetContentFitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetContentFit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetContentFit"
        })


#endif

-- method Picture::set_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_file" gtk_picture_set_file :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO ()

-- | Makes /@self@/ load and display /@file@/.
-- 
-- See 'GI.Gtk.Objects.Picture.pictureNewForFile' for details.
pictureSetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a, Gio.File.IsFile b) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Maybe (b)
    -- ^ /@file@/: a @GFile@
    -> m ()
pictureSetFile self file = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    gtk_picture_set_file self' maybeFile
    touchManagedPtr self
    whenJust file touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetFileMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPicture a, Gio.File.IsFile b) => O.OverloadedMethod PictureSetFileMethodInfo a signature where
    overloadedMethod = pictureSetFile

instance O.OverloadedMethodInfo PictureSetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetFile"
        })


#endif

-- method Picture::set_filename
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the filename to play"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_filename" gtk_picture_set_filename :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    CString ->                              -- filename : TBasicType TFileName
    IO ()

-- | Makes /@self@/ load and display the given /@filename@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Picture.pictureSetFile'.
pictureSetFilename ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Maybe ([Char])
    -- ^ /@filename@/: the filename to play
    -> m ()
pictureSetFilename self filename = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    gtk_picture_set_filename self' maybeFilename
    touchManagedPtr self
    freeMem maybeFilename
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetFilenameMethodInfo
instance (signature ~ (Maybe ([Char]) -> m ()), MonadIO m, IsPicture a) => O.OverloadedMethod PictureSetFilenameMethodInfo a signature where
    overloadedMethod = pictureSetFilename

instance O.OverloadedMethodInfo PictureSetFilenameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetFilename",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetFilename"
        })


#endif

-- method Picture::set_keep_aspect_ratio
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keep_aspect_ratio"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to keep aspect ratio"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_keep_aspect_ratio" gtk_picture_set_keep_aspect_ratio :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    CInt ->                                 -- keep_aspect_ratio : TBasicType TBoolean
    IO ()

{-# DEPRECATED pictureSetKeepAspectRatio ["(Since version 4.8)","Use 'GI.Gtk.Objects.Picture.pictureSetContentFit' instead. If still","  used, this method will always set the [Picture:contentFit](\"GI.Gtk.Objects.Picture#g:attr:contentFit\")","  property to @GTK_CONTENT_FIT_CONTAIN@ if /@keepAspectRatio@/ is true,","  otherwise it will set it to @GTK_CONTENT_FIT_FILL@."] #-}
-- | If set to 'P.True', the /@self@/ will render its contents according to
-- their aspect ratio.
-- 
-- That means that empty space may show up at the top\/bottom or
-- left\/right of /@self@/.
-- 
-- If set to 'P.False' or if the contents provide no aspect ratio,
-- the contents will be stretched over the picture\'s whole area.
pictureSetKeepAspectRatio ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Bool
    -- ^ /@keepAspectRatio@/: whether to keep aspect ratio
    -> m ()
pictureSetKeepAspectRatio self keepAspectRatio = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let keepAspectRatio' = (P.fromIntegral . P.fromEnum) keepAspectRatio
    gtk_picture_set_keep_aspect_ratio self' keepAspectRatio'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetKeepAspectRatioMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPicture a) => O.OverloadedMethod PictureSetKeepAspectRatioMethodInfo a signature where
    overloadedMethod = pictureSetKeepAspectRatio

instance O.OverloadedMethodInfo PictureSetKeepAspectRatioMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetKeepAspectRatio",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetKeepAspectRatio"
        })


#endif

-- method Picture::set_paintable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paintable"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Paintable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPaintable`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_paintable" gtk_picture_set_paintable :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    Ptr Gdk.Paintable.Paintable ->          -- paintable : TInterface (Name {namespace = "Gdk", name = "Paintable"})
    IO ()

-- | Makes /@self@/ display the given /@paintable@/.
-- 
-- If /@paintable@/ is 'P.Nothing', nothing will be displayed.
-- 
-- See 'GI.Gtk.Objects.Picture.pictureNewForPaintable' for details.
pictureSetPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a, Gdk.Paintable.IsPaintable b) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Maybe (b)
    -- ^ /@paintable@/: a @GdkPaintable@
    -> m ()
pictureSetPaintable self paintable = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybePaintable <- case paintable of
        Nothing -> return FP.nullPtr
        Just jPaintable -> do
            jPaintable' <- unsafeManagedPtrCastPtr jPaintable
            return jPaintable'
    gtk_picture_set_paintable self' maybePaintable
    touchManagedPtr self
    whenJust paintable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetPaintableMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPicture a, Gdk.Paintable.IsPaintable b) => O.OverloadedMethod PictureSetPaintableMethodInfo a signature where
    overloadedMethod = pictureSetPaintable

instance O.OverloadedMethodInfo PictureSetPaintableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetPaintable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetPaintable"
        })


#endif

-- method Picture::set_pixbuf
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbuf`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_pixbuf" gtk_picture_set_pixbuf :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    IO ()

{-# DEPRECATED pictureSetPixbuf ["(Since version 4.12)","Use 'GI.Gtk.Objects.Picture.pictureSetPaintable' instead"] #-}
-- | Sets a @GtkPicture@ to show a @GdkPixbuf@.
-- 
-- See 'GI.Gtk.Objects.Picture.pictureNewForPixbuf' for details.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Picture.pictureSetPaintable'.
pictureSetPixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a, GdkPixbuf.Pixbuf.IsPixbuf b) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Maybe (b)
    -- ^ /@pixbuf@/: a @GdkPixbuf@
    -> m ()
pictureSetPixbuf self pixbuf = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybePixbuf <- case pixbuf of
        Nothing -> return FP.nullPtr
        Just jPixbuf -> do
            jPixbuf' <- unsafeManagedPtrCastPtr jPixbuf
            return jPixbuf'
    gtk_picture_set_pixbuf self' maybePixbuf
    touchManagedPtr self
    whenJust pixbuf touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetPixbufMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPicture a, GdkPixbuf.Pixbuf.IsPixbuf b) => O.OverloadedMethod PictureSetPixbufMethodInfo a signature where
    overloadedMethod = pictureSetPixbuf

instance O.OverloadedMethodInfo PictureSetPixbufMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetPixbuf",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetPixbuf"
        })


#endif

-- method Picture::set_resource
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Picture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPicture`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the resource to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_picture_set_resource" gtk_picture_set_resource :: 
    Ptr Picture ->                          -- self : TInterface (Name {namespace = "Gtk", name = "Picture"})
    CString ->                              -- resource_path : TBasicType TUTF8
    IO ()

-- | Makes /@self@/ load and display the resource at the given
-- /@resourcePath@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Picture.pictureSetFile'.
pictureSetResource ::
    (B.CallStack.HasCallStack, MonadIO m, IsPicture a) =>
    a
    -- ^ /@self@/: a @GtkPicture@
    -> Maybe (T.Text)
    -- ^ /@resourcePath@/: the resource to set
    -> m ()
pictureSetResource self resourcePath = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeResourcePath <- case resourcePath of
        Nothing -> return FP.nullPtr
        Just jResourcePath -> do
            jResourcePath' <- textToCString jResourcePath
            return jResourcePath'
    gtk_picture_set_resource self' maybeResourcePath
    touchManagedPtr self
    freeMem maybeResourcePath
    return ()

#if defined(ENABLE_OVERLOADING)
data PictureSetResourceMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsPicture a) => O.OverloadedMethod PictureSetResourceMethodInfo a signature where
    overloadedMethod = pictureSetResource

instance O.OverloadedMethodInfo PictureSetResourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Picture.pictureSetResource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Picture.html#v:pictureSetResource"
        })


#endif


