{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkEntryBuffer@ that locks the underlying memory to prevent it
-- from being swapped to disk.
-- 
-- @GtkPasswordEntry@ uses a @GtkPasswordEntryBuffer@.
-- 
-- /Since: 4.4/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.PasswordEntryBuffer
    ( 

-- * Exported types
    PasswordEntryBuffer(..)                 ,
    IsPasswordEntryBuffer                   ,
    toPasswordEntryBuffer                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [deleteText]("GI.Gtk.Objects.EntryBuffer#g:method:deleteText"), [emitDeletedText]("GI.Gtk.Objects.EntryBuffer#g:method:emitDeletedText"), [emitInsertedText]("GI.Gtk.Objects.EntryBuffer#g:method:emitInsertedText"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [insertText]("GI.Gtk.Objects.EntryBuffer#g:method:insertText"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBytes]("GI.Gtk.Objects.EntryBuffer#g:method:getBytes"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLength]("GI.Gtk.Objects.EntryBuffer#g:method:getLength"), [getMaxLength]("GI.Gtk.Objects.EntryBuffer#g:method:getMaxLength"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getText]("GI.Gtk.Objects.EntryBuffer#g:method:getText").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setMaxLength]("GI.Gtk.Objects.EntryBuffer#g:method:setMaxLength"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setText]("GI.Gtk.Objects.EntryBuffer#g:method:setText").

#if defined(ENABLE_OVERLOADING)
    ResolvePasswordEntryBufferMethod        ,
#endif

-- ** new #method:new#

    passwordEntryBufferNew                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.EntryBuffer as Gtk.EntryBuffer

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.EntryBuffer as Gtk.EntryBuffer

#endif

-- | Memory-managed wrapper type.
newtype PasswordEntryBuffer = PasswordEntryBuffer (SP.ManagedPtr PasswordEntryBuffer)
    deriving (Eq)

instance SP.ManagedPtrNewtype PasswordEntryBuffer where
    toManagedPtr (PasswordEntryBuffer p) = p

foreign import ccall "gtk_password_entry_buffer_get_type"
    c_gtk_password_entry_buffer_get_type :: IO B.Types.GType

instance B.Types.TypedObject PasswordEntryBuffer where
    glibType = c_gtk_password_entry_buffer_get_type

instance B.Types.GObject PasswordEntryBuffer

-- | Type class for types which can be safely cast to `PasswordEntryBuffer`, for instance with `toPasswordEntryBuffer`.
class (SP.GObject o, O.IsDescendantOf PasswordEntryBuffer o) => IsPasswordEntryBuffer o
instance (SP.GObject o, O.IsDescendantOf PasswordEntryBuffer o) => IsPasswordEntryBuffer o

instance O.HasParentTypes PasswordEntryBuffer
type instance O.ParentTypes PasswordEntryBuffer = '[Gtk.EntryBuffer.EntryBuffer, GObject.Object.Object]

-- | Cast to `PasswordEntryBuffer`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPasswordEntryBuffer :: (MIO.MonadIO m, IsPasswordEntryBuffer o) => o -> m PasswordEntryBuffer
toPasswordEntryBuffer = MIO.liftIO . B.ManagedPtr.unsafeCastTo PasswordEntryBuffer

-- | Convert 'PasswordEntryBuffer' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PasswordEntryBuffer) where
    gvalueGType_ = c_gtk_password_entry_buffer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PasswordEntryBuffer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PasswordEntryBuffer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PasswordEntryBuffer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePasswordEntryBufferMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePasswordEntryBufferMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePasswordEntryBufferMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePasswordEntryBufferMethod "deleteText" o = Gtk.EntryBuffer.EntryBufferDeleteTextMethodInfo
    ResolvePasswordEntryBufferMethod "emitDeletedText" o = Gtk.EntryBuffer.EntryBufferEmitDeletedTextMethodInfo
    ResolvePasswordEntryBufferMethod "emitInsertedText" o = Gtk.EntryBuffer.EntryBufferEmitInsertedTextMethodInfo
    ResolvePasswordEntryBufferMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePasswordEntryBufferMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePasswordEntryBufferMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePasswordEntryBufferMethod "insertText" o = Gtk.EntryBuffer.EntryBufferInsertTextMethodInfo
    ResolvePasswordEntryBufferMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePasswordEntryBufferMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePasswordEntryBufferMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePasswordEntryBufferMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePasswordEntryBufferMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePasswordEntryBufferMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePasswordEntryBufferMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePasswordEntryBufferMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePasswordEntryBufferMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePasswordEntryBufferMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePasswordEntryBufferMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePasswordEntryBufferMethod "getBytes" o = Gtk.EntryBuffer.EntryBufferGetBytesMethodInfo
    ResolvePasswordEntryBufferMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePasswordEntryBufferMethod "getLength" o = Gtk.EntryBuffer.EntryBufferGetLengthMethodInfo
    ResolvePasswordEntryBufferMethod "getMaxLength" o = Gtk.EntryBuffer.EntryBufferGetMaxLengthMethodInfo
    ResolvePasswordEntryBufferMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePasswordEntryBufferMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePasswordEntryBufferMethod "getText" o = Gtk.EntryBuffer.EntryBufferGetTextMethodInfo
    ResolvePasswordEntryBufferMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePasswordEntryBufferMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePasswordEntryBufferMethod "setMaxLength" o = Gtk.EntryBuffer.EntryBufferSetMaxLengthMethodInfo
    ResolvePasswordEntryBufferMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePasswordEntryBufferMethod "setText" o = Gtk.EntryBuffer.EntryBufferSetTextMethodInfo
    ResolvePasswordEntryBufferMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePasswordEntryBufferMethod t PasswordEntryBuffer, O.OverloadedMethod info PasswordEntryBuffer p) => OL.IsLabel t (PasswordEntryBuffer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePasswordEntryBufferMethod t PasswordEntryBuffer, O.OverloadedMethod info PasswordEntryBuffer p, R.HasField t PasswordEntryBuffer p) => R.HasField t PasswordEntryBuffer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePasswordEntryBufferMethod t PasswordEntryBuffer, O.OverloadedMethodInfo info PasswordEntryBuffer) => OL.IsLabel t (O.MethodProxy info PasswordEntryBuffer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PasswordEntryBuffer
type instance O.AttributeList PasswordEntryBuffer = PasswordEntryBufferAttributeList
type PasswordEntryBufferAttributeList = ('[ '("length", Gtk.EntryBuffer.EntryBufferLengthPropertyInfo), '("maxLength", Gtk.EntryBuffer.EntryBufferMaxLengthPropertyInfo), '("text", Gtk.EntryBuffer.EntryBufferTextPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PasswordEntryBuffer = PasswordEntryBufferSignalList
type PasswordEntryBufferSignalList = ('[ '("deletedText", Gtk.EntryBuffer.EntryBufferDeletedTextSignalInfo), '("insertedText", Gtk.EntryBuffer.EntryBufferInsertedTextSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PasswordEntryBuffer::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "PasswordEntryBuffer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_password_entry_buffer_new" gtk_password_entry_buffer_new :: 
    IO (Ptr PasswordEntryBuffer)

-- | Creates a new @GtkEntryBuffer@ using secure memory allocations.
passwordEntryBufferNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m PasswordEntryBuffer
    -- ^ __Returns:__ the newly created instance
passwordEntryBufferNew  = liftIO $ do
    result <- gtk_password_entry_buffer_new
    checkUnexpectedReturnNULL "passwordEntryBufferNew" result
    result' <- (wrapObject PasswordEntryBuffer) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


