{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Presents a page setup dialog for platforms which don’t provide
-- a native page setup dialog, like Unix.
-- 
-- \<picture>
--   \<source srcset=\"pagesetupdialog-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkPageSetupUnixDialog\" src=\"pagesetupdialog.png\">
-- \<\/picture>
-- 
-- It can be used very much like any other GTK dialog, at the
-- cost of the portability offered by the high-level printing
-- API in t'GI.Gtk.Objects.PrintOperation.PrintOperation'.
-- 
-- == CSS nodes
-- 
-- @GtkPageSetupUnixDialog@ has a single CSS node with the name @window@ and
-- style class @.pagesetup@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.PageSetupUnixDialog
    ( 

-- * Exported types
    PageSetupUnixDialog(..)                 ,
    IsPageSetupUnixDialog                   ,
    toPageSetupUnixDialog                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addActionWidget]("GI.Gtk.Objects.Dialog#g:method:addActionWidget"), [addButton]("GI.Gtk.Objects.Dialog#g:method:addButton"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [close]("GI.Gtk.Objects.Window#g:method:close"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [destroy]("GI.Gtk.Objects.Window#g:method:destroy"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [fullscreen]("GI.Gtk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gtk.Objects.Window#g:method:fullscreenOnMonitor"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasGroup]("GI.Gtk.Objects.Window#g:method:hasGroup"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isActive]("GI.Gtk.Objects.Window#g:method:isActive"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isFullscreen]("GI.Gtk.Objects.Window#g:method:isFullscreen"), [isMaximized]("GI.Gtk.Objects.Window#g:method:isMaximized"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isSuspended]("GI.Gtk.Objects.Window#g:method:isSuspended"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [maximize]("GI.Gtk.Objects.Window#g:method:maximize"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [minimize]("GI.Gtk.Objects.Window#g:method:minimize"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [present]("GI.Gtk.Objects.Window#g:method:present"), [presentWithTime]("GI.Gtk.Objects.Window#g:method:presentWithTime"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [response]("GI.Gtk.Objects.Dialog#g:method:response"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unfullscreen]("GI.Gtk.Objects.Window#g:method:unfullscreen"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmaximize]("GI.Gtk.Objects.Window#g:method:unmaximize"), [unminimize]("GI.Gtk.Objects.Window#g:method:unminimize"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getApplication]("GI.Gtk.Objects.Window#g:method:getApplication"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Window#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getContentArea]("GI.Gtk.Objects.Dialog#g:method:getContentArea"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorated]("GI.Gtk.Objects.Window#g:method:getDecorated"), [getDefaultSize]("GI.Gtk.Objects.Window#g:method:getDefaultSize"), [getDefaultWidget]("GI.Gtk.Objects.Window#g:method:getDefaultWidget"), [getDeletable]("GI.Gtk.Objects.Window#g:method:getDeletable"), [getDestroyWithParent]("GI.Gtk.Objects.Window#g:method:getDestroyWithParent"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Objects.Window#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusVisible]("GI.Gtk.Objects.Window#g:method:getFocusVisible"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGroup]("GI.Gtk.Objects.Window#g:method:getGroup"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:getHandleMenubarAccel"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeaderBar]("GI.Gtk.Objects.Dialog#g:method:getHeaderBar"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideOnClose]("GI.Gtk.Objects.Window#g:method:getHideOnClose"), [getIconName]("GI.Gtk.Objects.Window#g:method:getIconName"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:getMnemonicsVisible"), [getModal]("GI.Gtk.Objects.Window#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPageSetup]("GI.Gtk.Objects.PageSetupUnixDialog#g:method:getPageSetup"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getPrintSettings]("GI.Gtk.Objects.PageSetupUnixDialog#g:method:getPrintSettings"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizable]("GI.Gtk.Objects.Window#g:method:getResizable"), [getResponseForWidget]("GI.Gtk.Objects.Dialog#g:method:getResponseForWidget"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.Window#g:method:getTitle"), [getTitlebar]("GI.Gtk.Objects.Window#g:method:getTitlebar"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransientFor]("GI.Gtk.Objects.Window#g:method:getTransientFor"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidgetForResponse]("GI.Gtk.Objects.Dialog#g:method:getWidgetForResponse"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setApplication]("GI.Gtk.Objects.Window#g:method:setApplication"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Window#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gtk.Objects.Window#g:method:setDecorated"), [setDefaultResponse]("GI.Gtk.Objects.Dialog#g:method:setDefaultResponse"), [setDefaultSize]("GI.Gtk.Objects.Window#g:method:setDefaultSize"), [setDefaultWidget]("GI.Gtk.Objects.Window#g:method:setDefaultWidget"), [setDeletable]("GI.Gtk.Objects.Window#g:method:setDeletable"), [setDestroyWithParent]("GI.Gtk.Objects.Window#g:method:setDestroyWithParent"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDisplay]("GI.Gtk.Objects.Window#g:method:setDisplay"), [setFocus]("GI.Gtk.Objects.Window#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusVisible]("GI.Gtk.Objects.Window#g:method:setFocusVisible"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:setHandleMenubarAccel"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideOnClose]("GI.Gtk.Objects.Window#g:method:setHideOnClose"), [setIconName]("GI.Gtk.Objects.Window#g:method:setIconName"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:setMnemonicsVisible"), [setModal]("GI.Gtk.Objects.Window#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setPageSetup]("GI.Gtk.Objects.PageSetupUnixDialog#g:method:setPageSetup"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPrintSettings]("GI.Gtk.Objects.PageSetupUnixDialog#g:method:setPrintSettings"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizable]("GI.Gtk.Objects.Window#g:method:setResizable"), [setResponseSensitive]("GI.Gtk.Objects.Dialog#g:method:setResponseSensitive"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartupId]("GI.Gtk.Objects.Window#g:method:setStartupId"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTitle]("GI.Gtk.Objects.Window#g:method:setTitle"), [setTitlebar]("GI.Gtk.Objects.Window#g:method:setTitlebar"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransientFor]("GI.Gtk.Objects.Window#g:method:setTransientFor"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolvePageSetupUnixDialogMethod        ,
#endif

-- ** getPageSetup #method:getPageSetup#

#if defined(ENABLE_OVERLOADING)
    PageSetupUnixDialogGetPageSetupMethodInfo,
#endif
    pageSetupUnixDialogGetPageSetup         ,


-- ** getPrintSettings #method:getPrintSettings#

#if defined(ENABLE_OVERLOADING)
    PageSetupUnixDialogGetPrintSettingsMethodInfo,
#endif
    pageSetupUnixDialogGetPrintSettings     ,


-- ** new #method:new#

    pageSetupUnixDialogNew                  ,


-- ** setPageSetup #method:setPageSetup#

#if defined(ENABLE_OVERLOADING)
    PageSetupUnixDialogSetPageSetupMethodInfo,
#endif
    pageSetupUnixDialogSetPageSetup         ,


-- ** setPrintSettings #method:setPrintSettings#

#if defined(ENABLE_OVERLOADING)
    PageSetupUnixDialogSetPrintSettingsMethodInfo,
#endif
    pageSetupUnixDialogSetPrintSettings     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.KeyFile as GLib.KeyFile
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.Box as Gtk.Box
import {-# SOURCE #-} qualified GI.Gtk.Objects.Dialog as Gtk.Dialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.HeaderBar as Gtk.HeaderBar
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.PageRange as Gtk.PageRange
import {-# SOURCE #-} qualified GI.Gtk.Structs.PaperSize as Gtk.PaperSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Dialog as Gtk.Dialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype PageSetupUnixDialog = PageSetupUnixDialog (SP.ManagedPtr PageSetupUnixDialog)
    deriving (Eq)

instance SP.ManagedPtrNewtype PageSetupUnixDialog where
    toManagedPtr (PageSetupUnixDialog p) = p

foreign import ccall "gtk_page_setup_unix_dialog_get_type"
    c_gtk_page_setup_unix_dialog_get_type :: IO B.Types.GType

instance B.Types.TypedObject PageSetupUnixDialog where
    glibType = c_gtk_page_setup_unix_dialog_get_type

instance B.Types.GObject PageSetupUnixDialog

-- | Type class for types which can be safely cast to `PageSetupUnixDialog`, for instance with `toPageSetupUnixDialog`.
class (SP.GObject o, O.IsDescendantOf PageSetupUnixDialog o) => IsPageSetupUnixDialog o
instance (SP.GObject o, O.IsDescendantOf PageSetupUnixDialog o) => IsPageSetupUnixDialog o

instance O.HasParentTypes PageSetupUnixDialog
type instance O.ParentTypes PageSetupUnixDialog = '[Gtk.Dialog.Dialog, Gtk.Window.Window, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to `PageSetupUnixDialog`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPageSetupUnixDialog :: (MIO.MonadIO m, IsPageSetupUnixDialog o) => o -> m PageSetupUnixDialog
toPageSetupUnixDialog = MIO.liftIO . B.ManagedPtr.unsafeCastTo PageSetupUnixDialog

-- | Convert 'PageSetupUnixDialog' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PageSetupUnixDialog) where
    gvalueGType_ = c_gtk_page_setup_unix_dialog_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PageSetupUnixDialog)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PageSetupUnixDialog)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PageSetupUnixDialog ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePageSetupUnixDialogMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePageSetupUnixDialogMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolvePageSetupUnixDialogMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolvePageSetupUnixDialogMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolvePageSetupUnixDialogMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolvePageSetupUnixDialogMethod "addActionWidget" o = Gtk.Dialog.DialogAddActionWidgetMethodInfo
    ResolvePageSetupUnixDialogMethod "addButton" o = Gtk.Dialog.DialogAddButtonMethodInfo
    ResolvePageSetupUnixDialogMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolvePageSetupUnixDialogMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolvePageSetupUnixDialogMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolvePageSetupUnixDialogMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolvePageSetupUnixDialogMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolvePageSetupUnixDialogMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolvePageSetupUnixDialogMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePageSetupUnixDialogMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePageSetupUnixDialogMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "close" o = Gtk.Window.WindowCloseMethodInfo
    ResolvePageSetupUnixDialogMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolvePageSetupUnixDialogMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolvePageSetupUnixDialogMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolvePageSetupUnixDialogMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolvePageSetupUnixDialogMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolvePageSetupUnixDialogMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolvePageSetupUnixDialogMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolvePageSetupUnixDialogMethod "destroy" o = Gtk.Window.WindowDestroyMethodInfo
    ResolvePageSetupUnixDialogMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolvePageSetupUnixDialogMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolvePageSetupUnixDialogMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolvePageSetupUnixDialogMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePageSetupUnixDialogMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePageSetupUnixDialogMethod "fullscreen" o = Gtk.Window.WindowFullscreenMethodInfo
    ResolvePageSetupUnixDialogMethod "fullscreenOnMonitor" o = Gtk.Window.WindowFullscreenOnMonitorMethodInfo
    ResolvePageSetupUnixDialogMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePageSetupUnixDialogMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolvePageSetupUnixDialogMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolvePageSetupUnixDialogMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "hasGroup" o = Gtk.Window.WindowHasGroupMethodInfo
    ResolvePageSetupUnixDialogMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolvePageSetupUnixDialogMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolvePageSetupUnixDialogMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolvePageSetupUnixDialogMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolvePageSetupUnixDialogMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolvePageSetupUnixDialogMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolvePageSetupUnixDialogMethod "isActive" o = Gtk.Window.WindowIsActiveMethodInfo
    ResolvePageSetupUnixDialogMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolvePageSetupUnixDialogMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolvePageSetupUnixDialogMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePageSetupUnixDialogMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "isFullscreen" o = Gtk.Window.WindowIsFullscreenMethodInfo
    ResolvePageSetupUnixDialogMethod "isMaximized" o = Gtk.Window.WindowIsMaximizedMethodInfo
    ResolvePageSetupUnixDialogMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolvePageSetupUnixDialogMethod "isSuspended" o = Gtk.Window.WindowIsSuspendedMethodInfo
    ResolvePageSetupUnixDialogMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolvePageSetupUnixDialogMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolvePageSetupUnixDialogMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolvePageSetupUnixDialogMethod "maximize" o = Gtk.Window.WindowMaximizeMethodInfo
    ResolvePageSetupUnixDialogMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolvePageSetupUnixDialogMethod "minimize" o = Gtk.Window.WindowMinimizeMethodInfo
    ResolvePageSetupUnixDialogMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolvePageSetupUnixDialogMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePageSetupUnixDialogMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePageSetupUnixDialogMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolvePageSetupUnixDialogMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolvePageSetupUnixDialogMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolvePageSetupUnixDialogMethod "present" o = Gtk.Window.WindowPresentMethodInfo
    ResolvePageSetupUnixDialogMethod "presentWithTime" o = Gtk.Window.WindowPresentWithTimeMethodInfo
    ResolvePageSetupUnixDialogMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolvePageSetupUnixDialogMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolvePageSetupUnixDialogMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolvePageSetupUnixDialogMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolvePageSetupUnixDialogMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePageSetupUnixDialogMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePageSetupUnixDialogMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolvePageSetupUnixDialogMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolvePageSetupUnixDialogMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolvePageSetupUnixDialogMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolvePageSetupUnixDialogMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolvePageSetupUnixDialogMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolvePageSetupUnixDialogMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolvePageSetupUnixDialogMethod "response" o = Gtk.Dialog.DialogResponseMethodInfo
    ResolvePageSetupUnixDialogMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePageSetupUnixDialogMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolvePageSetupUnixDialogMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolvePageSetupUnixDialogMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolvePageSetupUnixDialogMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolvePageSetupUnixDialogMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePageSetupUnixDialogMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePageSetupUnixDialogMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePageSetupUnixDialogMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolvePageSetupUnixDialogMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolvePageSetupUnixDialogMethod "unfullscreen" o = Gtk.Window.WindowUnfullscreenMethodInfo
    ResolvePageSetupUnixDialogMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolvePageSetupUnixDialogMethod "unmaximize" o = Gtk.Window.WindowUnmaximizeMethodInfo
    ResolvePageSetupUnixDialogMethod "unminimize" o = Gtk.Window.WindowUnminimizeMethodInfo
    ResolvePageSetupUnixDialogMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolvePageSetupUnixDialogMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolvePageSetupUnixDialogMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePageSetupUnixDialogMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolvePageSetupUnixDialogMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolvePageSetupUnixDialogMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolvePageSetupUnixDialogMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolvePageSetupUnixDialogMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolvePageSetupUnixDialogMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolvePageSetupUnixDialogMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePageSetupUnixDialogMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolvePageSetupUnixDialogMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolvePageSetupUnixDialogMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolvePageSetupUnixDialogMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolvePageSetupUnixDialogMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolvePageSetupUnixDialogMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolvePageSetupUnixDialogMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolvePageSetupUnixDialogMethod "getApplication" o = Gtk.Window.WindowGetApplicationMethodInfo
    ResolvePageSetupUnixDialogMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolvePageSetupUnixDialogMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolvePageSetupUnixDialogMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolvePageSetupUnixDialogMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolvePageSetupUnixDialogMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolvePageSetupUnixDialogMethod "getChild" o = Gtk.Window.WindowGetChildMethodInfo
    ResolvePageSetupUnixDialogMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolvePageSetupUnixDialogMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolvePageSetupUnixDialogMethod "getContentArea" o = Gtk.Dialog.DialogGetContentAreaMethodInfo
    ResolvePageSetupUnixDialogMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolvePageSetupUnixDialogMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolvePageSetupUnixDialogMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolvePageSetupUnixDialogMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePageSetupUnixDialogMethod "getDecorated" o = Gtk.Window.WindowGetDecoratedMethodInfo
    ResolvePageSetupUnixDialogMethod "getDefaultSize" o = Gtk.Window.WindowGetDefaultSizeMethodInfo
    ResolvePageSetupUnixDialogMethod "getDefaultWidget" o = Gtk.Window.WindowGetDefaultWidgetMethodInfo
    ResolvePageSetupUnixDialogMethod "getDeletable" o = Gtk.Window.WindowGetDeletableMethodInfo
    ResolvePageSetupUnixDialogMethod "getDestroyWithParent" o = Gtk.Window.WindowGetDestroyWithParentMethodInfo
    ResolvePageSetupUnixDialogMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolvePageSetupUnixDialogMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolvePageSetupUnixDialogMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolvePageSetupUnixDialogMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolvePageSetupUnixDialogMethod "getFocus" o = Gtk.Window.WindowGetFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolvePageSetupUnixDialogMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolvePageSetupUnixDialogMethod "getFocusVisible" o = Gtk.Window.WindowGetFocusVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolvePageSetupUnixDialogMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolvePageSetupUnixDialogMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolvePageSetupUnixDialogMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolvePageSetupUnixDialogMethod "getGroup" o = Gtk.Window.WindowGetGroupMethodInfo
    ResolvePageSetupUnixDialogMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolvePageSetupUnixDialogMethod "getHandleMenubarAccel" o = Gtk.Window.WindowGetHandleMenubarAccelMethodInfo
    ResolvePageSetupUnixDialogMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolvePageSetupUnixDialogMethod "getHeaderBar" o = Gtk.Dialog.DialogGetHeaderBarMethodInfo
    ResolvePageSetupUnixDialogMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolvePageSetupUnixDialogMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolvePageSetupUnixDialogMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolvePageSetupUnixDialogMethod "getHideOnClose" o = Gtk.Window.WindowGetHideOnCloseMethodInfo
    ResolvePageSetupUnixDialogMethod "getIconName" o = Gtk.Window.WindowGetIconNameMethodInfo
    ResolvePageSetupUnixDialogMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolvePageSetupUnixDialogMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolvePageSetupUnixDialogMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolvePageSetupUnixDialogMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolvePageSetupUnixDialogMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolvePageSetupUnixDialogMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolvePageSetupUnixDialogMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolvePageSetupUnixDialogMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolvePageSetupUnixDialogMethod "getMnemonicsVisible" o = Gtk.Window.WindowGetMnemonicsVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "getModal" o = Gtk.Window.WindowGetModalMethodInfo
    ResolvePageSetupUnixDialogMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolvePageSetupUnixDialogMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolvePageSetupUnixDialogMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolvePageSetupUnixDialogMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolvePageSetupUnixDialogMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolvePageSetupUnixDialogMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolvePageSetupUnixDialogMethod "getPageSetup" o = PageSetupUnixDialogGetPageSetupMethodInfo
    ResolvePageSetupUnixDialogMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolvePageSetupUnixDialogMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolvePageSetupUnixDialogMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolvePageSetupUnixDialogMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolvePageSetupUnixDialogMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolvePageSetupUnixDialogMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolvePageSetupUnixDialogMethod "getPrintSettings" o = PageSetupUnixDialogGetPrintSettingsMethodInfo
    ResolvePageSetupUnixDialogMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePageSetupUnixDialogMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePageSetupUnixDialogMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolvePageSetupUnixDialogMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolvePageSetupUnixDialogMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolvePageSetupUnixDialogMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolvePageSetupUnixDialogMethod "getResizable" o = Gtk.Window.WindowGetResizableMethodInfo
    ResolvePageSetupUnixDialogMethod "getResponseForWidget" o = Gtk.Dialog.DialogGetResponseForWidgetMethodInfo
    ResolvePageSetupUnixDialogMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolvePageSetupUnixDialogMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolvePageSetupUnixDialogMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolvePageSetupUnixDialogMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolvePageSetupUnixDialogMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolvePageSetupUnixDialogMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolvePageSetupUnixDialogMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolvePageSetupUnixDialogMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolvePageSetupUnixDialogMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolvePageSetupUnixDialogMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolvePageSetupUnixDialogMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolvePageSetupUnixDialogMethod "getTitle" o = Gtk.Window.WindowGetTitleMethodInfo
    ResolvePageSetupUnixDialogMethod "getTitlebar" o = Gtk.Window.WindowGetTitlebarMethodInfo
    ResolvePageSetupUnixDialogMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolvePageSetupUnixDialogMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolvePageSetupUnixDialogMethod "getTransientFor" o = Gtk.Window.WindowGetTransientForMethodInfo
    ResolvePageSetupUnixDialogMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolvePageSetupUnixDialogMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolvePageSetupUnixDialogMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolvePageSetupUnixDialogMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "getWidgetForResponse" o = Gtk.Dialog.DialogGetWidgetForResponseMethodInfo
    ResolvePageSetupUnixDialogMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolvePageSetupUnixDialogMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolvePageSetupUnixDialogMethod "setApplication" o = Gtk.Window.WindowSetApplicationMethodInfo
    ResolvePageSetupUnixDialogMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolvePageSetupUnixDialogMethod "setChild" o = Gtk.Window.WindowSetChildMethodInfo
    ResolvePageSetupUnixDialogMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolvePageSetupUnixDialogMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolvePageSetupUnixDialogMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolvePageSetupUnixDialogMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePageSetupUnixDialogMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePageSetupUnixDialogMethod "setDecorated" o = Gtk.Window.WindowSetDecoratedMethodInfo
    ResolvePageSetupUnixDialogMethod "setDefaultResponse" o = Gtk.Dialog.DialogSetDefaultResponseMethodInfo
    ResolvePageSetupUnixDialogMethod "setDefaultSize" o = Gtk.Window.WindowSetDefaultSizeMethodInfo
    ResolvePageSetupUnixDialogMethod "setDefaultWidget" o = Gtk.Window.WindowSetDefaultWidgetMethodInfo
    ResolvePageSetupUnixDialogMethod "setDeletable" o = Gtk.Window.WindowSetDeletableMethodInfo
    ResolvePageSetupUnixDialogMethod "setDestroyWithParent" o = Gtk.Window.WindowSetDestroyWithParentMethodInfo
    ResolvePageSetupUnixDialogMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolvePageSetupUnixDialogMethod "setDisplay" o = Gtk.Window.WindowSetDisplayMethodInfo
    ResolvePageSetupUnixDialogMethod "setFocus" o = Gtk.Window.WindowSetFocusMethodInfo
    ResolvePageSetupUnixDialogMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolvePageSetupUnixDialogMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolvePageSetupUnixDialogMethod "setFocusVisible" o = Gtk.Window.WindowSetFocusVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolvePageSetupUnixDialogMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolvePageSetupUnixDialogMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolvePageSetupUnixDialogMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolvePageSetupUnixDialogMethod "setHandleMenubarAccel" o = Gtk.Window.WindowSetHandleMenubarAccelMethodInfo
    ResolvePageSetupUnixDialogMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolvePageSetupUnixDialogMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolvePageSetupUnixDialogMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolvePageSetupUnixDialogMethod "setHideOnClose" o = Gtk.Window.WindowSetHideOnCloseMethodInfo
    ResolvePageSetupUnixDialogMethod "setIconName" o = Gtk.Window.WindowSetIconNameMethodInfo
    ResolvePageSetupUnixDialogMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolvePageSetupUnixDialogMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolvePageSetupUnixDialogMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolvePageSetupUnixDialogMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolvePageSetupUnixDialogMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolvePageSetupUnixDialogMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolvePageSetupUnixDialogMethod "setMnemonicsVisible" o = Gtk.Window.WindowSetMnemonicsVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod "setModal" o = Gtk.Window.WindowSetModalMethodInfo
    ResolvePageSetupUnixDialogMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolvePageSetupUnixDialogMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolvePageSetupUnixDialogMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolvePageSetupUnixDialogMethod "setPageSetup" o = PageSetupUnixDialogSetPageSetupMethodInfo
    ResolvePageSetupUnixDialogMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolvePageSetupUnixDialogMethod "setPrintSettings" o = PageSetupUnixDialogSetPrintSettingsMethodInfo
    ResolvePageSetupUnixDialogMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePageSetupUnixDialogMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolvePageSetupUnixDialogMethod "setResizable" o = Gtk.Window.WindowSetResizableMethodInfo
    ResolvePageSetupUnixDialogMethod "setResponseSensitive" o = Gtk.Dialog.DialogSetResponseSensitiveMethodInfo
    ResolvePageSetupUnixDialogMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolvePageSetupUnixDialogMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolvePageSetupUnixDialogMethod "setStartupId" o = Gtk.Window.WindowSetStartupIdMethodInfo
    ResolvePageSetupUnixDialogMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolvePageSetupUnixDialogMethod "setTitle" o = Gtk.Window.WindowSetTitleMethodInfo
    ResolvePageSetupUnixDialogMethod "setTitlebar" o = Gtk.Window.WindowSetTitlebarMethodInfo
    ResolvePageSetupUnixDialogMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolvePageSetupUnixDialogMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolvePageSetupUnixDialogMethod "setTransientFor" o = Gtk.Window.WindowSetTransientForMethodInfo
    ResolvePageSetupUnixDialogMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolvePageSetupUnixDialogMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolvePageSetupUnixDialogMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolvePageSetupUnixDialogMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolvePageSetupUnixDialogMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePageSetupUnixDialogMethod t PageSetupUnixDialog, O.OverloadedMethod info PageSetupUnixDialog p) => OL.IsLabel t (PageSetupUnixDialog -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePageSetupUnixDialogMethod t PageSetupUnixDialog, O.OverloadedMethod info PageSetupUnixDialog p, R.HasField t PageSetupUnixDialog p) => R.HasField t PageSetupUnixDialog p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePageSetupUnixDialogMethod t PageSetupUnixDialog, O.OverloadedMethodInfo info PageSetupUnixDialog) => OL.IsLabel t (O.MethodProxy info PageSetupUnixDialog) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PageSetupUnixDialog
type instance O.AttributeList PageSetupUnixDialog = PageSetupUnixDialogAttributeList
type PageSetupUnixDialogAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("application", Gtk.Window.WindowApplicationPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", Gtk.Window.WindowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorated", Gtk.Window.WindowDecoratedPropertyInfo), '("defaultHeight", Gtk.Window.WindowDefaultHeightPropertyInfo), '("defaultWidget", Gtk.Window.WindowDefaultWidgetPropertyInfo), '("defaultWidth", Gtk.Window.WindowDefaultWidthPropertyInfo), '("deletable", Gtk.Window.WindowDeletablePropertyInfo), '("destroyWithParent", Gtk.Window.WindowDestroyWithParentPropertyInfo), '("display", Gtk.Window.WindowDisplayPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusVisible", Gtk.Window.WindowFocusVisiblePropertyInfo), '("focusWidget", Gtk.Window.WindowFocusWidgetPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fullscreened", Gtk.Window.WindowFullscreenedPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("handleMenubarAccel", Gtk.Window.WindowHandleMenubarAccelPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideOnClose", Gtk.Window.WindowHideOnClosePropertyInfo), '("iconName", Gtk.Window.WindowIconNamePropertyInfo), '("isActive", Gtk.Window.WindowIsActivePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maximized", Gtk.Window.WindowMaximizedPropertyInfo), '("mnemonicsVisible", Gtk.Window.WindowMnemonicsVisiblePropertyInfo), '("modal", Gtk.Window.WindowModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizable", Gtk.Window.WindowResizablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("startupId", Gtk.Window.WindowStartupIdPropertyInfo), '("suspended", Gtk.Window.WindowSuspendedPropertyInfo), '("title", Gtk.Window.WindowTitlePropertyInfo), '("titlebar", Gtk.Window.WindowTitlebarPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transientFor", Gtk.Window.WindowTransientForPropertyInfo), '("useHeaderBar", Gtk.Dialog.DialogUseHeaderBarPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PageSetupUnixDialog = PageSetupUnixDialogSignalList
type PageSetupUnixDialogSignalList = ('[ '("activateDefault", Gtk.Window.WindowActivateDefaultSignalInfo), '("activateFocus", Gtk.Window.WindowActivateFocusSignalInfo), '("close", Gtk.Dialog.DialogCloseSignalInfo), '("closeRequest", Gtk.Window.WindowCloseRequestSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("enableDebugging", Gtk.Window.WindowEnableDebuggingSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("keysChanged", Gtk.Window.WindowKeysChangedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("response", Gtk.Dialog.DialogResponseSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PageSetupUnixDialog::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the title of the dialog"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transient parent of the dialog"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "PageSetupUnixDialog" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_page_setup_unix_dialog_new" gtk_page_setup_unix_dialog_new :: 
    CString ->                              -- title : TBasicType TUTF8
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr PageSetupUnixDialog)

-- | Creates a new page setup dialog.
pageSetupUnixDialogNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a) =>
    Maybe (T.Text)
    -- ^ /@title@/: the title of the dialog
    -> Maybe (a)
    -- ^ /@parent@/: transient parent of the dialog
    -> m PageSetupUnixDialog
    -- ^ __Returns:__ the new @GtkPageSetupUnixDialog@
pageSetupUnixDialogNew title parent = liftIO $ do
    maybeTitle <- case title of
        Nothing -> return FP.nullPtr
        Just jTitle -> do
            jTitle' <- textToCString jTitle
            return jTitle'
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    result <- gtk_page_setup_unix_dialog_new maybeTitle maybeParent
    checkUnexpectedReturnNULL "pageSetupUnixDialogNew" result
    result' <- (newObject PageSetupUnixDialog) result
    whenJust parent touchManagedPtr
    freeMem maybeTitle
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method PageSetupUnixDialog::get_page_setup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "PageSetupUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSetupUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PageSetup" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_page_setup_unix_dialog_get_page_setup" gtk_page_setup_unix_dialog_get_page_setup :: 
    Ptr PageSetupUnixDialog ->              -- dialog : TInterface (Name {namespace = "Gtk", name = "PageSetupUnixDialog"})
    IO (Ptr Gtk.PageSetup.PageSetup)

-- | Gets the currently selected page setup from the dialog.
pageSetupUnixDialogGetPageSetup ::
    (B.CallStack.HasCallStack, MonadIO m, IsPageSetupUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPageSetupUnixDialog@
    -> m Gtk.PageSetup.PageSetup
    -- ^ __Returns:__ the current page setup
pageSetupUnixDialogGetPageSetup dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_page_setup_unix_dialog_get_page_setup dialog'
    checkUnexpectedReturnNULL "pageSetupUnixDialogGetPageSetup" result
    result' <- (newObject Gtk.PageSetup.PageSetup) result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PageSetupUnixDialogGetPageSetupMethodInfo
instance (signature ~ (m Gtk.PageSetup.PageSetup), MonadIO m, IsPageSetupUnixDialog a) => O.OverloadedMethod PageSetupUnixDialogGetPageSetupMethodInfo a signature where
    overloadedMethod = pageSetupUnixDialogGetPageSetup

instance O.OverloadedMethodInfo PageSetupUnixDialogGetPageSetupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PageSetupUnixDialog.pageSetupUnixDialogGetPageSetup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PageSetupUnixDialog.html#v:pageSetupUnixDialogGetPageSetup"
        })


#endif

-- method PageSetupUnixDialog::get_print_settings
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "PageSetupUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSetupUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PrintSettings" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_page_setup_unix_dialog_get_print_settings" gtk_page_setup_unix_dialog_get_print_settings :: 
    Ptr PageSetupUnixDialog ->              -- dialog : TInterface (Name {namespace = "Gtk", name = "PageSetupUnixDialog"})
    IO (Ptr Gtk.PrintSettings.PrintSettings)

-- | Gets the current print settings from the dialog.
pageSetupUnixDialogGetPrintSettings ::
    (B.CallStack.HasCallStack, MonadIO m, IsPageSetupUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPageSetupUnixDialog@
    -> m (Maybe Gtk.PrintSettings.PrintSettings)
    -- ^ __Returns:__ the current print settings
pageSetupUnixDialogGetPrintSettings dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_page_setup_unix_dialog_get_print_settings dialog'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.PrintSettings.PrintSettings) result'
        return result''
    touchManagedPtr dialog
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PageSetupUnixDialogGetPrintSettingsMethodInfo
instance (signature ~ (m (Maybe Gtk.PrintSettings.PrintSettings)), MonadIO m, IsPageSetupUnixDialog a) => O.OverloadedMethod PageSetupUnixDialogGetPrintSettingsMethodInfo a signature where
    overloadedMethod = pageSetupUnixDialogGetPrintSettings

instance O.OverloadedMethodInfo PageSetupUnixDialogGetPrintSettingsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PageSetupUnixDialog.pageSetupUnixDialogGetPrintSettings",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PageSetupUnixDialog.html#v:pageSetupUnixDialogGetPrintSettings"
        })


#endif

-- method PageSetupUnixDialog::set_page_setup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "PageSetupUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSetupUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_setup"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSetup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSetup`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_page_setup_unix_dialog_set_page_setup" gtk_page_setup_unix_dialog_set_page_setup :: 
    Ptr PageSetupUnixDialog ->              -- dialog : TInterface (Name {namespace = "Gtk", name = "PageSetupUnixDialog"})
    Ptr Gtk.PageSetup.PageSetup ->          -- page_setup : TInterface (Name {namespace = "Gtk", name = "PageSetup"})
    IO ()

-- | Sets the @GtkPageSetup@ from which the page setup
-- dialog takes its values.
pageSetupUnixDialogSetPageSetup ::
    (B.CallStack.HasCallStack, MonadIO m, IsPageSetupUnixDialog a, Gtk.PageSetup.IsPageSetup b) =>
    a
    -- ^ /@dialog@/: a @GtkPageSetupUnixDialog@
    -> b
    -- ^ /@pageSetup@/: a @GtkPageSetup@
    -> m ()
pageSetupUnixDialogSetPageSetup dialog pageSetup = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    pageSetup' <- unsafeManagedPtrCastPtr pageSetup
    gtk_page_setup_unix_dialog_set_page_setup dialog' pageSetup'
    touchManagedPtr dialog
    touchManagedPtr pageSetup
    return ()

#if defined(ENABLE_OVERLOADING)
data PageSetupUnixDialogSetPageSetupMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsPageSetupUnixDialog a, Gtk.PageSetup.IsPageSetup b) => O.OverloadedMethod PageSetupUnixDialogSetPageSetupMethodInfo a signature where
    overloadedMethod = pageSetupUnixDialogSetPageSetup

instance O.OverloadedMethodInfo PageSetupUnixDialogSetPageSetupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PageSetupUnixDialog.pageSetupUnixDialogSetPageSetup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PageSetupUnixDialog.html#v:pageSetupUnixDialogSetPageSetup"
        })


#endif

-- method PageSetupUnixDialog::set_print_settings
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "PageSetupUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSetupUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "print_settings"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintSettings" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintSettings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_page_setup_unix_dialog_set_print_settings" gtk_page_setup_unix_dialog_set_print_settings :: 
    Ptr PageSetupUnixDialog ->              -- dialog : TInterface (Name {namespace = "Gtk", name = "PageSetupUnixDialog"})
    Ptr Gtk.PrintSettings.PrintSettings ->  -- print_settings : TInterface (Name {namespace = "Gtk", name = "PrintSettings"})
    IO ()

-- | Sets the @GtkPrintSettings@ from which the page setup dialog
-- takes its values.
pageSetupUnixDialogSetPrintSettings ::
    (B.CallStack.HasCallStack, MonadIO m, IsPageSetupUnixDialog a, Gtk.PrintSettings.IsPrintSettings b) =>
    a
    -- ^ /@dialog@/: a @GtkPageSetupUnixDialog@
    -> Maybe (b)
    -- ^ /@printSettings@/: a @GtkPrintSettings@
    -> m ()
pageSetupUnixDialogSetPrintSettings dialog printSettings = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    maybePrintSettings <- case printSettings of
        Nothing -> return FP.nullPtr
        Just jPrintSettings -> do
            jPrintSettings' <- unsafeManagedPtrCastPtr jPrintSettings
            return jPrintSettings'
    gtk_page_setup_unix_dialog_set_print_settings dialog' maybePrintSettings
    touchManagedPtr dialog
    whenJust printSettings touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PageSetupUnixDialogSetPrintSettingsMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPageSetupUnixDialog a, Gtk.PrintSettings.IsPrintSettings b) => O.OverloadedMethod PageSetupUnixDialogSetPrintSettingsMethodInfo a signature where
    overloadedMethod = pageSetupUnixDialogSetPrintSettings

instance O.OverloadedMethodInfo PageSetupUnixDialogSetPrintSettingsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PageSetupUnixDialog.pageSetupUnixDialogSetPrintSettings",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PageSetupUnixDialog.html#v:pageSetupUnixDialogSetPrintSettings"
        })


#endif


