{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Places “overlay” widgets on top of a single main child.
-- 
-- \<picture>
--   \<source srcset=\"overlay-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkOverlay\" src=\"overlay.png\">
-- \<\/picture>
-- 
-- The position of each overlay widget is determined by its
-- [Widget:halign]("GI.Gtk.Objects.Widget#g:attr:halign") and [Widget:valign]("GI.Gtk.Objects.Widget#g:attr:valign")
-- properties. E.g. a widget with both alignments set to 'GI.Gtk.Enums.AlignStart'
-- will be placed at the top left corner of the @GtkOverlay@ container,
-- whereas an overlay with halign set to 'GI.Gtk.Enums.AlignCenter' and valign set
-- to 'GI.Gtk.Enums.AlignEnd' will be placed a the bottom edge of the @GtkOverlay@,
-- horizontally centered. The position can be adjusted by setting the margin
-- properties of the child to non-zero values.
-- 
-- More complicated placement of overlays is possible by connecting
-- to the [Overlay::getChildPosition]("GI.Gtk.Objects.Overlay#g:signal:getChildPosition") signal.
-- 
-- An overlay’s minimum and natural sizes are those of its main child.
-- The sizes of overlay children are not considered when measuring these
-- preferred sizes.
-- 
-- = GtkOverlay as GtkBuildable
-- 
-- The @GtkOverlay@ implementation of the @GtkBuildable@ interface
-- supports placing a child as an overlay by specifying “overlay” as
-- the “type” attribute of a @\<child>@ element.
-- 
-- = CSS nodes
-- 
-- @GtkOverlay@ has a single CSS node with the name “overlay”. Overlay children
-- whose alignments cause them to be positioned at an edge get the style classes
-- “.left”, “.right”, “.top”, and\/or “.bottom” according to their position.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Overlay
    ( 

-- * Exported types
    Overlay(..)                             ,
    IsOverlay                               ,
    toOverlay                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addOverlay]("GI.Gtk.Objects.Overlay#g:method:addOverlay"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeOverlay]("GI.Gtk.Objects.Overlay#g:method:removeOverlay"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Overlay#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipOverlay]("GI.Gtk.Objects.Overlay#g:method:getClipOverlay"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMeasureOverlay]("GI.Gtk.Objects.Overlay#g:method:getMeasureOverlay"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Overlay#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setClipOverlay]("GI.Gtk.Objects.Overlay#g:method:setClipOverlay"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMeasureOverlay]("GI.Gtk.Objects.Overlay#g:method:setMeasureOverlay"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveOverlayMethod                    ,
#endif

-- ** addOverlay #method:addOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlayAddOverlayMethodInfo             ,
#endif
    overlayAddOverlay                       ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    OverlayGetChildMethodInfo               ,
#endif
    overlayGetChild                         ,


-- ** getClipOverlay #method:getClipOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlayGetClipOverlayMethodInfo         ,
#endif
    overlayGetClipOverlay                   ,


-- ** getMeasureOverlay #method:getMeasureOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlayGetMeasureOverlayMethodInfo      ,
#endif
    overlayGetMeasureOverlay                ,


-- ** new #method:new#

    overlayNew                              ,


-- ** removeOverlay #method:removeOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlayRemoveOverlayMethodInfo          ,
#endif
    overlayRemoveOverlay                    ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    OverlaySetChildMethodInfo               ,
#endif
    overlaySetChild                         ,


-- ** setClipOverlay #method:setClipOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlaySetClipOverlayMethodInfo         ,
#endif
    overlaySetClipOverlay                   ,


-- ** setMeasureOverlay #method:setMeasureOverlay#

#if defined(ENABLE_OVERLOADING)
    OverlaySetMeasureOverlayMethodInfo      ,
#endif
    overlaySetMeasureOverlay                ,




 -- * Properties


-- ** child #attr:child#
-- | The main child widget.

#if defined(ENABLE_OVERLOADING)
    OverlayChildPropertyInfo                ,
#endif
    clearOverlayChild                       ,
    constructOverlayChild                   ,
    getOverlayChild                         ,
#if defined(ENABLE_OVERLOADING)
    overlayChild                            ,
#endif
    setOverlayChild                         ,




 -- * Signals


-- ** getChildPosition #signal:getChildPosition#

    OverlayGetChildPositionCallback         ,
#if defined(ENABLE_OVERLOADING)
    OverlayGetChildPositionSignalInfo       ,
#endif
    afterOverlayGetChildPosition            ,
    onOverlayGetChildPosition               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Overlay = Overlay (SP.ManagedPtr Overlay)
    deriving (Eq)

instance SP.ManagedPtrNewtype Overlay where
    toManagedPtr (Overlay p) = p

foreign import ccall "gtk_overlay_get_type"
    c_gtk_overlay_get_type :: IO B.Types.GType

instance B.Types.TypedObject Overlay where
    glibType = c_gtk_overlay_get_type

instance B.Types.GObject Overlay

-- | Type class for types which can be safely cast to `Overlay`, for instance with `toOverlay`.
class (SP.GObject o, O.IsDescendantOf Overlay o) => IsOverlay o
instance (SP.GObject o, O.IsDescendantOf Overlay o) => IsOverlay o

instance O.HasParentTypes Overlay
type instance O.ParentTypes Overlay = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Overlay`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toOverlay :: (MIO.MonadIO m, IsOverlay o) => o -> m Overlay
toOverlay = MIO.liftIO . B.ManagedPtr.unsafeCastTo Overlay

-- | Convert 'Overlay' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Overlay) where
    gvalueGType_ = c_gtk_overlay_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Overlay)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Overlay)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Overlay ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveOverlayMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOverlayMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveOverlayMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveOverlayMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveOverlayMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveOverlayMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveOverlayMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveOverlayMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveOverlayMethod "addOverlay" o = OverlayAddOverlayMethodInfo
    ResolveOverlayMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveOverlayMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveOverlayMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveOverlayMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveOverlayMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveOverlayMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveOverlayMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveOverlayMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveOverlayMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveOverlayMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveOverlayMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveOverlayMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveOverlayMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveOverlayMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveOverlayMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveOverlayMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveOverlayMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveOverlayMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveOverlayMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveOverlayMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveOverlayMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveOverlayMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveOverlayMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveOverlayMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveOverlayMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveOverlayMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveOverlayMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveOverlayMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveOverlayMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveOverlayMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveOverlayMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveOverlayMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveOverlayMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveOverlayMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveOverlayMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveOverlayMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveOverlayMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveOverlayMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveOverlayMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveOverlayMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveOverlayMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveOverlayMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveOverlayMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveOverlayMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveOverlayMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveOverlayMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveOverlayMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveOverlayMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveOverlayMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveOverlayMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveOverlayMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveOverlayMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveOverlayMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveOverlayMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveOverlayMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveOverlayMethod "removeOverlay" o = OverlayRemoveOverlayMethodInfo
    ResolveOverlayMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveOverlayMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveOverlayMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveOverlayMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveOverlayMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveOverlayMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveOverlayMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveOverlayMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveOverlayMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveOverlayMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveOverlayMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveOverlayMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveOverlayMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveOverlayMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveOverlayMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveOverlayMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveOverlayMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveOverlayMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveOverlayMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveOverlayMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveOverlayMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveOverlayMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveOverlayMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveOverlayMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveOverlayMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveOverlayMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveOverlayMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveOverlayMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveOverlayMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveOverlayMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveOverlayMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveOverlayMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveOverlayMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveOverlayMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveOverlayMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveOverlayMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveOverlayMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveOverlayMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveOverlayMethod "getChild" o = OverlayGetChildMethodInfo
    ResolveOverlayMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveOverlayMethod "getClipOverlay" o = OverlayGetClipOverlayMethodInfo
    ResolveOverlayMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveOverlayMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveOverlayMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveOverlayMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveOverlayMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveOverlayMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveOverlayMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveOverlayMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveOverlayMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveOverlayMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveOverlayMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveOverlayMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveOverlayMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveOverlayMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveOverlayMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveOverlayMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveOverlayMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveOverlayMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveOverlayMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveOverlayMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveOverlayMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveOverlayMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveOverlayMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveOverlayMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveOverlayMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveOverlayMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveOverlayMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveOverlayMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveOverlayMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveOverlayMethod "getMeasureOverlay" o = OverlayGetMeasureOverlayMethodInfo
    ResolveOverlayMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveOverlayMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveOverlayMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveOverlayMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveOverlayMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveOverlayMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveOverlayMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveOverlayMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveOverlayMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveOverlayMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveOverlayMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveOverlayMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveOverlayMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveOverlayMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveOverlayMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveOverlayMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveOverlayMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveOverlayMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveOverlayMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveOverlayMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveOverlayMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveOverlayMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveOverlayMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveOverlayMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveOverlayMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveOverlayMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveOverlayMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveOverlayMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveOverlayMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveOverlayMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveOverlayMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveOverlayMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveOverlayMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveOverlayMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveOverlayMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveOverlayMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveOverlayMethod "setChild" o = OverlaySetChildMethodInfo
    ResolveOverlayMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveOverlayMethod "setClipOverlay" o = OverlaySetClipOverlayMethodInfo
    ResolveOverlayMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveOverlayMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveOverlayMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveOverlayMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveOverlayMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveOverlayMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveOverlayMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveOverlayMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveOverlayMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveOverlayMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveOverlayMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveOverlayMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveOverlayMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveOverlayMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveOverlayMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveOverlayMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveOverlayMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveOverlayMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveOverlayMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveOverlayMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveOverlayMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveOverlayMethod "setMeasureOverlay" o = OverlaySetMeasureOverlayMethodInfo
    ResolveOverlayMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveOverlayMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveOverlayMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveOverlayMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveOverlayMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveOverlayMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveOverlayMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveOverlayMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveOverlayMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveOverlayMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveOverlayMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveOverlayMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveOverlayMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveOverlayMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveOverlayMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveOverlayMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOverlayMethod t Overlay, O.OverloadedMethod info Overlay p) => OL.IsLabel t (Overlay -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOverlayMethod t Overlay, O.OverloadedMethod info Overlay p, R.HasField t Overlay p) => R.HasField t Overlay p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOverlayMethod t Overlay, O.OverloadedMethodInfo info Overlay) => OL.IsLabel t (O.MethodProxy info Overlay) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Overlay::get-child-position
-- | Emitted to determine the position and size of any overlay
-- child widgets.
-- 
-- A handler for this signal should fill /@allocation@/ with
-- the desired position and size for /@widget@/, relative to
-- the \'main\' child of /@overlay@/.
-- 
-- The default handler for this signal uses the /@widget@/\'s
-- halign and valign properties to determine the position
-- and gives the widget its natural size (except that an
-- alignment of 'GI.Gtk.Enums.AlignFill' will cause the overlay to
-- be full-width\/height). If the main child is a
-- @GtkScrolledWindow@, the overlays are placed relative
-- to its contents.
type OverlayGetChildPositionCallback =
    Gtk.Widget.Widget
    -- ^ /@widget@/: the child widget to position
    -> IO ((Bool, Gdk.Rectangle.Rectangle))
    -- ^ __Returns:__ 'P.True' if the /@allocation@/ has been filled

type C_OverlayGetChildPositionCallback =
    Ptr Overlay ->                          -- object
    Ptr Gtk.Widget.Widget ->
    Ptr Gdk.Rectangle.Rectangle ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_OverlayGetChildPositionCallback`.
foreign import ccall "wrapper"
    mk_OverlayGetChildPositionCallback :: C_OverlayGetChildPositionCallback -> IO (FunPtr C_OverlayGetChildPositionCallback)

wrap_OverlayGetChildPositionCallback :: 
    GObject a => (a -> OverlayGetChildPositionCallback) ->
    C_OverlayGetChildPositionCallback
wrap_OverlayGetChildPositionCallback gi'cb gi'selfPtr widget allocation _ = do
    -- XXX Could not generate callback wrapper for OverlayGetChildPositionCallback
    -- Not implemented: Unexpected transfer type for "allocation"
    P.error "The bindings for wrap_OverlayGetChildPositionCallback could not be generated, function unsupported."


-- | Connect a signal handler for the [getChildPosition](#signal:getChildPosition) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' overlay #getChildPosition callback
-- @
-- 
-- 
onOverlayGetChildPosition :: (IsOverlay a, MonadIO m) => a -> ((?self :: a) => OverlayGetChildPositionCallback) -> m SignalHandlerId
onOverlayGetChildPosition obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_OverlayGetChildPositionCallback wrapped
    wrapped'' <- mk_OverlayGetChildPositionCallback wrapped'
    connectSignalFunPtr obj "get-child-position" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [getChildPosition](#signal:getChildPosition) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' overlay #getChildPosition callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterOverlayGetChildPosition :: (IsOverlay a, MonadIO m) => a -> ((?self :: a) => OverlayGetChildPositionCallback) -> m SignalHandlerId
afterOverlayGetChildPosition obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_OverlayGetChildPositionCallback wrapped
    wrapped'' <- mk_OverlayGetChildPositionCallback wrapped'
    connectSignalFunPtr obj "get-child-position" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data OverlayGetChildPositionSignalInfo
instance SignalInfo OverlayGetChildPositionSignalInfo where
    type HaskellCallbackType OverlayGetChildPositionSignalInfo = OverlayGetChildPositionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_OverlayGetChildPositionCallback cb
        cb'' <- mk_OverlayGetChildPositionCallback cb'
        connectSignalFunPtr obj "get-child-position" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay::get-child-position"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#g:signal:getChildPosition"})

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' overlay #child
-- @
getOverlayChild :: (MonadIO m, IsOverlay o) => o -> m (Maybe Gtk.Widget.Widget)
getOverlayChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' overlay [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setOverlayChild :: (MonadIO m, IsOverlay o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setOverlayChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructOverlayChild :: (IsOverlay o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructOverlayChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearOverlayChild :: (MonadIO m, IsOverlay o) => o -> m ()
clearOverlayChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data OverlayChildPropertyInfo
instance AttrInfo OverlayChildPropertyInfo where
    type AttrAllowedOps OverlayChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint OverlayChildPropertyInfo = IsOverlay
    type AttrSetTypeConstraint OverlayChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint OverlayChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType OverlayChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType OverlayChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel OverlayChildPropertyInfo = "child"
    type AttrOrigin OverlayChildPropertyInfo = Overlay
    attrGet = getOverlayChild
    attrSet = setOverlayChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructOverlayChild
    attrClear = clearOverlayChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#g:attr:child"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Overlay
type instance O.AttributeList Overlay = OverlayAttributeList
type OverlayAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", OverlayChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
overlayChild :: AttrLabelProxy "child"
overlayChild = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Overlay = OverlaySignalList
type OverlaySignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("getChildPosition", OverlayGetChildPositionSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Overlay::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Overlay" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_new" gtk_overlay_new :: 
    IO (Ptr Overlay)

-- | Creates a new @GtkOverlay@.
overlayNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Overlay
    -- ^ __Returns:__ a new @GtkOverlay@ object.
overlayNew  = liftIO $ do
    result <- gtk_overlay_new
    checkUnexpectedReturnNULL "overlayNew" result
    result' <- (newObject Overlay) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Overlay::add_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget` to be added to the container"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_add_overlay" gtk_overlay_add_overlay :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Adds /@widget@/ to /@overlay@/.
-- 
-- The widget will be stacked on top of the main widget
-- added with 'GI.Gtk.Objects.Overlay.overlaySetChild'.
-- 
-- The position at which /@widget@/ is placed is determined
-- from its [Widget:halign]("GI.Gtk.Objects.Widget#g:attr:halign") and
-- [Widget:valign]("GI.Gtk.Objects.Widget#g:attr:valign") properties.
overlayAddOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> b
    -- ^ /@widget@/: a @GtkWidget@ to be added to the container
    -> m ()
overlayAddOverlay overlay widget = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    widget' <- unsafeManagedPtrCastPtr widget
    gtk_overlay_add_overlay overlay' widget'
    touchManagedPtr overlay
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data OverlayAddOverlayMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) => O.OverloadedMethod OverlayAddOverlayMethodInfo a signature where
    overloadedMethod = overlayAddOverlay

instance O.OverloadedMethodInfo OverlayAddOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlayAddOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlayAddOverlay"
        })


#endif

-- method Overlay::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_get_child" gtk_overlay_get_child :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@overlay@/.
overlayGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@overlay@/
overlayGetChild overlay = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    result <- gtk_overlay_get_child overlay'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr overlay
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data OverlayGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsOverlay a) => O.OverloadedMethod OverlayGetChildMethodInfo a signature where
    overloadedMethod = overlayGetChild

instance O.OverloadedMethodInfo OverlayGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlayGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlayGetChild"
        })


#endif

-- method Overlay::get_clip_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an overlay child of `GtkOverlay`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_get_clip_overlay" gtk_overlay_get_clip_overlay :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CInt

-- | Gets whether /@widget@/ should be clipped within the parent.
overlayGetClipOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> b
    -- ^ /@widget@/: an overlay child of @GtkOverlay@
    -> m Bool
    -- ^ __Returns:__ whether the widget is clipped within the parent.
overlayGetClipOverlay overlay widget = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    widget' <- unsafeManagedPtrCastPtr widget
    result <- gtk_overlay_get_clip_overlay overlay' widget'
    let result' = (/= 0) result
    touchManagedPtr overlay
    touchManagedPtr widget
    return result'

#if defined(ENABLE_OVERLOADING)
data OverlayGetClipOverlayMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) => O.OverloadedMethod OverlayGetClipOverlayMethodInfo a signature where
    overloadedMethod = overlayGetClipOverlay

instance O.OverloadedMethodInfo OverlayGetClipOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlayGetClipOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlayGetClipOverlay"
        })


#endif

-- method Overlay::get_measure_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an overlay child of `GtkOverlay`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_get_measure_overlay" gtk_overlay_get_measure_overlay :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CInt

-- | Gets whether /@widget@/\'s size is included in the measurement of
-- /@overlay@/.
overlayGetMeasureOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> b
    -- ^ /@widget@/: an overlay child of @GtkOverlay@
    -> m Bool
    -- ^ __Returns:__ whether the widget is measured
overlayGetMeasureOverlay overlay widget = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    widget' <- unsafeManagedPtrCastPtr widget
    result <- gtk_overlay_get_measure_overlay overlay' widget'
    let result' = (/= 0) result
    touchManagedPtr overlay
    touchManagedPtr widget
    return result'

#if defined(ENABLE_OVERLOADING)
data OverlayGetMeasureOverlayMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) => O.OverloadedMethod OverlayGetMeasureOverlayMethodInfo a signature where
    overloadedMethod = overlayGetMeasureOverlay

instance O.OverloadedMethodInfo OverlayGetMeasureOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlayGetMeasureOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlayGetMeasureOverlay"
        })


#endif

-- method Overlay::remove_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget` to be removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_remove_overlay" gtk_overlay_remove_overlay :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes an overlay that was added with 'GI.Gtk.Objects.Overlay.overlayAddOverlay'.
overlayRemoveOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> b
    -- ^ /@widget@/: a @GtkWidget@ to be removed
    -> m ()
overlayRemoveOverlay overlay widget = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    widget' <- unsafeManagedPtrCastPtr widget
    gtk_overlay_remove_overlay overlay' widget'
    touchManagedPtr overlay
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data OverlayRemoveOverlayMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) => O.OverloadedMethod OverlayRemoveOverlayMethodInfo a signature where
    overloadedMethod = overlayRemoveOverlay

instance O.OverloadedMethodInfo OverlayRemoveOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlayRemoveOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlayRemoveOverlay"
        })


#endif

-- method Overlay::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_set_child" gtk_overlay_set_child :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@overlay@/.
overlaySetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
overlaySetChild overlay child = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_overlay_set_child overlay' maybeChild
    touchManagedPtr overlay
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data OverlaySetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) => O.OverloadedMethod OverlaySetChildMethodInfo a signature where
    overloadedMethod = overlaySetChild

instance O.OverloadedMethodInfo OverlaySetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlaySetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlaySetChild"
        })


#endif

-- method Overlay::set_clip_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an overlay child of `GtkOverlay`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clip_overlay"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the child should be clipped"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_set_clip_overlay" gtk_overlay_set_clip_overlay :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CInt ->                                 -- clip_overlay : TBasicType TBoolean
    IO ()

-- | Sets whether /@widget@/ should be clipped within the parent.
overlaySetClipOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> b
    -- ^ /@widget@/: an overlay child of @GtkOverlay@
    -> Bool
    -- ^ /@clipOverlay@/: whether the child should be clipped
    -> m ()
overlaySetClipOverlay overlay widget clipOverlay = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    widget' <- unsafeManagedPtrCastPtr widget
    let clipOverlay' = (P.fromIntegral . P.fromEnum) clipOverlay
    gtk_overlay_set_clip_overlay overlay' widget' clipOverlay'
    touchManagedPtr overlay
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data OverlaySetClipOverlayMethodInfo
instance (signature ~ (b -> Bool -> m ()), MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) => O.OverloadedMethod OverlaySetClipOverlayMethodInfo a signature where
    overloadedMethod = overlaySetClipOverlay

instance O.OverloadedMethodInfo OverlaySetClipOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlaySetClipOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlaySetClipOverlay"
        })


#endif

-- method Overlay::set_measure_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Overlay" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkOverlay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an overlay child of `GtkOverlay`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "measure"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the child should be measured"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_overlay_set_measure_overlay" gtk_overlay_set_measure_overlay :: 
    Ptr Overlay ->                          -- overlay : TInterface (Name {namespace = "Gtk", name = "Overlay"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CInt ->                                 -- measure : TBasicType TBoolean
    IO ()

-- | Sets whether /@widget@/ is included in the measured size of /@overlay@/.
-- 
-- The overlay will request the size of the largest child that has
-- this property set to 'P.True'. Children who are not included may
-- be drawn outside of /@overlay@/\'s allocation if they are too large.
overlaySetMeasureOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@overlay@/: a @GtkOverlay@
    -> b
    -- ^ /@widget@/: an overlay child of @GtkOverlay@
    -> Bool
    -- ^ /@measure@/: whether the child should be measured
    -> m ()
overlaySetMeasureOverlay overlay widget measure = liftIO $ do
    overlay' <- unsafeManagedPtrCastPtr overlay
    widget' <- unsafeManagedPtrCastPtr widget
    let measure' = (P.fromIntegral . P.fromEnum) measure
    gtk_overlay_set_measure_overlay overlay' widget' measure'
    touchManagedPtr overlay
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data OverlaySetMeasureOverlayMethodInfo
instance (signature ~ (b -> Bool -> m ()), MonadIO m, IsOverlay a, Gtk.Widget.IsWidget b) => O.OverloadedMethod OverlaySetMeasureOverlayMethodInfo a signature where
    overloadedMethod = overlaySetMeasureOverlay

instance O.OverloadedMethodInfo OverlaySetMeasureOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Overlay.overlaySetMeasureOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Overlay.html#v:overlaySetMeasureOverlay"
        })


#endif


