{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Asks the user for passwords and other information required to
-- mount a volume.
-- 
-- @GtkMountOperation@ is needed when mounting volumes:
-- It is an implementation of @GMountOperation@ that can be used with
-- GIO functions for mounting volumes such as
-- 'GI.Gio.Interfaces.File.fileMountEnclosingVolume',
-- 'GI.Gio.Interfaces.File.fileMountMountable',
-- 'GI.Gio.Interfaces.Volume.volumeMount',
-- 'GI.Gio.Interfaces.Mount.mountUnmountWithOperation' and others.
-- 
-- When necessary, @GtkMountOperation@ shows dialogs to let the user
-- enter passwords, ask questions or show processes blocking unmount.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MountOperation
    ( 

-- * Exported types
    MountOperation(..)                      ,
    IsMountOperation                        ,
    toMountOperation                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isShowing]("GI.Gtk.Objects.MountOperation#g:method:isShowing"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reply]("GI.Gio.Objects.MountOperation#g:method:reply"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAnonymous]("GI.Gio.Objects.MountOperation#g:method:getAnonymous"), [getChoice]("GI.Gio.Objects.MountOperation#g:method:getChoice"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gtk.Objects.MountOperation#g:method:getDisplay"), [getDomain]("GI.Gio.Objects.MountOperation#g:method:getDomain"), [getIsTcryptHiddenVolume]("GI.Gio.Objects.MountOperation#g:method:getIsTcryptHiddenVolume"), [getIsTcryptSystemVolume]("GI.Gio.Objects.MountOperation#g:method:getIsTcryptSystemVolume"), [getParent]("GI.Gtk.Objects.MountOperation#g:method:getParent"), [getPassword]("GI.Gio.Objects.MountOperation#g:method:getPassword"), [getPasswordSave]("GI.Gio.Objects.MountOperation#g:method:getPasswordSave"), [getPim]("GI.Gio.Objects.MountOperation#g:method:getPim"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getUsername]("GI.Gio.Objects.MountOperation#g:method:getUsername").
-- 
-- ==== Setters
-- [setAnonymous]("GI.Gio.Objects.MountOperation#g:method:setAnonymous"), [setChoice]("GI.Gio.Objects.MountOperation#g:method:setChoice"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDisplay]("GI.Gtk.Objects.MountOperation#g:method:setDisplay"), [setDomain]("GI.Gio.Objects.MountOperation#g:method:setDomain"), [setIsTcryptHiddenVolume]("GI.Gio.Objects.MountOperation#g:method:setIsTcryptHiddenVolume"), [setIsTcryptSystemVolume]("GI.Gio.Objects.MountOperation#g:method:setIsTcryptSystemVolume"), [setParent]("GI.Gtk.Objects.MountOperation#g:method:setParent"), [setPassword]("GI.Gio.Objects.MountOperation#g:method:setPassword"), [setPasswordSave]("GI.Gio.Objects.MountOperation#g:method:setPasswordSave"), [setPim]("GI.Gio.Objects.MountOperation#g:method:setPim"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setUsername]("GI.Gio.Objects.MountOperation#g:method:setUsername").

#if defined(ENABLE_OVERLOADING)
    ResolveMountOperationMethod             ,
#endif

-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    MountOperationGetDisplayMethodInfo      ,
#endif
    mountOperationGetDisplay                ,


-- ** getParent #method:getParent#

#if defined(ENABLE_OVERLOADING)
    MountOperationGetParentMethodInfo       ,
#endif
    mountOperationGetParent                 ,


-- ** isShowing #method:isShowing#

#if defined(ENABLE_OVERLOADING)
    MountOperationIsShowingMethodInfo       ,
#endif
    mountOperationIsShowing                 ,


-- ** new #method:new#

    mountOperationNew                       ,


-- ** setDisplay #method:setDisplay#

#if defined(ENABLE_OVERLOADING)
    MountOperationSetDisplayMethodInfo      ,
#endif
    mountOperationSetDisplay                ,


-- ** setParent #method:setParent#

#if defined(ENABLE_OVERLOADING)
    MountOperationSetParentMethodInfo       ,
#endif
    mountOperationSetParent                 ,




 -- * Properties


-- ** display #attr:display#
-- | The display where dialogs will be shown.

#if defined(ENABLE_OVERLOADING)
    MountOperationDisplayPropertyInfo       ,
#endif
    constructMountOperationDisplay          ,
    getMountOperationDisplay                ,
#if defined(ENABLE_OVERLOADING)
    mountOperationDisplay                   ,
#endif
    setMountOperationDisplay                ,


-- ** isShowing #attr:isShowing#
-- | Whether a dialog is currently shown.

#if defined(ENABLE_OVERLOADING)
    MountOperationIsShowingPropertyInfo     ,
#endif
    getMountOperationIsShowing              ,


-- ** parent #attr:parent#
-- | The parent window.

#if defined(ENABLE_OVERLOADING)
    MountOperationParentPropertyInfo        ,
#endif
    clearMountOperationParent               ,
    constructMountOperationParent           ,
    getMountOperationParent                 ,
#if defined(ENABLE_OVERLOADING)
    mountOperationParent                    ,
#endif
    setMountOperationParent                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype MountOperation = MountOperation (SP.ManagedPtr MountOperation)
    deriving (Eq)

instance SP.ManagedPtrNewtype MountOperation where
    toManagedPtr (MountOperation p) = p

foreign import ccall "gtk_mount_operation_get_type"
    c_gtk_mount_operation_get_type :: IO B.Types.GType

instance B.Types.TypedObject MountOperation where
    glibType = c_gtk_mount_operation_get_type

instance B.Types.GObject MountOperation

-- | Type class for types which can be safely cast to `MountOperation`, for instance with `toMountOperation`.
class (SP.GObject o, O.IsDescendantOf MountOperation o) => IsMountOperation o
instance (SP.GObject o, O.IsDescendantOf MountOperation o) => IsMountOperation o

instance O.HasParentTypes MountOperation
type instance O.ParentTypes MountOperation = '[Gio.MountOperation.MountOperation, GObject.Object.Object]

-- | Cast to `MountOperation`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMountOperation :: (MIO.MonadIO m, IsMountOperation o) => o -> m MountOperation
toMountOperation = MIO.liftIO . B.ManagedPtr.unsafeCastTo MountOperation

-- | Convert 'MountOperation' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MountOperation) where
    gvalueGType_ = c_gtk_mount_operation_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MountOperation)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MountOperation)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MountOperation ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMountOperationMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMountOperationMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMountOperationMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMountOperationMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMountOperationMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMountOperationMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMountOperationMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMountOperationMethod "isShowing" o = MountOperationIsShowingMethodInfo
    ResolveMountOperationMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMountOperationMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMountOperationMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMountOperationMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMountOperationMethod "reply" o = Gio.MountOperation.MountOperationReplyMethodInfo
    ResolveMountOperationMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMountOperationMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMountOperationMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMountOperationMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMountOperationMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMountOperationMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMountOperationMethod "getAnonymous" o = Gio.MountOperation.MountOperationGetAnonymousMethodInfo
    ResolveMountOperationMethod "getChoice" o = Gio.MountOperation.MountOperationGetChoiceMethodInfo
    ResolveMountOperationMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMountOperationMethod "getDisplay" o = MountOperationGetDisplayMethodInfo
    ResolveMountOperationMethod "getDomain" o = Gio.MountOperation.MountOperationGetDomainMethodInfo
    ResolveMountOperationMethod "getIsTcryptHiddenVolume" o = Gio.MountOperation.MountOperationGetIsTcryptHiddenVolumeMethodInfo
    ResolveMountOperationMethod "getIsTcryptSystemVolume" o = Gio.MountOperation.MountOperationGetIsTcryptSystemVolumeMethodInfo
    ResolveMountOperationMethod "getParent" o = MountOperationGetParentMethodInfo
    ResolveMountOperationMethod "getPassword" o = Gio.MountOperation.MountOperationGetPasswordMethodInfo
    ResolveMountOperationMethod "getPasswordSave" o = Gio.MountOperation.MountOperationGetPasswordSaveMethodInfo
    ResolveMountOperationMethod "getPim" o = Gio.MountOperation.MountOperationGetPimMethodInfo
    ResolveMountOperationMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMountOperationMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMountOperationMethod "getUsername" o = Gio.MountOperation.MountOperationGetUsernameMethodInfo
    ResolveMountOperationMethod "setAnonymous" o = Gio.MountOperation.MountOperationSetAnonymousMethodInfo
    ResolveMountOperationMethod "setChoice" o = Gio.MountOperation.MountOperationSetChoiceMethodInfo
    ResolveMountOperationMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMountOperationMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMountOperationMethod "setDisplay" o = MountOperationSetDisplayMethodInfo
    ResolveMountOperationMethod "setDomain" o = Gio.MountOperation.MountOperationSetDomainMethodInfo
    ResolveMountOperationMethod "setIsTcryptHiddenVolume" o = Gio.MountOperation.MountOperationSetIsTcryptHiddenVolumeMethodInfo
    ResolveMountOperationMethod "setIsTcryptSystemVolume" o = Gio.MountOperation.MountOperationSetIsTcryptSystemVolumeMethodInfo
    ResolveMountOperationMethod "setParent" o = MountOperationSetParentMethodInfo
    ResolveMountOperationMethod "setPassword" o = Gio.MountOperation.MountOperationSetPasswordMethodInfo
    ResolveMountOperationMethod "setPasswordSave" o = Gio.MountOperation.MountOperationSetPasswordSaveMethodInfo
    ResolveMountOperationMethod "setPim" o = Gio.MountOperation.MountOperationSetPimMethodInfo
    ResolveMountOperationMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMountOperationMethod "setUsername" o = Gio.MountOperation.MountOperationSetUsernameMethodInfo
    ResolveMountOperationMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMountOperationMethod t MountOperation, O.OverloadedMethod info MountOperation p) => OL.IsLabel t (MountOperation -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMountOperationMethod t MountOperation, O.OverloadedMethod info MountOperation p, R.HasField t MountOperation p) => R.HasField t MountOperation p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMountOperationMethod t MountOperation, O.OverloadedMethodInfo info MountOperation) => OL.IsLabel t (O.MethodProxy info MountOperation) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mountOperation #display
-- @
getMountOperationDisplay :: (MonadIO m, IsMountOperation o) => o -> m Gdk.Display.Display
getMountOperationDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getMountOperationDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Set the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mountOperation [ #display 'Data.GI.Base.Attributes.:=' value ]
-- @
setMountOperationDisplay :: (MonadIO m, IsMountOperation o, Gdk.Display.IsDisplay a) => o -> a -> m ()
setMountOperationDisplay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "display" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMountOperationDisplay :: (IsMountOperation o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructMountOperationDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data MountOperationDisplayPropertyInfo
instance AttrInfo MountOperationDisplayPropertyInfo where
    type AttrAllowedOps MountOperationDisplayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MountOperationDisplayPropertyInfo = IsMountOperation
    type AttrSetTypeConstraint MountOperationDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint MountOperationDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType MountOperationDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType MountOperationDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel MountOperationDisplayPropertyInfo = "display"
    type AttrOrigin MountOperationDisplayPropertyInfo = MountOperation
    attrGet = getMountOperationDisplay
    attrSet = setMountOperationDisplay
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructMountOperationDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#g:attr:display"
        })
#endif

-- VVV Prop "is-showing"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@is-showing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mountOperation #isShowing
-- @
getMountOperationIsShowing :: (MonadIO m, IsMountOperation o) => o -> m Bool
getMountOperationIsShowing obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "is-showing"

#if defined(ENABLE_OVERLOADING)
data MountOperationIsShowingPropertyInfo
instance AttrInfo MountOperationIsShowingPropertyInfo where
    type AttrAllowedOps MountOperationIsShowingPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MountOperationIsShowingPropertyInfo = IsMountOperation
    type AttrSetTypeConstraint MountOperationIsShowingPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MountOperationIsShowingPropertyInfo = (~) ()
    type AttrTransferType MountOperationIsShowingPropertyInfo = ()
    type AttrGetType MountOperationIsShowingPropertyInfo = Bool
    type AttrLabel MountOperationIsShowingPropertyInfo = "is-showing"
    type AttrOrigin MountOperationIsShowingPropertyInfo = MountOperation
    attrGet = getMountOperationIsShowing
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.isShowing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#g:attr:isShowing"
        })
#endif

-- VVV Prop "parent"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Window"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@parent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mountOperation #parent
-- @
getMountOperationParent :: (MonadIO m, IsMountOperation o) => o -> m (Maybe Gtk.Window.Window)
getMountOperationParent obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "parent" Gtk.Window.Window

-- | Set the value of the “@parent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mountOperation [ #parent 'Data.GI.Base.Attributes.:=' value ]
-- @
setMountOperationParent :: (MonadIO m, IsMountOperation o, Gtk.Window.IsWindow a) => o -> a -> m ()
setMountOperationParent obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "parent" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@parent@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMountOperationParent :: (IsMountOperation o, MIO.MonadIO m, Gtk.Window.IsWindow a) => a -> m (GValueConstruct o)
constructMountOperationParent val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "parent" (P.Just val)

-- | Set the value of the “@parent@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #parent
-- @
clearMountOperationParent :: (MonadIO m, IsMountOperation o) => o -> m ()
clearMountOperationParent obj = liftIO $ B.Properties.setObjectPropertyObject obj "parent" (Nothing :: Maybe Gtk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data MountOperationParentPropertyInfo
instance AttrInfo MountOperationParentPropertyInfo where
    type AttrAllowedOps MountOperationParentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MountOperationParentPropertyInfo = IsMountOperation
    type AttrSetTypeConstraint MountOperationParentPropertyInfo = Gtk.Window.IsWindow
    type AttrTransferTypeConstraint MountOperationParentPropertyInfo = Gtk.Window.IsWindow
    type AttrTransferType MountOperationParentPropertyInfo = Gtk.Window.Window
    type AttrGetType MountOperationParentPropertyInfo = (Maybe Gtk.Window.Window)
    type AttrLabel MountOperationParentPropertyInfo = "parent"
    type AttrOrigin MountOperationParentPropertyInfo = MountOperation
    attrGet = getMountOperationParent
    attrSet = setMountOperationParent
    attrTransfer _ v = do
        unsafeCastTo Gtk.Window.Window v
    attrConstruct = constructMountOperationParent
    attrClear = clearMountOperationParent
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.parent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#g:attr:parent"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MountOperation
type instance O.AttributeList MountOperation = MountOperationAttributeList
type MountOperationAttributeList = ('[ '("anonymous", Gio.MountOperation.MountOperationAnonymousPropertyInfo), '("choice", Gio.MountOperation.MountOperationChoicePropertyInfo), '("display", MountOperationDisplayPropertyInfo), '("domain", Gio.MountOperation.MountOperationDomainPropertyInfo), '("isShowing", MountOperationIsShowingPropertyInfo), '("isTcryptHiddenVolume", Gio.MountOperation.MountOperationIsTcryptHiddenVolumePropertyInfo), '("isTcryptSystemVolume", Gio.MountOperation.MountOperationIsTcryptSystemVolumePropertyInfo), '("parent", MountOperationParentPropertyInfo), '("password", Gio.MountOperation.MountOperationPasswordPropertyInfo), '("passwordSave", Gio.MountOperation.MountOperationPasswordSavePropertyInfo), '("pim", Gio.MountOperation.MountOperationPimPropertyInfo), '("username", Gio.MountOperation.MountOperationUsernamePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
mountOperationDisplay :: AttrLabelProxy "display"
mountOperationDisplay = AttrLabelProxy

mountOperationParent :: AttrLabelProxy "parent"
mountOperationParent = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MountOperation = MountOperationSignalList
type MountOperationSignalList = ('[ '("aborted", Gio.MountOperation.MountOperationAbortedSignalInfo), '("askPassword", Gio.MountOperation.MountOperationAskPasswordSignalInfo), '("askQuestion", Gio.MountOperation.MountOperationAskQuestionSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("reply", Gio.MountOperation.MountOperationReplySignalInfo), '("showProcesses", Gio.MountOperation.MountOperationShowProcessesSignalInfo), '("showUnmountProgress", Gio.MountOperation.MountOperationShowUnmountProgressSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MountOperation::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transient parent of the window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "MountOperation" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mount_operation_new" gtk_mount_operation_new :: 
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr MountOperation)

-- | Creates a new @GtkMountOperation@.
mountOperationNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a) =>
    Maybe (a)
    -- ^ /@parent@/: transient parent of the window
    -> m MountOperation
    -- ^ __Returns:__ a new @GtkMountOperation@
mountOperationNew parent = liftIO $ do
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    result <- gtk_mount_operation_new maybeParent
    checkUnexpectedReturnNULL "mountOperationNew" result
    result' <- (wrapObject MountOperation) result
    whenJust parent touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MountOperation::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "op"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMountOperation`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mount_operation_get_display" gtk_mount_operation_get_display :: 
    Ptr MountOperation ->                   -- op : TInterface (Name {namespace = "Gtk", name = "MountOperation"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the display on which windows of the @GtkMountOperation@
-- will be shown.
mountOperationGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsMountOperation a) =>
    a
    -- ^ /@op@/: a @GtkMountOperation@
    -> m Gdk.Display.Display
    -- ^ __Returns:__ the display on which windows of /@op@/ are shown
mountOperationGetDisplay op = liftIO $ do
    op' <- unsafeManagedPtrCastPtr op
    result <- gtk_mount_operation_get_display op'
    checkUnexpectedReturnNULL "mountOperationGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr op
    return result'

#if defined(ENABLE_OVERLOADING)
data MountOperationGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsMountOperation a) => O.OverloadedMethod MountOperationGetDisplayMethodInfo a signature where
    overloadedMethod = mountOperationGetDisplay

instance O.OverloadedMethodInfo MountOperationGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.mountOperationGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#v:mountOperationGetDisplay"
        })


#endif

-- method MountOperation::get_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "op"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMountOperation`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mount_operation_get_parent" gtk_mount_operation_get_parent :: 
    Ptr MountOperation ->                   -- op : TInterface (Name {namespace = "Gtk", name = "MountOperation"})
    IO (Ptr Gtk.Window.Window)

-- | Gets the transient parent used by the @GtkMountOperation@.
mountOperationGetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsMountOperation a) =>
    a
    -- ^ /@op@/: a @GtkMountOperation@
    -> m (Maybe Gtk.Window.Window)
    -- ^ __Returns:__ the transient parent for windows shown by /@op@/
mountOperationGetParent op = liftIO $ do
    op' <- unsafeManagedPtrCastPtr op
    result <- gtk_mount_operation_get_parent op'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Window.Window) result'
        return result''
    touchManagedPtr op
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MountOperationGetParentMethodInfo
instance (signature ~ (m (Maybe Gtk.Window.Window)), MonadIO m, IsMountOperation a) => O.OverloadedMethod MountOperationGetParentMethodInfo a signature where
    overloadedMethod = mountOperationGetParent

instance O.OverloadedMethodInfo MountOperationGetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.mountOperationGetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#v:mountOperationGetParent"
        })


#endif

-- method MountOperation::is_showing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "op"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMountOperation`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mount_operation_is_showing" gtk_mount_operation_is_showing :: 
    Ptr MountOperation ->                   -- op : TInterface (Name {namespace = "Gtk", name = "MountOperation"})
    IO CInt

-- | Returns whether the @GtkMountOperation@ is currently displaying
-- a window.
mountOperationIsShowing ::
    (B.CallStack.HasCallStack, MonadIO m, IsMountOperation a) =>
    a
    -- ^ /@op@/: a @GtkMountOperation@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@op@/ is currently displaying a window
mountOperationIsShowing op = liftIO $ do
    op' <- unsafeManagedPtrCastPtr op
    result <- gtk_mount_operation_is_showing op'
    let result' = (/= 0) result
    touchManagedPtr op
    return result'

#if defined(ENABLE_OVERLOADING)
data MountOperationIsShowingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMountOperation a) => O.OverloadedMethod MountOperationIsShowingMethodInfo a signature where
    overloadedMethod = mountOperationIsShowing

instance O.OverloadedMethodInfo MountOperationIsShowingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.mountOperationIsShowing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#v:mountOperationIsShowing"
        })


#endif

-- method MountOperation::set_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "op"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMountOperation`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mount_operation_set_display" gtk_mount_operation_set_display :: 
    Ptr MountOperation ->                   -- op : TInterface (Name {namespace = "Gtk", name = "MountOperation"})
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Sets the display to show windows of the @GtkMountOperation@ on.
mountOperationSetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsMountOperation a, Gdk.Display.IsDisplay b) =>
    a
    -- ^ /@op@/: a @GtkMountOperation@
    -> b
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
mountOperationSetDisplay op display = liftIO $ do
    op' <- unsafeManagedPtrCastPtr op
    display' <- unsafeManagedPtrCastPtr display
    gtk_mount_operation_set_display op' display'
    touchManagedPtr op
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data MountOperationSetDisplayMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMountOperation a, Gdk.Display.IsDisplay b) => O.OverloadedMethod MountOperationSetDisplayMethodInfo a signature where
    overloadedMethod = mountOperationSetDisplay

instance O.OverloadedMethodInfo MountOperationSetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.mountOperationSetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#v:mountOperationSetDisplay"
        })


#endif

-- method MountOperation::set_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "op"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMountOperation`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transient parent of the window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mount_operation_set_parent" gtk_mount_operation_set_parent :: 
    Ptr MountOperation ->                   -- op : TInterface (Name {namespace = "Gtk", name = "MountOperation"})
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Sets the transient parent for windows shown by the
-- @GtkMountOperation@.
mountOperationSetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsMountOperation a, Gtk.Window.IsWindow b) =>
    a
    -- ^ /@op@/: a @GtkMountOperation@
    -> Maybe (b)
    -- ^ /@parent@/: transient parent of the window
    -> m ()
mountOperationSetParent op parent = liftIO $ do
    op' <- unsafeManagedPtrCastPtr op
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    gtk_mount_operation_set_parent op' maybeParent
    touchManagedPtr op
    whenJust parent touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MountOperationSetParentMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMountOperation a, Gtk.Window.IsWindow b) => O.OverloadedMethod MountOperationSetParentMethodInfo a signature where
    overloadedMethod = mountOperationSetParent

instance O.OverloadedMethodInfo MountOperationSetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MountOperation.mountOperationSetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MountOperation.html#v:mountOperationSetParent"
        })


#endif


