{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Triggers when a specific mnemonic is pressed.
-- 
-- Mnemonics require a *mnemonic modifier* (typically \<kbd>Alt\<\/kbd>) to be
-- pressed together with the mnemonic key.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MnemonicTrigger
    ( 

-- * Exported types
    MnemonicTrigger(..)                     ,
    IsMnemonicTrigger                       ,
    toMnemonicTrigger                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [compare]("GI.Gtk.Objects.ShortcutTrigger#g:method:compare"), [equal]("GI.Gtk.Objects.ShortcutTrigger#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gtk.Objects.ShortcutTrigger#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [print]("GI.Gtk.Objects.ShortcutTrigger#g:method:print"), [printLabel]("GI.Gtk.Objects.ShortcutTrigger#g:method:printLabel"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toLabel]("GI.Gtk.Objects.ShortcutTrigger#g:method:toLabel"), [toString]("GI.Gtk.Objects.ShortcutTrigger#g:method:toString"), [trigger]("GI.Gtk.Objects.ShortcutTrigger#g:method:trigger"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getKeyval]("GI.Gtk.Objects.MnemonicTrigger#g:method:getKeyval"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMnemonicTriggerMethod            ,
#endif

-- ** getKeyval #method:getKeyval#

#if defined(ENABLE_OVERLOADING)
    MnemonicTriggerGetKeyvalMethodInfo      ,
#endif
    mnemonicTriggerGetKeyval                ,


-- ** new #method:new#

    mnemonicTriggerNew                      ,




 -- * Properties


-- ** keyval #attr:keyval#
-- | The key value for the trigger.

#if defined(ENABLE_OVERLOADING)
    MnemonicTriggerKeyvalPropertyInfo       ,
#endif
    constructMnemonicTriggerKeyval          ,
    getMnemonicTriggerKeyval                ,
#if defined(ENABLE_OVERLOADING)
    mnemonicTriggerKeyval                   ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Enums as Gdk.Enums
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger

#endif

-- | Memory-managed wrapper type.
newtype MnemonicTrigger = MnemonicTrigger (SP.ManagedPtr MnemonicTrigger)
    deriving (Eq)

instance SP.ManagedPtrNewtype MnemonicTrigger where
    toManagedPtr (MnemonicTrigger p) = p

foreign import ccall "gtk_mnemonic_trigger_get_type"
    c_gtk_mnemonic_trigger_get_type :: IO B.Types.GType

instance B.Types.TypedObject MnemonicTrigger where
    glibType = c_gtk_mnemonic_trigger_get_type

instance B.Types.GObject MnemonicTrigger

-- | Type class for types which can be safely cast to `MnemonicTrigger`, for instance with `toMnemonicTrigger`.
class (SP.GObject o, O.IsDescendantOf MnemonicTrigger o) => IsMnemonicTrigger o
instance (SP.GObject o, O.IsDescendantOf MnemonicTrigger o) => IsMnemonicTrigger o

instance O.HasParentTypes MnemonicTrigger
type instance O.ParentTypes MnemonicTrigger = '[Gtk.ShortcutTrigger.ShortcutTrigger, GObject.Object.Object]

-- | Cast to `MnemonicTrigger`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMnemonicTrigger :: (MIO.MonadIO m, IsMnemonicTrigger o) => o -> m MnemonicTrigger
toMnemonicTrigger = MIO.liftIO . B.ManagedPtr.unsafeCastTo MnemonicTrigger

-- | Convert 'MnemonicTrigger' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MnemonicTrigger) where
    gvalueGType_ = c_gtk_mnemonic_trigger_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MnemonicTrigger)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MnemonicTrigger)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MnemonicTrigger ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMnemonicTriggerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMnemonicTriggerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMnemonicTriggerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMnemonicTriggerMethod "compare" o = Gtk.ShortcutTrigger.ShortcutTriggerCompareMethodInfo
    ResolveMnemonicTriggerMethod "equal" o = Gtk.ShortcutTrigger.ShortcutTriggerEqualMethodInfo
    ResolveMnemonicTriggerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMnemonicTriggerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMnemonicTriggerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMnemonicTriggerMethod "hash" o = Gtk.ShortcutTrigger.ShortcutTriggerHashMethodInfo
    ResolveMnemonicTriggerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMnemonicTriggerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMnemonicTriggerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMnemonicTriggerMethod "print" o = Gtk.ShortcutTrigger.ShortcutTriggerPrintMethodInfo
    ResolveMnemonicTriggerMethod "printLabel" o = Gtk.ShortcutTrigger.ShortcutTriggerPrintLabelMethodInfo
    ResolveMnemonicTriggerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMnemonicTriggerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMnemonicTriggerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMnemonicTriggerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMnemonicTriggerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMnemonicTriggerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMnemonicTriggerMethod "toLabel" o = Gtk.ShortcutTrigger.ShortcutTriggerToLabelMethodInfo
    ResolveMnemonicTriggerMethod "toString" o = Gtk.ShortcutTrigger.ShortcutTriggerToStringMethodInfo
    ResolveMnemonicTriggerMethod "trigger" o = Gtk.ShortcutTrigger.ShortcutTriggerTriggerMethodInfo
    ResolveMnemonicTriggerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMnemonicTriggerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMnemonicTriggerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMnemonicTriggerMethod "getKeyval" o = MnemonicTriggerGetKeyvalMethodInfo
    ResolveMnemonicTriggerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMnemonicTriggerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMnemonicTriggerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMnemonicTriggerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMnemonicTriggerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMnemonicTriggerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMnemonicTriggerMethod t MnemonicTrigger, O.OverloadedMethod info MnemonicTrigger p) => OL.IsLabel t (MnemonicTrigger -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMnemonicTriggerMethod t MnemonicTrigger, O.OverloadedMethod info MnemonicTrigger p, R.HasField t MnemonicTrigger p) => R.HasField t MnemonicTrigger p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMnemonicTriggerMethod t MnemonicTrigger, O.OverloadedMethodInfo info MnemonicTrigger) => OL.IsLabel t (O.MethodProxy info MnemonicTrigger) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "keyval"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@keyval@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mnemonicTrigger #keyval
-- @
getMnemonicTriggerKeyval :: (MonadIO m, IsMnemonicTrigger o) => o -> m Word32
getMnemonicTriggerKeyval obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "keyval"

-- | Construct a `GValueConstruct` with valid value for the “@keyval@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMnemonicTriggerKeyval :: (IsMnemonicTrigger o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructMnemonicTriggerKeyval val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "keyval" val

#if defined(ENABLE_OVERLOADING)
data MnemonicTriggerKeyvalPropertyInfo
instance AttrInfo MnemonicTriggerKeyvalPropertyInfo where
    type AttrAllowedOps MnemonicTriggerKeyvalPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MnemonicTriggerKeyvalPropertyInfo = IsMnemonicTrigger
    type AttrSetTypeConstraint MnemonicTriggerKeyvalPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint MnemonicTriggerKeyvalPropertyInfo = (~) Word32
    type AttrTransferType MnemonicTriggerKeyvalPropertyInfo = Word32
    type AttrGetType MnemonicTriggerKeyvalPropertyInfo = Word32
    type AttrLabel MnemonicTriggerKeyvalPropertyInfo = "keyval"
    type AttrOrigin MnemonicTriggerKeyvalPropertyInfo = MnemonicTrigger
    attrGet = getMnemonicTriggerKeyval
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructMnemonicTriggerKeyval
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MnemonicTrigger.keyval"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MnemonicTrigger.html#g:attr:keyval"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MnemonicTrigger
type instance O.AttributeList MnemonicTrigger = MnemonicTriggerAttributeList
type MnemonicTriggerAttributeList = ('[ '("keyval", MnemonicTriggerKeyvalPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
mnemonicTriggerKeyval :: AttrLabelProxy "keyval"
mnemonicTriggerKeyval = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MnemonicTrigger = MnemonicTriggerSignalList
type MnemonicTriggerSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MnemonicTrigger::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The keyval to trigger for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "MnemonicTrigger" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mnemonic_trigger_new" gtk_mnemonic_trigger_new :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO (Ptr MnemonicTrigger)

-- | Creates a @GtkShortcutTrigger@ that will trigger whenever the key with
-- the given /@keyval@/ is pressed and mnemonics have been activated.
-- 
-- Mnemonics are activated by calling code when a key event with the right
-- modifiers is detected.
mnemonicTriggerNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: The keyval to trigger for
    -> m MnemonicTrigger
    -- ^ __Returns:__ A new @GtkShortcutTrigger@
mnemonicTriggerNew keyval = liftIO $ do
    result <- gtk_mnemonic_trigger_new keyval
    checkUnexpectedReturnNULL "mnemonicTriggerNew" result
    result' <- (wrapObject MnemonicTrigger) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MnemonicTrigger::get_keyval
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MnemonicTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mnemonic `GtkShortcutTrigger`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mnemonic_trigger_get_keyval" gtk_mnemonic_trigger_get_keyval :: 
    Ptr MnemonicTrigger ->                  -- self : TInterface (Name {namespace = "Gtk", name = "MnemonicTrigger"})
    IO Word32

-- | Gets the keyval that must be pressed to succeed triggering /@self@/.
mnemonicTriggerGetKeyval ::
    (B.CallStack.HasCallStack, MonadIO m, IsMnemonicTrigger a) =>
    a
    -- ^ /@self@/: a mnemonic @GtkShortcutTrigger@
    -> m Word32
    -- ^ __Returns:__ the keyval
mnemonicTriggerGetKeyval self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_mnemonic_trigger_get_keyval self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data MnemonicTriggerGetKeyvalMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsMnemonicTrigger a) => O.OverloadedMethod MnemonicTriggerGetKeyvalMethodInfo a signature where
    overloadedMethod = mnemonicTriggerGetKeyval

instance O.OverloadedMethodInfo MnemonicTriggerGetKeyvalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MnemonicTrigger.mnemonicTriggerGetKeyval",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MnemonicTrigger.html#v:mnemonicTriggerGetKeyval"
        })


#endif


