{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Activates a widget with a mnemonic.
-- 
-- This means that 'GI.Gtk.Objects.Widget.widgetMnemonicActivate' is called.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MnemonicAction
    ( 

-- * Exported types
    MnemonicAction(..)                      ,
    IsMnemonicAction                        ,
    toMnemonicAction                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [activate]("GI.Gtk.Objects.ShortcutAction#g:method:activate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [print]("GI.Gtk.Objects.ShortcutAction#g:method:print"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gtk.Objects.ShortcutAction#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMnemonicActionMethod             ,
#endif

-- ** get #method:get#

    mnemonicActionGet                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction

#endif

-- | Memory-managed wrapper type.
newtype MnemonicAction = MnemonicAction (SP.ManagedPtr MnemonicAction)
    deriving (Eq)

instance SP.ManagedPtrNewtype MnemonicAction where
    toManagedPtr (MnemonicAction p) = p

foreign import ccall "gtk_mnemonic_action_get_type"
    c_gtk_mnemonic_action_get_type :: IO B.Types.GType

instance B.Types.TypedObject MnemonicAction where
    glibType = c_gtk_mnemonic_action_get_type

instance B.Types.GObject MnemonicAction

-- | Type class for types which can be safely cast to `MnemonicAction`, for instance with `toMnemonicAction`.
class (SP.GObject o, O.IsDescendantOf MnemonicAction o) => IsMnemonicAction o
instance (SP.GObject o, O.IsDescendantOf MnemonicAction o) => IsMnemonicAction o

instance O.HasParentTypes MnemonicAction
type instance O.ParentTypes MnemonicAction = '[Gtk.ShortcutAction.ShortcutAction, GObject.Object.Object]

-- | Cast to `MnemonicAction`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMnemonicAction :: (MIO.MonadIO m, IsMnemonicAction o) => o -> m MnemonicAction
toMnemonicAction = MIO.liftIO . B.ManagedPtr.unsafeCastTo MnemonicAction

-- | Convert 'MnemonicAction' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MnemonicAction) where
    gvalueGType_ = c_gtk_mnemonic_action_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MnemonicAction)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MnemonicAction)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MnemonicAction ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMnemonicActionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMnemonicActionMethod "activate" o = Gtk.ShortcutAction.ShortcutActionActivateMethodInfo
    ResolveMnemonicActionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMnemonicActionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMnemonicActionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMnemonicActionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMnemonicActionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMnemonicActionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMnemonicActionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMnemonicActionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMnemonicActionMethod "print" o = Gtk.ShortcutAction.ShortcutActionPrintMethodInfo
    ResolveMnemonicActionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMnemonicActionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMnemonicActionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMnemonicActionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMnemonicActionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMnemonicActionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMnemonicActionMethod "toString" o = Gtk.ShortcutAction.ShortcutActionToStringMethodInfo
    ResolveMnemonicActionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMnemonicActionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMnemonicActionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMnemonicActionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMnemonicActionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMnemonicActionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMnemonicActionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMnemonicActionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMnemonicActionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMnemonicActionMethod t MnemonicAction, O.OverloadedMethod info MnemonicAction p) => OL.IsLabel t (MnemonicAction -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMnemonicActionMethod t MnemonicAction, O.OverloadedMethod info MnemonicAction p, R.HasField t MnemonicAction p) => R.HasField t MnemonicAction p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMnemonicActionMethod t MnemonicAction, O.OverloadedMethodInfo info MnemonicAction) => OL.IsLabel t (O.MethodProxy info MnemonicAction) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MnemonicAction
type instance O.AttributeList MnemonicAction = MnemonicActionAttributeList
type MnemonicActionAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MnemonicAction = MnemonicActionSignalList
type MnemonicActionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MnemonicAction::get
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "MnemonicAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_mnemonic_action_get" gtk_mnemonic_action_get :: 
    IO (Ptr MnemonicAction)

-- | Gets the mnemonic action.
-- 
-- This is an action that calls 'GI.Gtk.Objects.Widget.widgetMnemonicActivate'
-- on the given widget upon activation.
mnemonicActionGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MnemonicAction
    -- ^ __Returns:__ The mnemonic action
mnemonicActionGet  = liftIO $ do
    result <- gtk_mnemonic_action_get
    checkUnexpectedReturnNULL "mnemonicActionGet" result
    result' <- (newObject MnemonicAction) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


