{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows controls for video playback.
-- 
-- \<picture>
--   \<source srcset=\"media-controls-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkMediaControls\" src=\"media-controls.png\">
-- \<\/picture>
-- 
-- Usually, @GtkMediaControls@ is used as part of t'GI.Gtk.Objects.Video.Video'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MediaControls
    ( 

-- * Exported types
    MediaControls(..)                       ,
    IsMediaControls                         ,
    toMediaControls                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMediaStream]("GI.Gtk.Objects.MediaControls#g:method:getMediaStream"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMediaStream]("GI.Gtk.Objects.MediaControls#g:method:setMediaStream"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveMediaControlsMethod              ,
#endif

-- ** getMediaStream #method:getMediaStream#

#if defined(ENABLE_OVERLOADING)
    MediaControlsGetMediaStreamMethodInfo   ,
#endif
    mediaControlsGetMediaStream             ,


-- ** new #method:new#

    mediaControlsNew                        ,


-- ** setMediaStream #method:setMediaStream#

#if defined(ENABLE_OVERLOADING)
    MediaControlsSetMediaStreamMethodInfo   ,
#endif
    mediaControlsSetMediaStream             ,




 -- * Properties


-- ** mediaStream #attr:mediaStream#
-- | The media-stream managed by this object or 'P.Nothing' if none.

#if defined(ENABLE_OVERLOADING)
    MediaControlsMediaStreamPropertyInfo    ,
#endif
    clearMediaControlsMediaStream           ,
    constructMediaControlsMediaStream       ,
    getMediaControlsMediaStream             ,
#if defined(ENABLE_OVERLOADING)
    mediaControlsMediaStream                ,
#endif
    setMediaControlsMediaStream             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.MediaStream as Gtk.MediaStream
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.MediaStream as Gtk.MediaStream
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype MediaControls = MediaControls (SP.ManagedPtr MediaControls)
    deriving (Eq)

instance SP.ManagedPtrNewtype MediaControls where
    toManagedPtr (MediaControls p) = p

foreign import ccall "gtk_media_controls_get_type"
    c_gtk_media_controls_get_type :: IO B.Types.GType

instance B.Types.TypedObject MediaControls where
    glibType = c_gtk_media_controls_get_type

instance B.Types.GObject MediaControls

-- | Type class for types which can be safely cast to `MediaControls`, for instance with `toMediaControls`.
class (SP.GObject o, O.IsDescendantOf MediaControls o) => IsMediaControls o
instance (SP.GObject o, O.IsDescendantOf MediaControls o) => IsMediaControls o

instance O.HasParentTypes MediaControls
type instance O.ParentTypes MediaControls = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `MediaControls`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMediaControls :: (MIO.MonadIO m, IsMediaControls o) => o -> m MediaControls
toMediaControls = MIO.liftIO . B.ManagedPtr.unsafeCastTo MediaControls

-- | Convert 'MediaControls' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MediaControls) where
    gvalueGType_ = c_gtk_media_controls_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MediaControls)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MediaControls)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MediaControls ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMediaControlsMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMediaControlsMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveMediaControlsMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveMediaControlsMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveMediaControlsMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveMediaControlsMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveMediaControlsMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveMediaControlsMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveMediaControlsMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveMediaControlsMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveMediaControlsMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveMediaControlsMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMediaControlsMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMediaControlsMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveMediaControlsMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveMediaControlsMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveMediaControlsMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveMediaControlsMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveMediaControlsMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveMediaControlsMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveMediaControlsMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveMediaControlsMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveMediaControlsMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveMediaControlsMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveMediaControlsMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMediaControlsMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMediaControlsMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMediaControlsMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveMediaControlsMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveMediaControlsMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveMediaControlsMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveMediaControlsMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveMediaControlsMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveMediaControlsMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveMediaControlsMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveMediaControlsMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveMediaControlsMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveMediaControlsMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveMediaControlsMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveMediaControlsMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveMediaControlsMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMediaControlsMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveMediaControlsMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveMediaControlsMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveMediaControlsMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveMediaControlsMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveMediaControlsMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveMediaControlsMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveMediaControlsMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveMediaControlsMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMediaControlsMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMediaControlsMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveMediaControlsMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveMediaControlsMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveMediaControlsMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveMediaControlsMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveMediaControlsMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveMediaControlsMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveMediaControlsMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMediaControlsMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMediaControlsMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveMediaControlsMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveMediaControlsMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveMediaControlsMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveMediaControlsMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveMediaControlsMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveMediaControlsMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveMediaControlsMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMediaControlsMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveMediaControlsMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveMediaControlsMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveMediaControlsMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveMediaControlsMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMediaControlsMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMediaControlsMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMediaControlsMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveMediaControlsMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveMediaControlsMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveMediaControlsMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveMediaControlsMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveMediaControlsMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMediaControlsMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveMediaControlsMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveMediaControlsMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveMediaControlsMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveMediaControlsMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveMediaControlsMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveMediaControlsMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMediaControlsMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveMediaControlsMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveMediaControlsMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveMediaControlsMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveMediaControlsMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveMediaControlsMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveMediaControlsMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveMediaControlsMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveMediaControlsMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveMediaControlsMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveMediaControlsMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveMediaControlsMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveMediaControlsMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveMediaControlsMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveMediaControlsMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveMediaControlsMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveMediaControlsMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveMediaControlsMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveMediaControlsMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveMediaControlsMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMediaControlsMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveMediaControlsMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveMediaControlsMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveMediaControlsMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveMediaControlsMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveMediaControlsMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveMediaControlsMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveMediaControlsMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveMediaControlsMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveMediaControlsMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveMediaControlsMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveMediaControlsMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveMediaControlsMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveMediaControlsMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveMediaControlsMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveMediaControlsMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveMediaControlsMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveMediaControlsMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveMediaControlsMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveMediaControlsMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveMediaControlsMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveMediaControlsMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveMediaControlsMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveMediaControlsMethod "getMediaStream" o = MediaControlsGetMediaStreamMethodInfo
    ResolveMediaControlsMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveMediaControlsMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveMediaControlsMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveMediaControlsMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveMediaControlsMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveMediaControlsMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveMediaControlsMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveMediaControlsMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveMediaControlsMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveMediaControlsMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveMediaControlsMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveMediaControlsMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveMediaControlsMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMediaControlsMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMediaControlsMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveMediaControlsMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveMediaControlsMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveMediaControlsMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveMediaControlsMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveMediaControlsMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveMediaControlsMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveMediaControlsMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveMediaControlsMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveMediaControlsMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveMediaControlsMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveMediaControlsMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveMediaControlsMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveMediaControlsMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveMediaControlsMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveMediaControlsMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveMediaControlsMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveMediaControlsMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveMediaControlsMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveMediaControlsMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveMediaControlsMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveMediaControlsMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveMediaControlsMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveMediaControlsMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveMediaControlsMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveMediaControlsMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveMediaControlsMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMediaControlsMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMediaControlsMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveMediaControlsMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveMediaControlsMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveMediaControlsMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveMediaControlsMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveMediaControlsMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveMediaControlsMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveMediaControlsMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveMediaControlsMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveMediaControlsMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveMediaControlsMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveMediaControlsMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveMediaControlsMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveMediaControlsMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveMediaControlsMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveMediaControlsMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveMediaControlsMethod "setMediaStream" o = MediaControlsSetMediaStreamMethodInfo
    ResolveMediaControlsMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveMediaControlsMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveMediaControlsMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveMediaControlsMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveMediaControlsMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMediaControlsMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveMediaControlsMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveMediaControlsMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveMediaControlsMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveMediaControlsMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveMediaControlsMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveMediaControlsMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveMediaControlsMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveMediaControlsMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveMediaControlsMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveMediaControlsMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMediaControlsMethod t MediaControls, O.OverloadedMethod info MediaControls p) => OL.IsLabel t (MediaControls -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMediaControlsMethod t MediaControls, O.OverloadedMethod info MediaControls p, R.HasField t MediaControls p) => R.HasField t MediaControls p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMediaControlsMethod t MediaControls, O.OverloadedMethodInfo info MediaControls) => OL.IsLabel t (O.MethodProxy info MediaControls) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "media-stream"
   -- Type: TInterface (Name {namespace = "Gtk", name = "MediaStream"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@media-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mediaControls #mediaStream
-- @
getMediaControlsMediaStream :: (MonadIO m, IsMediaControls o) => o -> m (Maybe Gtk.MediaStream.MediaStream)
getMediaControlsMediaStream obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "media-stream" Gtk.MediaStream.MediaStream

-- | Set the value of the “@media-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' mediaControls [ #mediaStream 'Data.GI.Base.Attributes.:=' value ]
-- @
setMediaControlsMediaStream :: (MonadIO m, IsMediaControls o, Gtk.MediaStream.IsMediaStream a) => o -> a -> m ()
setMediaControlsMediaStream obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "media-stream" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@media-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMediaControlsMediaStream :: (IsMediaControls o, MIO.MonadIO m, Gtk.MediaStream.IsMediaStream a) => a -> m (GValueConstruct o)
constructMediaControlsMediaStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "media-stream" (P.Just val)

-- | Set the value of the “@media-stream@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #mediaStream
-- @
clearMediaControlsMediaStream :: (MonadIO m, IsMediaControls o) => o -> m ()
clearMediaControlsMediaStream obj = liftIO $ B.Properties.setObjectPropertyObject obj "media-stream" (Nothing :: Maybe Gtk.MediaStream.MediaStream)

#if defined(ENABLE_OVERLOADING)
data MediaControlsMediaStreamPropertyInfo
instance AttrInfo MediaControlsMediaStreamPropertyInfo where
    type AttrAllowedOps MediaControlsMediaStreamPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MediaControlsMediaStreamPropertyInfo = IsMediaControls
    type AttrSetTypeConstraint MediaControlsMediaStreamPropertyInfo = Gtk.MediaStream.IsMediaStream
    type AttrTransferTypeConstraint MediaControlsMediaStreamPropertyInfo = Gtk.MediaStream.IsMediaStream
    type AttrTransferType MediaControlsMediaStreamPropertyInfo = Gtk.MediaStream.MediaStream
    type AttrGetType MediaControlsMediaStreamPropertyInfo = (Maybe Gtk.MediaStream.MediaStream)
    type AttrLabel MediaControlsMediaStreamPropertyInfo = "media-stream"
    type AttrOrigin MediaControlsMediaStreamPropertyInfo = MediaControls
    attrGet = getMediaControlsMediaStream
    attrSet = setMediaControlsMediaStream
    attrTransfer _ v = do
        unsafeCastTo Gtk.MediaStream.MediaStream v
    attrConstruct = constructMediaControlsMediaStream
    attrClear = clearMediaControlsMediaStream
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaControls.mediaStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MediaControls.html#g:attr:mediaStream"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MediaControls
type instance O.AttributeList MediaControls = MediaControlsAttributeList
type MediaControlsAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("mediaStream", MediaControlsMediaStreamPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
mediaControlsMediaStream :: AttrLabelProxy "mediaStream"
mediaControlsMediaStream = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MediaControls = MediaControlsSignalList
type MediaControlsSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MediaControls::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream` to manage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "MediaControls" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_controls_new" gtk_media_controls_new :: 
    Ptr Gtk.MediaStream.MediaStream ->      -- stream : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO (Ptr MediaControls)

-- | Creates a new @GtkMediaControls@ managing the /@stream@/ passed to it.
mediaControlsNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.MediaStream.IsMediaStream a) =>
    Maybe (a)
    -- ^ /@stream@/: a @GtkMediaStream@ to manage
    -> m MediaControls
    -- ^ __Returns:__ a new @GtkMediaControls@
mediaControlsNew stream = liftIO $ do
    maybeStream <- case stream of
        Nothing -> return FP.nullPtr
        Just jStream -> do
            jStream' <- unsafeManagedPtrCastPtr jStream
            return jStream'
    result <- gtk_media_controls_new maybeStream
    checkUnexpectedReturnNULL "mediaControlsNew" result
    result' <- (newObject MediaControls) result
    whenJust stream touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MediaControls::get_media_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controls"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaControls`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MediaStream" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_controls_get_media_stream" gtk_media_controls_get_media_stream :: 
    Ptr MediaControls ->                    -- controls : TInterface (Name {namespace = "Gtk", name = "MediaControls"})
    IO (Ptr Gtk.MediaStream.MediaStream)

-- | Gets the media stream managed by /@controls@/ or 'P.Nothing' if none.
mediaControlsGetMediaStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaControls a) =>
    a
    -- ^ /@controls@/: a @GtkMediaControls@
    -> m (Maybe Gtk.MediaStream.MediaStream)
    -- ^ __Returns:__ The media stream managed by /@controls@/
mediaControlsGetMediaStream controls = liftIO $ do
    controls' <- unsafeManagedPtrCastPtr controls
    result <- gtk_media_controls_get_media_stream controls'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.MediaStream.MediaStream) result'
        return result''
    touchManagedPtr controls
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MediaControlsGetMediaStreamMethodInfo
instance (signature ~ (m (Maybe Gtk.MediaStream.MediaStream)), MonadIO m, IsMediaControls a) => O.OverloadedMethod MediaControlsGetMediaStreamMethodInfo a signature where
    overloadedMethod = mediaControlsGetMediaStream

instance O.OverloadedMethodInfo MediaControlsGetMediaStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaControls.mediaControlsGetMediaStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MediaControls.html#v:mediaControlsGetMediaStream"
        })


#endif

-- method MediaControls::set_media_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controls"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaControls` widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_media_controls_set_media_stream" gtk_media_controls_set_media_stream :: 
    Ptr MediaControls ->                    -- controls : TInterface (Name {namespace = "Gtk", name = "MediaControls"})
    Ptr Gtk.MediaStream.MediaStream ->      -- stream : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Sets the stream that is controlled by /@controls@/.
mediaControlsSetMediaStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsMediaControls a, Gtk.MediaStream.IsMediaStream b) =>
    a
    -- ^ /@controls@/: a @GtkMediaControls@ widget
    -> Maybe (b)
    -- ^ /@stream@/: a @GtkMediaStream@
    -> m ()
mediaControlsSetMediaStream controls stream = liftIO $ do
    controls' <- unsafeManagedPtrCastPtr controls
    maybeStream <- case stream of
        Nothing -> return FP.nullPtr
        Just jStream -> do
            jStream' <- unsafeManagedPtrCastPtr jStream
            return jStream'
    gtk_media_controls_set_media_stream controls' maybeStream
    touchManagedPtr controls
    whenJust stream touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MediaControlsSetMediaStreamMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMediaControls a, Gtk.MediaStream.IsMediaStream b) => O.OverloadedMethod MediaControlsSetMediaStreamMethodInfo a signature where
    overloadedMethod = mediaControlsSetMediaStream

instance O.OverloadedMethodInfo MediaControlsSetMediaStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MediaControls.mediaControlsSetMediaStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MediaControls.html#v:mediaControlsSetMediaStream"
        })


#endif


