{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A list model that maps the items in another model to different items.
-- 
-- @GtkMapListModel@ uses a [callback/@gtk@/.MapListModelMapFunc].
-- 
-- Example: Create a list of @GtkEventControllers@
-- 
-- === /c code/
-- >static gpointer
-- >map_to_controllers (gpointer widget,
-- >                    gpointer data)
-- >{
-- >  gpointer result = gtk_widget_observe_controllers (widget);
-- >  g_object_unref (widget);
-- >  return result;
-- >}
-- >
-- >widgets = gtk_widget_observe_children (widget);
-- >
-- >controllers = gtk_map_list_model_new (widgets,
-- >                                      map_to_controllers,
-- >                                      NULL, NULL);
-- >
-- >model = gtk_flatten_list_model_new (GTK_TYPE_EVENT_CONTROLLER,
-- >                                    controllers);
-- 
-- 
-- @GtkMapListModel@ will attempt to discard the mapped objects as soon as
-- they are no longer needed and recreate them if necessary.
-- 
-- @GtkMapListModel@ passes through sections from the underlying model.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MapListModel
    ( 

-- * Exported types
    MapListModel(..)                        ,
    IsMapListModel                          ,
    toMapListModel                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasMap]("GI.Gtk.Objects.MapListModel#g:method:hasMap"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:method:sectionsChanged"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getModel]("GI.Gtk.Objects.MapListModel#g:method:getModel"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSection]("GI.Gtk.Interfaces.SectionModel#g:method:getSection").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setMapFunc]("GI.Gtk.Objects.MapListModel#g:method:setMapFunc"), [setModel]("GI.Gtk.Objects.MapListModel#g:method:setModel"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMapListModelMethod               ,
#endif

-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    MapListModelGetModelMethodInfo          ,
#endif
    mapListModelGetModel                    ,


-- ** hasMap #method:hasMap#

#if defined(ENABLE_OVERLOADING)
    MapListModelHasMapMethodInfo            ,
#endif
    mapListModelHasMap                      ,


-- ** new #method:new#

    mapListModelNew                         ,


-- ** setMapFunc #method:setMapFunc#

#if defined(ENABLE_OVERLOADING)
    MapListModelSetMapFuncMethodInfo        ,
#endif
    mapListModelSetMapFunc                  ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    MapListModelSetModelMethodInfo          ,
#endif
    mapListModelSetModel                    ,




 -- * Properties


-- ** hasMap #attr:hasMap#
-- | If a map is set for this model

#if defined(ENABLE_OVERLOADING)
    MapListModelHasMapPropertyInfo          ,
#endif
    getMapListModelHasMap                   ,


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MapListModelItemTypePropertyInfo        ,
#endif
    getMapListModelItemType                 ,
#if defined(ENABLE_OVERLOADING)
    mapListModelItemType                    ,
#endif


-- ** model #attr:model#
-- | The model being mapped.

#if defined(ENABLE_OVERLOADING)
    MapListModelModelPropertyInfo           ,
#endif
    constructMapListModelModel              ,
    getMapListModelModel                    ,
#if defined(ENABLE_OVERLOADING)
    mapListModelModel                       ,
#endif


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MapListModelNItemsPropertyInfo          ,
#endif
    getMapListModelNItems                   ,
#if defined(ENABLE_OVERLOADING)
    mapListModelNItems                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel

#endif

-- | Memory-managed wrapper type.
newtype MapListModel = MapListModel (SP.ManagedPtr MapListModel)
    deriving (Eq)

instance SP.ManagedPtrNewtype MapListModel where
    toManagedPtr (MapListModel p) = p

foreign import ccall "gtk_map_list_model_get_type"
    c_gtk_map_list_model_get_type :: IO B.Types.GType

instance B.Types.TypedObject MapListModel where
    glibType = c_gtk_map_list_model_get_type

instance B.Types.GObject MapListModel

-- | Type class for types which can be safely cast to `MapListModel`, for instance with `toMapListModel`.
class (SP.GObject o, O.IsDescendantOf MapListModel o) => IsMapListModel o
instance (SP.GObject o, O.IsDescendantOf MapListModel o) => IsMapListModel o

instance O.HasParentTypes MapListModel
type instance O.ParentTypes MapListModel = '[GObject.Object.Object, Gio.ListModel.ListModel, Gtk.SectionModel.SectionModel]

-- | Cast to `MapListModel`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMapListModel :: (MIO.MonadIO m, IsMapListModel o) => o -> m MapListModel
toMapListModel = MIO.liftIO . B.ManagedPtr.unsafeCastTo MapListModel

-- | Convert 'MapListModel' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MapListModel) where
    gvalueGType_ = c_gtk_map_list_model_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MapListModel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MapListModel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MapListModel ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMapListModelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMapListModelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMapListModelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMapListModelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMapListModelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMapListModelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMapListModelMethod "hasMap" o = MapListModelHasMapMethodInfo
    ResolveMapListModelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMapListModelMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveMapListModelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMapListModelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMapListModelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMapListModelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMapListModelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMapListModelMethod "sectionsChanged" o = Gtk.SectionModel.SectionModelSectionsChangedMethodInfo
    ResolveMapListModelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMapListModelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMapListModelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMapListModelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMapListModelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMapListModelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMapListModelMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveMapListModelMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveMapListModelMethod "getModel" o = MapListModelGetModelMethodInfo
    ResolveMapListModelMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveMapListModelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMapListModelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMapListModelMethod "getSection" o = Gtk.SectionModel.SectionModelGetSectionMethodInfo
    ResolveMapListModelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMapListModelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMapListModelMethod "setMapFunc" o = MapListModelSetMapFuncMethodInfo
    ResolveMapListModelMethod "setModel" o = MapListModelSetModelMethodInfo
    ResolveMapListModelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMapListModelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMapListModelMethod t MapListModel, O.OverloadedMethod info MapListModel p) => OL.IsLabel t (MapListModel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMapListModelMethod t MapListModel, O.OverloadedMethod info MapListModel p, R.HasField t MapListModel p) => R.HasField t MapListModel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMapListModelMethod t MapListModel, O.OverloadedMethodInfo info MapListModel) => OL.IsLabel t (O.MethodProxy info MapListModel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "has-map"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@has-map@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mapListModel #hasMap
-- @
getMapListModelHasMap :: (MonadIO m, IsMapListModel o) => o -> m Bool
getMapListModelHasMap obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-map"

#if defined(ENABLE_OVERLOADING)
data MapListModelHasMapPropertyInfo
instance AttrInfo MapListModelHasMapPropertyInfo where
    type AttrAllowedOps MapListModelHasMapPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MapListModelHasMapPropertyInfo = IsMapListModel
    type AttrSetTypeConstraint MapListModelHasMapPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MapListModelHasMapPropertyInfo = (~) ()
    type AttrTransferType MapListModelHasMapPropertyInfo = ()
    type AttrGetType MapListModelHasMapPropertyInfo = Bool
    type AttrLabel MapListModelHasMapPropertyInfo = "has-map"
    type AttrOrigin MapListModelHasMapPropertyInfo = MapListModel
    attrGet = getMapListModelHasMap
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.hasMap"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#g:attr:hasMap"
        })
#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mapListModel #itemType
-- @
getMapListModelItemType :: (MonadIO m, IsMapListModel o) => o -> m GType
getMapListModelItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data MapListModelItemTypePropertyInfo
instance AttrInfo MapListModelItemTypePropertyInfo where
    type AttrAllowedOps MapListModelItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MapListModelItemTypePropertyInfo = IsMapListModel
    type AttrSetTypeConstraint MapListModelItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MapListModelItemTypePropertyInfo = (~) ()
    type AttrTransferType MapListModelItemTypePropertyInfo = ()
    type AttrGetType MapListModelItemTypePropertyInfo = GType
    type AttrLabel MapListModelItemTypePropertyInfo = "item-type"
    type AttrOrigin MapListModelItemTypePropertyInfo = MapListModel
    attrGet = getMapListModelItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#g:attr:itemType"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mapListModel #model
-- @
getMapListModelModel :: (MonadIO m, IsMapListModel o) => o -> m (Maybe Gio.ListModel.ListModel)
getMapListModelModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gio.ListModel.ListModel

-- | Construct a `GValueConstruct` with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMapListModelModel :: (IsMapListModel o, MIO.MonadIO m, Gio.ListModel.IsListModel a) => a -> m (GValueConstruct o)
constructMapListModelModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data MapListModelModelPropertyInfo
instance AttrInfo MapListModelModelPropertyInfo where
    type AttrAllowedOps MapListModelModelPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MapListModelModelPropertyInfo = IsMapListModel
    type AttrSetTypeConstraint MapListModelModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferTypeConstraint MapListModelModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferType MapListModelModelPropertyInfo = Gio.ListModel.ListModel
    type AttrGetType MapListModelModelPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel MapListModelModelPropertyInfo = "model"
    type AttrOrigin MapListModelModelPropertyInfo = MapListModel
    attrGet = getMapListModelModel
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.ListModel.ListModel v
    attrConstruct = constructMapListModelModel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#g:attr:model"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' mapListModel #nItems
-- @
getMapListModelNItems :: (MonadIO m, IsMapListModel o) => o -> m Word32
getMapListModelNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data MapListModelNItemsPropertyInfo
instance AttrInfo MapListModelNItemsPropertyInfo where
    type AttrAllowedOps MapListModelNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MapListModelNItemsPropertyInfo = IsMapListModel
    type AttrSetTypeConstraint MapListModelNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MapListModelNItemsPropertyInfo = (~) ()
    type AttrTransferType MapListModelNItemsPropertyInfo = ()
    type AttrGetType MapListModelNItemsPropertyInfo = Word32
    type AttrLabel MapListModelNItemsPropertyInfo = "n-items"
    type AttrOrigin MapListModelNItemsPropertyInfo = MapListModel
    attrGet = getMapListModelNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MapListModel
type instance O.AttributeList MapListModel = MapListModelAttributeList
type MapListModelAttributeList = ('[ '("hasMap", MapListModelHasMapPropertyInfo), '("itemType", MapListModelItemTypePropertyInfo), '("model", MapListModelModelPropertyInfo), '("nItems", MapListModelNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
mapListModelItemType :: AttrLabelProxy "itemType"
mapListModelItemType = AttrLabelProxy

mapListModelModel :: AttrLabelProxy "model"
mapListModelModel = AttrLabelProxy

mapListModelNItems :: AttrLabelProxy "nItems"
mapListModelNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MapListModel = MapListModelSignalList
type MapListModelSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sectionsChanged", Gtk.SectionModel.SectionModelSectionsChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MapListModel::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The model to map" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "map_func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "MapListModelMapFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "map function" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @map_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notifier for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "MapListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_map_list_model_new" gtk_map_list_model_new :: 
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    FunPtr Gtk.Callbacks.C_MapListModelMapFunc -> -- map_func : TInterface (Name {namespace = "Gtk", name = "MapListModelMapFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr MapListModel)

-- | Creates a new @GtkMapListModel@ for the given arguments.
mapListModelNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.ListModel.IsListModel a) =>
    Maybe (a)
    -- ^ /@model@/: The model to map
    -> Maybe (Gtk.Callbacks.MapListModelMapFunc)
    -- ^ /@mapFunc@/: map function
    -> m MapListModel
    -- ^ __Returns:__ a new @GtkMapListModel@
mapListModelNew model mapFunc = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    maybeMapFunc <- case mapFunc of
        Nothing -> return FP.nullFunPtr
        Just jMapFunc -> do
            jMapFunc' <- Gtk.Callbacks.mk_MapListModelMapFunc (Gtk.Callbacks.wrap_MapListModelMapFunc Nothing (Gtk.Callbacks.drop_closures_MapListModelMapFunc jMapFunc))
            return jMapFunc'
    let userData = castFunPtrToPtr maybeMapFunc
    let userDestroy = SP.safeFreeFunPtrPtr
    result <- gtk_map_list_model_new maybeModel maybeMapFunc userData userDestroy
    checkUnexpectedReturnNULL "mapListModelNew" result
    result' <- (wrapObject MapListModel) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MapListModel::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MapListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMapListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_map_list_model_get_model" gtk_map_list_model_get_model :: 
    Ptr MapListModel ->                     -- self : TInterface (Name {namespace = "Gtk", name = "MapListModel"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Gets the model that is currently being mapped or 'P.Nothing' if none.
mapListModelGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMapListModel a) =>
    a
    -- ^ /@self@/: a @GtkMapListModel@
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model that gets mapped
mapListModelGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_map_list_model_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MapListModelGetModelMethodInfo
instance (signature ~ (m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsMapListModel a) => O.OverloadedMethod MapListModelGetModelMethodInfo a signature where
    overloadedMethod = mapListModelGetModel

instance O.OverloadedMethodInfo MapListModelGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.mapListModelGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#v:mapListModelGetModel"
        })


#endif

-- method MapListModel::has_map
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MapListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMapListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_map_list_model_has_map" gtk_map_list_model_has_map :: 
    Ptr MapListModel ->                     -- self : TInterface (Name {namespace = "Gtk", name = "MapListModel"})
    IO CInt

-- | Checks if a map function is currently set on /@self@/.
mapListModelHasMap ::
    (B.CallStack.HasCallStack, MonadIO m, IsMapListModel a) =>
    a
    -- ^ /@self@/: a @GtkMapListModel@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if a map function is set
mapListModelHasMap self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_map_list_model_has_map self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data MapListModelHasMapMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMapListModel a) => O.OverloadedMethod MapListModelHasMapMethodInfo a signature where
    overloadedMethod = mapListModelHasMap

instance O.OverloadedMethodInfo MapListModelHasMapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.mapListModelHasMap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#v:mapListModelHasMap"
        })


#endif

-- method MapListModel::set_map_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MapListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMapListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "map_func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "MapListModelMapFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "map function" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @map_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notifier for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_map_list_model_set_map_func" gtk_map_list_model_set_map_func :: 
    Ptr MapListModel ->                     -- self : TInterface (Name {namespace = "Gtk", name = "MapListModel"})
    FunPtr Gtk.Callbacks.C_MapListModelMapFunc -> -- map_func : TInterface (Name {namespace = "Gtk", name = "MapListModelMapFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets the function used to map items.
-- 
-- The function will be called whenever an item needs to be mapped
-- and must return the item to use for the given input item.
-- 
-- Note that @GtkMapListModel@ may call this function multiple times
-- on the same item, because it may delete items it doesn\'t need anymore.
-- 
-- GTK makes no effort to ensure that /@mapFunc@/ conforms to the item type
-- of /@self@/. It assumes that the caller knows what they are doing and the map
-- function returns items of the appropriate type.
mapListModelSetMapFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsMapListModel a) =>
    a
    -- ^ /@self@/: a @GtkMapListModel@
    -> Maybe (Gtk.Callbacks.MapListModelMapFunc)
    -- ^ /@mapFunc@/: map function
    -> m ()
mapListModelSetMapFunc self mapFunc = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeMapFunc <- case mapFunc of
        Nothing -> return FP.nullFunPtr
        Just jMapFunc -> do
            jMapFunc' <- Gtk.Callbacks.mk_MapListModelMapFunc (Gtk.Callbacks.wrap_MapListModelMapFunc Nothing (Gtk.Callbacks.drop_closures_MapListModelMapFunc jMapFunc))
            return jMapFunc'
    let userData = castFunPtrToPtr maybeMapFunc
    let userDestroy = SP.safeFreeFunPtrPtr
    gtk_map_list_model_set_map_func self' maybeMapFunc userData userDestroy
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MapListModelSetMapFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.MapListModelMapFunc) -> m ()), MonadIO m, IsMapListModel a) => O.OverloadedMethod MapListModelSetMapFuncMethodInfo a signature where
    overloadedMethod = mapListModelSetMapFunc

instance O.OverloadedMethodInfo MapListModelSetMapFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.mapListModelSetMapFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#v:mapListModelSetMapFunc"
        })


#endif

-- method MapListModel::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MapListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMapListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The model to be mapped"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_map_list_model_set_model" gtk_map_list_model_set_model :: 
    Ptr MapListModel ->                     -- self : TInterface (Name {namespace = "Gtk", name = "MapListModel"})
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO ()

-- | Sets the model to be mapped.
-- 
-- GTK makes no effort to ensure that /@model@/ conforms to the item type
-- expected by the map function. It assumes that the caller knows what
-- they are doing and have set up an appropriate map function.
mapListModelSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMapListModel a, Gio.ListModel.IsListModel b) =>
    a
    -- ^ /@self@/: a @GtkMapListModel@
    -> Maybe (b)
    -- ^ /@model@/: The model to be mapped
    -> m ()
mapListModelSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_map_list_model_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MapListModelSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMapListModel a, Gio.ListModel.IsListModel b) => O.OverloadedMethod MapListModelSetModelMethodInfo a signature where
    overloadedMethod = mapListModelSetModel

instance O.OverloadedMethodInfo MapListModelSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MapListModel.mapListModelSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-MapListModel.html#v:mapListModelSetModel"
        })


#endif


