{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Presents a large dynamic list of items.
-- 
-- @GtkListView@ uses its factory to generate one row widget for each visible
-- item and shows them in a linear display, either vertically or horizontally.
-- 
-- The [ListView:showSeparators]("GI.Gtk.Objects.ListView#g:attr:showSeparators") property offers a simple way to
-- display separators between the rows.
-- 
-- @GtkListView@ allows the user to select items according to the selection
-- characteristics of the model. For models that allow multiple selected items,
-- it is possible to turn on _rubberband selection_, using
-- [ListView:enableRubberband]("GI.Gtk.Objects.ListView#g:attr:enableRubberband").
-- 
-- If you need multiple columns with headers, see t'GI.Gtk.Objects.ColumnView.ColumnView'.
-- 
-- To learn more about the list widget framework, see the
-- <https://docs.gtk.org/gtk4/section-list-widget.html overview>.
-- 
-- An example of using @GtkListView@:
-- 
-- === /c code/
-- >static void
-- >setup_listitem_cb (GtkListItemFactory *factory,
-- >                   GtkListItem        *list_item)
-- >{
-- >  GtkWidget *image;
-- >
-- >  image = gtk_image_new ();
-- >  gtk_image_set_icon_size (GTK_IMAGE (image), GTK_ICON_SIZE_LARGE);
-- >  gtk_list_item_set_child (list_item, image);
-- >}
-- >
-- >static void
-- >bind_listitem_cb (GtkListItemFactory *factory,
-- >                  GtkListItem        *list_item)
-- >{
-- >  GtkWidget *image;
-- >  GAppInfo *app_info;
-- >
-- >  image = gtk_list_item_get_child (list_item);
-- >  app_info = gtk_list_item_get_item (list_item);
-- >  gtk_image_set_from_gicon (GTK_IMAGE (image), g_app_info_get_icon (app_info));
-- >}
-- >
-- >static void
-- >activate_cb (GtkListView  *list,
-- >             guint         position,
-- >             gpointer      unused)
-- >{
-- >  GAppInfo *app_info;
-- >
-- >  app_info = g_list_model_get_item (G_LIST_MODEL (gtk_list_view_get_model (list)), position);
-- >  g_app_info_launch (app_info, NULL, NULL, NULL);
-- >  g_object_unref (app_info);
-- >}
-- >
-- >...
-- >
-- >  model = create_application_list ();
-- >
-- >  factory = gtk_signal_list_item_factory_new ();
-- >  g_signal_connect (factory, "setup", G_CALLBACK (setup_listitem_cb), NULL);
-- >  g_signal_connect (factory, "bind", G_CALLBACK (bind_listitem_cb), NULL);
-- >
-- >  list = gtk_list_view_new (GTK_SELECTION_MODEL (gtk_single_selection_new (model)), factory);
-- >
-- >  g_signal_connect (list, "activate", G_CALLBACK (activate_cb), NULL);
-- >
-- >  gtk_scrolled_window_set_child (GTK_SCROLLED_WINDOW (sw), list);
-- 
-- 
-- = Actions
-- 
-- @GtkListView@ defines a set of built-in actions:
-- 
-- * @list.activate-item@ activates the item at given position by emitting
-- the [ListView::activate]("GI.Gtk.Objects.ListView#g:signal:activate") signal.
-- 
-- 
-- = CSS nodes
-- 
-- >listview[.separators][.rich-list][.navigation-sidebar][.data-table]
-- >├── row[.activatable]
-- >│
-- >├── row[.activatable]
-- >│
-- >┊
-- >╰── [rubberband]
-- 
-- 
-- @GtkListView@ uses a single CSS node named @listview@. It may carry the
-- @.separators@ style class, when [ListView:showSeparators]("GI.Gtk.Objects.ListView#g:attr:showSeparators")
-- property is set. Each child widget uses a single CSS node named @row@.
-- If the [ListItem:activatable]("GI.Gtk.Objects.ListItem#g:attr:activatable") property is set, the
-- corresponding row will have the @.activatable@ style class. For
-- rubberband selection, a node with name @rubberband@ is used.
-- 
-- The main listview node may also carry style classes to select
-- the style of <https://docs.gtk.org/gtk4/ListContainers.html#list-styles list presentation>:
-- .rich-list, .navigation-sidebar or .data-table.
-- 
-- = Accessibility
-- 
-- @GtkListView@ uses the [enum/@gtk@/.AccessibleRole.list] role, and the list
-- items use the [enum/@gtk@/.AccessibleRole.list_item] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ListView
    ( 

-- * Exported types
    ListView(..)                            ,
    IsListView                              ,
    toListView                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scrollTo]("GI.Gtk.Objects.ListView#g:method:scrollTo"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBorder]("GI.Gtk.Interfaces.Scrollable#g:method:getBorder"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEnableRubberband]("GI.Gtk.Objects.ListView#g:method:getEnableRubberband"), [getFactory]("GI.Gtk.Objects.ListView#g:method:getFactory"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getHadjustment"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeaderFactory]("GI.Gtk.Objects.ListView#g:method:getHeaderFactory"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getHscrollPolicy"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getModel]("GI.Gtk.Objects.ListView#g:method:getModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowSeparators]("GI.Gtk.Objects.ListView#g:method:getShowSeparators"), [getSingleClickActivate]("GI.Gtk.Objects.ListView#g:method:getSingleClickActivate"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTabBehavior]("GI.Gtk.Objects.ListView#g:method:getTabBehavior"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getVadjustment"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getVscrollPolicy"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEnableRubberband]("GI.Gtk.Objects.ListView#g:method:setEnableRubberband"), [setFactory]("GI.Gtk.Objects.ListView#g:method:setFactory"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setHadjustment"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHeaderFactory]("GI.Gtk.Objects.ListView#g:method:setHeaderFactory"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setHscrollPolicy"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setModel]("GI.Gtk.Objects.ListView#g:method:setModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowSeparators]("GI.Gtk.Objects.ListView#g:method:setShowSeparators"), [setSingleClickActivate]("GI.Gtk.Objects.ListView#g:method:setSingleClickActivate"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTabBehavior]("GI.Gtk.Objects.ListView#g:method:setTabBehavior"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setVadjustment"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setVscrollPolicy").

#if defined(ENABLE_OVERLOADING)
    ResolveListViewMethod                   ,
#endif

-- ** getEnableRubberband #method:getEnableRubberband#

#if defined(ENABLE_OVERLOADING)
    ListViewGetEnableRubberbandMethodInfo   ,
#endif
    listViewGetEnableRubberband             ,


-- ** getFactory #method:getFactory#

#if defined(ENABLE_OVERLOADING)
    ListViewGetFactoryMethodInfo            ,
#endif
    listViewGetFactory                      ,


-- ** getHeaderFactory #method:getHeaderFactory#

#if defined(ENABLE_OVERLOADING)
    ListViewGetHeaderFactoryMethodInfo      ,
#endif
    listViewGetHeaderFactory                ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    ListViewGetModelMethodInfo              ,
#endif
    listViewGetModel                        ,


-- ** getShowSeparators #method:getShowSeparators#

#if defined(ENABLE_OVERLOADING)
    ListViewGetShowSeparatorsMethodInfo     ,
#endif
    listViewGetShowSeparators               ,


-- ** getSingleClickActivate #method:getSingleClickActivate#

#if defined(ENABLE_OVERLOADING)
    ListViewGetSingleClickActivateMethodInfo,
#endif
    listViewGetSingleClickActivate          ,


-- ** getTabBehavior #method:getTabBehavior#

#if defined(ENABLE_OVERLOADING)
    ListViewGetTabBehaviorMethodInfo        ,
#endif
    listViewGetTabBehavior                  ,


-- ** new #method:new#

    listViewNew                             ,


-- ** scrollTo #method:scrollTo#

#if defined(ENABLE_OVERLOADING)
    ListViewScrollToMethodInfo              ,
#endif
    listViewScrollTo                        ,


-- ** setEnableRubberband #method:setEnableRubberband#

#if defined(ENABLE_OVERLOADING)
    ListViewSetEnableRubberbandMethodInfo   ,
#endif
    listViewSetEnableRubberband             ,


-- ** setFactory #method:setFactory#

#if defined(ENABLE_OVERLOADING)
    ListViewSetFactoryMethodInfo            ,
#endif
    listViewSetFactory                      ,


-- ** setHeaderFactory #method:setHeaderFactory#

#if defined(ENABLE_OVERLOADING)
    ListViewSetHeaderFactoryMethodInfo      ,
#endif
    listViewSetHeaderFactory                ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    ListViewSetModelMethodInfo              ,
#endif
    listViewSetModel                        ,


-- ** setShowSeparators #method:setShowSeparators#

#if defined(ENABLE_OVERLOADING)
    ListViewSetShowSeparatorsMethodInfo     ,
#endif
    listViewSetShowSeparators               ,


-- ** setSingleClickActivate #method:setSingleClickActivate#

#if defined(ENABLE_OVERLOADING)
    ListViewSetSingleClickActivateMethodInfo,
#endif
    listViewSetSingleClickActivate          ,


-- ** setTabBehavior #method:setTabBehavior#

#if defined(ENABLE_OVERLOADING)
    ListViewSetTabBehaviorMethodInfo        ,
#endif
    listViewSetTabBehavior                  ,




 -- * Properties


-- ** enableRubberband #attr:enableRubberband#
-- | Allow rubberband selection.

#if defined(ENABLE_OVERLOADING)
    ListViewEnableRubberbandPropertyInfo    ,
#endif
    constructListViewEnableRubberband       ,
    getListViewEnableRubberband             ,
#if defined(ENABLE_OVERLOADING)
    listViewEnableRubberband                ,
#endif
    setListViewEnableRubberband             ,


-- ** factory #attr:factory#
-- | Factory for populating list items.
-- 
-- The factory must be for configuring t'GI.Gtk.Objects.ListItem.ListItem' objects.

#if defined(ENABLE_OVERLOADING)
    ListViewFactoryPropertyInfo             ,
#endif
    clearListViewFactory                    ,
    constructListViewFactory                ,
    getListViewFactory                      ,
#if defined(ENABLE_OVERLOADING)
    listViewFactory                         ,
#endif
    setListViewFactory                      ,


-- ** headerFactory #attr:headerFactory#
-- | Factory for creating header widgets.
-- 
-- The factory must be for configuring t'GI.Gtk.Objects.ListHeader.ListHeader' objects.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ListViewHeaderFactoryPropertyInfo       ,
#endif
    clearListViewHeaderFactory              ,
    constructListViewHeaderFactory          ,
    getListViewHeaderFactory                ,
#if defined(ENABLE_OVERLOADING)
    listViewHeaderFactory                   ,
#endif
    setListViewHeaderFactory                ,


-- ** model #attr:model#
-- | Model for the items displayed.

#if defined(ENABLE_OVERLOADING)
    ListViewModelPropertyInfo               ,
#endif
    clearListViewModel                      ,
    constructListViewModel                  ,
    getListViewModel                        ,
#if defined(ENABLE_OVERLOADING)
    listViewModel                           ,
#endif
    setListViewModel                        ,


-- ** showSeparators #attr:showSeparators#
-- | Show separators between rows.

#if defined(ENABLE_OVERLOADING)
    ListViewShowSeparatorsPropertyInfo      ,
#endif
    constructListViewShowSeparators         ,
    getListViewShowSeparators               ,
#if defined(ENABLE_OVERLOADING)
    listViewShowSeparators                  ,
#endif
    setListViewShowSeparators               ,


-- ** singleClickActivate #attr:singleClickActivate#
-- | Activate rows on single click and select them on hover.

#if defined(ENABLE_OVERLOADING)
    ListViewSingleClickActivatePropertyInfo ,
#endif
    constructListViewSingleClickActivate    ,
    getListViewSingleClickActivate          ,
#if defined(ENABLE_OVERLOADING)
    listViewSingleClickActivate             ,
#endif
    setListViewSingleClickActivate          ,


-- ** tabBehavior #attr:tabBehavior#
-- | Behavior of the \<kbd>Tab\<\/kbd> key
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ListViewTabBehaviorPropertyInfo         ,
#endif
    constructListViewTabBehavior            ,
    getListViewTabBehavior                  ,
#if defined(ENABLE_OVERLOADING)
    listViewTabBehavior                     ,
#endif
    setListViewTabBehavior                  ,




 -- * Signals


-- ** activate #signal:activate#

    ListViewActivateCallback                ,
#if defined(ENABLE_OVERLOADING)
    ListViewActivateSignalInfo              ,
#endif
    afterListViewActivate                   ,
    onListViewActivate                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBase as Gtk.ListBase
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.ScrollInfo as Gtk.ScrollInfo
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBase as Gtk.ListBase
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.ScrollInfo as Gtk.ScrollInfo

#endif

-- | Memory-managed wrapper type.
newtype ListView = ListView (SP.ManagedPtr ListView)
    deriving (Eq)

instance SP.ManagedPtrNewtype ListView where
    toManagedPtr (ListView p) = p

foreign import ccall "gtk_list_view_get_type"
    c_gtk_list_view_get_type :: IO B.Types.GType

instance B.Types.TypedObject ListView where
    glibType = c_gtk_list_view_get_type

instance B.Types.GObject ListView

-- | Type class for types which can be safely cast to `ListView`, for instance with `toListView`.
class (SP.GObject o, O.IsDescendantOf ListView o) => IsListView o
instance (SP.GObject o, O.IsDescendantOf ListView o) => IsListView o

instance O.HasParentTypes ListView
type instance O.ParentTypes ListView = '[Gtk.ListBase.ListBase, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable, Gtk.Scrollable.Scrollable]

-- | Cast to `ListView`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toListView :: (MIO.MonadIO m, IsListView o) => o -> m ListView
toListView = MIO.liftIO . B.ManagedPtr.unsafeCastTo ListView

-- | Convert 'ListView' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ListView) where
    gvalueGType_ = c_gtk_list_view_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ListView)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ListView)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ListView ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveListViewMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveListViewMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveListViewMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveListViewMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveListViewMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveListViewMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveListViewMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveListViewMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveListViewMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveListViewMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveListViewMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveListViewMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveListViewMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveListViewMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveListViewMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveListViewMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveListViewMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveListViewMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveListViewMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveListViewMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveListViewMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveListViewMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveListViewMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveListViewMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveListViewMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveListViewMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveListViewMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveListViewMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveListViewMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveListViewMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveListViewMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveListViewMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveListViewMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveListViewMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveListViewMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveListViewMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveListViewMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveListViewMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveListViewMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveListViewMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveListViewMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveListViewMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveListViewMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveListViewMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveListViewMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveListViewMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveListViewMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveListViewMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveListViewMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveListViewMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveListViewMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveListViewMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveListViewMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveListViewMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveListViewMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveListViewMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveListViewMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveListViewMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveListViewMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveListViewMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveListViewMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveListViewMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveListViewMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveListViewMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveListViewMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveListViewMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveListViewMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveListViewMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveListViewMethod "scrollTo" o = ListViewScrollToMethodInfo
    ResolveListViewMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveListViewMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveListViewMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveListViewMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveListViewMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveListViewMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveListViewMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveListViewMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveListViewMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveListViewMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveListViewMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveListViewMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveListViewMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveListViewMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveListViewMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveListViewMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveListViewMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveListViewMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveListViewMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveListViewMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveListViewMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveListViewMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveListViewMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveListViewMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveListViewMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveListViewMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveListViewMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveListViewMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveListViewMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveListViewMethod "getBorder" o = Gtk.Scrollable.ScrollableGetBorderMethodInfo
    ResolveListViewMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveListViewMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveListViewMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveListViewMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveListViewMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveListViewMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveListViewMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveListViewMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveListViewMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveListViewMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveListViewMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveListViewMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveListViewMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveListViewMethod "getEnableRubberband" o = ListViewGetEnableRubberbandMethodInfo
    ResolveListViewMethod "getFactory" o = ListViewGetFactoryMethodInfo
    ResolveListViewMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveListViewMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveListViewMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveListViewMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveListViewMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveListViewMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveListViewMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveListViewMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveListViewMethod "getHadjustment" o = Gtk.Scrollable.ScrollableGetHadjustmentMethodInfo
    ResolveListViewMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveListViewMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveListViewMethod "getHeaderFactory" o = ListViewGetHeaderFactoryMethodInfo
    ResolveListViewMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveListViewMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveListViewMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveListViewMethod "getHscrollPolicy" o = Gtk.Scrollable.ScrollableGetHscrollPolicyMethodInfo
    ResolveListViewMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveListViewMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveListViewMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveListViewMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveListViewMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveListViewMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveListViewMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveListViewMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveListViewMethod "getModel" o = ListViewGetModelMethodInfo
    ResolveListViewMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveListViewMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveListViewMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveListViewMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveListViewMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveListViewMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveListViewMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveListViewMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveListViewMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveListViewMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveListViewMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveListViewMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveListViewMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveListViewMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveListViewMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveListViewMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveListViewMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveListViewMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveListViewMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveListViewMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveListViewMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveListViewMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveListViewMethod "getShowSeparators" o = ListViewGetShowSeparatorsMethodInfo
    ResolveListViewMethod "getSingleClickActivate" o = ListViewGetSingleClickActivateMethodInfo
    ResolveListViewMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveListViewMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveListViewMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveListViewMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveListViewMethod "getTabBehavior" o = ListViewGetTabBehaviorMethodInfo
    ResolveListViewMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveListViewMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveListViewMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveListViewMethod "getVadjustment" o = Gtk.Scrollable.ScrollableGetVadjustmentMethodInfo
    ResolveListViewMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveListViewMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveListViewMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveListViewMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveListViewMethod "getVscrollPolicy" o = Gtk.Scrollable.ScrollableGetVscrollPolicyMethodInfo
    ResolveListViewMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveListViewMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveListViewMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveListViewMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveListViewMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveListViewMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveListViewMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveListViewMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveListViewMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveListViewMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveListViewMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveListViewMethod "setEnableRubberband" o = ListViewSetEnableRubberbandMethodInfo
    ResolveListViewMethod "setFactory" o = ListViewSetFactoryMethodInfo
    ResolveListViewMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveListViewMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveListViewMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveListViewMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveListViewMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveListViewMethod "setHadjustment" o = Gtk.Scrollable.ScrollableSetHadjustmentMethodInfo
    ResolveListViewMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveListViewMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveListViewMethod "setHeaderFactory" o = ListViewSetHeaderFactoryMethodInfo
    ResolveListViewMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveListViewMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveListViewMethod "setHscrollPolicy" o = Gtk.Scrollable.ScrollableSetHscrollPolicyMethodInfo
    ResolveListViewMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveListViewMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveListViewMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveListViewMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveListViewMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveListViewMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveListViewMethod "setModel" o = ListViewSetModelMethodInfo
    ResolveListViewMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveListViewMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveListViewMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveListViewMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveListViewMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveListViewMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveListViewMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveListViewMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveListViewMethod "setShowSeparators" o = ListViewSetShowSeparatorsMethodInfo
    ResolveListViewMethod "setSingleClickActivate" o = ListViewSetSingleClickActivateMethodInfo
    ResolveListViewMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveListViewMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveListViewMethod "setTabBehavior" o = ListViewSetTabBehaviorMethodInfo
    ResolveListViewMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveListViewMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveListViewMethod "setVadjustment" o = Gtk.Scrollable.ScrollableSetVadjustmentMethodInfo
    ResolveListViewMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveListViewMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveListViewMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveListViewMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveListViewMethod "setVscrollPolicy" o = Gtk.Scrollable.ScrollableSetVscrollPolicyMethodInfo
    ResolveListViewMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveListViewMethod t ListView, O.OverloadedMethod info ListView p) => OL.IsLabel t (ListView -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveListViewMethod t ListView, O.OverloadedMethod info ListView p, R.HasField t ListView p) => R.HasField t ListView p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveListViewMethod t ListView, O.OverloadedMethodInfo info ListView) => OL.IsLabel t (O.MethodProxy info ListView) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ListView::activate
-- | Emitted when a row has been activated by the user.
-- 
-- Activation usually happens via the list.activate-item action of
-- the @GtkListView@.
-- 
-- This allows for a convenient way to handle activation in a listview.
-- See 'GI.Gtk.Objects.ListItem.listItemSetActivatable' for details on how to use
-- this signal.
type ListViewActivateCallback =
    Word32
    -- ^ /@position@/: position of item to activate
    -> IO ()

type C_ListViewActivateCallback =
    Ptr ListView ->                         -- object
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListViewActivateCallback`.
foreign import ccall "wrapper"
    mk_ListViewActivateCallback :: C_ListViewActivateCallback -> IO (FunPtr C_ListViewActivateCallback)

wrap_ListViewActivateCallback :: 
    GObject a => (a -> ListViewActivateCallback) ->
    C_ListViewActivateCallback
wrap_ListViewActivateCallback gi'cb gi'selfPtr position _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  position


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listView #activate callback
-- @
-- 
-- 
onListViewActivate :: (IsListView a, MonadIO m) => a -> ((?self :: a) => ListViewActivateCallback) -> m SignalHandlerId
onListViewActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListViewActivateCallback wrapped
    wrapped'' <- mk_ListViewActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listView #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListViewActivate :: (IsListView a, MonadIO m) => a -> ((?self :: a) => ListViewActivateCallback) -> m SignalHandlerId
afterListViewActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListViewActivateCallback wrapped
    wrapped'' <- mk_ListViewActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListViewActivateSignalInfo
instance SignalInfo ListViewActivateSignalInfo where
    type HaskellCallbackType ListViewActivateSignalInfo = ListViewActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListViewActivateCallback cb
        cb'' <- mk_ListViewActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:signal:activate"})

#endif

--- XXX Duplicated object with different types:
  --- Name {namespace = "Gtk", name = "ListBase"} -> Property {propName = "orientation", propType = TInterface (Name {namespace = "Gtk", name = "Orientation"}), propFlags = [PropertyReadable,PropertyWritable], propReadNullable = Nothing, propWriteNullable = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The orientation of the list. See GtkOrientable:orientation\nfor details.", sinceVersion = Nothing}, propDeprecated = Nothing}
  --- Name {namespace = "Gtk", name = "Orientable"} -> Property {propName = "orientation", propType = TInterface (Name {namespace = "Gtk", name = "Orientation"}), propFlags = [PropertyReadable,PropertyWritable], propReadNullable = Just False, propWriteNullable = Just False, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The orientation of the orientable.", sinceVersion = Nothing}, propDeprecated = Nothing}
-- VVV Prop "enable-rubberband"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@enable-rubberband@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listView #enableRubberband
-- @
getListViewEnableRubberband :: (MonadIO m, IsListView o) => o -> m Bool
getListViewEnableRubberband obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enable-rubberband"

-- | Set the value of the “@enable-rubberband@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listView [ #enableRubberband 'Data.GI.Base.Attributes.:=' value ]
-- @
setListViewEnableRubberband :: (MonadIO m, IsListView o) => o -> Bool -> m ()
setListViewEnableRubberband obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enable-rubberband" val

-- | Construct a `GValueConstruct` with valid value for the “@enable-rubberband@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListViewEnableRubberband :: (IsListView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListViewEnableRubberband val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enable-rubberband" val

#if defined(ENABLE_OVERLOADING)
data ListViewEnableRubberbandPropertyInfo
instance AttrInfo ListViewEnableRubberbandPropertyInfo where
    type AttrAllowedOps ListViewEnableRubberbandPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ListViewEnableRubberbandPropertyInfo = IsListView
    type AttrSetTypeConstraint ListViewEnableRubberbandPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListViewEnableRubberbandPropertyInfo = (~) Bool
    type AttrTransferType ListViewEnableRubberbandPropertyInfo = Bool
    type AttrGetType ListViewEnableRubberbandPropertyInfo = Bool
    type AttrLabel ListViewEnableRubberbandPropertyInfo = "enable-rubberband"
    type AttrOrigin ListViewEnableRubberbandPropertyInfo = ListView
    attrGet = getListViewEnableRubberband
    attrSet = setListViewEnableRubberband
    attrTransfer _ v = do
        return v
    attrConstruct = constructListViewEnableRubberband
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.enableRubberband"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:attr:enableRubberband"
        })
#endif

-- VVV Prop "factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listView #factory
-- @
getListViewFactory :: (MonadIO m, IsListView o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getListViewFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listView [ #factory 'Data.GI.Base.Attributes.:=' value ]
-- @
setListViewFactory :: (MonadIO m, IsListView o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setListViewFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "factory" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListViewFactory :: (IsListView o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructListViewFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "factory" (P.Just val)

-- | Set the value of the “@factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #factory
-- @
clearListViewFactory :: (MonadIO m, IsListView o) => o -> m ()
clearListViewFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data ListViewFactoryPropertyInfo
instance AttrInfo ListViewFactoryPropertyInfo where
    type AttrAllowedOps ListViewFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ListViewFactoryPropertyInfo = IsListView
    type AttrSetTypeConstraint ListViewFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint ListViewFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType ListViewFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType ListViewFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel ListViewFactoryPropertyInfo = "factory"
    type AttrOrigin ListViewFactoryPropertyInfo = ListView
    attrGet = getListViewFactory
    attrSet = setListViewFactory
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructListViewFactory
    attrClear = clearListViewFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.factory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:attr:factory"
        })
#endif

-- VVV Prop "header-factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@header-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listView #headerFactory
-- @
getListViewHeaderFactory :: (MonadIO m, IsListView o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getListViewHeaderFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "header-factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@header-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listView [ #headerFactory 'Data.GI.Base.Attributes.:=' value ]
-- @
setListViewHeaderFactory :: (MonadIO m, IsListView o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setListViewHeaderFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "header-factory" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@header-factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListViewHeaderFactory :: (IsListView o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructListViewHeaderFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "header-factory" (P.Just val)

-- | Set the value of the “@header-factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #headerFactory
-- @
clearListViewHeaderFactory :: (MonadIO m, IsListView o) => o -> m ()
clearListViewHeaderFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "header-factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data ListViewHeaderFactoryPropertyInfo
instance AttrInfo ListViewHeaderFactoryPropertyInfo where
    type AttrAllowedOps ListViewHeaderFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ListViewHeaderFactoryPropertyInfo = IsListView
    type AttrSetTypeConstraint ListViewHeaderFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint ListViewHeaderFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType ListViewHeaderFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType ListViewHeaderFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel ListViewHeaderFactoryPropertyInfo = "header-factory"
    type AttrOrigin ListViewHeaderFactoryPropertyInfo = ListView
    attrGet = getListViewHeaderFactory
    attrSet = setListViewHeaderFactory
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructListViewHeaderFactory
    attrClear = clearListViewHeaderFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.headerFactory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:attr:headerFactory"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listView #model
-- @
getListViewModel :: (MonadIO m, IsListView o) => o -> m (Maybe Gtk.SelectionModel.SelectionModel)
getListViewModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gtk.SelectionModel.SelectionModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listView [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setListViewModel :: (MonadIO m, IsListView o, Gtk.SelectionModel.IsSelectionModel a) => o -> a -> m ()
setListViewModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListViewModel :: (IsListView o, MIO.MonadIO m, Gtk.SelectionModel.IsSelectionModel a) => a -> m (GValueConstruct o)
constructListViewModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearListViewModel :: (MonadIO m, IsListView o) => o -> m ()
clearListViewModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gtk.SelectionModel.SelectionModel)

#if defined(ENABLE_OVERLOADING)
data ListViewModelPropertyInfo
instance AttrInfo ListViewModelPropertyInfo where
    type AttrAllowedOps ListViewModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ListViewModelPropertyInfo = IsListView
    type AttrSetTypeConstraint ListViewModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferTypeConstraint ListViewModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferType ListViewModelPropertyInfo = Gtk.SelectionModel.SelectionModel
    type AttrGetType ListViewModelPropertyInfo = (Maybe Gtk.SelectionModel.SelectionModel)
    type AttrLabel ListViewModelPropertyInfo = "model"
    type AttrOrigin ListViewModelPropertyInfo = ListView
    attrGet = getListViewModel
    attrSet = setListViewModel
    attrTransfer _ v = do
        unsafeCastTo Gtk.SelectionModel.SelectionModel v
    attrConstruct = constructListViewModel
    attrClear = clearListViewModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:attr:model"
        })
#endif

-- VVV Prop "show-separators"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listView #showSeparators
-- @
getListViewShowSeparators :: (MonadIO m, IsListView o) => o -> m Bool
getListViewShowSeparators obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-separators"

-- | Set the value of the “@show-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listView [ #showSeparators 'Data.GI.Base.Attributes.:=' value ]
-- @
setListViewShowSeparators :: (MonadIO m, IsListView o) => o -> Bool -> m ()
setListViewShowSeparators obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-separators" val

-- | Construct a `GValueConstruct` with valid value for the “@show-separators@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListViewShowSeparators :: (IsListView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListViewShowSeparators val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-separators" val

#if defined(ENABLE_OVERLOADING)
data ListViewShowSeparatorsPropertyInfo
instance AttrInfo ListViewShowSeparatorsPropertyInfo where
    type AttrAllowedOps ListViewShowSeparatorsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ListViewShowSeparatorsPropertyInfo = IsListView
    type AttrSetTypeConstraint ListViewShowSeparatorsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListViewShowSeparatorsPropertyInfo = (~) Bool
    type AttrTransferType ListViewShowSeparatorsPropertyInfo = Bool
    type AttrGetType ListViewShowSeparatorsPropertyInfo = Bool
    type AttrLabel ListViewShowSeparatorsPropertyInfo = "show-separators"
    type AttrOrigin ListViewShowSeparatorsPropertyInfo = ListView
    attrGet = getListViewShowSeparators
    attrSet = setListViewShowSeparators
    attrTransfer _ v = do
        return v
    attrConstruct = constructListViewShowSeparators
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.showSeparators"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:attr:showSeparators"
        })
#endif

-- VVV Prop "single-click-activate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@single-click-activate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listView #singleClickActivate
-- @
getListViewSingleClickActivate :: (MonadIO m, IsListView o) => o -> m Bool
getListViewSingleClickActivate obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "single-click-activate"

-- | Set the value of the “@single-click-activate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listView [ #singleClickActivate 'Data.GI.Base.Attributes.:=' value ]
-- @
setListViewSingleClickActivate :: (MonadIO m, IsListView o) => o -> Bool -> m ()
setListViewSingleClickActivate obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "single-click-activate" val

-- | Construct a `GValueConstruct` with valid value for the “@single-click-activate@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListViewSingleClickActivate :: (IsListView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListViewSingleClickActivate val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "single-click-activate" val

#if defined(ENABLE_OVERLOADING)
data ListViewSingleClickActivatePropertyInfo
instance AttrInfo ListViewSingleClickActivatePropertyInfo where
    type AttrAllowedOps ListViewSingleClickActivatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ListViewSingleClickActivatePropertyInfo = IsListView
    type AttrSetTypeConstraint ListViewSingleClickActivatePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListViewSingleClickActivatePropertyInfo = (~) Bool
    type AttrTransferType ListViewSingleClickActivatePropertyInfo = Bool
    type AttrGetType ListViewSingleClickActivatePropertyInfo = Bool
    type AttrLabel ListViewSingleClickActivatePropertyInfo = "single-click-activate"
    type AttrOrigin ListViewSingleClickActivatePropertyInfo = ListView
    attrGet = getListViewSingleClickActivate
    attrSet = setListViewSingleClickActivate
    attrTransfer _ v = do
        return v
    attrConstruct = constructListViewSingleClickActivate
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.singleClickActivate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:attr:singleClickActivate"
        })
#endif

-- VVV Prop "tab-behavior"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listView #tabBehavior
-- @
getListViewTabBehavior :: (MonadIO m, IsListView o) => o -> m Gtk.Enums.ListTabBehavior
getListViewTabBehavior obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "tab-behavior"

-- | Set the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listView [ #tabBehavior 'Data.GI.Base.Attributes.:=' value ]
-- @
setListViewTabBehavior :: (MonadIO m, IsListView o) => o -> Gtk.Enums.ListTabBehavior -> m ()
setListViewTabBehavior obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "tab-behavior" val

-- | Construct a `GValueConstruct` with valid value for the “@tab-behavior@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListViewTabBehavior :: (IsListView o, MIO.MonadIO m) => Gtk.Enums.ListTabBehavior -> m (GValueConstruct o)
constructListViewTabBehavior val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "tab-behavior" val

#if defined(ENABLE_OVERLOADING)
data ListViewTabBehaviorPropertyInfo
instance AttrInfo ListViewTabBehaviorPropertyInfo where
    type AttrAllowedOps ListViewTabBehaviorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ListViewTabBehaviorPropertyInfo = IsListView
    type AttrSetTypeConstraint ListViewTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferTypeConstraint ListViewTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferType ListViewTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrGetType ListViewTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrLabel ListViewTabBehaviorPropertyInfo = "tab-behavior"
    type AttrOrigin ListViewTabBehaviorPropertyInfo = ListView
    attrGet = getListViewTabBehavior
    attrSet = setListViewTabBehavior
    attrTransfer _ v = do
        return v
    attrConstruct = constructListViewTabBehavior
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.tabBehavior"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#g:attr:tabBehavior"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ListView
type instance O.AttributeList ListView = ListViewAttributeList
type ListViewAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("enableRubberband", ListViewEnableRubberbandPropertyInfo), '("factory", ListViewFactoryPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("hadjustment", Gtk.Scrollable.ScrollableHadjustmentPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("headerFactory", ListViewHeaderFactoryPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hscrollPolicy", Gtk.Scrollable.ScrollableHscrollPolicyPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("model", ListViewModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.ListBase.ListBaseOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showSeparators", ListViewShowSeparatorsPropertyInfo), '("singleClickActivate", ListViewSingleClickActivatePropertyInfo), '("tabBehavior", ListViewTabBehaviorPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("vadjustment", Gtk.Scrollable.ScrollableVadjustmentPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("vscrollPolicy", Gtk.Scrollable.ScrollableVscrollPolicyPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
listViewEnableRubberband :: AttrLabelProxy "enableRubberband"
listViewEnableRubberband = AttrLabelProxy

listViewFactory :: AttrLabelProxy "factory"
listViewFactory = AttrLabelProxy

listViewHeaderFactory :: AttrLabelProxy "headerFactory"
listViewHeaderFactory = AttrLabelProxy

listViewModel :: AttrLabelProxy "model"
listViewModel = AttrLabelProxy

listViewShowSeparators :: AttrLabelProxy "showSeparators"
listViewShowSeparators = AttrLabelProxy

listViewSingleClickActivate :: AttrLabelProxy "singleClickActivate"
listViewSingleClickActivate = AttrLabelProxy

listViewTabBehavior :: AttrLabelProxy "tabBehavior"
listViewTabBehavior = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ListView = ListViewSignalList
type ListViewSignalList = ('[ '("activate", ListViewActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ListView::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The factory to populate items with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ListView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_new" gtk_list_view_new :: 
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO (Ptr ListView)

-- | Creates a new @GtkListView@ that uses the given /@factory@/ for
-- mapping items to widgets.
-- 
-- The function takes ownership of the
-- arguments, so you can write code like
-- 
-- === /c code/
-- >list_view = gtk_list_view_new (create_model (),
-- >  gtk_builder_list_item_factory_new_from_resource ("/resource.ui"));
listViewNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.SelectionModel.IsSelectionModel a, Gtk.ListItemFactory.IsListItemFactory b) =>
    Maybe (a)
    -- ^ /@model@/: the model to use
    -> Maybe (b)
    -- ^ /@factory@/: The factory to populate items with
    -> m ListView
    -- ^ __Returns:__ a new @GtkListView@ using the given /@model@/ and /@factory@/
listViewNew model factory = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- B.ManagedPtr.disownObject jFactory
            return jFactory'
    result <- gtk_list_view_new maybeModel maybeFactory
    checkUnexpectedReturnNULL "listViewNew" result
    result' <- (newObject ListView) result
    whenJust model touchManagedPtr
    whenJust factory touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ListView::get_enable_rubberband
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_get_enable_rubberband" gtk_list_view_get_enable_rubberband :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    IO CInt

-- | Returns whether rows can be selected by dragging with the mouse.
listViewGetEnableRubberband ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> m Bool
    -- ^ __Returns:__ true if rubberband selection is enabled
listViewGetEnableRubberband self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_view_get_enable_rubberband self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ListViewGetEnableRubberbandMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListView a) => O.OverloadedMethod ListViewGetEnableRubberbandMethodInfo a signature where
    overloadedMethod = listViewGetEnableRubberband

instance O.OverloadedMethodInfo ListViewGetEnableRubberbandMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewGetEnableRubberband",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewGetEnableRubberband"
        })


#endif

-- method ListView::get_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_get_factory" gtk_list_view_get_factory :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory that\'s currently used to populate list items.
listViewGetFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory in use
listViewGetFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_view_get_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListViewGetFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsListView a) => O.OverloadedMethod ListViewGetFactoryMethodInfo a signature where
    overloadedMethod = listViewGetFactory

instance O.OverloadedMethodInfo ListViewGetFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewGetFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewGetFactory"
        })


#endif

-- method ListView::get_header_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_get_header_factory" gtk_list_view_get_header_factory :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory that\'s currently used to populate section headers.
-- 
-- /Since: 4.12/
listViewGetHeaderFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory in use
listViewGetHeaderFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_view_get_header_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListViewGetHeaderFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsListView a) => O.OverloadedMethod ListViewGetHeaderFactoryMethodInfo a signature where
    overloadedMethod = listViewGetHeaderFactory

instance O.OverloadedMethodInfo ListViewGetHeaderFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewGetHeaderFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewGetHeaderFactory"
        })


#endif

-- method ListView::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SelectionModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_get_model" gtk_list_view_get_model :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    IO (Ptr Gtk.SelectionModel.SelectionModel)

-- | Gets the model that\'s currently used to read the items displayed.
listViewGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> m (Maybe Gtk.SelectionModel.SelectionModel)
    -- ^ __Returns:__ The model in use
listViewGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_view_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.SelectionModel.SelectionModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListViewGetModelMethodInfo
instance (signature ~ (m (Maybe Gtk.SelectionModel.SelectionModel)), MonadIO m, IsListView a) => O.OverloadedMethod ListViewGetModelMethodInfo a signature where
    overloadedMethod = listViewGetModel

instance O.OverloadedMethodInfo ListViewGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewGetModel"
        })


#endif

-- method ListView::get_show_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_get_show_separators" gtk_list_view_get_show_separators :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    IO CInt

-- | Returns whether the listview should show separators
-- between rows.
listViewGetShowSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> m Bool
    -- ^ __Returns:__ true if the listview shows separators
listViewGetShowSeparators self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_view_get_show_separators self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ListViewGetShowSeparatorsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListView a) => O.OverloadedMethod ListViewGetShowSeparatorsMethodInfo a signature where
    overloadedMethod = listViewGetShowSeparators

instance O.OverloadedMethodInfo ListViewGetShowSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewGetShowSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewGetShowSeparators"
        })


#endif

-- method ListView::get_single_click_activate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_get_single_click_activate" gtk_list_view_get_single_click_activate :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    IO CInt

-- | Returns whether rows will be activated on single click and
-- selected on hover.
listViewGetSingleClickActivate ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> m Bool
    -- ^ __Returns:__ true if rows are activated on single click
listViewGetSingleClickActivate self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_view_get_single_click_activate self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ListViewGetSingleClickActivateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListView a) => O.OverloadedMethod ListViewGetSingleClickActivateMethodInfo a signature where
    overloadedMethod = listViewGetSingleClickActivate

instance O.OverloadedMethodInfo ListViewGetSingleClickActivateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewGetSingleClickActivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewGetSingleClickActivate"
        })


#endif

-- method ListView::get_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_get_tab_behavior" gtk_list_view_get_tab_behavior :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    IO CUInt

-- | Gets the behavior set for the \<kbd>Tab\<\/kbd> key.
-- 
-- /Since: 4.12/
listViewGetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> m Gtk.Enums.ListTabBehavior
    -- ^ __Returns:__ The behavior of the \<kbd>Tab\<\/kbd> key
listViewGetTabBehavior self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_list_view_get_tab_behavior self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ListViewGetTabBehaviorMethodInfo
instance (signature ~ (m Gtk.Enums.ListTabBehavior), MonadIO m, IsListView a) => O.OverloadedMethod ListViewGetTabBehaviorMethodInfo a signature where
    overloadedMethod = listViewGetTabBehavior

instance O.OverloadedMethodInfo ListViewGetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewGetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewGetTabBehavior"
        })


#endif

-- method ListView::scroll_to
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "position of the item. Must be less than the number of\n  items in the view."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListScrollFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "actions to perform" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scroll"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "details of how to perform\n  the scroll operation or %NULL to scroll into view"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_scroll_to" gtk_list_view_scroll_to :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    Word32 ->                               -- pos : TBasicType TUInt
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "ListScrollFlags"})
    Ptr Gtk.ScrollInfo.ScrollInfo ->        -- scroll : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    IO ()

-- | Scrolls to the item at the given position and performs the actions
-- specified in /@flags@/.
-- 
-- This function works no matter if the listview is shown or focused.
-- If it isn\'t, then the changes will take effect once that happens.
-- 
-- /Since: 4.12/
listViewScrollTo ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> Word32
    -- ^ /@pos@/: position of the item. Must be less than the number of
    --   items in the view.
    -> [Gtk.Flags.ListScrollFlags]
    -- ^ /@flags@/: actions to perform
    -> Maybe (Gtk.ScrollInfo.ScrollInfo)
    -- ^ /@scroll@/: details of how to perform
    --   the scroll operation or 'P.Nothing' to scroll into view
    -> m ()
listViewScrollTo self pos flags scroll = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let flags' = gflagsToWord flags
    maybeScroll <- case scroll of
        Nothing -> return FP.nullPtr
        Just jScroll -> do
            jScroll' <- B.ManagedPtr.disownBoxed jScroll
            return jScroll'
    gtk_list_view_scroll_to self' pos flags' maybeScroll
    touchManagedPtr self
    whenJust scroll touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewScrollToMethodInfo
instance (signature ~ (Word32 -> [Gtk.Flags.ListScrollFlags] -> Maybe (Gtk.ScrollInfo.ScrollInfo) -> m ()), MonadIO m, IsListView a) => O.OverloadedMethod ListViewScrollToMethodInfo a signature where
    overloadedMethod = listViewScrollTo

instance O.OverloadedMethodInfo ListViewScrollToMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewScrollTo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewScrollTo"
        })


#endif

-- method ListView::set_enable_rubberband
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enable_rubberband"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to enable rubberband selection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_set_enable_rubberband" gtk_list_view_set_enable_rubberband :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    CInt ->                                 -- enable_rubberband : TBasicType TBoolean
    IO ()

-- | Sets whether selections can be changed by dragging with the mouse.
listViewSetEnableRubberband ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> Bool
    -- ^ /@enableRubberband@/: whether to enable rubberband selection
    -> m ()
listViewSetEnableRubberband self enableRubberband = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let enableRubberband' = (P.fromIntegral . P.fromEnum) enableRubberband
    gtk_list_view_set_enable_rubberband self' enableRubberband'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewSetEnableRubberbandMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsListView a) => O.OverloadedMethod ListViewSetEnableRubberbandMethodInfo a signature where
    overloadedMethod = listViewSetEnableRubberband

instance O.OverloadedMethodInfo ListViewSetEnableRubberbandMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewSetEnableRubberband",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewSetEnableRubberband"
        })


#endif

-- method ListView::set_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the factory to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_set_factory" gtk_list_view_set_factory :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the @GtkListItemFactory@ to use for populating list items.
listViewSetFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a listview
    -> Maybe (b)
    -- ^ /@factory@/: the factory to use
    -> m ()
listViewSetFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_list_view_set_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewSetFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListView a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod ListViewSetFactoryMethodInfo a signature where
    overloadedMethod = listViewSetFactory

instance O.OverloadedMethodInfo ListViewSetFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewSetFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewSetFactory"
        })


#endif

-- method ListView::set_header_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the factory to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_set_header_factory" gtk_list_view_set_header_factory :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the @GtkListItemFactory@ to use for populating the
-- t'GI.Gtk.Objects.ListHeader.ListHeader' objects used in section headers.
-- 
-- If this factory is set to @NULL@, the list will not show
-- section headers.
-- 
-- /Since: 4.12/
listViewSetHeaderFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a listview
    -> Maybe (b)
    -- ^ /@factory@/: the factory to use
    -> m ()
listViewSetHeaderFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_list_view_set_header_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewSetHeaderFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListView a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod ListViewSetHeaderFactoryMethodInfo a signature where
    overloadedMethod = listViewSetHeaderFactory

instance O.OverloadedMethodInfo ListViewSetHeaderFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewSetHeaderFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewSetHeaderFactory"
        })


#endif

-- method ListView::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_set_model" gtk_list_view_set_model :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    IO ()

-- | Sets the model to use.
-- 
-- This must be a t'GI.Gtk.Interfaces.SelectionModel.SelectionModel' to use.
listViewSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a, Gtk.SelectionModel.IsSelectionModel b) =>
    a
    -- ^ /@self@/: a listview
    -> Maybe (b)
    -- ^ /@model@/: the model to use
    -> m ()
listViewSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_list_view_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListView a, Gtk.SelectionModel.IsSelectionModel b) => O.OverloadedMethod ListViewSetModelMethodInfo a signature where
    overloadedMethod = listViewSetModel

instance O.OverloadedMethodInfo ListViewSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewSetModel"
        })


#endif

-- method ListView::set_show_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_separators"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show separators"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_set_show_separators" gtk_list_view_set_show_separators :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    CInt ->                                 -- show_separators : TBasicType TBoolean
    IO ()

-- | Sets whether the listview should show separators
-- between rows.
listViewSetShowSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> Bool
    -- ^ /@showSeparators@/: whether to show separators
    -> m ()
listViewSetShowSeparators self showSeparators = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let showSeparators' = (P.fromIntegral . P.fromEnum) showSeparators
    gtk_list_view_set_show_separators self' showSeparators'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewSetShowSeparatorsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsListView a) => O.OverloadedMethod ListViewSetShowSeparatorsMethodInfo a signature where
    overloadedMethod = listViewSetShowSeparators

instance O.OverloadedMethodInfo ListViewSetShowSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewSetShowSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewSetShowSeparators"
        })


#endif

-- method ListView::set_single_click_activate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "single_click_activate"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to activate items on single click"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_set_single_click_activate" gtk_list_view_set_single_click_activate :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    CInt ->                                 -- single_click_activate : TBasicType TBoolean
    IO ()

-- | Sets whether rows should be activated on single click and
-- selected on hover.
listViewSetSingleClickActivate ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> Bool
    -- ^ /@singleClickActivate@/: whether to activate items on single click
    -> m ()
listViewSetSingleClickActivate self singleClickActivate = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let singleClickActivate' = (P.fromIntegral . P.fromEnum) singleClickActivate
    gtk_list_view_set_single_click_activate self' singleClickActivate'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewSetSingleClickActivateMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsListView a) => O.OverloadedMethod ListViewSetSingleClickActivateMethodInfo a signature where
    overloadedMethod = listViewSetSingleClickActivate

instance O.OverloadedMethodInfo ListViewSetSingleClickActivateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewSetSingleClickActivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewSetSingleClickActivate"
        })


#endif

-- method ListView::set_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_behavior"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The desired tab behavior"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_view_set_tab_behavior" gtk_list_view_set_tab_behavior :: 
    Ptr ListView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "ListView"})
    CUInt ->                                -- tab_behavior : TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
    IO ()

-- | Sets the \<kbd>Tab\<\/kbd> key behavior.
-- 
-- This influences how the \<kbd>Tab\<\/kbd> and
-- \<kbd>Shift\<\/kbd>+\<kbd>Tab\<\/kbd> keys move the
-- focus in the listview.
-- 
-- /Since: 4.12/
listViewSetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsListView a) =>
    a
    -- ^ /@self@/: a listview
    -> Gtk.Enums.ListTabBehavior
    -- ^ /@tabBehavior@/: The desired tab behavior
    -> m ()
listViewSetTabBehavior self tabBehavior = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let tabBehavior' = (fromIntegral . fromEnum) tabBehavior
    gtk_list_view_set_tab_behavior self' tabBehavior'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ListViewSetTabBehaviorMethodInfo
instance (signature ~ (Gtk.Enums.ListTabBehavior -> m ()), MonadIO m, IsListView a) => O.OverloadedMethod ListViewSetTabBehaviorMethodInfo a signature where
    overloadedMethod = listViewSetTabBehavior

instance O.OverloadedMethodInfo ListViewSetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListView.listViewSetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ListView.html#v:listViewSetTabBehavior"
        })


#endif


