{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows a level indicator.
-- 
-- Typical use cases are displaying the strength of a password, or
-- showing the charge level of a battery.
-- 
-- \<picture>
--   \<source srcset=\"levelbar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkLevelBar\" src=\"levelbar.png\">
-- \<\/picture>
-- 
-- Use 'GI.Gtk.Objects.LevelBar.levelBarSetValue' to set the current value, and
-- 'GI.Gtk.Objects.LevelBar.levelBarAddOffsetValue' to set the value offsets at which
-- the bar will be considered in a different state. GTK will add a few
-- offsets by default on the level bar: 'GI.Gtk.Constants.LEVEL_BAR_OFFSET_LOW',
-- 'GI.Gtk.Constants.LEVEL_BAR_OFFSET_HIGH' and 'GI.Gtk.Constants.LEVEL_BAR_OFFSET_FULL', with
-- values 0.25, 0.75 and 1.0 respectively.
-- 
-- Note that it is your responsibility to update preexisting offsets
-- when changing the minimum or maximum value. GTK will simply clamp
-- them to the new range.
-- 
-- == Adding a custom offset on the bar
-- 
-- 
-- === /c code/
-- >static GtkWidget *
-- >create_level_bar (void)
-- >{
-- >  GtkWidget *widget;
-- >  GtkLevelBar *bar;
-- >
-- >  widget = gtk_level_bar_new ();
-- >  bar = GTK_LEVEL_BAR (widget);
-- >
-- >  // This changes the value of the default low offset
-- >
-- >  gtk_level_bar_add_offset_value (bar,
-- >                                  GTK_LEVEL_BAR_OFFSET_LOW,
-- >                                  0.10);
-- >
-- >  // This adds a new offset to the bar; the application will
-- >  // be able to change its color CSS like this:
-- >  //
-- >  // levelbar block.my-offset {
-- >  //   background-color: magenta;
-- >  //   border-style: solid;
-- >  //   border-color: black;
-- >  //   border-width: 1px;
-- >  // }
-- >
-- >  gtk_level_bar_add_offset_value (bar, "my-offset", 0.60);
-- >
-- >  return widget;
-- >}
-- 
-- 
-- The default interval of values is between zero and one, but it’s possible
-- to modify the interval using 'GI.Gtk.Objects.LevelBar.levelBarSetMinValue' and
-- 'GI.Gtk.Objects.LevelBar.levelBarSetMaxValue'. The value will be always drawn in
-- proportion to the admissible interval, i.e. a value of 15 with a specified
-- interval between 10 and 20 is equivalent to a value of 0.5 with an interval
-- between 0 and 1. When 'GI.Gtk.Enums.LevelBarModeDiscrete' is used, the bar level
-- is rendered as a finite number of separated blocks instead of a single one.
-- The number of blocks that will be rendered is equal to the number of units
-- specified by the admissible interval.
-- 
-- For instance, to build a bar rendered with five blocks, it’s sufficient to
-- set the minimum value to 0 and the maximum value to 5 after changing the
-- indicator mode to discrete.
-- 
-- = GtkLevelBar as GtkBuildable
-- 
-- The @GtkLevelBar@ implementation of the @GtkBuildable@ interface supports a
-- custom @\<offsets>@ element, which can contain any number of @\<offset>@ elements,
-- each of which must have \"name\" and \"value\" attributes.
-- 
-- = CSS nodes
-- 
-- >levelbar[.discrete]
-- >╰── trough
-- >    ├── block.filled.level-name
-- >    ┊
-- >    ├── block.empty
-- >    ┊
-- 
-- 
-- @GtkLevelBar@ has a main CSS node with name levelbar and one of the style
-- classes .discrete or .continuous and a subnode with name trough. Below the
-- trough node are a number of nodes with name block and style class .filled
-- or .empty. In continuous mode, there is exactly one node of each, in discrete
-- mode, the number of filled and unfilled nodes corresponds to blocks that are
-- drawn. The block.filled nodes also get a style class .level-name corresponding
-- to the level for the current value.
-- 
-- In horizontal orientation, the nodes are always arranged from left to right,
-- regardless of text direction.
-- 
-- = Accessibility
-- 
-- @GtkLevelBar@ uses the [enum/@gtk@/.AccessibleRole.meter] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.LevelBar
    ( 

-- * Exported types
    LevelBar(..)                            ,
    IsLevelBar                              ,
    toLevelBar                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addOffsetValue]("GI.Gtk.Objects.LevelBar#g:method:addOffsetValue"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeOffsetValue]("GI.Gtk.Objects.LevelBar#g:method:removeOffsetValue"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getInverted]("GI.Gtk.Objects.LevelBar#g:method:getInverted"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMaxValue]("GI.Gtk.Objects.LevelBar#g:method:getMaxValue"), [getMinValue]("GI.Gtk.Objects.LevelBar#g:method:getMinValue"), [getMode]("GI.Gtk.Objects.LevelBar#g:method:getMode"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOffsetValue]("GI.Gtk.Objects.LevelBar#g:method:getOffsetValue"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getValue]("GI.Gtk.Objects.LevelBar#g:method:getValue"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setInverted]("GI.Gtk.Objects.LevelBar#g:method:setInverted"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMaxValue]("GI.Gtk.Objects.LevelBar#g:method:setMaxValue"), [setMinValue]("GI.Gtk.Objects.LevelBar#g:method:setMinValue"), [setMode]("GI.Gtk.Objects.LevelBar#g:method:setMode"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setValue]("GI.Gtk.Objects.LevelBar#g:method:setValue"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveLevelBarMethod                   ,
#endif

-- ** addOffsetValue #method:addOffsetValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarAddOffsetValueMethodInfo        ,
#endif
    levelBarAddOffsetValue                  ,


-- ** getInverted #method:getInverted#

#if defined(ENABLE_OVERLOADING)
    LevelBarGetInvertedMethodInfo           ,
#endif
    levelBarGetInverted                     ,


-- ** getMaxValue #method:getMaxValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarGetMaxValueMethodInfo           ,
#endif
    levelBarGetMaxValue                     ,


-- ** getMinValue #method:getMinValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarGetMinValueMethodInfo           ,
#endif
    levelBarGetMinValue                     ,


-- ** getMode #method:getMode#

#if defined(ENABLE_OVERLOADING)
    LevelBarGetModeMethodInfo               ,
#endif
    levelBarGetMode                         ,


-- ** getOffsetValue #method:getOffsetValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarGetOffsetValueMethodInfo        ,
#endif
    levelBarGetOffsetValue                  ,


-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarGetValueMethodInfo              ,
#endif
    levelBarGetValue                        ,


-- ** new #method:new#

    levelBarNew                             ,


-- ** newForInterval #method:newForInterval#

    levelBarNewForInterval                  ,


-- ** removeOffsetValue #method:removeOffsetValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarRemoveOffsetValueMethodInfo     ,
#endif
    levelBarRemoveOffsetValue               ,


-- ** setInverted #method:setInverted#

#if defined(ENABLE_OVERLOADING)
    LevelBarSetInvertedMethodInfo           ,
#endif
    levelBarSetInverted                     ,


-- ** setMaxValue #method:setMaxValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarSetMaxValueMethodInfo           ,
#endif
    levelBarSetMaxValue                     ,


-- ** setMinValue #method:setMinValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarSetMinValueMethodInfo           ,
#endif
    levelBarSetMinValue                     ,


-- ** setMode #method:setMode#

#if defined(ENABLE_OVERLOADING)
    LevelBarSetModeMethodInfo               ,
#endif
    levelBarSetMode                         ,


-- ** setValue #method:setValue#

#if defined(ENABLE_OVERLOADING)
    LevelBarSetValueMethodInfo              ,
#endif
    levelBarSetValue                        ,




 -- * Properties


-- ** inverted #attr:inverted#
-- | Whether the @GtkLeveBar@ is inverted.
-- 
-- Level bars normally grow from top to bottom or left to right.
-- Inverted level bars grow in the opposite direction.

#if defined(ENABLE_OVERLOADING)
    LevelBarInvertedPropertyInfo            ,
#endif
    constructLevelBarInverted               ,
    getLevelBarInverted                     ,
#if defined(ENABLE_OVERLOADING)
    levelBarInverted                        ,
#endif
    setLevelBarInverted                     ,


-- ** maxValue #attr:maxValue#
-- | Determines the maximum value of the interval that can be displayed by the bar.

#if defined(ENABLE_OVERLOADING)
    LevelBarMaxValuePropertyInfo            ,
#endif
    constructLevelBarMaxValue               ,
    getLevelBarMaxValue                     ,
#if defined(ENABLE_OVERLOADING)
    levelBarMaxValue                        ,
#endif
    setLevelBarMaxValue                     ,


-- ** minValue #attr:minValue#
-- | Determines the minimum value of the interval that can be displayed by the bar.

#if defined(ENABLE_OVERLOADING)
    LevelBarMinValuePropertyInfo            ,
#endif
    constructLevelBarMinValue               ,
    getLevelBarMinValue                     ,
#if defined(ENABLE_OVERLOADING)
    levelBarMinValue                        ,
#endif
    setLevelBarMinValue                     ,


-- ** mode #attr:mode#
-- | Determines the way @GtkLevelBar@ interprets the value properties to draw the
-- level fill area.
-- 
-- Specifically, when the value is 'GI.Gtk.Enums.LevelBarModeContinuous',
-- @GtkLevelBar@ will draw a single block representing the current value in
-- that area; when the value is 'GI.Gtk.Enums.LevelBarModeDiscrete',
-- the widget will draw a succession of separate blocks filling the
-- draw area, with the number of blocks being equal to the units separating
-- the integral roundings of [LevelBar:minValue]("GI.Gtk.Objects.LevelBar#g:attr:minValue") and
-- [LevelBar:maxValue]("GI.Gtk.Objects.LevelBar#g:attr:maxValue").

#if defined(ENABLE_OVERLOADING)
    LevelBarModePropertyInfo                ,
#endif
    constructLevelBarMode                   ,
    getLevelBarMode                         ,
#if defined(ENABLE_OVERLOADING)
    levelBarMode                            ,
#endif
    setLevelBarMode                         ,


-- ** value #attr:value#
-- | Determines the currently filled value of the level bar.

#if defined(ENABLE_OVERLOADING)
    LevelBarValuePropertyInfo               ,
#endif
    constructLevelBarValue                  ,
    getLevelBarValue                        ,
#if defined(ENABLE_OVERLOADING)
    levelBarValue                           ,
#endif
    setLevelBarValue                        ,




 -- * Signals


-- ** offsetChanged #signal:offsetChanged#

    LevelBarOffsetChangedCallback           ,
#if defined(ENABLE_OVERLOADING)
    LevelBarOffsetChangedSignalInfo         ,
#endif
    afterLevelBarOffsetChanged              ,
    onLevelBarOffsetChanged                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype LevelBar = LevelBar (SP.ManagedPtr LevelBar)
    deriving (Eq)

instance SP.ManagedPtrNewtype LevelBar where
    toManagedPtr (LevelBar p) = p

foreign import ccall "gtk_level_bar_get_type"
    c_gtk_level_bar_get_type :: IO B.Types.GType

instance B.Types.TypedObject LevelBar where
    glibType = c_gtk_level_bar_get_type

instance B.Types.GObject LevelBar

-- | Type class for types which can be safely cast to `LevelBar`, for instance with `toLevelBar`.
class (SP.GObject o, O.IsDescendantOf LevelBar o) => IsLevelBar o
instance (SP.GObject o, O.IsDescendantOf LevelBar o) => IsLevelBar o

instance O.HasParentTypes LevelBar
type instance O.ParentTypes LevelBar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleRange.AccessibleRange, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to `LevelBar`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toLevelBar :: (MIO.MonadIO m, IsLevelBar o) => o -> m LevelBar
toLevelBar = MIO.liftIO . B.ManagedPtr.unsafeCastTo LevelBar

-- | Convert 'LevelBar' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe LevelBar) where
    gvalueGType_ = c_gtk_level_bar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr LevelBar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr LevelBar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject LevelBar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveLevelBarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveLevelBarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveLevelBarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveLevelBarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveLevelBarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveLevelBarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveLevelBarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveLevelBarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveLevelBarMethod "addOffsetValue" o = LevelBarAddOffsetValueMethodInfo
    ResolveLevelBarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveLevelBarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveLevelBarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveLevelBarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveLevelBarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveLevelBarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveLevelBarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveLevelBarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveLevelBarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveLevelBarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveLevelBarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveLevelBarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveLevelBarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveLevelBarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveLevelBarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveLevelBarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveLevelBarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveLevelBarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveLevelBarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveLevelBarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveLevelBarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveLevelBarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveLevelBarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveLevelBarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveLevelBarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveLevelBarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveLevelBarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveLevelBarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveLevelBarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveLevelBarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveLevelBarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveLevelBarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveLevelBarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveLevelBarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveLevelBarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveLevelBarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveLevelBarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveLevelBarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveLevelBarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveLevelBarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveLevelBarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveLevelBarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveLevelBarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveLevelBarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveLevelBarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveLevelBarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveLevelBarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveLevelBarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveLevelBarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveLevelBarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveLevelBarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveLevelBarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveLevelBarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveLevelBarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveLevelBarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveLevelBarMethod "removeOffsetValue" o = LevelBarRemoveOffsetValueMethodInfo
    ResolveLevelBarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveLevelBarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveLevelBarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveLevelBarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveLevelBarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveLevelBarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveLevelBarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveLevelBarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveLevelBarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveLevelBarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveLevelBarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveLevelBarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveLevelBarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveLevelBarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveLevelBarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveLevelBarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveLevelBarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveLevelBarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveLevelBarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveLevelBarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveLevelBarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveLevelBarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveLevelBarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveLevelBarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveLevelBarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveLevelBarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveLevelBarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveLevelBarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveLevelBarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveLevelBarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveLevelBarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveLevelBarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveLevelBarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveLevelBarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveLevelBarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveLevelBarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveLevelBarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveLevelBarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveLevelBarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveLevelBarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveLevelBarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveLevelBarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveLevelBarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveLevelBarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveLevelBarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveLevelBarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveLevelBarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveLevelBarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveLevelBarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveLevelBarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveLevelBarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveLevelBarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveLevelBarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveLevelBarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveLevelBarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveLevelBarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveLevelBarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveLevelBarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveLevelBarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveLevelBarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveLevelBarMethod "getInverted" o = LevelBarGetInvertedMethodInfo
    ResolveLevelBarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveLevelBarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveLevelBarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveLevelBarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveLevelBarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveLevelBarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveLevelBarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveLevelBarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveLevelBarMethod "getMaxValue" o = LevelBarGetMaxValueMethodInfo
    ResolveLevelBarMethod "getMinValue" o = LevelBarGetMinValueMethodInfo
    ResolveLevelBarMethod "getMode" o = LevelBarGetModeMethodInfo
    ResolveLevelBarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveLevelBarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveLevelBarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveLevelBarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveLevelBarMethod "getOffsetValue" o = LevelBarGetOffsetValueMethodInfo
    ResolveLevelBarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveLevelBarMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveLevelBarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveLevelBarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveLevelBarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveLevelBarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveLevelBarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveLevelBarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveLevelBarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveLevelBarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveLevelBarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveLevelBarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveLevelBarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveLevelBarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveLevelBarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveLevelBarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveLevelBarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveLevelBarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveLevelBarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveLevelBarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveLevelBarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveLevelBarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveLevelBarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveLevelBarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveLevelBarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveLevelBarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveLevelBarMethod "getValue" o = LevelBarGetValueMethodInfo
    ResolveLevelBarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveLevelBarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveLevelBarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveLevelBarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveLevelBarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveLevelBarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveLevelBarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveLevelBarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveLevelBarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveLevelBarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveLevelBarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveLevelBarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveLevelBarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveLevelBarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveLevelBarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveLevelBarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveLevelBarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveLevelBarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveLevelBarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveLevelBarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveLevelBarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveLevelBarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveLevelBarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveLevelBarMethod "setInverted" o = LevelBarSetInvertedMethodInfo
    ResolveLevelBarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveLevelBarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveLevelBarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveLevelBarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveLevelBarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveLevelBarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveLevelBarMethod "setMaxValue" o = LevelBarSetMaxValueMethodInfo
    ResolveLevelBarMethod "setMinValue" o = LevelBarSetMinValueMethodInfo
    ResolveLevelBarMethod "setMode" o = LevelBarSetModeMethodInfo
    ResolveLevelBarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveLevelBarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveLevelBarMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveLevelBarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveLevelBarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveLevelBarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveLevelBarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveLevelBarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveLevelBarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveLevelBarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveLevelBarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveLevelBarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveLevelBarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveLevelBarMethod "setValue" o = LevelBarSetValueMethodInfo
    ResolveLevelBarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveLevelBarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveLevelBarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveLevelBarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveLevelBarMethod t LevelBar, O.OverloadedMethod info LevelBar p) => OL.IsLabel t (LevelBar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveLevelBarMethod t LevelBar, O.OverloadedMethod info LevelBar p, R.HasField t LevelBar p) => R.HasField t LevelBar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveLevelBarMethod t LevelBar, O.OverloadedMethodInfo info LevelBar) => OL.IsLabel t (O.MethodProxy info LevelBar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal LevelBar::offset-changed
-- | Emitted when an offset specified on the bar changes value.
-- 
-- This typically is the result of a 'GI.Gtk.Objects.LevelBar.levelBarAddOffsetValue'
-- call.
-- 
-- The signal supports detailed connections; you can connect to the
-- detailed signal \"changed[x](#g:signal:x)\" in order to only receive callbacks when
-- the value of offset \"x\" changes.
type LevelBarOffsetChangedCallback =
    T.Text
    -- ^ /@name@/: the name of the offset that changed value
    -> IO ()

type C_LevelBarOffsetChangedCallback =
    Ptr LevelBar ->                         -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_LevelBarOffsetChangedCallback`.
foreign import ccall "wrapper"
    mk_LevelBarOffsetChangedCallback :: C_LevelBarOffsetChangedCallback -> IO (FunPtr C_LevelBarOffsetChangedCallback)

wrap_LevelBarOffsetChangedCallback :: 
    GObject a => (a -> LevelBarOffsetChangedCallback) ->
    C_LevelBarOffsetChangedCallback
wrap_LevelBarOffsetChangedCallback gi'cb gi'selfPtr name _ = do
    name' <- cstringToText name
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  name'


-- | Connect a signal handler for the [offsetChanged](#signal:offsetChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' levelBar #offsetChanged callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@offset-changed::detail@” instead.
-- 
onLevelBarOffsetChanged :: (IsLevelBar a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => LevelBarOffsetChangedCallback) -> m SignalHandlerId
onLevelBarOffsetChanged obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_LevelBarOffsetChangedCallback wrapped
    wrapped'' <- mk_LevelBarOffsetChangedCallback wrapped'
    connectSignalFunPtr obj "offset-changed" wrapped'' SignalConnectBefore detail

-- | Connect a signal handler for the [offsetChanged](#signal:offsetChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' levelBar #offsetChanged callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@offset-changed::detail@” instead.
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterLevelBarOffsetChanged :: (IsLevelBar a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => LevelBarOffsetChangedCallback) -> m SignalHandlerId
afterLevelBarOffsetChanged obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_LevelBarOffsetChangedCallback wrapped
    wrapped'' <- mk_LevelBarOffsetChangedCallback wrapped'
    connectSignalFunPtr obj "offset-changed" wrapped'' SignalConnectAfter detail


#if defined(ENABLE_OVERLOADING)
data LevelBarOffsetChangedSignalInfo
instance SignalInfo LevelBarOffsetChangedSignalInfo where
    type HaskellCallbackType LevelBarOffsetChangedSignalInfo = LevelBarOffsetChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_LevelBarOffsetChangedCallback cb
        cb'' <- mk_LevelBarOffsetChangedCallback cb'
        connectSignalFunPtr obj "offset-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar::offset-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#g:signal:offsetChanged"})

#endif

-- VVV Prop "inverted"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@inverted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' levelBar #inverted
-- @
getLevelBarInverted :: (MonadIO m, IsLevelBar o) => o -> m Bool
getLevelBarInverted obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "inverted"

-- | Set the value of the “@inverted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' levelBar [ #inverted 'Data.GI.Base.Attributes.:=' value ]
-- @
setLevelBarInverted :: (MonadIO m, IsLevelBar o) => o -> Bool -> m ()
setLevelBarInverted obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "inverted" val

-- | Construct a `GValueConstruct` with valid value for the “@inverted@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructLevelBarInverted :: (IsLevelBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructLevelBarInverted val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "inverted" val

#if defined(ENABLE_OVERLOADING)
data LevelBarInvertedPropertyInfo
instance AttrInfo LevelBarInvertedPropertyInfo where
    type AttrAllowedOps LevelBarInvertedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint LevelBarInvertedPropertyInfo = IsLevelBar
    type AttrSetTypeConstraint LevelBarInvertedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint LevelBarInvertedPropertyInfo = (~) Bool
    type AttrTransferType LevelBarInvertedPropertyInfo = Bool
    type AttrGetType LevelBarInvertedPropertyInfo = Bool
    type AttrLabel LevelBarInvertedPropertyInfo = "inverted"
    type AttrOrigin LevelBarInvertedPropertyInfo = LevelBar
    attrGet = getLevelBarInverted
    attrSet = setLevelBarInverted
    attrTransfer _ v = do
        return v
    attrConstruct = constructLevelBarInverted
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.inverted"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#g:attr:inverted"
        })
#endif

-- VVV Prop "max-value"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@max-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' levelBar #maxValue
-- @
getLevelBarMaxValue :: (MonadIO m, IsLevelBar o) => o -> m Double
getLevelBarMaxValue obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "max-value"

-- | Set the value of the “@max-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' levelBar [ #maxValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setLevelBarMaxValue :: (MonadIO m, IsLevelBar o) => o -> Double -> m ()
setLevelBarMaxValue obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "max-value" val

-- | Construct a `GValueConstruct` with valid value for the “@max-value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructLevelBarMaxValue :: (IsLevelBar o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructLevelBarMaxValue val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "max-value" val

#if defined(ENABLE_OVERLOADING)
data LevelBarMaxValuePropertyInfo
instance AttrInfo LevelBarMaxValuePropertyInfo where
    type AttrAllowedOps LevelBarMaxValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint LevelBarMaxValuePropertyInfo = IsLevelBar
    type AttrSetTypeConstraint LevelBarMaxValuePropertyInfo = (~) Double
    type AttrTransferTypeConstraint LevelBarMaxValuePropertyInfo = (~) Double
    type AttrTransferType LevelBarMaxValuePropertyInfo = Double
    type AttrGetType LevelBarMaxValuePropertyInfo = Double
    type AttrLabel LevelBarMaxValuePropertyInfo = "max-value"
    type AttrOrigin LevelBarMaxValuePropertyInfo = LevelBar
    attrGet = getLevelBarMaxValue
    attrSet = setLevelBarMaxValue
    attrTransfer _ v = do
        return v
    attrConstruct = constructLevelBarMaxValue
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.maxValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#g:attr:maxValue"
        })
#endif

-- VVV Prop "min-value"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@min-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' levelBar #minValue
-- @
getLevelBarMinValue :: (MonadIO m, IsLevelBar o) => o -> m Double
getLevelBarMinValue obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "min-value"

-- | Set the value of the “@min-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' levelBar [ #minValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setLevelBarMinValue :: (MonadIO m, IsLevelBar o) => o -> Double -> m ()
setLevelBarMinValue obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "min-value" val

-- | Construct a `GValueConstruct` with valid value for the “@min-value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructLevelBarMinValue :: (IsLevelBar o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructLevelBarMinValue val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "min-value" val

#if defined(ENABLE_OVERLOADING)
data LevelBarMinValuePropertyInfo
instance AttrInfo LevelBarMinValuePropertyInfo where
    type AttrAllowedOps LevelBarMinValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint LevelBarMinValuePropertyInfo = IsLevelBar
    type AttrSetTypeConstraint LevelBarMinValuePropertyInfo = (~) Double
    type AttrTransferTypeConstraint LevelBarMinValuePropertyInfo = (~) Double
    type AttrTransferType LevelBarMinValuePropertyInfo = Double
    type AttrGetType LevelBarMinValuePropertyInfo = Double
    type AttrLabel LevelBarMinValuePropertyInfo = "min-value"
    type AttrOrigin LevelBarMinValuePropertyInfo = LevelBar
    attrGet = getLevelBarMinValue
    attrSet = setLevelBarMinValue
    attrTransfer _ v = do
        return v
    attrConstruct = constructLevelBarMinValue
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.minValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#g:attr:minValue"
        })
#endif

-- VVV Prop "mode"
   -- Type: TInterface (Name {namespace = "Gtk", name = "LevelBarMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' levelBar #mode
-- @
getLevelBarMode :: (MonadIO m, IsLevelBar o) => o -> m Gtk.Enums.LevelBarMode
getLevelBarMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "mode"

-- | Set the value of the “@mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' levelBar [ #mode 'Data.GI.Base.Attributes.:=' value ]
-- @
setLevelBarMode :: (MonadIO m, IsLevelBar o) => o -> Gtk.Enums.LevelBarMode -> m ()
setLevelBarMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "mode" val

-- | Construct a `GValueConstruct` with valid value for the “@mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructLevelBarMode :: (IsLevelBar o, MIO.MonadIO m) => Gtk.Enums.LevelBarMode -> m (GValueConstruct o)
constructLevelBarMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "mode" val

#if defined(ENABLE_OVERLOADING)
data LevelBarModePropertyInfo
instance AttrInfo LevelBarModePropertyInfo where
    type AttrAllowedOps LevelBarModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint LevelBarModePropertyInfo = IsLevelBar
    type AttrSetTypeConstraint LevelBarModePropertyInfo = (~) Gtk.Enums.LevelBarMode
    type AttrTransferTypeConstraint LevelBarModePropertyInfo = (~) Gtk.Enums.LevelBarMode
    type AttrTransferType LevelBarModePropertyInfo = Gtk.Enums.LevelBarMode
    type AttrGetType LevelBarModePropertyInfo = Gtk.Enums.LevelBarMode
    type AttrLabel LevelBarModePropertyInfo = "mode"
    type AttrOrigin LevelBarModePropertyInfo = LevelBar
    attrGet = getLevelBarMode
    attrSet = setLevelBarMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructLevelBarMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.mode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#g:attr:mode"
        })
#endif

-- VVV Prop "value"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' levelBar #value
-- @
getLevelBarValue :: (MonadIO m, IsLevelBar o) => o -> m Double
getLevelBarValue obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "value"

-- | Set the value of the “@value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' levelBar [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setLevelBarValue :: (MonadIO m, IsLevelBar o) => o -> Double -> m ()
setLevelBarValue obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "value" val

-- | Construct a `GValueConstruct` with valid value for the “@value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructLevelBarValue :: (IsLevelBar o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructLevelBarValue val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "value" val

#if defined(ENABLE_OVERLOADING)
data LevelBarValuePropertyInfo
instance AttrInfo LevelBarValuePropertyInfo where
    type AttrAllowedOps LevelBarValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint LevelBarValuePropertyInfo = IsLevelBar
    type AttrSetTypeConstraint LevelBarValuePropertyInfo = (~) Double
    type AttrTransferTypeConstraint LevelBarValuePropertyInfo = (~) Double
    type AttrTransferType LevelBarValuePropertyInfo = Double
    type AttrGetType LevelBarValuePropertyInfo = Double
    type AttrLabel LevelBarValuePropertyInfo = "value"
    type AttrOrigin LevelBarValuePropertyInfo = LevelBar
    attrGet = getLevelBarValue
    attrSet = setLevelBarValue
    attrTransfer _ v = do
        return v
    attrConstruct = constructLevelBarValue
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#g:attr:value"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList LevelBar
type instance O.AttributeList LevelBar = LevelBarAttributeList
type LevelBarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("inverted", LevelBarInvertedPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maxValue", LevelBarMaxValuePropertyInfo), '("minValue", LevelBarMinValuePropertyInfo), '("mode", LevelBarModePropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("value", LevelBarValuePropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
levelBarInverted :: AttrLabelProxy "inverted"
levelBarInverted = AttrLabelProxy

levelBarMaxValue :: AttrLabelProxy "maxValue"
levelBarMaxValue = AttrLabelProxy

levelBarMinValue :: AttrLabelProxy "minValue"
levelBarMinValue = AttrLabelProxy

levelBarMode :: AttrLabelProxy "mode"
levelBarMode = AttrLabelProxy

levelBarValue :: AttrLabelProxy "value"
levelBarValue = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList LevelBar = LevelBarSignalList
type LevelBarSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("offsetChanged", LevelBarOffsetChangedSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method LevelBar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "LevelBar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_new" gtk_level_bar_new :: 
    IO (Ptr LevelBar)

-- | Creates a new @GtkLevelBar@.
levelBarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m LevelBar
    -- ^ __Returns:__ a @GtkLevelBar@.
levelBarNew  = liftIO $ do
    result <- gtk_level_bar_new
    checkUnexpectedReturnNULL "levelBarNew" result
    result' <- (newObject LevelBar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method LevelBar::new_for_interval
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "min_value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a positive value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a positive value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "LevelBar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_new_for_interval" gtk_level_bar_new_for_interval :: 
    CDouble ->                              -- min_value : TBasicType TDouble
    CDouble ->                              -- max_value : TBasicType TDouble
    IO (Ptr LevelBar)

-- | Creates a new @GtkLevelBar@ for the specified interval.
levelBarNewForInterval ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Double
    -- ^ /@minValue@/: a positive value
    -> Double
    -- ^ /@maxValue@/: a positive value
    -> m LevelBar
    -- ^ __Returns:__ a @GtkLevelBar@
levelBarNewForInterval minValue maxValue = liftIO $ do
    let minValue' = realToFrac minValue
    let maxValue' = realToFrac maxValue
    result <- gtk_level_bar_new_for_interval minValue' maxValue'
    checkUnexpectedReturnNULL "levelBarNewForInterval" result
    result' <- (newObject LevelBar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method LevelBar::add_offset_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the new offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value for the new offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_add_offset_value" gtk_level_bar_add_offset_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CString ->                              -- name : TBasicType TUTF8
    CDouble ->                              -- value : TBasicType TDouble
    IO ()

-- | Adds a new offset marker on /@self@/ at the position specified by /@value@/.
-- 
-- When the bar value is in the interval topped by /@value@/ (or between /@value@/
-- and [LevelBar:maxValue]("GI.Gtk.Objects.LevelBar#g:attr:maxValue") in case the offset is the last one
-- on the bar) a style class named @level-@/@name@/ will be applied
-- when rendering the level bar fill.
-- 
-- If another offset marker named /@name@/ exists, its value will be
-- replaced by /@value@/.
levelBarAddOffsetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> T.Text
    -- ^ /@name@/: the name of the new offset
    -> Double
    -- ^ /@value@/: the value for the new offset
    -> m ()
levelBarAddOffsetValue self name value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    name' <- textToCString name
    let value' = realToFrac value
    gtk_level_bar_add_offset_value self' name' value'
    touchManagedPtr self
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data LevelBarAddOffsetValueMethodInfo
instance (signature ~ (T.Text -> Double -> m ()), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarAddOffsetValueMethodInfo a signature where
    overloadedMethod = levelBarAddOffsetValue

instance O.OverloadedMethodInfo LevelBarAddOffsetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarAddOffsetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarAddOffsetValue"
        })


#endif

-- method LevelBar::get_inverted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_get_inverted" gtk_level_bar_get_inverted :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    IO CInt

-- | Returns whether the levelbar is inverted.
levelBarGetInverted ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the level bar is inverted
levelBarGetInverted self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_level_bar_get_inverted self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data LevelBarGetInvertedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarGetInvertedMethodInfo a signature where
    overloadedMethod = levelBarGetInverted

instance O.OverloadedMethodInfo LevelBarGetInvertedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarGetInverted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarGetInverted"
        })


#endif

-- method LevelBar::get_max_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_get_max_value" gtk_level_bar_get_max_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    IO CDouble

-- | Returns the @max-value@ of the @GtkLevelBar@.
levelBarGetMaxValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> m Double
    -- ^ __Returns:__ a positive value
levelBarGetMaxValue self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_level_bar_get_max_value self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data LevelBarGetMaxValueMethodInfo
instance (signature ~ (m Double), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarGetMaxValueMethodInfo a signature where
    overloadedMethod = levelBarGetMaxValue

instance O.OverloadedMethodInfo LevelBarGetMaxValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarGetMaxValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarGetMaxValue"
        })


#endif

-- method LevelBar::get_min_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_get_min_value" gtk_level_bar_get_min_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    IO CDouble

-- | Returns the @min-value@ of the @GtkLevelBar@.
levelBarGetMinValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> m Double
    -- ^ __Returns:__ a positive value
levelBarGetMinValue self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_level_bar_get_min_value self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data LevelBarGetMinValueMethodInfo
instance (signature ~ (m Double), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarGetMinValueMethodInfo a signature where
    overloadedMethod = levelBarGetMinValue

instance O.OverloadedMethodInfo LevelBarGetMinValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarGetMinValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarGetMinValue"
        })


#endif

-- method LevelBar::get_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "LevelBarMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_get_mode" gtk_level_bar_get_mode :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    IO CUInt

-- | Returns the @mode@ of the @GtkLevelBar@.
levelBarGetMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> m Gtk.Enums.LevelBarMode
    -- ^ __Returns:__ a @GtkLevelBarMode@
levelBarGetMode self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_level_bar_get_mode self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data LevelBarGetModeMethodInfo
instance (signature ~ (m Gtk.Enums.LevelBarMode), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarGetModeMethodInfo a signature where
    overloadedMethod = levelBarGetMode

instance O.OverloadedMethodInfo LevelBarGetModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarGetMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarGetMode"
        })


#endif

-- method LevelBar::get_offset_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of an offset in the bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location where to store the value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_get_offset_value" gtk_level_bar_get_offset_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr CDouble ->                          -- value : TBasicType TDouble
    IO CInt

-- | Fetches the value specified for the offset marker /@name@/ in /@self@/.
levelBarGetOffsetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> Maybe (T.Text)
    -- ^ /@name@/: the name of an offset in the bar
    -> m ((Bool, Double))
    -- ^ __Returns:__ 'P.True' if the specified offset is found
levelBarGetOffsetValue self name = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    value <- allocMem :: IO (Ptr CDouble)
    result <- gtk_level_bar_get_offset_value self' maybeName value
    let result' = (/= 0) result
    value' <- peek value
    let value'' = realToFrac value'
    touchManagedPtr self
    freeMem maybeName
    freeMem value
    return (result', value'')

#if defined(ENABLE_OVERLOADING)
data LevelBarGetOffsetValueMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ((Bool, Double))), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarGetOffsetValueMethodInfo a signature where
    overloadedMethod = levelBarGetOffsetValue

instance O.OverloadedMethodInfo LevelBarGetOffsetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarGetOffsetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarGetOffsetValue"
        })


#endif

-- method LevelBar::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_get_value" gtk_level_bar_get_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    IO CDouble

-- | Returns the @value@ of the @GtkLevelBar@.
levelBarGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> m Double
    -- ^ __Returns:__ a value in the interval between
    --   [LevelBar:minValue]("GI.Gtk.Objects.LevelBar#g:attr:minValue") and [LevelBar:maxValue]("GI.Gtk.Objects.LevelBar#g:attr:maxValue")
levelBarGetValue self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_level_bar_get_value self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data LevelBarGetValueMethodInfo
instance (signature ~ (m Double), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarGetValueMethodInfo a signature where
    overloadedMethod = levelBarGetValue

instance O.OverloadedMethodInfo LevelBarGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarGetValue"
        })


#endif

-- method LevelBar::remove_offset_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of an offset in the bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_remove_offset_value" gtk_level_bar_remove_offset_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Removes an offset marker from a @GtkLevelBar@.
-- 
-- The marker must have been previously added with
-- 'GI.Gtk.Objects.LevelBar.levelBarAddOffsetValue'.
levelBarRemoveOffsetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> Maybe (T.Text)
    -- ^ /@name@/: the name of an offset in the bar
    -> m ()
levelBarRemoveOffsetValue self name = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    gtk_level_bar_remove_offset_value self' maybeName
    touchManagedPtr self
    freeMem maybeName
    return ()

#if defined(ENABLE_OVERLOADING)
data LevelBarRemoveOffsetValueMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarRemoveOffsetValueMethodInfo a signature where
    overloadedMethod = levelBarRemoveOffsetValue

instance O.OverloadedMethodInfo LevelBarRemoveOffsetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarRemoveOffsetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarRemoveOffsetValue"
        })


#endif

-- method LevelBar::set_inverted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "inverted"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to invert the level bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_set_inverted" gtk_level_bar_set_inverted :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CInt ->                                 -- inverted : TBasicType TBoolean
    IO ()

-- | Sets whether the @GtkLevelBar@ is inverted.
levelBarSetInverted ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> Bool
    -- ^ /@inverted@/: 'P.True' to invert the level bar
    -> m ()
levelBarSetInverted self inverted = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let inverted' = (P.fromIntegral . P.fromEnum) inverted
    gtk_level_bar_set_inverted self' inverted'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data LevelBarSetInvertedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarSetInvertedMethodInfo a signature where
    overloadedMethod = levelBarSetInverted

instance O.OverloadedMethodInfo LevelBarSetInvertedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarSetInverted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarSetInverted"
        })


#endif

-- method LevelBar::set_max_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a positive value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_set_max_value" gtk_level_bar_set_max_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CDouble ->                              -- value : TBasicType TDouble
    IO ()

-- | Sets the @max-value@ of the @GtkLevelBar@.
-- 
-- You probably want to update preexisting level offsets after calling
-- this function.
levelBarSetMaxValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> Double
    -- ^ /@value@/: a positive value
    -> m ()
levelBarSetMaxValue self value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let value' = realToFrac value
    gtk_level_bar_set_max_value self' value'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data LevelBarSetMaxValueMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarSetMaxValueMethodInfo a signature where
    overloadedMethod = levelBarSetMaxValue

instance O.OverloadedMethodInfo LevelBarSetMaxValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarSetMaxValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarSetMaxValue"
        })


#endif

-- method LevelBar::set_min_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a positive value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_set_min_value" gtk_level_bar_set_min_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CDouble ->                              -- value : TBasicType TDouble
    IO ()

-- | Sets the @min-value@ of the @GtkLevelBar@.
-- 
-- You probably want to update preexisting level offsets after calling
-- this function.
levelBarSetMinValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> Double
    -- ^ /@value@/: a positive value
    -> m ()
levelBarSetMinValue self value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let value' = realToFrac value
    gtk_level_bar_set_min_value self' value'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data LevelBarSetMinValueMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarSetMinValueMethodInfo a signature where
    overloadedMethod = levelBarSetMinValue

instance O.OverloadedMethodInfo LevelBarSetMinValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarSetMinValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarSetMinValue"
        })


#endif

-- method LevelBar::set_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBarMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBarMode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_set_mode" gtk_level_bar_set_mode :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Gtk", name = "LevelBarMode"})
    IO ()

-- | Sets the @mode@ of the @GtkLevelBar@.
levelBarSetMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> Gtk.Enums.LevelBarMode
    -- ^ /@mode@/: a @GtkLevelBarMode@
    -> m ()
levelBarSetMode self mode = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let mode' = (fromIntegral . fromEnum) mode
    gtk_level_bar_set_mode self' mode'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data LevelBarSetModeMethodInfo
instance (signature ~ (Gtk.Enums.LevelBarMode -> m ()), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarSetModeMethodInfo a signature where
    overloadedMethod = levelBarSetMode

instance O.OverloadedMethodInfo LevelBarSetModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarSetMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarSetMode"
        })


#endif

-- method LevelBar::set_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LevelBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLevelBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a value in the interval between\n  [property@Gtk.LevelBar:min-value] and [property@Gtk.LevelBar:max-value]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_level_bar_set_value" gtk_level_bar_set_value :: 
    Ptr LevelBar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "LevelBar"})
    CDouble ->                              -- value : TBasicType TDouble
    IO ()

-- | Sets the value of the @GtkLevelBar@.
levelBarSetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsLevelBar a) =>
    a
    -- ^ /@self@/: a @GtkLevelBar@
    -> Double
    -- ^ /@value@/: a value in the interval between
    --   [LevelBar:minValue]("GI.Gtk.Objects.LevelBar#g:attr:minValue") and [LevelBar:maxValue]("GI.Gtk.Objects.LevelBar#g:attr:maxValue")
    -> m ()
levelBarSetValue self value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let value' = realToFrac value
    gtk_level_bar_set_value self' value'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data LevelBarSetValueMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsLevelBar a) => O.OverloadedMethod LevelBarSetValueMethodInfo a signature where
    overloadedMethod = levelBarSetValue

instance O.OverloadedMethodInfo LevelBarSetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LevelBar.levelBarSetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-LevelBar.html#v:levelBarSetValue"
        })


#endif


