{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkInfoBar@ can be used to show messages to the user without a dialog.
-- 
-- \<picture>
--   \<source srcset=\"info-bar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkInfoBar\" src=\"info-bar.png\">
-- \<\/picture>
-- 
-- It is often temporarily shown at the top or bottom of a document.
-- In contrast to t'GI.Gtk.Objects.Dialog.Dialog', which has an action area at the
-- bottom, @GtkInfoBar@ has an action area at the side.
-- 
-- The API of @GtkInfoBar@ is very similar to @GtkDialog@, allowing you
-- to add buttons to the action area with 'GI.Gtk.Objects.InfoBar.infoBarAddButton'
-- or t'GI.Gtk.Objects.InfoBar.InfoBar'.@/new_with_buttons/@(). The sensitivity of action widgets
-- can be controlled with 'GI.Gtk.Objects.InfoBar.infoBarSetResponseSensitive'.
-- 
-- To add widgets to the main content area of a @GtkInfoBar@, use
-- 'GI.Gtk.Objects.InfoBar.infoBarAddChild'.
-- 
-- Similar to t'GI.Gtk.Objects.MessageDialog.MessageDialog', the contents of a @GtkInfoBar@
-- can by classified as error message, warning, informational message, etc,
-- by using 'GI.Gtk.Objects.InfoBar.infoBarSetMessageType'. GTK may use the message
-- type to determine how the message is displayed.
-- 
-- A simple example for using a @GtkInfoBar@:
-- 
-- === /c code/
-- >GtkWidget *message_label;
-- >GtkWidget *widget;
-- >GtkWidget *grid;
-- >GtkInfoBar *bar;
-- >
-- >// set up info bar
-- >widget = gtk_info_bar_new ();
-- >bar = GTK_INFO_BAR (widget);
-- >grid = gtk_grid_new ();
-- >
-- >message_label = gtk_label_new ("");
-- >gtk_info_bar_add_child (bar, message_label);
-- >gtk_info_bar_add_button (bar,
-- >                         _("_OK"),
-- >                         GTK_RESPONSE_OK);
-- >g_signal_connect (bar,
-- >                  "response",
-- >                  G_CALLBACK (gtk_widget_hide),
-- >                  NULL);
-- >gtk_grid_attach (GTK_GRID (grid),
-- >                 widget,
-- >                 0, 2, 1, 1);
-- >
-- >// ...
-- >
-- >// show an error message
-- >gtk_label_set_text (GTK_LABEL (message_label), "An error occurred!");
-- >gtk_info_bar_set_message_type (bar, GTK_MESSAGE_ERROR);
-- >gtk_widget_show (bar);
-- 
-- 
-- = GtkInfoBar as GtkBuildable
-- 
-- @GtkInfoBar@ supports a custom @\<action-widgets>@ element, which can contain
-- multiple @\<action-widget>@ elements. The “response” attribute specifies a
-- numeric response, and the content of the element is the id of widget
-- (which should be a child of the dialogs /@actionArea@/).
-- 
-- @GtkInfoBar@ supports adding action widgets by specifying “action” as
-- the “type” attribute of a @\<child>@ element. The widget will be added
-- either to the action area. The response id has to be associated
-- with the action widget using the @\<action-widgets>@ element.
-- 
-- = CSS nodes
-- 
-- @GtkInfoBar@ has a single CSS node with name infobar. The node may get
-- one of the style classes .info, .warning, .error or .question, depending
-- on the message type.
-- If the info bar shows a close button, that button will have the .close
-- style class applied.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.InfoBar
    ( 

-- * Exported types
    InfoBar(..)                             ,
    IsInfoBar                               ,
    toInfoBar                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addActionWidget]("GI.Gtk.Objects.InfoBar#g:method:addActionWidget"), [addButton]("GI.Gtk.Objects.InfoBar#g:method:addButton"), [addChild]("GI.Gtk.Objects.InfoBar#g:method:addChild"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeActionWidget]("GI.Gtk.Objects.InfoBar#g:method:removeActionWidget"), [removeChild]("GI.Gtk.Objects.InfoBar#g:method:removeChild"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [response]("GI.Gtk.Objects.InfoBar#g:method:response"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMessageType]("GI.Gtk.Objects.InfoBar#g:method:getMessageType"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRevealed]("GI.Gtk.Objects.InfoBar#g:method:getRevealed"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowCloseButton]("GI.Gtk.Objects.InfoBar#g:method:getShowCloseButton"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultResponse]("GI.Gtk.Objects.InfoBar#g:method:setDefaultResponse"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMessageType]("GI.Gtk.Objects.InfoBar#g:method:setMessageType"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResponseSensitive]("GI.Gtk.Objects.InfoBar#g:method:setResponseSensitive"), [setRevealed]("GI.Gtk.Objects.InfoBar#g:method:setRevealed"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowCloseButton]("GI.Gtk.Objects.InfoBar#g:method:setShowCloseButton"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveInfoBarMethod                    ,
#endif

-- ** addActionWidget #method:addActionWidget#

#if defined(ENABLE_OVERLOADING)
    InfoBarAddActionWidgetMethodInfo        ,
#endif
    infoBarAddActionWidget                  ,


-- ** addButton #method:addButton#

#if defined(ENABLE_OVERLOADING)
    InfoBarAddButtonMethodInfo              ,
#endif
    infoBarAddButton                        ,


-- ** addChild #method:addChild#

#if defined(ENABLE_OVERLOADING)
    InfoBarAddChildMethodInfo               ,
#endif
    infoBarAddChild                         ,


-- ** getMessageType #method:getMessageType#

#if defined(ENABLE_OVERLOADING)
    InfoBarGetMessageTypeMethodInfo         ,
#endif
    infoBarGetMessageType                   ,


-- ** getRevealed #method:getRevealed#

#if defined(ENABLE_OVERLOADING)
    InfoBarGetRevealedMethodInfo            ,
#endif
    infoBarGetRevealed                      ,


-- ** getShowCloseButton #method:getShowCloseButton#

#if defined(ENABLE_OVERLOADING)
    InfoBarGetShowCloseButtonMethodInfo     ,
#endif
    infoBarGetShowCloseButton               ,


-- ** new #method:new#

    infoBarNew                              ,


-- ** removeActionWidget #method:removeActionWidget#

#if defined(ENABLE_OVERLOADING)
    InfoBarRemoveActionWidgetMethodInfo     ,
#endif
    infoBarRemoveActionWidget               ,


-- ** removeChild #method:removeChild#

#if defined(ENABLE_OVERLOADING)
    InfoBarRemoveChildMethodInfo            ,
#endif
    infoBarRemoveChild                      ,


-- ** response #method:response#

#if defined(ENABLE_OVERLOADING)
    InfoBarResponseMethodInfo               ,
#endif
    infoBarResponse                         ,


-- ** setDefaultResponse #method:setDefaultResponse#

#if defined(ENABLE_OVERLOADING)
    InfoBarSetDefaultResponseMethodInfo     ,
#endif
    infoBarSetDefaultResponse               ,


-- ** setMessageType #method:setMessageType#

#if defined(ENABLE_OVERLOADING)
    InfoBarSetMessageTypeMethodInfo         ,
#endif
    infoBarSetMessageType                   ,


-- ** setResponseSensitive #method:setResponseSensitive#

#if defined(ENABLE_OVERLOADING)
    InfoBarSetResponseSensitiveMethodInfo   ,
#endif
    infoBarSetResponseSensitive             ,


-- ** setRevealed #method:setRevealed#

#if defined(ENABLE_OVERLOADING)
    InfoBarSetRevealedMethodInfo            ,
#endif
    infoBarSetRevealed                      ,


-- ** setShowCloseButton #method:setShowCloseButton#

#if defined(ENABLE_OVERLOADING)
    InfoBarSetShowCloseButtonMethodInfo     ,
#endif
    infoBarSetShowCloseButton               ,




 -- * Properties


-- ** messageType #attr:messageType#
-- | The type of the message.
-- 
-- The type may be used to determine the appearance of the info bar.

#if defined(ENABLE_OVERLOADING)
    InfoBarMessageTypePropertyInfo          ,
#endif
    constructInfoBarMessageType             ,
    getInfoBarMessageType                   ,
#if defined(ENABLE_OVERLOADING)
    infoBarMessageType                      ,
#endif
    setInfoBarMessageType                   ,


-- ** revealed #attr:revealed#
-- | Whether the info bar shows its contents.

#if defined(ENABLE_OVERLOADING)
    InfoBarRevealedPropertyInfo             ,
#endif
    constructInfoBarRevealed                ,
    getInfoBarRevealed                      ,
#if defined(ENABLE_OVERLOADING)
    infoBarRevealed                         ,
#endif
    setInfoBarRevealed                      ,


-- ** showCloseButton #attr:showCloseButton#
-- | Whether to include a standard close button.

#if defined(ENABLE_OVERLOADING)
    InfoBarShowCloseButtonPropertyInfo      ,
#endif
    constructInfoBarShowCloseButton         ,
    getInfoBarShowCloseButton               ,
#if defined(ENABLE_OVERLOADING)
    infoBarShowCloseButton                  ,
#endif
    setInfoBarShowCloseButton               ,




 -- * Signals


-- ** close #signal:close#

    InfoBarCloseCallback                    ,
#if defined(ENABLE_OVERLOADING)
    InfoBarCloseSignalInfo                  ,
#endif
    afterInfoBarClose                       ,
    onInfoBarClose                          ,


-- ** response #signal:response#

    InfoBarResponseCallback                 ,
#if defined(ENABLE_OVERLOADING)
    InfoBarResponseSignalInfo               ,
#endif
    afterInfoBarResponse                    ,
    onInfoBarResponse                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Button as Gtk.Button
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Button as Gtk.Button
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype InfoBar = InfoBar (SP.ManagedPtr InfoBar)
    deriving (Eq)

instance SP.ManagedPtrNewtype InfoBar where
    toManagedPtr (InfoBar p) = p

foreign import ccall "gtk_info_bar_get_type"
    c_gtk_info_bar_get_type :: IO B.Types.GType

instance B.Types.TypedObject InfoBar where
    glibType = c_gtk_info_bar_get_type

instance B.Types.GObject InfoBar

-- | Type class for types which can be safely cast to `InfoBar`, for instance with `toInfoBar`.
class (SP.GObject o, O.IsDescendantOf InfoBar o) => IsInfoBar o
instance (SP.GObject o, O.IsDescendantOf InfoBar o) => IsInfoBar o

instance O.HasParentTypes InfoBar
type instance O.ParentTypes InfoBar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `InfoBar`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toInfoBar :: (MIO.MonadIO m, IsInfoBar o) => o -> m InfoBar
toInfoBar = MIO.liftIO . B.ManagedPtr.unsafeCastTo InfoBar

-- | Convert 'InfoBar' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe InfoBar) where
    gvalueGType_ = c_gtk_info_bar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr InfoBar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr InfoBar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject InfoBar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveInfoBarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInfoBarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveInfoBarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveInfoBarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveInfoBarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveInfoBarMethod "addActionWidget" o = InfoBarAddActionWidgetMethodInfo
    ResolveInfoBarMethod "addButton" o = InfoBarAddButtonMethodInfo
    ResolveInfoBarMethod "addChild" o = InfoBarAddChildMethodInfo
    ResolveInfoBarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveInfoBarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveInfoBarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveInfoBarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveInfoBarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveInfoBarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveInfoBarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveInfoBarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveInfoBarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveInfoBarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveInfoBarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveInfoBarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveInfoBarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveInfoBarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveInfoBarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveInfoBarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveInfoBarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveInfoBarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveInfoBarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveInfoBarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveInfoBarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveInfoBarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveInfoBarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveInfoBarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveInfoBarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveInfoBarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveInfoBarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveInfoBarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveInfoBarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveInfoBarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveInfoBarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveInfoBarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveInfoBarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveInfoBarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveInfoBarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveInfoBarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveInfoBarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveInfoBarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveInfoBarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveInfoBarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveInfoBarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveInfoBarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveInfoBarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveInfoBarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveInfoBarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveInfoBarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveInfoBarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveInfoBarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveInfoBarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveInfoBarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveInfoBarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveInfoBarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveInfoBarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveInfoBarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveInfoBarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveInfoBarMethod "removeActionWidget" o = InfoBarRemoveActionWidgetMethodInfo
    ResolveInfoBarMethod "removeChild" o = InfoBarRemoveChildMethodInfo
    ResolveInfoBarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveInfoBarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveInfoBarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveInfoBarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveInfoBarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveInfoBarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveInfoBarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveInfoBarMethod "response" o = InfoBarResponseMethodInfo
    ResolveInfoBarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveInfoBarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveInfoBarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveInfoBarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveInfoBarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveInfoBarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveInfoBarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveInfoBarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveInfoBarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveInfoBarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveInfoBarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveInfoBarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveInfoBarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveInfoBarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveInfoBarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveInfoBarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveInfoBarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveInfoBarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveInfoBarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveInfoBarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveInfoBarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveInfoBarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveInfoBarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveInfoBarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveInfoBarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveInfoBarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveInfoBarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveInfoBarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveInfoBarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveInfoBarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveInfoBarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveInfoBarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveInfoBarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveInfoBarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveInfoBarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveInfoBarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveInfoBarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveInfoBarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveInfoBarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveInfoBarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveInfoBarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveInfoBarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveInfoBarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveInfoBarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveInfoBarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveInfoBarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveInfoBarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveInfoBarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveInfoBarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveInfoBarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveInfoBarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveInfoBarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveInfoBarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveInfoBarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveInfoBarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveInfoBarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveInfoBarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveInfoBarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveInfoBarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveInfoBarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveInfoBarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveInfoBarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveInfoBarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveInfoBarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveInfoBarMethod "getMessageType" o = InfoBarGetMessageTypeMethodInfo
    ResolveInfoBarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveInfoBarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveInfoBarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveInfoBarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveInfoBarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveInfoBarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveInfoBarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveInfoBarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveInfoBarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveInfoBarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveInfoBarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveInfoBarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveInfoBarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveInfoBarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveInfoBarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveInfoBarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveInfoBarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveInfoBarMethod "getRevealed" o = InfoBarGetRevealedMethodInfo
    ResolveInfoBarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveInfoBarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveInfoBarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveInfoBarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveInfoBarMethod "getShowCloseButton" o = InfoBarGetShowCloseButtonMethodInfo
    ResolveInfoBarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveInfoBarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveInfoBarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveInfoBarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveInfoBarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveInfoBarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveInfoBarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveInfoBarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveInfoBarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveInfoBarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveInfoBarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveInfoBarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveInfoBarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveInfoBarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveInfoBarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveInfoBarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveInfoBarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveInfoBarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveInfoBarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveInfoBarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveInfoBarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveInfoBarMethod "setDefaultResponse" o = InfoBarSetDefaultResponseMethodInfo
    ResolveInfoBarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveInfoBarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveInfoBarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveInfoBarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveInfoBarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveInfoBarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveInfoBarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveInfoBarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveInfoBarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveInfoBarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveInfoBarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveInfoBarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveInfoBarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveInfoBarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveInfoBarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveInfoBarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveInfoBarMethod "setMessageType" o = InfoBarSetMessageTypeMethodInfo
    ResolveInfoBarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveInfoBarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveInfoBarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveInfoBarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveInfoBarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveInfoBarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveInfoBarMethod "setResponseSensitive" o = InfoBarSetResponseSensitiveMethodInfo
    ResolveInfoBarMethod "setRevealed" o = InfoBarSetRevealedMethodInfo
    ResolveInfoBarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveInfoBarMethod "setShowCloseButton" o = InfoBarSetShowCloseButtonMethodInfo
    ResolveInfoBarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveInfoBarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveInfoBarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveInfoBarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveInfoBarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveInfoBarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveInfoBarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveInfoBarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveInfoBarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInfoBarMethod t InfoBar, O.OverloadedMethod info InfoBar p) => OL.IsLabel t (InfoBar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInfoBarMethod t InfoBar, O.OverloadedMethod info InfoBar p, R.HasField t InfoBar p) => R.HasField t InfoBar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInfoBarMethod t InfoBar, O.OverloadedMethodInfo info InfoBar) => OL.IsLabel t (O.MethodProxy info InfoBar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal InfoBar::close
-- | Gets emitted when the user uses a keybinding to dismiss the info bar.
-- 
-- The [close](#g:signal:close) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is the Escape key.
type InfoBarCloseCallback =
    IO ()

type C_InfoBarCloseCallback =
    Ptr InfoBar ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_InfoBarCloseCallback`.
foreign import ccall "wrapper"
    mk_InfoBarCloseCallback :: C_InfoBarCloseCallback -> IO (FunPtr C_InfoBarCloseCallback)

wrap_InfoBarCloseCallback :: 
    GObject a => (a -> InfoBarCloseCallback) ->
    C_InfoBarCloseCallback
wrap_InfoBarCloseCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [close](#signal:close) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' infoBar #close callback
-- @
-- 
-- 
onInfoBarClose :: (IsInfoBar a, MonadIO m) => a -> ((?self :: a) => InfoBarCloseCallback) -> m SignalHandlerId
onInfoBarClose obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_InfoBarCloseCallback wrapped
    wrapped'' <- mk_InfoBarCloseCallback wrapped'
    connectSignalFunPtr obj "close" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [close](#signal:close) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' infoBar #close callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterInfoBarClose :: (IsInfoBar a, MonadIO m) => a -> ((?self :: a) => InfoBarCloseCallback) -> m SignalHandlerId
afterInfoBarClose obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_InfoBarCloseCallback wrapped
    wrapped'' <- mk_InfoBarCloseCallback wrapped'
    connectSignalFunPtr obj "close" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data InfoBarCloseSignalInfo
instance SignalInfo InfoBarCloseSignalInfo where
    type HaskellCallbackType InfoBarCloseSignalInfo = InfoBarCloseCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_InfoBarCloseCallback cb
        cb'' <- mk_InfoBarCloseCallback cb'
        connectSignalFunPtr obj "close" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar::close"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#g:signal:close"})

#endif

-- signal InfoBar::response
-- | Emitted when an action widget is clicked.
-- 
-- The signal is also emitted when the application programmer
-- calls 'GI.Gtk.Objects.InfoBar.infoBarResponse'. The /@responseId@/ depends
-- on which action widget was clicked.
type InfoBarResponseCallback =
    Int32
    -- ^ /@responseId@/: the response ID
    -> IO ()

type C_InfoBarResponseCallback =
    Ptr InfoBar ->                          -- object
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_InfoBarResponseCallback`.
foreign import ccall "wrapper"
    mk_InfoBarResponseCallback :: C_InfoBarResponseCallback -> IO (FunPtr C_InfoBarResponseCallback)

wrap_InfoBarResponseCallback :: 
    GObject a => (a -> InfoBarResponseCallback) ->
    C_InfoBarResponseCallback
wrap_InfoBarResponseCallback gi'cb gi'selfPtr responseId _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  responseId


-- | Connect a signal handler for the [response](#signal:response) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' infoBar #response callback
-- @
-- 
-- 
onInfoBarResponse :: (IsInfoBar a, MonadIO m) => a -> ((?self :: a) => InfoBarResponseCallback) -> m SignalHandlerId
onInfoBarResponse obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_InfoBarResponseCallback wrapped
    wrapped'' <- mk_InfoBarResponseCallback wrapped'
    connectSignalFunPtr obj "response" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [response](#signal:response) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' infoBar #response callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterInfoBarResponse :: (IsInfoBar a, MonadIO m) => a -> ((?self :: a) => InfoBarResponseCallback) -> m SignalHandlerId
afterInfoBarResponse obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_InfoBarResponseCallback wrapped
    wrapped'' <- mk_InfoBarResponseCallback wrapped'
    connectSignalFunPtr obj "response" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data InfoBarResponseSignalInfo
instance SignalInfo InfoBarResponseSignalInfo where
    type HaskellCallbackType InfoBarResponseSignalInfo = InfoBarResponseCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_InfoBarResponseCallback cb
        cb'' <- mk_InfoBarResponseCallback cb'
        connectSignalFunPtr obj "response" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar::response"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#g:signal:response"})

#endif

-- VVV Prop "message-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "MessageType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@message-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' infoBar #messageType
-- @
getInfoBarMessageType :: (MonadIO m, IsInfoBar o) => o -> m Gtk.Enums.MessageType
getInfoBarMessageType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "message-type"

-- | Set the value of the “@message-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' infoBar [ #messageType 'Data.GI.Base.Attributes.:=' value ]
-- @
setInfoBarMessageType :: (MonadIO m, IsInfoBar o) => o -> Gtk.Enums.MessageType -> m ()
setInfoBarMessageType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "message-type" val

-- | Construct a `GValueConstruct` with valid value for the “@message-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInfoBarMessageType :: (IsInfoBar o, MIO.MonadIO m) => Gtk.Enums.MessageType -> m (GValueConstruct o)
constructInfoBarMessageType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "message-type" val

#if defined(ENABLE_OVERLOADING)
data InfoBarMessageTypePropertyInfo
instance AttrInfo InfoBarMessageTypePropertyInfo where
    type AttrAllowedOps InfoBarMessageTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InfoBarMessageTypePropertyInfo = IsInfoBar
    type AttrSetTypeConstraint InfoBarMessageTypePropertyInfo = (~) Gtk.Enums.MessageType
    type AttrTransferTypeConstraint InfoBarMessageTypePropertyInfo = (~) Gtk.Enums.MessageType
    type AttrTransferType InfoBarMessageTypePropertyInfo = Gtk.Enums.MessageType
    type AttrGetType InfoBarMessageTypePropertyInfo = Gtk.Enums.MessageType
    type AttrLabel InfoBarMessageTypePropertyInfo = "message-type"
    type AttrOrigin InfoBarMessageTypePropertyInfo = InfoBar
    attrGet = getInfoBarMessageType
    attrSet = setInfoBarMessageType
    attrTransfer _ v = do
        return v
    attrConstruct = constructInfoBarMessageType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.messageType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#g:attr:messageType"
        })
#endif

-- VVV Prop "revealed"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@revealed@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' infoBar #revealed
-- @
getInfoBarRevealed :: (MonadIO m, IsInfoBar o) => o -> m Bool
getInfoBarRevealed obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "revealed"

-- | Set the value of the “@revealed@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' infoBar [ #revealed 'Data.GI.Base.Attributes.:=' value ]
-- @
setInfoBarRevealed :: (MonadIO m, IsInfoBar o) => o -> Bool -> m ()
setInfoBarRevealed obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "revealed" val

-- | Construct a `GValueConstruct` with valid value for the “@revealed@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInfoBarRevealed :: (IsInfoBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructInfoBarRevealed val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "revealed" val

#if defined(ENABLE_OVERLOADING)
data InfoBarRevealedPropertyInfo
instance AttrInfo InfoBarRevealedPropertyInfo where
    type AttrAllowedOps InfoBarRevealedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InfoBarRevealedPropertyInfo = IsInfoBar
    type AttrSetTypeConstraint InfoBarRevealedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint InfoBarRevealedPropertyInfo = (~) Bool
    type AttrTransferType InfoBarRevealedPropertyInfo = Bool
    type AttrGetType InfoBarRevealedPropertyInfo = Bool
    type AttrLabel InfoBarRevealedPropertyInfo = "revealed"
    type AttrOrigin InfoBarRevealedPropertyInfo = InfoBar
    attrGet = getInfoBarRevealed
    attrSet = setInfoBarRevealed
    attrTransfer _ v = do
        return v
    attrConstruct = constructInfoBarRevealed
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.revealed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#g:attr:revealed"
        })
#endif

-- VVV Prop "show-close-button"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-close-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' infoBar #showCloseButton
-- @
getInfoBarShowCloseButton :: (MonadIO m, IsInfoBar o) => o -> m Bool
getInfoBarShowCloseButton obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-close-button"

-- | Set the value of the “@show-close-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' infoBar [ #showCloseButton 'Data.GI.Base.Attributes.:=' value ]
-- @
setInfoBarShowCloseButton :: (MonadIO m, IsInfoBar o) => o -> Bool -> m ()
setInfoBarShowCloseButton obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-close-button" val

-- | Construct a `GValueConstruct` with valid value for the “@show-close-button@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInfoBarShowCloseButton :: (IsInfoBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructInfoBarShowCloseButton val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-close-button" val

#if defined(ENABLE_OVERLOADING)
data InfoBarShowCloseButtonPropertyInfo
instance AttrInfo InfoBarShowCloseButtonPropertyInfo where
    type AttrAllowedOps InfoBarShowCloseButtonPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InfoBarShowCloseButtonPropertyInfo = IsInfoBar
    type AttrSetTypeConstraint InfoBarShowCloseButtonPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint InfoBarShowCloseButtonPropertyInfo = (~) Bool
    type AttrTransferType InfoBarShowCloseButtonPropertyInfo = Bool
    type AttrGetType InfoBarShowCloseButtonPropertyInfo = Bool
    type AttrLabel InfoBarShowCloseButtonPropertyInfo = "show-close-button"
    type AttrOrigin InfoBarShowCloseButtonPropertyInfo = InfoBar
    attrGet = getInfoBarShowCloseButton
    attrSet = setInfoBarShowCloseButton
    attrTransfer _ v = do
        return v
    attrConstruct = constructInfoBarShowCloseButton
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.showCloseButton"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#g:attr:showCloseButton"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InfoBar
type instance O.AttributeList InfoBar = InfoBarAttributeList
type InfoBarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("messageType", InfoBarMessageTypePropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("revealed", InfoBarRevealedPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showCloseButton", InfoBarShowCloseButtonPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
infoBarMessageType :: AttrLabelProxy "messageType"
infoBarMessageType = AttrLabelProxy

infoBarRevealed :: AttrLabelProxy "revealed"
infoBarRevealed = AttrLabelProxy

infoBarShowCloseButton :: AttrLabelProxy "showCloseButton"
infoBarShowCloseButton = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList InfoBar = InfoBarSignalList
type InfoBarSignalList = ('[ '("close", InfoBarCloseSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("response", InfoBarResponseSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method InfoBar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "InfoBar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_new" gtk_info_bar_new :: 
    IO (Ptr InfoBar)

{-# DEPRECATED infoBarNew ["(Since version 4.10)"] #-}
-- | Creates a new @GtkInfoBar@ object.
infoBarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m InfoBar
    -- ^ __Returns:__ a new @GtkInfoBar@ object
infoBarNew  = liftIO $ do
    result <- gtk_info_bar_new
    checkUnexpectedReturnNULL "infoBarNew" result
    result' <- (newObject InfoBar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method InfoBar::add_action_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an activatable widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "response_id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "response ID for @child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_add_action_widget" gtk_info_bar_add_action_widget :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- response_id : TBasicType TInt
    IO ()

{-# DEPRECATED infoBarAddActionWidget ["(Since version 4.10)"] #-}
-- | Add an activatable widget to the action area of a @GtkInfoBar@.
-- 
-- This also connects a signal handler that will emit the
-- [InfoBar::response]("GI.Gtk.Objects.InfoBar#g:signal:response") signal on the message area
-- when the widget is activated. The widget is appended to the
-- end of the message areas action area.
infoBarAddActionWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> b
    -- ^ /@child@/: an activatable widget
    -> Int32
    -- ^ /@responseId@/: response ID for /@child@/
    -> m ()
infoBarAddActionWidget infoBar child responseId = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    child' <- unsafeManagedPtrCastPtr child
    gtk_info_bar_add_action_widget infoBar' child' responseId
    touchManagedPtr infoBar
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarAddActionWidgetMethodInfo
instance (signature ~ (b -> Int32 -> m ()), MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod InfoBarAddActionWidgetMethodInfo a signature where
    overloadedMethod = infoBarAddActionWidget

instance O.OverloadedMethodInfo InfoBarAddActionWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarAddActionWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarAddActionWidget"
        })


#endif

-- method InfoBar::add_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text of button" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "response_id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "response ID for the button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Button" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_add_button" gtk_info_bar_add_button :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    CString ->                              -- button_text : TBasicType TUTF8
    Int32 ->                                -- response_id : TBasicType TInt
    IO (Ptr Gtk.Button.Button)

{-# DEPRECATED infoBarAddButton ["(Since version 4.10)"] #-}
-- | Adds a button with the given text.
-- 
-- Clicking the button will emit the [InfoBar::response]("GI.Gtk.Objects.InfoBar#g:signal:response")
-- signal with the given response_id. The button is appended to the
-- end of the info bar\'s action area. The button widget is returned,
-- but usually you don\'t need it.
infoBarAddButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> T.Text
    -- ^ /@buttonText@/: text of button
    -> Int32
    -- ^ /@responseId@/: response ID for the button
    -> m Gtk.Button.Button
    -- ^ __Returns:__ the @GtkButton@ widget
    -- that was added
infoBarAddButton infoBar buttonText responseId = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    buttonText' <- textToCString buttonText
    result <- gtk_info_bar_add_button infoBar' buttonText' responseId
    checkUnexpectedReturnNULL "infoBarAddButton" result
    result' <- (newObject Gtk.Button.Button) result
    touchManagedPtr infoBar
    freeMem buttonText'
    return result'

#if defined(ENABLE_OVERLOADING)
data InfoBarAddButtonMethodInfo
instance (signature ~ (T.Text -> Int32 -> m Gtk.Button.Button), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarAddButtonMethodInfo a signature where
    overloadedMethod = infoBarAddButton

instance O.OverloadedMethodInfo InfoBarAddButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarAddButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarAddButton"
        })


#endif

-- method InfoBar::add_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child to be added"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_add_child" gtk_info_bar_add_child :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

{-# DEPRECATED infoBarAddChild ["(Since version 4.10)"] #-}
-- | Adds a widget to the content area of the info bar.
infoBarAddChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> b
    -- ^ /@widget@/: the child to be added
    -> m ()
infoBarAddChild infoBar widget = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    widget' <- unsafeManagedPtrCastPtr widget
    gtk_info_bar_add_child infoBar' widget'
    touchManagedPtr infoBar
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarAddChildMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod InfoBarAddChildMethodInfo a signature where
    overloadedMethod = infoBarAddChild

instance O.OverloadedMethodInfo InfoBarAddChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarAddChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarAddChild"
        })


#endif

-- method InfoBar::get_message_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MessageType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_get_message_type" gtk_info_bar_get_message_type :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    IO CUInt

{-# DEPRECATED infoBarGetMessageType ["(Since version 4.10)"] #-}
-- | Returns the message type of the message area.
infoBarGetMessageType ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> m Gtk.Enums.MessageType
    -- ^ __Returns:__ the message type of the message area.
infoBarGetMessageType infoBar = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    result <- gtk_info_bar_get_message_type infoBar'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr infoBar
    return result'

#if defined(ENABLE_OVERLOADING)
data InfoBarGetMessageTypeMethodInfo
instance (signature ~ (m Gtk.Enums.MessageType), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarGetMessageTypeMethodInfo a signature where
    overloadedMethod = infoBarGetMessageType

instance O.OverloadedMethodInfo InfoBarGetMessageTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarGetMessageType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarGetMessageType"
        })


#endif

-- method InfoBar::get_revealed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_get_revealed" gtk_info_bar_get_revealed :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    IO CInt

{-# DEPRECATED infoBarGetRevealed ["(Since version 4.10)"] #-}
-- | Returns whether the info bar is currently revealed.
infoBarGetRevealed ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> m Bool
    -- ^ __Returns:__ the current value of the [InfoBar:revealed]("GI.Gtk.Objects.InfoBar#g:attr:revealed") property
infoBarGetRevealed infoBar = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    result <- gtk_info_bar_get_revealed infoBar'
    let result' = (/= 0) result
    touchManagedPtr infoBar
    return result'

#if defined(ENABLE_OVERLOADING)
data InfoBarGetRevealedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarGetRevealedMethodInfo a signature where
    overloadedMethod = infoBarGetRevealed

instance O.OverloadedMethodInfo InfoBarGetRevealedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarGetRevealed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarGetRevealed"
        })


#endif

-- method InfoBar::get_show_close_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_get_show_close_button" gtk_info_bar_get_show_close_button :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    IO CInt

{-# DEPRECATED infoBarGetShowCloseButton ["(Since version 4.10)"] #-}
-- | Returns whether the widget will display a standard close button.
infoBarGetShowCloseButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the widget displays standard close button
infoBarGetShowCloseButton infoBar = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    result <- gtk_info_bar_get_show_close_button infoBar'
    let result' = (/= 0) result
    touchManagedPtr infoBar
    return result'

#if defined(ENABLE_OVERLOADING)
data InfoBarGetShowCloseButtonMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarGetShowCloseButtonMethodInfo a signature where
    overloadedMethod = infoBarGetShowCloseButton

instance O.OverloadedMethodInfo InfoBarGetShowCloseButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarGetShowCloseButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarGetShowCloseButton"
        })


#endif

-- method InfoBar::remove_action_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an action widget to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_remove_action_widget" gtk_info_bar_remove_action_widget :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

{-# DEPRECATED infoBarRemoveActionWidget ["(Since version 4.10)"] #-}
-- | Removes a widget from the action area of /@infoBar@/.
-- 
-- The widget must have been put there by a call to
-- 'GI.Gtk.Objects.InfoBar.infoBarAddActionWidget' or 'GI.Gtk.Objects.InfoBar.infoBarAddButton'.
infoBarRemoveActionWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> b
    -- ^ /@widget@/: an action widget to remove
    -> m ()
infoBarRemoveActionWidget infoBar widget = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    widget' <- unsafeManagedPtrCastPtr widget
    gtk_info_bar_remove_action_widget infoBar' widget'
    touchManagedPtr infoBar
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarRemoveActionWidgetMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod InfoBarRemoveActionWidgetMethodInfo a signature where
    overloadedMethod = infoBarRemoveActionWidget

instance O.OverloadedMethodInfo InfoBarRemoveActionWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarRemoveActionWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarRemoveActionWidget"
        })


#endif

-- method InfoBar::remove_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a child that has been added to the content area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_remove_child" gtk_info_bar_remove_child :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

{-# DEPRECATED infoBarRemoveChild ["(Since version 4.10)"] #-}
-- | Removes a widget from the content area of the info bar.
infoBarRemoveChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> b
    -- ^ /@widget@/: a child that has been added to the content area
    -> m ()
infoBarRemoveChild infoBar widget = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    widget' <- unsafeManagedPtrCastPtr widget
    gtk_info_bar_remove_child infoBar' widget'
    touchManagedPtr infoBar
    touchManagedPtr widget
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarRemoveChildMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsInfoBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod InfoBarRemoveChildMethodInfo a signature where
    overloadedMethod = infoBarRemoveChild

instance O.OverloadedMethodInfo InfoBarRemoveChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarRemoveChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarRemoveChild"
        })


#endif

-- method InfoBar::response
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "response_id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a response ID" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_response" gtk_info_bar_response :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    Int32 ->                                -- response_id : TBasicType TInt
    IO ()

{-# DEPRECATED infoBarResponse ["(Since version 4.10)"] #-}
-- | Emits the “response” signal with the given /@responseId@/.
infoBarResponse ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> Int32
    -- ^ /@responseId@/: a response ID
    -> m ()
infoBarResponse infoBar responseId = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    gtk_info_bar_response infoBar' responseId
    touchManagedPtr infoBar
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarResponseMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarResponseMethodInfo a signature where
    overloadedMethod = infoBarResponse

instance O.OverloadedMethodInfo InfoBarResponseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarResponse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarResponse"
        })


#endif

-- method InfoBar::set_default_response
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "response_id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a response ID" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_set_default_response" gtk_info_bar_set_default_response :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    Int32 ->                                -- response_id : TBasicType TInt
    IO ()

{-# DEPRECATED infoBarSetDefaultResponse ["(Since version 4.10)"] #-}
-- | Sets the last widget in the info bar’s action area with
-- the given response_id as the default widget for the dialog.
-- 
-- Pressing “Enter” normally activates the default widget.
-- 
-- Note that this function currently requires /@infoBar@/ to
-- be added to a widget hierarchy.
infoBarSetDefaultResponse ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> Int32
    -- ^ /@responseId@/: a response ID
    -> m ()
infoBarSetDefaultResponse infoBar responseId = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    gtk_info_bar_set_default_response infoBar' responseId
    touchManagedPtr infoBar
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarSetDefaultResponseMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarSetDefaultResponseMethodInfo a signature where
    overloadedMethod = infoBarSetDefaultResponse

instance O.OverloadedMethodInfo InfoBarSetDefaultResponseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarSetDefaultResponse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarSetDefaultResponse"
        })


#endif

-- method InfoBar::set_message_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message_type"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MessageType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMessageType`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_set_message_type" gtk_info_bar_set_message_type :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    CUInt ->                                -- message_type : TInterface (Name {namespace = "Gtk", name = "MessageType"})
    IO ()

{-# DEPRECATED infoBarSetMessageType ["(Since version 4.10)"] #-}
-- | Sets the message type of the message area.
-- 
-- GTK uses this type to determine how the message is displayed.
infoBarSetMessageType ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> Gtk.Enums.MessageType
    -- ^ /@messageType@/: a @GtkMessageType@
    -> m ()
infoBarSetMessageType infoBar messageType = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    let messageType' = (fromIntegral . fromEnum) messageType
    gtk_info_bar_set_message_type infoBar' messageType'
    touchManagedPtr infoBar
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarSetMessageTypeMethodInfo
instance (signature ~ (Gtk.Enums.MessageType -> m ()), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarSetMessageTypeMethodInfo a signature where
    overloadedMethod = infoBarSetMessageType

instance O.OverloadedMethodInfo InfoBarSetMessageTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarSetMessageType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarSetMessageType"
        })


#endif

-- method InfoBar::set_response_sensitive
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "response_id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a response ID" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "TRUE for sensitive" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_set_response_sensitive" gtk_info_bar_set_response_sensitive :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    Int32 ->                                -- response_id : TBasicType TInt
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED infoBarSetResponseSensitive ["(Since version 4.10)"] #-}
-- | Sets the sensitivity of action widgets for /@responseId@/.
-- 
-- Calls @gtk_widget_set_sensitive (widget, setting)@ for each
-- widget in the info bars’s action area with the given /@responseId@/.
-- A convenient way to sensitize\/desensitize buttons.
infoBarSetResponseSensitive ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> Int32
    -- ^ /@responseId@/: a response ID
    -> Bool
    -- ^ /@setting@/: TRUE for sensitive
    -> m ()
infoBarSetResponseSensitive infoBar responseId setting = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_info_bar_set_response_sensitive infoBar' responseId setting'
    touchManagedPtr infoBar
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarSetResponseSensitiveMethodInfo
instance (signature ~ (Int32 -> Bool -> m ()), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarSetResponseSensitiveMethodInfo a signature where
    overloadedMethod = infoBarSetResponseSensitive

instance O.OverloadedMethodInfo InfoBarSetResponseSensitiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarSetResponseSensitive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarSetResponseSensitive"
        })


#endif

-- method InfoBar::set_revealed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "revealed"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The new value of the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_set_revealed" gtk_info_bar_set_revealed :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    CInt ->                                 -- revealed : TBasicType TBoolean
    IO ()

{-# DEPRECATED infoBarSetRevealed ["(Since version 4.10)"] #-}
-- | Sets whether the @GtkInfoBar@ is revealed.
-- 
-- Changing this will make /@infoBar@/ reveal or conceal
-- itself via a sliding transition.
-- 
-- Note: this does not show or hide /@infoBar@/ in the
-- [Widget:visible]("GI.Gtk.Objects.Widget#g:attr:visible") sense, so revealing has no effect
-- if [Widget:visible]("GI.Gtk.Objects.Widget#g:attr:visible") is 'P.False'.
infoBarSetRevealed ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> Bool
    -- ^ /@revealed@/: The new value of the property
    -> m ()
infoBarSetRevealed infoBar revealed = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    let revealed' = (P.fromIntegral . P.fromEnum) revealed
    gtk_info_bar_set_revealed infoBar' revealed'
    touchManagedPtr infoBar
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarSetRevealedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarSetRevealedMethodInfo a signature where
    overloadedMethod = infoBarSetRevealed

instance O.OverloadedMethodInfo InfoBarSetRevealedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarSetRevealed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarSetRevealed"
        })


#endif

-- method InfoBar::set_show_close_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info_bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InfoBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInfoBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to include a close button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_info_bar_set_show_close_button" gtk_info_bar_set_show_close_button :: 
    Ptr InfoBar ->                          -- info_bar : TInterface (Name {namespace = "Gtk", name = "InfoBar"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

{-# DEPRECATED infoBarSetShowCloseButton ["(Since version 4.10)"] #-}
-- | If true, a standard close button is shown.
-- 
-- When clicked it emits the response 'GI.Gtk.Enums.ResponseTypeClose'.
infoBarSetShowCloseButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsInfoBar a) =>
    a
    -- ^ /@infoBar@/: a @GtkInfoBar@
    -> Bool
    -- ^ /@setting@/: 'P.True' to include a close button
    -> m ()
infoBarSetShowCloseButton infoBar setting = liftIO $ do
    infoBar' <- unsafeManagedPtrCastPtr infoBar
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_info_bar_set_show_close_button infoBar' setting'
    touchManagedPtr infoBar
    return ()

#if defined(ENABLE_OVERLOADING)
data InfoBarSetShowCloseButtonMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsInfoBar a) => O.OverloadedMethod InfoBarSetShowCloseButtonMethodInfo a signature where
    overloadedMethod = infoBarSetShowCloseButton

instance O.OverloadedMethodInfo InfoBarSetShowCloseButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.InfoBar.infoBarSetShowCloseButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-InfoBar.html#v:infoBarSetShowCloseButton"
        })


#endif


