{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Loads themed icons.
-- 
-- The main reason for using a name rather than simply providing a filename
-- is to allow different icons to be used depending on what “icon theme” is
-- selected by the user. The operation of icon themes on Linux and Unix
-- follows the <http://www.freedesktop.org/Standards/icon-theme-spec Icon Theme Specification>
-- There is a fallback icon theme, named @hicolor@, where applications
-- should install their icons, but additional icon themes can be installed
-- as operating system vendors and users choose.
-- 
-- In many cases, named themes are used indirectly, via t'GI.Gtk.Objects.Image.Image'
-- rather than directly, but looking up icons directly is also simple. The
-- @GtkIconTheme@ object acts as a database of all the icons in the current
-- theme. You can create new @GtkIconTheme@ objects, but it’s much more
-- efficient to use the standard icon theme of the @GtkWidget@ so that the
-- icon information is shared with other people looking up icons.
-- 
-- 
-- === /c code/
-- >GtkIconTheme *icon_theme;
-- >GtkIconPaintable *icon;
-- >GdkPaintable *paintable;
-- >
-- >icon_theme = gtk_icon_theme_get_for_display (gtk_widget_get_display (my_widget));
-- >icon = gtk_icon_theme_lookup_icon (icon_theme,
-- >                                   "my-icon-name", // icon name
-- >                                   48, // icon size
-- >                                   1,  // scale
-- >                                   0,  // flags);
-- >paintable = GDK_PAINTABLE (icon);
-- >// Use the paintable
-- >g_object_unref (icon);
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.IconTheme
    ( 

-- * Exported types
    IconTheme(..)                           ,
    IsIconTheme                             ,
    toIconTheme                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addResourcePath]("GI.Gtk.Objects.IconTheme#g:method:addResourcePath"), [addSearchPath]("GI.Gtk.Objects.IconTheme#g:method:addSearchPath"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasGicon]("GI.Gtk.Objects.IconTheme#g:method:hasGicon"), [hasIcon]("GI.Gtk.Objects.IconTheme#g:method:hasIcon"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [lookupByGicon]("GI.Gtk.Objects.IconTheme#g:method:lookupByGicon"), [lookupIcon]("GI.Gtk.Objects.IconTheme#g:method:lookupIcon"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gtk.Objects.IconTheme#g:method:getDisplay"), [getIconNames]("GI.Gtk.Objects.IconTheme#g:method:getIconNames"), [getIconSizes]("GI.Gtk.Objects.IconTheme#g:method:getIconSizes"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getResourcePath]("GI.Gtk.Objects.IconTheme#g:method:getResourcePath"), [getSearchPath]("GI.Gtk.Objects.IconTheme#g:method:getSearchPath"), [getThemeName]("GI.Gtk.Objects.IconTheme#g:method:getThemeName").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setResourcePath]("GI.Gtk.Objects.IconTheme#g:method:setResourcePath"), [setSearchPath]("GI.Gtk.Objects.IconTheme#g:method:setSearchPath"), [setThemeName]("GI.Gtk.Objects.IconTheme#g:method:setThemeName").

#if defined(ENABLE_OVERLOADING)
    ResolveIconThemeMethod                  ,
#endif

-- ** addResourcePath #method:addResourcePath#

#if defined(ENABLE_OVERLOADING)
    IconThemeAddResourcePathMethodInfo      ,
#endif
    iconThemeAddResourcePath                ,


-- ** addSearchPath #method:addSearchPath#

#if defined(ENABLE_OVERLOADING)
    IconThemeAddSearchPathMethodInfo        ,
#endif
    iconThemeAddSearchPath                  ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    IconThemeGetDisplayMethodInfo           ,
#endif
    iconThemeGetDisplay                     ,


-- ** getForDisplay #method:getForDisplay#

    iconThemeGetForDisplay                  ,


-- ** getIconNames #method:getIconNames#

#if defined(ENABLE_OVERLOADING)
    IconThemeGetIconNamesMethodInfo         ,
#endif
    iconThemeGetIconNames                   ,


-- ** getIconSizes #method:getIconSizes#

#if defined(ENABLE_OVERLOADING)
    IconThemeGetIconSizesMethodInfo         ,
#endif
    iconThemeGetIconSizes                   ,


-- ** getResourcePath #method:getResourcePath#

#if defined(ENABLE_OVERLOADING)
    IconThemeGetResourcePathMethodInfo      ,
#endif
    iconThemeGetResourcePath                ,


-- ** getSearchPath #method:getSearchPath#

#if defined(ENABLE_OVERLOADING)
    IconThemeGetSearchPathMethodInfo        ,
#endif
    iconThemeGetSearchPath                  ,


-- ** getThemeName #method:getThemeName#

#if defined(ENABLE_OVERLOADING)
    IconThemeGetThemeNameMethodInfo         ,
#endif
    iconThemeGetThemeName                   ,


-- ** hasGicon #method:hasGicon#

#if defined(ENABLE_OVERLOADING)
    IconThemeHasGiconMethodInfo             ,
#endif
    iconThemeHasGicon                       ,


-- ** hasIcon #method:hasIcon#

#if defined(ENABLE_OVERLOADING)
    IconThemeHasIconMethodInfo              ,
#endif
    iconThemeHasIcon                        ,


-- ** lookupByGicon #method:lookupByGicon#

#if defined(ENABLE_OVERLOADING)
    IconThemeLookupByGiconMethodInfo        ,
#endif
    iconThemeLookupByGicon                  ,


-- ** lookupIcon #method:lookupIcon#

#if defined(ENABLE_OVERLOADING)
    IconThemeLookupIconMethodInfo           ,
#endif
    iconThemeLookupIcon                     ,


-- ** new #method:new#

    iconThemeNew                            ,


-- ** setResourcePath #method:setResourcePath#

#if defined(ENABLE_OVERLOADING)
    IconThemeSetResourcePathMethodInfo      ,
#endif
    iconThemeSetResourcePath                ,


-- ** setSearchPath #method:setSearchPath#

#if defined(ENABLE_OVERLOADING)
    IconThemeSetSearchPathMethodInfo        ,
#endif
    iconThemeSetSearchPath                  ,


-- ** setThemeName #method:setThemeName#

#if defined(ENABLE_OVERLOADING)
    IconThemeSetThemeNameMethodInfo         ,
#endif
    iconThemeSetThemeName                   ,




 -- * Properties


-- ** display #attr:display#
-- | The display that this icon theme object is attached to.

#if defined(ENABLE_OVERLOADING)
    IconThemeDisplayPropertyInfo            ,
#endif
    clearIconThemeDisplay                   ,
    constructIconThemeDisplay               ,
    getIconThemeDisplay                     ,
#if defined(ENABLE_OVERLOADING)
    iconThemeDisplay                        ,
#endif
    setIconThemeDisplay                     ,


-- ** iconNames #attr:iconNames#
-- | The icon names that are supported by the icon theme.

#if defined(ENABLE_OVERLOADING)
    IconThemeIconNamesPropertyInfo          ,
#endif
    getIconThemeIconNames                   ,
#if defined(ENABLE_OVERLOADING)
    iconThemeIconNames                      ,
#endif


-- ** resourcePath #attr:resourcePath#
-- | Resource paths that will be looked at when looking for icons,
-- similar to search paths.
-- 
-- The resources are considered as part of the hicolor icon theme
-- and must be located in subdirectories that are defined in the
-- hicolor icon theme, such as @\@path\/16x16\/actions\/run.png@.
-- Icons that are directly placed in the resource path instead
-- of a subdirectory are also considered as ultimate fallback.

#if defined(ENABLE_OVERLOADING)
    IconThemeResourcePathPropertyInfo       ,
#endif
    clearIconThemeResourcePath              ,
    constructIconThemeResourcePath          ,
    getIconThemeResourcePath                ,
#if defined(ENABLE_OVERLOADING)
    iconThemeResourcePath                   ,
#endif
    setIconThemeResourcePath                ,


-- ** searchPath #attr:searchPath#
-- | The search path for this icon theme.
-- 
-- When looking for icons, GTK will search for a subdirectory of
-- one or more of the directories in the search path with the same
-- name as the icon theme containing an index.theme file. (Themes
-- from multiple of the path elements are combined to allow themes
-- to be extended by adding icons in the user’s home directory.)

#if defined(ENABLE_OVERLOADING)
    IconThemeSearchPathPropertyInfo         ,
#endif
    clearIconThemeSearchPath                ,
    constructIconThemeSearchPath            ,
    getIconThemeSearchPath                  ,
#if defined(ENABLE_OVERLOADING)
    iconThemeSearchPath                     ,
#endif
    setIconThemeSearchPath                  ,


-- ** themeName #attr:themeName#
-- | The name of the icon theme that is being used.
-- 
-- Unless set to a different value, this will be the value of
-- the @GtkSettings:gtk-icon-theme-name@ property of the @GtkSettings@
-- object associated to the display of the icontheme object.

#if defined(ENABLE_OVERLOADING)
    IconThemeThemeNamePropertyInfo          ,
#endif
    clearIconThemeThemeName                 ,
    constructIconThemeThemeName             ,
    getIconThemeThemeName                   ,
#if defined(ENABLE_OVERLOADING)
    iconThemeThemeName                      ,
#endif
    setIconThemeThemeName                   ,




 -- * Signals


-- ** changed #signal:changed#

    IconThemeChangedCallback                ,
#if defined(ENABLE_OVERLOADING)
    IconThemeChangedSignalInfo              ,
#endif
    afterIconThemeChanged                   ,
    onIconThemeChanged                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SymbolicPaintable as Gtk.SymbolicPaintable
import {-# SOURCE #-} qualified GI.Gtk.Objects.IconPaintable as Gtk.IconPaintable

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Objects.IconPaintable as Gtk.IconPaintable

#endif

-- | Memory-managed wrapper type.
newtype IconTheme = IconTheme (SP.ManagedPtr IconTheme)
    deriving (Eq)

instance SP.ManagedPtrNewtype IconTheme where
    toManagedPtr (IconTheme p) = p

foreign import ccall "gtk_icon_theme_get_type"
    c_gtk_icon_theme_get_type :: IO B.Types.GType

instance B.Types.TypedObject IconTheme where
    glibType = c_gtk_icon_theme_get_type

instance B.Types.GObject IconTheme

-- | Type class for types which can be safely cast to `IconTheme`, for instance with `toIconTheme`.
class (SP.GObject o, O.IsDescendantOf IconTheme o) => IsIconTheme o
instance (SP.GObject o, O.IsDescendantOf IconTheme o) => IsIconTheme o

instance O.HasParentTypes IconTheme
type instance O.ParentTypes IconTheme = '[GObject.Object.Object]

-- | Cast to `IconTheme`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toIconTheme :: (MIO.MonadIO m, IsIconTheme o) => o -> m IconTheme
toIconTheme = MIO.liftIO . B.ManagedPtr.unsafeCastTo IconTheme

-- | Convert 'IconTheme' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe IconTheme) where
    gvalueGType_ = c_gtk_icon_theme_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr IconTheme)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr IconTheme)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject IconTheme ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveIconThemeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIconThemeMethod "addResourcePath" o = IconThemeAddResourcePathMethodInfo
    ResolveIconThemeMethod "addSearchPath" o = IconThemeAddSearchPathMethodInfo
    ResolveIconThemeMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveIconThemeMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveIconThemeMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveIconThemeMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveIconThemeMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveIconThemeMethod "hasGicon" o = IconThemeHasGiconMethodInfo
    ResolveIconThemeMethod "hasIcon" o = IconThemeHasIconMethodInfo
    ResolveIconThemeMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveIconThemeMethod "lookupByGicon" o = IconThemeLookupByGiconMethodInfo
    ResolveIconThemeMethod "lookupIcon" o = IconThemeLookupIconMethodInfo
    ResolveIconThemeMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveIconThemeMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveIconThemeMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveIconThemeMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveIconThemeMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveIconThemeMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveIconThemeMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveIconThemeMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveIconThemeMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveIconThemeMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveIconThemeMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveIconThemeMethod "getDisplay" o = IconThemeGetDisplayMethodInfo
    ResolveIconThemeMethod "getIconNames" o = IconThemeGetIconNamesMethodInfo
    ResolveIconThemeMethod "getIconSizes" o = IconThemeGetIconSizesMethodInfo
    ResolveIconThemeMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveIconThemeMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveIconThemeMethod "getResourcePath" o = IconThemeGetResourcePathMethodInfo
    ResolveIconThemeMethod "getSearchPath" o = IconThemeGetSearchPathMethodInfo
    ResolveIconThemeMethod "getThemeName" o = IconThemeGetThemeNameMethodInfo
    ResolveIconThemeMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveIconThemeMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveIconThemeMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveIconThemeMethod "setResourcePath" o = IconThemeSetResourcePathMethodInfo
    ResolveIconThemeMethod "setSearchPath" o = IconThemeSetSearchPathMethodInfo
    ResolveIconThemeMethod "setThemeName" o = IconThemeSetThemeNameMethodInfo
    ResolveIconThemeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIconThemeMethod t IconTheme, O.OverloadedMethod info IconTheme p) => OL.IsLabel t (IconTheme -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIconThemeMethod t IconTheme, O.OverloadedMethod info IconTheme p, R.HasField t IconTheme p) => R.HasField t IconTheme p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIconThemeMethod t IconTheme, O.OverloadedMethodInfo info IconTheme) => OL.IsLabel t (O.MethodProxy info IconTheme) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal IconTheme::changed
-- | Emitted when the icon theme changes.
-- 
-- This can happen because current icon theme is switched or
-- because GTK detects that a change has occurred in the
-- contents of the current icon theme.
type IconThemeChangedCallback =
    IO ()

type C_IconThemeChangedCallback =
    Ptr IconTheme ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IconThemeChangedCallback`.
foreign import ccall "wrapper"
    mk_IconThemeChangedCallback :: C_IconThemeChangedCallback -> IO (FunPtr C_IconThemeChangedCallback)

wrap_IconThemeChangedCallback :: 
    GObject a => (a -> IconThemeChangedCallback) ->
    C_IconThemeChangedCallback
wrap_IconThemeChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iconTheme #changed callback
-- @
-- 
-- 
onIconThemeChanged :: (IsIconTheme a, MonadIO m) => a -> ((?self :: a) => IconThemeChangedCallback) -> m SignalHandlerId
onIconThemeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconThemeChangedCallback wrapped
    wrapped'' <- mk_IconThemeChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iconTheme #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIconThemeChanged :: (IsIconTheme a, MonadIO m) => a -> ((?self :: a) => IconThemeChangedCallback) -> m SignalHandlerId
afterIconThemeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IconThemeChangedCallback wrapped
    wrapped'' <- mk_IconThemeChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IconThemeChangedSignalInfo
instance SignalInfo IconThemeChangedSignalInfo where
    type HaskellCallbackType IconThemeChangedSignalInfo = IconThemeChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IconThemeChangedCallback cb
        cb'' <- mk_IconThemeChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#g:signal:changed"})

#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconTheme #display
-- @
getIconThemeDisplay :: (MonadIO m, IsIconTheme o) => o -> m (Maybe Gdk.Display.Display)
getIconThemeDisplay obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Set the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconTheme [ #display 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconThemeDisplay :: (MonadIO m, IsIconTheme o, Gdk.Display.IsDisplay a) => o -> a -> m ()
setIconThemeDisplay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "display" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconThemeDisplay :: (IsIconTheme o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructIconThemeDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

-- | Set the value of the “@display@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #display
-- @
clearIconThemeDisplay :: (MonadIO m, IsIconTheme o) => o -> m ()
clearIconThemeDisplay obj = liftIO $ B.Properties.setObjectPropertyObject obj "display" (Nothing :: Maybe Gdk.Display.Display)

#if defined(ENABLE_OVERLOADING)
data IconThemeDisplayPropertyInfo
instance AttrInfo IconThemeDisplayPropertyInfo where
    type AttrAllowedOps IconThemeDisplayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint IconThemeDisplayPropertyInfo = IsIconTheme
    type AttrSetTypeConstraint IconThemeDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint IconThemeDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType IconThemeDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType IconThemeDisplayPropertyInfo = (Maybe Gdk.Display.Display)
    type AttrLabel IconThemeDisplayPropertyInfo = "display"
    type AttrOrigin IconThemeDisplayPropertyInfo = IconTheme
    attrGet = getIconThemeDisplay
    attrSet = setIconThemeDisplay
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructIconThemeDisplay
    attrClear = clearIconThemeDisplay
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#g:attr:display"
        })
#endif

-- VVV Prop "icon-names"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@icon-names@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconTheme #iconNames
-- @
getIconThemeIconNames :: (MonadIO m, IsIconTheme o) => o -> m (Maybe [T.Text])
getIconThemeIconNames obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "icon-names"

#if defined(ENABLE_OVERLOADING)
data IconThemeIconNamesPropertyInfo
instance AttrInfo IconThemeIconNamesPropertyInfo where
    type AttrAllowedOps IconThemeIconNamesPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint IconThemeIconNamesPropertyInfo = IsIconTheme
    type AttrSetTypeConstraint IconThemeIconNamesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint IconThemeIconNamesPropertyInfo = (~) ()
    type AttrTransferType IconThemeIconNamesPropertyInfo = ()
    type AttrGetType IconThemeIconNamesPropertyInfo = (Maybe [T.Text])
    type AttrLabel IconThemeIconNamesPropertyInfo = "icon-names"
    type AttrOrigin IconThemeIconNamesPropertyInfo = IconTheme
    attrGet = getIconThemeIconNames
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconNames"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#g:attr:iconNames"
        })
#endif

-- VVV Prop "resource-path"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@resource-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconTheme #resourcePath
-- @
getIconThemeResourcePath :: (MonadIO m, IsIconTheme o) => o -> m (Maybe [T.Text])
getIconThemeResourcePath obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "resource-path"

-- | Set the value of the “@resource-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconTheme [ #resourcePath 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconThemeResourcePath :: (MonadIO m, IsIconTheme o) => o -> [T.Text] -> m ()
setIconThemeResourcePath obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "resource-path" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@resource-path@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconThemeResourcePath :: (IsIconTheme o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructIconThemeResourcePath val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "resource-path" (P.Just val)

-- | Set the value of the “@resource-path@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #resourcePath
-- @
clearIconThemeResourcePath :: (MonadIO m, IsIconTheme o) => o -> m ()
clearIconThemeResourcePath obj = liftIO $ B.Properties.setObjectPropertyStringArray obj "resource-path" (Nothing :: Maybe [T.Text])

#if defined(ENABLE_OVERLOADING)
data IconThemeResourcePathPropertyInfo
instance AttrInfo IconThemeResourcePathPropertyInfo where
    type AttrAllowedOps IconThemeResourcePathPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint IconThemeResourcePathPropertyInfo = IsIconTheme
    type AttrSetTypeConstraint IconThemeResourcePathPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint IconThemeResourcePathPropertyInfo = (~) [T.Text]
    type AttrTransferType IconThemeResourcePathPropertyInfo = [T.Text]
    type AttrGetType IconThemeResourcePathPropertyInfo = (Maybe [T.Text])
    type AttrLabel IconThemeResourcePathPropertyInfo = "resource-path"
    type AttrOrigin IconThemeResourcePathPropertyInfo = IconTheme
    attrGet = getIconThemeResourcePath
    attrSet = setIconThemeResourcePath
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconThemeResourcePath
    attrClear = clearIconThemeResourcePath
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.resourcePath"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#g:attr:resourcePath"
        })
#endif

-- VVV Prop "search-path"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@search-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconTheme #searchPath
-- @
getIconThemeSearchPath :: (MonadIO m, IsIconTheme o) => o -> m (Maybe [T.Text])
getIconThemeSearchPath obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "search-path"

-- | Set the value of the “@search-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconTheme [ #searchPath 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconThemeSearchPath :: (MonadIO m, IsIconTheme o) => o -> [T.Text] -> m ()
setIconThemeSearchPath obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "search-path" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@search-path@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconThemeSearchPath :: (IsIconTheme o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructIconThemeSearchPath val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "search-path" (P.Just val)

-- | Set the value of the “@search-path@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #searchPath
-- @
clearIconThemeSearchPath :: (MonadIO m, IsIconTheme o) => o -> m ()
clearIconThemeSearchPath obj = liftIO $ B.Properties.setObjectPropertyStringArray obj "search-path" (Nothing :: Maybe [T.Text])

#if defined(ENABLE_OVERLOADING)
data IconThemeSearchPathPropertyInfo
instance AttrInfo IconThemeSearchPathPropertyInfo where
    type AttrAllowedOps IconThemeSearchPathPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint IconThemeSearchPathPropertyInfo = IsIconTheme
    type AttrSetTypeConstraint IconThemeSearchPathPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint IconThemeSearchPathPropertyInfo = (~) [T.Text]
    type AttrTransferType IconThemeSearchPathPropertyInfo = [T.Text]
    type AttrGetType IconThemeSearchPathPropertyInfo = (Maybe [T.Text])
    type AttrLabel IconThemeSearchPathPropertyInfo = "search-path"
    type AttrOrigin IconThemeSearchPathPropertyInfo = IconTheme
    attrGet = getIconThemeSearchPath
    attrSet = setIconThemeSearchPath
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconThemeSearchPath
    attrClear = clearIconThemeSearchPath
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.searchPath"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#g:attr:searchPath"
        })
#endif

-- VVV Prop "theme-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@theme-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iconTheme #themeName
-- @
getIconThemeThemeName :: (MonadIO m, IsIconTheme o) => o -> m (Maybe T.Text)
getIconThemeThemeName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "theme-name"

-- | Set the value of the “@theme-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iconTheme [ #themeName 'Data.GI.Base.Attributes.:=' value ]
-- @
setIconThemeThemeName :: (MonadIO m, IsIconTheme o) => o -> T.Text -> m ()
setIconThemeThemeName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "theme-name" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@theme-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIconThemeThemeName :: (IsIconTheme o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructIconThemeThemeName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "theme-name" (P.Just val)

-- | Set the value of the “@theme-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #themeName
-- @
clearIconThemeThemeName :: (MonadIO m, IsIconTheme o) => o -> m ()
clearIconThemeThemeName obj = liftIO $ B.Properties.setObjectPropertyString obj "theme-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data IconThemeThemeNamePropertyInfo
instance AttrInfo IconThemeThemeNamePropertyInfo where
    type AttrAllowedOps IconThemeThemeNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint IconThemeThemeNamePropertyInfo = IsIconTheme
    type AttrSetTypeConstraint IconThemeThemeNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint IconThemeThemeNamePropertyInfo = (~) T.Text
    type AttrTransferType IconThemeThemeNamePropertyInfo = T.Text
    type AttrGetType IconThemeThemeNamePropertyInfo = (Maybe T.Text)
    type AttrLabel IconThemeThemeNamePropertyInfo = "theme-name"
    type AttrOrigin IconThemeThemeNamePropertyInfo = IconTheme
    attrGet = getIconThemeThemeName
    attrSet = setIconThemeThemeName
    attrTransfer _ v = do
        return v
    attrConstruct = constructIconThemeThemeName
    attrClear = clearIconThemeThemeName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.themeName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#g:attr:themeName"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IconTheme
type instance O.AttributeList IconTheme = IconThemeAttributeList
type IconThemeAttributeList = ('[ '("display", IconThemeDisplayPropertyInfo), '("iconNames", IconThemeIconNamesPropertyInfo), '("resourcePath", IconThemeResourcePathPropertyInfo), '("searchPath", IconThemeSearchPathPropertyInfo), '("themeName", IconThemeThemeNamePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
iconThemeDisplay :: AttrLabelProxy "display"
iconThemeDisplay = AttrLabelProxy

iconThemeIconNames :: AttrLabelProxy "iconNames"
iconThemeIconNames = AttrLabelProxy

iconThemeResourcePath :: AttrLabelProxy "resourcePath"
iconThemeResourcePath = AttrLabelProxy

iconThemeSearchPath :: AttrLabelProxy "searchPath"
iconThemeSearchPath = AttrLabelProxy

iconThemeThemeName :: AttrLabelProxy "themeName"
iconThemeThemeName = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList IconTheme = IconThemeSignalList
type IconThemeSignalList = ('[ '("changed", IconThemeChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method IconTheme::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "IconTheme" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_new" gtk_icon_theme_new :: 
    IO (Ptr IconTheme)

-- | Creates a new icon theme object.
-- 
-- Icon theme objects are used to lookup up an icon by name
-- in a particular icon theme. Usually, you’ll want to use
-- [func/@gtk@/.IconTheme.get_for_display] rather than creating
-- a new icon theme object for scratch.
iconThemeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m IconTheme
    -- ^ __Returns:__ the newly created @GtkIconTheme@ object.
iconThemeNew  = liftIO $ do
    result <- gtk_icon_theme_new
    checkUnexpectedReturnNULL "iconThemeNew" result
    result' <- (wrapObject IconTheme) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method IconTheme::add_resource_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a resource path" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_add_resource_path" gtk_icon_theme_add_resource_path :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    CString ->                              -- path : TBasicType TUTF8
    IO ()

-- | Adds a resource path that will be looked at when looking
-- for icons, similar to search paths.
-- 
-- See 'GI.Gtk.Objects.IconTheme.iconThemeSetResourcePath'.
-- 
-- This function should be used to make application-specific icons
-- available as part of the icon theme.
iconThemeAddResourcePath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> T.Text
    -- ^ /@path@/: a resource path
    -> m ()
iconThemeAddResourcePath self path = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    path' <- textToCString path
    gtk_icon_theme_add_resource_path self' path'
    touchManagedPtr self
    freeMem path'
    return ()

#if defined(ENABLE_OVERLOADING)
data IconThemeAddResourcePathMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeAddResourcePathMethodInfo a signature where
    overloadedMethod = iconThemeAddResourcePath

instance O.OverloadedMethodInfo IconThemeAddResourcePathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeAddResourcePath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeAddResourcePath"
        })


#endif

-- method IconTheme::add_search_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "directory name to append to the icon path"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_add_search_path" gtk_icon_theme_add_search_path :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    CString ->                              -- path : TBasicType TFileName
    IO ()

-- | Appends a directory to the search path.
-- 
-- See 'GI.Gtk.Objects.IconTheme.iconThemeSetSearchPath'.
iconThemeAddSearchPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> [Char]
    -- ^ /@path@/: directory name to append to the icon path
    -> m ()
iconThemeAddSearchPath self path = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    path' <- stringToCString path
    gtk_icon_theme_add_search_path self' path'
    touchManagedPtr self
    freeMem path'
    return ()

#if defined(ENABLE_OVERLOADING)
data IconThemeAddSearchPathMethodInfo
instance (signature ~ ([Char] -> m ()), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeAddSearchPathMethodInfo a signature where
    overloadedMethod = iconThemeAddSearchPath

instance O.OverloadedMethodInfo IconThemeAddSearchPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeAddSearchPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeAddSearchPath"
        })


#endif

-- method IconTheme::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_get_display" gtk_icon_theme_get_display :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    IO (Ptr Gdk.Display.Display)

-- | Returns the display that the @GtkIconTheme@ object was
-- created for.
iconThemeGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> m (Maybe Gdk.Display.Display)
    -- ^ __Returns:__ the display of /@iconTheme@/
iconThemeGetDisplay self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_icon_theme_get_display self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Display.Display) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconThemeGetDisplayMethodInfo
instance (signature ~ (m (Maybe Gdk.Display.Display)), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeGetDisplayMethodInfo a signature where
    overloadedMethod = iconThemeGetDisplay

instance O.OverloadedMethodInfo IconThemeGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeGetDisplay"
        })


#endif

-- method IconTheme::get_icon_names
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_get_icon_names" gtk_icon_theme_get_icon_names :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    IO (Ptr CString)

-- | Lists the names of icons in the current icon theme.
iconThemeGetIconNames ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> m [T.Text]
    -- ^ __Returns:__ a string array
    --   holding the names of all the icons in the theme. You must
    --   free the array using 'GI.GLib.Functions.strfreev'.
iconThemeGetIconNames self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_icon_theme_get_icon_names self'
    checkUnexpectedReturnNULL "iconThemeGetIconNames" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data IconThemeGetIconNamesMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeGetIconNamesMethodInfo a signature where
    overloadedMethod = iconThemeGetIconNames

instance O.OverloadedMethodInfo IconThemeGetIconNamesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeGetIconNames",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeGetIconNames"
        })


#endif

-- method IconTheme::get_icon_sizes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of an icon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TInt))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_get_icon_sizes" gtk_icon_theme_get_icon_sizes :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    CString ->                              -- icon_name : TBasicType TUTF8
    IO (Ptr Int32)

-- | Returns an array of integers describing the sizes at which
-- the icon is available without scaling.
-- 
-- A size of -1 means that the icon is available in a scalable
-- format. The array is zero-terminated.
iconThemeGetIconSizes ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> T.Text
    -- ^ /@iconName@/: the name of an icon
    -> m [Int32]
    -- ^ __Returns:__ A newly
    --   allocated array describing the sizes at which the icon is
    --   available. The array should be freed with 'GI.GLib.Functions.free' when it is no
    --   longer needed.
iconThemeGetIconSizes self iconName = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    iconName' <- textToCString iconName
    result <- gtk_icon_theme_get_icon_sizes self' iconName'
    checkUnexpectedReturnNULL "iconThemeGetIconSizes" result
    result' <- unpackZeroTerminatedStorableArray result
    freeMem result
    touchManagedPtr self
    freeMem iconName'
    return result'

#if defined(ENABLE_OVERLOADING)
data IconThemeGetIconSizesMethodInfo
instance (signature ~ (T.Text -> m [Int32]), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeGetIconSizesMethodInfo a signature where
    overloadedMethod = iconThemeGetIconSizes

instance O.OverloadedMethodInfo IconThemeGetIconSizesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeGetIconSizes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeGetIconSizes"
        })


#endif

-- method IconTheme::get_resource_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_get_resource_path" gtk_icon_theme_get_resource_path :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    IO (Ptr CString)

-- | Gets the current resource path.
-- 
-- See 'GI.Gtk.Objects.IconTheme.iconThemeSetResourcePath'.
iconThemeGetResourcePath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> m (Maybe [T.Text])
    -- ^ __Returns:__ 
    --   A list of resource paths
iconThemeGetResourcePath self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_icon_theme_get_resource_path self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedUTF8CArray result'
        mapZeroTerminatedCArray freeMem result'
        freeMem result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconThemeGetResourcePathMethodInfo
instance (signature ~ (m (Maybe [T.Text])), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeGetResourcePathMethodInfo a signature where
    overloadedMethod = iconThemeGetResourcePath

instance O.OverloadedMethodInfo IconThemeGetResourcePathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeGetResourcePath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeGetResourcePath"
        })


#endif

-- method IconTheme::get_search_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TFileName))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_get_search_path" gtk_icon_theme_get_search_path :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    IO (Ptr CString)

-- | Gets the current search path.
-- 
-- See 'GI.Gtk.Objects.IconTheme.iconThemeSetSearchPath'.
iconThemeGetSearchPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> m (Maybe [[Char]])
    -- ^ __Returns:__ 
    --   a list of icon theme path directories
iconThemeGetSearchPath self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_icon_theme_get_search_path self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedFileNameArray result'
        mapZeroTerminatedCArray freeMem result'
        freeMem result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconThemeGetSearchPathMethodInfo
instance (signature ~ (m (Maybe [[Char]])), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeGetSearchPathMethodInfo a signature where
    overloadedMethod = iconThemeGetSearchPath

instance O.OverloadedMethodInfo IconThemeGetSearchPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeGetSearchPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeGetSearchPath"
        })


#endif

-- method IconTheme::get_theme_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_get_theme_name" gtk_icon_theme_get_theme_name :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    IO CString

-- | Gets the current icon theme name.
iconThemeGetThemeName ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> m T.Text
    -- ^ __Returns:__ the current icon theme name,
iconThemeGetThemeName self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_icon_theme_get_theme_name self'
    checkUnexpectedReturnNULL "iconThemeGetThemeName" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data IconThemeGetThemeNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeGetThemeNameMethodInfo a signature where
    overloadedMethod = iconThemeGetThemeName

instance O.OverloadedMethodInfo IconThemeGetThemeNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeGetThemeName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeGetThemeName"
        })


#endif

-- method IconTheme::has_gicon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gicon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GIcon`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_has_gicon" gtk_icon_theme_has_gicon :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    Ptr Gio.Icon.Icon ->                    -- gicon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO CInt

-- | Checks whether an icon theme includes an icon
-- for a particular @GIcon@.
-- 
-- /Since: 4.2/
iconThemeHasGicon ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a, Gio.Icon.IsIcon b) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> b
    -- ^ /@gicon@/: a @GIcon@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@self@/ includes an icon for /@gicon@/
iconThemeHasGicon self gicon = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gicon' <- unsafeManagedPtrCastPtr gicon
    result <- gtk_icon_theme_has_gicon self' gicon'
    let result' = (/= 0) result
    touchManagedPtr self
    touchManagedPtr gicon
    return result'

#if defined(ENABLE_OVERLOADING)
data IconThemeHasGiconMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsIconTheme a, Gio.Icon.IsIcon b) => O.OverloadedMethod IconThemeHasGiconMethodInfo a signature where
    overloadedMethod = iconThemeHasGicon

instance O.OverloadedMethodInfo IconThemeHasGiconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeHasGicon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeHasGicon"
        })


#endif

-- method IconTheme::has_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of an icon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_has_icon" gtk_icon_theme_has_icon :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    CString ->                              -- icon_name : TBasicType TUTF8
    IO CInt

-- | Checks whether an icon theme includes an icon
-- for a particular name.
iconThemeHasIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> T.Text
    -- ^ /@iconName@/: the name of an icon
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@self@/ includes an
    --  icon for /@iconName@/.
iconThemeHasIcon self iconName = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    iconName' <- textToCString iconName
    result <- gtk_icon_theme_has_icon self' iconName'
    let result' = (/= 0) result
    touchManagedPtr self
    freeMem iconName'
    return result'

#if defined(ENABLE_OVERLOADING)
data IconThemeHasIconMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeHasIconMethodInfo a signature where
    overloadedMethod = iconThemeHasIcon

instance O.OverloadedMethodInfo IconThemeHasIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeHasIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeHasIcon"
        })


#endif

-- method IconTheme::lookup_by_gicon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GIcon` to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "desired icon size, in application pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the desired scale" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextDirection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text direction the icon will be displayed in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconLookupFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "flags modifying the behavior of the icon lookup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "IconPaintable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_lookup_by_gicon" gtk_icon_theme_lookup_by_gicon :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    Int32 ->                                -- size : TBasicType TInt
    Int32 ->                                -- scale : TBasicType TInt
    CUInt ->                                -- direction : TInterface (Name {namespace = "Gtk", name = "TextDirection"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "IconLookupFlags"})
    IO (Ptr Gtk.IconPaintable.IconPaintable)

-- | Looks up a icon for a desired size and window scale.
-- 
-- The icon can then be rendered by using it as a @GdkPaintable@,
-- or you can get information such as the filename and size.
iconThemeLookupByGicon ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a, Gio.Icon.IsIcon b) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> b
    -- ^ /@icon@/: the @GIcon@ to look up
    -> Int32
    -- ^ /@size@/: desired icon size, in application pixels
    -> Int32
    -- ^ /@scale@/: the desired scale
    -> Gtk.Enums.TextDirection
    -- ^ /@direction@/: text direction the icon will be displayed in
    -> [Gtk.Flags.IconLookupFlags]
    -- ^ /@flags@/: flags modifying the behavior of the icon lookup
    -> m Gtk.IconPaintable.IconPaintable
    -- ^ __Returns:__ a @GtkIconPaintable@ containing
    --   information about the icon. Unref with 'GI.GObject.Objects.Object.objectUnref'
iconThemeLookupByGicon self icon size scale direction flags = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    icon' <- unsafeManagedPtrCastPtr icon
    let direction' = (fromIntegral . fromEnum) direction
    let flags' = gflagsToWord flags
    result <- gtk_icon_theme_lookup_by_gicon self' icon' size scale direction' flags'
    checkUnexpectedReturnNULL "iconThemeLookupByGicon" result
    result' <- (wrapObject Gtk.IconPaintable.IconPaintable) result
    touchManagedPtr self
    touchManagedPtr icon
    return result'

#if defined(ENABLE_OVERLOADING)
data IconThemeLookupByGiconMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> Gtk.Enums.TextDirection -> [Gtk.Flags.IconLookupFlags] -> m Gtk.IconPaintable.IconPaintable), MonadIO m, IsIconTheme a, Gio.Icon.IsIcon b) => O.OverloadedMethod IconThemeLookupByGiconMethodInfo a signature where
    overloadedMethod = iconThemeLookupByGicon

instance O.OverloadedMethodInfo IconThemeLookupByGiconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeLookupByGicon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeLookupByGicon"
        })


#endif

-- method IconTheme::lookup_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the icon to lookup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fallbacks"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "fallback names" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "desired icon size, in application pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the window scale this will be displayed on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextDirection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text direction the icon will be displayed in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconLookupFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "flags modifying the behavior of the icon lookup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "IconPaintable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_lookup_icon" gtk_icon_theme_lookup_icon :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    CString ->                              -- icon_name : TBasicType TUTF8
    Ptr CString ->                          -- fallbacks : TCArray True (-1) (-1) (TBasicType TUTF8)
    Int32 ->                                -- size : TBasicType TInt
    Int32 ->                                -- scale : TBasicType TInt
    CUInt ->                                -- direction : TInterface (Name {namespace = "Gtk", name = "TextDirection"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "IconLookupFlags"})
    IO (Ptr Gtk.IconPaintable.IconPaintable)

-- | Looks up a named icon for a desired size and window scale,
-- returning a @GtkIconPaintable@.
-- 
-- The icon can then be rendered by using it as a @GdkPaintable@,
-- or you can get information such as the filename and size.
-- 
-- If the available /@iconName@/ is not available and /@fallbacks@/ are
-- provided, they will be tried in order.
-- 
-- If no matching icon is found, then a paintable that renders the
-- \"missing icon\" icon is returned. If you need to do something else
-- for missing icons you need to use 'GI.Gtk.Objects.IconTheme.iconThemeHasIcon'.
-- 
-- Note that you probably want to listen for icon theme changes and
-- update the icon. This is usually done by overriding the
-- GtkWidgetClass.css-@/changed()/@ function.
iconThemeLookupIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> T.Text
    -- ^ /@iconName@/: the name of the icon to lookup
    -> Maybe ([T.Text])
    -- ^ /@fallbacks@/: fallback names
    -> Int32
    -- ^ /@size@/: desired icon size, in application pixels
    -> Int32
    -- ^ /@scale@/: the window scale this will be displayed on
    -> Gtk.Enums.TextDirection
    -- ^ /@direction@/: text direction the icon will be displayed in
    -> [Gtk.Flags.IconLookupFlags]
    -- ^ /@flags@/: flags modifying the behavior of the icon lookup
    -> m Gtk.IconPaintable.IconPaintable
    -- ^ __Returns:__ a @GtkIconPaintable@ object
    --   containing the icon.
iconThemeLookupIcon self iconName fallbacks size scale direction flags = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    iconName' <- textToCString iconName
    maybeFallbacks <- case fallbacks of
        Nothing -> return FP.nullPtr
        Just jFallbacks -> do
            jFallbacks' <- packZeroTerminatedUTF8CArray jFallbacks
            return jFallbacks'
    let direction' = (fromIntegral . fromEnum) direction
    let flags' = gflagsToWord flags
    result <- gtk_icon_theme_lookup_icon self' iconName' maybeFallbacks size scale direction' flags'
    checkUnexpectedReturnNULL "iconThemeLookupIcon" result
    result' <- (wrapObject Gtk.IconPaintable.IconPaintable) result
    touchManagedPtr self
    freeMem iconName'
    mapZeroTerminatedCArray freeMem maybeFallbacks
    freeMem maybeFallbacks
    return result'

#if defined(ENABLE_OVERLOADING)
data IconThemeLookupIconMethodInfo
instance (signature ~ (T.Text -> Maybe ([T.Text]) -> Int32 -> Int32 -> Gtk.Enums.TextDirection -> [Gtk.Flags.IconLookupFlags] -> m Gtk.IconPaintable.IconPaintable), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeLookupIconMethodInfo a signature where
    overloadedMethod = iconThemeLookupIcon

instance O.OverloadedMethodInfo IconThemeLookupIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeLookupIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeLookupIcon"
        })


#endif

-- method IconTheme::set_resource_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n  NULL-terminated array of resource paths\n  that are searched for icons"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_set_resource_path" gtk_icon_theme_set_resource_path :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    Ptr CString ->                          -- path : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the resource paths that will be looked at when
-- looking for icons, similar to search paths.
-- 
-- The resources are considered as part of the hicolor icon theme
-- and must be located in subdirectories that are defined in the
-- hicolor icon theme, such as @\@path\/16x16\/actions\/run.png@
-- or @\@path\/scalable\/actions\/run.svg@.
-- 
-- Icons that are directly placed in the resource path instead
-- of a subdirectory are also considered as ultimate fallback,
-- but they are treated like unthemed icons.
iconThemeSetResourcePath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> Maybe ([T.Text])
    -- ^ /@path@/: 
    --   NULL-terminated array of resource paths
    --   that are searched for icons
    -> m ()
iconThemeSetResourcePath self path = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybePath <- case path of
        Nothing -> return FP.nullPtr
        Just jPath -> do
            jPath' <- packZeroTerminatedUTF8CArray jPath
            return jPath'
    gtk_icon_theme_set_resource_path self' maybePath
    touchManagedPtr self
    mapZeroTerminatedCArray freeMem maybePath
    freeMem maybePath
    return ()

#if defined(ENABLE_OVERLOADING)
data IconThemeSetResourcePathMethodInfo
instance (signature ~ (Maybe ([T.Text]) -> m ()), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeSetResourcePathMethodInfo a signature where
    overloadedMethod = iconThemeSetResourcePath

instance O.OverloadedMethodInfo IconThemeSetResourcePathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeSetResourcePath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeSetResourcePath"
        })


#endif

-- method IconTheme::set_search_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "NULL-terminated\n  array of directories that are searched for icon themes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_set_search_path" gtk_icon_theme_set_search_path :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    Ptr CString ->                          -- path : TCArray True (-1) (-1) (TBasicType TFileName)
    IO ()

-- | Sets the search path for the icon theme object.
-- 
-- When looking for an icon theme, GTK will search for a subdirectory
-- of one or more of the directories in /@path@/ with the same name
-- as the icon theme containing an index.theme file. (Themes from
-- multiple of the path elements are combined to allow themes to be
-- extended by adding icons in the user’s home directory.)
-- 
-- In addition if an icon found isn’t found either in the current
-- icon theme or the default icon theme, and an image file with
-- the right name is found directly in one of the elements of
-- /@path@/, then that image will be used for the icon name.
-- (This is legacy feature, and new icons should be put
-- into the fallback icon theme, which is called hicolor,
-- rather than directly on the icon path.)
iconThemeSetSearchPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> Maybe ([[Char]])
    -- ^ /@path@/: NULL-terminated
    --   array of directories that are searched for icon themes
    -> m ()
iconThemeSetSearchPath self path = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybePath <- case path of
        Nothing -> return FP.nullPtr
        Just jPath -> do
            jPath' <- packZeroTerminatedFileNameArray jPath
            return jPath'
    gtk_icon_theme_set_search_path self' maybePath
    touchManagedPtr self
    mapZeroTerminatedCArray freeMem maybePath
    freeMem maybePath
    return ()

#if defined(ENABLE_OVERLOADING)
data IconThemeSetSearchPathMethodInfo
instance (signature ~ (Maybe ([[Char]]) -> m ()), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeSetSearchPathMethodInfo a signature where
    overloadedMethod = iconThemeSetSearchPath

instance O.OverloadedMethodInfo IconThemeSetSearchPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeSetSearchPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeSetSearchPath"
        })


#endif

-- method IconTheme::set_theme_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconTheme" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkIconTheme`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "theme_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "name of icon theme to use instead of\n  configured theme, or %NULL to unset a previously set custom theme"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_set_theme_name" gtk_icon_theme_set_theme_name :: 
    Ptr IconTheme ->                        -- self : TInterface (Name {namespace = "Gtk", name = "IconTheme"})
    CString ->                              -- theme_name : TBasicType TUTF8
    IO ()

-- | Sets the name of the icon theme that the @GtkIconTheme@ object uses
-- overriding system configuration.
-- 
-- This function cannot be called on the icon theme objects returned
-- from [func/@gtk@/.IconTheme.get_for_display].
iconThemeSetThemeName ::
    (B.CallStack.HasCallStack, MonadIO m, IsIconTheme a) =>
    a
    -- ^ /@self@/: a @GtkIconTheme@
    -> Maybe (T.Text)
    -- ^ /@themeName@/: name of icon theme to use instead of
    --   configured theme, or 'P.Nothing' to unset a previously set custom theme
    -> m ()
iconThemeSetThemeName self themeName = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeThemeName <- case themeName of
        Nothing -> return FP.nullPtr
        Just jThemeName -> do
            jThemeName' <- textToCString jThemeName
            return jThemeName'
    gtk_icon_theme_set_theme_name self' maybeThemeName
    touchManagedPtr self
    freeMem maybeThemeName
    return ()

#if defined(ENABLE_OVERLOADING)
data IconThemeSetThemeNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsIconTheme a) => O.OverloadedMethod IconThemeSetThemeNameMethodInfo a signature where
    overloadedMethod = iconThemeSetThemeName

instance O.OverloadedMethodInfo IconThemeSetThemeNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IconTheme.iconThemeSetThemeName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IconTheme.html#v:iconThemeSetThemeName"
        })


#endif

-- method IconTheme::get_for_display
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "IconTheme" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_icon_theme_get_for_display" gtk_icon_theme_get_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr IconTheme)

-- | Gets the icon theme object associated with /@display@/.
-- 
-- If this function has not previously been called for the given
-- display, a new icon theme object will be created and associated
-- with the display. Icon theme objects are fairly expensive to create,
-- so using this function is usually a better choice than calling
-- 'GI.Gtk.Objects.IconTheme.iconThemeNew' and setting the display yourself; by using
-- this function a single icon theme object will be shared between users.
iconThemeGetForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m IconTheme
    -- ^ __Returns:__ A unique @GtkIconTheme@ associated with
    --   the given display. This icon theme is associated with the display
    --   and can be used as long as the display is open. Do not ref or unref it.
iconThemeGetForDisplay display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gtk_icon_theme_get_for_display display'
    checkUnexpectedReturnNULL "iconThemeGetForDisplay" result
    result' <- (newObject IconTheme) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


