{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Supports compose sequences, dead keys and numeric Unicode input.
-- 
-- == Compose sequences
-- 
-- @GtkIMContextSimple@ reads compose sequences from the first of the
-- following files that is found: ~\/.config\/gtk-4.0\/Compose, ~\/.XCompose,
-- \/usr\/share\/X11\/locale\/$locale\/Compose (for locales that have a nontrivial
-- Compose file). A subset of the file syntax described in the Compose(5)
-- manual page is supported. Additionally, @include \"%L\"@ loads GTK’s built-in
-- table of compose sequences rather than the locale-specific one from X11.
-- 
-- If none of these files is found, @GtkIMContextSimple@ uses a built-in table
-- of compose sequences that is derived from the X11 Compose files.
-- 
-- Note that compose sequences typically start with the Compose_key, which is
-- often not available as a dedicated key on keyboards. Keyboard layouts may
-- map this keysym to other keys, such as the right Control key.
-- 
-- == Unicode characters
-- 
-- @GtkIMContextSimple@ also supports numeric entry of Unicode characters
-- by typing \<kbd>Ctrl\<\/kbd>-\<kbd>Shift\<\/kbd>-\<kbd>u\<\/kbd>, followed by a
-- hexadecimal Unicode codepoint.
-- 
-- For example,
-- 
--     Ctrl-Shift-u 1 2 3 Enter
-- 
-- yields U+0123 LATIN SMALL LETTER G WITH CEDILLA, i.e. ģ.
-- 
-- == Dead keys
-- 
-- @GtkIMContextSimple@ supports dead keys. For example, typing
-- 
--     dead_acute a
-- 
--  yields U+00E! LATIN SMALL LETTER_A WITH ACUTE, i.e. á. Note that this
--  depends on the keyboard layout including dead keys.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.IMContextSimple
    ( 

-- * Exported types
    IMContextSimple(..)                     ,
    IsIMContextSimple                       ,
    toIMContextSimple                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [activateOsk]("GI.Gtk.Objects.IMContext#g:method:activateOsk"), [addComposeFile]("GI.Gtk.Objects.IMContextSimple#g:method:addComposeFile"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [deleteSurrounding]("GI.Gtk.Objects.IMContext#g:method:deleteSurrounding"), [filterKey]("GI.Gtk.Objects.IMContext#g:method:filterKey"), [filterKeypress]("GI.Gtk.Objects.IMContext#g:method:filterKeypress"), [focusIn]("GI.Gtk.Objects.IMContext#g:method:focusIn"), [focusOut]("GI.Gtk.Objects.IMContext#g:method:focusOut"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.IMContext#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getPreeditString]("GI.Gtk.Objects.IMContext#g:method:getPreeditString"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurrounding]("GI.Gtk.Objects.IMContext#g:method:getSurrounding"), [getSurroundingWithSelection]("GI.Gtk.Objects.IMContext#g:method:getSurroundingWithSelection").
-- 
-- ==== Setters
-- [setClientWidget]("GI.Gtk.Objects.IMContext#g:method:setClientWidget"), [setCursorLocation]("GI.Gtk.Objects.IMContext#g:method:setCursorLocation"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSurrounding]("GI.Gtk.Objects.IMContext#g:method:setSurrounding"), [setSurroundingWithSelection]("GI.Gtk.Objects.IMContext#g:method:setSurroundingWithSelection"), [setUsePreedit]("GI.Gtk.Objects.IMContext#g:method:setUsePreedit").

#if defined(ENABLE_OVERLOADING)
    ResolveIMContextSimpleMethod            ,
#endif

-- ** addComposeFile #method:addComposeFile#

#if defined(ENABLE_OVERLOADING)
    IMContextSimpleAddComposeFileMethodInfo ,
#endif
    iMContextSimpleAddComposeFile           ,


-- ** new #method:new#

    iMContextSimpleNew                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.IMContext as Gtk.IMContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.AttrList as Pango.AttrList

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.IMContext as Gtk.IMContext

#endif

-- | Memory-managed wrapper type.
newtype IMContextSimple = IMContextSimple (SP.ManagedPtr IMContextSimple)
    deriving (Eq)

instance SP.ManagedPtrNewtype IMContextSimple where
    toManagedPtr (IMContextSimple p) = p

foreign import ccall "gtk_im_context_simple_get_type"
    c_gtk_im_context_simple_get_type :: IO B.Types.GType

instance B.Types.TypedObject IMContextSimple where
    glibType = c_gtk_im_context_simple_get_type

instance B.Types.GObject IMContextSimple

-- | Type class for types which can be safely cast to `IMContextSimple`, for instance with `toIMContextSimple`.
class (SP.GObject o, O.IsDescendantOf IMContextSimple o) => IsIMContextSimple o
instance (SP.GObject o, O.IsDescendantOf IMContextSimple o) => IsIMContextSimple o

instance O.HasParentTypes IMContextSimple
type instance O.ParentTypes IMContextSimple = '[Gtk.IMContext.IMContext, GObject.Object.Object]

-- | Cast to `IMContextSimple`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toIMContextSimple :: (MIO.MonadIO m, IsIMContextSimple o) => o -> m IMContextSimple
toIMContextSimple = MIO.liftIO . B.ManagedPtr.unsafeCastTo IMContextSimple

-- | Convert 'IMContextSimple' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe IMContextSimple) where
    gvalueGType_ = c_gtk_im_context_simple_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr IMContextSimple)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr IMContextSimple)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject IMContextSimple ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveIMContextSimpleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIMContextSimpleMethod "activateOsk" o = Gtk.IMContext.IMContextActivateOskMethodInfo
    ResolveIMContextSimpleMethod "addComposeFile" o = IMContextSimpleAddComposeFileMethodInfo
    ResolveIMContextSimpleMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveIMContextSimpleMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveIMContextSimpleMethod "deleteSurrounding" o = Gtk.IMContext.IMContextDeleteSurroundingMethodInfo
    ResolveIMContextSimpleMethod "filterKey" o = Gtk.IMContext.IMContextFilterKeyMethodInfo
    ResolveIMContextSimpleMethod "filterKeypress" o = Gtk.IMContext.IMContextFilterKeypressMethodInfo
    ResolveIMContextSimpleMethod "focusIn" o = Gtk.IMContext.IMContextFocusInMethodInfo
    ResolveIMContextSimpleMethod "focusOut" o = Gtk.IMContext.IMContextFocusOutMethodInfo
    ResolveIMContextSimpleMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveIMContextSimpleMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveIMContextSimpleMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveIMContextSimpleMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveIMContextSimpleMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveIMContextSimpleMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveIMContextSimpleMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveIMContextSimpleMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveIMContextSimpleMethod "reset" o = Gtk.IMContext.IMContextResetMethodInfo
    ResolveIMContextSimpleMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveIMContextSimpleMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveIMContextSimpleMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveIMContextSimpleMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveIMContextSimpleMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveIMContextSimpleMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveIMContextSimpleMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveIMContextSimpleMethod "getPreeditString" o = Gtk.IMContext.IMContextGetPreeditStringMethodInfo
    ResolveIMContextSimpleMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveIMContextSimpleMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveIMContextSimpleMethod "getSurrounding" o = Gtk.IMContext.IMContextGetSurroundingMethodInfo
    ResolveIMContextSimpleMethod "getSurroundingWithSelection" o = Gtk.IMContext.IMContextGetSurroundingWithSelectionMethodInfo
    ResolveIMContextSimpleMethod "setClientWidget" o = Gtk.IMContext.IMContextSetClientWidgetMethodInfo
    ResolveIMContextSimpleMethod "setCursorLocation" o = Gtk.IMContext.IMContextSetCursorLocationMethodInfo
    ResolveIMContextSimpleMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveIMContextSimpleMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveIMContextSimpleMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveIMContextSimpleMethod "setSurrounding" o = Gtk.IMContext.IMContextSetSurroundingMethodInfo
    ResolveIMContextSimpleMethod "setSurroundingWithSelection" o = Gtk.IMContext.IMContextSetSurroundingWithSelectionMethodInfo
    ResolveIMContextSimpleMethod "setUsePreedit" o = Gtk.IMContext.IMContextSetUsePreeditMethodInfo
    ResolveIMContextSimpleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIMContextSimpleMethod t IMContextSimple, O.OverloadedMethod info IMContextSimple p) => OL.IsLabel t (IMContextSimple -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIMContextSimpleMethod t IMContextSimple, O.OverloadedMethod info IMContextSimple p, R.HasField t IMContextSimple p) => R.HasField t IMContextSimple p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIMContextSimpleMethod t IMContextSimple, O.OverloadedMethodInfo info IMContextSimple) => OL.IsLabel t (O.MethodProxy info IMContextSimple) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IMContextSimple
type instance O.AttributeList IMContextSimple = IMContextSimpleAttributeList
type IMContextSimpleAttributeList = ('[ '("inputHints", Gtk.IMContext.IMContextInputHintsPropertyInfo), '("inputPurpose", Gtk.IMContext.IMContextInputPurposePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList IMContextSimple = IMContextSimpleSignalList
type IMContextSimpleSignalList = ('[ '("commit", Gtk.IMContext.IMContextCommitSignalInfo), '("deleteSurrounding", Gtk.IMContext.IMContextDeleteSurroundingSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("preeditChanged", Gtk.IMContext.IMContextPreeditChangedSignalInfo), '("preeditEnd", Gtk.IMContext.IMContextPreeditEndSignalInfo), '("preeditStart", Gtk.IMContext.IMContextPreeditStartSignalInfo), '("retrieveSurrounding", Gtk.IMContext.IMContextRetrieveSurroundingSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method IMContextSimple::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "IMContextSimple" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_simple_new" gtk_im_context_simple_new :: 
    IO (Ptr IMContextSimple)

-- | Creates a new @GtkIMContextSimple@.
iMContextSimpleNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m IMContextSimple
    -- ^ __Returns:__ a new @GtkIMContextSimple@
iMContextSimpleNew  = liftIO $ do
    result <- gtk_im_context_simple_new
    checkUnexpectedReturnNULL "iMContextSimpleNew" result
    result' <- (wrapObject IMContextSimple) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method IMContextSimple::add_compose_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context_simple"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContextSimple" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkIMContextSimple`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "compose_file"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The path of compose file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_simple_add_compose_file" gtk_im_context_simple_add_compose_file :: 
    Ptr IMContextSimple ->                  -- context_simple : TInterface (Name {namespace = "Gtk", name = "IMContextSimple"})
    CString ->                              -- compose_file : TBasicType TUTF8
    IO ()

-- | Adds an additional table from the X11 compose file.
iMContextSimpleAddComposeFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContextSimple a) =>
    a
    -- ^ /@contextSimple@/: A @GtkIMContextSimple@
    -> T.Text
    -- ^ /@composeFile@/: The path of compose file
    -> m ()
iMContextSimpleAddComposeFile contextSimple composeFile = liftIO $ do
    contextSimple' <- unsafeManagedPtrCastPtr contextSimple
    composeFile' <- textToCString composeFile
    gtk_im_context_simple_add_compose_file contextSimple' composeFile'
    touchManagedPtr contextSimple
    freeMem composeFile'
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextSimpleAddComposeFileMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsIMContextSimple a) => O.OverloadedMethod IMContextSimpleAddComposeFileMethodInfo a signature where
    overloadedMethod = iMContextSimpleAddComposeFile

instance O.OverloadedMethodInfo IMContextSimpleAddComposeFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContextSimple.iMContextSimpleAddComposeFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-IMContextSimple.html#v:iMContextSimpleAddComposeFile"
        })


#endif


