{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Presents a large dynamic grid of items.
-- 
-- @GtkGridView@ uses its factory to generate one child widget for each
-- visible item and shows them in a grid. The orientation of the grid view
-- determines if the grid reflows vertically or horizontally.
-- 
-- @GtkGridView@ allows the user to select items according to the selection
-- characteristics of the model. For models that allow multiple selected items,
-- it is possible to turn on _rubberband selection_, using
-- [GridView:enableRubberband]("GI.Gtk.Objects.GridView#g:attr:enableRubberband").
-- 
-- To learn more about the list widget framework, see the
-- <https://docs.gtk.org/gtk4/section-list-widget.html overview>.
-- 
-- = Actions
-- 
-- @GtkGridView@ defines a set of built-in actions:
-- 
-- * @list.activate-item@ activates the item at given position by emitting the
-- the [GridView::activate]("GI.Gtk.Objects.GridView#g:signal:activate") signal.
-- 
-- 
-- = CSS nodes
-- 
-- >gridview
-- >├── child[.activatable]
-- >│
-- >├── child[.activatable]
-- >│
-- >┊
-- >╰── [rubberband]
-- 
-- 
-- @GtkGridView@ uses a single CSS node with name @gridview@. Each child uses
-- a single CSS node with name @child@. If the [ListItem:activatable]("GI.Gtk.Objects.ListItem#g:attr:activatable")
-- property is set, the corresponding row will have the @.activatable@ style
-- class. For rubberband selection, a subnode with name @rubberband@ is used.
-- 
-- = Accessibility
-- 
-- @GtkGridView@ uses the [enum/@gtk@/.AccessibleRole.grid] role, and the items
-- use the [enum/@gtk@/.AccessibleRole.grid_cell] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.GridView
    ( 

-- * Exported types
    GridView(..)                            ,
    IsGridView                              ,
    toGridView                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scrollTo]("GI.Gtk.Objects.GridView#g:method:scrollTo"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBorder]("GI.Gtk.Interfaces.Scrollable#g:method:getBorder"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEnableRubberband]("GI.Gtk.Objects.GridView#g:method:getEnableRubberband"), [getFactory]("GI.Gtk.Objects.GridView#g:method:getFactory"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getHadjustment"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getHscrollPolicy"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMaxColumns]("GI.Gtk.Objects.GridView#g:method:getMaxColumns"), [getMinColumns]("GI.Gtk.Objects.GridView#g:method:getMinColumns"), [getModel]("GI.Gtk.Objects.GridView#g:method:getModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSingleClickActivate]("GI.Gtk.Objects.GridView#g:method:getSingleClickActivate"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTabBehavior]("GI.Gtk.Objects.GridView#g:method:getTabBehavior"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getVadjustment"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getVscrollPolicy"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEnableRubberband]("GI.Gtk.Objects.GridView#g:method:setEnableRubberband"), [setFactory]("GI.Gtk.Objects.GridView#g:method:setFactory"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setHadjustment"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setHscrollPolicy"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMaxColumns]("GI.Gtk.Objects.GridView#g:method:setMaxColumns"), [setMinColumns]("GI.Gtk.Objects.GridView#g:method:setMinColumns"), [setModel]("GI.Gtk.Objects.GridView#g:method:setModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSingleClickActivate]("GI.Gtk.Objects.GridView#g:method:setSingleClickActivate"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTabBehavior]("GI.Gtk.Objects.GridView#g:method:setTabBehavior"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setVadjustment"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setVscrollPolicy").

#if defined(ENABLE_OVERLOADING)
    ResolveGridViewMethod                   ,
#endif

-- ** getEnableRubberband #method:getEnableRubberband#

#if defined(ENABLE_OVERLOADING)
    GridViewGetEnableRubberbandMethodInfo   ,
#endif
    gridViewGetEnableRubberband             ,


-- ** getFactory #method:getFactory#

#if defined(ENABLE_OVERLOADING)
    GridViewGetFactoryMethodInfo            ,
#endif
    gridViewGetFactory                      ,


-- ** getMaxColumns #method:getMaxColumns#

#if defined(ENABLE_OVERLOADING)
    GridViewGetMaxColumnsMethodInfo         ,
#endif
    gridViewGetMaxColumns                   ,


-- ** getMinColumns #method:getMinColumns#

#if defined(ENABLE_OVERLOADING)
    GridViewGetMinColumnsMethodInfo         ,
#endif
    gridViewGetMinColumns                   ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    GridViewGetModelMethodInfo              ,
#endif
    gridViewGetModel                        ,


-- ** getSingleClickActivate #method:getSingleClickActivate#

#if defined(ENABLE_OVERLOADING)
    GridViewGetSingleClickActivateMethodInfo,
#endif
    gridViewGetSingleClickActivate          ,


-- ** getTabBehavior #method:getTabBehavior#

#if defined(ENABLE_OVERLOADING)
    GridViewGetTabBehaviorMethodInfo        ,
#endif
    gridViewGetTabBehavior                  ,


-- ** new #method:new#

    gridViewNew                             ,


-- ** scrollTo #method:scrollTo#

#if defined(ENABLE_OVERLOADING)
    GridViewScrollToMethodInfo              ,
#endif
    gridViewScrollTo                        ,


-- ** setEnableRubberband #method:setEnableRubberband#

#if defined(ENABLE_OVERLOADING)
    GridViewSetEnableRubberbandMethodInfo   ,
#endif
    gridViewSetEnableRubberband             ,


-- ** setFactory #method:setFactory#

#if defined(ENABLE_OVERLOADING)
    GridViewSetFactoryMethodInfo            ,
#endif
    gridViewSetFactory                      ,


-- ** setMaxColumns #method:setMaxColumns#

#if defined(ENABLE_OVERLOADING)
    GridViewSetMaxColumnsMethodInfo         ,
#endif
    gridViewSetMaxColumns                   ,


-- ** setMinColumns #method:setMinColumns#

#if defined(ENABLE_OVERLOADING)
    GridViewSetMinColumnsMethodInfo         ,
#endif
    gridViewSetMinColumns                   ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    GridViewSetModelMethodInfo              ,
#endif
    gridViewSetModel                        ,


-- ** setSingleClickActivate #method:setSingleClickActivate#

#if defined(ENABLE_OVERLOADING)
    GridViewSetSingleClickActivateMethodInfo,
#endif
    gridViewSetSingleClickActivate          ,


-- ** setTabBehavior #method:setTabBehavior#

#if defined(ENABLE_OVERLOADING)
    GridViewSetTabBehaviorMethodInfo        ,
#endif
    gridViewSetTabBehavior                  ,




 -- * Properties


-- ** enableRubberband #attr:enableRubberband#
-- | Allow rubberband selection.

#if defined(ENABLE_OVERLOADING)
    GridViewEnableRubberbandPropertyInfo    ,
#endif
    constructGridViewEnableRubberband       ,
    getGridViewEnableRubberband             ,
#if defined(ENABLE_OVERLOADING)
    gridViewEnableRubberband                ,
#endif
    setGridViewEnableRubberband             ,


-- ** factory #attr:factory#
-- | Factory for populating list items.
-- 
-- The factory must be for configuring t'GI.Gtk.Objects.ListItem.ListItem' objects.

#if defined(ENABLE_OVERLOADING)
    GridViewFactoryPropertyInfo             ,
#endif
    clearGridViewFactory                    ,
    constructGridViewFactory                ,
    getGridViewFactory                      ,
#if defined(ENABLE_OVERLOADING)
    gridViewFactory                         ,
#endif
    setGridViewFactory                      ,


-- ** maxColumns #attr:maxColumns#
-- | Maximum number of columns per row.
-- 
-- If this number is smaller than [GridView:minColumns]("GI.Gtk.Objects.GridView#g:attr:minColumns"),
-- that value is used instead.

#if defined(ENABLE_OVERLOADING)
    GridViewMaxColumnsPropertyInfo          ,
#endif
    constructGridViewMaxColumns             ,
    getGridViewMaxColumns                   ,
#if defined(ENABLE_OVERLOADING)
    gridViewMaxColumns                      ,
#endif
    setGridViewMaxColumns                   ,


-- ** minColumns #attr:minColumns#
-- | Minimum number of columns per row.

#if defined(ENABLE_OVERLOADING)
    GridViewMinColumnsPropertyInfo          ,
#endif
    constructGridViewMinColumns             ,
    getGridViewMinColumns                   ,
#if defined(ENABLE_OVERLOADING)
    gridViewMinColumns                      ,
#endif
    setGridViewMinColumns                   ,


-- ** model #attr:model#
-- | Model for the items displayed.

#if defined(ENABLE_OVERLOADING)
    GridViewModelPropertyInfo               ,
#endif
    clearGridViewModel                      ,
    constructGridViewModel                  ,
    getGridViewModel                        ,
#if defined(ENABLE_OVERLOADING)
    gridViewModel                           ,
#endif
    setGridViewModel                        ,


-- ** singleClickActivate #attr:singleClickActivate#
-- | Activate rows on single click and select them on hover.

#if defined(ENABLE_OVERLOADING)
    GridViewSingleClickActivatePropertyInfo ,
#endif
    constructGridViewSingleClickActivate    ,
    getGridViewSingleClickActivate          ,
#if defined(ENABLE_OVERLOADING)
    gridViewSingleClickActivate             ,
#endif
    setGridViewSingleClickActivate          ,


-- ** tabBehavior #attr:tabBehavior#
-- | Behavior of the \<kbd>Tab\<\/kbd> key
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GridViewTabBehaviorPropertyInfo         ,
#endif
    constructGridViewTabBehavior            ,
    getGridViewTabBehavior                  ,
#if defined(ENABLE_OVERLOADING)
    gridViewTabBehavior                     ,
#endif
    setGridViewTabBehavior                  ,




 -- * Signals


-- ** activate #signal:activate#

    GridViewActivateCallback                ,
#if defined(ENABLE_OVERLOADING)
    GridViewActivateSignalInfo              ,
#endif
    afterGridViewActivate                   ,
    onGridViewActivate                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBase as Gtk.ListBase
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.ScrollInfo as Gtk.ScrollInfo
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBase as Gtk.ListBase
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.ScrollInfo as Gtk.ScrollInfo

#endif

-- | Memory-managed wrapper type.
newtype GridView = GridView (SP.ManagedPtr GridView)
    deriving (Eq)

instance SP.ManagedPtrNewtype GridView where
    toManagedPtr (GridView p) = p

foreign import ccall "gtk_grid_view_get_type"
    c_gtk_grid_view_get_type :: IO B.Types.GType

instance B.Types.TypedObject GridView where
    glibType = c_gtk_grid_view_get_type

instance B.Types.GObject GridView

-- | Type class for types which can be safely cast to `GridView`, for instance with `toGridView`.
class (SP.GObject o, O.IsDescendantOf GridView o) => IsGridView o
instance (SP.GObject o, O.IsDescendantOf GridView o) => IsGridView o

instance O.HasParentTypes GridView
type instance O.ParentTypes GridView = '[Gtk.ListBase.ListBase, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable, Gtk.Scrollable.Scrollable]

-- | Cast to `GridView`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toGridView :: (MIO.MonadIO m, IsGridView o) => o -> m GridView
toGridView = MIO.liftIO . B.ManagedPtr.unsafeCastTo GridView

-- | Convert 'GridView' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GridView) where
    gvalueGType_ = c_gtk_grid_view_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GridView)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GridView)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GridView ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGridViewMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGridViewMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveGridViewMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveGridViewMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveGridViewMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveGridViewMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveGridViewMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveGridViewMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveGridViewMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveGridViewMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveGridViewMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveGridViewMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGridViewMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGridViewMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveGridViewMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveGridViewMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveGridViewMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveGridViewMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveGridViewMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveGridViewMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveGridViewMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveGridViewMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveGridViewMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveGridViewMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveGridViewMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGridViewMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGridViewMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGridViewMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveGridViewMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveGridViewMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveGridViewMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveGridViewMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveGridViewMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveGridViewMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveGridViewMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveGridViewMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveGridViewMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveGridViewMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveGridViewMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveGridViewMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveGridViewMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGridViewMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveGridViewMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveGridViewMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveGridViewMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveGridViewMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveGridViewMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveGridViewMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveGridViewMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveGridViewMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGridViewMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGridViewMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveGridViewMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveGridViewMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveGridViewMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveGridViewMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveGridViewMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveGridViewMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveGridViewMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGridViewMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGridViewMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveGridViewMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveGridViewMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveGridViewMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveGridViewMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveGridViewMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveGridViewMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveGridViewMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGridViewMethod "scrollTo" o = GridViewScrollToMethodInfo
    ResolveGridViewMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveGridViewMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveGridViewMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveGridViewMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveGridViewMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGridViewMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGridViewMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGridViewMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveGridViewMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveGridViewMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveGridViewMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveGridViewMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveGridViewMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGridViewMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveGridViewMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveGridViewMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveGridViewMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveGridViewMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveGridViewMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveGridViewMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGridViewMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveGridViewMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveGridViewMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveGridViewMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveGridViewMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveGridViewMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveGridViewMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveGridViewMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveGridViewMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveGridViewMethod "getBorder" o = Gtk.Scrollable.ScrollableGetBorderMethodInfo
    ResolveGridViewMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveGridViewMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveGridViewMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveGridViewMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveGridViewMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveGridViewMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveGridViewMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveGridViewMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveGridViewMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveGridViewMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveGridViewMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGridViewMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveGridViewMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveGridViewMethod "getEnableRubberband" o = GridViewGetEnableRubberbandMethodInfo
    ResolveGridViewMethod "getFactory" o = GridViewGetFactoryMethodInfo
    ResolveGridViewMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveGridViewMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveGridViewMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveGridViewMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveGridViewMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveGridViewMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveGridViewMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveGridViewMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveGridViewMethod "getHadjustment" o = Gtk.Scrollable.ScrollableGetHadjustmentMethodInfo
    ResolveGridViewMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveGridViewMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveGridViewMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveGridViewMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveGridViewMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveGridViewMethod "getHscrollPolicy" o = Gtk.Scrollable.ScrollableGetHscrollPolicyMethodInfo
    ResolveGridViewMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveGridViewMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveGridViewMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveGridViewMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveGridViewMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveGridViewMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveGridViewMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveGridViewMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveGridViewMethod "getMaxColumns" o = GridViewGetMaxColumnsMethodInfo
    ResolveGridViewMethod "getMinColumns" o = GridViewGetMinColumnsMethodInfo
    ResolveGridViewMethod "getModel" o = GridViewGetModelMethodInfo
    ResolveGridViewMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveGridViewMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveGridViewMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveGridViewMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveGridViewMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveGridViewMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveGridViewMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveGridViewMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveGridViewMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveGridViewMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveGridViewMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveGridViewMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveGridViewMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveGridViewMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGridViewMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGridViewMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveGridViewMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveGridViewMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveGridViewMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveGridViewMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveGridViewMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveGridViewMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveGridViewMethod "getSingleClickActivate" o = GridViewGetSingleClickActivateMethodInfo
    ResolveGridViewMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveGridViewMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveGridViewMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveGridViewMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveGridViewMethod "getTabBehavior" o = GridViewGetTabBehaviorMethodInfo
    ResolveGridViewMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveGridViewMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveGridViewMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveGridViewMethod "getVadjustment" o = Gtk.Scrollable.ScrollableGetVadjustmentMethodInfo
    ResolveGridViewMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveGridViewMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveGridViewMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveGridViewMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveGridViewMethod "getVscrollPolicy" o = Gtk.Scrollable.ScrollableGetVscrollPolicyMethodInfo
    ResolveGridViewMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveGridViewMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveGridViewMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveGridViewMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveGridViewMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveGridViewMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveGridViewMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveGridViewMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveGridViewMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGridViewMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGridViewMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveGridViewMethod "setEnableRubberband" o = GridViewSetEnableRubberbandMethodInfo
    ResolveGridViewMethod "setFactory" o = GridViewSetFactoryMethodInfo
    ResolveGridViewMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveGridViewMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveGridViewMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveGridViewMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveGridViewMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveGridViewMethod "setHadjustment" o = Gtk.Scrollable.ScrollableSetHadjustmentMethodInfo
    ResolveGridViewMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveGridViewMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveGridViewMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveGridViewMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveGridViewMethod "setHscrollPolicy" o = Gtk.Scrollable.ScrollableSetHscrollPolicyMethodInfo
    ResolveGridViewMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveGridViewMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveGridViewMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveGridViewMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveGridViewMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveGridViewMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveGridViewMethod "setMaxColumns" o = GridViewSetMaxColumnsMethodInfo
    ResolveGridViewMethod "setMinColumns" o = GridViewSetMinColumnsMethodInfo
    ResolveGridViewMethod "setModel" o = GridViewSetModelMethodInfo
    ResolveGridViewMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveGridViewMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveGridViewMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveGridViewMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveGridViewMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveGridViewMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGridViewMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveGridViewMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveGridViewMethod "setSingleClickActivate" o = GridViewSetSingleClickActivateMethodInfo
    ResolveGridViewMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveGridViewMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveGridViewMethod "setTabBehavior" o = GridViewSetTabBehaviorMethodInfo
    ResolveGridViewMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveGridViewMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveGridViewMethod "setVadjustment" o = Gtk.Scrollable.ScrollableSetVadjustmentMethodInfo
    ResolveGridViewMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveGridViewMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveGridViewMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveGridViewMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveGridViewMethod "setVscrollPolicy" o = Gtk.Scrollable.ScrollableSetVscrollPolicyMethodInfo
    ResolveGridViewMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGridViewMethod t GridView, O.OverloadedMethod info GridView p) => OL.IsLabel t (GridView -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGridViewMethod t GridView, O.OverloadedMethod info GridView p, R.HasField t GridView p) => R.HasField t GridView p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGridViewMethod t GridView, O.OverloadedMethodInfo info GridView) => OL.IsLabel t (O.MethodProxy info GridView) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal GridView::activate
-- | Emitted when a cell has been activated by the user,
-- usually via activating the GtkGridView|list.activate-item action.
-- 
-- This allows for a convenient way to handle activation in a gridview.
-- See [ListItem:activatable]("GI.Gtk.Objects.ListItem#g:attr:activatable") for details on how to use
-- this signal.
type GridViewActivateCallback =
    Word32
    -- ^ /@position@/: position of item to activate
    -> IO ()

type C_GridViewActivateCallback =
    Ptr GridView ->                         -- object
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GridViewActivateCallback`.
foreign import ccall "wrapper"
    mk_GridViewActivateCallback :: C_GridViewActivateCallback -> IO (FunPtr C_GridViewActivateCallback)

wrap_GridViewActivateCallback :: 
    GObject a => (a -> GridViewActivateCallback) ->
    C_GridViewActivateCallback
wrap_GridViewActivateCallback gi'cb gi'selfPtr position _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  position


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gridView #activate callback
-- @
-- 
-- 
onGridViewActivate :: (IsGridView a, MonadIO m) => a -> ((?self :: a) => GridViewActivateCallback) -> m SignalHandlerId
onGridViewActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GridViewActivateCallback wrapped
    wrapped'' <- mk_GridViewActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gridView #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGridViewActivate :: (IsGridView a, MonadIO m) => a -> ((?self :: a) => GridViewActivateCallback) -> m SignalHandlerId
afterGridViewActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GridViewActivateCallback wrapped
    wrapped'' <- mk_GridViewActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GridViewActivateSignalInfo
instance SignalInfo GridViewActivateSignalInfo where
    type HaskellCallbackType GridViewActivateSignalInfo = GridViewActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GridViewActivateCallback cb
        cb'' <- mk_GridViewActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:signal:activate"})

#endif

--- XXX Duplicated object with different types:
  --- Name {namespace = "Gtk", name = "ListBase"} -> Property {propName = "orientation", propType = TInterface (Name {namespace = "Gtk", name = "Orientation"}), propFlags = [PropertyReadable,PropertyWritable], propReadNullable = Nothing, propWriteNullable = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The orientation of the list. See GtkOrientable:orientation\nfor details.", sinceVersion = Nothing}, propDeprecated = Nothing}
  --- Name {namespace = "Gtk", name = "Orientable"} -> Property {propName = "orientation", propType = TInterface (Name {namespace = "Gtk", name = "Orientation"}), propFlags = [PropertyReadable,PropertyWritable], propReadNullable = Just False, propWriteNullable = Just False, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The orientation of the orientable.", sinceVersion = Nothing}, propDeprecated = Nothing}
-- VVV Prop "enable-rubberband"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@enable-rubberband@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridView #enableRubberband
-- @
getGridViewEnableRubberband :: (MonadIO m, IsGridView o) => o -> m Bool
getGridViewEnableRubberband obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enable-rubberband"

-- | Set the value of the “@enable-rubberband@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridView [ #enableRubberband 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridViewEnableRubberband :: (MonadIO m, IsGridView o) => o -> Bool -> m ()
setGridViewEnableRubberband obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enable-rubberband" val

-- | Construct a `GValueConstruct` with valid value for the “@enable-rubberband@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridViewEnableRubberband :: (IsGridView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGridViewEnableRubberband val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enable-rubberband" val

#if defined(ENABLE_OVERLOADING)
data GridViewEnableRubberbandPropertyInfo
instance AttrInfo GridViewEnableRubberbandPropertyInfo where
    type AttrAllowedOps GridViewEnableRubberbandPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridViewEnableRubberbandPropertyInfo = IsGridView
    type AttrSetTypeConstraint GridViewEnableRubberbandPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GridViewEnableRubberbandPropertyInfo = (~) Bool
    type AttrTransferType GridViewEnableRubberbandPropertyInfo = Bool
    type AttrGetType GridViewEnableRubberbandPropertyInfo = Bool
    type AttrLabel GridViewEnableRubberbandPropertyInfo = "enable-rubberband"
    type AttrOrigin GridViewEnableRubberbandPropertyInfo = GridView
    attrGet = getGridViewEnableRubberband
    attrSet = setGridViewEnableRubberband
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridViewEnableRubberband
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.enableRubberband"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:attr:enableRubberband"
        })
#endif

-- VVV Prop "factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridView #factory
-- @
getGridViewFactory :: (MonadIO m, IsGridView o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getGridViewFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridView [ #factory 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridViewFactory :: (MonadIO m, IsGridView o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setGridViewFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "factory" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridViewFactory :: (IsGridView o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructGridViewFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "factory" (P.Just val)

-- | Set the value of the “@factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #factory
-- @
clearGridViewFactory :: (MonadIO m, IsGridView o) => o -> m ()
clearGridViewFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data GridViewFactoryPropertyInfo
instance AttrInfo GridViewFactoryPropertyInfo where
    type AttrAllowedOps GridViewFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GridViewFactoryPropertyInfo = IsGridView
    type AttrSetTypeConstraint GridViewFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint GridViewFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType GridViewFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType GridViewFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel GridViewFactoryPropertyInfo = "factory"
    type AttrOrigin GridViewFactoryPropertyInfo = GridView
    attrGet = getGridViewFactory
    attrSet = setGridViewFactory
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructGridViewFactory
    attrClear = clearGridViewFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.factory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:attr:factory"
        })
#endif

-- VVV Prop "max-columns"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@max-columns@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridView #maxColumns
-- @
getGridViewMaxColumns :: (MonadIO m, IsGridView o) => o -> m Word32
getGridViewMaxColumns obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "max-columns"

-- | Set the value of the “@max-columns@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridView [ #maxColumns 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridViewMaxColumns :: (MonadIO m, IsGridView o) => o -> Word32 -> m ()
setGridViewMaxColumns obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "max-columns" val

-- | Construct a `GValueConstruct` with valid value for the “@max-columns@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridViewMaxColumns :: (IsGridView o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructGridViewMaxColumns val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "max-columns" val

#if defined(ENABLE_OVERLOADING)
data GridViewMaxColumnsPropertyInfo
instance AttrInfo GridViewMaxColumnsPropertyInfo where
    type AttrAllowedOps GridViewMaxColumnsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridViewMaxColumnsPropertyInfo = IsGridView
    type AttrSetTypeConstraint GridViewMaxColumnsPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint GridViewMaxColumnsPropertyInfo = (~) Word32
    type AttrTransferType GridViewMaxColumnsPropertyInfo = Word32
    type AttrGetType GridViewMaxColumnsPropertyInfo = Word32
    type AttrLabel GridViewMaxColumnsPropertyInfo = "max-columns"
    type AttrOrigin GridViewMaxColumnsPropertyInfo = GridView
    attrGet = getGridViewMaxColumns
    attrSet = setGridViewMaxColumns
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridViewMaxColumns
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.maxColumns"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:attr:maxColumns"
        })
#endif

-- VVV Prop "min-columns"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@min-columns@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridView #minColumns
-- @
getGridViewMinColumns :: (MonadIO m, IsGridView o) => o -> m Word32
getGridViewMinColumns obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "min-columns"

-- | Set the value of the “@min-columns@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridView [ #minColumns 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridViewMinColumns :: (MonadIO m, IsGridView o) => o -> Word32 -> m ()
setGridViewMinColumns obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "min-columns" val

-- | Construct a `GValueConstruct` with valid value for the “@min-columns@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridViewMinColumns :: (IsGridView o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructGridViewMinColumns val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "min-columns" val

#if defined(ENABLE_OVERLOADING)
data GridViewMinColumnsPropertyInfo
instance AttrInfo GridViewMinColumnsPropertyInfo where
    type AttrAllowedOps GridViewMinColumnsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridViewMinColumnsPropertyInfo = IsGridView
    type AttrSetTypeConstraint GridViewMinColumnsPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint GridViewMinColumnsPropertyInfo = (~) Word32
    type AttrTransferType GridViewMinColumnsPropertyInfo = Word32
    type AttrGetType GridViewMinColumnsPropertyInfo = Word32
    type AttrLabel GridViewMinColumnsPropertyInfo = "min-columns"
    type AttrOrigin GridViewMinColumnsPropertyInfo = GridView
    attrGet = getGridViewMinColumns
    attrSet = setGridViewMinColumns
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridViewMinColumns
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.minColumns"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:attr:minColumns"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridView #model
-- @
getGridViewModel :: (MonadIO m, IsGridView o) => o -> m (Maybe Gtk.SelectionModel.SelectionModel)
getGridViewModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gtk.SelectionModel.SelectionModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridView [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridViewModel :: (MonadIO m, IsGridView o, Gtk.SelectionModel.IsSelectionModel a) => o -> a -> m ()
setGridViewModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridViewModel :: (IsGridView o, MIO.MonadIO m, Gtk.SelectionModel.IsSelectionModel a) => a -> m (GValueConstruct o)
constructGridViewModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearGridViewModel :: (MonadIO m, IsGridView o) => o -> m ()
clearGridViewModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gtk.SelectionModel.SelectionModel)

#if defined(ENABLE_OVERLOADING)
data GridViewModelPropertyInfo
instance AttrInfo GridViewModelPropertyInfo where
    type AttrAllowedOps GridViewModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GridViewModelPropertyInfo = IsGridView
    type AttrSetTypeConstraint GridViewModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferTypeConstraint GridViewModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferType GridViewModelPropertyInfo = Gtk.SelectionModel.SelectionModel
    type AttrGetType GridViewModelPropertyInfo = (Maybe Gtk.SelectionModel.SelectionModel)
    type AttrLabel GridViewModelPropertyInfo = "model"
    type AttrOrigin GridViewModelPropertyInfo = GridView
    attrGet = getGridViewModel
    attrSet = setGridViewModel
    attrTransfer _ v = do
        unsafeCastTo Gtk.SelectionModel.SelectionModel v
    attrConstruct = constructGridViewModel
    attrClear = clearGridViewModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:attr:model"
        })
#endif

-- VVV Prop "single-click-activate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@single-click-activate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridView #singleClickActivate
-- @
getGridViewSingleClickActivate :: (MonadIO m, IsGridView o) => o -> m Bool
getGridViewSingleClickActivate obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "single-click-activate"

-- | Set the value of the “@single-click-activate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridView [ #singleClickActivate 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridViewSingleClickActivate :: (MonadIO m, IsGridView o) => o -> Bool -> m ()
setGridViewSingleClickActivate obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "single-click-activate" val

-- | Construct a `GValueConstruct` with valid value for the “@single-click-activate@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridViewSingleClickActivate :: (IsGridView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGridViewSingleClickActivate val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "single-click-activate" val

#if defined(ENABLE_OVERLOADING)
data GridViewSingleClickActivatePropertyInfo
instance AttrInfo GridViewSingleClickActivatePropertyInfo where
    type AttrAllowedOps GridViewSingleClickActivatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridViewSingleClickActivatePropertyInfo = IsGridView
    type AttrSetTypeConstraint GridViewSingleClickActivatePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GridViewSingleClickActivatePropertyInfo = (~) Bool
    type AttrTransferType GridViewSingleClickActivatePropertyInfo = Bool
    type AttrGetType GridViewSingleClickActivatePropertyInfo = Bool
    type AttrLabel GridViewSingleClickActivatePropertyInfo = "single-click-activate"
    type AttrOrigin GridViewSingleClickActivatePropertyInfo = GridView
    attrGet = getGridViewSingleClickActivate
    attrSet = setGridViewSingleClickActivate
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridViewSingleClickActivate
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.singleClickActivate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:attr:singleClickActivate"
        })
#endif

-- VVV Prop "tab-behavior"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridView #tabBehavior
-- @
getGridViewTabBehavior :: (MonadIO m, IsGridView o) => o -> m Gtk.Enums.ListTabBehavior
getGridViewTabBehavior obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "tab-behavior"

-- | Set the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridView [ #tabBehavior 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridViewTabBehavior :: (MonadIO m, IsGridView o) => o -> Gtk.Enums.ListTabBehavior -> m ()
setGridViewTabBehavior obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "tab-behavior" val

-- | Construct a `GValueConstruct` with valid value for the “@tab-behavior@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridViewTabBehavior :: (IsGridView o, MIO.MonadIO m) => Gtk.Enums.ListTabBehavior -> m (GValueConstruct o)
constructGridViewTabBehavior val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "tab-behavior" val

#if defined(ENABLE_OVERLOADING)
data GridViewTabBehaviorPropertyInfo
instance AttrInfo GridViewTabBehaviorPropertyInfo where
    type AttrAllowedOps GridViewTabBehaviorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridViewTabBehaviorPropertyInfo = IsGridView
    type AttrSetTypeConstraint GridViewTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferTypeConstraint GridViewTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferType GridViewTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrGetType GridViewTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrLabel GridViewTabBehaviorPropertyInfo = "tab-behavior"
    type AttrOrigin GridViewTabBehaviorPropertyInfo = GridView
    attrGet = getGridViewTabBehavior
    attrSet = setGridViewTabBehavior
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridViewTabBehavior
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.tabBehavior"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#g:attr:tabBehavior"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GridView
type instance O.AttributeList GridView = GridViewAttributeList
type GridViewAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("enableRubberband", GridViewEnableRubberbandPropertyInfo), '("factory", GridViewFactoryPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("hadjustment", Gtk.Scrollable.ScrollableHadjustmentPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hscrollPolicy", Gtk.Scrollable.ScrollableHscrollPolicyPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maxColumns", GridViewMaxColumnsPropertyInfo), '("minColumns", GridViewMinColumnsPropertyInfo), '("model", GridViewModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.ListBase.ListBaseOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("singleClickActivate", GridViewSingleClickActivatePropertyInfo), '("tabBehavior", GridViewTabBehaviorPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("vadjustment", Gtk.Scrollable.ScrollableVadjustmentPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("vscrollPolicy", Gtk.Scrollable.ScrollableVscrollPolicyPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
gridViewEnableRubberband :: AttrLabelProxy "enableRubberband"
gridViewEnableRubberband = AttrLabelProxy

gridViewFactory :: AttrLabelProxy "factory"
gridViewFactory = AttrLabelProxy

gridViewMaxColumns :: AttrLabelProxy "maxColumns"
gridViewMaxColumns = AttrLabelProxy

gridViewMinColumns :: AttrLabelProxy "minColumns"
gridViewMinColumns = AttrLabelProxy

gridViewModel :: AttrLabelProxy "model"
gridViewModel = AttrLabelProxy

gridViewSingleClickActivate :: AttrLabelProxy "singleClickActivate"
gridViewSingleClickActivate = AttrLabelProxy

gridViewTabBehavior :: AttrLabelProxy "tabBehavior"
gridViewTabBehavior = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GridView = GridViewSignalList
type GridViewSignalList = ('[ '("activate", GridViewActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GridView::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The factory to populate items with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "GridView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_new" gtk_grid_view_new :: 
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO (Ptr GridView)

-- | Creates a new @GtkGridView@ that uses the given /@factory@/ for
-- mapping items to widgets.
-- 
-- The function takes ownership of the
-- arguments, so you can write code like
-- 
-- === /c code/
-- >grid_view = gtk_grid_view_new (create_model (),
-- >  gtk_builder_list_item_factory_new_from_resource ("/resource.ui"));
gridViewNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.SelectionModel.IsSelectionModel a, Gtk.ListItemFactory.IsListItemFactory b) =>
    Maybe (a)
    -- ^ /@model@/: the model to use
    -> Maybe (b)
    -- ^ /@factory@/: The factory to populate items with
    -> m GridView
    -- ^ __Returns:__ a new @GtkGridView@ using the given /@model@/ and /@factory@/
gridViewNew model factory = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- B.ManagedPtr.disownObject jFactory
            return jFactory'
    result <- gtk_grid_view_new maybeModel maybeFactory
    checkUnexpectedReturnNULL "gridViewNew" result
    result' <- (newObject GridView) result
    whenJust model touchManagedPtr
    whenJust factory touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GridView::get_enable_rubberband
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_get_enable_rubberband" gtk_grid_view_get_enable_rubberband :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    IO CInt

-- | Returns whether rows can be selected by dragging with the mouse.
gridViewGetEnableRubberband ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if rubberband selection is enabled
gridViewGetEnableRubberband self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_grid_view_get_enable_rubberband self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GridViewGetEnableRubberbandMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewGetEnableRubberbandMethodInfo a signature where
    overloadedMethod = gridViewGetEnableRubberband

instance O.OverloadedMethodInfo GridViewGetEnableRubberbandMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewGetEnableRubberband",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewGetEnableRubberband"
        })


#endif

-- method GridView::get_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_get_factory" gtk_grid_view_get_factory :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory that\'s currently used to populate list items.
gridViewGetFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory in use
gridViewGetFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_grid_view_get_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GridViewGetFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewGetFactoryMethodInfo a signature where
    overloadedMethod = gridViewGetFactory

instance O.OverloadedMethodInfo GridViewGetFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewGetFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewGetFactory"
        })


#endif

-- method GridView::get_max_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_get_max_columns" gtk_grid_view_get_max_columns :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    IO Word32

-- | Gets the maximum number of columns that the grid will use.
gridViewGetMaxColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> m Word32
    -- ^ __Returns:__ The maximum number of columns
gridViewGetMaxColumns self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_grid_view_get_max_columns self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data GridViewGetMaxColumnsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewGetMaxColumnsMethodInfo a signature where
    overloadedMethod = gridViewGetMaxColumns

instance O.OverloadedMethodInfo GridViewGetMaxColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewGetMaxColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewGetMaxColumns"
        })


#endif

-- method GridView::get_min_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_get_min_columns" gtk_grid_view_get_min_columns :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    IO Word32

-- | Gets the minimum number of columns that the grid will use.
gridViewGetMinColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> m Word32
    -- ^ __Returns:__ The minimum number of columns
gridViewGetMinColumns self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_grid_view_get_min_columns self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data GridViewGetMinColumnsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewGetMinColumnsMethodInfo a signature where
    overloadedMethod = gridViewGetMinColumns

instance O.OverloadedMethodInfo GridViewGetMinColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewGetMinColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewGetMinColumns"
        })


#endif

-- method GridView::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SelectionModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_get_model" gtk_grid_view_get_model :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    IO (Ptr Gtk.SelectionModel.SelectionModel)

-- | Gets the model that\'s currently used to read the items displayed.
gridViewGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> m (Maybe Gtk.SelectionModel.SelectionModel)
    -- ^ __Returns:__ The model in use
gridViewGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_grid_view_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.SelectionModel.SelectionModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GridViewGetModelMethodInfo
instance (signature ~ (m (Maybe Gtk.SelectionModel.SelectionModel)), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewGetModelMethodInfo a signature where
    overloadedMethod = gridViewGetModel

instance O.OverloadedMethodInfo GridViewGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewGetModel"
        })


#endif

-- method GridView::get_single_click_activate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_get_single_click_activate" gtk_grid_view_get_single_click_activate :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    IO CInt

-- | Returns whether items will be activated on single click and
-- selected on hover.
gridViewGetSingleClickActivate ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if items are activated on single click
gridViewGetSingleClickActivate self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_grid_view_get_single_click_activate self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GridViewGetSingleClickActivateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewGetSingleClickActivateMethodInfo a signature where
    overloadedMethod = gridViewGetSingleClickActivate

instance O.OverloadedMethodInfo GridViewGetSingleClickActivateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewGetSingleClickActivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewGetSingleClickActivate"
        })


#endif

-- method GridView::get_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_get_tab_behavior" gtk_grid_view_get_tab_behavior :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    IO CUInt

-- | Gets the behavior set for the \<kbd>Tab\<\/kbd> key.
-- 
-- /Since: 4.12/
gridViewGetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> m Gtk.Enums.ListTabBehavior
    -- ^ __Returns:__ The behavior of the \<kbd>Tab\<\/kbd> key
gridViewGetTabBehavior self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_grid_view_get_tab_behavior self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GridViewGetTabBehaviorMethodInfo
instance (signature ~ (m Gtk.Enums.ListTabBehavior), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewGetTabBehaviorMethodInfo a signature where
    overloadedMethod = gridViewGetTabBehavior

instance O.OverloadedMethodInfo GridViewGetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewGetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewGetTabBehavior"
        })


#endif

-- method GridView::scroll_to
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The gridview to scroll in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "position of the item. Must be less than the number of\n  items in the view."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListScrollFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "actions to perform" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scroll"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "details of how to perform\n  the scroll operation or %NULL to scroll into view"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_scroll_to" gtk_grid_view_scroll_to :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    Word32 ->                               -- pos : TBasicType TUInt
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "ListScrollFlags"})
    Ptr Gtk.ScrollInfo.ScrollInfo ->        -- scroll : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    IO ()

-- | Scrolls to the item at the given position and performs the actions
-- specified in /@flags@/.
-- 
-- This function works no matter if the gridview is shown or focused.
-- If it isn\'t, then the changes will take effect once that happens.
-- 
-- /Since: 4.12/
gridViewScrollTo ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: The gridview to scroll in
    -> Word32
    -- ^ /@pos@/: position of the item. Must be less than the number of
    --   items in the view.
    -> [Gtk.Flags.ListScrollFlags]
    -- ^ /@flags@/: actions to perform
    -> Maybe (Gtk.ScrollInfo.ScrollInfo)
    -- ^ /@scroll@/: details of how to perform
    --   the scroll operation or 'P.Nothing' to scroll into view
    -> m ()
gridViewScrollTo self pos flags scroll = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let flags' = gflagsToWord flags
    maybeScroll <- case scroll of
        Nothing -> return FP.nullPtr
        Just jScroll -> do
            jScroll' <- B.ManagedPtr.disownBoxed jScroll
            return jScroll'
    gtk_grid_view_scroll_to self' pos flags' maybeScroll
    touchManagedPtr self
    whenJust scroll touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewScrollToMethodInfo
instance (signature ~ (Word32 -> [Gtk.Flags.ListScrollFlags] -> Maybe (Gtk.ScrollInfo.ScrollInfo) -> m ()), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewScrollToMethodInfo a signature where
    overloadedMethod = gridViewScrollTo

instance O.OverloadedMethodInfo GridViewScrollToMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewScrollTo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewScrollTo"
        })


#endif

-- method GridView::set_enable_rubberband
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enable_rubberband"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to enable rubberband selection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_set_enable_rubberband" gtk_grid_view_set_enable_rubberband :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    CInt ->                                 -- enable_rubberband : TBasicType TBoolean
    IO ()

-- | Sets whether selections can be changed by dragging with the mouse.
gridViewSetEnableRubberband ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> Bool
    -- ^ /@enableRubberband@/: 'P.True' to enable rubberband selection
    -> m ()
gridViewSetEnableRubberband self enableRubberband = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let enableRubberband' = (P.fromIntegral . P.fromEnum) enableRubberband
    gtk_grid_view_set_enable_rubberband self' enableRubberband'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewSetEnableRubberbandMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewSetEnableRubberbandMethodInfo a signature where
    overloadedMethod = gridViewSetEnableRubberband

instance O.OverloadedMethodInfo GridViewSetEnableRubberbandMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewSetEnableRubberband",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewSetEnableRubberband"
        })


#endif

-- method GridView::set_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the factory to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_set_factory" gtk_grid_view_set_factory :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the @GtkListItemFactory@ to use for populating list items.
gridViewSetFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> Maybe (b)
    -- ^ /@factory@/: the factory to use
    -> m ()
gridViewSetFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_grid_view_set_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewSetFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsGridView a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod GridViewSetFactoryMethodInfo a signature where
    overloadedMethod = gridViewSetFactory

instance O.OverloadedMethodInfo GridViewSetFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewSetFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewSetFactory"
        })


#endif

-- method GridView::set_max_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_columns"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The maximum number of columns"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_set_max_columns" gtk_grid_view_set_max_columns :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    Word32 ->                               -- max_columns : TBasicType TUInt
    IO ()

-- | Sets the maximum number of columns to use.
-- 
-- This number must be at least 1.
-- 
-- If /@maxColumns@/ is smaller than the minimum set via
-- 'GI.Gtk.Objects.GridView.gridViewSetMinColumns', that value is used instead.
gridViewSetMaxColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> Word32
    -- ^ /@maxColumns@/: The maximum number of columns
    -> m ()
gridViewSetMaxColumns self maxColumns = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_grid_view_set_max_columns self' maxColumns
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewSetMaxColumnsMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewSetMaxColumnsMethodInfo a signature where
    overloadedMethod = gridViewSetMaxColumns

instance O.OverloadedMethodInfo GridViewSetMaxColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewSetMaxColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewSetMaxColumns"
        })


#endif

-- method GridView::set_min_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min_columns"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The minimum number of columns"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_set_min_columns" gtk_grid_view_set_min_columns :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    Word32 ->                               -- min_columns : TBasicType TUInt
    IO ()

-- | Sets the minimum number of columns to use.
-- 
-- This number must be at least 1.
-- 
-- If /@minColumns@/ is smaller than the minimum set via
-- 'GI.Gtk.Objects.GridView.gridViewSetMaxColumns', that value is ignored.
gridViewSetMinColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> Word32
    -- ^ /@minColumns@/: The minimum number of columns
    -> m ()
gridViewSetMinColumns self minColumns = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_grid_view_set_min_columns self' minColumns
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewSetMinColumnsMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewSetMinColumnsMethodInfo a signature where
    overloadedMethod = gridViewSetMinColumns

instance O.OverloadedMethodInfo GridViewSetMinColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewSetMinColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewSetMinColumns"
        })


#endif

-- method GridView::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_set_model" gtk_grid_view_set_model :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    IO ()

-- | Sets the model to use.
-- 
-- This must be a t'GI.Gtk.Interfaces.SelectionModel.SelectionModel'.
gridViewSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a, Gtk.SelectionModel.IsSelectionModel b) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> Maybe (b)
    -- ^ /@model@/: the model to use
    -> m ()
gridViewSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_grid_view_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsGridView a, Gtk.SelectionModel.IsSelectionModel b) => O.OverloadedMethod GridViewSetModelMethodInfo a signature where
    overloadedMethod = gridViewSetModel

instance O.OverloadedMethodInfo GridViewSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewSetModel"
        })


#endif

-- method GridView::set_single_click_activate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "single_click_activate"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to activate items on single click"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_set_single_click_activate" gtk_grid_view_set_single_click_activate :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    CInt ->                                 -- single_click_activate : TBasicType TBoolean
    IO ()

-- | Sets whether items should be activated on single click and
-- selected on hover.
gridViewSetSingleClickActivate ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> Bool
    -- ^ /@singleClickActivate@/: 'P.True' to activate items on single click
    -> m ()
gridViewSetSingleClickActivate self singleClickActivate = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let singleClickActivate' = (P.fromIntegral . P.fromEnum) singleClickActivate
    gtk_grid_view_set_single_click_activate self' singleClickActivate'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewSetSingleClickActivateMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewSetSingleClickActivateMethodInfo a signature where
    overloadedMethod = gridViewSetSingleClickActivate

instance O.OverloadedMethodInfo GridViewSetSingleClickActivateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewSetSingleClickActivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewSetSingleClickActivate"
        })


#endif

-- method GridView::set_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_behavior"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The desired tab behavior"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_view_set_tab_behavior" gtk_grid_view_set_tab_behavior :: 
    Ptr GridView ->                         -- self : TInterface (Name {namespace = "Gtk", name = "GridView"})
    CUInt ->                                -- tab_behavior : TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
    IO ()

-- | Sets the behavior of the \<kbd>Tab\<\/kbd> and \<kbd>Shift\<\/kbd>+\<kbd>Tab\<\/kbd> keys.
-- 
-- /Since: 4.12/
gridViewSetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridView a) =>
    a
    -- ^ /@self@/: a @GtkGridView@
    -> Gtk.Enums.ListTabBehavior
    -- ^ /@tabBehavior@/: The desired tab behavior
    -> m ()
gridViewSetTabBehavior self tabBehavior = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let tabBehavior' = (fromIntegral . fromEnum) tabBehavior
    gtk_grid_view_set_tab_behavior self' tabBehavior'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GridViewSetTabBehaviorMethodInfo
instance (signature ~ (Gtk.Enums.ListTabBehavior -> m ()), MonadIO m, IsGridView a) => O.OverloadedMethod GridViewSetTabBehaviorMethodInfo a signature where
    overloadedMethod = gridViewSetTabBehavior

instance O.OverloadedMethodInfo GridViewSetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridView.gridViewSetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GridView.html#v:gridViewSetTabBehavior"
        })


#endif


