{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Arranges its child widgets in rows and columns.
-- 
-- \<picture>
--   \<source srcset=\"grid-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkGrid\" src=\"grid.png\">
-- \<\/picture>
-- 
-- It supports arbitrary positions and horizontal\/vertical spans.
-- 
-- Children are added using 'GI.Gtk.Objects.Grid.gridAttach'. They can span multiple
-- rows or columns. It is also possible to add a child next to an existing
-- child, using 'GI.Gtk.Objects.Grid.gridAttachNextTo'. To remove a child from the
-- grid, use 'GI.Gtk.Objects.Grid.gridRemove'.
-- 
-- The behaviour of @GtkGrid@ when several children occupy the same grid
-- cell is undefined.
-- 
-- = GtkGrid as GtkBuildable
-- 
-- Every child in a @GtkGrid@ has access to a custom t'GI.Gtk.Interfaces.Buildable.Buildable'
-- element, called @\<layout>@. It can by used to specify a position in the
-- grid and optionally spans. All properties that can be used in the @\<layout>@
-- element are implemented by t'GI.Gtk.Objects.GridLayoutChild.GridLayoutChild'.
-- 
-- It is implemented by @GtkWidget@ using t'GI.Gtk.Objects.LayoutManager.LayoutManager'.
-- 
-- To showcase it, here is a simple example:
-- 
-- 
-- === /xml code/
-- ><object class="GtkGrid" id="my_grid">
-- >  <child>
-- >    <object class="GtkButton" id="button1">
-- >      <property name="label">Button 1</property>
-- >      <layout>
-- >        <property name="column">0</property>
-- >        <property name="row">0</property>
-- >      </layout>
-- >    </object>
-- >  </child>
-- >  <child>
-- >    <object class="GtkButton" id="button2">
-- >      <property name="label">Button 2</property>
-- >      <layout>
-- >        <property name="column">1</property>
-- >        <property name="row">0</property>
-- >      </layout>
-- >    </object>
-- >  </child>
-- >  <child>
-- >    <object class="GtkButton" id="button3">
-- >      <property name="label">Button 3</property>
-- >      <layout>
-- >        <property name="column">2</property>
-- >        <property name="row">0</property>
-- >        <property name="row-span">2</property>
-- >      </layout>
-- >    </object>
-- >  </child>
-- >  <child>
-- >    <object class="GtkButton" id="button4">
-- >      <property name="label">Button 4</property>
-- >      <layout>
-- >        <property name="column">0</property>
-- >        <property name="row">1</property>
-- >        <property name="column-span">2</property>
-- >      </layout>
-- >    </object>
-- >  </child>
-- ></object>
-- 
-- 
-- It organizes the first two buttons side-by-side in one cell each.
-- The third button is in the last column but spans across two rows.
-- This is defined by the @row-span@ property. The last button is
-- located in the second row and spans across two columns, which is
-- defined by the @column-span@ property.
-- 
-- = CSS nodes
-- 
-- @GtkGrid@ uses a single CSS node with name @grid@.
-- 
-- = Accessibility
-- 
-- Until GTK 4.10, @GtkGrid@ used the [enum/@gtk@/.AccessibleRole.group] role.
-- 
-- Starting from GTK 4.12, @GtkGrid@ uses the [enum/@gtk@/.AccessibleRole.generic] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Grid
    ( 

-- * Exported types
    Grid(..)                                ,
    IsGrid                                  ,
    toGrid                                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [attach]("GI.Gtk.Objects.Grid#g:method:attach"), [attachNextTo]("GI.Gtk.Objects.Grid#g:method:attachNextTo"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertColumn]("GI.Gtk.Objects.Grid#g:method:insertColumn"), [insertNextTo]("GI.Gtk.Objects.Grid#g:method:insertNextTo"), [insertRow]("GI.Gtk.Objects.Grid#g:method:insertRow"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queryChild]("GI.Gtk.Objects.Grid#g:method:queryChild"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.Grid#g:method:remove"), [removeColumn]("GI.Gtk.Objects.Grid#g:method:removeColumn"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeRow]("GI.Gtk.Objects.Grid#g:method:removeRow"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBaselineRow]("GI.Gtk.Objects.Grid#g:method:getBaselineRow"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildAt]("GI.Gtk.Objects.Grid#g:method:getChildAt"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getColumnHomogeneous]("GI.Gtk.Objects.Grid#g:method:getColumnHomogeneous"), [getColumnSpacing]("GI.Gtk.Objects.Grid#g:method:getColumnSpacing"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getRowBaselinePosition]("GI.Gtk.Objects.Grid#g:method:getRowBaselinePosition"), [getRowHomogeneous]("GI.Gtk.Objects.Grid#g:method:getRowHomogeneous"), [getRowSpacing]("GI.Gtk.Objects.Grid#g:method:getRowSpacing"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setBaselineRow]("GI.Gtk.Objects.Grid#g:method:setBaselineRow"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setColumnHomogeneous]("GI.Gtk.Objects.Grid#g:method:setColumnHomogeneous"), [setColumnSpacing]("GI.Gtk.Objects.Grid#g:method:setColumnSpacing"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRowBaselinePosition]("GI.Gtk.Objects.Grid#g:method:setRowBaselinePosition"), [setRowHomogeneous]("GI.Gtk.Objects.Grid#g:method:setRowHomogeneous"), [setRowSpacing]("GI.Gtk.Objects.Grid#g:method:setRowSpacing"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveGridMethod                       ,
#endif

-- ** attach #method:attach#

#if defined(ENABLE_OVERLOADING)
    GridAttachMethodInfo                    ,
#endif
    gridAttach                              ,


-- ** attachNextTo #method:attachNextTo#

#if defined(ENABLE_OVERLOADING)
    GridAttachNextToMethodInfo              ,
#endif
    gridAttachNextTo                        ,


-- ** getBaselineRow #method:getBaselineRow#

#if defined(ENABLE_OVERLOADING)
    GridGetBaselineRowMethodInfo            ,
#endif
    gridGetBaselineRow                      ,


-- ** getChildAt #method:getChildAt#

#if defined(ENABLE_OVERLOADING)
    GridGetChildAtMethodInfo                ,
#endif
    gridGetChildAt                          ,


-- ** getColumnHomogeneous #method:getColumnHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridGetColumnHomogeneousMethodInfo      ,
#endif
    gridGetColumnHomogeneous                ,


-- ** getColumnSpacing #method:getColumnSpacing#

#if defined(ENABLE_OVERLOADING)
    GridGetColumnSpacingMethodInfo          ,
#endif
    gridGetColumnSpacing                    ,


-- ** getRowBaselinePosition #method:getRowBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    GridGetRowBaselinePositionMethodInfo    ,
#endif
    gridGetRowBaselinePosition              ,


-- ** getRowHomogeneous #method:getRowHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridGetRowHomogeneousMethodInfo         ,
#endif
    gridGetRowHomogeneous                   ,


-- ** getRowSpacing #method:getRowSpacing#

#if defined(ENABLE_OVERLOADING)
    GridGetRowSpacingMethodInfo             ,
#endif
    gridGetRowSpacing                       ,


-- ** insertColumn #method:insertColumn#

#if defined(ENABLE_OVERLOADING)
    GridInsertColumnMethodInfo              ,
#endif
    gridInsertColumn                        ,


-- ** insertNextTo #method:insertNextTo#

#if defined(ENABLE_OVERLOADING)
    GridInsertNextToMethodInfo              ,
#endif
    gridInsertNextTo                        ,


-- ** insertRow #method:insertRow#

#if defined(ENABLE_OVERLOADING)
    GridInsertRowMethodInfo                 ,
#endif
    gridInsertRow                           ,


-- ** new #method:new#

    gridNew                                 ,


-- ** queryChild #method:queryChild#

#if defined(ENABLE_OVERLOADING)
    GridQueryChildMethodInfo                ,
#endif
    gridQueryChild                          ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    GridRemoveMethodInfo                    ,
#endif
    gridRemove                              ,


-- ** removeColumn #method:removeColumn#

#if defined(ENABLE_OVERLOADING)
    GridRemoveColumnMethodInfo              ,
#endif
    gridRemoveColumn                        ,


-- ** removeRow #method:removeRow#

#if defined(ENABLE_OVERLOADING)
    GridRemoveRowMethodInfo                 ,
#endif
    gridRemoveRow                           ,


-- ** setBaselineRow #method:setBaselineRow#

#if defined(ENABLE_OVERLOADING)
    GridSetBaselineRowMethodInfo            ,
#endif
    gridSetBaselineRow                      ,


-- ** setColumnHomogeneous #method:setColumnHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridSetColumnHomogeneousMethodInfo      ,
#endif
    gridSetColumnHomogeneous                ,


-- ** setColumnSpacing #method:setColumnSpacing#

#if defined(ENABLE_OVERLOADING)
    GridSetColumnSpacingMethodInfo          ,
#endif
    gridSetColumnSpacing                    ,


-- ** setRowBaselinePosition #method:setRowBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    GridSetRowBaselinePositionMethodInfo    ,
#endif
    gridSetRowBaselinePosition              ,


-- ** setRowHomogeneous #method:setRowHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridSetRowHomogeneousMethodInfo         ,
#endif
    gridSetRowHomogeneous                   ,


-- ** setRowSpacing #method:setRowSpacing#

#if defined(ENABLE_OVERLOADING)
    GridSetRowSpacingMethodInfo             ,
#endif
    gridSetRowSpacing                       ,




 -- * Properties


-- ** baselineRow #attr:baselineRow#
-- | The row to align to the baseline when valign is using baseline alignment.

#if defined(ENABLE_OVERLOADING)
    GridBaselineRowPropertyInfo             ,
#endif
    constructGridBaselineRow                ,
    getGridBaselineRow                      ,
#if defined(ENABLE_OVERLOADING)
    gridBaselineRow                         ,
#endif
    setGridBaselineRow                      ,


-- ** columnHomogeneous #attr:columnHomogeneous#
-- | If 'P.True', the columns are all the same width.

#if defined(ENABLE_OVERLOADING)
    GridColumnHomogeneousPropertyInfo       ,
#endif
    constructGridColumnHomogeneous          ,
    getGridColumnHomogeneous                ,
#if defined(ENABLE_OVERLOADING)
    gridColumnHomogeneous                   ,
#endif
    setGridColumnHomogeneous                ,


-- ** columnSpacing #attr:columnSpacing#
-- | The amount of space between two consecutive columns.

#if defined(ENABLE_OVERLOADING)
    GridColumnSpacingPropertyInfo           ,
#endif
    constructGridColumnSpacing              ,
    getGridColumnSpacing                    ,
#if defined(ENABLE_OVERLOADING)
    gridColumnSpacing                       ,
#endif
    setGridColumnSpacing                    ,


-- ** rowHomogeneous #attr:rowHomogeneous#
-- | If 'P.True', the rows are all the same height.

#if defined(ENABLE_OVERLOADING)
    GridRowHomogeneousPropertyInfo          ,
#endif
    constructGridRowHomogeneous             ,
    getGridRowHomogeneous                   ,
#if defined(ENABLE_OVERLOADING)
    gridRowHomogeneous                      ,
#endif
    setGridRowHomogeneous                   ,


-- ** rowSpacing #attr:rowSpacing#
-- | The amount of space between two consecutive rows.

#if defined(ENABLE_OVERLOADING)
    GridRowSpacingPropertyInfo              ,
#endif
    constructGridRowSpacing                 ,
    getGridRowSpacing                       ,
#if defined(ENABLE_OVERLOADING)
    gridRowSpacing                          ,
#endif
    setGridRowSpacing                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Grid = Grid (SP.ManagedPtr Grid)
    deriving (Eq)

instance SP.ManagedPtrNewtype Grid where
    toManagedPtr (Grid p) = p

foreign import ccall "gtk_grid_get_type"
    c_gtk_grid_get_type :: IO B.Types.GType

instance B.Types.TypedObject Grid where
    glibType = c_gtk_grid_get_type

instance B.Types.GObject Grid

-- | Type class for types which can be safely cast to `Grid`, for instance with `toGrid`.
class (SP.GObject o, O.IsDescendantOf Grid o) => IsGrid o
instance (SP.GObject o, O.IsDescendantOf Grid o) => IsGrid o

instance O.HasParentTypes Grid
type instance O.ParentTypes Grid = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to `Grid`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toGrid :: (MIO.MonadIO m, IsGrid o) => o -> m Grid
toGrid = MIO.liftIO . B.ManagedPtr.unsafeCastTo Grid

-- | Convert 'Grid' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Grid) where
    gvalueGType_ = c_gtk_grid_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Grid)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Grid)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Grid ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGridMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGridMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveGridMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveGridMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveGridMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveGridMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveGridMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveGridMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveGridMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveGridMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveGridMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveGridMethod "attach" o = GridAttachMethodInfo
    ResolveGridMethod "attachNextTo" o = GridAttachNextToMethodInfo
    ResolveGridMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGridMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGridMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveGridMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveGridMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveGridMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveGridMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveGridMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveGridMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveGridMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveGridMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveGridMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveGridMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveGridMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGridMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGridMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGridMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveGridMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveGridMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveGridMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveGridMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveGridMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveGridMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveGridMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveGridMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveGridMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveGridMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveGridMethod "insertColumn" o = GridInsertColumnMethodInfo
    ResolveGridMethod "insertNextTo" o = GridInsertNextToMethodInfo
    ResolveGridMethod "insertRow" o = GridInsertRowMethodInfo
    ResolveGridMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveGridMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveGridMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGridMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveGridMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveGridMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveGridMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveGridMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveGridMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveGridMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveGridMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveGridMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGridMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGridMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveGridMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveGridMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveGridMethod "queryChild" o = GridQueryChildMethodInfo
    ResolveGridMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveGridMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveGridMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveGridMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveGridMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGridMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGridMethod "remove" o = GridRemoveMethodInfo
    ResolveGridMethod "removeColumn" o = GridRemoveColumnMethodInfo
    ResolveGridMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveGridMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveGridMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveGridMethod "removeRow" o = GridRemoveRowMethodInfo
    ResolveGridMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveGridMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveGridMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveGridMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveGridMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGridMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveGridMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveGridMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveGridMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveGridMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGridMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGridMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGridMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveGridMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveGridMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveGridMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveGridMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveGridMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGridMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveGridMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveGridMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveGridMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveGridMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveGridMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveGridMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGridMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveGridMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveGridMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveGridMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveGridMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveGridMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveGridMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveGridMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveGridMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveGridMethod "getBaselineRow" o = GridGetBaselineRowMethodInfo
    ResolveGridMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveGridMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveGridMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveGridMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveGridMethod "getChildAt" o = GridGetChildAtMethodInfo
    ResolveGridMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveGridMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveGridMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveGridMethod "getColumnHomogeneous" o = GridGetColumnHomogeneousMethodInfo
    ResolveGridMethod "getColumnSpacing" o = GridGetColumnSpacingMethodInfo
    ResolveGridMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveGridMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveGridMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveGridMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGridMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveGridMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveGridMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveGridMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveGridMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveGridMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveGridMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveGridMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveGridMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveGridMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveGridMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveGridMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveGridMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveGridMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveGridMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveGridMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveGridMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveGridMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveGridMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveGridMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveGridMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveGridMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveGridMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveGridMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveGridMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveGridMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveGridMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveGridMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveGridMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveGridMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveGridMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveGridMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveGridMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveGridMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveGridMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveGridMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveGridMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGridMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGridMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveGridMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveGridMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveGridMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveGridMethod "getRowBaselinePosition" o = GridGetRowBaselinePositionMethodInfo
    ResolveGridMethod "getRowHomogeneous" o = GridGetRowHomogeneousMethodInfo
    ResolveGridMethod "getRowSpacing" o = GridGetRowSpacingMethodInfo
    ResolveGridMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveGridMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveGridMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveGridMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveGridMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveGridMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveGridMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveGridMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveGridMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveGridMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveGridMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveGridMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveGridMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveGridMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveGridMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveGridMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveGridMethod "setBaselineRow" o = GridSetBaselineRowMethodInfo
    ResolveGridMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveGridMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveGridMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveGridMethod "setColumnHomogeneous" o = GridSetColumnHomogeneousMethodInfo
    ResolveGridMethod "setColumnSpacing" o = GridSetColumnSpacingMethodInfo
    ResolveGridMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveGridMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveGridMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveGridMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGridMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGridMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveGridMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveGridMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveGridMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveGridMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveGridMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveGridMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveGridMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveGridMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveGridMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveGridMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveGridMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveGridMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveGridMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveGridMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveGridMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveGridMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveGridMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveGridMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveGridMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveGridMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveGridMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGridMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveGridMethod "setRowBaselinePosition" o = GridSetRowBaselinePositionMethodInfo
    ResolveGridMethod "setRowHomogeneous" o = GridSetRowHomogeneousMethodInfo
    ResolveGridMethod "setRowSpacing" o = GridSetRowSpacingMethodInfo
    ResolveGridMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveGridMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveGridMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveGridMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveGridMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveGridMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveGridMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveGridMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveGridMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveGridMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGridMethod t Grid, O.OverloadedMethod info Grid p) => OL.IsLabel t (Grid -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGridMethod t Grid, O.OverloadedMethod info Grid p, R.HasField t Grid p) => R.HasField t Grid p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGridMethod t Grid, O.OverloadedMethodInfo info Grid) => OL.IsLabel t (O.MethodProxy info Grid) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "baseline-row"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@baseline-row@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' grid #baselineRow
-- @
getGridBaselineRow :: (MonadIO m, IsGrid o) => o -> m Int32
getGridBaselineRow obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "baseline-row"

-- | Set the value of the “@baseline-row@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' grid [ #baselineRow 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridBaselineRow :: (MonadIO m, IsGrid o) => o -> Int32 -> m ()
setGridBaselineRow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "baseline-row" val

-- | Construct a `GValueConstruct` with valid value for the “@baseline-row@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridBaselineRow :: (IsGrid o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGridBaselineRow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "baseline-row" val

#if defined(ENABLE_OVERLOADING)
data GridBaselineRowPropertyInfo
instance AttrInfo GridBaselineRowPropertyInfo where
    type AttrAllowedOps GridBaselineRowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridBaselineRowPropertyInfo = IsGrid
    type AttrSetTypeConstraint GridBaselineRowPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GridBaselineRowPropertyInfo = (~) Int32
    type AttrTransferType GridBaselineRowPropertyInfo = Int32
    type AttrGetType GridBaselineRowPropertyInfo = Int32
    type AttrLabel GridBaselineRowPropertyInfo = "baseline-row"
    type AttrOrigin GridBaselineRowPropertyInfo = Grid
    attrGet = getGridBaselineRow
    attrSet = setGridBaselineRow
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridBaselineRow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.baselineRow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#g:attr:baselineRow"
        })
#endif

-- VVV Prop "column-homogeneous"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@column-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' grid #columnHomogeneous
-- @
getGridColumnHomogeneous :: (MonadIO m, IsGrid o) => o -> m Bool
getGridColumnHomogeneous obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "column-homogeneous"

-- | Set the value of the “@column-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' grid [ #columnHomogeneous 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridColumnHomogeneous :: (MonadIO m, IsGrid o) => o -> Bool -> m ()
setGridColumnHomogeneous obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "column-homogeneous" val

-- | Construct a `GValueConstruct` with valid value for the “@column-homogeneous@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridColumnHomogeneous :: (IsGrid o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGridColumnHomogeneous val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "column-homogeneous" val

#if defined(ENABLE_OVERLOADING)
data GridColumnHomogeneousPropertyInfo
instance AttrInfo GridColumnHomogeneousPropertyInfo where
    type AttrAllowedOps GridColumnHomogeneousPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridColumnHomogeneousPropertyInfo = IsGrid
    type AttrSetTypeConstraint GridColumnHomogeneousPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GridColumnHomogeneousPropertyInfo = (~) Bool
    type AttrTransferType GridColumnHomogeneousPropertyInfo = Bool
    type AttrGetType GridColumnHomogeneousPropertyInfo = Bool
    type AttrLabel GridColumnHomogeneousPropertyInfo = "column-homogeneous"
    type AttrOrigin GridColumnHomogeneousPropertyInfo = Grid
    attrGet = getGridColumnHomogeneous
    attrSet = setGridColumnHomogeneous
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridColumnHomogeneous
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.columnHomogeneous"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#g:attr:columnHomogeneous"
        })
#endif

-- VVV Prop "column-spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@column-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' grid #columnSpacing
-- @
getGridColumnSpacing :: (MonadIO m, IsGrid o) => o -> m Int32
getGridColumnSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "column-spacing"

-- | Set the value of the “@column-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' grid [ #columnSpacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridColumnSpacing :: (MonadIO m, IsGrid o) => o -> Int32 -> m ()
setGridColumnSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "column-spacing" val

-- | Construct a `GValueConstruct` with valid value for the “@column-spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridColumnSpacing :: (IsGrid o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGridColumnSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "column-spacing" val

#if defined(ENABLE_OVERLOADING)
data GridColumnSpacingPropertyInfo
instance AttrInfo GridColumnSpacingPropertyInfo where
    type AttrAllowedOps GridColumnSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridColumnSpacingPropertyInfo = IsGrid
    type AttrSetTypeConstraint GridColumnSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GridColumnSpacingPropertyInfo = (~) Int32
    type AttrTransferType GridColumnSpacingPropertyInfo = Int32
    type AttrGetType GridColumnSpacingPropertyInfo = Int32
    type AttrLabel GridColumnSpacingPropertyInfo = "column-spacing"
    type AttrOrigin GridColumnSpacingPropertyInfo = Grid
    attrGet = getGridColumnSpacing
    attrSet = setGridColumnSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridColumnSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.columnSpacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#g:attr:columnSpacing"
        })
#endif

-- VVV Prop "row-homogeneous"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@row-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' grid #rowHomogeneous
-- @
getGridRowHomogeneous :: (MonadIO m, IsGrid o) => o -> m Bool
getGridRowHomogeneous obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "row-homogeneous"

-- | Set the value of the “@row-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' grid [ #rowHomogeneous 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridRowHomogeneous :: (MonadIO m, IsGrid o) => o -> Bool -> m ()
setGridRowHomogeneous obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "row-homogeneous" val

-- | Construct a `GValueConstruct` with valid value for the “@row-homogeneous@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridRowHomogeneous :: (IsGrid o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGridRowHomogeneous val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "row-homogeneous" val

#if defined(ENABLE_OVERLOADING)
data GridRowHomogeneousPropertyInfo
instance AttrInfo GridRowHomogeneousPropertyInfo where
    type AttrAllowedOps GridRowHomogeneousPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridRowHomogeneousPropertyInfo = IsGrid
    type AttrSetTypeConstraint GridRowHomogeneousPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GridRowHomogeneousPropertyInfo = (~) Bool
    type AttrTransferType GridRowHomogeneousPropertyInfo = Bool
    type AttrGetType GridRowHomogeneousPropertyInfo = Bool
    type AttrLabel GridRowHomogeneousPropertyInfo = "row-homogeneous"
    type AttrOrigin GridRowHomogeneousPropertyInfo = Grid
    attrGet = getGridRowHomogeneous
    attrSet = setGridRowHomogeneous
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridRowHomogeneous
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.rowHomogeneous"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#g:attr:rowHomogeneous"
        })
#endif

-- VVV Prop "row-spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@row-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' grid #rowSpacing
-- @
getGridRowSpacing :: (MonadIO m, IsGrid o) => o -> m Int32
getGridRowSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "row-spacing"

-- | Set the value of the “@row-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' grid [ #rowSpacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridRowSpacing :: (MonadIO m, IsGrid o) => o -> Int32 -> m ()
setGridRowSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "row-spacing" val

-- | Construct a `GValueConstruct` with valid value for the “@row-spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridRowSpacing :: (IsGrid o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGridRowSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "row-spacing" val

#if defined(ENABLE_OVERLOADING)
data GridRowSpacingPropertyInfo
instance AttrInfo GridRowSpacingPropertyInfo where
    type AttrAllowedOps GridRowSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridRowSpacingPropertyInfo = IsGrid
    type AttrSetTypeConstraint GridRowSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GridRowSpacingPropertyInfo = (~) Int32
    type AttrTransferType GridRowSpacingPropertyInfo = Int32
    type AttrGetType GridRowSpacingPropertyInfo = Int32
    type AttrLabel GridRowSpacingPropertyInfo = "row-spacing"
    type AttrOrigin GridRowSpacingPropertyInfo = Grid
    attrGet = getGridRowSpacing
    attrSet = setGridRowSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridRowSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.rowSpacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#g:attr:rowSpacing"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Grid
type instance O.AttributeList Grid = GridAttributeList
type GridAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("baselineRow", GridBaselineRowPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("columnHomogeneous", GridColumnHomogeneousPropertyInfo), '("columnSpacing", GridColumnSpacingPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("rowHomogeneous", GridRowHomogeneousPropertyInfo), '("rowSpacing", GridRowSpacingPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
gridBaselineRow :: AttrLabelProxy "baselineRow"
gridBaselineRow = AttrLabelProxy

gridColumnHomogeneous :: AttrLabelProxy "columnHomogeneous"
gridColumnHomogeneous = AttrLabelProxy

gridColumnSpacing :: AttrLabelProxy "columnSpacing"
gridColumnSpacing = AttrLabelProxy

gridRowHomogeneous :: AttrLabelProxy "rowHomogeneous"
gridRowHomogeneous = AttrLabelProxy

gridRowSpacing :: AttrLabelProxy "rowSpacing"
gridRowSpacing = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Grid = GridSignalList
type GridSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Grid::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Grid" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_new" gtk_grid_new :: 
    IO (Ptr Grid)

-- | Creates a new grid widget.
gridNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Grid
    -- ^ __Returns:__ the new @GtkGrid@
gridNew  = liftIO $ do
    result <- gtk_grid_new
    checkUnexpectedReturnNULL "gridNew" result
    result' <- (newObject Grid) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Grid::attach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the column number to attach the left side of @child to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the row number to attach the top side of @child to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of columns that @child will span"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of rows that @child will span"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_attach" gtk_grid_attach :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- column : TBasicType TInt
    Int32 ->                                -- row : TBasicType TInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Adds a widget to the grid.
-- 
-- The position of /@child@/ is determined by /@column@/ and /@row@/.
-- The number of “cells” that /@child@/ will occupy is determined
-- by /@width@/ and /@height@/.
gridAttach ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> b
    -- ^ /@child@/: the widget to add
    -> Int32
    -- ^ /@column@/: the column number to attach the left side of /@child@/ to
    -> Int32
    -- ^ /@row@/: the row number to attach the top side of /@child@/ to
    -> Int32
    -- ^ /@width@/: the number of columns that /@child@/ will span
    -> Int32
    -- ^ /@height@/: the number of rows that /@child@/ will span
    -> m ()
gridAttach grid child column row width height = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    child' <- unsafeManagedPtrCastPtr child
    gtk_grid_attach grid' child' column row width height
    touchManagedPtr grid
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data GridAttachMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> Int32 -> Int32 -> m ()), MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) => O.OverloadedMethod GridAttachMethodInfo a signature where
    overloadedMethod = gridAttach

instance O.OverloadedMethodInfo GridAttachMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridAttach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridAttach"
        })


#endif

-- method Grid::attach_next_to
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sibling"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the child of @grid that @child will be placed\n  next to, or %NULL to place @child at the beginning or end"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "side"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PositionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the side of @sibling that @child is positioned next to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of columns that @child will span"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of rows that @child will span"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_attach_next_to" gtk_grid_attach_next_to :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- sibling : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CUInt ->                                -- side : TInterface (Name {namespace = "Gtk", name = "PositionType"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Adds a widget to the grid.
-- 
-- The widget is placed next to /@sibling@/, on the side determined by
-- /@side@/. When /@sibling@/ is 'P.Nothing', the widget is placed in row (for
-- left or right placement) or column 0 (for top or bottom placement),
-- at the end indicated by /@side@/.
-- 
-- Attaching widgets labeled @[1]@, @[2]@, @[3]@ with @\@sibling == %NULL@ and
-- @\@side == %GTK_POS_LEFT@ yields a layout of @[3][2][1]@.
gridAttachNextTo ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> b
    -- ^ /@child@/: the widget to add
    -> Maybe (c)
    -- ^ /@sibling@/: the child of /@grid@/ that /@child@/ will be placed
    --   next to, or 'P.Nothing' to place /@child@/ at the beginning or end
    -> Gtk.Enums.PositionType
    -- ^ /@side@/: the side of /@sibling@/ that /@child@/ is positioned next to
    -> Int32
    -- ^ /@width@/: the number of columns that /@child@/ will span
    -> Int32
    -- ^ /@height@/: the number of rows that /@child@/ will span
    -> m ()
gridAttachNextTo grid child sibling side width height = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    child' <- unsafeManagedPtrCastPtr child
    maybeSibling <- case sibling of
        Nothing -> return FP.nullPtr
        Just jSibling -> do
            jSibling' <- unsafeManagedPtrCastPtr jSibling
            return jSibling'
    let side' = (fromIntegral . fromEnum) side
    gtk_grid_attach_next_to grid' child' maybeSibling side' width height
    touchManagedPtr grid
    touchManagedPtr child
    whenJust sibling touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GridAttachNextToMethodInfo
instance (signature ~ (b -> Maybe (c) -> Gtk.Enums.PositionType -> Int32 -> Int32 -> m ()), MonadIO m, IsGrid a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) => O.OverloadedMethod GridAttachNextToMethodInfo a signature where
    overloadedMethod = gridAttachNextTo

instance O.OverloadedMethodInfo GridAttachNextToMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridAttachNextTo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridAttachNextTo"
        })


#endif

-- method Grid::get_baseline_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_get_baseline_row" gtk_grid_get_baseline_row :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    IO Int32

-- | Returns which row defines the global baseline of /@grid@/.
gridGetBaselineRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> m Int32
    -- ^ __Returns:__ the row index defining the global baseline
gridGetBaselineRow grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_get_baseline_row grid'
    touchManagedPtr grid
    return result

#if defined(ENABLE_OVERLOADING)
data GridGetBaselineRowMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsGrid a) => O.OverloadedMethod GridGetBaselineRowMethodInfo a signature where
    overloadedMethod = gridGetBaselineRow

instance O.OverloadedMethodInfo GridGetBaselineRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridGetBaselineRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridGetBaselineRow"
        })


#endif

-- method Grid::get_child_at
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the left edge of the cell"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the top edge of the cell"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_get_child_at" gtk_grid_get_child_at :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- column : TBasicType TInt
    Int32 ->                                -- row : TBasicType TInt
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child of /@grid@/ whose area covers the grid
-- cell at /@column@/, /@row@/.
gridGetChildAt ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@column@/: the left edge of the cell
    -> Int32
    -- ^ /@row@/: the top edge of the cell
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child at the given position
gridGetChildAt grid column row = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_get_child_at grid' column row
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr grid
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GridGetChildAtMethodInfo
instance (signature ~ (Int32 -> Int32 -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsGrid a) => O.OverloadedMethod GridGetChildAtMethodInfo a signature where
    overloadedMethod = gridGetChildAt

instance O.OverloadedMethodInfo GridGetChildAtMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridGetChildAt",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridGetChildAt"
        })


#endif

-- method Grid::get_column_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_get_column_homogeneous" gtk_grid_get_column_homogeneous :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    IO CInt

-- | Returns whether all columns of /@grid@/ have the same width.
gridGetColumnHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> m Bool
    -- ^ __Returns:__ whether all columns of /@grid@/ have the same width.
gridGetColumnHomogeneous grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_get_column_homogeneous grid'
    let result' = (/= 0) result
    touchManagedPtr grid
    return result'

#if defined(ENABLE_OVERLOADING)
data GridGetColumnHomogeneousMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGrid a) => O.OverloadedMethod GridGetColumnHomogeneousMethodInfo a signature where
    overloadedMethod = gridGetColumnHomogeneous

instance O.OverloadedMethodInfo GridGetColumnHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridGetColumnHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridGetColumnHomogeneous"
        })


#endif

-- method Grid::get_column_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_get_column_spacing" gtk_grid_get_column_spacing :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    IO Word32

-- | Returns the amount of space between the columns of /@grid@/.
gridGetColumnSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> m Word32
    -- ^ __Returns:__ the column spacing of /@grid@/
gridGetColumnSpacing grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_get_column_spacing grid'
    touchManagedPtr grid
    return result

#if defined(ENABLE_OVERLOADING)
data GridGetColumnSpacingMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGrid a) => O.OverloadedMethod GridGetColumnSpacingMethodInfo a signature where
    overloadedMethod = gridGetColumnSpacing

instance O.OverloadedMethodInfo GridGetColumnSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridGetColumnSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridGetColumnSpacing"
        })


#endif

-- method Grid::get_row_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a row index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BaselinePosition" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_get_row_baseline_position" gtk_grid_get_row_baseline_position :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- row : TBasicType TInt
    IO CUInt

-- | Returns the baseline position of /@row@/.
-- 
-- See 'GI.Gtk.Objects.Grid.gridSetRowBaselinePosition'.
gridGetRowBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@row@/: a row index
    -> m Gtk.Enums.BaselinePosition
    -- ^ __Returns:__ the baseline position of /@row@/
gridGetRowBaselinePosition grid row = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_get_row_baseline_position grid' row
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr grid
    return result'

#if defined(ENABLE_OVERLOADING)
data GridGetRowBaselinePositionMethodInfo
instance (signature ~ (Int32 -> m Gtk.Enums.BaselinePosition), MonadIO m, IsGrid a) => O.OverloadedMethod GridGetRowBaselinePositionMethodInfo a signature where
    overloadedMethod = gridGetRowBaselinePosition

instance O.OverloadedMethodInfo GridGetRowBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridGetRowBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridGetRowBaselinePosition"
        })


#endif

-- method Grid::get_row_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_get_row_homogeneous" gtk_grid_get_row_homogeneous :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    IO CInt

-- | Returns whether all rows of /@grid@/ have the same height.
gridGetRowHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> m Bool
    -- ^ __Returns:__ whether all rows of /@grid@/ have the same height.
gridGetRowHomogeneous grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_get_row_homogeneous grid'
    let result' = (/= 0) result
    touchManagedPtr grid
    return result'

#if defined(ENABLE_OVERLOADING)
data GridGetRowHomogeneousMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGrid a) => O.OverloadedMethod GridGetRowHomogeneousMethodInfo a signature where
    overloadedMethod = gridGetRowHomogeneous

instance O.OverloadedMethodInfo GridGetRowHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridGetRowHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridGetRowHomogeneous"
        })


#endif

-- method Grid::get_row_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_get_row_spacing" gtk_grid_get_row_spacing :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    IO Word32

-- | Returns the amount of space between the rows of /@grid@/.
gridGetRowSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> m Word32
    -- ^ __Returns:__ the row spacing of /@grid@/
gridGetRowSpacing grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_get_row_spacing grid'
    touchManagedPtr grid
    return result

#if defined(ENABLE_OVERLOADING)
data GridGetRowSpacingMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGrid a) => O.OverloadedMethod GridGetRowSpacingMethodInfo a signature where
    overloadedMethod = gridGetRowSpacing

instance O.OverloadedMethodInfo GridGetRowSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridGetRowSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridGetRowSpacing"
        })


#endif

-- method Grid::insert_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position to insert the column at"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_insert_column" gtk_grid_insert_column :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

-- | Inserts a column at the specified position.
-- 
-- Children which are attached at or to the right of this position
-- are moved one column to the right. Children which span across this
-- position are grown to span the new column.
gridInsertColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@position@/: the position to insert the column at
    -> m ()
gridInsertColumn grid position = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_insert_column grid' position
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridInsertColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridInsertColumnMethodInfo a signature where
    overloadedMethod = gridInsertColumn

instance O.OverloadedMethodInfo GridInsertColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridInsertColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridInsertColumn"
        })


#endif

-- method Grid::insert_next_to
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sibling"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the child of @grid that the new row or column will be\n  placed next to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "side"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PositionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the side of @sibling that @child is positioned next to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_insert_next_to" gtk_grid_insert_next_to :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Ptr Gtk.Widget.Widget ->                -- sibling : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CUInt ->                                -- side : TInterface (Name {namespace = "Gtk", name = "PositionType"})
    IO ()

-- | Inserts a row or column at the specified position.
-- 
-- The new row or column is placed next to /@sibling@/, on the side
-- determined by /@side@/. If /@side@/ is 'GI.Gtk.Enums.PositionTypeTop' or 'GI.Gtk.Enums.PositionTypeBottom',
-- a row is inserted. If /@side@/ is 'GI.Gtk.Enums.PositionTypeLeft' of 'GI.Gtk.Enums.PositionTypeRight',
-- a column is inserted.
gridInsertNextTo ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> b
    -- ^ /@sibling@/: the child of /@grid@/ that the new row or column will be
    --   placed next to
    -> Gtk.Enums.PositionType
    -- ^ /@side@/: the side of /@sibling@/ that /@child@/ is positioned next to
    -> m ()
gridInsertNextTo grid sibling side = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    sibling' <- unsafeManagedPtrCastPtr sibling
    let side' = (fromIntegral . fromEnum) side
    gtk_grid_insert_next_to grid' sibling' side'
    touchManagedPtr grid
    touchManagedPtr sibling
    return ()

#if defined(ENABLE_OVERLOADING)
data GridInsertNextToMethodInfo
instance (signature ~ (b -> Gtk.Enums.PositionType -> m ()), MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) => O.OverloadedMethod GridInsertNextToMethodInfo a signature where
    overloadedMethod = gridInsertNextTo

instance O.OverloadedMethodInfo GridInsertNextToMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridInsertNextTo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridInsertNextTo"
        })


#endif

-- method Grid::insert_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position to insert the row at"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_insert_row" gtk_grid_insert_row :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

-- | Inserts a row at the specified position.
-- 
-- Children which are attached at or below this position
-- are moved one row down. Children which span across this
-- position are grown to span the new row.
gridInsertRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@position@/: the position to insert the row at
    -> m ()
gridInsertRow grid position = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_insert_row grid' position
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridInsertRowMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridInsertRowMethodInfo a signature where
    overloadedMethod = gridInsertRow

instance O.OverloadedMethodInfo GridInsertRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridInsertRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridInsertRow"
        })


#endif

-- method Grid::query_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget` child of @grid"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the column used to attach the left side of @child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row used to attach the top side of @child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of columns @child spans"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of rows @child spans"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_query_child" gtk_grid_query_child :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Int32 ->                            -- column : TBasicType TInt
    Ptr Int32 ->                            -- row : TBasicType TInt
    Ptr Int32 ->                            -- width : TBasicType TInt
    Ptr Int32 ->                            -- height : TBasicType TInt
    IO ()

-- | Queries the attach points and spans of /@child@/ inside the given @GtkGrid@.
gridQueryChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> b
    -- ^ /@child@/: a @GtkWidget@ child of /@grid@/
    -> m ((Int32, Int32, Int32, Int32))
gridQueryChild grid child = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    child' <- unsafeManagedPtrCastPtr child
    column <- allocMem :: IO (Ptr Int32)
    row <- allocMem :: IO (Ptr Int32)
    width <- allocMem :: IO (Ptr Int32)
    height <- allocMem :: IO (Ptr Int32)
    gtk_grid_query_child grid' child' column row width height
    column' <- peek column
    row' <- peek row
    width' <- peek width
    height' <- peek height
    touchManagedPtr grid
    touchManagedPtr child
    freeMem column
    freeMem row
    freeMem width
    freeMem height
    return (column', row', width', height')

#if defined(ENABLE_OVERLOADING)
data GridQueryChildMethodInfo
instance (signature ~ (b -> m ((Int32, Int32, Int32, Int32))), MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) => O.OverloadedMethod GridQueryChildMethodInfo a signature where
    overloadedMethod = gridQueryChild

instance O.OverloadedMethodInfo GridQueryChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridQueryChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridQueryChild"
        })


#endif

-- method Grid::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_remove" gtk_grid_remove :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes a child from /@grid@/.
-- 
-- The child must have been added with
-- 'GI.Gtk.Objects.Grid.gridAttach' or 'GI.Gtk.Objects.Grid.gridAttachNextTo'.
gridRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> b
    -- ^ /@child@/: the child widget to remove
    -> m ()
gridRemove grid child = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    child' <- unsafeManagedPtrCastPtr child
    gtk_grid_remove grid' child'
    touchManagedPtr grid
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data GridRemoveMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsGrid a, Gtk.Widget.IsWidget b) => O.OverloadedMethod GridRemoveMethodInfo a signature where
    overloadedMethod = gridRemove

instance O.OverloadedMethodInfo GridRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridRemove"
        })


#endif

-- method Grid::remove_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the column to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_remove_column" gtk_grid_remove_column :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

-- | Removes a column from the grid.
-- 
-- Children that are placed in this column are removed,
-- spanning children that overlap this column have their
-- width reduced by one, and children after the column
-- are moved to the left.
gridRemoveColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@position@/: the position of the column to remove
    -> m ()
gridRemoveColumn grid position = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_remove_column grid' position
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridRemoveColumnMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridRemoveColumnMethodInfo a signature where
    overloadedMethod = gridRemoveColumn

instance O.OverloadedMethodInfo GridRemoveColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridRemoveColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridRemoveColumn"
        })


#endif

-- method Grid::remove_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the row to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_remove_row" gtk_grid_remove_row :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

-- | Removes a row from the grid.
-- 
-- Children that are placed in this row are removed,
-- spanning children that overlap this row have their
-- height reduced by one, and children below the row
-- are moved up.
gridRemoveRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@position@/: the position of the row to remove
    -> m ()
gridRemoveRow grid position = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_remove_row grid' position
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridRemoveRowMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridRemoveRowMethodInfo a signature where
    overloadedMethod = gridRemoveRow

instance O.OverloadedMethodInfo GridRemoveRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridRemoveRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridRemoveRow"
        })


#endif

-- method Grid::set_baseline_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_set_baseline_row" gtk_grid_set_baseline_row :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- row : TBasicType TInt
    IO ()

-- | Sets which row defines the global baseline for the entire grid.
-- 
-- Each row in the grid can have its own local baseline, but only
-- one of those is global, meaning it will be the baseline in the
-- parent of the /@grid@/.
gridSetBaselineRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@row@/: the row index
    -> m ()
gridSetBaselineRow grid row = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_set_baseline_row grid' row
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridSetBaselineRowMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridSetBaselineRowMethodInfo a signature where
    overloadedMethod = gridSetBaselineRow

instance O.OverloadedMethodInfo GridSetBaselineRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridSetBaselineRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridSetBaselineRow"
        })


#endif

-- method Grid::set_column_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "homogeneous"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make columns homogeneous"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_set_column_homogeneous" gtk_grid_set_column_homogeneous :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    CInt ->                                 -- homogeneous : TBasicType TBoolean
    IO ()

-- | Sets whether all columns of /@grid@/ will have the same width.
gridSetColumnHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Bool
    -- ^ /@homogeneous@/: 'P.True' to make columns homogeneous
    -> m ()
gridSetColumnHomogeneous grid homogeneous = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    let homogeneous' = (P.fromIntegral . P.fromEnum) homogeneous
    gtk_grid_set_column_homogeneous grid' homogeneous'
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridSetColumnHomogeneousMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridSetColumnHomogeneousMethodInfo a signature where
    overloadedMethod = gridSetColumnHomogeneous

instance O.OverloadedMethodInfo GridSetColumnHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridSetColumnHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridSetColumnHomogeneous"
        })


#endif

-- method Grid::set_column_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spacing"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the amount of space to insert between columns"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_set_column_spacing" gtk_grid_set_column_spacing :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Word32 ->                               -- spacing : TBasicType TUInt
    IO ()

-- | Sets the amount of space between columns of /@grid@/.
gridSetColumnSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Word32
    -- ^ /@spacing@/: the amount of space to insert between columns
    -> m ()
gridSetColumnSpacing grid spacing = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_set_column_spacing grid' spacing
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridSetColumnSpacingMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridSetColumnSpacingMethodInfo a signature where
    overloadedMethod = gridSetColumnSpacing

instance O.OverloadedMethodInfo GridSetColumnSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridSetColumnSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridSetColumnSpacing"
        })


#endif

-- method Grid::set_row_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a row index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BaselinePosition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBaselinePosition`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_set_row_baseline_position" gtk_grid_set_row_baseline_position :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Int32 ->                                -- row : TBasicType TInt
    CUInt ->                                -- pos : TInterface (Name {namespace = "Gtk", name = "BaselinePosition"})
    IO ()

-- | Sets how the baseline should be positioned on /@row@/ of the
-- grid, in case that row is assigned more space than is requested.
-- 
-- The default baseline position is 'GI.Gtk.Enums.BaselinePositionCenter'.
gridSetRowBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Int32
    -- ^ /@row@/: a row index
    -> Gtk.Enums.BaselinePosition
    -- ^ /@pos@/: a @GtkBaselinePosition@
    -> m ()
gridSetRowBaselinePosition grid row pos = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    let pos' = (fromIntegral . fromEnum) pos
    gtk_grid_set_row_baseline_position grid' row pos'
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridSetRowBaselinePositionMethodInfo
instance (signature ~ (Int32 -> Gtk.Enums.BaselinePosition -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridSetRowBaselinePositionMethodInfo a signature where
    overloadedMethod = gridSetRowBaselinePosition

instance O.OverloadedMethodInfo GridSetRowBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridSetRowBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridSetRowBaselinePosition"
        })


#endif

-- method Grid::set_row_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "homogeneous"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make rows homogeneous"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_set_row_homogeneous" gtk_grid_set_row_homogeneous :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    CInt ->                                 -- homogeneous : TBasicType TBoolean
    IO ()

-- | Sets whether all rows of /@grid@/ will have the same height.
gridSetRowHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Bool
    -- ^ /@homogeneous@/: 'P.True' to make rows homogeneous
    -> m ()
gridSetRowHomogeneous grid homogeneous = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    let homogeneous' = (P.fromIntegral . P.fromEnum) homogeneous
    gtk_grid_set_row_homogeneous grid' homogeneous'
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridSetRowHomogeneousMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridSetRowHomogeneousMethodInfo a signature where
    overloadedMethod = gridSetRowHomogeneous

instance O.OverloadedMethodInfo GridSetRowHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridSetRowHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridSetRowHomogeneous"
        })


#endif

-- method Grid::set_row_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Grid" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGrid`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spacing"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the amount of space to insert between rows"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_set_row_spacing" gtk_grid_set_row_spacing :: 
    Ptr Grid ->                             -- grid : TInterface (Name {namespace = "Gtk", name = "Grid"})
    Word32 ->                               -- spacing : TBasicType TUInt
    IO ()

-- | Sets the amount of space between rows of /@grid@/.
gridSetRowSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGrid a) =>
    a
    -- ^ /@grid@/: a @GtkGrid@
    -> Word32
    -- ^ /@spacing@/: the amount of space to insert between rows
    -> m ()
gridSetRowSpacing grid spacing = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_set_row_spacing grid' spacing
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridSetRowSpacingMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsGrid a) => O.OverloadedMethod GridSetRowSpacingMethodInfo a signature where
    overloadedMethod = gridSetRowSpacing

instance O.OverloadedMethodInfo GridSetRowSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Grid.gridSetRowSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Grid.html#v:gridSetRowSpacing"
        })


#endif


