{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Bypasses gsk rendering by passing the content of its child directly to the compositor.
-- 
-- Graphics offload is an optimization to reduce overhead and battery use that is
-- most useful for video content. It only works on some platforms and in certain
-- situations. GTK will automatically fall back to normal rendering if it doesn\'t.
-- 
-- Graphics offload is most efficient if there are no controls drawn on top of the
-- video content.
-- 
-- You should consider using graphics offload for your main widget if it shows
-- frequently changing content (such as a video, or a VM display) and you provide
-- the content in the form of dmabuf textures (see t'GI.Gdk.Objects.DmabufTextureBuilder.DmabufTextureBuilder'),
-- in particular if it may be fullscreen.
-- 
-- Numerous factors can prohibit graphics offload:
-- 
-- * Unsupported platforms. Currently, graphics offload only works on Linux with Wayland.
-- * Clipping, such as rounded corners that cause the video content to not be rectangular
-- * Unsupported dmabuf formats (see 'GI.Gdk.Objects.Display.displayGetDmabufFormats')
-- * Translucent video content (content with an alpha channel, even if it isn\'t used)
-- * Transforms that are more complex than translations and scales
-- * Filters such as opacity, grayscale or similar
-- 
-- 
-- To investigate problems related graphics offload, GTK offers debug flags to print
-- out information about graphics offload and dmabuf use:
-- 
--     GDK_DEBUG=offload
--     GDK_DEBUG=dmabuf
-- 
-- The GTK inspector provides a visual debugging tool for graphics offload.
-- 
-- /Since: 4.14/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.GraphicsOffload
    ( 

-- * Exported types
    GraphicsOffload(..)                     ,
    IsGraphicsOffload                       ,
    toGraphicsOffload                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBlackBackground]("GI.Gtk.Objects.GraphicsOffload#g:method:getBlackBackground"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.GraphicsOffload#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEnabled]("GI.Gtk.Objects.GraphicsOffload#g:method:getEnabled"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setBlackBackground]("GI.Gtk.Objects.GraphicsOffload#g:method:setBlackBackground"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.GraphicsOffload#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEnabled]("GI.Gtk.Objects.GraphicsOffload#g:method:setEnabled"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveGraphicsOffloadMethod            ,
#endif

-- ** getBlackBackground #method:getBlackBackground#

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadGetBlackBackgroundMethodInfo,
#endif
    graphicsOffloadGetBlackBackground       ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadGetChildMethodInfo       ,
#endif
    graphicsOffloadGetChild                 ,


-- ** getEnabled #method:getEnabled#

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadGetEnabledMethodInfo     ,
#endif
    graphicsOffloadGetEnabled               ,


-- ** new #method:new#

    graphicsOffloadNew                      ,


-- ** setBlackBackground #method:setBlackBackground#

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadSetBlackBackgroundMethodInfo,
#endif
    graphicsOffloadSetBlackBackground       ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadSetChildMethodInfo       ,
#endif
    graphicsOffloadSetChild                 ,


-- ** setEnabled #method:setEnabled#

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadSetEnabledMethodInfo     ,
#endif
    graphicsOffloadSetEnabled               ,




 -- * Properties


-- ** blackBackground #attr:blackBackground#
-- | Whether to draw a black background.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadBlackBackgroundPropertyInfo,
#endif
    constructGraphicsOffloadBlackBackground ,
    getGraphicsOffloadBlackBackground       ,
#if defined(ENABLE_OVERLOADING)
    graphicsOffloadBlackBackground          ,
#endif
    setGraphicsOffloadBlackBackground       ,


-- ** child #attr:child#
-- | The child widget.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadChildPropertyInfo        ,
#endif
    clearGraphicsOffloadChild               ,
    constructGraphicsOffloadChild           ,
    getGraphicsOffloadChild                 ,
#if defined(ENABLE_OVERLOADING)
    graphicsOffloadChild                    ,
#endif
    setGraphicsOffloadChild                 ,


-- ** enabled #attr:enabled#
-- | Whether graphics offload is enabled.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    GraphicsOffloadEnabledPropertyInfo      ,
#endif
    constructGraphicsOffloadEnabled         ,
    getGraphicsOffloadEnabled               ,
#if defined(ENABLE_OVERLOADING)
    graphicsOffloadEnabled                  ,
#endif
    setGraphicsOffloadEnabled               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype GraphicsOffload = GraphicsOffload (SP.ManagedPtr GraphicsOffload)
    deriving (Eq)

instance SP.ManagedPtrNewtype GraphicsOffload where
    toManagedPtr (GraphicsOffload p) = p

foreign import ccall "gtk_graphics_offload_get_type"
    c_gtk_graphics_offload_get_type :: IO B.Types.GType

instance B.Types.TypedObject GraphicsOffload where
    glibType = c_gtk_graphics_offload_get_type

instance B.Types.GObject GraphicsOffload

-- | Type class for types which can be safely cast to `GraphicsOffload`, for instance with `toGraphicsOffload`.
class (SP.GObject o, O.IsDescendantOf GraphicsOffload o) => IsGraphicsOffload o
instance (SP.GObject o, O.IsDescendantOf GraphicsOffload o) => IsGraphicsOffload o

instance O.HasParentTypes GraphicsOffload
type instance O.ParentTypes GraphicsOffload = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `GraphicsOffload`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toGraphicsOffload :: (MIO.MonadIO m, IsGraphicsOffload o) => o -> m GraphicsOffload
toGraphicsOffload = MIO.liftIO . B.ManagedPtr.unsafeCastTo GraphicsOffload

-- | Convert 'GraphicsOffload' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GraphicsOffload) where
    gvalueGType_ = c_gtk_graphics_offload_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GraphicsOffload)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GraphicsOffload)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GraphicsOffload ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGraphicsOffloadMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGraphicsOffloadMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveGraphicsOffloadMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveGraphicsOffloadMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveGraphicsOffloadMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveGraphicsOffloadMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveGraphicsOffloadMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveGraphicsOffloadMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveGraphicsOffloadMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveGraphicsOffloadMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveGraphicsOffloadMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveGraphicsOffloadMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGraphicsOffloadMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGraphicsOffloadMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveGraphicsOffloadMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveGraphicsOffloadMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveGraphicsOffloadMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveGraphicsOffloadMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveGraphicsOffloadMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveGraphicsOffloadMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveGraphicsOffloadMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveGraphicsOffloadMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveGraphicsOffloadMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveGraphicsOffloadMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveGraphicsOffloadMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGraphicsOffloadMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGraphicsOffloadMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGraphicsOffloadMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveGraphicsOffloadMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveGraphicsOffloadMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveGraphicsOffloadMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveGraphicsOffloadMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveGraphicsOffloadMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveGraphicsOffloadMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveGraphicsOffloadMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveGraphicsOffloadMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveGraphicsOffloadMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveGraphicsOffloadMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveGraphicsOffloadMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveGraphicsOffloadMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveGraphicsOffloadMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGraphicsOffloadMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveGraphicsOffloadMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveGraphicsOffloadMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveGraphicsOffloadMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveGraphicsOffloadMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveGraphicsOffloadMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveGraphicsOffloadMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveGraphicsOffloadMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveGraphicsOffloadMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGraphicsOffloadMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGraphicsOffloadMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveGraphicsOffloadMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveGraphicsOffloadMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveGraphicsOffloadMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveGraphicsOffloadMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveGraphicsOffloadMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveGraphicsOffloadMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveGraphicsOffloadMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGraphicsOffloadMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGraphicsOffloadMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveGraphicsOffloadMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveGraphicsOffloadMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveGraphicsOffloadMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveGraphicsOffloadMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveGraphicsOffloadMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveGraphicsOffloadMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveGraphicsOffloadMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGraphicsOffloadMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveGraphicsOffloadMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveGraphicsOffloadMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveGraphicsOffloadMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveGraphicsOffloadMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGraphicsOffloadMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGraphicsOffloadMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGraphicsOffloadMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveGraphicsOffloadMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveGraphicsOffloadMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveGraphicsOffloadMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveGraphicsOffloadMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveGraphicsOffloadMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGraphicsOffloadMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveGraphicsOffloadMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveGraphicsOffloadMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveGraphicsOffloadMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveGraphicsOffloadMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveGraphicsOffloadMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveGraphicsOffloadMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGraphicsOffloadMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveGraphicsOffloadMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveGraphicsOffloadMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveGraphicsOffloadMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveGraphicsOffloadMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveGraphicsOffloadMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveGraphicsOffloadMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveGraphicsOffloadMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveGraphicsOffloadMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveGraphicsOffloadMethod "getBlackBackground" o = GraphicsOffloadGetBlackBackgroundMethodInfo
    ResolveGraphicsOffloadMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveGraphicsOffloadMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveGraphicsOffloadMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveGraphicsOffloadMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveGraphicsOffloadMethod "getChild" o = GraphicsOffloadGetChildMethodInfo
    ResolveGraphicsOffloadMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveGraphicsOffloadMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveGraphicsOffloadMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveGraphicsOffloadMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveGraphicsOffloadMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveGraphicsOffloadMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveGraphicsOffloadMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGraphicsOffloadMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveGraphicsOffloadMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveGraphicsOffloadMethod "getEnabled" o = GraphicsOffloadGetEnabledMethodInfo
    ResolveGraphicsOffloadMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveGraphicsOffloadMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveGraphicsOffloadMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveGraphicsOffloadMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveGraphicsOffloadMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveGraphicsOffloadMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveGraphicsOffloadMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveGraphicsOffloadMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveGraphicsOffloadMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveGraphicsOffloadMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveGraphicsOffloadMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveGraphicsOffloadMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveGraphicsOffloadMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveGraphicsOffloadMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveGraphicsOffloadMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveGraphicsOffloadMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveGraphicsOffloadMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveGraphicsOffloadMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveGraphicsOffloadMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveGraphicsOffloadMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveGraphicsOffloadMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveGraphicsOffloadMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveGraphicsOffloadMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveGraphicsOffloadMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveGraphicsOffloadMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveGraphicsOffloadMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveGraphicsOffloadMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveGraphicsOffloadMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveGraphicsOffloadMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveGraphicsOffloadMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveGraphicsOffloadMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveGraphicsOffloadMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveGraphicsOffloadMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveGraphicsOffloadMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGraphicsOffloadMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGraphicsOffloadMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveGraphicsOffloadMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveGraphicsOffloadMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveGraphicsOffloadMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveGraphicsOffloadMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveGraphicsOffloadMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveGraphicsOffloadMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveGraphicsOffloadMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveGraphicsOffloadMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveGraphicsOffloadMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveGraphicsOffloadMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveGraphicsOffloadMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveGraphicsOffloadMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveGraphicsOffloadMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveGraphicsOffloadMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveGraphicsOffloadMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveGraphicsOffloadMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveGraphicsOffloadMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveGraphicsOffloadMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveGraphicsOffloadMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveGraphicsOffloadMethod "setBlackBackground" o = GraphicsOffloadSetBlackBackgroundMethodInfo
    ResolveGraphicsOffloadMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveGraphicsOffloadMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveGraphicsOffloadMethod "setChild" o = GraphicsOffloadSetChildMethodInfo
    ResolveGraphicsOffloadMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveGraphicsOffloadMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveGraphicsOffloadMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveGraphicsOffloadMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveGraphicsOffloadMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGraphicsOffloadMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGraphicsOffloadMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveGraphicsOffloadMethod "setEnabled" o = GraphicsOffloadSetEnabledMethodInfo
    ResolveGraphicsOffloadMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveGraphicsOffloadMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveGraphicsOffloadMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveGraphicsOffloadMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveGraphicsOffloadMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveGraphicsOffloadMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveGraphicsOffloadMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveGraphicsOffloadMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveGraphicsOffloadMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveGraphicsOffloadMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveGraphicsOffloadMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveGraphicsOffloadMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveGraphicsOffloadMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveGraphicsOffloadMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveGraphicsOffloadMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveGraphicsOffloadMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveGraphicsOffloadMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveGraphicsOffloadMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveGraphicsOffloadMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveGraphicsOffloadMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGraphicsOffloadMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveGraphicsOffloadMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveGraphicsOffloadMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveGraphicsOffloadMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveGraphicsOffloadMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveGraphicsOffloadMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveGraphicsOffloadMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveGraphicsOffloadMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveGraphicsOffloadMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveGraphicsOffloadMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveGraphicsOffloadMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGraphicsOffloadMethod t GraphicsOffload, O.OverloadedMethod info GraphicsOffload p) => OL.IsLabel t (GraphicsOffload -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGraphicsOffloadMethod t GraphicsOffload, O.OverloadedMethod info GraphicsOffload p, R.HasField t GraphicsOffload p) => R.HasField t GraphicsOffload p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGraphicsOffloadMethod t GraphicsOffload, O.OverloadedMethodInfo info GraphicsOffload) => OL.IsLabel t (O.MethodProxy info GraphicsOffload) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "black-background"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@black-background@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' graphicsOffload #blackBackground
-- @
getGraphicsOffloadBlackBackground :: (MonadIO m, IsGraphicsOffload o) => o -> m Bool
getGraphicsOffloadBlackBackground obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "black-background"

-- | Set the value of the “@black-background@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' graphicsOffload [ #blackBackground 'Data.GI.Base.Attributes.:=' value ]
-- @
setGraphicsOffloadBlackBackground :: (MonadIO m, IsGraphicsOffload o) => o -> Bool -> m ()
setGraphicsOffloadBlackBackground obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "black-background" val

-- | Construct a `GValueConstruct` with valid value for the “@black-background@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGraphicsOffloadBlackBackground :: (IsGraphicsOffload o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGraphicsOffloadBlackBackground val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "black-background" val

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadBlackBackgroundPropertyInfo
instance AttrInfo GraphicsOffloadBlackBackgroundPropertyInfo where
    type AttrAllowedOps GraphicsOffloadBlackBackgroundPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GraphicsOffloadBlackBackgroundPropertyInfo = IsGraphicsOffload
    type AttrSetTypeConstraint GraphicsOffloadBlackBackgroundPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GraphicsOffloadBlackBackgroundPropertyInfo = (~) Bool
    type AttrTransferType GraphicsOffloadBlackBackgroundPropertyInfo = Bool
    type AttrGetType GraphicsOffloadBlackBackgroundPropertyInfo = Bool
    type AttrLabel GraphicsOffloadBlackBackgroundPropertyInfo = "black-background"
    type AttrOrigin GraphicsOffloadBlackBackgroundPropertyInfo = GraphicsOffload
    attrGet = getGraphicsOffloadBlackBackground
    attrSet = setGraphicsOffloadBlackBackground
    attrTransfer _ v = do
        return v
    attrConstruct = constructGraphicsOffloadBlackBackground
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.blackBackground"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#g:attr:blackBackground"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' graphicsOffload #child
-- @
getGraphicsOffloadChild :: (MonadIO m, IsGraphicsOffload o) => o -> m (Maybe Gtk.Widget.Widget)
getGraphicsOffloadChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' graphicsOffload [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setGraphicsOffloadChild :: (MonadIO m, IsGraphicsOffload o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setGraphicsOffloadChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGraphicsOffloadChild :: (IsGraphicsOffload o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructGraphicsOffloadChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearGraphicsOffloadChild :: (MonadIO m, IsGraphicsOffload o) => o -> m ()
clearGraphicsOffloadChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadChildPropertyInfo
instance AttrInfo GraphicsOffloadChildPropertyInfo where
    type AttrAllowedOps GraphicsOffloadChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GraphicsOffloadChildPropertyInfo = IsGraphicsOffload
    type AttrSetTypeConstraint GraphicsOffloadChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint GraphicsOffloadChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType GraphicsOffloadChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType GraphicsOffloadChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel GraphicsOffloadChildPropertyInfo = "child"
    type AttrOrigin GraphicsOffloadChildPropertyInfo = GraphicsOffload
    attrGet = getGraphicsOffloadChild
    attrSet = setGraphicsOffloadChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructGraphicsOffloadChild
    attrClear = clearGraphicsOffloadChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#g:attr:child"
        })
#endif

-- VVV Prop "enabled"
   -- Type: TInterface (Name {namespace = "Gtk", name = "GraphicsOffloadEnabled"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@enabled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' graphicsOffload #enabled
-- @
getGraphicsOffloadEnabled :: (MonadIO m, IsGraphicsOffload o) => o -> m Gtk.Enums.GraphicsOffloadEnabled
getGraphicsOffloadEnabled obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "enabled"

-- | Set the value of the “@enabled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' graphicsOffload [ #enabled 'Data.GI.Base.Attributes.:=' value ]
-- @
setGraphicsOffloadEnabled :: (MonadIO m, IsGraphicsOffload o) => o -> Gtk.Enums.GraphicsOffloadEnabled -> m ()
setGraphicsOffloadEnabled obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "enabled" val

-- | Construct a `GValueConstruct` with valid value for the “@enabled@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGraphicsOffloadEnabled :: (IsGraphicsOffload o, MIO.MonadIO m) => Gtk.Enums.GraphicsOffloadEnabled -> m (GValueConstruct o)
constructGraphicsOffloadEnabled val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "enabled" val

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadEnabledPropertyInfo
instance AttrInfo GraphicsOffloadEnabledPropertyInfo where
    type AttrAllowedOps GraphicsOffloadEnabledPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GraphicsOffloadEnabledPropertyInfo = IsGraphicsOffload
    type AttrSetTypeConstraint GraphicsOffloadEnabledPropertyInfo = (~) Gtk.Enums.GraphicsOffloadEnabled
    type AttrTransferTypeConstraint GraphicsOffloadEnabledPropertyInfo = (~) Gtk.Enums.GraphicsOffloadEnabled
    type AttrTransferType GraphicsOffloadEnabledPropertyInfo = Gtk.Enums.GraphicsOffloadEnabled
    type AttrGetType GraphicsOffloadEnabledPropertyInfo = Gtk.Enums.GraphicsOffloadEnabled
    type AttrLabel GraphicsOffloadEnabledPropertyInfo = "enabled"
    type AttrOrigin GraphicsOffloadEnabledPropertyInfo = GraphicsOffload
    attrGet = getGraphicsOffloadEnabled
    attrSet = setGraphicsOffloadEnabled
    attrTransfer _ v = do
        return v
    attrConstruct = constructGraphicsOffloadEnabled
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.enabled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#g:attr:enabled"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GraphicsOffload
type instance O.AttributeList GraphicsOffload = GraphicsOffloadAttributeList
type GraphicsOffloadAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("blackBackground", GraphicsOffloadBlackBackgroundPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", GraphicsOffloadChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("enabled", GraphicsOffloadEnabledPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
graphicsOffloadBlackBackground :: AttrLabelProxy "blackBackground"
graphicsOffloadBlackBackground = AttrLabelProxy

graphicsOffloadChild :: AttrLabelProxy "child"
graphicsOffloadChild = AttrLabelProxy

graphicsOffloadEnabled :: AttrLabelProxy "enabled"
graphicsOffloadEnabled = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GraphicsOffload = GraphicsOffloadSignalList
type GraphicsOffloadSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GraphicsOffload::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "GraphicsOffload" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_graphics_offload_new" gtk_graphics_offload_new :: 
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr GraphicsOffload)

-- | Creates a new GtkGraphicsOffload widget.
-- 
-- /Since: 4.14/
graphicsOffloadNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    Maybe (a)
    -- ^ /@child@/: the child widget
    -> m GraphicsOffload
    -- ^ __Returns:__ the new widget
graphicsOffloadNew child = liftIO $ do
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    result <- gtk_graphics_offload_new maybeChild
    checkUnexpectedReturnNULL "graphicsOffloadNew" result
    result' <- (newObject GraphicsOffload) result
    whenJust child touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GraphicsOffload::get_black_background
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GraphicsOffload" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGraphicsOffload`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_graphics_offload_get_black_background" gtk_graphics_offload_get_black_background :: 
    Ptr GraphicsOffload ->                  -- self : TInterface (Name {namespace = "Gtk", name = "GraphicsOffload"})
    IO CInt

-- | Returns whether the widget draws a black background.
-- 
-- See 'GI.Gtk.Objects.GraphicsOffload.graphicsOffloadSetBlackBackground'.
-- 
-- /Since: 4.16/
graphicsOffloadGetBlackBackground ::
    (B.CallStack.HasCallStack, MonadIO m, IsGraphicsOffload a) =>
    a
    -- ^ /@self@/: a @GtkGraphicsOffload@
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if black background is drawn
graphicsOffloadGetBlackBackground self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_graphics_offload_get_black_background self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadGetBlackBackgroundMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGraphicsOffload a) => O.OverloadedMethod GraphicsOffloadGetBlackBackgroundMethodInfo a signature where
    overloadedMethod = graphicsOffloadGetBlackBackground

instance O.OverloadedMethodInfo GraphicsOffloadGetBlackBackgroundMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.graphicsOffloadGetBlackBackground",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#v:graphicsOffloadGetBlackBackground"
        })


#endif

-- method GraphicsOffload::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GraphicsOffload" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGraphicsOffload`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_graphics_offload_get_child" gtk_graphics_offload_get_child :: 
    Ptr GraphicsOffload ->                  -- self : TInterface (Name {namespace = "Gtk", name = "GraphicsOffload"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child of /@self@/.
-- 
-- /Since: 4.14/
graphicsOffloadGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsGraphicsOffload a) =>
    a
    -- ^ /@self@/: a @GtkGraphicsOffload@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget
graphicsOffloadGetChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_graphics_offload_get_child self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsGraphicsOffload a) => O.OverloadedMethod GraphicsOffloadGetChildMethodInfo a signature where
    overloadedMethod = graphicsOffloadGetChild

instance O.OverloadedMethodInfo GraphicsOffloadGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.graphicsOffloadGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#v:graphicsOffloadGetChild"
        })


#endif

-- method GraphicsOffload::get_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GraphicsOffload" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGraphicsOffload`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "GraphicsOffloadEnabled" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_graphics_offload_get_enabled" gtk_graphics_offload_get_enabled :: 
    Ptr GraphicsOffload ->                  -- self : TInterface (Name {namespace = "Gtk", name = "GraphicsOffload"})
    IO CUInt

-- | Returns whether offload is enabled for /@self@/.
-- 
-- /Since: 4.14/
graphicsOffloadGetEnabled ::
    (B.CallStack.HasCallStack, MonadIO m, IsGraphicsOffload a) =>
    a
    -- ^ /@self@/: a @GtkGraphicsOffload@
    -> m Gtk.Enums.GraphicsOffloadEnabled
    -- ^ __Returns:__ whether offload is enabled
graphicsOffloadGetEnabled self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_graphics_offload_get_enabled self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadGetEnabledMethodInfo
instance (signature ~ (m Gtk.Enums.GraphicsOffloadEnabled), MonadIO m, IsGraphicsOffload a) => O.OverloadedMethod GraphicsOffloadGetEnabledMethodInfo a signature where
    overloadedMethod = graphicsOffloadGetEnabled

instance O.OverloadedMethodInfo GraphicsOffloadGetEnabledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.graphicsOffloadGetEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#v:graphicsOffloadGetEnabled"
        })


#endif

-- method GraphicsOffload::set_black_background
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GraphicsOffload" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGraphicsOffload`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to draw a black background behind the content"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_graphics_offload_set_black_background" gtk_graphics_offload_set_black_background :: 
    Ptr GraphicsOffload ->                  -- self : TInterface (Name {namespace = "Gtk", name = "GraphicsOffload"})
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()

-- | Sets whether this GtkGraphicsOffload widget will draw a black
-- background.
-- 
-- A main use case for this is **_letterboxing_** where black bars are
-- visible next to the content if the aspect ratio of the content does
-- not match the dimensions of the monitor.
-- 
-- Using this property for letterboxing instead of CSS allows compositors
-- to show content with maximum efficiency, using direct scanout to avoid
-- extra copies in the compositor.
-- 
-- On Wayland, this is implemented using the
-- <https://wayland.app/protocols/single-pixel-buffer-v1 single-pixel buffer>
-- protocol.
-- 
-- /Since: 4.16/
graphicsOffloadSetBlackBackground ::
    (B.CallStack.HasCallStack, MonadIO m, IsGraphicsOffload a) =>
    a
    -- ^ /@self@/: a @GtkGraphicsOffload@
    -> Bool
    -- ^ /@value@/: whether to draw a black background behind the content
    -> m ()
graphicsOffloadSetBlackBackground self value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let value' = (P.fromIntegral . P.fromEnum) value
    gtk_graphics_offload_set_black_background self' value'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadSetBlackBackgroundMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGraphicsOffload a) => O.OverloadedMethod GraphicsOffloadSetBlackBackgroundMethodInfo a signature where
    overloadedMethod = graphicsOffloadSetBlackBackground

instance O.OverloadedMethodInfo GraphicsOffloadSetBlackBackgroundMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.graphicsOffloadSetBlackBackground",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#v:graphicsOffloadSetBlackBackground"
        })


#endif

-- method GraphicsOffload::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GraphicsOffload" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGraphicsOffload`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_graphics_offload_set_child" gtk_graphics_offload_set_child :: 
    Ptr GraphicsOffload ->                  -- self : TInterface (Name {namespace = "Gtk", name = "GraphicsOffload"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child of /@self@/.
-- 
-- /Since: 4.14/
graphicsOffloadSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsGraphicsOffload a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkGraphicsOffload@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
graphicsOffloadSetChild self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_graphics_offload_set_child self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsGraphicsOffload a, Gtk.Widget.IsWidget b) => O.OverloadedMethod GraphicsOffloadSetChildMethodInfo a signature where
    overloadedMethod = graphicsOffloadSetChild

instance O.OverloadedMethodInfo GraphicsOffloadSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.graphicsOffloadSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#v:graphicsOffloadSetChild"
        })


#endif

-- method GraphicsOffload::set_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GraphicsOffload" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGraphicsOffload`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enabled"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "GraphicsOffloadEnabled" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to enable offload"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_graphics_offload_set_enabled" gtk_graphics_offload_set_enabled :: 
    Ptr GraphicsOffload ->                  -- self : TInterface (Name {namespace = "Gtk", name = "GraphicsOffload"})
    CUInt ->                                -- enabled : TInterface (Name {namespace = "Gtk", name = "GraphicsOffloadEnabled"})
    IO ()

-- | Sets whether this GtkGraphicsOffload widget will attempt
-- to offload the content of its child widget.
-- 
-- /Since: 4.14/
graphicsOffloadSetEnabled ::
    (B.CallStack.HasCallStack, MonadIO m, IsGraphicsOffload a) =>
    a
    -- ^ /@self@/: a @GtkGraphicsOffload@
    -> Gtk.Enums.GraphicsOffloadEnabled
    -- ^ /@enabled@/: whether to enable offload
    -> m ()
graphicsOffloadSetEnabled self enabled = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let enabled' = (fromIntegral . fromEnum) enabled
    gtk_graphics_offload_set_enabled self' enabled'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GraphicsOffloadSetEnabledMethodInfo
instance (signature ~ (Gtk.Enums.GraphicsOffloadEnabled -> m ()), MonadIO m, IsGraphicsOffload a) => O.OverloadedMethod GraphicsOffloadSetEnabledMethodInfo a signature where
    overloadedMethod = graphicsOffloadSetEnabled

instance O.OverloadedMethodInfo GraphicsOffloadSetEnabledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GraphicsOffload.graphicsOffloadSetEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GraphicsOffload.html#v:graphicsOffloadSetEnabled"
        })


#endif


