{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Recognizes 2-finger rotation gestures.
-- 
-- Whenever the angle between both handled sequences changes, the
-- [GestureRotate::angleChanged]("GI.Gtk.Objects.GestureRotate#g:signal:angleChanged") signal is emitted.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.GestureRotate
    ( 

-- * Exported types
    GestureRotate(..)                       ,
    IsGestureRotate                         ,
    toGestureRotate                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [group]("GI.Gtk.Objects.Gesture#g:method:group"), [handlesSequence]("GI.Gtk.Objects.Gesture#g:method:handlesSequence"), [isActive]("GI.Gtk.Objects.Gesture#g:method:isActive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isGroupedWith]("GI.Gtk.Objects.Gesture#g:method:isGroupedWith"), [isRecognized]("GI.Gtk.Objects.Gesture#g:method:isRecognized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungroup]("GI.Gtk.Objects.Gesture#g:method:ungroup"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAngleDelta]("GI.Gtk.Objects.GestureRotate#g:method:getAngleDelta"), [getBoundingBox]("GI.Gtk.Objects.Gesture#g:method:getBoundingBox"), [getBoundingBoxCenter]("GI.Gtk.Objects.Gesture#g:method:getBoundingBoxCenter"), [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDevice]("GI.Gtk.Objects.Gesture#g:method:getDevice"), [getGroup]("GI.Gtk.Objects.Gesture#g:method:getGroup"), [getLastEvent]("GI.Gtk.Objects.Gesture#g:method:getLastEvent"), [getLastUpdatedSequence]("GI.Gtk.Objects.Gesture#g:method:getLastUpdatedSequence"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPoint]("GI.Gtk.Objects.Gesture#g:method:getPoint"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSequenceState]("GI.Gtk.Objects.Gesture#g:method:getSequenceState"), [getSequences]("GI.Gtk.Objects.Gesture#g:method:getSequences"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSequenceState]("GI.Gtk.Objects.Gesture#g:method:setSequenceState"), [setState]("GI.Gtk.Objects.Gesture#g:method:setState"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveGestureRotateMethod              ,
#endif

-- ** getAngleDelta #method:getAngleDelta#

#if defined(ENABLE_OVERLOADING)
    GestureRotateGetAngleDeltaMethodInfo    ,
#endif
    gestureRotateGetAngleDelta              ,


-- ** new #method:new#

    gestureRotateNew                        ,




 -- * Signals


-- ** angleChanged #signal:angleChanged#

    GestureRotateAngleChangedCallback       ,
#if defined(ENABLE_OVERLOADING)
    GestureRotateAngleChangedSignalInfo     ,
#endif
    afterGestureRotateAngleChanged          ,
    onGestureRotateAngleChanged             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture

#endif

-- | Memory-managed wrapper type.
newtype GestureRotate = GestureRotate (SP.ManagedPtr GestureRotate)
    deriving (Eq)

instance SP.ManagedPtrNewtype GestureRotate where
    toManagedPtr (GestureRotate p) = p

foreign import ccall "gtk_gesture_rotate_get_type"
    c_gtk_gesture_rotate_get_type :: IO B.Types.GType

instance B.Types.TypedObject GestureRotate where
    glibType = c_gtk_gesture_rotate_get_type

instance B.Types.GObject GestureRotate

-- | Type class for types which can be safely cast to `GestureRotate`, for instance with `toGestureRotate`.
class (SP.GObject o, O.IsDescendantOf GestureRotate o) => IsGestureRotate o
instance (SP.GObject o, O.IsDescendantOf GestureRotate o) => IsGestureRotate o

instance O.HasParentTypes GestureRotate
type instance O.ParentTypes GestureRotate = '[Gtk.Gesture.Gesture, Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to `GestureRotate`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toGestureRotate :: (MIO.MonadIO m, IsGestureRotate o) => o -> m GestureRotate
toGestureRotate = MIO.liftIO . B.ManagedPtr.unsafeCastTo GestureRotate

-- | Convert 'GestureRotate' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GestureRotate) where
    gvalueGType_ = c_gtk_gesture_rotate_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GestureRotate)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GestureRotate)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GestureRotate ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGestureRotateMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGestureRotateMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGestureRotateMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGestureRotateMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGestureRotateMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGestureRotateMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGestureRotateMethod "group" o = Gtk.Gesture.GestureGroupMethodInfo
    ResolveGestureRotateMethod "handlesSequence" o = Gtk.Gesture.GestureHandlesSequenceMethodInfo
    ResolveGestureRotateMethod "isActive" o = Gtk.Gesture.GestureIsActiveMethodInfo
    ResolveGestureRotateMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGestureRotateMethod "isGroupedWith" o = Gtk.Gesture.GestureIsGroupedWithMethodInfo
    ResolveGestureRotateMethod "isRecognized" o = Gtk.Gesture.GestureIsRecognizedMethodInfo
    ResolveGestureRotateMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGestureRotateMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGestureRotateMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGestureRotateMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGestureRotateMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveGestureRotateMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGestureRotateMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGestureRotateMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGestureRotateMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGestureRotateMethod "ungroup" o = Gtk.Gesture.GestureUngroupMethodInfo
    ResolveGestureRotateMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGestureRotateMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGestureRotateMethod "getAngleDelta" o = GestureRotateGetAngleDeltaMethodInfo
    ResolveGestureRotateMethod "getBoundingBox" o = Gtk.Gesture.GestureGetBoundingBoxMethodInfo
    ResolveGestureRotateMethod "getBoundingBoxCenter" o = Gtk.Gesture.GestureGetBoundingBoxCenterMethodInfo
    ResolveGestureRotateMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveGestureRotateMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveGestureRotateMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveGestureRotateMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveGestureRotateMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGestureRotateMethod "getDevice" o = Gtk.Gesture.GestureGetDeviceMethodInfo
    ResolveGestureRotateMethod "getGroup" o = Gtk.Gesture.GestureGetGroupMethodInfo
    ResolveGestureRotateMethod "getLastEvent" o = Gtk.Gesture.GestureGetLastEventMethodInfo
    ResolveGestureRotateMethod "getLastUpdatedSequence" o = Gtk.Gesture.GestureGetLastUpdatedSequenceMethodInfo
    ResolveGestureRotateMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveGestureRotateMethod "getPoint" o = Gtk.Gesture.GestureGetPointMethodInfo
    ResolveGestureRotateMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveGestureRotateMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveGestureRotateMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGestureRotateMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGestureRotateMethod "getSequenceState" o = Gtk.Gesture.GestureGetSequenceStateMethodInfo
    ResolveGestureRotateMethod "getSequences" o = Gtk.Gesture.GestureGetSequencesMethodInfo
    ResolveGestureRotateMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveGestureRotateMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGestureRotateMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGestureRotateMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveGestureRotateMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveGestureRotateMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveGestureRotateMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGestureRotateMethod "setSequenceState" o = Gtk.Gesture.GestureSetSequenceStateMethodInfo
    ResolveGestureRotateMethod "setState" o = Gtk.Gesture.GestureSetStateMethodInfo
    ResolveGestureRotateMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveGestureRotateMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGestureRotateMethod t GestureRotate, O.OverloadedMethod info GestureRotate p) => OL.IsLabel t (GestureRotate -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGestureRotateMethod t GestureRotate, O.OverloadedMethod info GestureRotate p, R.HasField t GestureRotate p) => R.HasField t GestureRotate p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGestureRotateMethod t GestureRotate, O.OverloadedMethodInfo info GestureRotate) => OL.IsLabel t (O.MethodProxy info GestureRotate) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal GestureRotate::angle-changed
-- | Emitted when the angle between both tracked points changes.
type GestureRotateAngleChangedCallback =
    Double
    -- ^ /@angle@/: Current angle in radians
    -> Double
    -- ^ /@angleDelta@/: Difference with the starting angle, in radians
    -> IO ()

type C_GestureRotateAngleChangedCallback =
    Ptr GestureRotate ->                    -- object
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureRotateAngleChangedCallback`.
foreign import ccall "wrapper"
    mk_GestureRotateAngleChangedCallback :: C_GestureRotateAngleChangedCallback -> IO (FunPtr C_GestureRotateAngleChangedCallback)

wrap_GestureRotateAngleChangedCallback :: 
    GObject a => (a -> GestureRotateAngleChangedCallback) ->
    C_GestureRotateAngleChangedCallback
wrap_GestureRotateAngleChangedCallback gi'cb gi'selfPtr angle angleDelta _ = do
    let angle' = realToFrac angle
    let angleDelta' = realToFrac angleDelta
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  angle' angleDelta'


-- | Connect a signal handler for the [angleChanged](#signal:angleChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureRotate #angleChanged callback
-- @
-- 
-- 
onGestureRotateAngleChanged :: (IsGestureRotate a, MonadIO m) => a -> ((?self :: a) => GestureRotateAngleChangedCallback) -> m SignalHandlerId
onGestureRotateAngleChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureRotateAngleChangedCallback wrapped
    wrapped'' <- mk_GestureRotateAngleChangedCallback wrapped'
    connectSignalFunPtr obj "angle-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [angleChanged](#signal:angleChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureRotate #angleChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureRotateAngleChanged :: (IsGestureRotate a, MonadIO m) => a -> ((?self :: a) => GestureRotateAngleChangedCallback) -> m SignalHandlerId
afterGestureRotateAngleChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureRotateAngleChangedCallback wrapped
    wrapped'' <- mk_GestureRotateAngleChangedCallback wrapped'
    connectSignalFunPtr obj "angle-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureRotateAngleChangedSignalInfo
instance SignalInfo GestureRotateAngleChangedSignalInfo where
    type HaskellCallbackType GestureRotateAngleChangedSignalInfo = GestureRotateAngleChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureRotateAngleChangedCallback cb
        cb'' <- mk_GestureRotateAngleChangedCallback cb'
        connectSignalFunPtr obj "angle-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureRotate::angle-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GestureRotate.html#g:signal:angleChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GestureRotate
type instance O.AttributeList GestureRotate = GestureRotateAttributeList
type GestureRotateAttributeList = ('[ '("nPoints", Gtk.Gesture.GestureNPointsPropertyInfo), '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GestureRotate = GestureRotateSignalList
type GestureRotateSignalList = ('[ '("angleChanged", GestureRotateAngleChangedSignalInfo), '("begin", Gtk.Gesture.GestureBeginSignalInfo), '("cancel", Gtk.Gesture.GestureCancelSignalInfo), '("end", Gtk.Gesture.GestureEndSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sequenceStateChanged", Gtk.Gesture.GestureSequenceStateChangedSignalInfo), '("update", Gtk.Gesture.GestureUpdateSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GestureRotate::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "GestureRotate" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_rotate_new" gtk_gesture_rotate_new :: 
    IO (Ptr GestureRotate)

-- | Returns a newly created @GtkGesture@ that recognizes 2-touch
-- rotation gestures.
gestureRotateNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GestureRotate
    -- ^ __Returns:__ a newly created @GtkGestureRotate@
gestureRotateNew  = liftIO $ do
    result <- gtk_gesture_rotate_new
    checkUnexpectedReturnNULL "gestureRotateNew" result
    result' <- (wrapObject GestureRotate) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GestureRotate::get_angle_delta
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "gesture"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GestureRotate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGestureRotate`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_rotate_get_angle_delta" gtk_gesture_rotate_get_angle_delta :: 
    Ptr GestureRotate ->                    -- gesture : TInterface (Name {namespace = "Gtk", name = "GestureRotate"})
    IO CDouble

-- | Gets the angle delta in radians.
-- 
-- If /@gesture@/ is active, this function returns the angle difference
-- in radians since the gesture was first recognized. If /@gesture@/ is
-- not active, 0 is returned.
gestureRotateGetAngleDelta ::
    (B.CallStack.HasCallStack, MonadIO m, IsGestureRotate a) =>
    a
    -- ^ /@gesture@/: a @GtkGestureRotate@
    -> m Double
    -- ^ __Returns:__ the angle delta in radians
gestureRotateGetAngleDelta gesture = liftIO $ do
    gesture' <- unsafeManagedPtrCastPtr gesture
    result <- gtk_gesture_rotate_get_angle_delta gesture'
    let result' = realToFrac result
    touchManagedPtr gesture
    return result'

#if defined(ENABLE_OVERLOADING)
data GestureRotateGetAngleDeltaMethodInfo
instance (signature ~ (m Double), MonadIO m, IsGestureRotate a) => O.OverloadedMethod GestureRotateGetAngleDeltaMethodInfo a signature where
    overloadedMethod = gestureRotateGetAngleDelta

instance O.OverloadedMethodInfo GestureRotateGetAngleDeltaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureRotate.gestureRotateGetAngleDelta",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-GestureRotate.html#v:gestureRotateGetAngleDelta"
        })


#endif


