{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Surrounds its child with a decorative frame and an optional label.
-- 
-- \<picture>
--   \<source srcset=\"frame-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkFrame\" src=\"frame.png\">
-- \<\/picture>
-- 
-- If present, the label is drawn inside the top edge of the frame.
-- The horizontal position of the label can be controlled with
-- 'GI.Gtk.Objects.Frame.frameSetLabelAlign'.
-- 
-- @GtkFrame@ clips its child. You can use this to add rounded corners
-- to widgets, but be aware that it also cuts off shadows.
-- 
-- = GtkFrame as GtkBuildable
-- 
-- The @GtkFrame@ implementation of the @GtkBuildable@ interface supports
-- placing a child in the label position by specifying “label” as the
-- “type” attribute of a @\<child>@ element. A normal content child can
-- be specified without specifying a @\<child>@ type attribute.
-- 
-- An example of a UI definition fragment with GtkFrame:
-- 
-- === /xml code/
-- ><object class="GtkFrame">
-- >  <child type="label">
-- >    <object class="GtkLabel" id="frame_label"/>
-- >  </child>
-- >  <child>
-- >    <object class="GtkEntry" id="frame_content"/>
-- >  </child>
-- ></object>
-- 
-- 
-- = CSS nodes
-- 
-- >frame
-- >├── <label widget>
-- >╰── <child>
-- 
-- 
-- @GtkFrame@ has a main CSS node with name “frame”, which is used to draw the
-- visible border. You can set the appearance of the border using CSS properties
-- like “border-style” on this node.
-- 
-- = Accessibility
-- 
-- @GtkFrame@ uses the [enum/@gtk@/.AccessibleRole.group] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Frame
    ( 

-- * Exported types
    Frame(..)                               ,
    IsFrame                                 ,
    toFrame                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Frame#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLabel]("GI.Gtk.Objects.Frame#g:method:getLabel"), [getLabelAlign]("GI.Gtk.Objects.Frame#g:method:getLabelAlign"), [getLabelWidget]("GI.Gtk.Objects.Frame#g:method:getLabelWidget"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Frame#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLabel]("GI.Gtk.Objects.Frame#g:method:setLabel"), [setLabelAlign]("GI.Gtk.Objects.Frame#g:method:setLabelAlign"), [setLabelWidget]("GI.Gtk.Objects.Frame#g:method:setLabelWidget"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveFrameMethod                      ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    FrameGetChildMethodInfo                 ,
#endif
    frameGetChild                           ,


-- ** getLabel #method:getLabel#

#if defined(ENABLE_OVERLOADING)
    FrameGetLabelMethodInfo                 ,
#endif
    frameGetLabel                           ,


-- ** getLabelAlign #method:getLabelAlign#

#if defined(ENABLE_OVERLOADING)
    FrameGetLabelAlignMethodInfo            ,
#endif
    frameGetLabelAlign                      ,


-- ** getLabelWidget #method:getLabelWidget#

#if defined(ENABLE_OVERLOADING)
    FrameGetLabelWidgetMethodInfo           ,
#endif
    frameGetLabelWidget                     ,


-- ** new #method:new#

    frameNew                                ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    FrameSetChildMethodInfo                 ,
#endif
    frameSetChild                           ,


-- ** setLabel #method:setLabel#

#if defined(ENABLE_OVERLOADING)
    FrameSetLabelMethodInfo                 ,
#endif
    frameSetLabel                           ,


-- ** setLabelAlign #method:setLabelAlign#

#if defined(ENABLE_OVERLOADING)
    FrameSetLabelAlignMethodInfo            ,
#endif
    frameSetLabelAlign                      ,


-- ** setLabelWidget #method:setLabelWidget#

#if defined(ENABLE_OVERLOADING)
    FrameSetLabelWidgetMethodInfo           ,
#endif
    frameSetLabelWidget                     ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    FrameChildPropertyInfo                  ,
#endif
    clearFrameChild                         ,
    constructFrameChild                     ,
#if defined(ENABLE_OVERLOADING)
    frameChild                              ,
#endif
    getFrameChild                           ,
    setFrameChild                           ,


-- ** label #attr:label#
-- | Text of the frame\'s label.

#if defined(ENABLE_OVERLOADING)
    FrameLabelPropertyInfo                  ,
#endif
    clearFrameLabel                         ,
    constructFrameLabel                     ,
#if defined(ENABLE_OVERLOADING)
    frameLabel                              ,
#endif
    getFrameLabel                           ,
    setFrameLabel                           ,


-- ** labelWidget #attr:labelWidget#
-- | Widget to display in place of the usual frame label.

#if defined(ENABLE_OVERLOADING)
    FrameLabelWidgetPropertyInfo            ,
#endif
    clearFrameLabelWidget                   ,
    constructFrameLabelWidget               ,
#if defined(ENABLE_OVERLOADING)
    frameLabelWidget                        ,
#endif
    getFrameLabelWidget                     ,
    setFrameLabelWidget                     ,


-- ** labelXalign #attr:labelXalign#
-- | The horizontal alignment of the label.

#if defined(ENABLE_OVERLOADING)
    FrameLabelXalignPropertyInfo            ,
#endif
    constructFrameLabelXalign               ,
#if defined(ENABLE_OVERLOADING)
    frameLabelXalign                        ,
#endif
    getFrameLabelXalign                     ,
    setFrameLabelXalign                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Frame = Frame (SP.ManagedPtr Frame)
    deriving (Eq)

instance SP.ManagedPtrNewtype Frame where
    toManagedPtr (Frame p) = p

foreign import ccall "gtk_frame_get_type"
    c_gtk_frame_get_type :: IO B.Types.GType

instance B.Types.TypedObject Frame where
    glibType = c_gtk_frame_get_type

instance B.Types.GObject Frame

-- | Type class for types which can be safely cast to `Frame`, for instance with `toFrame`.
class (SP.GObject o, O.IsDescendantOf Frame o) => IsFrame o
instance (SP.GObject o, O.IsDescendantOf Frame o) => IsFrame o

instance O.HasParentTypes Frame
type instance O.ParentTypes Frame = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Frame`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFrame :: (MIO.MonadIO m, IsFrame o) => o -> m Frame
toFrame = MIO.liftIO . B.ManagedPtr.unsafeCastTo Frame

-- | Convert 'Frame' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Frame) where
    gvalueGType_ = c_gtk_frame_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Frame)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Frame)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Frame ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFrameMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFrameMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveFrameMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveFrameMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveFrameMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveFrameMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveFrameMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveFrameMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveFrameMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveFrameMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveFrameMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveFrameMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFrameMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFrameMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveFrameMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveFrameMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveFrameMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveFrameMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveFrameMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveFrameMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveFrameMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveFrameMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveFrameMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveFrameMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveFrameMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFrameMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFrameMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFrameMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveFrameMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveFrameMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveFrameMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveFrameMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveFrameMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveFrameMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveFrameMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveFrameMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveFrameMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveFrameMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveFrameMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveFrameMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveFrameMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFrameMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveFrameMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveFrameMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveFrameMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveFrameMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveFrameMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveFrameMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveFrameMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveFrameMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFrameMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFrameMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveFrameMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveFrameMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveFrameMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveFrameMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveFrameMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveFrameMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveFrameMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFrameMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFrameMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveFrameMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveFrameMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveFrameMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveFrameMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveFrameMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveFrameMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveFrameMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFrameMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveFrameMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveFrameMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveFrameMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveFrameMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFrameMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFrameMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFrameMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveFrameMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveFrameMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveFrameMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveFrameMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveFrameMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFrameMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveFrameMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveFrameMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveFrameMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveFrameMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveFrameMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveFrameMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFrameMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveFrameMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveFrameMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveFrameMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveFrameMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveFrameMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveFrameMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveFrameMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveFrameMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveFrameMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveFrameMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveFrameMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveFrameMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveFrameMethod "getChild" o = FrameGetChildMethodInfo
    ResolveFrameMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveFrameMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveFrameMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveFrameMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveFrameMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveFrameMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveFrameMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFrameMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveFrameMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveFrameMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveFrameMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveFrameMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveFrameMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveFrameMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveFrameMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveFrameMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveFrameMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveFrameMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveFrameMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveFrameMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveFrameMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveFrameMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveFrameMethod "getLabel" o = FrameGetLabelMethodInfo
    ResolveFrameMethod "getLabelAlign" o = FrameGetLabelAlignMethodInfo
    ResolveFrameMethod "getLabelWidget" o = FrameGetLabelWidgetMethodInfo
    ResolveFrameMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveFrameMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveFrameMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveFrameMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveFrameMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveFrameMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveFrameMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveFrameMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveFrameMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveFrameMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveFrameMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveFrameMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveFrameMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveFrameMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveFrameMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveFrameMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveFrameMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveFrameMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveFrameMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveFrameMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveFrameMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFrameMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFrameMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveFrameMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveFrameMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveFrameMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveFrameMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveFrameMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveFrameMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveFrameMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveFrameMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveFrameMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveFrameMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveFrameMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveFrameMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveFrameMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveFrameMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveFrameMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveFrameMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveFrameMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveFrameMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveFrameMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveFrameMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveFrameMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveFrameMethod "setChild" o = FrameSetChildMethodInfo
    ResolveFrameMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveFrameMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveFrameMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveFrameMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveFrameMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFrameMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFrameMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveFrameMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveFrameMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveFrameMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveFrameMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveFrameMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveFrameMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveFrameMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveFrameMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveFrameMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveFrameMethod "setLabel" o = FrameSetLabelMethodInfo
    ResolveFrameMethod "setLabelAlign" o = FrameSetLabelAlignMethodInfo
    ResolveFrameMethod "setLabelWidget" o = FrameSetLabelWidgetMethodInfo
    ResolveFrameMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveFrameMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveFrameMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveFrameMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveFrameMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveFrameMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveFrameMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveFrameMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveFrameMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveFrameMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveFrameMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFrameMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveFrameMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveFrameMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveFrameMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveFrameMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveFrameMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveFrameMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveFrameMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveFrameMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveFrameMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveFrameMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFrameMethod t Frame, O.OverloadedMethod info Frame p) => OL.IsLabel t (Frame -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFrameMethod t Frame, O.OverloadedMethod info Frame p, R.HasField t Frame p) => R.HasField t Frame p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFrameMethod t Frame, O.OverloadedMethodInfo info Frame) => OL.IsLabel t (O.MethodProxy info Frame) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' frame #child
-- @
getFrameChild :: (MonadIO m, IsFrame o) => o -> m (Maybe Gtk.Widget.Widget)
getFrameChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' frame [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setFrameChild :: (MonadIO m, IsFrame o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setFrameChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFrameChild :: (IsFrame o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructFrameChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearFrameChild :: (MonadIO m, IsFrame o) => o -> m ()
clearFrameChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data FrameChildPropertyInfo
instance AttrInfo FrameChildPropertyInfo where
    type AttrAllowedOps FrameChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FrameChildPropertyInfo = IsFrame
    type AttrSetTypeConstraint FrameChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint FrameChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType FrameChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType FrameChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel FrameChildPropertyInfo = "child"
    type AttrOrigin FrameChildPropertyInfo = Frame
    attrGet = getFrameChild
    attrSet = setFrameChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructFrameChild
    attrClear = clearFrameChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#g:attr:child"
        })
#endif

-- VVV Prop "label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' frame #label
-- @
getFrameLabel :: (MonadIO m, IsFrame o) => o -> m (Maybe T.Text)
getFrameLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "label"

-- | Set the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' frame [ #label 'Data.GI.Base.Attributes.:=' value ]
-- @
setFrameLabel :: (MonadIO m, IsFrame o) => o -> T.Text -> m ()
setFrameLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "label" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFrameLabel :: (IsFrame o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructFrameLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "label" (P.Just val)

-- | Set the value of the “@label@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #label
-- @
clearFrameLabel :: (MonadIO m, IsFrame o) => o -> m ()
clearFrameLabel obj = liftIO $ B.Properties.setObjectPropertyString obj "label" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data FrameLabelPropertyInfo
instance AttrInfo FrameLabelPropertyInfo where
    type AttrAllowedOps FrameLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FrameLabelPropertyInfo = IsFrame
    type AttrSetTypeConstraint FrameLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint FrameLabelPropertyInfo = (~) T.Text
    type AttrTransferType FrameLabelPropertyInfo = T.Text
    type AttrGetType FrameLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel FrameLabelPropertyInfo = "label"
    type AttrOrigin FrameLabelPropertyInfo = Frame
    attrGet = getFrameLabel
    attrSet = setFrameLabel
    attrTransfer _ v = do
        return v
    attrConstruct = constructFrameLabel
    attrClear = clearFrameLabel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.label"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#g:attr:label"
        })
#endif

-- VVV Prop "label-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@label-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' frame #labelWidget
-- @
getFrameLabelWidget :: (MonadIO m, IsFrame o) => o -> m (Maybe Gtk.Widget.Widget)
getFrameLabelWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "label-widget" Gtk.Widget.Widget

-- | Set the value of the “@label-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' frame [ #labelWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setFrameLabelWidget :: (MonadIO m, IsFrame o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setFrameLabelWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "label-widget" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@label-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFrameLabelWidget :: (IsFrame o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructFrameLabelWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "label-widget" (P.Just val)

-- | Set the value of the “@label-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #labelWidget
-- @
clearFrameLabelWidget :: (MonadIO m, IsFrame o) => o -> m ()
clearFrameLabelWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "label-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data FrameLabelWidgetPropertyInfo
instance AttrInfo FrameLabelWidgetPropertyInfo where
    type AttrAllowedOps FrameLabelWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FrameLabelWidgetPropertyInfo = IsFrame
    type AttrSetTypeConstraint FrameLabelWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint FrameLabelWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType FrameLabelWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType FrameLabelWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel FrameLabelWidgetPropertyInfo = "label-widget"
    type AttrOrigin FrameLabelWidgetPropertyInfo = Frame
    attrGet = getFrameLabelWidget
    attrSet = setFrameLabelWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructFrameLabelWidget
    attrClear = clearFrameLabelWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.labelWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#g:attr:labelWidget"
        })
#endif

-- VVV Prop "label-xalign"
   -- Type: TBasicType TFloat
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@label-xalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' frame #labelXalign
-- @
getFrameLabelXalign :: (MonadIO m, IsFrame o) => o -> m Float
getFrameLabelXalign obj = MIO.liftIO $ B.Properties.getObjectPropertyFloat obj "label-xalign"

-- | Set the value of the “@label-xalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' frame [ #labelXalign 'Data.GI.Base.Attributes.:=' value ]
-- @
setFrameLabelXalign :: (MonadIO m, IsFrame o) => o -> Float -> m ()
setFrameLabelXalign obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFloat obj "label-xalign" val

-- | Construct a `GValueConstruct` with valid value for the “@label-xalign@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFrameLabelXalign :: (IsFrame o, MIO.MonadIO m) => Float -> m (GValueConstruct o)
constructFrameLabelXalign val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFloat "label-xalign" val

#if defined(ENABLE_OVERLOADING)
data FrameLabelXalignPropertyInfo
instance AttrInfo FrameLabelXalignPropertyInfo where
    type AttrAllowedOps FrameLabelXalignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FrameLabelXalignPropertyInfo = IsFrame
    type AttrSetTypeConstraint FrameLabelXalignPropertyInfo = (~) Float
    type AttrTransferTypeConstraint FrameLabelXalignPropertyInfo = (~) Float
    type AttrTransferType FrameLabelXalignPropertyInfo = Float
    type AttrGetType FrameLabelXalignPropertyInfo = Float
    type AttrLabel FrameLabelXalignPropertyInfo = "label-xalign"
    type AttrOrigin FrameLabelXalignPropertyInfo = Frame
    attrGet = getFrameLabelXalign
    attrSet = setFrameLabelXalign
    attrTransfer _ v = do
        return v
    attrConstruct = constructFrameLabelXalign
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.labelXalign"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#g:attr:labelXalign"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Frame
type instance O.AttributeList Frame = FrameAttributeList
type FrameAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", FrameChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("label", FrameLabelPropertyInfo), '("labelWidget", FrameLabelWidgetPropertyInfo), '("labelXalign", FrameLabelXalignPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
frameChild :: AttrLabelProxy "child"
frameChild = AttrLabelProxy

frameLabel :: AttrLabelProxy "label"
frameLabel = AttrLabelProxy

frameLabelWidget :: AttrLabelProxy "labelWidget"
frameLabelWidget = AttrLabelProxy

frameLabelXalign :: AttrLabelProxy "labelXalign"
frameLabelXalign = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Frame = FrameSignalList
type FrameSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Frame::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text to use as the label of the frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Frame" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_new" gtk_frame_new :: 
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr Frame)

-- | Creates a new @GtkFrame@, with optional label /@label@/.
-- 
-- If /@label@/ is 'P.Nothing', the label is omitted.
frameNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@label@/: the text to use as the label of the frame
    -> m Frame
    -- ^ __Returns:__ a new @GtkFrame@ widget
frameNew label = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    result <- gtk_frame_new maybeLabel
    checkUnexpectedReturnNULL "frameNew" result
    result' <- (newObject Frame) result
    freeMem maybeLabel
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Frame::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_get_child" gtk_frame_get_child :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@frame@/.
frameGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@frame@/
frameGetChild frame = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    result <- gtk_frame_get_child frame'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr frame
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FrameGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsFrame a) => O.OverloadedMethod FrameGetChildMethodInfo a signature where
    overloadedMethod = frameGetChild

instance O.OverloadedMethodInfo FrameGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameGetChild"
        })


#endif

-- method Frame::get_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_get_label" gtk_frame_get_label :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    IO CString

-- | Returns the frame labels text.
-- 
-- If the frame\'s label widget is not a @GtkLabel@, 'P.Nothing'
-- is returned.
frameGetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the text in the label, or 'P.Nothing' if there
    --    was no label widget or the label widget was not a @GtkLabel@.
    --    This string is owned by GTK and must not be modified or freed.
frameGetLabel frame = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    result <- gtk_frame_get_label frame'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr frame
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FrameGetLabelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsFrame a) => O.OverloadedMethod FrameGetLabelMethodInfo a signature where
    overloadedMethod = frameGetLabel

instance O.OverloadedMethodInfo FrameGetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameGetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameGetLabel"
        })


#endif

-- method Frame::get_label_align
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_get_label_align" gtk_frame_get_label_align :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    IO CFloat

-- | Retrieves the X alignment of the frame’s label.
frameGetLabelAlign ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> m Float
    -- ^ __Returns:__ the frames X alignment
frameGetLabelAlign frame = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    result <- gtk_frame_get_label_align frame'
    let result' = realToFrac result
    touchManagedPtr frame
    return result'

#if defined(ENABLE_OVERLOADING)
data FrameGetLabelAlignMethodInfo
instance (signature ~ (m Float), MonadIO m, IsFrame a) => O.OverloadedMethod FrameGetLabelAlignMethodInfo a signature where
    overloadedMethod = frameGetLabelAlign

instance O.OverloadedMethodInfo FrameGetLabelAlignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameGetLabelAlign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameGetLabelAlign"
        })


#endif

-- method Frame::get_label_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_get_label_widget" gtk_frame_get_label_widget :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the label widget for the frame.
frameGetLabelWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the label widget
frameGetLabelWidget frame = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    result <- gtk_frame_get_label_widget frame'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr frame
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FrameGetLabelWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsFrame a) => O.OverloadedMethod FrameGetLabelWidgetMethodInfo a signature where
    overloadedMethod = frameGetLabelWidget

instance O.OverloadedMethodInfo FrameGetLabelWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameGetLabelWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameGetLabelWidget"
        })


#endif

-- method Frame::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_set_child" gtk_frame_set_child :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@frame@/.
frameSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
frameSetChild frame child = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_frame_set_child frame' maybeChild
    touchManagedPtr frame
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsFrame a, Gtk.Widget.IsWidget b) => O.OverloadedMethod FrameSetChildMethodInfo a signature where
    overloadedMethod = frameSetChild

instance O.OverloadedMethodInfo FrameSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameSetChild"
        })


#endif

-- method Frame::set_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text to use as the label of the frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_set_label" gtk_frame_set_label :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    CString ->                              -- label : TBasicType TUTF8
    IO ()

-- | Creates a new @GtkLabel@ with the /@label@/ and sets it as the frame\'s
-- label widget.
frameSetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> Maybe (T.Text)
    -- ^ /@label@/: the text to use as the label of the frame
    -> m ()
frameSetLabel frame label = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    gtk_frame_set_label frame' maybeLabel
    touchManagedPtr frame
    freeMem maybeLabel
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameSetLabelMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsFrame a) => O.OverloadedMethod FrameSetLabelMethodInfo a signature where
    overloadedMethod = frameSetLabel

instance O.OverloadedMethodInfo FrameSetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameSetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameSetLabel"
        })


#endif

-- method Frame::set_label_align
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xalign"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The position of the label along the top edge\n  of the widget. A value of 0.0 represents left alignment;\n  1.0 represents right alignment."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_set_label_align" gtk_frame_set_label_align :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    CFloat ->                               -- xalign : TBasicType TFloat
    IO ()

-- | Sets the X alignment of the frame widget’s label.
-- 
-- The default value for a newly created frame is 0.0.
frameSetLabelAlign ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> Float
    -- ^ /@xalign@/: The position of the label along the top edge
    --   of the widget. A value of 0.0 represents left alignment;
    --   1.0 represents right alignment.
    -> m ()
frameSetLabelAlign frame xalign = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    let xalign' = realToFrac xalign
    gtk_frame_set_label_align frame' xalign'
    touchManagedPtr frame
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameSetLabelAlignMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m, IsFrame a) => O.OverloadedMethod FrameSetLabelAlignMethodInfo a signature where
    overloadedMethod = frameSetLabelAlign

instance O.OverloadedMethodInfo FrameSetLabelAlignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameSetLabelAlign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameSetLabelAlign"
        })


#endif

-- method Frame::set_label_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Frame" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFrame`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label_widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new label widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_frame_set_label_widget" gtk_frame_set_label_widget :: 
    Ptr Frame ->                            -- frame : TInterface (Name {namespace = "Gtk", name = "Frame"})
    Ptr Gtk.Widget.Widget ->                -- label_widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the label widget for the frame.
-- 
-- This is the widget that will appear embedded in the top edge
-- of the frame as a title.
frameSetLabelWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrame a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@frame@/: a @GtkFrame@
    -> Maybe (b)
    -- ^ /@labelWidget@/: the new label widget
    -> m ()
frameSetLabelWidget frame labelWidget = liftIO $ do
    frame' <- unsafeManagedPtrCastPtr frame
    maybeLabelWidget <- case labelWidget of
        Nothing -> return FP.nullPtr
        Just jLabelWidget -> do
            jLabelWidget' <- unsafeManagedPtrCastPtr jLabelWidget
            return jLabelWidget'
    gtk_frame_set_label_widget frame' maybeLabelWidget
    touchManagedPtr frame
    whenJust labelWidget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameSetLabelWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsFrame a, Gtk.Widget.IsWidget b) => O.OverloadedMethod FrameSetLabelWidgetMethodInfo a signature where
    overloadedMethod = frameSetLabelWidget

instance O.OverloadedMethodInfo FrameSetLabelWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Frame.frameSetLabelWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Frame.html#v:frameSetLabelWidget"
        })


#endif


