{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Opens a font chooser dialog to select a font.
-- 
-- \<picture>
--   \<source srcset=\"font-button-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkFontDialogButton\" src=\"font-button.png\">
-- \<\/picture>
-- 
-- It is suitable widget for selecting a font in a preference dialog.
-- 
-- = CSS nodes
-- 
-- >fontbutton
-- >╰── button.font
-- >    ╰── [content]
-- 
-- 
-- @GtkFontDialogButton@ has a single CSS node with name fontbutton which
-- contains a button node with the .font style class.
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.FontDialogButton
    ( 

-- * Exported types
    FontDialogButton(..)                    ,
    IsFontDialogButton                      ,
    toFontDialogButton                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDialog]("GI.Gtk.Objects.FontDialogButton#g:method:getDialog"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontDesc]("GI.Gtk.Objects.FontDialogButton#g:method:getFontDesc"), [getFontFeatures]("GI.Gtk.Objects.FontDialogButton#g:method:getFontFeatures"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLanguage]("GI.Gtk.Objects.FontDialogButton#g:method:getLanguage"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLevel]("GI.Gtk.Objects.FontDialogButton#g:method:getLevel"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseFont]("GI.Gtk.Objects.FontDialogButton#g:method:getUseFont"), [getUseSize]("GI.Gtk.Objects.FontDialogButton#g:method:getUseSize"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDialog]("GI.Gtk.Objects.FontDialogButton#g:method:setDialog"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontDesc]("GI.Gtk.Objects.FontDialogButton#g:method:setFontDesc"), [setFontFeatures]("GI.Gtk.Objects.FontDialogButton#g:method:setFontFeatures"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLanguage]("GI.Gtk.Objects.FontDialogButton#g:method:setLanguage"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLevel]("GI.Gtk.Objects.FontDialogButton#g:method:setLevel"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseFont]("GI.Gtk.Objects.FontDialogButton#g:method:setUseFont"), [setUseSize]("GI.Gtk.Objects.FontDialogButton#g:method:setUseSize"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveFontDialogButtonMethod           ,
#endif

-- ** getDialog #method:getDialog#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonGetDialogMethodInfo     ,
#endif
    fontDialogButtonGetDialog               ,


-- ** getFontDesc #method:getFontDesc#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonGetFontDescMethodInfo   ,
#endif
    fontDialogButtonGetFontDesc             ,


-- ** getFontFeatures #method:getFontFeatures#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonGetFontFeaturesMethodInfo,
#endif
    fontDialogButtonGetFontFeatures         ,


-- ** getLanguage #method:getLanguage#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonGetLanguageMethodInfo   ,
#endif
    fontDialogButtonGetLanguage             ,


-- ** getLevel #method:getLevel#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonGetLevelMethodInfo      ,
#endif
    fontDialogButtonGetLevel                ,


-- ** getUseFont #method:getUseFont#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonGetUseFontMethodInfo    ,
#endif
    fontDialogButtonGetUseFont              ,


-- ** getUseSize #method:getUseSize#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonGetUseSizeMethodInfo    ,
#endif
    fontDialogButtonGetUseSize              ,


-- ** new #method:new#

    fontDialogButtonNew                     ,


-- ** setDialog #method:setDialog#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonSetDialogMethodInfo     ,
#endif
    fontDialogButtonSetDialog               ,


-- ** setFontDesc #method:setFontDesc#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonSetFontDescMethodInfo   ,
#endif
    fontDialogButtonSetFontDesc             ,


-- ** setFontFeatures #method:setFontFeatures#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonSetFontFeaturesMethodInfo,
#endif
    fontDialogButtonSetFontFeatures         ,


-- ** setLanguage #method:setLanguage#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonSetLanguageMethodInfo   ,
#endif
    fontDialogButtonSetLanguage             ,


-- ** setLevel #method:setLevel#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonSetLevelMethodInfo      ,
#endif
    fontDialogButtonSetLevel                ,


-- ** setUseFont #method:setUseFont#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonSetUseFontMethodInfo    ,
#endif
    fontDialogButtonSetUseFont              ,


-- ** setUseSize #method:setUseSize#

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonSetUseSizeMethodInfo    ,
#endif
    fontDialogButtonSetUseSize              ,




 -- * Properties


-- ** dialog #attr:dialog#
-- | The @GtkFontDialog@ that contains parameters for
-- the font chooser dialog.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonDialogPropertyInfo      ,
#endif
    constructFontDialogButtonDialog         ,
#if defined(ENABLE_OVERLOADING)
    fontDialogButtonDialog                  ,
#endif
    getFontDialogButtonDialog               ,
    setFontDialogButtonDialog               ,


-- ** fontDesc #attr:fontDesc#
-- | The selected font.
-- 
-- This property can be set to give the button its initial
-- font, and it will be updated to reflect the users choice
-- in the font chooser dialog.
-- 
-- Listen to @notify::font-desc@ to get informed about changes
-- to the buttons font.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonFontDescPropertyInfo    ,
#endif
    constructFontDialogButtonFontDesc       ,
#if defined(ENABLE_OVERLOADING)
    fontDialogButtonFontDesc                ,
#endif
    getFontDialogButtonFontDesc             ,
    setFontDialogButtonFontDesc             ,


-- ** fontFeatures #attr:fontFeatures#
-- | The selected font features.
-- 
-- This property will be updated to reflect the users choice
-- in the font chooser dialog.
-- 
-- Listen to @notify::font-features@ to get informed about changes
-- to the buttons font features.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonFontFeaturesPropertyInfo,
#endif
    clearFontDialogButtonFontFeatures       ,
    constructFontDialogButtonFontFeatures   ,
#if defined(ENABLE_OVERLOADING)
    fontDialogButtonFontFeatures            ,
#endif
    getFontDialogButtonFontFeatures         ,
    setFontDialogButtonFontFeatures         ,


-- ** language #attr:language#
-- | The selected language for font features.
-- 
-- This property will be updated to reflect the users choice
-- in the font chooser dialog.
-- 
-- Listen to @notify::language@ to get informed about changes
-- to the buttons language.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonLanguagePropertyInfo    ,
#endif
    clearFontDialogButtonLanguage           ,
    constructFontDialogButtonLanguage       ,
#if defined(ENABLE_OVERLOADING)
    fontDialogButtonLanguage                ,
#endif
    getFontDialogButtonLanguage             ,
    setFontDialogButtonLanguage             ,


-- ** level #attr:level#
-- | The level of detail for the font chooser dialog.

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonLevelPropertyInfo       ,
#endif
    constructFontDialogButtonLevel          ,
#if defined(ENABLE_OVERLOADING)
    fontDialogButtonLevel                   ,
#endif
    getFontDialogButtonLevel                ,
    setFontDialogButtonLevel                ,


-- ** useFont #attr:useFont#
-- | Whether the buttons label will be drawn in the selected font.

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonUseFontPropertyInfo     ,
#endif
    constructFontDialogButtonUseFont        ,
#if defined(ENABLE_OVERLOADING)
    fontDialogButtonUseFont                 ,
#endif
    getFontDialogButtonUseFont              ,
    setFontDialogButtonUseFont              ,


-- ** useSize #attr:useSize#
-- | Whether the buttons label will use the selected font size.

#if defined(ENABLE_OVERLOADING)
    FontDialogButtonUseSizePropertyInfo     ,
#endif
    constructFontDialogButtonUseSize        ,
#if defined(ENABLE_OVERLOADING)
    fontDialogButtonUseSize                 ,
#endif
    getFontDialogButtonUseSize              ,
    setFontDialogButtonUseSize              ,




 -- * Signals


-- ** activate #signal:activate#

    FontDialogButtonActivateCallback        ,
#if defined(ENABLE_OVERLOADING)
    FontDialogButtonActivateSignalInfo      ,
#endif
    afterFontDialogButtonActivate           ,
    onFontDialogButtonActivate              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Objects.FontDialog as Gtk.FontDialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontFace as Pango.FontFace
import qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import qualified GI.Pango.Structs.Language as Pango.Language

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.FontDialog as Gtk.FontDialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import qualified GI.Pango.Structs.Language as Pango.Language

#endif

-- | Memory-managed wrapper type.
newtype FontDialogButton = FontDialogButton (SP.ManagedPtr FontDialogButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype FontDialogButton where
    toManagedPtr (FontDialogButton p) = p

foreign import ccall "gtk_font_dialog_button_get_type"
    c_gtk_font_dialog_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject FontDialogButton where
    glibType = c_gtk_font_dialog_button_get_type

instance B.Types.GObject FontDialogButton

-- | Type class for types which can be safely cast to `FontDialogButton`, for instance with `toFontDialogButton`.
class (SP.GObject o, O.IsDescendantOf FontDialogButton o) => IsFontDialogButton o
instance (SP.GObject o, O.IsDescendantOf FontDialogButton o) => IsFontDialogButton o

instance O.HasParentTypes FontDialogButton
type instance O.ParentTypes FontDialogButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `FontDialogButton`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFontDialogButton :: (MIO.MonadIO m, IsFontDialogButton o) => o -> m FontDialogButton
toFontDialogButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo FontDialogButton

-- | Convert 'FontDialogButton' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FontDialogButton) where
    gvalueGType_ = c_gtk_font_dialog_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FontDialogButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FontDialogButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FontDialogButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFontDialogButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFontDialogButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveFontDialogButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveFontDialogButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveFontDialogButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveFontDialogButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveFontDialogButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveFontDialogButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveFontDialogButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveFontDialogButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveFontDialogButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveFontDialogButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFontDialogButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFontDialogButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveFontDialogButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveFontDialogButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveFontDialogButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveFontDialogButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveFontDialogButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveFontDialogButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveFontDialogButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveFontDialogButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveFontDialogButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveFontDialogButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveFontDialogButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFontDialogButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFontDialogButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFontDialogButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveFontDialogButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveFontDialogButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveFontDialogButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveFontDialogButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveFontDialogButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveFontDialogButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveFontDialogButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveFontDialogButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveFontDialogButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveFontDialogButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveFontDialogButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveFontDialogButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveFontDialogButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFontDialogButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveFontDialogButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveFontDialogButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveFontDialogButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveFontDialogButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveFontDialogButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveFontDialogButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveFontDialogButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveFontDialogButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFontDialogButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFontDialogButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveFontDialogButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveFontDialogButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveFontDialogButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveFontDialogButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveFontDialogButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveFontDialogButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveFontDialogButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFontDialogButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFontDialogButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveFontDialogButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveFontDialogButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveFontDialogButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveFontDialogButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveFontDialogButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveFontDialogButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveFontDialogButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFontDialogButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveFontDialogButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveFontDialogButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveFontDialogButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveFontDialogButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFontDialogButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFontDialogButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFontDialogButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveFontDialogButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveFontDialogButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveFontDialogButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveFontDialogButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveFontDialogButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFontDialogButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveFontDialogButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveFontDialogButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveFontDialogButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveFontDialogButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveFontDialogButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveFontDialogButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFontDialogButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveFontDialogButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveFontDialogButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveFontDialogButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveFontDialogButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveFontDialogButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveFontDialogButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveFontDialogButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveFontDialogButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveFontDialogButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveFontDialogButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveFontDialogButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveFontDialogButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveFontDialogButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveFontDialogButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveFontDialogButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveFontDialogButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveFontDialogButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveFontDialogButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveFontDialogButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFontDialogButtonMethod "getDialog" o = FontDialogButtonGetDialogMethodInfo
    ResolveFontDialogButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveFontDialogButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveFontDialogButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveFontDialogButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveFontDialogButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveFontDialogButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveFontDialogButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveFontDialogButtonMethod "getFontDesc" o = FontDialogButtonGetFontDescMethodInfo
    ResolveFontDialogButtonMethod "getFontFeatures" o = FontDialogButtonGetFontFeaturesMethodInfo
    ResolveFontDialogButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveFontDialogButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveFontDialogButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveFontDialogButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveFontDialogButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveFontDialogButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveFontDialogButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveFontDialogButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveFontDialogButtonMethod "getLanguage" o = FontDialogButtonGetLanguageMethodInfo
    ResolveFontDialogButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveFontDialogButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveFontDialogButtonMethod "getLevel" o = FontDialogButtonGetLevelMethodInfo
    ResolveFontDialogButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveFontDialogButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveFontDialogButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveFontDialogButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveFontDialogButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveFontDialogButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveFontDialogButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveFontDialogButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveFontDialogButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveFontDialogButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveFontDialogButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveFontDialogButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveFontDialogButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveFontDialogButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveFontDialogButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveFontDialogButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveFontDialogButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveFontDialogButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveFontDialogButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFontDialogButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFontDialogButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveFontDialogButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveFontDialogButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveFontDialogButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveFontDialogButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveFontDialogButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveFontDialogButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveFontDialogButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveFontDialogButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveFontDialogButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveFontDialogButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveFontDialogButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveFontDialogButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveFontDialogButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveFontDialogButtonMethod "getUseFont" o = FontDialogButtonGetUseFontMethodInfo
    ResolveFontDialogButtonMethod "getUseSize" o = FontDialogButtonGetUseSizeMethodInfo
    ResolveFontDialogButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveFontDialogButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveFontDialogButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveFontDialogButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveFontDialogButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveFontDialogButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveFontDialogButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveFontDialogButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveFontDialogButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveFontDialogButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveFontDialogButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveFontDialogButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveFontDialogButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFontDialogButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFontDialogButtonMethod "setDialog" o = FontDialogButtonSetDialogMethodInfo
    ResolveFontDialogButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveFontDialogButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveFontDialogButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveFontDialogButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveFontDialogButtonMethod "setFontDesc" o = FontDialogButtonSetFontDescMethodInfo
    ResolveFontDialogButtonMethod "setFontFeatures" o = FontDialogButtonSetFontFeaturesMethodInfo
    ResolveFontDialogButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveFontDialogButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveFontDialogButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveFontDialogButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveFontDialogButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveFontDialogButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveFontDialogButtonMethod "setLanguage" o = FontDialogButtonSetLanguageMethodInfo
    ResolveFontDialogButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveFontDialogButtonMethod "setLevel" o = FontDialogButtonSetLevelMethodInfo
    ResolveFontDialogButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveFontDialogButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveFontDialogButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveFontDialogButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveFontDialogButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveFontDialogButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveFontDialogButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveFontDialogButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveFontDialogButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveFontDialogButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFontDialogButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveFontDialogButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveFontDialogButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveFontDialogButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveFontDialogButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveFontDialogButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveFontDialogButtonMethod "setUseFont" o = FontDialogButtonSetUseFontMethodInfo
    ResolveFontDialogButtonMethod "setUseSize" o = FontDialogButtonSetUseSizeMethodInfo
    ResolveFontDialogButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveFontDialogButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveFontDialogButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveFontDialogButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveFontDialogButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFontDialogButtonMethod t FontDialogButton, O.OverloadedMethod info FontDialogButton p) => OL.IsLabel t (FontDialogButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFontDialogButtonMethod t FontDialogButton, O.OverloadedMethod info FontDialogButton p, R.HasField t FontDialogButton p) => R.HasField t FontDialogButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFontDialogButtonMethod t FontDialogButton, O.OverloadedMethodInfo info FontDialogButton) => OL.IsLabel t (O.MethodProxy info FontDialogButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal FontDialogButton::activate
-- | Emitted when the font dialog button is activated.
-- 
-- The @::activate@ signal on @GtkFontDialogButton@ is an action signal
-- and emitting it causes the button to pop up its dialog.
-- 
-- /Since: 4.14/
type FontDialogButtonActivateCallback =
    IO ()

type C_FontDialogButtonActivateCallback =
    Ptr FontDialogButton ->                 -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FontDialogButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_FontDialogButtonActivateCallback :: C_FontDialogButtonActivateCallback -> IO (FunPtr C_FontDialogButtonActivateCallback)

wrap_FontDialogButtonActivateCallback :: 
    GObject a => (a -> FontDialogButtonActivateCallback) ->
    C_FontDialogButtonActivateCallback
wrap_FontDialogButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fontDialogButton #activate callback
-- @
-- 
-- 
onFontDialogButtonActivate :: (IsFontDialogButton a, MonadIO m) => a -> ((?self :: a) => FontDialogButtonActivateCallback) -> m SignalHandlerId
onFontDialogButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FontDialogButtonActivateCallback wrapped
    wrapped'' <- mk_FontDialogButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fontDialogButton #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFontDialogButtonActivate :: (IsFontDialogButton a, MonadIO m) => a -> ((?self :: a) => FontDialogButtonActivateCallback) -> m SignalHandlerId
afterFontDialogButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FontDialogButtonActivateCallback wrapped
    wrapped'' <- mk_FontDialogButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FontDialogButtonActivateSignalInfo
instance SignalInfo FontDialogButtonActivateSignalInfo where
    type HaskellCallbackType FontDialogButtonActivateSignalInfo = FontDialogButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FontDialogButtonActivateCallback cb
        cb'' <- mk_FontDialogButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:signal:activate"})

#endif

-- VVV Prop "dialog"
   -- Type: TInterface (Name {namespace = "Gtk", name = "FontDialog"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@dialog@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontDialogButton #dialog
-- @
getFontDialogButtonDialog :: (MonadIO m, IsFontDialogButton o) => o -> m (Maybe Gtk.FontDialog.FontDialog)
getFontDialogButtonDialog obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "dialog" Gtk.FontDialog.FontDialog

-- | Set the value of the “@dialog@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontDialogButton [ #dialog 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontDialogButtonDialog :: (MonadIO m, IsFontDialogButton o, Gtk.FontDialog.IsFontDialog a) => o -> a -> m ()
setFontDialogButtonDialog obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "dialog" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@dialog@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontDialogButtonDialog :: (IsFontDialogButton o, MIO.MonadIO m, Gtk.FontDialog.IsFontDialog a) => a -> m (GValueConstruct o)
constructFontDialogButtonDialog val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "dialog" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonDialogPropertyInfo
instance AttrInfo FontDialogButtonDialogPropertyInfo where
    type AttrAllowedOps FontDialogButtonDialogPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontDialogButtonDialogPropertyInfo = IsFontDialogButton
    type AttrSetTypeConstraint FontDialogButtonDialogPropertyInfo = Gtk.FontDialog.IsFontDialog
    type AttrTransferTypeConstraint FontDialogButtonDialogPropertyInfo = Gtk.FontDialog.IsFontDialog
    type AttrTransferType FontDialogButtonDialogPropertyInfo = Gtk.FontDialog.FontDialog
    type AttrGetType FontDialogButtonDialogPropertyInfo = (Maybe Gtk.FontDialog.FontDialog)
    type AttrLabel FontDialogButtonDialogPropertyInfo = "dialog"
    type AttrOrigin FontDialogButtonDialogPropertyInfo = FontDialogButton
    attrGet = getFontDialogButtonDialog
    attrSet = setFontDialogButtonDialog
    attrTransfer _ v = do
        unsafeCastTo Gtk.FontDialog.FontDialog v
    attrConstruct = constructFontDialogButtonDialog
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.dialog"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:attr:dialog"
        })
#endif

-- VVV Prop "font-desc"
   -- Type: TInterface (Name {namespace = "Pango", name = "FontDescription"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@font-desc@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontDialogButton #fontDesc
-- @
getFontDialogButtonFontDesc :: (MonadIO m, IsFontDialogButton o) => o -> m (Maybe Pango.FontDescription.FontDescription)
getFontDialogButtonFontDesc obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "font-desc" Pango.FontDescription.FontDescription

-- | Set the value of the “@font-desc@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontDialogButton [ #fontDesc 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontDialogButtonFontDesc :: (MonadIO m, IsFontDialogButton o) => o -> Pango.FontDescription.FontDescription -> m ()
setFontDialogButtonFontDesc obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "font-desc" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@font-desc@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontDialogButtonFontDesc :: (IsFontDialogButton o, MIO.MonadIO m) => Pango.FontDescription.FontDescription -> m (GValueConstruct o)
constructFontDialogButtonFontDesc val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "font-desc" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonFontDescPropertyInfo
instance AttrInfo FontDialogButtonFontDescPropertyInfo where
    type AttrAllowedOps FontDialogButtonFontDescPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontDialogButtonFontDescPropertyInfo = IsFontDialogButton
    type AttrSetTypeConstraint FontDialogButtonFontDescPropertyInfo = (~) Pango.FontDescription.FontDescription
    type AttrTransferTypeConstraint FontDialogButtonFontDescPropertyInfo = (~) Pango.FontDescription.FontDescription
    type AttrTransferType FontDialogButtonFontDescPropertyInfo = Pango.FontDescription.FontDescription
    type AttrGetType FontDialogButtonFontDescPropertyInfo = (Maybe Pango.FontDescription.FontDescription)
    type AttrLabel FontDialogButtonFontDescPropertyInfo = "font-desc"
    type AttrOrigin FontDialogButtonFontDescPropertyInfo = FontDialogButton
    attrGet = getFontDialogButtonFontDesc
    attrSet = setFontDialogButtonFontDesc
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontDialogButtonFontDesc
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDesc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:attr:fontDesc"
        })
#endif

-- VVV Prop "font-features"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@font-features@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontDialogButton #fontFeatures
-- @
getFontDialogButtonFontFeatures :: (MonadIO m, IsFontDialogButton o) => o -> m (Maybe T.Text)
getFontDialogButtonFontFeatures obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "font-features"

-- | Set the value of the “@font-features@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontDialogButton [ #fontFeatures 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontDialogButtonFontFeatures :: (MonadIO m, IsFontDialogButton o) => o -> T.Text -> m ()
setFontDialogButtonFontFeatures obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "font-features" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@font-features@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontDialogButtonFontFeatures :: (IsFontDialogButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructFontDialogButtonFontFeatures val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "font-features" (P.Just val)

-- | Set the value of the “@font-features@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #fontFeatures
-- @
clearFontDialogButtonFontFeatures :: (MonadIO m, IsFontDialogButton o) => o -> m ()
clearFontDialogButtonFontFeatures obj = liftIO $ B.Properties.setObjectPropertyString obj "font-features" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonFontFeaturesPropertyInfo
instance AttrInfo FontDialogButtonFontFeaturesPropertyInfo where
    type AttrAllowedOps FontDialogButtonFontFeaturesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FontDialogButtonFontFeaturesPropertyInfo = IsFontDialogButton
    type AttrSetTypeConstraint FontDialogButtonFontFeaturesPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint FontDialogButtonFontFeaturesPropertyInfo = (~) T.Text
    type AttrTransferType FontDialogButtonFontFeaturesPropertyInfo = T.Text
    type AttrGetType FontDialogButtonFontFeaturesPropertyInfo = (Maybe T.Text)
    type AttrLabel FontDialogButtonFontFeaturesPropertyInfo = "font-features"
    type AttrOrigin FontDialogButtonFontFeaturesPropertyInfo = FontDialogButton
    attrGet = getFontDialogButtonFontFeatures
    attrSet = setFontDialogButtonFontFeatures
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontDialogButtonFontFeatures
    attrClear = clearFontDialogButtonFontFeatures
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontFeatures"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:attr:fontFeatures"
        })
#endif

-- VVV Prop "language"
   -- Type: TInterface (Name {namespace = "Pango", name = "Language"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@language@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontDialogButton #language
-- @
getFontDialogButtonLanguage :: (MonadIO m, IsFontDialogButton o) => o -> m (Maybe Pango.Language.Language)
getFontDialogButtonLanguage obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "language" Pango.Language.Language

-- | Set the value of the “@language@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontDialogButton [ #language 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontDialogButtonLanguage :: (MonadIO m, IsFontDialogButton o) => o -> Pango.Language.Language -> m ()
setFontDialogButtonLanguage obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "language" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@language@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontDialogButtonLanguage :: (IsFontDialogButton o, MIO.MonadIO m) => Pango.Language.Language -> m (GValueConstruct o)
constructFontDialogButtonLanguage val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "language" (P.Just val)

-- | Set the value of the “@language@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #language
-- @
clearFontDialogButtonLanguage :: (MonadIO m, IsFontDialogButton o) => o -> m ()
clearFontDialogButtonLanguage obj = liftIO $ B.Properties.setObjectPropertyBoxed obj "language" (Nothing :: Maybe Pango.Language.Language)

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonLanguagePropertyInfo
instance AttrInfo FontDialogButtonLanguagePropertyInfo where
    type AttrAllowedOps FontDialogButtonLanguagePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FontDialogButtonLanguagePropertyInfo = IsFontDialogButton
    type AttrSetTypeConstraint FontDialogButtonLanguagePropertyInfo = (~) Pango.Language.Language
    type AttrTransferTypeConstraint FontDialogButtonLanguagePropertyInfo = (~) Pango.Language.Language
    type AttrTransferType FontDialogButtonLanguagePropertyInfo = Pango.Language.Language
    type AttrGetType FontDialogButtonLanguagePropertyInfo = (Maybe Pango.Language.Language)
    type AttrLabel FontDialogButtonLanguagePropertyInfo = "language"
    type AttrOrigin FontDialogButtonLanguagePropertyInfo = FontDialogButton
    attrGet = getFontDialogButtonLanguage
    attrSet = setFontDialogButtonLanguage
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontDialogButtonLanguage
    attrClear = clearFontDialogButtonLanguage
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.language"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:attr:language"
        })
#endif

-- VVV Prop "level"
   -- Type: TInterface (Name {namespace = "Gtk", name = "FontLevel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontDialogButton #level
-- @
getFontDialogButtonLevel :: (MonadIO m, IsFontDialogButton o) => o -> m Gtk.Enums.FontLevel
getFontDialogButtonLevel obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "level"

-- | Set the value of the “@level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontDialogButton [ #level 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontDialogButtonLevel :: (MonadIO m, IsFontDialogButton o) => o -> Gtk.Enums.FontLevel -> m ()
setFontDialogButtonLevel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "level" val

-- | Construct a `GValueConstruct` with valid value for the “@level@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontDialogButtonLevel :: (IsFontDialogButton o, MIO.MonadIO m) => Gtk.Enums.FontLevel -> m (GValueConstruct o)
constructFontDialogButtonLevel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "level" val

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonLevelPropertyInfo
instance AttrInfo FontDialogButtonLevelPropertyInfo where
    type AttrAllowedOps FontDialogButtonLevelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontDialogButtonLevelPropertyInfo = IsFontDialogButton
    type AttrSetTypeConstraint FontDialogButtonLevelPropertyInfo = (~) Gtk.Enums.FontLevel
    type AttrTransferTypeConstraint FontDialogButtonLevelPropertyInfo = (~) Gtk.Enums.FontLevel
    type AttrTransferType FontDialogButtonLevelPropertyInfo = Gtk.Enums.FontLevel
    type AttrGetType FontDialogButtonLevelPropertyInfo = Gtk.Enums.FontLevel
    type AttrLabel FontDialogButtonLevelPropertyInfo = "level"
    type AttrOrigin FontDialogButtonLevelPropertyInfo = FontDialogButton
    attrGet = getFontDialogButtonLevel
    attrSet = setFontDialogButtonLevel
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontDialogButtonLevel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.level"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:attr:level"
        })
#endif

-- VVV Prop "use-font"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-font@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontDialogButton #useFont
-- @
getFontDialogButtonUseFont :: (MonadIO m, IsFontDialogButton o) => o -> m Bool
getFontDialogButtonUseFont obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-font"

-- | Set the value of the “@use-font@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontDialogButton [ #useFont 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontDialogButtonUseFont :: (MonadIO m, IsFontDialogButton o) => o -> Bool -> m ()
setFontDialogButtonUseFont obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-font" val

-- | Construct a `GValueConstruct` with valid value for the “@use-font@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontDialogButtonUseFont :: (IsFontDialogButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFontDialogButtonUseFont val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-font" val

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonUseFontPropertyInfo
instance AttrInfo FontDialogButtonUseFontPropertyInfo where
    type AttrAllowedOps FontDialogButtonUseFontPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontDialogButtonUseFontPropertyInfo = IsFontDialogButton
    type AttrSetTypeConstraint FontDialogButtonUseFontPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FontDialogButtonUseFontPropertyInfo = (~) Bool
    type AttrTransferType FontDialogButtonUseFontPropertyInfo = Bool
    type AttrGetType FontDialogButtonUseFontPropertyInfo = Bool
    type AttrLabel FontDialogButtonUseFontPropertyInfo = "use-font"
    type AttrOrigin FontDialogButtonUseFontPropertyInfo = FontDialogButton
    attrGet = getFontDialogButtonUseFont
    attrSet = setFontDialogButtonUseFont
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontDialogButtonUseFont
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.useFont"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:attr:useFont"
        })
#endif

-- VVV Prop "use-size"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fontDialogButton #useSize
-- @
getFontDialogButtonUseSize :: (MonadIO m, IsFontDialogButton o) => o -> m Bool
getFontDialogButtonUseSize obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-size"

-- | Set the value of the “@use-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fontDialogButton [ #useSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setFontDialogButtonUseSize :: (MonadIO m, IsFontDialogButton o) => o -> Bool -> m ()
setFontDialogButtonUseSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-size" val

-- | Construct a `GValueConstruct` with valid value for the “@use-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFontDialogButtonUseSize :: (IsFontDialogButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFontDialogButtonUseSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-size" val

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonUseSizePropertyInfo
instance AttrInfo FontDialogButtonUseSizePropertyInfo where
    type AttrAllowedOps FontDialogButtonUseSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FontDialogButtonUseSizePropertyInfo = IsFontDialogButton
    type AttrSetTypeConstraint FontDialogButtonUseSizePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FontDialogButtonUseSizePropertyInfo = (~) Bool
    type AttrTransferType FontDialogButtonUseSizePropertyInfo = Bool
    type AttrGetType FontDialogButtonUseSizePropertyInfo = Bool
    type AttrLabel FontDialogButtonUseSizePropertyInfo = "use-size"
    type AttrOrigin FontDialogButtonUseSizePropertyInfo = FontDialogButton
    attrGet = getFontDialogButtonUseSize
    attrSet = setFontDialogButtonUseSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructFontDialogButtonUseSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.useSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#g:attr:useSize"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FontDialogButton
type instance O.AttributeList FontDialogButton = FontDialogButtonAttributeList
type FontDialogButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("dialog", FontDialogButtonDialogPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fontDesc", FontDialogButtonFontDescPropertyInfo), '("fontFeatures", FontDialogButtonFontFeaturesPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("language", FontDialogButtonLanguagePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("level", FontDialogButtonLevelPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useFont", FontDialogButtonUseFontPropertyInfo), '("useSize", FontDialogButtonUseSizePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fontDialogButtonDialog :: AttrLabelProxy "dialog"
fontDialogButtonDialog = AttrLabelProxy

fontDialogButtonFontDesc :: AttrLabelProxy "fontDesc"
fontDialogButtonFontDesc = AttrLabelProxy

fontDialogButtonFontFeatures :: AttrLabelProxy "fontFeatures"
fontDialogButtonFontFeatures = AttrLabelProxy

fontDialogButtonLanguage :: AttrLabelProxy "language"
fontDialogButtonLanguage = AttrLabelProxy

fontDialogButtonLevel :: AttrLabelProxy "level"
fontDialogButtonLevel = AttrLabelProxy

fontDialogButtonUseFont :: AttrLabelProxy "useFont"
fontDialogButtonUseFont = AttrLabelProxy

fontDialogButtonUseSize :: AttrLabelProxy "useSize"
fontDialogButtonUseSize = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FontDialogButton = FontDialogButtonSignalList
type FontDialogButtonSignalList = ('[ '("activate", FontDialogButtonActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FontDialogButton::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialog" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkFontDialog` to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "FontDialogButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_new" gtk_font_dialog_button_new :: 
    Ptr Gtk.FontDialog.FontDialog ->        -- dialog : TInterface (Name {namespace = "Gtk", name = "FontDialog"})
    IO (Ptr FontDialogButton)

-- | Creates a new @GtkFontDialogButton@ with the
-- given @GtkFontDialog@.
-- 
-- You can pass @NULL@ to this function and set a @GtkFontDialog@
-- later. The button will be insensitive until that happens.
-- 
-- /Since: 4.10/
fontDialogButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.FontDialog.IsFontDialog a) =>
    Maybe (a)
    -- ^ /@dialog@/: the @GtkFontDialog@ to use
    -> m FontDialogButton
    -- ^ __Returns:__ the new @GtkFontDialogButton@
fontDialogButtonNew dialog = liftIO $ do
    maybeDialog <- case dialog of
        Nothing -> return FP.nullPtr
        Just jDialog -> do
            jDialog' <- B.ManagedPtr.disownObject jDialog
            return jDialog'
    result <- gtk_font_dialog_button_new maybeDialog
    checkUnexpectedReturnNULL "fontDialogButtonNew" result
    result' <- (newObject FontDialogButton) result
    whenJust dialog touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FontDialogButton::get_dialog
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "FontDialog" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_get_dialog" gtk_font_dialog_button_get_dialog :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    IO (Ptr Gtk.FontDialog.FontDialog)

-- | Returns the @GtkFontDialog@ of /@self@/.
-- 
-- /Since: 4.10/
fontDialogButtonGetDialog ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> m (Maybe Gtk.FontDialog.FontDialog)
    -- ^ __Returns:__ the @GtkFontDialog@
fontDialogButtonGetDialog self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_font_dialog_button_get_dialog self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.FontDialog.FontDialog) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonGetDialogMethodInfo
instance (signature ~ (m (Maybe Gtk.FontDialog.FontDialog)), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonGetDialogMethodInfo a signature where
    overloadedMethod = fontDialogButtonGetDialog

instance O.OverloadedMethodInfo FontDialogButtonGetDialogMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetDialog",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonGetDialog"
        })


#endif

-- method FontDialogButton::get_font_desc
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Pango" , name = "FontDescription" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_get_font_desc" gtk_font_dialog_button_get_font_desc :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    IO (Ptr Pango.FontDescription.FontDescription)

-- | Returns the font of the button.
-- 
-- This function is what should be used to obtain
-- the font that was chosen by the user. To get
-- informed about changes, listen to \"notify[fontDesc](#g:signal:fontDesc)\".
-- 
-- /Since: 4.10/
fontDialogButtonGetFontDesc ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> m (Maybe Pango.FontDescription.FontDescription)
    -- ^ __Returns:__ the font
fontDialogButtonGetFontDesc self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_font_dialog_button_get_font_desc self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.FontDescription.FontDescription) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonGetFontDescMethodInfo
instance (signature ~ (m (Maybe Pango.FontDescription.FontDescription)), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonGetFontDescMethodInfo a signature where
    overloadedMethod = fontDialogButtonGetFontDesc

instance O.OverloadedMethodInfo FontDialogButtonGetFontDescMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetFontDesc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonGetFontDesc"
        })


#endif

-- method FontDialogButton::get_font_features
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_get_font_features" gtk_font_dialog_button_get_font_features :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    IO CString

-- | Returns the font features of the button.
-- 
-- This function is what should be used to obtain the font features
-- that were chosen by the user. To get informed about changes, listen
-- to \"notify[fontFeatures](#g:signal:fontFeatures)\".
-- 
-- Note that the button will only let users choose font features
-- if [FontDialogButton:level]("GI.Gtk.Objects.FontDialogButton#g:attr:level") is set to
-- @GTK_FONT_LEVEL_FEATURES@.
-- 
-- /Since: 4.10/
fontDialogButtonGetFontFeatures ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the font features
fontDialogButtonGetFontFeatures self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_font_dialog_button_get_font_features self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonGetFontFeaturesMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonGetFontFeaturesMethodInfo a signature where
    overloadedMethod = fontDialogButtonGetFontFeatures

instance O.OverloadedMethodInfo FontDialogButtonGetFontFeaturesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetFontFeatures",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonGetFontFeatures"
        })


#endif

-- method FontDialogButton::get_language
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Language" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_get_language" gtk_font_dialog_button_get_language :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    IO (Ptr Pango.Language.Language)

-- | Returns the language that is used for font features.
-- 
-- /Since: 4.10/
fontDialogButtonGetLanguage ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> m (Maybe Pango.Language.Language)
    -- ^ __Returns:__ the language
fontDialogButtonGetLanguage self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_font_dialog_button_get_language self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Pango.Language.Language) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonGetLanguageMethodInfo
instance (signature ~ (m (Maybe Pango.Language.Language)), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonGetLanguageMethodInfo a signature where
    overloadedMethod = fontDialogButtonGetLanguage

instance O.OverloadedMethodInfo FontDialogButtonGetLanguageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetLanguage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonGetLanguage"
        })


#endif

-- method FontDialogButton::get_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "FontLevel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_get_level" gtk_font_dialog_button_get_level :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    IO CUInt

-- | Returns the level of detail at which this dialog
-- lets the user select fonts.
-- 
-- /Since: 4.10/
fontDialogButtonGetLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a \`GtkFontDialogButton
    -> m Gtk.Enums.FontLevel
    -- ^ __Returns:__ the level of detail
fontDialogButtonGetLevel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_font_dialog_button_get_level self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonGetLevelMethodInfo
instance (signature ~ (m Gtk.Enums.FontLevel), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonGetLevelMethodInfo a signature where
    overloadedMethod = fontDialogButtonGetLevel

instance O.OverloadedMethodInfo FontDialogButtonGetLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonGetLevel"
        })


#endif

-- method FontDialogButton::get_use_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_get_use_font" gtk_font_dialog_button_get_use_font :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    IO CInt

-- | Returns whether the selected font is used in the label.
-- 
-- /Since: 4.10/
fontDialogButtonGetUseFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> m Bool
    -- ^ __Returns:__ whether the selected font is used in the label
fontDialogButtonGetUseFont self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_font_dialog_button_get_use_font self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonGetUseFontMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonGetUseFontMethodInfo a signature where
    overloadedMethod = fontDialogButtonGetUseFont

instance O.OverloadedMethodInfo FontDialogButtonGetUseFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetUseFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonGetUseFont"
        })


#endif

-- method FontDialogButton::get_use_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_get_use_size" gtk_font_dialog_button_get_use_size :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    IO CInt

-- | Returns whether the selected font size is used in the label.
-- 
-- /Since: 4.10/
fontDialogButtonGetUseSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> m Bool
    -- ^ __Returns:__ whether the selected font size is used in the label
fontDialogButtonGetUseSize self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_font_dialog_button_get_use_size self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonGetUseSizeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonGetUseSizeMethodInfo a signature where
    overloadedMethod = fontDialogButtonGetUseSize

instance O.OverloadedMethodInfo FontDialogButtonGetUseSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonGetUseSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonGetUseSize"
        })


#endif

-- method FontDialogButton::set_dialog
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new `GtkFontDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_set_dialog" gtk_font_dialog_button_set_dialog :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    Ptr Gtk.FontDialog.FontDialog ->        -- dialog : TInterface (Name {namespace = "Gtk", name = "FontDialog"})
    IO ()

-- | Sets a @GtkFontDialog@ object to use for
-- creating the font chooser dialog that is
-- presented when the user clicks the button.
-- 
-- /Since: 4.10/
fontDialogButtonSetDialog ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a, Gtk.FontDialog.IsFontDialog b) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> b
    -- ^ /@dialog@/: the new @GtkFontDialog@
    -> m ()
fontDialogButtonSetDialog self dialog = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    dialog' <- unsafeManagedPtrCastPtr dialog
    gtk_font_dialog_button_set_dialog self' dialog'
    touchManagedPtr self
    touchManagedPtr dialog
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonSetDialogMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFontDialogButton a, Gtk.FontDialog.IsFontDialog b) => O.OverloadedMethod FontDialogButtonSetDialogMethodInfo a signature where
    overloadedMethod = fontDialogButtonSetDialog

instance O.OverloadedMethodInfo FontDialogButtonSetDialogMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonSetDialog",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonSetDialog"
        })


#endif

-- method FontDialogButton::set_font_desc
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new font" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_set_font_desc" gtk_font_dialog_button_set_font_desc :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    Ptr Pango.FontDescription.FontDescription -> -- font_desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO ()

-- | Sets the font of the button.
-- 
-- /Since: 4.10/
fontDialogButtonSetFontDesc ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> Pango.FontDescription.FontDescription
    -- ^ /@fontDesc@/: the new font
    -> m ()
fontDialogButtonSetFontDesc self fontDesc = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    fontDesc' <- unsafeManagedPtrGetPtr fontDesc
    gtk_font_dialog_button_set_font_desc self' fontDesc'
    touchManagedPtr self
    touchManagedPtr fontDesc
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonSetFontDescMethodInfo
instance (signature ~ (Pango.FontDescription.FontDescription -> m ()), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonSetFontDescMethodInfo a signature where
    overloadedMethod = fontDialogButtonSetFontDesc

instance O.OverloadedMethodInfo FontDialogButtonSetFontDescMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonSetFontDesc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonSetFontDesc"
        })


#endif

-- method FontDialogButton::set_font_features
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_features"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the font features" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_set_font_features" gtk_font_dialog_button_set_font_features :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    CString ->                              -- font_features : TBasicType TUTF8
    IO ()

-- | Sets the font features of the button.
-- 
-- /Since: 4.10/
fontDialogButtonSetFontFeatures ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> Maybe (T.Text)
    -- ^ /@fontFeatures@/: the font features
    -> m ()
fontDialogButtonSetFontFeatures self fontFeatures = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFontFeatures <- case fontFeatures of
        Nothing -> return FP.nullPtr
        Just jFontFeatures -> do
            jFontFeatures' <- textToCString jFontFeatures
            return jFontFeatures'
    gtk_font_dialog_button_set_font_features self' maybeFontFeatures
    touchManagedPtr self
    freeMem maybeFontFeatures
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonSetFontFeaturesMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonSetFontFeaturesMethodInfo a signature where
    overloadedMethod = fontDialogButtonSetFontFeatures

instance O.OverloadedMethodInfo FontDialogButtonSetFontFeaturesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonSetFontFeatures",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonSetFontFeatures"
        })


#endif

-- method FontDialogButton::set_language
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new language" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_set_language" gtk_font_dialog_button_set_language :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    Ptr Pango.Language.Language ->          -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    IO ()

-- | Sets the language to use for font features.
-- 
-- /Since: 4.10/
fontDialogButtonSetLanguage ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> Maybe (Pango.Language.Language)
    -- ^ /@language@/: the new language
    -> m ()
fontDialogButtonSetLanguage self language = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeLanguage <- case language of
        Nothing -> return FP.nullPtr
        Just jLanguage -> do
            jLanguage' <- unsafeManagedPtrGetPtr jLanguage
            return jLanguage'
    gtk_font_dialog_button_set_language self' maybeLanguage
    touchManagedPtr self
    whenJust language touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonSetLanguageMethodInfo
instance (signature ~ (Maybe (Pango.Language.Language) -> m ()), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonSetLanguageMethodInfo a signature where
    overloadedMethod = fontDialogButtonSetLanguage

instance O.OverloadedMethodInfo FontDialogButtonSetLanguageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonSetLanguage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonSetLanguage"
        })


#endif

-- method FontDialogButton::set_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "level"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontLevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the level of detail"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_set_level" gtk_font_dialog_button_set_level :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    CUInt ->                                -- level : TInterface (Name {namespace = "Gtk", name = "FontLevel"})
    IO ()

-- | Sets the level of detail at which this dialog
-- lets the user select fonts.
-- 
-- /Since: 4.10/
fontDialogButtonSetLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> Gtk.Enums.FontLevel
    -- ^ /@level@/: the level of detail
    -> m ()
fontDialogButtonSetLevel self level = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let level' = (fromIntegral . fromEnum) level
    gtk_font_dialog_button_set_level self' level'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonSetLevelMethodInfo
instance (signature ~ (Gtk.Enums.FontLevel -> m ()), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonSetLevelMethodInfo a signature where
    overloadedMethod = fontDialogButtonSetLevel

instance O.OverloadedMethodInfo FontDialogButtonSetLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonSetLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonSetLevel"
        })


#endif

-- method FontDialogButton::set_use_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_font"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "If `TRUE`, font name will be written using\n  the chosen font"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_set_use_font" gtk_font_dialog_button_set_use_font :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    CInt ->                                 -- use_font : TBasicType TBoolean
    IO ()

-- | If /@useFont@/ is @TRUE@, the font name will be written
-- using the selected font.
-- 
-- /Since: 4.10/
fontDialogButtonSetUseFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> Bool
    -- ^ /@useFont@/: If @TRUE@, font name will be written using
    --   the chosen font
    -> m ()
fontDialogButtonSetUseFont self useFont = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let useFont' = (P.fromIntegral . P.fromEnum) useFont
    gtk_font_dialog_button_set_use_font self' useFont'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonSetUseFontMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonSetUseFontMethodInfo a signature where
    overloadedMethod = fontDialogButtonSetUseFont

instance O.OverloadedMethodInfo FontDialogButtonSetUseFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonSetUseFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonSetUseFont"
        })


#endif

-- method FontDialogButton::set_use_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FontDialogButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFontDialogButton`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_size"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "If `TRUE`, font name will be written using\n  the chosen font size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_font_dialog_button_set_use_size" gtk_font_dialog_button_set_use_size :: 
    Ptr FontDialogButton ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FontDialogButton"})
    CInt ->                                 -- use_size : TBasicType TBoolean
    IO ()

-- | If /@useSize@/ is @TRUE@, the font name will be written
-- using the selected font size.
-- 
-- /Since: 4.10/
fontDialogButtonSetUseSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsFontDialogButton a) =>
    a
    -- ^ /@self@/: a @GtkFontDialogButton@
    -> Bool
    -- ^ /@useSize@/: If @TRUE@, font name will be written using
    --   the chosen font size
    -> m ()
fontDialogButtonSetUseSize self useSize = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let useSize' = (P.fromIntegral . P.fromEnum) useSize
    gtk_font_dialog_button_set_use_size self' useSize'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data FontDialogButtonSetUseSizeMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFontDialogButton a) => O.OverloadedMethod FontDialogButtonSetUseSizeMethodInfo a signature where
    overloadedMethod = fontDialogButtonSetUseSize

instance O.OverloadedMethodInfo FontDialogButtonSetUseSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FontDialogButton.fontDialogButtonSetUseSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FontDialogButton.html#v:fontDialogButtonSetUseSize"
        })


#endif


