{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A list model that concatenates other list models.
-- 
-- @GtkFlattenListModel@ takes a list model containing list models, and flattens
-- it into a single model. Each list model becomes a section in the single model.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.FlattenListModel
    ( 

-- * Exported types
    FlattenListModel(..)                    ,
    IsFlattenListModel                      ,
    toFlattenListModel                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:method:sectionsChanged"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getModel]("GI.Gtk.Objects.FlattenListModel#g:method:getModel"), [getModelForItem]("GI.Gtk.Objects.FlattenListModel#g:method:getModelForItem"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSection]("GI.Gtk.Interfaces.SectionModel#g:method:getSection").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setModel]("GI.Gtk.Objects.FlattenListModel#g:method:setModel"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFlattenListModelMethod           ,
#endif

-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    FlattenListModelGetModelMethodInfo      ,
#endif
    flattenListModelGetModel                ,


-- ** getModelForItem #method:getModelForItem#

#if defined(ENABLE_OVERLOADING)
    FlattenListModelGetModelForItemMethodInfo,
#endif
    flattenListModelGetModelForItem         ,


-- ** new #method:new#

    flattenListModelNew                     ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    FlattenListModelSetModelMethodInfo      ,
#endif
    flattenListModelSetModel                ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    FlattenListModelItemTypePropertyInfo    ,
#endif
#if defined(ENABLE_OVERLOADING)
    flattenListModelItemType                ,
#endif
    getFlattenListModelItemType             ,


-- ** model #attr:model#
-- | The model being flattened.

#if defined(ENABLE_OVERLOADING)
    FlattenListModelModelPropertyInfo       ,
#endif
    clearFlattenListModelModel              ,
    constructFlattenListModelModel          ,
#if defined(ENABLE_OVERLOADING)
    flattenListModelModel                   ,
#endif
    getFlattenListModelModel                ,
    setFlattenListModelModel                ,


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    FlattenListModelNItemsPropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    flattenListModelNItems                  ,
#endif
    getFlattenListModelNItems               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel

#endif

-- | Memory-managed wrapper type.
newtype FlattenListModel = FlattenListModel (SP.ManagedPtr FlattenListModel)
    deriving (Eq)

instance SP.ManagedPtrNewtype FlattenListModel where
    toManagedPtr (FlattenListModel p) = p

foreign import ccall "gtk_flatten_list_model_get_type"
    c_gtk_flatten_list_model_get_type :: IO B.Types.GType

instance B.Types.TypedObject FlattenListModel where
    glibType = c_gtk_flatten_list_model_get_type

instance B.Types.GObject FlattenListModel

-- | Type class for types which can be safely cast to `FlattenListModel`, for instance with `toFlattenListModel`.
class (SP.GObject o, O.IsDescendantOf FlattenListModel o) => IsFlattenListModel o
instance (SP.GObject o, O.IsDescendantOf FlattenListModel o) => IsFlattenListModel o

instance O.HasParentTypes FlattenListModel
type instance O.ParentTypes FlattenListModel = '[GObject.Object.Object, Gio.ListModel.ListModel, Gtk.SectionModel.SectionModel]

-- | Cast to `FlattenListModel`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFlattenListModel :: (MIO.MonadIO m, IsFlattenListModel o) => o -> m FlattenListModel
toFlattenListModel = MIO.liftIO . B.ManagedPtr.unsafeCastTo FlattenListModel

-- | Convert 'FlattenListModel' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FlattenListModel) where
    gvalueGType_ = c_gtk_flatten_list_model_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FlattenListModel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FlattenListModel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FlattenListModel ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFlattenListModelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFlattenListModelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFlattenListModelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFlattenListModelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFlattenListModelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFlattenListModelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFlattenListModelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFlattenListModelMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveFlattenListModelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFlattenListModelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFlattenListModelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFlattenListModelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFlattenListModelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFlattenListModelMethod "sectionsChanged" o = Gtk.SectionModel.SectionModelSectionsChangedMethodInfo
    ResolveFlattenListModelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFlattenListModelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFlattenListModelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFlattenListModelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFlattenListModelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFlattenListModelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFlattenListModelMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveFlattenListModelMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveFlattenListModelMethod "getModel" o = FlattenListModelGetModelMethodInfo
    ResolveFlattenListModelMethod "getModelForItem" o = FlattenListModelGetModelForItemMethodInfo
    ResolveFlattenListModelMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveFlattenListModelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFlattenListModelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFlattenListModelMethod "getSection" o = Gtk.SectionModel.SectionModelGetSectionMethodInfo
    ResolveFlattenListModelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFlattenListModelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFlattenListModelMethod "setModel" o = FlattenListModelSetModelMethodInfo
    ResolveFlattenListModelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFlattenListModelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFlattenListModelMethod t FlattenListModel, O.OverloadedMethod info FlattenListModel p) => OL.IsLabel t (FlattenListModel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFlattenListModelMethod t FlattenListModel, O.OverloadedMethod info FlattenListModel p, R.HasField t FlattenListModel p) => R.HasField t FlattenListModel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFlattenListModelMethod t FlattenListModel, O.OverloadedMethodInfo info FlattenListModel) => OL.IsLabel t (O.MethodProxy info FlattenListModel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flattenListModel #itemType
-- @
getFlattenListModelItemType :: (MonadIO m, IsFlattenListModel o) => o -> m GType
getFlattenListModelItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data FlattenListModelItemTypePropertyInfo
instance AttrInfo FlattenListModelItemTypePropertyInfo where
    type AttrAllowedOps FlattenListModelItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FlattenListModelItemTypePropertyInfo = IsFlattenListModel
    type AttrSetTypeConstraint FlattenListModelItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FlattenListModelItemTypePropertyInfo = (~) ()
    type AttrTransferType FlattenListModelItemTypePropertyInfo = ()
    type AttrGetType FlattenListModelItemTypePropertyInfo = GType
    type AttrLabel FlattenListModelItemTypePropertyInfo = "item-type"
    type AttrOrigin FlattenListModelItemTypePropertyInfo = FlattenListModel
    attrGet = getFlattenListModelItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FlattenListModel.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FlattenListModel.html#g:attr:itemType"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flattenListModel #model
-- @
getFlattenListModelModel :: (MonadIO m, IsFlattenListModel o) => o -> m (Maybe Gio.ListModel.ListModel)
getFlattenListModelModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gio.ListModel.ListModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' flattenListModel [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setFlattenListModelModel :: (MonadIO m, IsFlattenListModel o, Gio.ListModel.IsListModel a) => o -> a -> m ()
setFlattenListModelModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFlattenListModelModel :: (IsFlattenListModel o, MIO.MonadIO m, Gio.ListModel.IsListModel a) => a -> m (GValueConstruct o)
constructFlattenListModelModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearFlattenListModelModel :: (MonadIO m, IsFlattenListModel o) => o -> m ()
clearFlattenListModelModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gio.ListModel.ListModel)

#if defined(ENABLE_OVERLOADING)
data FlattenListModelModelPropertyInfo
instance AttrInfo FlattenListModelModelPropertyInfo where
    type AttrAllowedOps FlattenListModelModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FlattenListModelModelPropertyInfo = IsFlattenListModel
    type AttrSetTypeConstraint FlattenListModelModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferTypeConstraint FlattenListModelModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferType FlattenListModelModelPropertyInfo = Gio.ListModel.ListModel
    type AttrGetType FlattenListModelModelPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel FlattenListModelModelPropertyInfo = "model"
    type AttrOrigin FlattenListModelModelPropertyInfo = FlattenListModel
    attrGet = getFlattenListModelModel
    attrSet = setFlattenListModelModel
    attrTransfer _ v = do
        unsafeCastTo Gio.ListModel.ListModel v
    attrConstruct = constructFlattenListModelModel
    attrClear = clearFlattenListModelModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FlattenListModel.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FlattenListModel.html#g:attr:model"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flattenListModel #nItems
-- @
getFlattenListModelNItems :: (MonadIO m, IsFlattenListModel o) => o -> m Word32
getFlattenListModelNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data FlattenListModelNItemsPropertyInfo
instance AttrInfo FlattenListModelNItemsPropertyInfo where
    type AttrAllowedOps FlattenListModelNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FlattenListModelNItemsPropertyInfo = IsFlattenListModel
    type AttrSetTypeConstraint FlattenListModelNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint FlattenListModelNItemsPropertyInfo = (~) ()
    type AttrTransferType FlattenListModelNItemsPropertyInfo = ()
    type AttrGetType FlattenListModelNItemsPropertyInfo = Word32
    type AttrLabel FlattenListModelNItemsPropertyInfo = "n-items"
    type AttrOrigin FlattenListModelNItemsPropertyInfo = FlattenListModel
    attrGet = getFlattenListModelNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FlattenListModel.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FlattenListModel.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FlattenListModel
type instance O.AttributeList FlattenListModel = FlattenListModelAttributeList
type FlattenListModelAttributeList = ('[ '("itemType", FlattenListModelItemTypePropertyInfo), '("model", FlattenListModelModelPropertyInfo), '("nItems", FlattenListModelNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
flattenListModelItemType :: AttrLabelProxy "itemType"
flattenListModelItemType = AttrLabelProxy

flattenListModelModel :: AttrLabelProxy "model"
flattenListModelModel = AttrLabelProxy

flattenListModelNItems :: AttrLabelProxy "nItems"
flattenListModelNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FlattenListModel = FlattenListModelSignalList
type FlattenListModelSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sectionsChanged", Gtk.SectionModel.SectionModelSectionsChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FlattenListModel::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to be flattened"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "FlattenListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_flatten_list_model_new" gtk_flatten_list_model_new :: 
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO (Ptr FlattenListModel)

-- | Creates a new @GtkFlattenListModel@ that flattens /@list@/.
flattenListModelNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.ListModel.IsListModel a) =>
    Maybe (a)
    -- ^ /@model@/: the model to be flattened
    -> m FlattenListModel
    -- ^ __Returns:__ a new @GtkFlattenListModel@
flattenListModelNew model = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    result <- gtk_flatten_list_model_new maybeModel
    checkUnexpectedReturnNULL "flattenListModelNew" result
    result' <- (wrapObject FlattenListModel) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FlattenListModel::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlattenListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFlattenListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_flatten_list_model_get_model" gtk_flatten_list_model_get_model :: 
    Ptr FlattenListModel ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FlattenListModel"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Gets the model set via 'GI.Gtk.Objects.FlattenListModel.flattenListModelSetModel'.
flattenListModelGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsFlattenListModel a) =>
    a
    -- ^ /@self@/: a @GtkFlattenListModel@
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model flattened by /@self@/
flattenListModelGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_flatten_list_model_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FlattenListModelGetModelMethodInfo
instance (signature ~ (m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsFlattenListModel a) => O.OverloadedMethod FlattenListModelGetModelMethodInfo a signature where
    overloadedMethod = flattenListModelGetModel

instance O.OverloadedMethodInfo FlattenListModelGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FlattenListModel.flattenListModelGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FlattenListModel.html#v:flattenListModelGetModel"
        })


#endif

-- method FlattenListModel::get_model_for_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlattenListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFlattenListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_flatten_list_model_get_model_for_item" gtk_flatten_list_model_get_model_for_item :: 
    Ptr FlattenListModel ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FlattenListModel"})
    Word32 ->                               -- position : TBasicType TUInt
    IO (Ptr Gio.ListModel.ListModel)

-- | Returns the model containing the item at the given position.
flattenListModelGetModelForItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsFlattenListModel a) =>
    a
    -- ^ /@self@/: a @GtkFlattenListModel@
    -> Word32
    -- ^ /@position@/: a position
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ the model containing the item at /@position@/
flattenListModelGetModelForItem self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_flatten_list_model_get_model_for_item self' position
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FlattenListModelGetModelForItemMethodInfo
instance (signature ~ (Word32 -> m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsFlattenListModel a) => O.OverloadedMethod FlattenListModelGetModelForItemMethodInfo a signature where
    overloadedMethod = flattenListModelGetModelForItem

instance O.OverloadedMethodInfo FlattenListModelGetModelForItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FlattenListModel.flattenListModelGetModelForItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FlattenListModel.html#v:flattenListModelGetModelForItem"
        })


#endif

-- method FlattenListModel::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FlattenListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFlattenListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new model" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_flatten_list_model_set_model" gtk_flatten_list_model_set_model :: 
    Ptr FlattenListModel ->                 -- self : TInterface (Name {namespace = "Gtk", name = "FlattenListModel"})
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO ()

-- | Sets a new model to be flattened.
flattenListModelSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsFlattenListModel a, Gio.ListModel.IsListModel b) =>
    a
    -- ^ /@self@/: a @GtkFlattenListModel@
    -> Maybe (b)
    -- ^ /@model@/: the new model
    -> m ()
flattenListModelSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_flatten_list_model_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FlattenListModelSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsFlattenListModel a, Gio.ListModel.IsListModel b) => O.OverloadedMethod FlattenListModelSetModelMethodInfo a signature where
    overloadedMethod = flattenListModelSetModel

instance O.OverloadedMethodInfo FlattenListModelSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FlattenListModel.flattenListModelSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FlattenListModel.html#v:flattenListModelSetModel"
        })


#endif


