{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Asynchronous API to open a file with an application.
-- 
-- @GtkFileLauncher@ collects the arguments that are needed to open the file.
-- 
-- Depending on system configuration, user preferences and available APIs, this
-- may or may not show an app chooser dialog or launch the default application
-- right away.
-- 
-- The operation is started with the 'GI.Gtk.Objects.FileLauncher.fileLauncherLaunch' function.
-- 
-- To launch uris that don\'t represent files, use t'GI.Gtk.Objects.UriLauncher.UriLauncher'.
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.FileLauncher
    ( 

-- * Exported types
    FileLauncher(..)                        ,
    IsFileLauncher                          ,
    toFileLauncher                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [launch]("GI.Gtk.Objects.FileLauncher#g:method:launch"), [launchFinish]("GI.Gtk.Objects.FileLauncher#g:method:launchFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [openContainingFolder]("GI.Gtk.Objects.FileLauncher#g:method:openContainingFolder"), [openContainingFolderFinish]("GI.Gtk.Objects.FileLauncher#g:method:openContainingFolderFinish"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAlwaysAsk]("GI.Gtk.Objects.FileLauncher#g:method:getAlwaysAsk"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFile]("GI.Gtk.Objects.FileLauncher#g:method:getFile"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWritable]("GI.Gtk.Objects.FileLauncher#g:method:getWritable").
-- 
-- ==== Setters
-- [setAlwaysAsk]("GI.Gtk.Objects.FileLauncher#g:method:setAlwaysAsk"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFile]("GI.Gtk.Objects.FileLauncher#g:method:setFile"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setWritable]("GI.Gtk.Objects.FileLauncher#g:method:setWritable").

#if defined(ENABLE_OVERLOADING)
    ResolveFileLauncherMethod               ,
#endif

-- ** getAlwaysAsk #method:getAlwaysAsk#

#if defined(ENABLE_OVERLOADING)
    FileLauncherGetAlwaysAskMethodInfo      ,
#endif
    fileLauncherGetAlwaysAsk                ,


-- ** getFile #method:getFile#

#if defined(ENABLE_OVERLOADING)
    FileLauncherGetFileMethodInfo           ,
#endif
    fileLauncherGetFile                     ,


-- ** getWritable #method:getWritable#

#if defined(ENABLE_OVERLOADING)
    FileLauncherGetWritableMethodInfo       ,
#endif
    fileLauncherGetWritable                 ,


-- ** launch #method:launch#

#if defined(ENABLE_OVERLOADING)
    FileLauncherLaunchMethodInfo            ,
#endif
    fileLauncherLaunch                      ,


-- ** launchFinish #method:launchFinish#

#if defined(ENABLE_OVERLOADING)
    FileLauncherLaunchFinishMethodInfo      ,
#endif
    fileLauncherLaunchFinish                ,


-- ** new #method:new#

    fileLauncherNew                         ,


-- ** openContainingFolder #method:openContainingFolder#

#if defined(ENABLE_OVERLOADING)
    FileLauncherOpenContainingFolderMethodInfo,
#endif
    fileLauncherOpenContainingFolder        ,


-- ** openContainingFolderFinish #method:openContainingFolderFinish#

#if defined(ENABLE_OVERLOADING)
    FileLauncherOpenContainingFolderFinishMethodInfo,
#endif
    fileLauncherOpenContainingFolderFinish  ,


-- ** setAlwaysAsk #method:setAlwaysAsk#

#if defined(ENABLE_OVERLOADING)
    FileLauncherSetAlwaysAskMethodInfo      ,
#endif
    fileLauncherSetAlwaysAsk                ,


-- ** setFile #method:setFile#

#if defined(ENABLE_OVERLOADING)
    FileLauncherSetFileMethodInfo           ,
#endif
    fileLauncherSetFile                     ,


-- ** setWritable #method:setWritable#

#if defined(ENABLE_OVERLOADING)
    FileLauncherSetWritableMethodInfo       ,
#endif
    fileLauncherSetWritable                 ,




 -- * Properties


-- ** alwaysAsk #attr:alwaysAsk#
-- | Whether to ask the user to choose an app for opening the file. If @FALSE@,
-- the file might be opened with a default app or the previous choice.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    FileLauncherAlwaysAskPropertyInfo       ,
#endif
    constructFileLauncherAlwaysAsk          ,
#if defined(ENABLE_OVERLOADING)
    fileLauncherAlwaysAsk                   ,
#endif
    getFileLauncherAlwaysAsk                ,
    setFileLauncherAlwaysAsk                ,


-- ** file #attr:file#
-- | The file to launch.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    FileLauncherFilePropertyInfo            ,
#endif
    clearFileLauncherFile                   ,
    constructFileLauncherFile               ,
#if defined(ENABLE_OVERLOADING)
    fileLauncherFile                        ,
#endif
    getFileLauncherFile                     ,
    setFileLauncherFile                     ,


-- ** writable #attr:writable#
-- | Whether to make the file writable for the handler.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    FileLauncherWritablePropertyInfo        ,
#endif
    constructFileLauncherWritable           ,
#if defined(ENABLE_OVERLOADING)
    fileLauncherWritable                    ,
#endif
    getFileLauncherWritable                 ,
    setFileLauncherWritable                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype FileLauncher = FileLauncher (SP.ManagedPtr FileLauncher)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileLauncher where
    toManagedPtr (FileLauncher p) = p

foreign import ccall "gtk_file_launcher_get_type"
    c_gtk_file_launcher_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileLauncher where
    glibType = c_gtk_file_launcher_get_type

instance B.Types.GObject FileLauncher

-- | Type class for types which can be safely cast to `FileLauncher`, for instance with `toFileLauncher`.
class (SP.GObject o, O.IsDescendantOf FileLauncher o) => IsFileLauncher o
instance (SP.GObject o, O.IsDescendantOf FileLauncher o) => IsFileLauncher o

instance O.HasParentTypes FileLauncher
type instance O.ParentTypes FileLauncher = '[GObject.Object.Object]

-- | Cast to `FileLauncher`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFileLauncher :: (MIO.MonadIO m, IsFileLauncher o) => o -> m FileLauncher
toFileLauncher = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileLauncher

-- | Convert 'FileLauncher' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileLauncher) where
    gvalueGType_ = c_gtk_file_launcher_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileLauncher)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileLauncher)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileLauncher ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFileLauncherMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileLauncherMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileLauncherMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileLauncherMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileLauncherMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileLauncherMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileLauncherMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileLauncherMethod "launch" o = FileLauncherLaunchMethodInfo
    ResolveFileLauncherMethod "launchFinish" o = FileLauncherLaunchFinishMethodInfo
    ResolveFileLauncherMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileLauncherMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileLauncherMethod "openContainingFolder" o = FileLauncherOpenContainingFolderMethodInfo
    ResolveFileLauncherMethod "openContainingFolderFinish" o = FileLauncherOpenContainingFolderFinishMethodInfo
    ResolveFileLauncherMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileLauncherMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileLauncherMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileLauncherMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileLauncherMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileLauncherMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileLauncherMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileLauncherMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileLauncherMethod "getAlwaysAsk" o = FileLauncherGetAlwaysAskMethodInfo
    ResolveFileLauncherMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileLauncherMethod "getFile" o = FileLauncherGetFileMethodInfo
    ResolveFileLauncherMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileLauncherMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileLauncherMethod "getWritable" o = FileLauncherGetWritableMethodInfo
    ResolveFileLauncherMethod "setAlwaysAsk" o = FileLauncherSetAlwaysAskMethodInfo
    ResolveFileLauncherMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileLauncherMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileLauncherMethod "setFile" o = FileLauncherSetFileMethodInfo
    ResolveFileLauncherMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileLauncherMethod "setWritable" o = FileLauncherSetWritableMethodInfo
    ResolveFileLauncherMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileLauncherMethod t FileLauncher, O.OverloadedMethod info FileLauncher p) => OL.IsLabel t (FileLauncher -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileLauncherMethod t FileLauncher, O.OverloadedMethod info FileLauncher p, R.HasField t FileLauncher p) => R.HasField t FileLauncher p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileLauncherMethod t FileLauncher, O.OverloadedMethodInfo info FileLauncher) => OL.IsLabel t (O.MethodProxy info FileLauncher) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "always-ask"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@always-ask@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileLauncher #alwaysAsk
-- @
getFileLauncherAlwaysAsk :: (MonadIO m, IsFileLauncher o) => o -> m Bool
getFileLauncherAlwaysAsk obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "always-ask"

-- | Set the value of the “@always-ask@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileLauncher [ #alwaysAsk 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileLauncherAlwaysAsk :: (MonadIO m, IsFileLauncher o) => o -> Bool -> m ()
setFileLauncherAlwaysAsk obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "always-ask" val

-- | Construct a `GValueConstruct` with valid value for the “@always-ask@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileLauncherAlwaysAsk :: (IsFileLauncher o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFileLauncherAlwaysAsk val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "always-ask" val

#if defined(ENABLE_OVERLOADING)
data FileLauncherAlwaysAskPropertyInfo
instance AttrInfo FileLauncherAlwaysAskPropertyInfo where
    type AttrAllowedOps FileLauncherAlwaysAskPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FileLauncherAlwaysAskPropertyInfo = IsFileLauncher
    type AttrSetTypeConstraint FileLauncherAlwaysAskPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FileLauncherAlwaysAskPropertyInfo = (~) Bool
    type AttrTransferType FileLauncherAlwaysAskPropertyInfo = Bool
    type AttrGetType FileLauncherAlwaysAskPropertyInfo = Bool
    type AttrLabel FileLauncherAlwaysAskPropertyInfo = "always-ask"
    type AttrOrigin FileLauncherAlwaysAskPropertyInfo = FileLauncher
    attrGet = getFileLauncherAlwaysAsk
    attrSet = setFileLauncherAlwaysAsk
    attrTransfer _ v = do
        return v
    attrConstruct = constructFileLauncherAlwaysAsk
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.alwaysAsk"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#g:attr:alwaysAsk"
        })
#endif

-- VVV Prop "file"
   -- Type: TInterface (Name {namespace = "Gio", name = "File"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileLauncher #file
-- @
getFileLauncherFile :: (MonadIO m, IsFileLauncher o) => o -> m (Maybe Gio.File.File)
getFileLauncherFile obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "file" Gio.File.File

-- | Set the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileLauncher [ #file 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileLauncherFile :: (MonadIO m, IsFileLauncher o, Gio.File.IsFile a) => o -> a -> m ()
setFileLauncherFile obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "file" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@file@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileLauncherFile :: (IsFileLauncher o, MIO.MonadIO m, Gio.File.IsFile a) => a -> m (GValueConstruct o)
constructFileLauncherFile val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "file" (P.Just val)

-- | Set the value of the “@file@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #file
-- @
clearFileLauncherFile :: (MonadIO m, IsFileLauncher o) => o -> m ()
clearFileLauncherFile obj = liftIO $ B.Properties.setObjectPropertyObject obj "file" (Nothing :: Maybe Gio.File.File)

#if defined(ENABLE_OVERLOADING)
data FileLauncherFilePropertyInfo
instance AttrInfo FileLauncherFilePropertyInfo where
    type AttrAllowedOps FileLauncherFilePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FileLauncherFilePropertyInfo = IsFileLauncher
    type AttrSetTypeConstraint FileLauncherFilePropertyInfo = Gio.File.IsFile
    type AttrTransferTypeConstraint FileLauncherFilePropertyInfo = Gio.File.IsFile
    type AttrTransferType FileLauncherFilePropertyInfo = Gio.File.File
    type AttrGetType FileLauncherFilePropertyInfo = (Maybe Gio.File.File)
    type AttrLabel FileLauncherFilePropertyInfo = "file"
    type AttrOrigin FileLauncherFilePropertyInfo = FileLauncher
    attrGet = getFileLauncherFile
    attrSet = setFileLauncherFile
    attrTransfer _ v = do
        unsafeCastTo Gio.File.File v
    attrConstruct = constructFileLauncherFile
    attrClear = clearFileLauncherFile
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.file"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#g:attr:file"
        })
#endif

-- VVV Prop "writable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@writable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileLauncher #writable
-- @
getFileLauncherWritable :: (MonadIO m, IsFileLauncher o) => o -> m Bool
getFileLauncherWritable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "writable"

-- | Set the value of the “@writable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileLauncher [ #writable 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileLauncherWritable :: (MonadIO m, IsFileLauncher o) => o -> Bool -> m ()
setFileLauncherWritable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "writable" val

-- | Construct a `GValueConstruct` with valid value for the “@writable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileLauncherWritable :: (IsFileLauncher o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFileLauncherWritable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "writable" val

#if defined(ENABLE_OVERLOADING)
data FileLauncherWritablePropertyInfo
instance AttrInfo FileLauncherWritablePropertyInfo where
    type AttrAllowedOps FileLauncherWritablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FileLauncherWritablePropertyInfo = IsFileLauncher
    type AttrSetTypeConstraint FileLauncherWritablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FileLauncherWritablePropertyInfo = (~) Bool
    type AttrTransferType FileLauncherWritablePropertyInfo = Bool
    type AttrGetType FileLauncherWritablePropertyInfo = Bool
    type AttrLabel FileLauncherWritablePropertyInfo = "writable"
    type AttrOrigin FileLauncherWritablePropertyInfo = FileLauncher
    attrGet = getFileLauncherWritable
    attrSet = setFileLauncherWritable
    attrTransfer _ v = do
        return v
    attrConstruct = constructFileLauncherWritable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.writable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#g:attr:writable"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileLauncher
type instance O.AttributeList FileLauncher = FileLauncherAttributeList
type FileLauncherAttributeList = ('[ '("alwaysAsk", FileLauncherAlwaysAskPropertyInfo), '("file", FileLauncherFilePropertyInfo), '("writable", FileLauncherWritablePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fileLauncherAlwaysAsk :: AttrLabelProxy "alwaysAsk"
fileLauncherAlwaysAsk = AttrLabelProxy

fileLauncherFile :: AttrLabelProxy "file"
fileLauncherFile = AttrLabelProxy

fileLauncherWritable :: AttrLabelProxy "writable"
fileLauncherWritable = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileLauncher = FileLauncherSignalList
type FileLauncherSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FileLauncher::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the file to open" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "FileLauncher" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_new" gtk_file_launcher_new :: 
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO (Ptr FileLauncher)

-- | Creates a new @GtkFileLauncher@ object.
-- 
-- /Since: 4.10/
fileLauncherNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.File.IsFile a) =>
    Maybe (a)
    -- ^ /@file@/: the file to open
    -> m FileLauncher
    -- ^ __Returns:__ the new @GtkFileLauncher@
fileLauncherNew file = liftIO $ do
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    result <- gtk_file_launcher_new maybeFile
    checkUnexpectedReturnNULL "fileLauncherNew" result
    result' <- (wrapObject FileLauncher) result
    whenJust file touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FileLauncher::get_always_ask
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_get_always_ask" gtk_file_launcher_get_always_ask :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    IO CInt

-- | Returns whether to ask the user which app to use.
-- 
-- /Since: 4.12/
fileLauncherGetAlwaysAsk ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a) =>
    a
    -- ^ /@self@/: a file launcher
    -> m Bool
    -- ^ __Returns:__ true if always asking the user
fileLauncherGetAlwaysAsk self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_file_launcher_get_always_ask self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data FileLauncherGetAlwaysAskMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileLauncher a) => O.OverloadedMethod FileLauncherGetAlwaysAskMethodInfo a signature where
    overloadedMethod = fileLauncherGetAlwaysAsk

instance O.OverloadedMethodInfo FileLauncherGetAlwaysAskMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherGetAlwaysAsk",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherGetAlwaysAsk"
        })


#endif

-- method FileLauncher::get_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_get_file" gtk_file_launcher_get_file :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    IO (Ptr Gio.File.File)

-- | Gets the file that will be opened.
-- 
-- /Since: 4.10/
fileLauncherGetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a) =>
    a
    -- ^ /@self@/: a file launcher
    -> m (Maybe Gio.File.File)
    -- ^ __Returns:__ the file
fileLauncherGetFile self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_file_launcher_get_file self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.File.File) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FileLauncherGetFileMethodInfo
instance (signature ~ (m (Maybe Gio.File.File)), MonadIO m, IsFileLauncher a) => O.OverloadedMethod FileLauncherGetFileMethodInfo a signature where
    overloadedMethod = fileLauncherGetFile

instance O.OverloadedMethodInfo FileLauncherGetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherGetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherGetFile"
        })


#endif

-- method FileLauncher::get_writable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_get_writable" gtk_file_launcher_get_writable :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    IO CInt

-- | Returns whether to make the file writable for the handler.
-- 
-- /Since: 4.14/
fileLauncherGetWritable ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a) =>
    a
    -- ^ /@self@/: a file launcher
    -> m Bool
    -- ^ __Returns:__ true if the file will be made writable
fileLauncherGetWritable self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_file_launcher_get_writable self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data FileLauncherGetWritableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFileLauncher a) => O.OverloadedMethod FileLauncherGetWritableMethodInfo a signature where
    overloadedMethod = fileLauncherGetWritable

instance O.OverloadedMethodInfo FileLauncherGetWritableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherGetWritable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherGetWritable"
        })


#endif

-- method FileLauncher::launch
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cancellable to cancel the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a callback to call when the\n  operation is complete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_launch" gtk_file_launcher_launch :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Launches an application to open the file.
-- 
-- This may present an app chooser dialog to the user.
-- 
-- /Since: 4.10/
fileLauncherLaunch ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@self@/: a file launcher
    -> Maybe (b)
    -- ^ /@parent@/: the parent window
    -> Maybe (c)
    -- ^ /@cancellable@/: a cancellable to cancel the operation
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a callback to call when the
    --   operation is complete
    -> m ()
fileLauncherLaunch self parent cancellable callback = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gtk_file_launcher_launch self' maybeParent maybeCancellable maybeCallback userData
    touchManagedPtr self
    whenJust parent touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FileLauncherLaunchMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsFileLauncher a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod FileLauncherLaunchMethodInfo a signature where
    overloadedMethod = fileLauncherLaunch

instance O.OverloadedMethodInfo FileLauncherLaunchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherLaunch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherLaunch"
        })


#endif

-- method FileLauncher::launch_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_file_launcher_launch_finish" gtk_file_launcher_launch_finish :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes the 'GI.Gtk.Objects.FileLauncher.fileLauncherLaunch' call and
-- returns the result.
-- 
-- /Since: 4.10/
fileLauncherLaunchFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@self@/: a file launcher
    -> b
    -- ^ /@result@/: the result
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileLauncherLaunchFinish self result_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ gtk_file_launcher_launch_finish self' result_'
        touchManagedPtr self
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileLauncherLaunchFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileLauncher a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod FileLauncherLaunchFinishMethodInfo a signature where
    overloadedMethod = fileLauncherLaunchFinish

instance O.OverloadedMethodInfo FileLauncherLaunchFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherLaunchFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherLaunchFinish"
        })


#endif

-- method FileLauncher::open_containing_folder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cancellable to cancel the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a callback to call when the\n  operation is complete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_open_containing_folder" gtk_file_launcher_open_containing_folder :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Launches a file manager to show the file in its parent directory.
-- 
-- This is only supported for native files. It will fail if /@file@/
-- is e.g. a http:\/\/ uri.
-- 
-- /Since: 4.10/
fileLauncherOpenContainingFolder ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@self@/: a file launcher
    -> Maybe (b)
    -- ^ /@parent@/: the parent window
    -> Maybe (c)
    -- ^ /@cancellable@/: a cancellable to cancel the operation
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a callback to call when the
    --   operation is complete
    -> m ()
fileLauncherOpenContainingFolder self parent cancellable callback = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gtk_file_launcher_open_containing_folder self' maybeParent maybeCancellable maybeCallback userData
    touchManagedPtr self
    whenJust parent touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FileLauncherOpenContainingFolderMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsFileLauncher a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod FileLauncherOpenContainingFolderMethodInfo a signature where
    overloadedMethod = fileLauncherOpenContainingFolder

instance O.OverloadedMethodInfo FileLauncherOpenContainingFolderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherOpenContainingFolder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherOpenContainingFolder"
        })


#endif

-- method FileLauncher::open_containing_folder_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_file_launcher_open_containing_folder_finish" gtk_file_launcher_open_containing_folder_finish :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes the 'GI.Gtk.Objects.FileLauncher.fileLauncherOpenContainingFolder'
-- call and returns the result.
-- 
-- /Since: 4.10/
fileLauncherOpenContainingFolderFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@self@/: a file launcher
    -> b
    -- ^ /@result@/: the result
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileLauncherOpenContainingFolderFinish self result_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ gtk_file_launcher_open_containing_folder_finish self' result_'
        touchManagedPtr self
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileLauncherOpenContainingFolderFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsFileLauncher a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod FileLauncherOpenContainingFolderFinishMethodInfo a signature where
    overloadedMethod = fileLauncherOpenContainingFolderFinish

instance O.OverloadedMethodInfo FileLauncherOpenContainingFolderFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherOpenContainingFolderFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherOpenContainingFolderFinish"
        })


#endif

-- method FileLauncher::set_always_ask
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "always_ask"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to always ask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_set_always_ask" gtk_file_launcher_set_always_ask :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    CInt ->                                 -- always_ask : TBasicType TBoolean
    IO ()

-- | Sets whether to always ask the user which app to use.
-- 
-- If false, the file might be opened with a default app
-- or the previous choice.
-- 
-- /Since: 4.12/
fileLauncherSetAlwaysAsk ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a) =>
    a
    -- ^ /@self@/: a file launcher
    -> Bool
    -- ^ /@alwaysAsk@/: whether to always ask
    -> m ()
fileLauncherSetAlwaysAsk self alwaysAsk = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let alwaysAsk' = (P.fromIntegral . P.fromEnum) alwaysAsk
    gtk_file_launcher_set_always_ask self' alwaysAsk'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data FileLauncherSetAlwaysAskMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFileLauncher a) => O.OverloadedMethod FileLauncherSetAlwaysAskMethodInfo a signature where
    overloadedMethod = fileLauncherSetAlwaysAsk

instance O.OverloadedMethodInfo FileLauncherSetAlwaysAskMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherSetAlwaysAsk",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherSetAlwaysAsk"
        })


#endif

-- method FileLauncher::set_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the file" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_set_file" gtk_file_launcher_set_file :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO ()

-- | Sets the file that will be opened.
-- 
-- /Since: 4.10/
fileLauncherSetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a, Gio.File.IsFile b) =>
    a
    -- ^ /@self@/: a file launcher
    -> Maybe (b)
    -- ^ /@file@/: the file
    -> m ()
fileLauncherSetFile self file = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    gtk_file_launcher_set_file self' maybeFile
    touchManagedPtr self
    whenJust file touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data FileLauncherSetFileMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsFileLauncher a, Gio.File.IsFile b) => O.OverloadedMethod FileLauncherSetFileMethodInfo a signature where
    overloadedMethod = fileLauncherSetFile

instance O.OverloadedMethodInfo FileLauncherSetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherSetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherSetFile"
        })


#endif

-- method FileLauncher::set_writable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "writable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to make the file writable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_launcher_set_writable" gtk_file_launcher_set_writable :: 
    Ptr FileLauncher ->                     -- self : TInterface (Name {namespace = "Gtk", name = "FileLauncher"})
    CInt ->                                 -- writable : TBasicType TBoolean
    IO ()

-- | Sets whether to make the file writable for the handler.
-- 
-- /Since: 4.14/
fileLauncherSetWritable ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileLauncher a) =>
    a
    -- ^ /@self@/: a file launcher
    -> Bool
    -- ^ /@writable@/: whether to make the file writable
    -> m ()
fileLauncherSetWritable self writable = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let writable' = (P.fromIntegral . P.fromEnum) writable
    gtk_file_launcher_set_writable self' writable'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data FileLauncherSetWritableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFileLauncher a) => O.OverloadedMethod FileLauncherSetWritableMethodInfo a signature where
    overloadedMethod = fileLauncherSetWritable

instance O.OverloadedMethodInfo FileLauncherSetWritableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileLauncher.fileLauncherSetWritable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileLauncher.html#v:fileLauncherSetWritable"
        })


#endif


