{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkFileChooserWidget@ is a widget for choosing files.
-- 
-- It exposes the t'GI.Gtk.Interfaces.FileChooser.FileChooser' interface, and you should
-- use the methods of this interface to interact with the
-- widget.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkFileChooserWidget@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Shift\<\/kbd>+\<kbd>F10\<\/kbd> or \<kbd>Menu\<\/kbd> opens the context menu.
-- 
-- 
-- The following signals have default keybindings:
-- 
-- * [FileChooserWidget::desktopFolder]("GI.Gtk.Objects.FileChooserWidget#g:signal:desktopFolder")
-- * [FileChooserWidget::downFolder]("GI.Gtk.Objects.FileChooserWidget#g:signal:downFolder")
-- * [FileChooserWidget::homeFolder]("GI.Gtk.Objects.FileChooserWidget#g:signal:homeFolder")
-- * [FileChooserWidget::locationPopup]("GI.Gtk.Objects.FileChooserWidget#g:signal:locationPopup")
-- * [FileChooserWidget::locationPopupOnPaste]("GI.Gtk.Objects.FileChooserWidget#g:signal:locationPopupOnPaste")
-- * [FileChooserWidget::locationTogglePopup]("GI.Gtk.Objects.FileChooserWidget#g:signal:locationTogglePopup")
-- * [FileChooserWidget::placesShortcut]("GI.Gtk.Objects.FileChooserWidget#g:signal:placesShortcut")
-- * [FileChooserWidget::quickBookmark]("GI.Gtk.Objects.FileChooserWidget#g:signal:quickBookmark")
-- * [FileChooserWidget::recentShortcut]("GI.Gtk.Objects.FileChooserWidget#g:signal:recentShortcut")
-- * [FileChooserWidget::searchShortcut]("GI.Gtk.Objects.FileChooserWidget#g:signal:searchShortcut")
-- * [FileChooserWidget::showHidden]("GI.Gtk.Objects.FileChooserWidget#g:signal:showHidden")
-- * [FileChooserWidget::upFolder]("GI.Gtk.Objects.FileChooserWidget#g:signal:upFolder")
-- 
-- 
-- = CSS nodes
-- 
-- @GtkFileChooserWidget@ has a single CSS node with name filechooser.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.FileChooserWidget
    ( 

-- * Exported types
    FileChooserWidget(..)                   ,
    IsFileChooserWidget                     ,
    toFileChooserWidget                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addChoice]("GI.Gtk.Interfaces.FileChooser#g:method:addChoice"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addFilter]("GI.Gtk.Interfaces.FileChooser#g:method:addFilter"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addShortcutFolder]("GI.Gtk.Interfaces.FileChooser#g:method:addShortcutFolder"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeChoice]("GI.Gtk.Interfaces.FileChooser#g:method:removeChoice"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeFilter]("GI.Gtk.Interfaces.FileChooser#g:method:removeFilter"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeShortcutFolder]("GI.Gtk.Interfaces.FileChooser#g:method:removeShortcutFolder"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAction]("GI.Gtk.Interfaces.FileChooser#g:method:getAction"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getChoice]("GI.Gtk.Interfaces.FileChooser#g:method:getChoice"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCreateFolders]("GI.Gtk.Interfaces.FileChooser#g:method:getCreateFolders"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCurrentFolder]("GI.Gtk.Interfaces.FileChooser#g:method:getCurrentFolder"), [getCurrentName]("GI.Gtk.Interfaces.FileChooser#g:method:getCurrentName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFile]("GI.Gtk.Interfaces.FileChooser#g:method:getFile"), [getFiles]("GI.Gtk.Interfaces.FileChooser#g:method:getFiles"), [getFilter]("GI.Gtk.Interfaces.FileChooser#g:method:getFilter"), [getFilters]("GI.Gtk.Interfaces.FileChooser#g:method:getFilters"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSelectMultiple]("GI.Gtk.Interfaces.FileChooser#g:method:getSelectMultiple"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShortcutFolders]("GI.Gtk.Interfaces.FileChooser#g:method:getShortcutFolders"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAction]("GI.Gtk.Interfaces.FileChooser#g:method:setAction"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setChoice]("GI.Gtk.Interfaces.FileChooser#g:method:setChoice"), [setCreateFolders]("GI.Gtk.Interfaces.FileChooser#g:method:setCreateFolders"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCurrentFolder]("GI.Gtk.Interfaces.FileChooser#g:method:setCurrentFolder"), [setCurrentName]("GI.Gtk.Interfaces.FileChooser#g:method:setCurrentName"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFile]("GI.Gtk.Interfaces.FileChooser#g:method:setFile"), [setFilter]("GI.Gtk.Interfaces.FileChooser#g:method:setFilter"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSelectMultiple]("GI.Gtk.Interfaces.FileChooser#g:method:setSelectMultiple"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveFileChooserWidgetMethod          ,
#endif

-- ** new #method:new#

    fileChooserWidgetNew                    ,




 -- * Properties


-- ** searchMode #attr:searchMode#
-- | Whether search mode is enabled.

#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetSearchModePropertyInfo ,
#endif
    constructFileChooserWidgetSearchMode    ,
#if defined(ENABLE_OVERLOADING)
    fileChooserWidgetSearchMode             ,
#endif
    getFileChooserWidgetSearchMode          ,
    setFileChooserWidgetSearchMode          ,


-- ** showTime #attr:showTime#
-- | Whether to show the time.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetShowTimePropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    fileChooserWidgetShowTime               ,
#endif
    getFileChooserWidgetShowTime            ,


-- ** subtitle #attr:subtitle#
-- | The subtitle of the file chooser widget.

#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetSubtitlePropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    fileChooserWidgetSubtitle               ,
#endif
    getFileChooserWidgetSubtitle            ,




 -- * Signals


-- ** desktopFolder #signal:desktopFolder#

    FileChooserWidgetDesktopFolderCallback  ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetDesktopFolderSignalInfo,
#endif
    afterFileChooserWidgetDesktopFolder     ,
    onFileChooserWidgetDesktopFolder        ,


-- ** downFolder #signal:downFolder#

    FileChooserWidgetDownFolderCallback     ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetDownFolderSignalInfo   ,
#endif
    afterFileChooserWidgetDownFolder        ,
    onFileChooserWidgetDownFolder           ,


-- ** homeFolder #signal:homeFolder#

    FileChooserWidgetHomeFolderCallback     ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetHomeFolderSignalInfo   ,
#endif
    afterFileChooserWidgetHomeFolder        ,
    onFileChooserWidgetHomeFolder           ,


-- ** locationPopup #signal:locationPopup#

    FileChooserWidgetLocationPopupCallback  ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetLocationPopupSignalInfo,
#endif
    afterFileChooserWidgetLocationPopup     ,
    onFileChooserWidgetLocationPopup        ,


-- ** locationPopupOnPaste #signal:locationPopupOnPaste#

    FileChooserWidgetLocationPopupOnPasteCallback,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetLocationPopupOnPasteSignalInfo,
#endif
    afterFileChooserWidgetLocationPopupOnPaste,
    onFileChooserWidgetLocationPopupOnPaste ,


-- ** locationTogglePopup #signal:locationTogglePopup#

    FileChooserWidgetLocationTogglePopupCallback,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetLocationTogglePopupSignalInfo,
#endif
    afterFileChooserWidgetLocationTogglePopup,
    onFileChooserWidgetLocationTogglePopup  ,


-- ** placesShortcut #signal:placesShortcut#

    FileChooserWidgetPlacesShortcutCallback ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetPlacesShortcutSignalInfo,
#endif
    afterFileChooserWidgetPlacesShortcut    ,
    onFileChooserWidgetPlacesShortcut       ,


-- ** quickBookmark #signal:quickBookmark#

    FileChooserWidgetQuickBookmarkCallback  ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetQuickBookmarkSignalInfo,
#endif
    afterFileChooserWidgetQuickBookmark     ,
    onFileChooserWidgetQuickBookmark        ,


-- ** recentShortcut #signal:recentShortcut#

    FileChooserWidgetRecentShortcutCallback ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetRecentShortcutSignalInfo,
#endif
    afterFileChooserWidgetRecentShortcut    ,
    onFileChooserWidgetRecentShortcut       ,


-- ** searchShortcut #signal:searchShortcut#

    FileChooserWidgetSearchShortcutCallback ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetSearchShortcutSignalInfo,
#endif
    afterFileChooserWidgetSearchShortcut    ,
    onFileChooserWidgetSearchShortcut       ,


-- ** showHidden #signal:showHidden#

    FileChooserWidgetShowHiddenCallback     ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetShowHiddenSignalInfo   ,
#endif
    afterFileChooserWidgetShowHidden        ,
    onFileChooserWidgetShowHidden           ,


-- ** upFolder #signal:upFolder#

    FileChooserWidgetUpFolderCallback       ,
#if defined(ENABLE_OVERLOADING)
    FileChooserWidgetUpFolderSignalInfo     ,
#endif
    afterFileChooserWidgetUpFolder          ,
    onFileChooserWidgetUpFolder             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.FileChooser as Gtk.FileChooser
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.FileFilter as Gtk.FileFilter
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.FileChooser as Gtk.FileChooser
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype FileChooserWidget = FileChooserWidget (SP.ManagedPtr FileChooserWidget)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileChooserWidget where
    toManagedPtr (FileChooserWidget p) = p

foreign import ccall "gtk_file_chooser_widget_get_type"
    c_gtk_file_chooser_widget_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileChooserWidget where
    glibType = c_gtk_file_chooser_widget_get_type

instance B.Types.GObject FileChooserWidget

-- | Type class for types which can be safely cast to `FileChooserWidget`, for instance with `toFileChooserWidget`.
class (SP.GObject o, O.IsDescendantOf FileChooserWidget o) => IsFileChooserWidget o
instance (SP.GObject o, O.IsDescendantOf FileChooserWidget o) => IsFileChooserWidget o

instance O.HasParentTypes FileChooserWidget
type instance O.ParentTypes FileChooserWidget = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.FileChooser.FileChooser]

-- | Cast to `FileChooserWidget`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFileChooserWidget :: (MIO.MonadIO m, IsFileChooserWidget o) => o -> m FileChooserWidget
toFileChooserWidget = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileChooserWidget

-- | Convert 'FileChooserWidget' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileChooserWidget) where
    gvalueGType_ = c_gtk_file_chooser_widget_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileChooserWidget)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileChooserWidget)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileChooserWidget ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFileChooserWidgetMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileChooserWidgetMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveFileChooserWidgetMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveFileChooserWidgetMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveFileChooserWidgetMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveFileChooserWidgetMethod "addChoice" o = Gtk.FileChooser.FileChooserAddChoiceMethodInfo
    ResolveFileChooserWidgetMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveFileChooserWidgetMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveFileChooserWidgetMethod "addFilter" o = Gtk.FileChooser.FileChooserAddFilterMethodInfo
    ResolveFileChooserWidgetMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveFileChooserWidgetMethod "addShortcutFolder" o = Gtk.FileChooser.FileChooserAddShortcutFolderMethodInfo
    ResolveFileChooserWidgetMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveFileChooserWidgetMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveFileChooserWidgetMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveFileChooserWidgetMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileChooserWidgetMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileChooserWidgetMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveFileChooserWidgetMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveFileChooserWidgetMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveFileChooserWidgetMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveFileChooserWidgetMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveFileChooserWidgetMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveFileChooserWidgetMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveFileChooserWidgetMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveFileChooserWidgetMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveFileChooserWidgetMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveFileChooserWidgetMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveFileChooserWidgetMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileChooserWidgetMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileChooserWidgetMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileChooserWidgetMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveFileChooserWidgetMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveFileChooserWidgetMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveFileChooserWidgetMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveFileChooserWidgetMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveFileChooserWidgetMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveFileChooserWidgetMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveFileChooserWidgetMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveFileChooserWidgetMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveFileChooserWidgetMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveFileChooserWidgetMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveFileChooserWidgetMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveFileChooserWidgetMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveFileChooserWidgetMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileChooserWidgetMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveFileChooserWidgetMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveFileChooserWidgetMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveFileChooserWidgetMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveFileChooserWidgetMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveFileChooserWidgetMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveFileChooserWidgetMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveFileChooserWidgetMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveFileChooserWidgetMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileChooserWidgetMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileChooserWidgetMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveFileChooserWidgetMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveFileChooserWidgetMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveFileChooserWidgetMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveFileChooserWidgetMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveFileChooserWidgetMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveFileChooserWidgetMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveFileChooserWidgetMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileChooserWidgetMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileChooserWidgetMethod "removeChoice" o = Gtk.FileChooser.FileChooserRemoveChoiceMethodInfo
    ResolveFileChooserWidgetMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveFileChooserWidgetMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveFileChooserWidgetMethod "removeFilter" o = Gtk.FileChooser.FileChooserRemoveFilterMethodInfo
    ResolveFileChooserWidgetMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveFileChooserWidgetMethod "removeShortcutFolder" o = Gtk.FileChooser.FileChooserRemoveShortcutFolderMethodInfo
    ResolveFileChooserWidgetMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveFileChooserWidgetMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveFileChooserWidgetMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveFileChooserWidgetMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveFileChooserWidgetMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileChooserWidgetMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveFileChooserWidgetMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveFileChooserWidgetMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveFileChooserWidgetMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveFileChooserWidgetMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileChooserWidgetMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileChooserWidgetMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileChooserWidgetMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveFileChooserWidgetMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveFileChooserWidgetMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveFileChooserWidgetMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveFileChooserWidgetMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveFileChooserWidgetMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileChooserWidgetMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveFileChooserWidgetMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveFileChooserWidgetMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveFileChooserWidgetMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveFileChooserWidgetMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveFileChooserWidgetMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveFileChooserWidgetMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileChooserWidgetMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveFileChooserWidgetMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveFileChooserWidgetMethod "getAction" o = Gtk.FileChooser.FileChooserGetActionMethodInfo
    ResolveFileChooserWidgetMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveFileChooserWidgetMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveFileChooserWidgetMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveFileChooserWidgetMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveFileChooserWidgetMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveFileChooserWidgetMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveFileChooserWidgetMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveFileChooserWidgetMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveFileChooserWidgetMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveFileChooserWidgetMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveFileChooserWidgetMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveFileChooserWidgetMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveFileChooserWidgetMethod "getChoice" o = Gtk.FileChooser.FileChooserGetChoiceMethodInfo
    ResolveFileChooserWidgetMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveFileChooserWidgetMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveFileChooserWidgetMethod "getCreateFolders" o = Gtk.FileChooser.FileChooserGetCreateFoldersMethodInfo
    ResolveFileChooserWidgetMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveFileChooserWidgetMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveFileChooserWidgetMethod "getCurrentFolder" o = Gtk.FileChooser.FileChooserGetCurrentFolderMethodInfo
    ResolveFileChooserWidgetMethod "getCurrentName" o = Gtk.FileChooser.FileChooserGetCurrentNameMethodInfo
    ResolveFileChooserWidgetMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveFileChooserWidgetMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileChooserWidgetMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveFileChooserWidgetMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveFileChooserWidgetMethod "getFile" o = Gtk.FileChooser.FileChooserGetFileMethodInfo
    ResolveFileChooserWidgetMethod "getFiles" o = Gtk.FileChooser.FileChooserGetFilesMethodInfo
    ResolveFileChooserWidgetMethod "getFilter" o = Gtk.FileChooser.FileChooserGetFilterMethodInfo
    ResolveFileChooserWidgetMethod "getFilters" o = Gtk.FileChooser.FileChooserGetFiltersMethodInfo
    ResolveFileChooserWidgetMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveFileChooserWidgetMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveFileChooserWidgetMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveFileChooserWidgetMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveFileChooserWidgetMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveFileChooserWidgetMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveFileChooserWidgetMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveFileChooserWidgetMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveFileChooserWidgetMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveFileChooserWidgetMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveFileChooserWidgetMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveFileChooserWidgetMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveFileChooserWidgetMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveFileChooserWidgetMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveFileChooserWidgetMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveFileChooserWidgetMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveFileChooserWidgetMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveFileChooserWidgetMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveFileChooserWidgetMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveFileChooserWidgetMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveFileChooserWidgetMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveFileChooserWidgetMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveFileChooserWidgetMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveFileChooserWidgetMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveFileChooserWidgetMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveFileChooserWidgetMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveFileChooserWidgetMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveFileChooserWidgetMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveFileChooserWidgetMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveFileChooserWidgetMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveFileChooserWidgetMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveFileChooserWidgetMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveFileChooserWidgetMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveFileChooserWidgetMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileChooserWidgetMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileChooserWidgetMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveFileChooserWidgetMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveFileChooserWidgetMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveFileChooserWidgetMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveFileChooserWidgetMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveFileChooserWidgetMethod "getSelectMultiple" o = Gtk.FileChooser.FileChooserGetSelectMultipleMethodInfo
    ResolveFileChooserWidgetMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveFileChooserWidgetMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveFileChooserWidgetMethod "getShortcutFolders" o = Gtk.FileChooser.FileChooserGetShortcutFoldersMethodInfo
    ResolveFileChooserWidgetMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveFileChooserWidgetMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveFileChooserWidgetMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveFileChooserWidgetMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveFileChooserWidgetMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveFileChooserWidgetMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveFileChooserWidgetMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveFileChooserWidgetMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveFileChooserWidgetMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveFileChooserWidgetMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveFileChooserWidgetMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveFileChooserWidgetMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveFileChooserWidgetMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveFileChooserWidgetMethod "setAction" o = Gtk.FileChooser.FileChooserSetActionMethodInfo
    ResolveFileChooserWidgetMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveFileChooserWidgetMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveFileChooserWidgetMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveFileChooserWidgetMethod "setChoice" o = Gtk.FileChooser.FileChooserSetChoiceMethodInfo
    ResolveFileChooserWidgetMethod "setCreateFolders" o = Gtk.FileChooser.FileChooserSetCreateFoldersMethodInfo
    ResolveFileChooserWidgetMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveFileChooserWidgetMethod "setCurrentFolder" o = Gtk.FileChooser.FileChooserSetCurrentFolderMethodInfo
    ResolveFileChooserWidgetMethod "setCurrentName" o = Gtk.FileChooser.FileChooserSetCurrentNameMethodInfo
    ResolveFileChooserWidgetMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveFileChooserWidgetMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveFileChooserWidgetMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileChooserWidgetMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileChooserWidgetMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveFileChooserWidgetMethod "setFile" o = Gtk.FileChooser.FileChooserSetFileMethodInfo
    ResolveFileChooserWidgetMethod "setFilter" o = Gtk.FileChooser.FileChooserSetFilterMethodInfo
    ResolveFileChooserWidgetMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveFileChooserWidgetMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveFileChooserWidgetMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveFileChooserWidgetMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveFileChooserWidgetMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveFileChooserWidgetMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveFileChooserWidgetMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveFileChooserWidgetMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveFileChooserWidgetMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveFileChooserWidgetMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveFileChooserWidgetMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveFileChooserWidgetMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveFileChooserWidgetMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveFileChooserWidgetMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveFileChooserWidgetMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveFileChooserWidgetMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveFileChooserWidgetMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveFileChooserWidgetMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveFileChooserWidgetMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveFileChooserWidgetMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileChooserWidgetMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveFileChooserWidgetMethod "setSelectMultiple" o = Gtk.FileChooser.FileChooserSetSelectMultipleMethodInfo
    ResolveFileChooserWidgetMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveFileChooserWidgetMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveFileChooserWidgetMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveFileChooserWidgetMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveFileChooserWidgetMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveFileChooserWidgetMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveFileChooserWidgetMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveFileChooserWidgetMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveFileChooserWidgetMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveFileChooserWidgetMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileChooserWidgetMethod t FileChooserWidget, O.OverloadedMethod info FileChooserWidget p) => OL.IsLabel t (FileChooserWidget -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileChooserWidgetMethod t FileChooserWidget, O.OverloadedMethod info FileChooserWidget p, R.HasField t FileChooserWidget p) => R.HasField t FileChooserWidget p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileChooserWidgetMethod t FileChooserWidget, O.OverloadedMethodInfo info FileChooserWidget) => OL.IsLabel t (O.MethodProxy info FileChooserWidget) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal FileChooserWidget::desktop-folder
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser show the user\'s Desktop
-- folder in the file list.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>D\<\/kbd>.
type FileChooserWidgetDesktopFolderCallback =
    IO ()

type C_FileChooserWidgetDesktopFolderCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetDesktopFolderCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetDesktopFolderCallback :: C_FileChooserWidgetDesktopFolderCallback -> IO (FunPtr C_FileChooserWidgetDesktopFolderCallback)

wrap_FileChooserWidgetDesktopFolderCallback :: 
    GObject a => (a -> FileChooserWidgetDesktopFolderCallback) ->
    C_FileChooserWidgetDesktopFolderCallback
wrap_FileChooserWidgetDesktopFolderCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [desktopFolder](#signal:desktopFolder) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #desktopFolder callback
-- @
-- 
-- 
onFileChooserWidgetDesktopFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetDesktopFolderCallback) -> m SignalHandlerId
onFileChooserWidgetDesktopFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetDesktopFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetDesktopFolderCallback wrapped'
    connectSignalFunPtr obj "desktop-folder" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [desktopFolder](#signal:desktopFolder) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #desktopFolder callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetDesktopFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetDesktopFolderCallback) -> m SignalHandlerId
afterFileChooserWidgetDesktopFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetDesktopFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetDesktopFolderCallback wrapped'
    connectSignalFunPtr obj "desktop-folder" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetDesktopFolderSignalInfo
instance SignalInfo FileChooserWidgetDesktopFolderSignalInfo where
    type HaskellCallbackType FileChooserWidgetDesktopFolderSignalInfo = FileChooserWidgetDesktopFolderCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetDesktopFolderCallback cb
        cb'' <- mk_FileChooserWidgetDesktopFolderCallback cb'
        connectSignalFunPtr obj "desktop-folder" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::desktop-folder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:desktopFolder"})

#endif

-- signal FileChooserWidget::down-folder
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser go to a child of the
-- current folder in the file hierarchy. The subfolder that will
-- be used is displayed in the path bar widget of the file chooser.
-- For example, if the path bar is showing \"\/foo\/bar\/baz\", with bar
-- currently displayed, then this will cause the file chooser to
-- switch to the \"baz\" subfolder.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>Down\<\/kbd>.
type FileChooserWidgetDownFolderCallback =
    IO ()

type C_FileChooserWidgetDownFolderCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetDownFolderCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetDownFolderCallback :: C_FileChooserWidgetDownFolderCallback -> IO (FunPtr C_FileChooserWidgetDownFolderCallback)

wrap_FileChooserWidgetDownFolderCallback :: 
    GObject a => (a -> FileChooserWidgetDownFolderCallback) ->
    C_FileChooserWidgetDownFolderCallback
wrap_FileChooserWidgetDownFolderCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [downFolder](#signal:downFolder) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #downFolder callback
-- @
-- 
-- 
onFileChooserWidgetDownFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetDownFolderCallback) -> m SignalHandlerId
onFileChooserWidgetDownFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetDownFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetDownFolderCallback wrapped'
    connectSignalFunPtr obj "down-folder" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [downFolder](#signal:downFolder) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #downFolder callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetDownFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetDownFolderCallback) -> m SignalHandlerId
afterFileChooserWidgetDownFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetDownFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetDownFolderCallback wrapped'
    connectSignalFunPtr obj "down-folder" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetDownFolderSignalInfo
instance SignalInfo FileChooserWidgetDownFolderSignalInfo where
    type HaskellCallbackType FileChooserWidgetDownFolderSignalInfo = FileChooserWidgetDownFolderCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetDownFolderCallback cb
        cb'' <- mk_FileChooserWidgetDownFolderCallback cb'
        connectSignalFunPtr obj "down-folder" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::down-folder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:downFolder"})

#endif

-- signal FileChooserWidget::home-folder
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser show the user\'s home
-- folder in the file list.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>Home\<\/kbd>.
type FileChooserWidgetHomeFolderCallback =
    IO ()

type C_FileChooserWidgetHomeFolderCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetHomeFolderCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetHomeFolderCallback :: C_FileChooserWidgetHomeFolderCallback -> IO (FunPtr C_FileChooserWidgetHomeFolderCallback)

wrap_FileChooserWidgetHomeFolderCallback :: 
    GObject a => (a -> FileChooserWidgetHomeFolderCallback) ->
    C_FileChooserWidgetHomeFolderCallback
wrap_FileChooserWidgetHomeFolderCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [homeFolder](#signal:homeFolder) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #homeFolder callback
-- @
-- 
-- 
onFileChooserWidgetHomeFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetHomeFolderCallback) -> m SignalHandlerId
onFileChooserWidgetHomeFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetHomeFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetHomeFolderCallback wrapped'
    connectSignalFunPtr obj "home-folder" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [homeFolder](#signal:homeFolder) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #homeFolder callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetHomeFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetHomeFolderCallback) -> m SignalHandlerId
afterFileChooserWidgetHomeFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetHomeFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetHomeFolderCallback wrapped'
    connectSignalFunPtr obj "home-folder" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetHomeFolderSignalInfo
instance SignalInfo FileChooserWidgetHomeFolderSignalInfo where
    type HaskellCallbackType FileChooserWidgetHomeFolderSignalInfo = FileChooserWidgetHomeFolderCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetHomeFolderCallback cb
        cb'' <- mk_FileChooserWidgetHomeFolderCallback cb'
        connectSignalFunPtr obj "home-folder" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::home-folder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:homeFolder"})

#endif

-- signal FileChooserWidget::location-popup
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser show a \"Location\" prompt which
-- the user can use to manually type the name of the file he wishes to select.
-- 
-- The default bindings for this signal are \<kbd>Control\<\/kbd>-\<kbd>L\<\/kbd>
-- with a /@path@/ string of \"\" (the empty string). It is also bound to
-- \<kbd>\/\<\/kbd> with a /@path@/ string of \"@\/@\" (a slash):  this lets you
-- type @\/@ and immediately type a path name. On Unix systems, this is
-- bound to \<kbd>~\<\/kbd> (tilde) with a /@path@/ string of \"~\" itself for
-- access to home directories.
type FileChooserWidgetLocationPopupCallback =
    T.Text
    -- ^ /@path@/: a string that gets put in the text entry for the file name
    -> IO ()

type C_FileChooserWidgetLocationPopupCallback =
    Ptr FileChooserWidget ->                -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetLocationPopupCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetLocationPopupCallback :: C_FileChooserWidgetLocationPopupCallback -> IO (FunPtr C_FileChooserWidgetLocationPopupCallback)

wrap_FileChooserWidgetLocationPopupCallback :: 
    GObject a => (a -> FileChooserWidgetLocationPopupCallback) ->
    C_FileChooserWidgetLocationPopupCallback
wrap_FileChooserWidgetLocationPopupCallback gi'cb gi'selfPtr path _ = do
    path' <- cstringToText path
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  path'


-- | Connect a signal handler for the [locationPopup](#signal:locationPopup) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #locationPopup callback
-- @
-- 
-- 
onFileChooserWidgetLocationPopup :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetLocationPopupCallback) -> m SignalHandlerId
onFileChooserWidgetLocationPopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetLocationPopupCallback wrapped
    wrapped'' <- mk_FileChooserWidgetLocationPopupCallback wrapped'
    connectSignalFunPtr obj "location-popup" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [locationPopup](#signal:locationPopup) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #locationPopup callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetLocationPopup :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetLocationPopupCallback) -> m SignalHandlerId
afterFileChooserWidgetLocationPopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetLocationPopupCallback wrapped
    wrapped'' <- mk_FileChooserWidgetLocationPopupCallback wrapped'
    connectSignalFunPtr obj "location-popup" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetLocationPopupSignalInfo
instance SignalInfo FileChooserWidgetLocationPopupSignalInfo where
    type HaskellCallbackType FileChooserWidgetLocationPopupSignalInfo = FileChooserWidgetLocationPopupCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetLocationPopupCallback cb
        cb'' <- mk_FileChooserWidgetLocationPopupCallback cb'
        connectSignalFunPtr obj "location-popup" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::location-popup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:locationPopup"})

#endif

-- signal FileChooserWidget::location-popup-on-paste
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser show a \"Location\" prompt
-- when the user pastes into a @GtkFileChooserWidget@.
-- 
-- The default binding for this signal is \<kbd>Control\<\/kbd>-\<kbd>V\<\/kbd>.
type FileChooserWidgetLocationPopupOnPasteCallback =
    IO ()

type C_FileChooserWidgetLocationPopupOnPasteCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetLocationPopupOnPasteCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetLocationPopupOnPasteCallback :: C_FileChooserWidgetLocationPopupOnPasteCallback -> IO (FunPtr C_FileChooserWidgetLocationPopupOnPasteCallback)

wrap_FileChooserWidgetLocationPopupOnPasteCallback :: 
    GObject a => (a -> FileChooserWidgetLocationPopupOnPasteCallback) ->
    C_FileChooserWidgetLocationPopupOnPasteCallback
wrap_FileChooserWidgetLocationPopupOnPasteCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [locationPopupOnPaste](#signal:locationPopupOnPaste) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #locationPopupOnPaste callback
-- @
-- 
-- 
onFileChooserWidgetLocationPopupOnPaste :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetLocationPopupOnPasteCallback) -> m SignalHandlerId
onFileChooserWidgetLocationPopupOnPaste obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetLocationPopupOnPasteCallback wrapped
    wrapped'' <- mk_FileChooserWidgetLocationPopupOnPasteCallback wrapped'
    connectSignalFunPtr obj "location-popup-on-paste" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [locationPopupOnPaste](#signal:locationPopupOnPaste) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #locationPopupOnPaste callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetLocationPopupOnPaste :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetLocationPopupOnPasteCallback) -> m SignalHandlerId
afterFileChooserWidgetLocationPopupOnPaste obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetLocationPopupOnPasteCallback wrapped
    wrapped'' <- mk_FileChooserWidgetLocationPopupOnPasteCallback wrapped'
    connectSignalFunPtr obj "location-popup-on-paste" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetLocationPopupOnPasteSignalInfo
instance SignalInfo FileChooserWidgetLocationPopupOnPasteSignalInfo where
    type HaskellCallbackType FileChooserWidgetLocationPopupOnPasteSignalInfo = FileChooserWidgetLocationPopupOnPasteCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetLocationPopupOnPasteCallback cb
        cb'' <- mk_FileChooserWidgetLocationPopupOnPasteCallback cb'
        connectSignalFunPtr obj "location-popup-on-paste" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::location-popup-on-paste"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:locationPopupOnPaste"})

#endif

-- signal FileChooserWidget::location-toggle-popup
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to toggle the visibility of a \"Location\" prompt
-- which the user can use to manually type the name of the file
-- he wishes to select.
-- 
-- The default binding for this signal is \<kbd>Control\<\/kbd>-\<kbd>L\<\/kbd>.
type FileChooserWidgetLocationTogglePopupCallback =
    IO ()

type C_FileChooserWidgetLocationTogglePopupCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetLocationTogglePopupCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetLocationTogglePopupCallback :: C_FileChooserWidgetLocationTogglePopupCallback -> IO (FunPtr C_FileChooserWidgetLocationTogglePopupCallback)

wrap_FileChooserWidgetLocationTogglePopupCallback :: 
    GObject a => (a -> FileChooserWidgetLocationTogglePopupCallback) ->
    C_FileChooserWidgetLocationTogglePopupCallback
wrap_FileChooserWidgetLocationTogglePopupCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [locationTogglePopup](#signal:locationTogglePopup) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #locationTogglePopup callback
-- @
-- 
-- 
onFileChooserWidgetLocationTogglePopup :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetLocationTogglePopupCallback) -> m SignalHandlerId
onFileChooserWidgetLocationTogglePopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetLocationTogglePopupCallback wrapped
    wrapped'' <- mk_FileChooserWidgetLocationTogglePopupCallback wrapped'
    connectSignalFunPtr obj "location-toggle-popup" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [locationTogglePopup](#signal:locationTogglePopup) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #locationTogglePopup callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetLocationTogglePopup :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetLocationTogglePopupCallback) -> m SignalHandlerId
afterFileChooserWidgetLocationTogglePopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetLocationTogglePopupCallback wrapped
    wrapped'' <- mk_FileChooserWidgetLocationTogglePopupCallback wrapped'
    connectSignalFunPtr obj "location-toggle-popup" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetLocationTogglePopupSignalInfo
instance SignalInfo FileChooserWidgetLocationTogglePopupSignalInfo where
    type HaskellCallbackType FileChooserWidgetLocationTogglePopupSignalInfo = FileChooserWidgetLocationTogglePopupCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetLocationTogglePopupCallback cb
        cb'' <- mk_FileChooserWidgetLocationTogglePopupCallback cb'
        connectSignalFunPtr obj "location-toggle-popup" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::location-toggle-popup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:locationTogglePopup"})

#endif

-- signal FileChooserWidget::places-shortcut
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to move the focus to the places sidebar.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>P\<\/kbd>.
type FileChooserWidgetPlacesShortcutCallback =
    IO ()

type C_FileChooserWidgetPlacesShortcutCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetPlacesShortcutCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetPlacesShortcutCallback :: C_FileChooserWidgetPlacesShortcutCallback -> IO (FunPtr C_FileChooserWidgetPlacesShortcutCallback)

wrap_FileChooserWidgetPlacesShortcutCallback :: 
    GObject a => (a -> FileChooserWidgetPlacesShortcutCallback) ->
    C_FileChooserWidgetPlacesShortcutCallback
wrap_FileChooserWidgetPlacesShortcutCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [placesShortcut](#signal:placesShortcut) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #placesShortcut callback
-- @
-- 
-- 
onFileChooserWidgetPlacesShortcut :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetPlacesShortcutCallback) -> m SignalHandlerId
onFileChooserWidgetPlacesShortcut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetPlacesShortcutCallback wrapped
    wrapped'' <- mk_FileChooserWidgetPlacesShortcutCallback wrapped'
    connectSignalFunPtr obj "places-shortcut" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [placesShortcut](#signal:placesShortcut) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #placesShortcut callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetPlacesShortcut :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetPlacesShortcutCallback) -> m SignalHandlerId
afterFileChooserWidgetPlacesShortcut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetPlacesShortcutCallback wrapped
    wrapped'' <- mk_FileChooserWidgetPlacesShortcutCallback wrapped'
    connectSignalFunPtr obj "places-shortcut" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetPlacesShortcutSignalInfo
instance SignalInfo FileChooserWidgetPlacesShortcutSignalInfo where
    type HaskellCallbackType FileChooserWidgetPlacesShortcutSignalInfo = FileChooserWidgetPlacesShortcutCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetPlacesShortcutCallback cb
        cb'' <- mk_FileChooserWidgetPlacesShortcutCallback cb'
        connectSignalFunPtr obj "places-shortcut" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::places-shortcut"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:placesShortcut"})

#endif

-- signal FileChooserWidget::quick-bookmark
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser switch to the bookmark
-- specified in the /@bookmarkIndex@/ parameter. For example, if
-- you have three bookmarks, you can pass 0, 1, 2 to this signal
-- to switch to each of them, respectively.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>1\<\/kbd>,
-- \<kbd>Alt\<\/kbd>-\<kbd>2\<\/kbd>, etc. until \<kbd>Alt\<\/kbd>-\<kbd>0\<\/kbd>.
-- Note that in the default binding, that \<kbd>Alt\<\/kbd>-\<kbd>1\<\/kbd> is
-- actually defined to switch to the bookmark at index 0, and so on
-- successively.
type FileChooserWidgetQuickBookmarkCallback =
    Int32
    -- ^ /@bookmarkIndex@/: the number of the bookmark to switch to
    -> IO ()

type C_FileChooserWidgetQuickBookmarkCallback =
    Ptr FileChooserWidget ->                -- object
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetQuickBookmarkCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetQuickBookmarkCallback :: C_FileChooserWidgetQuickBookmarkCallback -> IO (FunPtr C_FileChooserWidgetQuickBookmarkCallback)

wrap_FileChooserWidgetQuickBookmarkCallback :: 
    GObject a => (a -> FileChooserWidgetQuickBookmarkCallback) ->
    C_FileChooserWidgetQuickBookmarkCallback
wrap_FileChooserWidgetQuickBookmarkCallback gi'cb gi'selfPtr bookmarkIndex _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  bookmarkIndex


-- | Connect a signal handler for the [quickBookmark](#signal:quickBookmark) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #quickBookmark callback
-- @
-- 
-- 
onFileChooserWidgetQuickBookmark :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetQuickBookmarkCallback) -> m SignalHandlerId
onFileChooserWidgetQuickBookmark obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetQuickBookmarkCallback wrapped
    wrapped'' <- mk_FileChooserWidgetQuickBookmarkCallback wrapped'
    connectSignalFunPtr obj "quick-bookmark" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [quickBookmark](#signal:quickBookmark) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #quickBookmark callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetQuickBookmark :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetQuickBookmarkCallback) -> m SignalHandlerId
afterFileChooserWidgetQuickBookmark obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetQuickBookmarkCallback wrapped
    wrapped'' <- mk_FileChooserWidgetQuickBookmarkCallback wrapped'
    connectSignalFunPtr obj "quick-bookmark" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetQuickBookmarkSignalInfo
instance SignalInfo FileChooserWidgetQuickBookmarkSignalInfo where
    type HaskellCallbackType FileChooserWidgetQuickBookmarkSignalInfo = FileChooserWidgetQuickBookmarkCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetQuickBookmarkCallback cb
        cb'' <- mk_FileChooserWidgetQuickBookmarkCallback cb'
        connectSignalFunPtr obj "quick-bookmark" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::quick-bookmark"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:quickBookmark"})

#endif

-- signal FileChooserWidget::recent-shortcut
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser show the Recent location.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>R\<\/kbd>.
type FileChooserWidgetRecentShortcutCallback =
    IO ()

type C_FileChooserWidgetRecentShortcutCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetRecentShortcutCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetRecentShortcutCallback :: C_FileChooserWidgetRecentShortcutCallback -> IO (FunPtr C_FileChooserWidgetRecentShortcutCallback)

wrap_FileChooserWidgetRecentShortcutCallback :: 
    GObject a => (a -> FileChooserWidgetRecentShortcutCallback) ->
    C_FileChooserWidgetRecentShortcutCallback
wrap_FileChooserWidgetRecentShortcutCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [recentShortcut](#signal:recentShortcut) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #recentShortcut callback
-- @
-- 
-- 
onFileChooserWidgetRecentShortcut :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetRecentShortcutCallback) -> m SignalHandlerId
onFileChooserWidgetRecentShortcut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetRecentShortcutCallback wrapped
    wrapped'' <- mk_FileChooserWidgetRecentShortcutCallback wrapped'
    connectSignalFunPtr obj "recent-shortcut" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [recentShortcut](#signal:recentShortcut) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #recentShortcut callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetRecentShortcut :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetRecentShortcutCallback) -> m SignalHandlerId
afterFileChooserWidgetRecentShortcut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetRecentShortcutCallback wrapped
    wrapped'' <- mk_FileChooserWidgetRecentShortcutCallback wrapped'
    connectSignalFunPtr obj "recent-shortcut" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetRecentShortcutSignalInfo
instance SignalInfo FileChooserWidgetRecentShortcutSignalInfo where
    type HaskellCallbackType FileChooserWidgetRecentShortcutSignalInfo = FileChooserWidgetRecentShortcutCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetRecentShortcutCallback cb
        cb'' <- mk_FileChooserWidgetRecentShortcutCallback cb'
        connectSignalFunPtr obj "recent-shortcut" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::recent-shortcut"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:recentShortcut"})

#endif

-- signal FileChooserWidget::search-shortcut
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser show the search entry.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>S\<\/kbd>.
type FileChooserWidgetSearchShortcutCallback =
    IO ()

type C_FileChooserWidgetSearchShortcutCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetSearchShortcutCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetSearchShortcutCallback :: C_FileChooserWidgetSearchShortcutCallback -> IO (FunPtr C_FileChooserWidgetSearchShortcutCallback)

wrap_FileChooserWidgetSearchShortcutCallback :: 
    GObject a => (a -> FileChooserWidgetSearchShortcutCallback) ->
    C_FileChooserWidgetSearchShortcutCallback
wrap_FileChooserWidgetSearchShortcutCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [searchShortcut](#signal:searchShortcut) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #searchShortcut callback
-- @
-- 
-- 
onFileChooserWidgetSearchShortcut :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetSearchShortcutCallback) -> m SignalHandlerId
onFileChooserWidgetSearchShortcut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetSearchShortcutCallback wrapped
    wrapped'' <- mk_FileChooserWidgetSearchShortcutCallback wrapped'
    connectSignalFunPtr obj "search-shortcut" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [searchShortcut](#signal:searchShortcut) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #searchShortcut callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetSearchShortcut :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetSearchShortcutCallback) -> m SignalHandlerId
afterFileChooserWidgetSearchShortcut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetSearchShortcutCallback wrapped
    wrapped'' <- mk_FileChooserWidgetSearchShortcutCallback wrapped'
    connectSignalFunPtr obj "search-shortcut" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetSearchShortcutSignalInfo
instance SignalInfo FileChooserWidgetSearchShortcutSignalInfo where
    type HaskellCallbackType FileChooserWidgetSearchShortcutSignalInfo = FileChooserWidgetSearchShortcutCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetSearchShortcutCallback cb
        cb'' <- mk_FileChooserWidgetSearchShortcutCallback cb'
        connectSignalFunPtr obj "search-shortcut" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::search-shortcut"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:searchShortcut"})

#endif

-- signal FileChooserWidget::show-hidden
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser display hidden files.
-- 
-- The default binding for this signal is \<kbd>Control\<\/kbd>-\<kbd>H\<\/kbd>.
type FileChooserWidgetShowHiddenCallback =
    IO ()

type C_FileChooserWidgetShowHiddenCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetShowHiddenCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetShowHiddenCallback :: C_FileChooserWidgetShowHiddenCallback -> IO (FunPtr C_FileChooserWidgetShowHiddenCallback)

wrap_FileChooserWidgetShowHiddenCallback :: 
    GObject a => (a -> FileChooserWidgetShowHiddenCallback) ->
    C_FileChooserWidgetShowHiddenCallback
wrap_FileChooserWidgetShowHiddenCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [showHidden](#signal:showHidden) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #showHidden callback
-- @
-- 
-- 
onFileChooserWidgetShowHidden :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetShowHiddenCallback) -> m SignalHandlerId
onFileChooserWidgetShowHidden obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetShowHiddenCallback wrapped
    wrapped'' <- mk_FileChooserWidgetShowHiddenCallback wrapped'
    connectSignalFunPtr obj "show-hidden" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [showHidden](#signal:showHidden) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #showHidden callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetShowHidden :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetShowHiddenCallback) -> m SignalHandlerId
afterFileChooserWidgetShowHidden obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetShowHiddenCallback wrapped
    wrapped'' <- mk_FileChooserWidgetShowHiddenCallback wrapped'
    connectSignalFunPtr obj "show-hidden" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetShowHiddenSignalInfo
instance SignalInfo FileChooserWidgetShowHiddenSignalInfo where
    type HaskellCallbackType FileChooserWidgetShowHiddenSignalInfo = FileChooserWidgetShowHiddenCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetShowHiddenCallback cb
        cb'' <- mk_FileChooserWidgetShowHiddenCallback cb'
        connectSignalFunPtr obj "show-hidden" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::show-hidden"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:showHidden"})

#endif

-- signal FileChooserWidget::up-folder
-- | Emitted when the user asks for it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This is used to make the file chooser go to the parent
-- of the current folder in the file hierarchy.
-- 
-- The default binding for this signal is \<kbd>Alt\<\/kbd>-\<kbd>Up\<\/kbd>.
type FileChooserWidgetUpFolderCallback =
    IO ()

type C_FileChooserWidgetUpFolderCallback =
    Ptr FileChooserWidget ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FileChooserWidgetUpFolderCallback`.
foreign import ccall "wrapper"
    mk_FileChooserWidgetUpFolderCallback :: C_FileChooserWidgetUpFolderCallback -> IO (FunPtr C_FileChooserWidgetUpFolderCallback)

wrap_FileChooserWidgetUpFolderCallback :: 
    GObject a => (a -> FileChooserWidgetUpFolderCallback) ->
    C_FileChooserWidgetUpFolderCallback
wrap_FileChooserWidgetUpFolderCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [upFolder](#signal:upFolder) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' fileChooserWidget #upFolder callback
-- @
-- 
-- 
onFileChooserWidgetUpFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetUpFolderCallback) -> m SignalHandlerId
onFileChooserWidgetUpFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetUpFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetUpFolderCallback wrapped'
    connectSignalFunPtr obj "up-folder" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [upFolder](#signal:upFolder) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' fileChooserWidget #upFolder callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFileChooserWidgetUpFolder :: (IsFileChooserWidget a, MonadIO m) => a -> ((?self :: a) => FileChooserWidgetUpFolderCallback) -> m SignalHandlerId
afterFileChooserWidgetUpFolder obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FileChooserWidgetUpFolderCallback wrapped
    wrapped'' <- mk_FileChooserWidgetUpFolderCallback wrapped'
    connectSignalFunPtr obj "up-folder" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetUpFolderSignalInfo
instance SignalInfo FileChooserWidgetUpFolderSignalInfo where
    type HaskellCallbackType FileChooserWidgetUpFolderSignalInfo = FileChooserWidgetUpFolderCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FileChooserWidgetUpFolderCallback cb
        cb'' <- mk_FileChooserWidgetUpFolderCallback cb'
        connectSignalFunPtr obj "up-folder" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget::up-folder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:signal:upFolder"})

#endif

-- VVV Prop "search-mode"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@search-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooserWidget #searchMode
-- @
getFileChooserWidgetSearchMode :: (MonadIO m, IsFileChooserWidget o) => o -> m Bool
getFileChooserWidgetSearchMode obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "search-mode"

-- | Set the value of the “@search-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileChooserWidget [ #searchMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileChooserWidgetSearchMode :: (MonadIO m, IsFileChooserWidget o) => o -> Bool -> m ()
setFileChooserWidgetSearchMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "search-mode" val

-- | Construct a `GValueConstruct` with valid value for the “@search-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileChooserWidgetSearchMode :: (IsFileChooserWidget o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFileChooserWidgetSearchMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "search-mode" val

#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetSearchModePropertyInfo
instance AttrInfo FileChooserWidgetSearchModePropertyInfo where
    type AttrAllowedOps FileChooserWidgetSearchModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FileChooserWidgetSearchModePropertyInfo = IsFileChooserWidget
    type AttrSetTypeConstraint FileChooserWidgetSearchModePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FileChooserWidgetSearchModePropertyInfo = (~) Bool
    type AttrTransferType FileChooserWidgetSearchModePropertyInfo = Bool
    type AttrGetType FileChooserWidgetSearchModePropertyInfo = Bool
    type AttrLabel FileChooserWidgetSearchModePropertyInfo = "search-mode"
    type AttrOrigin FileChooserWidgetSearchModePropertyInfo = FileChooserWidget
    attrGet = getFileChooserWidgetSearchMode
    attrSet = setFileChooserWidgetSearchMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructFileChooserWidgetSearchMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget.searchMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:attr:searchMode"
        })
#endif

-- VVV Prop "show-time"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@show-time@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooserWidget #showTime
-- @
getFileChooserWidgetShowTime :: (MonadIO m, IsFileChooserWidget o) => o -> m Bool
getFileChooserWidgetShowTime obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-time"

#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetShowTimePropertyInfo
instance AttrInfo FileChooserWidgetShowTimePropertyInfo where
    type AttrAllowedOps FileChooserWidgetShowTimePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint FileChooserWidgetShowTimePropertyInfo = IsFileChooserWidget
    type AttrSetTypeConstraint FileChooserWidgetShowTimePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FileChooserWidgetShowTimePropertyInfo = (~) ()
    type AttrTransferType FileChooserWidgetShowTimePropertyInfo = ()
    type AttrGetType FileChooserWidgetShowTimePropertyInfo = Bool
    type AttrLabel FileChooserWidgetShowTimePropertyInfo = "show-time"
    type AttrOrigin FileChooserWidgetShowTimePropertyInfo = FileChooserWidget
    attrGet = getFileChooserWidgetShowTime
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget.showTime"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:attr:showTime"
        })
#endif

-- VVV Prop "subtitle"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@subtitle@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileChooserWidget #subtitle
-- @
getFileChooserWidgetSubtitle :: (MonadIO m, IsFileChooserWidget o) => o -> m (Maybe T.Text)
getFileChooserWidgetSubtitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "subtitle"

#if defined(ENABLE_OVERLOADING)
data FileChooserWidgetSubtitlePropertyInfo
instance AttrInfo FileChooserWidgetSubtitlePropertyInfo where
    type AttrAllowedOps FileChooserWidgetSubtitlePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FileChooserWidgetSubtitlePropertyInfo = IsFileChooserWidget
    type AttrSetTypeConstraint FileChooserWidgetSubtitlePropertyInfo = (~) ()
    type AttrTransferTypeConstraint FileChooserWidgetSubtitlePropertyInfo = (~) ()
    type AttrTransferType FileChooserWidgetSubtitlePropertyInfo = ()
    type AttrGetType FileChooserWidgetSubtitlePropertyInfo = (Maybe T.Text)
    type AttrLabel FileChooserWidgetSubtitlePropertyInfo = "subtitle"
    type AttrOrigin FileChooserWidgetSubtitlePropertyInfo = FileChooserWidget
    attrGet = getFileChooserWidgetSubtitle
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FileChooserWidget.subtitle"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-FileChooserWidget.html#g:attr:subtitle"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileChooserWidget
type instance O.AttributeList FileChooserWidget = FileChooserWidgetAttributeList
type FileChooserWidgetAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("action", Gtk.FileChooser.FileChooserActionPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("createFolders", Gtk.FileChooser.FileChooserCreateFoldersPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("filter", Gtk.FileChooser.FileChooserFilterPropertyInfo), '("filters", Gtk.FileChooser.FileChooserFiltersPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("searchMode", FileChooserWidgetSearchModePropertyInfo), '("selectMultiple", Gtk.FileChooser.FileChooserSelectMultiplePropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("shortcutFolders", Gtk.FileChooser.FileChooserShortcutFoldersPropertyInfo), '("showTime", FileChooserWidgetShowTimePropertyInfo), '("subtitle", FileChooserWidgetSubtitlePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fileChooserWidgetSearchMode :: AttrLabelProxy "searchMode"
fileChooserWidgetSearchMode = AttrLabelProxy

fileChooserWidgetShowTime :: AttrLabelProxy "showTime"
fileChooserWidgetShowTime = AttrLabelProxy

fileChooserWidgetSubtitle :: AttrLabelProxy "subtitle"
fileChooserWidgetSubtitle = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileChooserWidget = FileChooserWidgetSignalList
type FileChooserWidgetSignalList = ('[ '("desktopFolder", FileChooserWidgetDesktopFolderSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("downFolder", FileChooserWidgetDownFolderSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("homeFolder", FileChooserWidgetHomeFolderSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("locationPopup", FileChooserWidgetLocationPopupSignalInfo), '("locationPopupOnPaste", FileChooserWidgetLocationPopupOnPasteSignalInfo), '("locationTogglePopup", FileChooserWidgetLocationTogglePopupSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("placesShortcut", FileChooserWidgetPlacesShortcutSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("quickBookmark", FileChooserWidgetQuickBookmarkSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("recentShortcut", FileChooserWidgetRecentShortcutSignalInfo), '("searchShortcut", FileChooserWidgetSearchShortcutSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("showHidden", FileChooserWidgetShowHiddenSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo), '("upFolder", FileChooserWidgetUpFolderSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FileChooserWidget::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FileChooserAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Open or save mode for the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "FileChooserWidget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_file_chooser_widget_new" gtk_file_chooser_widget_new :: 
    CUInt ->                                -- action : TInterface (Name {namespace = "Gtk", name = "FileChooserAction"})
    IO (Ptr FileChooserWidget)

{-# DEPRECATED fileChooserWidgetNew ["(Since version 4.10)","Direct use of @GtkFileChooserWidget@ is deprecated"] #-}
-- | Creates a new @GtkFileChooserWidget@.
-- 
-- This is a file chooser widget that can be embedded in custom
-- windows, and it is the same widget that is used by
-- @GtkFileChooserDialog@.
fileChooserWidgetNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gtk.Enums.FileChooserAction
    -- ^ /@action@/: Open or save mode for the widget
    -> m FileChooserWidget
    -- ^ __Returns:__ a new @GtkFileChooserWidget@
fileChooserWidgetNew action = liftIO $ do
    let action' = (fromIntegral . fromEnum) action
    result <- gtk_file_chooser_widget_new action'
    checkUnexpectedReturnNULL "fileChooserWidgetNew" result
    result' <- (newObject FileChooserWidget) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


