{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Allows the user to reveal or conceal a child widget.
-- 
-- \<picture>
--   \<source srcset=\"expander-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkExpander\" src=\"expander.png\">
-- \<\/picture>
-- 
-- This is similar to the triangles used in a @GtkTreeView@.
-- 
-- Normally you use an expander as you would use a frame; you create
-- the child widget and use 'GI.Gtk.Objects.Expander.expanderSetChild' to add it
-- to the expander. When the expander is toggled, it will take care of
-- showing and hiding the child automatically.
-- 
-- = Special Usage
-- 
-- There are situations in which you may prefer to show and hide the
-- expanded widget yourself, such as when you want to actually create
-- the widget at expansion time. In this case, create a @GtkExpander@
-- but do not add a child to it. The expander widget has an
-- [Expander:expanded]("GI.Gtk.Objects.Expander#g:attr:expanded") property which can be used to
-- monitor its expansion state. You should watch this property with
-- a signal connection as follows:
-- 
-- 
-- === /c code/
-- >static void
-- >expander_callback (GObject    *object,
-- >                   GParamSpec *param_spec,
-- >                   gpointer    user_data)
-- >{
-- >  GtkExpander *expander;
-- >
-- >  expander = GTK_EXPANDER (object);
-- >
-- >  if (gtk_expander_get_expanded (expander))
-- >    {
-- >      // Show or create widgets
-- >    }
-- >  else
-- >    {
-- >      // Hide or destroy widgets
-- >    }
-- >}
-- >
-- >static void
-- >create_expander (void)
-- >{
-- >  GtkWidget *expander = gtk_expander_new_with_mnemonic ("_More Options");
-- >  g_signal_connect (expander, "notify::expanded",
-- >                    G_CALLBACK (expander_callback), NULL);
-- >
-- >  // ...
-- >}
-- 
-- 
-- = GtkExpander as GtkBuildable
-- 
-- The @GtkExpander@ implementation of the @GtkBuildable@ interface supports
-- placing a child in the label position by specifying “label” as the
-- “type” attribute of a @\<child>@ element. A normal content child can be
-- specified without specifying a @\<child>@ type attribute.
-- 
-- An example of a UI definition fragment with GtkExpander:
-- 
-- 
-- === /xml code/
-- ><object class="GtkExpander">
-- >  <child type="label">
-- >    <object class="GtkLabel" id="expander-label"/>
-- >  </child>
-- >  <child>
-- >    <object class="GtkEntry" id="expander-content"/>
-- >  </child>
-- ></object>
-- 
-- 
-- = CSS nodes
-- 
-- >expander-widget
-- >╰── box
-- >    ├── title
-- >    │   ├── expander
-- >    │   ╰── <label widget>
-- >    ╰── <child>
-- 
-- 
-- @GtkExpander@ has a main node @expander-widget@, and subnode @box@ containing
-- the title and child widget. The box subnode @title@ contains node @expander@,
-- i.e. the expand\/collapse arrow; then the label widget if any. The arrow of an
-- expander that is showing its child gets the @:checked@ pseudoclass set on it.
-- 
-- = Accessibility
-- 
-- @GtkExpander@ uses the [enum/@gtk@/.AccessibleRole.button] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Expander
    ( 

-- * Exported types
    Expander(..)                            ,
    IsExpander                              ,
    toExpander                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Expander#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getExpanded]("GI.Gtk.Objects.Expander#g:method:getExpanded"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLabel]("GI.Gtk.Objects.Expander#g:method:getLabel"), [getLabelWidget]("GI.Gtk.Objects.Expander#g:method:getLabelWidget"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizeToplevel]("GI.Gtk.Objects.Expander#g:method:getResizeToplevel"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseMarkup]("GI.Gtk.Objects.Expander#g:method:getUseMarkup"), [getUseUnderline]("GI.Gtk.Objects.Expander#g:method:getUseUnderline"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Expander#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setExpanded]("GI.Gtk.Objects.Expander#g:method:setExpanded"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLabel]("GI.Gtk.Objects.Expander#g:method:setLabel"), [setLabelWidget]("GI.Gtk.Objects.Expander#g:method:setLabelWidget"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizeToplevel]("GI.Gtk.Objects.Expander#g:method:setResizeToplevel"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseMarkup]("GI.Gtk.Objects.Expander#g:method:setUseMarkup"), [setUseUnderline]("GI.Gtk.Objects.Expander#g:method:setUseUnderline"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveExpanderMethod                   ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ExpanderGetChildMethodInfo              ,
#endif
    expanderGetChild                        ,


-- ** getExpanded #method:getExpanded#

#if defined(ENABLE_OVERLOADING)
    ExpanderGetExpandedMethodInfo           ,
#endif
    expanderGetExpanded                     ,


-- ** getLabel #method:getLabel#

#if defined(ENABLE_OVERLOADING)
    ExpanderGetLabelMethodInfo              ,
#endif
    expanderGetLabel                        ,


-- ** getLabelWidget #method:getLabelWidget#

#if defined(ENABLE_OVERLOADING)
    ExpanderGetLabelWidgetMethodInfo        ,
#endif
    expanderGetLabelWidget                  ,


-- ** getResizeToplevel #method:getResizeToplevel#

#if defined(ENABLE_OVERLOADING)
    ExpanderGetResizeToplevelMethodInfo     ,
#endif
    expanderGetResizeToplevel               ,


-- ** getUseMarkup #method:getUseMarkup#

#if defined(ENABLE_OVERLOADING)
    ExpanderGetUseMarkupMethodInfo          ,
#endif
    expanderGetUseMarkup                    ,


-- ** getUseUnderline #method:getUseUnderline#

#if defined(ENABLE_OVERLOADING)
    ExpanderGetUseUnderlineMethodInfo       ,
#endif
    expanderGetUseUnderline                 ,


-- ** new #method:new#

    expanderNew                             ,


-- ** newWithMnemonic #method:newWithMnemonic#

    expanderNewWithMnemonic                 ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    ExpanderSetChildMethodInfo              ,
#endif
    expanderSetChild                        ,


-- ** setExpanded #method:setExpanded#

#if defined(ENABLE_OVERLOADING)
    ExpanderSetExpandedMethodInfo           ,
#endif
    expanderSetExpanded                     ,


-- ** setLabel #method:setLabel#

#if defined(ENABLE_OVERLOADING)
    ExpanderSetLabelMethodInfo              ,
#endif
    expanderSetLabel                        ,


-- ** setLabelWidget #method:setLabelWidget#

#if defined(ENABLE_OVERLOADING)
    ExpanderSetLabelWidgetMethodInfo        ,
#endif
    expanderSetLabelWidget                  ,


-- ** setResizeToplevel #method:setResizeToplevel#

#if defined(ENABLE_OVERLOADING)
    ExpanderSetResizeToplevelMethodInfo     ,
#endif
    expanderSetResizeToplevel               ,


-- ** setUseMarkup #method:setUseMarkup#

#if defined(ENABLE_OVERLOADING)
    ExpanderSetUseMarkupMethodInfo          ,
#endif
    expanderSetUseMarkup                    ,


-- ** setUseUnderline #method:setUseUnderline#

#if defined(ENABLE_OVERLOADING)
    ExpanderSetUseUnderlineMethodInfo       ,
#endif
    expanderSetUseUnderline                 ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    ExpanderChildPropertyInfo               ,
#endif
    clearExpanderChild                      ,
    constructExpanderChild                  ,
#if defined(ENABLE_OVERLOADING)
    expanderChild                           ,
#endif
    getExpanderChild                        ,
    setExpanderChild                        ,


-- ** expanded #attr:expanded#
-- | Whether the expander has been opened to reveal the child.

#if defined(ENABLE_OVERLOADING)
    ExpanderExpandedPropertyInfo            ,
#endif
    constructExpanderExpanded               ,
#if defined(ENABLE_OVERLOADING)
    expanderExpanded                        ,
#endif
    getExpanderExpanded                     ,
    setExpanderExpanded                     ,


-- ** label #attr:label#
-- | The text of the expanders label.

#if defined(ENABLE_OVERLOADING)
    ExpanderLabelPropertyInfo               ,
#endif
    clearExpanderLabel                      ,
    constructExpanderLabel                  ,
#if defined(ENABLE_OVERLOADING)
    expanderLabel                           ,
#endif
    getExpanderLabel                        ,
    setExpanderLabel                        ,


-- ** labelWidget #attr:labelWidget#
-- | A widget to display instead of the usual expander label.

#if defined(ENABLE_OVERLOADING)
    ExpanderLabelWidgetPropertyInfo         ,
#endif
    clearExpanderLabelWidget                ,
    constructExpanderLabelWidget            ,
#if defined(ENABLE_OVERLOADING)
    expanderLabelWidget                     ,
#endif
    getExpanderLabelWidget                  ,
    setExpanderLabelWidget                  ,


-- ** resizeToplevel #attr:resizeToplevel#
-- | When this property is 'P.True', the expander will resize the toplevel
-- widget containing the expander upon expanding and collapsing.

#if defined(ENABLE_OVERLOADING)
    ExpanderResizeToplevelPropertyInfo      ,
#endif
    constructExpanderResizeToplevel         ,
#if defined(ENABLE_OVERLOADING)
    expanderResizeToplevel                  ,
#endif
    getExpanderResizeToplevel               ,
    setExpanderResizeToplevel               ,


-- ** useMarkup #attr:useMarkup#
-- | Whether the text in the label is Pango markup.

#if defined(ENABLE_OVERLOADING)
    ExpanderUseMarkupPropertyInfo           ,
#endif
    constructExpanderUseMarkup              ,
#if defined(ENABLE_OVERLOADING)
    expanderUseMarkup                       ,
#endif
    getExpanderUseMarkup                    ,
    setExpanderUseMarkup                    ,


-- ** useUnderline #attr:useUnderline#
-- | Whether an underline in the text indicates a mnemonic.

#if defined(ENABLE_OVERLOADING)
    ExpanderUseUnderlinePropertyInfo        ,
#endif
    constructExpanderUseUnderline           ,
#if defined(ENABLE_OVERLOADING)
    expanderUseUnderline                    ,
#endif
    getExpanderUseUnderline                 ,
    setExpanderUseUnderline                 ,




 -- * Signals


-- ** activate #signal:activate#

    ExpanderActivateCallback                ,
#if defined(ENABLE_OVERLOADING)
    ExpanderActivateSignalInfo              ,
#endif
    afterExpanderActivate                   ,
    onExpanderActivate                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Expander = Expander (SP.ManagedPtr Expander)
    deriving (Eq)

instance SP.ManagedPtrNewtype Expander where
    toManagedPtr (Expander p) = p

foreign import ccall "gtk_expander_get_type"
    c_gtk_expander_get_type :: IO B.Types.GType

instance B.Types.TypedObject Expander where
    glibType = c_gtk_expander_get_type

instance B.Types.GObject Expander

-- | Type class for types which can be safely cast to `Expander`, for instance with `toExpander`.
class (SP.GObject o, O.IsDescendantOf Expander o) => IsExpander o
instance (SP.GObject o, O.IsDescendantOf Expander o) => IsExpander o

instance O.HasParentTypes Expander
type instance O.ParentTypes Expander = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Expander`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toExpander :: (MIO.MonadIO m, IsExpander o) => o -> m Expander
toExpander = MIO.liftIO . B.ManagedPtr.unsafeCastTo Expander

-- | Convert 'Expander' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Expander) where
    gvalueGType_ = c_gtk_expander_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Expander)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Expander)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Expander ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveExpanderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveExpanderMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveExpanderMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveExpanderMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveExpanderMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveExpanderMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveExpanderMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveExpanderMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveExpanderMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveExpanderMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveExpanderMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveExpanderMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveExpanderMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveExpanderMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveExpanderMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveExpanderMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveExpanderMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveExpanderMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveExpanderMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveExpanderMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveExpanderMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveExpanderMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveExpanderMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveExpanderMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveExpanderMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveExpanderMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveExpanderMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveExpanderMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveExpanderMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveExpanderMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveExpanderMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveExpanderMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveExpanderMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveExpanderMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveExpanderMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveExpanderMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveExpanderMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveExpanderMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveExpanderMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveExpanderMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveExpanderMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveExpanderMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveExpanderMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveExpanderMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveExpanderMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveExpanderMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveExpanderMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveExpanderMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveExpanderMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveExpanderMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveExpanderMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveExpanderMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveExpanderMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveExpanderMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveExpanderMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveExpanderMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveExpanderMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveExpanderMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveExpanderMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveExpanderMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveExpanderMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveExpanderMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveExpanderMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveExpanderMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveExpanderMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveExpanderMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveExpanderMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveExpanderMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveExpanderMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveExpanderMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveExpanderMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveExpanderMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveExpanderMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveExpanderMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveExpanderMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveExpanderMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveExpanderMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveExpanderMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveExpanderMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveExpanderMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveExpanderMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveExpanderMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveExpanderMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveExpanderMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveExpanderMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveExpanderMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveExpanderMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveExpanderMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveExpanderMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveExpanderMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveExpanderMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveExpanderMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveExpanderMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveExpanderMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveExpanderMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveExpanderMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveExpanderMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveExpanderMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveExpanderMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveExpanderMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveExpanderMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveExpanderMethod "getChild" o = ExpanderGetChildMethodInfo
    ResolveExpanderMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveExpanderMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveExpanderMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveExpanderMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveExpanderMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveExpanderMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveExpanderMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveExpanderMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveExpanderMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveExpanderMethod "getExpanded" o = ExpanderGetExpandedMethodInfo
    ResolveExpanderMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveExpanderMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveExpanderMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveExpanderMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveExpanderMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveExpanderMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveExpanderMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveExpanderMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveExpanderMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveExpanderMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveExpanderMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveExpanderMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveExpanderMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveExpanderMethod "getLabel" o = ExpanderGetLabelMethodInfo
    ResolveExpanderMethod "getLabelWidget" o = ExpanderGetLabelWidgetMethodInfo
    ResolveExpanderMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveExpanderMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveExpanderMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveExpanderMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveExpanderMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveExpanderMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveExpanderMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveExpanderMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveExpanderMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveExpanderMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveExpanderMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveExpanderMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveExpanderMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveExpanderMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveExpanderMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveExpanderMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveExpanderMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveExpanderMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveExpanderMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveExpanderMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveExpanderMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveExpanderMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveExpanderMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveExpanderMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveExpanderMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveExpanderMethod "getResizeToplevel" o = ExpanderGetResizeToplevelMethodInfo
    ResolveExpanderMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveExpanderMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveExpanderMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveExpanderMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveExpanderMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveExpanderMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveExpanderMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveExpanderMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveExpanderMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveExpanderMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveExpanderMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveExpanderMethod "getUseMarkup" o = ExpanderGetUseMarkupMethodInfo
    ResolveExpanderMethod "getUseUnderline" o = ExpanderGetUseUnderlineMethodInfo
    ResolveExpanderMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveExpanderMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveExpanderMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveExpanderMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveExpanderMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveExpanderMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveExpanderMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveExpanderMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveExpanderMethod "setChild" o = ExpanderSetChildMethodInfo
    ResolveExpanderMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveExpanderMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveExpanderMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveExpanderMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveExpanderMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveExpanderMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveExpanderMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveExpanderMethod "setExpanded" o = ExpanderSetExpandedMethodInfo
    ResolveExpanderMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveExpanderMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveExpanderMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveExpanderMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveExpanderMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveExpanderMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveExpanderMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveExpanderMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveExpanderMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveExpanderMethod "setLabel" o = ExpanderSetLabelMethodInfo
    ResolveExpanderMethod "setLabelWidget" o = ExpanderSetLabelWidgetMethodInfo
    ResolveExpanderMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveExpanderMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveExpanderMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveExpanderMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveExpanderMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveExpanderMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveExpanderMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveExpanderMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveExpanderMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveExpanderMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveExpanderMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveExpanderMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveExpanderMethod "setResizeToplevel" o = ExpanderSetResizeToplevelMethodInfo
    ResolveExpanderMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveExpanderMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveExpanderMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveExpanderMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveExpanderMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveExpanderMethod "setUseMarkup" o = ExpanderSetUseMarkupMethodInfo
    ResolveExpanderMethod "setUseUnderline" o = ExpanderSetUseUnderlineMethodInfo
    ResolveExpanderMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveExpanderMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveExpanderMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveExpanderMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveExpanderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveExpanderMethod t Expander, O.OverloadedMethod info Expander p) => OL.IsLabel t (Expander -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveExpanderMethod t Expander, O.OverloadedMethod info Expander p, R.HasField t Expander p) => R.HasField t Expander p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveExpanderMethod t Expander, O.OverloadedMethodInfo info Expander) => OL.IsLabel t (O.MethodProxy info Expander) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Expander::activate
-- | Activates the @GtkExpander@.
type ExpanderActivateCallback =
    IO ()

type C_ExpanderActivateCallback =
    Ptr Expander ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ExpanderActivateCallback`.
foreign import ccall "wrapper"
    mk_ExpanderActivateCallback :: C_ExpanderActivateCallback -> IO (FunPtr C_ExpanderActivateCallback)

wrap_ExpanderActivateCallback :: 
    GObject a => (a -> ExpanderActivateCallback) ->
    C_ExpanderActivateCallback
wrap_ExpanderActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' expander #activate callback
-- @
-- 
-- 
onExpanderActivate :: (IsExpander a, MonadIO m) => a -> ((?self :: a) => ExpanderActivateCallback) -> m SignalHandlerId
onExpanderActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ExpanderActivateCallback wrapped
    wrapped'' <- mk_ExpanderActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' expander #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterExpanderActivate :: (IsExpander a, MonadIO m) => a -> ((?self :: a) => ExpanderActivateCallback) -> m SignalHandlerId
afterExpanderActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ExpanderActivateCallback wrapped
    wrapped'' <- mk_ExpanderActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ExpanderActivateSignalInfo
instance SignalInfo ExpanderActivateSignalInfo where
    type HaskellCallbackType ExpanderActivateSignalInfo = ExpanderActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ExpanderActivateCallback cb
        cb'' <- mk_ExpanderActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:signal:activate"})

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' expander #child
-- @
getExpanderChild :: (MonadIO m, IsExpander o) => o -> m (Maybe Gtk.Widget.Widget)
getExpanderChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' expander [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setExpanderChild :: (MonadIO m, IsExpander o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setExpanderChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructExpanderChild :: (IsExpander o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructExpanderChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearExpanderChild :: (MonadIO m, IsExpander o) => o -> m ()
clearExpanderChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data ExpanderChildPropertyInfo
instance AttrInfo ExpanderChildPropertyInfo where
    type AttrAllowedOps ExpanderChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ExpanderChildPropertyInfo = IsExpander
    type AttrSetTypeConstraint ExpanderChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint ExpanderChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType ExpanderChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType ExpanderChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel ExpanderChildPropertyInfo = "child"
    type AttrOrigin ExpanderChildPropertyInfo = Expander
    attrGet = getExpanderChild
    attrSet = setExpanderChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructExpanderChild
    attrClear = clearExpanderChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:attr:child"
        })
#endif

-- VVV Prop "expanded"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@expanded@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' expander #expanded
-- @
getExpanderExpanded :: (MonadIO m, IsExpander o) => o -> m Bool
getExpanderExpanded obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "expanded"

-- | Set the value of the “@expanded@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' expander [ #expanded 'Data.GI.Base.Attributes.:=' value ]
-- @
setExpanderExpanded :: (MonadIO m, IsExpander o) => o -> Bool -> m ()
setExpanderExpanded obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "expanded" val

-- | Construct a `GValueConstruct` with valid value for the “@expanded@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructExpanderExpanded :: (IsExpander o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructExpanderExpanded val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "expanded" val

#if defined(ENABLE_OVERLOADING)
data ExpanderExpandedPropertyInfo
instance AttrInfo ExpanderExpandedPropertyInfo where
    type AttrAllowedOps ExpanderExpandedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ExpanderExpandedPropertyInfo = IsExpander
    type AttrSetTypeConstraint ExpanderExpandedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ExpanderExpandedPropertyInfo = (~) Bool
    type AttrTransferType ExpanderExpandedPropertyInfo = Bool
    type AttrGetType ExpanderExpandedPropertyInfo = Bool
    type AttrLabel ExpanderExpandedPropertyInfo = "expanded"
    type AttrOrigin ExpanderExpandedPropertyInfo = Expander
    attrGet = getExpanderExpanded
    attrSet = setExpanderExpanded
    attrTransfer _ v = do
        return v
    attrConstruct = constructExpanderExpanded
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanded"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:attr:expanded"
        })
#endif

-- VVV Prop "label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' expander #label
-- @
getExpanderLabel :: (MonadIO m, IsExpander o) => o -> m (Maybe T.Text)
getExpanderLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "label"

-- | Set the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' expander [ #label 'Data.GI.Base.Attributes.:=' value ]
-- @
setExpanderLabel :: (MonadIO m, IsExpander o) => o -> T.Text -> m ()
setExpanderLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "label" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructExpanderLabel :: (IsExpander o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructExpanderLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "label" (P.Just val)

-- | Set the value of the “@label@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #label
-- @
clearExpanderLabel :: (MonadIO m, IsExpander o) => o -> m ()
clearExpanderLabel obj = liftIO $ B.Properties.setObjectPropertyString obj "label" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ExpanderLabelPropertyInfo
instance AttrInfo ExpanderLabelPropertyInfo where
    type AttrAllowedOps ExpanderLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ExpanderLabelPropertyInfo = IsExpander
    type AttrSetTypeConstraint ExpanderLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ExpanderLabelPropertyInfo = (~) T.Text
    type AttrTransferType ExpanderLabelPropertyInfo = T.Text
    type AttrGetType ExpanderLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel ExpanderLabelPropertyInfo = "label"
    type AttrOrigin ExpanderLabelPropertyInfo = Expander
    attrGet = getExpanderLabel
    attrSet = setExpanderLabel
    attrTransfer _ v = do
        return v
    attrConstruct = constructExpanderLabel
    attrClear = clearExpanderLabel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.label"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:attr:label"
        })
#endif

-- VVV Prop "label-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@label-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' expander #labelWidget
-- @
getExpanderLabelWidget :: (MonadIO m, IsExpander o) => o -> m (Maybe Gtk.Widget.Widget)
getExpanderLabelWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "label-widget" Gtk.Widget.Widget

-- | Set the value of the “@label-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' expander [ #labelWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setExpanderLabelWidget :: (MonadIO m, IsExpander o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setExpanderLabelWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "label-widget" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@label-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructExpanderLabelWidget :: (IsExpander o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructExpanderLabelWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "label-widget" (P.Just val)

-- | Set the value of the “@label-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #labelWidget
-- @
clearExpanderLabelWidget :: (MonadIO m, IsExpander o) => o -> m ()
clearExpanderLabelWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "label-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data ExpanderLabelWidgetPropertyInfo
instance AttrInfo ExpanderLabelWidgetPropertyInfo where
    type AttrAllowedOps ExpanderLabelWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ExpanderLabelWidgetPropertyInfo = IsExpander
    type AttrSetTypeConstraint ExpanderLabelWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint ExpanderLabelWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType ExpanderLabelWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType ExpanderLabelWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel ExpanderLabelWidgetPropertyInfo = "label-widget"
    type AttrOrigin ExpanderLabelWidgetPropertyInfo = Expander
    attrGet = getExpanderLabelWidget
    attrSet = setExpanderLabelWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructExpanderLabelWidget
    attrClear = clearExpanderLabelWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.labelWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:attr:labelWidget"
        })
#endif

-- VVV Prop "resize-toplevel"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@resize-toplevel@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' expander #resizeToplevel
-- @
getExpanderResizeToplevel :: (MonadIO m, IsExpander o) => o -> m Bool
getExpanderResizeToplevel obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "resize-toplevel"

-- | Set the value of the “@resize-toplevel@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' expander [ #resizeToplevel 'Data.GI.Base.Attributes.:=' value ]
-- @
setExpanderResizeToplevel :: (MonadIO m, IsExpander o) => o -> Bool -> m ()
setExpanderResizeToplevel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "resize-toplevel" val

-- | Construct a `GValueConstruct` with valid value for the “@resize-toplevel@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructExpanderResizeToplevel :: (IsExpander o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructExpanderResizeToplevel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "resize-toplevel" val

#if defined(ENABLE_OVERLOADING)
data ExpanderResizeToplevelPropertyInfo
instance AttrInfo ExpanderResizeToplevelPropertyInfo where
    type AttrAllowedOps ExpanderResizeToplevelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ExpanderResizeToplevelPropertyInfo = IsExpander
    type AttrSetTypeConstraint ExpanderResizeToplevelPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ExpanderResizeToplevelPropertyInfo = (~) Bool
    type AttrTransferType ExpanderResizeToplevelPropertyInfo = Bool
    type AttrGetType ExpanderResizeToplevelPropertyInfo = Bool
    type AttrLabel ExpanderResizeToplevelPropertyInfo = "resize-toplevel"
    type AttrOrigin ExpanderResizeToplevelPropertyInfo = Expander
    attrGet = getExpanderResizeToplevel
    attrSet = setExpanderResizeToplevel
    attrTransfer _ v = do
        return v
    attrConstruct = constructExpanderResizeToplevel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.resizeToplevel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:attr:resizeToplevel"
        })
#endif

-- VVV Prop "use-markup"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-markup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' expander #useMarkup
-- @
getExpanderUseMarkup :: (MonadIO m, IsExpander o) => o -> m Bool
getExpanderUseMarkup obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-markup"

-- | Set the value of the “@use-markup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' expander [ #useMarkup 'Data.GI.Base.Attributes.:=' value ]
-- @
setExpanderUseMarkup :: (MonadIO m, IsExpander o) => o -> Bool -> m ()
setExpanderUseMarkup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-markup" val

-- | Construct a `GValueConstruct` with valid value for the “@use-markup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructExpanderUseMarkup :: (IsExpander o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructExpanderUseMarkup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-markup" val

#if defined(ENABLE_OVERLOADING)
data ExpanderUseMarkupPropertyInfo
instance AttrInfo ExpanderUseMarkupPropertyInfo where
    type AttrAllowedOps ExpanderUseMarkupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ExpanderUseMarkupPropertyInfo = IsExpander
    type AttrSetTypeConstraint ExpanderUseMarkupPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ExpanderUseMarkupPropertyInfo = (~) Bool
    type AttrTransferType ExpanderUseMarkupPropertyInfo = Bool
    type AttrGetType ExpanderUseMarkupPropertyInfo = Bool
    type AttrLabel ExpanderUseMarkupPropertyInfo = "use-markup"
    type AttrOrigin ExpanderUseMarkupPropertyInfo = Expander
    attrGet = getExpanderUseMarkup
    attrSet = setExpanderUseMarkup
    attrTransfer _ v = do
        return v
    attrConstruct = constructExpanderUseMarkup
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.useMarkup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:attr:useMarkup"
        })
#endif

-- VVV Prop "use-underline"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' expander #useUnderline
-- @
getExpanderUseUnderline :: (MonadIO m, IsExpander o) => o -> m Bool
getExpanderUseUnderline obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-underline"

-- | Set the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' expander [ #useUnderline 'Data.GI.Base.Attributes.:=' value ]
-- @
setExpanderUseUnderline :: (MonadIO m, IsExpander o) => o -> Bool -> m ()
setExpanderUseUnderline obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-underline" val

-- | Construct a `GValueConstruct` with valid value for the “@use-underline@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructExpanderUseUnderline :: (IsExpander o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructExpanderUseUnderline val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-underline" val

#if defined(ENABLE_OVERLOADING)
data ExpanderUseUnderlinePropertyInfo
instance AttrInfo ExpanderUseUnderlinePropertyInfo where
    type AttrAllowedOps ExpanderUseUnderlinePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ExpanderUseUnderlinePropertyInfo = IsExpander
    type AttrSetTypeConstraint ExpanderUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ExpanderUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferType ExpanderUseUnderlinePropertyInfo = Bool
    type AttrGetType ExpanderUseUnderlinePropertyInfo = Bool
    type AttrLabel ExpanderUseUnderlinePropertyInfo = "use-underline"
    type AttrOrigin ExpanderUseUnderlinePropertyInfo = Expander
    attrGet = getExpanderUseUnderline
    attrSet = setExpanderUseUnderline
    attrTransfer _ v = do
        return v
    attrConstruct = constructExpanderUseUnderline
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.useUnderline"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#g:attr:useUnderline"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Expander
type instance O.AttributeList Expander = ExpanderAttributeList
type ExpanderAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", ExpanderChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("expanded", ExpanderExpandedPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("label", ExpanderLabelPropertyInfo), '("labelWidget", ExpanderLabelWidgetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizeToplevel", ExpanderResizeToplevelPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useMarkup", ExpanderUseMarkupPropertyInfo), '("useUnderline", ExpanderUseUnderlinePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
expanderChild :: AttrLabelProxy "child"
expanderChild = AttrLabelProxy

expanderExpanded :: AttrLabelProxy "expanded"
expanderExpanded = AttrLabelProxy

expanderLabel :: AttrLabelProxy "label"
expanderLabel = AttrLabelProxy

expanderLabelWidget :: AttrLabelProxy "labelWidget"
expanderLabelWidget = AttrLabelProxy

expanderResizeToplevel :: AttrLabelProxy "resizeToplevel"
expanderResizeToplevel = AttrLabelProxy

expanderUseMarkup :: AttrLabelProxy "useMarkup"
expanderUseMarkup = AttrLabelProxy

expanderUseUnderline :: AttrLabelProxy "useUnderline"
expanderUseUnderline = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Expander = ExpanderSignalList
type ExpanderSignalList = ('[ '("activate", ExpanderActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Expander::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text of the label"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expander" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_new" gtk_expander_new :: 
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr Expander)

-- | Creates a new expander using /@label@/ as the text of the label.
expanderNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@label@/: the text of the label
    -> m Expander
    -- ^ __Returns:__ a new @GtkExpander@ widget.
expanderNew label = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    result <- gtk_expander_new maybeLabel
    checkUnexpectedReturnNULL "expanderNew" result
    result' <- (newObject Expander) result
    freeMem maybeLabel
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Expander::new_with_mnemonic
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the text of the label with an underscore\n  in front of the mnemonic character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expander" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_new_with_mnemonic" gtk_expander_new_with_mnemonic :: 
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr Expander)

-- | Creates a new expander using /@label@/ as the text of the label.
-- 
-- If characters in /@label@/ are preceded by an underscore, they are
-- underlined. If you need a literal underscore character in a label,
-- use “__” (two underscores). The first underlined character represents
-- a keyboard accelerator called a mnemonic.
-- 
-- Pressing Alt and that key activates the button.
expanderNewWithMnemonic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@label@/: the text of the label with an underscore
    --   in front of the mnemonic character
    -> m Expander
    -- ^ __Returns:__ a new @GtkExpander@ widget.
expanderNewWithMnemonic label = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    result <- gtk_expander_new_with_mnemonic maybeLabel
    checkUnexpectedReturnNULL "expanderNewWithMnemonic" result
    result' <- (newObject Expander) result
    freeMem maybeLabel
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Expander::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_get_child" gtk_expander_get_child :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@expander@/.
expanderGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@expander@/
expanderGetChild expander = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    result <- gtk_expander_get_child expander'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr expander
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ExpanderGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderGetChildMethodInfo a signature where
    overloadedMethod = expanderGetChild

instance O.OverloadedMethodInfo ExpanderGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderGetChild"
        })


#endif

-- method Expander::get_expanded
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_get_expanded" gtk_expander_get_expanded :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    IO CInt

-- | Queries a @GtkExpander@ and returns its current state.
-- 
-- Returns 'P.True' if the child widget is revealed.
expanderGetExpanded ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> m Bool
    -- ^ __Returns:__ the current state of the expander
expanderGetExpanded expander = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    result <- gtk_expander_get_expanded expander'
    let result' = (/= 0) result
    touchManagedPtr expander
    return result'

#if defined(ENABLE_OVERLOADING)
data ExpanderGetExpandedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderGetExpandedMethodInfo a signature where
    overloadedMethod = expanderGetExpanded

instance O.OverloadedMethodInfo ExpanderGetExpandedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderGetExpanded",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderGetExpanded"
        })


#endif

-- method Expander::get_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_get_label" gtk_expander_get_label :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    IO CString

-- | Fetches the text from a label widget.
-- 
-- This is including any embedded underlines indicating mnemonics and
-- Pango markup, as set by 'GI.Gtk.Objects.Expander.expanderSetLabel'. If the label
-- text has not been set the return value will be 'P.Nothing'. This will be the
-- case if you create an empty button with 'GI.Gtk.Objects.Button.buttonNew' to use as a
-- container.
expanderGetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The text of the label widget. This string is owned
    --   by the widget and must not be modified or freed.
expanderGetLabel expander = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    result <- gtk_expander_get_label expander'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr expander
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ExpanderGetLabelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderGetLabelMethodInfo a signature where
    overloadedMethod = expanderGetLabel

instance O.OverloadedMethodInfo ExpanderGetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderGetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderGetLabel"
        })


#endif

-- method Expander::get_label_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_get_label_widget" gtk_expander_get_label_widget :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the label widget for the frame.
expanderGetLabelWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the label widget
expanderGetLabelWidget expander = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    result <- gtk_expander_get_label_widget expander'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr expander
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ExpanderGetLabelWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderGetLabelWidgetMethodInfo a signature where
    overloadedMethod = expanderGetLabelWidget

instance O.OverloadedMethodInfo ExpanderGetLabelWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderGetLabelWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderGetLabelWidget"
        })


#endif

-- method Expander::get_resize_toplevel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_get_resize_toplevel" gtk_expander_get_resize_toplevel :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    IO CInt

-- | Returns whether the expander will resize the toplevel widget
-- containing the expander upon resizing and collapsing.
expanderGetResizeToplevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> m Bool
    -- ^ __Returns:__ the “resize toplevel” setting.
expanderGetResizeToplevel expander = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    result <- gtk_expander_get_resize_toplevel expander'
    let result' = (/= 0) result
    touchManagedPtr expander
    return result'

#if defined(ENABLE_OVERLOADING)
data ExpanderGetResizeToplevelMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderGetResizeToplevelMethodInfo a signature where
    overloadedMethod = expanderGetResizeToplevel

instance O.OverloadedMethodInfo ExpanderGetResizeToplevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderGetResizeToplevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderGetResizeToplevel"
        })


#endif

-- method Expander::get_use_markup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_get_use_markup" gtk_expander_get_use_markup :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    IO CInt

-- | Returns whether the label’s text is interpreted as Pango markup.
expanderGetUseMarkup ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the label’s text will be parsed for markup
expanderGetUseMarkup expander = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    result <- gtk_expander_get_use_markup expander'
    let result' = (/= 0) result
    touchManagedPtr expander
    return result'

#if defined(ENABLE_OVERLOADING)
data ExpanderGetUseMarkupMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderGetUseMarkupMethodInfo a signature where
    overloadedMethod = expanderGetUseMarkup

instance O.OverloadedMethodInfo ExpanderGetUseMarkupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderGetUseMarkup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderGetUseMarkup"
        })


#endif

-- method Expander::get_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_get_use_underline" gtk_expander_get_use_underline :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    IO CInt

-- | Returns whether an underline in the text indicates a mnemonic.
expanderGetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if an embedded underline in the expander
    --   label indicates the mnemonic accelerator keys
expanderGetUseUnderline expander = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    result <- gtk_expander_get_use_underline expander'
    let result' = (/= 0) result
    touchManagedPtr expander
    return result'

#if defined(ENABLE_OVERLOADING)
data ExpanderGetUseUnderlineMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderGetUseUnderlineMethodInfo a signature where
    overloadedMethod = expanderGetUseUnderline

instance O.OverloadedMethodInfo ExpanderGetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderGetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderGetUseUnderline"
        })


#endif

-- method Expander::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_set_child" gtk_expander_set_child :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@expander@/.
expanderSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
expanderSetChild expander child = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_expander_set_child expander' maybeChild
    touchManagedPtr expander
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ExpanderSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsExpander a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ExpanderSetChildMethodInfo a signature where
    overloadedMethod = expanderSetChild

instance O.OverloadedMethodInfo ExpanderSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderSetChild"
        })


#endif

-- method Expander::set_expanded
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expanded"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the child widget is revealed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_set_expanded" gtk_expander_set_expanded :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    CInt ->                                 -- expanded : TBasicType TBoolean
    IO ()

-- | Sets the state of the expander.
-- 
-- Set to 'P.True', if you want the child widget to be revealed,
-- and 'P.False' if you want the child widget to be hidden.
expanderSetExpanded ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> Bool
    -- ^ /@expanded@/: whether the child widget is revealed
    -> m ()
expanderSetExpanded expander expanded = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    let expanded' = (P.fromIntegral . P.fromEnum) expanded
    gtk_expander_set_expanded expander' expanded'
    touchManagedPtr expander
    return ()

#if defined(ENABLE_OVERLOADING)
data ExpanderSetExpandedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderSetExpandedMethodInfo a signature where
    overloadedMethod = expanderSetExpanded

instance O.OverloadedMethodInfo ExpanderSetExpandedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderSetExpanded",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderSetExpanded"
        })


#endif

-- method Expander::set_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_set_label" gtk_expander_set_label :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    CString ->                              -- label : TBasicType TUTF8
    IO ()

-- | Sets the text of the label of the expander to /@label@/.
-- 
-- This will also clear any previously set labels.
expanderSetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> Maybe (T.Text)
    -- ^ /@label@/: a string
    -> m ()
expanderSetLabel expander label = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    gtk_expander_set_label expander' maybeLabel
    touchManagedPtr expander
    freeMem maybeLabel
    return ()

#if defined(ENABLE_OVERLOADING)
data ExpanderSetLabelMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderSetLabelMethodInfo a signature where
    overloadedMethod = expanderSetLabel

instance O.OverloadedMethodInfo ExpanderSetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderSetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderSetLabel"
        })


#endif

-- method Expander::set_label_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label_widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new label widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_set_label_widget" gtk_expander_set_label_widget :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    Ptr Gtk.Widget.Widget ->                -- label_widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Set the label widget for the expander.
-- 
-- This is the widget that will appear embedded alongside
-- the expander arrow.
expanderSetLabelWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> Maybe (b)
    -- ^ /@labelWidget@/: the new label widget
    -> m ()
expanderSetLabelWidget expander labelWidget = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    maybeLabelWidget <- case labelWidget of
        Nothing -> return FP.nullPtr
        Just jLabelWidget -> do
            jLabelWidget' <- unsafeManagedPtrCastPtr jLabelWidget
            return jLabelWidget'
    gtk_expander_set_label_widget expander' maybeLabelWidget
    touchManagedPtr expander
    whenJust labelWidget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ExpanderSetLabelWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsExpander a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ExpanderSetLabelWidgetMethodInfo a signature where
    overloadedMethod = expanderSetLabelWidget

instance O.OverloadedMethodInfo ExpanderSetLabelWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderSetLabelWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderSetLabelWidget"
        })


#endif

-- method Expander::set_resize_toplevel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resize_toplevel"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to resize the toplevel"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_set_resize_toplevel" gtk_expander_set_resize_toplevel :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    CInt ->                                 -- resize_toplevel : TBasicType TBoolean
    IO ()

-- | Sets whether the expander will resize the toplevel widget
-- containing the expander upon resizing and collapsing.
expanderSetResizeToplevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> Bool
    -- ^ /@resizeToplevel@/: whether to resize the toplevel
    -> m ()
expanderSetResizeToplevel expander resizeToplevel = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    let resizeToplevel' = (P.fromIntegral . P.fromEnum) resizeToplevel
    gtk_expander_set_resize_toplevel expander' resizeToplevel'
    touchManagedPtr expander
    return ()

#if defined(ENABLE_OVERLOADING)
data ExpanderSetResizeToplevelMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderSetResizeToplevelMethodInfo a signature where
    overloadedMethod = expanderSetResizeToplevel

instance O.OverloadedMethodInfo ExpanderSetResizeToplevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderSetResizeToplevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderSetResizeToplevel"
        })


#endif

-- method Expander::set_use_markup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_markup"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the label\8217s text should be parsed for markup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_set_use_markup" gtk_expander_set_use_markup :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    CInt ->                                 -- use_markup : TBasicType TBoolean
    IO ()

-- | Sets whether the text of the label contains Pango markup.
expanderSetUseMarkup ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> Bool
    -- ^ /@useMarkup@/: 'P.True' if the label’s text should be parsed for markup
    -> m ()
expanderSetUseMarkup expander useMarkup = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    let useMarkup' = (P.fromIntegral . P.fromEnum) useMarkup
    gtk_expander_set_use_markup expander' useMarkup'
    touchManagedPtr expander
    return ()

#if defined(ENABLE_OVERLOADING)
data ExpanderSetUseMarkupMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderSetUseMarkupMethodInfo a signature where
    overloadedMethod = expanderSetUseMarkup

instance O.OverloadedMethodInfo ExpanderSetUseMarkupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderSetUseMarkup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderSetUseMarkup"
        })


#endif

-- method Expander::set_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expander"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpander`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_underline"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if underlines in the text indicate mnemonics"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_expander_set_use_underline" gtk_expander_set_use_underline :: 
    Ptr Expander ->                         -- expander : TInterface (Name {namespace = "Gtk", name = "Expander"})
    CInt ->                                 -- use_underline : TBasicType TBoolean
    IO ()

-- | If true, an underline in the text indicates a mnemonic.
expanderSetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsExpander a) =>
    a
    -- ^ /@expander@/: a @GtkExpander@
    -> Bool
    -- ^ /@useUnderline@/: 'P.True' if underlines in the text indicate mnemonics
    -> m ()
expanderSetUseUnderline expander useUnderline = liftIO $ do
    expander' <- unsafeManagedPtrCastPtr expander
    let useUnderline' = (P.fromIntegral . P.fromEnum) useUnderline
    gtk_expander_set_use_underline expander' useUnderline'
    touchManagedPtr expander
    return ()

#if defined(ENABLE_OVERLOADING)
data ExpanderSetUseUnderlineMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsExpander a) => O.OverloadedMethod ExpanderSetUseUnderlineMethodInfo a signature where
    overloadedMethod = expanderSetUseUnderline

instance O.OverloadedMethodInfo ExpanderSetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Expander.expanderSetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Expander.html#v:expanderSetUseUnderline"
        })


#endif


