{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Matches an item when each of its filters matches.
-- 
-- To add filters to a @GtkEveryFilter@, use 'GI.Gtk.Objects.MultiFilter.multiFilterAppend'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.EveryFilter
    ( 

-- * Exported types
    EveryFilter(..)                         ,
    IsEveryFilter                           ,
    toEveryFilter                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.Gtk.Objects.MultiFilter#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Filter#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [match]("GI.Gtk.Objects.Filter#g:method:match"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.MultiFilter#g:method:remove"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStrictness]("GI.Gtk.Objects.Filter#g:method:getStrictness").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveEveryFilterMethod                ,
#endif

-- ** new #method:new#

    everyFilterNew                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Objects.MultiFilter as Gtk.MultiFilter

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Objects.MultiFilter as Gtk.MultiFilter

#endif

-- | Memory-managed wrapper type.
newtype EveryFilter = EveryFilter (SP.ManagedPtr EveryFilter)
    deriving (Eq)

instance SP.ManagedPtrNewtype EveryFilter where
    toManagedPtr (EveryFilter p) = p

foreign import ccall "gtk_every_filter_get_type"
    c_gtk_every_filter_get_type :: IO B.Types.GType

instance B.Types.TypedObject EveryFilter where
    glibType = c_gtk_every_filter_get_type

instance B.Types.GObject EveryFilter

-- | Type class for types which can be safely cast to `EveryFilter`, for instance with `toEveryFilter`.
class (SP.GObject o, O.IsDescendantOf EveryFilter o) => IsEveryFilter o
instance (SP.GObject o, O.IsDescendantOf EveryFilter o) => IsEveryFilter o

instance O.HasParentTypes EveryFilter
type instance O.ParentTypes EveryFilter = '[Gtk.MultiFilter.MultiFilter, Gtk.Filter.Filter, GObject.Object.Object, Gio.ListModel.ListModel, Gtk.Buildable.Buildable]

-- | Cast to `EveryFilter`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toEveryFilter :: (MIO.MonadIO m, IsEveryFilter o) => o -> m EveryFilter
toEveryFilter = MIO.liftIO . B.ManagedPtr.unsafeCastTo EveryFilter

-- | Convert 'EveryFilter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EveryFilter) where
    gvalueGType_ = c_gtk_every_filter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EveryFilter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EveryFilter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EveryFilter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEveryFilterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEveryFilterMethod "append" o = Gtk.MultiFilter.MultiFilterAppendMethodInfo
    ResolveEveryFilterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEveryFilterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEveryFilterMethod "changed" o = Gtk.Filter.FilterChangedMethodInfo
    ResolveEveryFilterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEveryFilterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEveryFilterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEveryFilterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEveryFilterMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveEveryFilterMethod "match" o = Gtk.Filter.FilterMatchMethodInfo
    ResolveEveryFilterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEveryFilterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEveryFilterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEveryFilterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEveryFilterMethod "remove" o = Gtk.MultiFilter.MultiFilterRemoveMethodInfo
    ResolveEveryFilterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEveryFilterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEveryFilterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEveryFilterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEveryFilterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEveryFilterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEveryFilterMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveEveryFilterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEveryFilterMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveEveryFilterMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveEveryFilterMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveEveryFilterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEveryFilterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEveryFilterMethod "getStrictness" o = Gtk.Filter.FilterGetStrictnessMethodInfo
    ResolveEveryFilterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEveryFilterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEveryFilterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEveryFilterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEveryFilterMethod t EveryFilter, O.OverloadedMethod info EveryFilter p) => OL.IsLabel t (EveryFilter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEveryFilterMethod t EveryFilter, O.OverloadedMethod info EveryFilter p, R.HasField t EveryFilter p) => R.HasField t EveryFilter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEveryFilterMethod t EveryFilter, O.OverloadedMethodInfo info EveryFilter) => OL.IsLabel t (O.MethodProxy info EveryFilter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EveryFilter
type instance O.AttributeList EveryFilter = EveryFilterAttributeList
type EveryFilterAttributeList = ('[ '("itemType", Gtk.MultiFilter.MultiFilterItemTypePropertyInfo), '("nItems", Gtk.MultiFilter.MultiFilterNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EveryFilter = EveryFilterSignalList
type EveryFilterSignalList = ('[ '("changed", Gtk.Filter.FilterChangedSignalInfo), '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EveryFilter::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "EveryFilter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_every_filter_new" gtk_every_filter_new :: 
    IO (Ptr EveryFilter)

-- | Creates a new empty \"every\" filter.
-- 
-- Use 'GI.Gtk.Objects.MultiFilter.multiFilterAppend' to add filters to it.
-- 
-- This filter matches an item if each of the filters added to it
-- matches the item. In particular, this means that if no filter
-- has been added to it, the filter matches every item.
everyFilterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m EveryFilter
    -- ^ __Returns:__ a new @GtkEveryFilter@
everyFilterNew  = liftIO $ do
    result <- gtk_every_filter_new
    checkUnexpectedReturnNULL "everyFilterNew" result
    result' <- (wrapObject EveryFilter) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


