{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides raw access to the event stream.
-- 
-- It should only be used as a last resort if none of the other event
-- controllers or gestures do the job.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.EventControllerLegacy
    ( 

-- * Exported types
    EventControllerLegacy(..)               ,
    IsEventControllerLegacy                 ,
    toEventControllerLegacy                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveEventControllerLegacyMethod      ,
#endif

-- ** new #method:new#

    eventControllerLegacyNew                ,




 -- * Signals


-- ** event #signal:event#

    EventControllerLegacyEventCallback      ,
#if defined(ENABLE_OVERLOADING)
    EventControllerLegacyEventSignalInfo    ,
#endif
    afterEventControllerLegacyEvent         ,
    onEventControllerLegacyEvent            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController

#endif

-- | Memory-managed wrapper type.
newtype EventControllerLegacy = EventControllerLegacy (SP.ManagedPtr EventControllerLegacy)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventControllerLegacy where
    toManagedPtr (EventControllerLegacy p) = p

foreign import ccall "gtk_event_controller_legacy_get_type"
    c_gtk_event_controller_legacy_get_type :: IO B.Types.GType

instance B.Types.TypedObject EventControllerLegacy where
    glibType = c_gtk_event_controller_legacy_get_type

instance B.Types.GObject EventControllerLegacy

-- | Type class for types which can be safely cast to `EventControllerLegacy`, for instance with `toEventControllerLegacy`.
class (SP.GObject o, O.IsDescendantOf EventControllerLegacy o) => IsEventControllerLegacy o
instance (SP.GObject o, O.IsDescendantOf EventControllerLegacy o) => IsEventControllerLegacy o

instance O.HasParentTypes EventControllerLegacy
type instance O.ParentTypes EventControllerLegacy = '[Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to `EventControllerLegacy`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toEventControllerLegacy :: (MIO.MonadIO m, IsEventControllerLegacy o) => o -> m EventControllerLegacy
toEventControllerLegacy = MIO.liftIO . B.ManagedPtr.unsafeCastTo EventControllerLegacy

-- | Convert 'EventControllerLegacy' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EventControllerLegacy) where
    gvalueGType_ = c_gtk_event_controller_legacy_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EventControllerLegacy)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EventControllerLegacy)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EventControllerLegacy ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEventControllerLegacyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventControllerLegacyMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEventControllerLegacyMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEventControllerLegacyMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEventControllerLegacyMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEventControllerLegacyMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEventControllerLegacyMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEventControllerLegacyMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEventControllerLegacyMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEventControllerLegacyMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEventControllerLegacyMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEventControllerLegacyMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveEventControllerLegacyMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEventControllerLegacyMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEventControllerLegacyMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEventControllerLegacyMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEventControllerLegacyMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEventControllerLegacyMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEventControllerLegacyMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveEventControllerLegacyMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveEventControllerLegacyMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveEventControllerLegacyMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveEventControllerLegacyMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEventControllerLegacyMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveEventControllerLegacyMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveEventControllerLegacyMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveEventControllerLegacyMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEventControllerLegacyMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEventControllerLegacyMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveEventControllerLegacyMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEventControllerLegacyMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEventControllerLegacyMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveEventControllerLegacyMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveEventControllerLegacyMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveEventControllerLegacyMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEventControllerLegacyMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveEventControllerLegacyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventControllerLegacyMethod t EventControllerLegacy, O.OverloadedMethod info EventControllerLegacy p) => OL.IsLabel t (EventControllerLegacy -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventControllerLegacyMethod t EventControllerLegacy, O.OverloadedMethod info EventControllerLegacy p, R.HasField t EventControllerLegacy p) => R.HasField t EventControllerLegacy p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventControllerLegacyMethod t EventControllerLegacy, O.OverloadedMethodInfo info EventControllerLegacy) => OL.IsLabel t (O.MethodProxy info EventControllerLegacy) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal EventControllerLegacy::event
-- | Emitted for each GDK event delivered to /@controller@/.
type EventControllerLegacyEventCallback =
    Gdk.Event.Event
    -- ^ /@event@/: the @GdkEvent@ which triggered this signal
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop other handlers from being invoked for the event
    --   and the emission of this signal. 'P.False' to propagate the event further.

type C_EventControllerLegacyEventCallback =
    Ptr EventControllerLegacy ->            -- object
    Ptr Gdk.Event.Event ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_EventControllerLegacyEventCallback`.
foreign import ccall "wrapper"
    mk_EventControllerLegacyEventCallback :: C_EventControllerLegacyEventCallback -> IO (FunPtr C_EventControllerLegacyEventCallback)

wrap_EventControllerLegacyEventCallback :: 
    GObject a => (a -> EventControllerLegacyEventCallback) ->
    C_EventControllerLegacyEventCallback
wrap_EventControllerLegacyEventCallback gi'cb gi'selfPtr event _ = do
    event' <- (newPtr Gdk.Event.Event) event
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  event'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [event](#signal:event) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' eventControllerLegacy #event callback
-- @
-- 
-- 
onEventControllerLegacyEvent :: (IsEventControllerLegacy a, MonadIO m) => a -> ((?self :: a) => EventControllerLegacyEventCallback) -> m SignalHandlerId
onEventControllerLegacyEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerLegacyEventCallback wrapped
    wrapped'' <- mk_EventControllerLegacyEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [event](#signal:event) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' eventControllerLegacy #event callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEventControllerLegacyEvent :: (IsEventControllerLegacy a, MonadIO m) => a -> ((?self :: a) => EventControllerLegacyEventCallback) -> m SignalHandlerId
afterEventControllerLegacyEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EventControllerLegacyEventCallback wrapped
    wrapped'' <- mk_EventControllerLegacyEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EventControllerLegacyEventSignalInfo
instance SignalInfo EventControllerLegacyEventSignalInfo where
    type HaskellCallbackType EventControllerLegacyEventSignalInfo = EventControllerLegacyEventCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EventControllerLegacyEventCallback cb
        cb'' <- mk_EventControllerLegacyEventCallback cb'
        connectSignalFunPtr obj "event" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventControllerLegacy::event"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventControllerLegacy.html#g:signal:event"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventControllerLegacy
type instance O.AttributeList EventControllerLegacy = EventControllerLegacyAttributeList
type EventControllerLegacyAttributeList = ('[ '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EventControllerLegacy = EventControllerLegacySignalList
type EventControllerLegacySignalList = ('[ '("event", EventControllerLegacyEventSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EventControllerLegacy::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "EventControllerLegacy" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_legacy_new" gtk_event_controller_legacy_new :: 
    IO (Ptr EventControllerLegacy)

-- | Creates a new legacy event controller.
eventControllerLegacyNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m EventControllerLegacy
    -- ^ __Returns:__ the newly created event controller.
eventControllerLegacyNew  = liftIO $ do
    result <- gtk_event_controller_legacy_new
    checkUnexpectedReturnNULL "eventControllerLegacyNew" result
    result' <- (wrapObject EventControllerLegacy) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


