{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The base class for event controllers.
-- 
-- These are ancillary objects associated to widgets, which react
-- to @GdkEvents@, and possibly trigger actions as a consequence.
-- 
-- Event controllers are added to a widget with
-- 'GI.Gtk.Objects.Widget.widgetAddController'. It is rarely necessary to
-- explicitly remove a controller with 'GI.Gtk.Objects.Widget.widgetRemoveController'.
-- 
-- See the chapter on <https://docs.gtk.org/gtk4/input-handling.html input handling> for
-- an overview of the basic concepts, such as the capture and bubble
-- phases of event propagation.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.EventController
    ( 

-- * Exported types
    EventController(..)                     ,
    IsEventController                       ,
    toEventController                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveEventControllerMethod            ,
#endif

-- ** getCurrentEvent #method:getCurrentEvent#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetCurrentEventMethodInfo,
#endif
    eventControllerGetCurrentEvent          ,


-- ** getCurrentEventDevice #method:getCurrentEventDevice#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetCurrentEventDeviceMethodInfo,
#endif
    eventControllerGetCurrentEventDevice    ,


-- ** getCurrentEventState #method:getCurrentEventState#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetCurrentEventStateMethodInfo,
#endif
    eventControllerGetCurrentEventState     ,


-- ** getCurrentEventTime #method:getCurrentEventTime#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetCurrentEventTimeMethodInfo,
#endif
    eventControllerGetCurrentEventTime      ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetNameMethodInfo        ,
#endif
    eventControllerGetName                  ,


-- ** getPropagationLimit #method:getPropagationLimit#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetPropagationLimitMethodInfo,
#endif
    eventControllerGetPropagationLimit      ,


-- ** getPropagationPhase #method:getPropagationPhase#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetPropagationPhaseMethodInfo,
#endif
    eventControllerGetPropagationPhase      ,


-- ** getWidget #method:getWidget#

#if defined(ENABLE_OVERLOADING)
    EventControllerGetWidgetMethodInfo      ,
#endif
    eventControllerGetWidget                ,


-- ** reset #method:reset#

#if defined(ENABLE_OVERLOADING)
    EventControllerResetMethodInfo          ,
#endif
    eventControllerReset                    ,


-- ** setName #method:setName#

#if defined(ENABLE_OVERLOADING)
    EventControllerSetNameMethodInfo        ,
#endif
    eventControllerSetName                  ,


-- ** setPropagationLimit #method:setPropagationLimit#

#if defined(ENABLE_OVERLOADING)
    EventControllerSetPropagationLimitMethodInfo,
#endif
    eventControllerSetPropagationLimit      ,


-- ** setPropagationPhase #method:setPropagationPhase#

#if defined(ENABLE_OVERLOADING)
    EventControllerSetPropagationPhaseMethodInfo,
#endif
    eventControllerSetPropagationPhase      ,


-- ** setStaticName #method:setStaticName#

#if defined(ENABLE_OVERLOADING)
    EventControllerSetStaticNameMethodInfo  ,
#endif
    eventControllerSetStaticName            ,




 -- * Properties


-- ** name #attr:name#
-- | The name for this controller, typically used for debugging purposes.

#if defined(ENABLE_OVERLOADING)
    EventControllerNamePropertyInfo         ,
#endif
    clearEventControllerName                ,
    constructEventControllerName            ,
#if defined(ENABLE_OVERLOADING)
    eventControllerName                     ,
#endif
    getEventControllerName                  ,
    setEventControllerName                  ,


-- ** propagationLimit #attr:propagationLimit#
-- | The limit for which events this controller will handle.

#if defined(ENABLE_OVERLOADING)
    EventControllerPropagationLimitPropertyInfo,
#endif
    constructEventControllerPropagationLimit,
#if defined(ENABLE_OVERLOADING)
    eventControllerPropagationLimit         ,
#endif
    getEventControllerPropagationLimit      ,
    setEventControllerPropagationLimit      ,


-- ** propagationPhase #attr:propagationPhase#
-- | The propagation phase at which this controller will handle events.

#if defined(ENABLE_OVERLOADING)
    EventControllerPropagationPhasePropertyInfo,
#endif
    constructEventControllerPropagationPhase,
#if defined(ENABLE_OVERLOADING)
    eventControllerPropagationPhase         ,
#endif
    getEventControllerPropagationPhase      ,
    setEventControllerPropagationPhase      ,


-- ** widget #attr:widget#
-- | The widget receiving the @GdkEvents@ that the controller will handle.

#if defined(ENABLE_OVERLOADING)
    EventControllerWidgetPropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    eventControllerWidget                   ,
#endif
    getEventControllerWidget                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype EventController = EventController (SP.ManagedPtr EventController)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventController where
    toManagedPtr (EventController p) = p

foreign import ccall "gtk_event_controller_get_type"
    c_gtk_event_controller_get_type :: IO B.Types.GType

instance B.Types.TypedObject EventController where
    glibType = c_gtk_event_controller_get_type

instance B.Types.GObject EventController

-- | Type class for types which can be safely cast to `EventController`, for instance with `toEventController`.
class (SP.GObject o, O.IsDescendantOf EventController o) => IsEventController o
instance (SP.GObject o, O.IsDescendantOf EventController o) => IsEventController o

instance O.HasParentTypes EventController
type instance O.ParentTypes EventController = '[GObject.Object.Object]

-- | Cast to `EventController`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toEventController :: (MIO.MonadIO m, IsEventController o) => o -> m EventController
toEventController = MIO.liftIO . B.ManagedPtr.unsafeCastTo EventController

-- | Convert 'EventController' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EventController) where
    gvalueGType_ = c_gtk_event_controller_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EventController)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EventController)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EventController ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEventControllerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventControllerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEventControllerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEventControllerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEventControllerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEventControllerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEventControllerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEventControllerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEventControllerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEventControllerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEventControllerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEventControllerMethod "reset" o = EventControllerResetMethodInfo
    ResolveEventControllerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEventControllerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEventControllerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEventControllerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEventControllerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEventControllerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEventControllerMethod "getCurrentEvent" o = EventControllerGetCurrentEventMethodInfo
    ResolveEventControllerMethod "getCurrentEventDevice" o = EventControllerGetCurrentEventDeviceMethodInfo
    ResolveEventControllerMethod "getCurrentEventState" o = EventControllerGetCurrentEventStateMethodInfo
    ResolveEventControllerMethod "getCurrentEventTime" o = EventControllerGetCurrentEventTimeMethodInfo
    ResolveEventControllerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEventControllerMethod "getName" o = EventControllerGetNameMethodInfo
    ResolveEventControllerMethod "getPropagationLimit" o = EventControllerGetPropagationLimitMethodInfo
    ResolveEventControllerMethod "getPropagationPhase" o = EventControllerGetPropagationPhaseMethodInfo
    ResolveEventControllerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEventControllerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEventControllerMethod "getWidget" o = EventControllerGetWidgetMethodInfo
    ResolveEventControllerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEventControllerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEventControllerMethod "setName" o = EventControllerSetNameMethodInfo
    ResolveEventControllerMethod "setPropagationLimit" o = EventControllerSetPropagationLimitMethodInfo
    ResolveEventControllerMethod "setPropagationPhase" o = EventControllerSetPropagationPhaseMethodInfo
    ResolveEventControllerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEventControllerMethod "setStaticName" o = EventControllerSetStaticNameMethodInfo
    ResolveEventControllerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventControllerMethod t EventController, O.OverloadedMethod info EventController p) => OL.IsLabel t (EventController -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventControllerMethod t EventController, O.OverloadedMethod info EventController p, R.HasField t EventController p) => R.HasField t EventController p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventControllerMethod t EventController, O.OverloadedMethodInfo info EventController) => OL.IsLabel t (O.MethodProxy info EventController) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventController #name
-- @
getEventControllerName :: (MonadIO m, IsEventController o) => o -> m (Maybe T.Text)
getEventControllerName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "name"

-- | Set the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventController [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventControllerName :: (MonadIO m, IsEventController o) => o -> T.Text -> m ()
setEventControllerName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "name" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructEventControllerName :: (IsEventController o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructEventControllerName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "name" (P.Just val)

-- | Set the value of the “@name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearEventControllerName :: (MonadIO m, IsEventController o) => o -> m ()
clearEventControllerName obj = liftIO $ B.Properties.setObjectPropertyString obj "name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data EventControllerNamePropertyInfo
instance AttrInfo EventControllerNamePropertyInfo where
    type AttrAllowedOps EventControllerNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint EventControllerNamePropertyInfo = IsEventController
    type AttrSetTypeConstraint EventControllerNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint EventControllerNamePropertyInfo = (~) T.Text
    type AttrTransferType EventControllerNamePropertyInfo = T.Text
    type AttrGetType EventControllerNamePropertyInfo = (Maybe T.Text)
    type AttrLabel EventControllerNamePropertyInfo = "name"
    type AttrOrigin EventControllerNamePropertyInfo = EventController
    attrGet = getEventControllerName
    attrSet = setEventControllerName
    attrTransfer _ v = do
        return v
    attrConstruct = constructEventControllerName
    attrClear = clearEventControllerName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#g:attr:name"
        })
#endif

-- VVV Prop "propagation-limit"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PropagationLimit"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@propagation-limit@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventController #propagationLimit
-- @
getEventControllerPropagationLimit :: (MonadIO m, IsEventController o) => o -> m Gtk.Enums.PropagationLimit
getEventControllerPropagationLimit obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "propagation-limit"

-- | Set the value of the “@propagation-limit@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventController [ #propagationLimit 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventControllerPropagationLimit :: (MonadIO m, IsEventController o) => o -> Gtk.Enums.PropagationLimit -> m ()
setEventControllerPropagationLimit obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "propagation-limit" val

-- | Construct a `GValueConstruct` with valid value for the “@propagation-limit@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructEventControllerPropagationLimit :: (IsEventController o, MIO.MonadIO m) => Gtk.Enums.PropagationLimit -> m (GValueConstruct o)
constructEventControllerPropagationLimit val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "propagation-limit" val

#if defined(ENABLE_OVERLOADING)
data EventControllerPropagationLimitPropertyInfo
instance AttrInfo EventControllerPropagationLimitPropertyInfo where
    type AttrAllowedOps EventControllerPropagationLimitPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint EventControllerPropagationLimitPropertyInfo = IsEventController
    type AttrSetTypeConstraint EventControllerPropagationLimitPropertyInfo = (~) Gtk.Enums.PropagationLimit
    type AttrTransferTypeConstraint EventControllerPropagationLimitPropertyInfo = (~) Gtk.Enums.PropagationLimit
    type AttrTransferType EventControllerPropagationLimitPropertyInfo = Gtk.Enums.PropagationLimit
    type AttrGetType EventControllerPropagationLimitPropertyInfo = Gtk.Enums.PropagationLimit
    type AttrLabel EventControllerPropagationLimitPropertyInfo = "propagation-limit"
    type AttrOrigin EventControllerPropagationLimitPropertyInfo = EventController
    attrGet = getEventControllerPropagationLimit
    attrSet = setEventControllerPropagationLimit
    attrTransfer _ v = do
        return v
    attrConstruct = constructEventControllerPropagationLimit
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.propagationLimit"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#g:attr:propagationLimit"
        })
#endif

-- VVV Prop "propagation-phase"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PropagationPhase"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@propagation-phase@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventController #propagationPhase
-- @
getEventControllerPropagationPhase :: (MonadIO m, IsEventController o) => o -> m Gtk.Enums.PropagationPhase
getEventControllerPropagationPhase obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "propagation-phase"

-- | Set the value of the “@propagation-phase@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventController [ #propagationPhase 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventControllerPropagationPhase :: (MonadIO m, IsEventController o) => o -> Gtk.Enums.PropagationPhase -> m ()
setEventControllerPropagationPhase obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "propagation-phase" val

-- | Construct a `GValueConstruct` with valid value for the “@propagation-phase@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructEventControllerPropagationPhase :: (IsEventController o, MIO.MonadIO m) => Gtk.Enums.PropagationPhase -> m (GValueConstruct o)
constructEventControllerPropagationPhase val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "propagation-phase" val

#if defined(ENABLE_OVERLOADING)
data EventControllerPropagationPhasePropertyInfo
instance AttrInfo EventControllerPropagationPhasePropertyInfo where
    type AttrAllowedOps EventControllerPropagationPhasePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint EventControllerPropagationPhasePropertyInfo = IsEventController
    type AttrSetTypeConstraint EventControllerPropagationPhasePropertyInfo = (~) Gtk.Enums.PropagationPhase
    type AttrTransferTypeConstraint EventControllerPropagationPhasePropertyInfo = (~) Gtk.Enums.PropagationPhase
    type AttrTransferType EventControllerPropagationPhasePropertyInfo = Gtk.Enums.PropagationPhase
    type AttrGetType EventControllerPropagationPhasePropertyInfo = Gtk.Enums.PropagationPhase
    type AttrLabel EventControllerPropagationPhasePropertyInfo = "propagation-phase"
    type AttrOrigin EventControllerPropagationPhasePropertyInfo = EventController
    attrGet = getEventControllerPropagationPhase
    attrSet = setEventControllerPropagationPhase
    attrTransfer _ v = do
        return v
    attrConstruct = constructEventControllerPropagationPhase
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.propagationPhase"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#g:attr:propagationPhase"
        })
#endif

-- VVV Prop "widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventController #widget
-- @
getEventControllerWidget :: (MonadIO m, IsEventController o) => o -> m (Maybe Gtk.Widget.Widget)
getEventControllerWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "widget" Gtk.Widget.Widget

#if defined(ENABLE_OVERLOADING)
data EventControllerWidgetPropertyInfo
instance AttrInfo EventControllerWidgetPropertyInfo where
    type AttrAllowedOps EventControllerWidgetPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint EventControllerWidgetPropertyInfo = IsEventController
    type AttrSetTypeConstraint EventControllerWidgetPropertyInfo = (~) ()
    type AttrTransferTypeConstraint EventControllerWidgetPropertyInfo = (~) ()
    type AttrTransferType EventControllerWidgetPropertyInfo = ()
    type AttrGetType EventControllerWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel EventControllerWidgetPropertyInfo = "widget"
    type AttrOrigin EventControllerWidgetPropertyInfo = EventController
    attrGet = getEventControllerWidget
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.widget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#g:attr:widget"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventController
type instance O.AttributeList EventController = EventControllerAttributeList
type EventControllerAttributeList = ('[ '("name", EventControllerNamePropertyInfo), '("propagationLimit", EventControllerPropagationLimitPropertyInfo), '("propagationPhase", EventControllerPropagationPhasePropertyInfo), '("widget", EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
eventControllerName :: AttrLabelProxy "name"
eventControllerName = AttrLabelProxy

eventControllerPropagationLimit :: AttrLabelProxy "propagationLimit"
eventControllerPropagationLimit = AttrLabelProxy

eventControllerPropagationPhase :: AttrLabelProxy "propagationPhase"
eventControllerPropagationPhase = AttrLabelProxy

eventControllerWidget :: AttrLabelProxy "widget"
eventControllerWidget = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EventController = EventControllerSignalList
type EventControllerSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EventController::get_current_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Event" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_current_event" gtk_event_controller_get_current_event :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO (Ptr Gdk.Event.Event)

-- | Returns the event that is currently being handled by the controller.
-- 
-- At other times, 'P.Nothing' is returned.
eventControllerGetCurrentEvent ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m (Maybe Gdk.Event.Event)
    -- ^ __Returns:__ the event that is currently
    --   handled by /@controller@/
eventControllerGetCurrentEvent controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_current_event controller'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gdk.Event.Event) result'
        return result''
    touchManagedPtr controller
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data EventControllerGetCurrentEventMethodInfo
instance (signature ~ (m (Maybe Gdk.Event.Event)), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetCurrentEventMethodInfo a signature where
    overloadedMethod = eventControllerGetCurrentEvent

instance O.OverloadedMethodInfo EventControllerGetCurrentEventMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetCurrentEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetCurrentEvent"
        })


#endif

-- method EventController::get_current_event_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_current_event_device" gtk_event_controller_get_current_event_device :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO (Ptr Gdk.Device.Device)

-- | Returns the device of the event that is currently being
-- handled by the controller.
-- 
-- At other times, 'P.Nothing' is returned.
eventControllerGetCurrentEventDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m (Maybe Gdk.Device.Device)
    -- ^ __Returns:__ device of the event is
    --   currently handled by /@controller@/
eventControllerGetCurrentEventDevice controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_current_event_device controller'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Device.Device) result'
        return result''
    touchManagedPtr controller
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data EventControllerGetCurrentEventDeviceMethodInfo
instance (signature ~ (m (Maybe Gdk.Device.Device)), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetCurrentEventDeviceMethodInfo a signature where
    overloadedMethod = eventControllerGetCurrentEventDevice

instance O.OverloadedMethodInfo EventControllerGetCurrentEventDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetCurrentEventDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetCurrentEventDevice"
        })


#endif

-- method EventController::get_current_event_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ModifierType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_current_event_state" gtk_event_controller_get_current_event_state :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO CUInt

-- | Returns the modifier state of the event that is currently being
-- handled by the controller.
-- 
-- At other times, 0 is returned.
eventControllerGetCurrentEventState ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m [Gdk.Flags.ModifierType]
    -- ^ __Returns:__ modifier state of the event is currently handled by /@controller@/
eventControllerGetCurrentEventState controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_current_event_state controller'
    let result' = wordToGFlags result
    touchManagedPtr controller
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerGetCurrentEventStateMethodInfo
instance (signature ~ (m [Gdk.Flags.ModifierType]), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetCurrentEventStateMethodInfo a signature where
    overloadedMethod = eventControllerGetCurrentEventState

instance O.OverloadedMethodInfo EventControllerGetCurrentEventStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetCurrentEventState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetCurrentEventState"
        })


#endif

-- method EventController::get_current_event_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_current_event_time" gtk_event_controller_get_current_event_time :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO Word32

-- | Returns the timestamp of the event that is currently being
-- handled by the controller.
-- 
-- At other times, 0 is returned.
eventControllerGetCurrentEventTime ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m Word32
    -- ^ __Returns:__ timestamp of the event is currently handled by /@controller@/
eventControllerGetCurrentEventTime controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_current_event_time controller'
    touchManagedPtr controller
    return result

#if defined(ENABLE_OVERLOADING)
data EventControllerGetCurrentEventTimeMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetCurrentEventTimeMethodInfo a signature where
    overloadedMethod = eventControllerGetCurrentEventTime

instance O.OverloadedMethodInfo EventControllerGetCurrentEventTimeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetCurrentEventTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetCurrentEventTime"
        })


#endif

-- method EventController::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_name" gtk_event_controller_get_name :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO CString

-- | Gets the name of /@controller@/.
eventControllerGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The controller name
eventControllerGetName controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_name controller'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr controller
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data EventControllerGetNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetNameMethodInfo a signature where
    overloadedMethod = eventControllerGetName

instance O.OverloadedMethodInfo EventControllerGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetName"
        })


#endif

-- method EventController::get_propagation_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PropagationLimit" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_propagation_limit" gtk_event_controller_get_propagation_limit :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO CUInt

-- | Gets the propagation limit of the event controller.
eventControllerGetPropagationLimit ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m Gtk.Enums.PropagationLimit
    -- ^ __Returns:__ the propagation limit
eventControllerGetPropagationLimit controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_propagation_limit controller'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr controller
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerGetPropagationLimitMethodInfo
instance (signature ~ (m Gtk.Enums.PropagationLimit), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetPropagationLimitMethodInfo a signature where
    overloadedMethod = eventControllerGetPropagationLimit

instance O.OverloadedMethodInfo EventControllerGetPropagationLimitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetPropagationLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetPropagationLimit"
        })


#endif

-- method EventController::get_propagation_phase
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PropagationPhase" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_propagation_phase" gtk_event_controller_get_propagation_phase :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO CUInt

-- | Gets the propagation phase at which /@controller@/ handles events.
eventControllerGetPropagationPhase ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m Gtk.Enums.PropagationPhase
    -- ^ __Returns:__ the propagation phase
eventControllerGetPropagationPhase controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_propagation_phase controller'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr controller
    return result'

#if defined(ENABLE_OVERLOADING)
data EventControllerGetPropagationPhaseMethodInfo
instance (signature ~ (m Gtk.Enums.PropagationPhase), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetPropagationPhaseMethodInfo a signature where
    overloadedMethod = eventControllerGetPropagationPhase

instance O.OverloadedMethodInfo EventControllerGetPropagationPhaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetPropagationPhase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetPropagationPhase"
        })


#endif

-- method EventController::get_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_get_widget" gtk_event_controller_get_widget :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the @GtkWidget@ this controller relates to.
eventControllerGetWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ a @GtkWidget@
eventControllerGetWidget controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    result <- gtk_event_controller_get_widget controller'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr controller
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data EventControllerGetWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerGetWidgetMethodInfo a signature where
    overloadedMethod = eventControllerGetWidget

instance O.OverloadedMethodInfo EventControllerGetWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerGetWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerGetWidget"
        })


#endif

-- method EventController::reset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_reset" gtk_event_controller_reset :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    IO ()

-- | Resets the /@controller@/ to a clean state.
eventControllerReset ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> m ()
eventControllerReset controller = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    gtk_event_controller_reset controller'
    touchManagedPtr controller
    return ()

#if defined(ENABLE_OVERLOADING)
data EventControllerResetMethodInfo
instance (signature ~ (m ()), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerResetMethodInfo a signature where
    overloadedMethod = eventControllerReset

instance O.OverloadedMethodInfo EventControllerResetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerReset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerReset"
        })


#endif

-- method EventController::set_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a name for @controller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_set_name" gtk_event_controller_set_name :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets a name on the controller that can be used for debugging.
eventControllerSetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> Maybe (T.Text)
    -- ^ /@name@/: a name for /@controller@/
    -> m ()
eventControllerSetName controller name = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    gtk_event_controller_set_name controller' maybeName
    touchManagedPtr controller
    freeMem maybeName
    return ()

#if defined(ENABLE_OVERLOADING)
data EventControllerSetNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerSetNameMethodInfo a signature where
    overloadedMethod = eventControllerSetName

instance O.OverloadedMethodInfo EventControllerSetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerSetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerSetName"
        })


#endif

-- method EventController::set_propagation_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "limit"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PropagationLimit" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the propagation limit"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_set_propagation_limit" gtk_event_controller_set_propagation_limit :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    CUInt ->                                -- limit : TInterface (Name {namespace = "Gtk", name = "PropagationLimit"})
    IO ()

-- | Sets the event propagation limit on the event controller.
-- 
-- If the limit is set to 'GI.Gtk.Enums.PropagationLimitSameNative', the controller
-- won\'t handle events that are targeted at widgets on a different
-- surface, such as popovers.
eventControllerSetPropagationLimit ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> Gtk.Enums.PropagationLimit
    -- ^ /@limit@/: the propagation limit
    -> m ()
eventControllerSetPropagationLimit controller limit = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    let limit' = (fromIntegral . fromEnum) limit
    gtk_event_controller_set_propagation_limit controller' limit'
    touchManagedPtr controller
    return ()

#if defined(ENABLE_OVERLOADING)
data EventControllerSetPropagationLimitMethodInfo
instance (signature ~ (Gtk.Enums.PropagationLimit -> m ()), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerSetPropagationLimitMethodInfo a signature where
    overloadedMethod = eventControllerSetPropagationLimit

instance O.OverloadedMethodInfo EventControllerSetPropagationLimitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerSetPropagationLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerSetPropagationLimit"
        })


#endif

-- method EventController::set_propagation_phase
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "phase"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PropagationPhase" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a propagation phase"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_set_propagation_phase" gtk_event_controller_set_propagation_phase :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    CUInt ->                                -- phase : TInterface (Name {namespace = "Gtk", name = "PropagationPhase"})
    IO ()

-- | Sets the propagation phase at which a controller handles events.
-- 
-- If /@phase@/ is 'GI.Gtk.Enums.PropagationPhaseNone', no automatic event handling will be
-- performed, but other additional gesture maintenance will.
eventControllerSetPropagationPhase ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> Gtk.Enums.PropagationPhase
    -- ^ /@phase@/: a propagation phase
    -> m ()
eventControllerSetPropagationPhase controller phase = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    let phase' = (fromIntegral . fromEnum) phase
    gtk_event_controller_set_propagation_phase controller' phase'
    touchManagedPtr controller
    return ()

#if defined(ENABLE_OVERLOADING)
data EventControllerSetPropagationPhaseMethodInfo
instance (signature ~ (Gtk.Enums.PropagationPhase -> m ()), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerSetPropagationPhaseMethodInfo a signature where
    overloadedMethod = eventControllerSetPropagationPhase

instance O.OverloadedMethodInfo EventControllerSetPropagationPhaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerSetPropagationPhase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerSetPropagationPhase"
        })


#endif

-- method EventController::set_static_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "controller"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "EventController" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkEventController`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a name for @controller, must be a static string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_event_controller_set_static_name" gtk_event_controller_set_static_name :: 
    Ptr EventController ->                  -- controller : TInterface (Name {namespace = "Gtk", name = "EventController"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets a name on the controller that can be used for debugging.
-- 
-- /Since: 4.8/
eventControllerSetStaticName ::
    (B.CallStack.HasCallStack, MonadIO m, IsEventController a) =>
    a
    -- ^ /@controller@/: a @GtkEventController@
    -> Maybe (T.Text)
    -- ^ /@name@/: a name for /@controller@/, must be a static string
    -> m ()
eventControllerSetStaticName controller name = liftIO $ do
    controller' <- unsafeManagedPtrCastPtr controller
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    gtk_event_controller_set_static_name controller' maybeName
    touchManagedPtr controller
    freeMem maybeName
    return ()

#if defined(ENABLE_OVERLOADING)
data EventControllerSetStaticNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsEventController a) => O.OverloadedMethod EventControllerSetStaticNameMethodInfo a signature where
    overloadedMethod = eventControllerSetStaticName

instance O.OverloadedMethodInfo EventControllerSetStaticNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EventController.eventControllerSetStaticName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EventController.html#v:eventControllerSetStaticName"
        })


#endif


