{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Used by text widgets to let users insert Emoji characters.
-- 
-- \<picture>
--   \<source srcset=\"emojichooser-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkEmojiChooser\" src=\"emojichooser.png\">
-- \<\/picture>
-- 
-- @GtkEmojiChooser@ emits the [EmojiChooser::emojiPicked]("GI.Gtk.Objects.EmojiChooser#g:signal:emojiPicked")
-- signal when an Emoji is selected.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkEmojiChooser@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Ctrl\<\/kbd>+\<kbd>N\<\/kbd> scrolls th the next section.
-- * \<kbd>Ctrl\<\/kbd>+\<kbd>P\<\/kbd> scrolls th the previous section.
-- 
-- 
-- = Actions
-- 
-- @GtkEmojiChooser@ defines a set of built-in actions:
-- 
-- * @scroll.section@ scrolls to the next or previous section.
-- 
-- 
-- = CSS nodes
-- 
-- >popover
-- >├── box.emoji-searchbar
-- >│   ╰── entry.search
-- >╰── box.emoji-toolbar
-- >    ├── button.image-button.emoji-section
-- >    ├── ...
-- >    ╰── button.image-button.emoji-section
-- 
-- 
-- Every @GtkEmojiChooser@ consists of a main node called popover.
-- The contents of the popover are largely implementation defined
-- and supposed to inherit general styles.
-- The top searchbar used to search emoji and gets the .emoji-searchbar
-- style class itself.
-- The bottom toolbar used to switch between different emoji categories
-- consists of buttons with the .emoji-section style class and gets the
-- .emoji-toolbar style class itself.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.EmojiChooser
    ( 

-- * Exported types
    EmojiChooser(..)                        ,
    IsEmojiChooser                          ,
    toEmojiChooser                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [popdown]("GI.Gtk.Objects.Popover#g:method:popdown"), [popup]("GI.Gtk.Objects.Popover#g:method:popup"), [present]("GI.Gtk.Objects.Popover#g:method:present"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getAutohide]("GI.Gtk.Objects.Popover#g:method:getAutohide"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCascadePopdown]("GI.Gtk.Objects.Popover#g:method:getCascadePopdown"), [getChild]("GI.Gtk.Objects.Popover#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasArrow]("GI.Gtk.Objects.Popover#g:method:getHasArrow"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Popover#g:method:getMnemonicsVisible"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOffset]("GI.Gtk.Objects.Popover#g:method:getOffset"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPointingTo]("GI.Gtk.Objects.Popover#g:method:getPointingTo"), [getPosition]("GI.Gtk.Objects.Popover#g:method:getPosition"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAutohide]("GI.Gtk.Objects.Popover#g:method:setAutohide"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCascadePopdown]("GI.Gtk.Objects.Popover#g:method:setCascadePopdown"), [setChild]("GI.Gtk.Objects.Popover#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultWidget]("GI.Gtk.Objects.Popover#g:method:setDefaultWidget"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasArrow]("GI.Gtk.Objects.Popover#g:method:setHasArrow"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Popover#g:method:setMnemonicsVisible"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOffset]("GI.Gtk.Objects.Popover#g:method:setOffset"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPointingTo]("GI.Gtk.Objects.Popover#g:method:setPointingTo"), [setPosition]("GI.Gtk.Objects.Popover#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveEmojiChooserMethod               ,
#endif

-- ** new #method:new#

    emojiChooserNew                         ,




 -- * Signals


-- ** emojiPicked #signal:emojiPicked#

    EmojiChooserEmojiPickedCallback         ,
#if defined(ENABLE_OVERLOADING)
    EmojiChooserEmojiPickedSignalInfo       ,
#endif
    afterEmojiChooserEmojiPicked            ,
    onEmojiChooserEmojiPicked               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Popover as Gtk.Popover
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Popover as Gtk.Popover
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype EmojiChooser = EmojiChooser (SP.ManagedPtr EmojiChooser)
    deriving (Eq)

instance SP.ManagedPtrNewtype EmojiChooser where
    toManagedPtr (EmojiChooser p) = p

foreign import ccall "gtk_emoji_chooser_get_type"
    c_gtk_emoji_chooser_get_type :: IO B.Types.GType

instance B.Types.TypedObject EmojiChooser where
    glibType = c_gtk_emoji_chooser_get_type

instance B.Types.GObject EmojiChooser

-- | Type class for types which can be safely cast to `EmojiChooser`, for instance with `toEmojiChooser`.
class (SP.GObject o, O.IsDescendantOf EmojiChooser o) => IsEmojiChooser o
instance (SP.GObject o, O.IsDescendantOf EmojiChooser o) => IsEmojiChooser o

instance O.HasParentTypes EmojiChooser
type instance O.ParentTypes EmojiChooser = '[Gtk.Popover.Popover, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to `EmojiChooser`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toEmojiChooser :: (MIO.MonadIO m, IsEmojiChooser o) => o -> m EmojiChooser
toEmojiChooser = MIO.liftIO . B.ManagedPtr.unsafeCastTo EmojiChooser

-- | Convert 'EmojiChooser' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe EmojiChooser) where
    gvalueGType_ = c_gtk_emoji_chooser_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr EmojiChooser)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr EmojiChooser)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject EmojiChooser ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEmojiChooserMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEmojiChooserMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveEmojiChooserMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveEmojiChooserMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveEmojiChooserMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveEmojiChooserMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveEmojiChooserMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveEmojiChooserMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveEmojiChooserMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveEmojiChooserMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveEmojiChooserMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveEmojiChooserMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEmojiChooserMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEmojiChooserMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveEmojiChooserMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveEmojiChooserMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveEmojiChooserMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveEmojiChooserMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveEmojiChooserMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveEmojiChooserMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveEmojiChooserMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveEmojiChooserMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveEmojiChooserMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveEmojiChooserMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveEmojiChooserMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEmojiChooserMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEmojiChooserMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEmojiChooserMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveEmojiChooserMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveEmojiChooserMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveEmojiChooserMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveEmojiChooserMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveEmojiChooserMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveEmojiChooserMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveEmojiChooserMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveEmojiChooserMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveEmojiChooserMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveEmojiChooserMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveEmojiChooserMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveEmojiChooserMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveEmojiChooserMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEmojiChooserMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveEmojiChooserMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveEmojiChooserMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveEmojiChooserMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveEmojiChooserMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveEmojiChooserMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveEmojiChooserMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveEmojiChooserMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveEmojiChooserMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEmojiChooserMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEmojiChooserMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveEmojiChooserMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveEmojiChooserMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveEmojiChooserMethod "popdown" o = Gtk.Popover.PopoverPopdownMethodInfo
    ResolveEmojiChooserMethod "popup" o = Gtk.Popover.PopoverPopupMethodInfo
    ResolveEmojiChooserMethod "present" o = Gtk.Popover.PopoverPresentMethodInfo
    ResolveEmojiChooserMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveEmojiChooserMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveEmojiChooserMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveEmojiChooserMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveEmojiChooserMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEmojiChooserMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEmojiChooserMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveEmojiChooserMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveEmojiChooserMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveEmojiChooserMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveEmojiChooserMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveEmojiChooserMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveEmojiChooserMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveEmojiChooserMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEmojiChooserMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveEmojiChooserMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveEmojiChooserMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveEmojiChooserMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveEmojiChooserMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEmojiChooserMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEmojiChooserMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEmojiChooserMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveEmojiChooserMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveEmojiChooserMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveEmojiChooserMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveEmojiChooserMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveEmojiChooserMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEmojiChooserMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveEmojiChooserMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveEmojiChooserMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveEmojiChooserMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveEmojiChooserMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveEmojiChooserMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveEmojiChooserMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEmojiChooserMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveEmojiChooserMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveEmojiChooserMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveEmojiChooserMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveEmojiChooserMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveEmojiChooserMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveEmojiChooserMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveEmojiChooserMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveEmojiChooserMethod "getAutohide" o = Gtk.Popover.PopoverGetAutohideMethodInfo
    ResolveEmojiChooserMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveEmojiChooserMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveEmojiChooserMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveEmojiChooserMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveEmojiChooserMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveEmojiChooserMethod "getCascadePopdown" o = Gtk.Popover.PopoverGetCascadePopdownMethodInfo
    ResolveEmojiChooserMethod "getChild" o = Gtk.Popover.PopoverGetChildMethodInfo
    ResolveEmojiChooserMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveEmojiChooserMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveEmojiChooserMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveEmojiChooserMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveEmojiChooserMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveEmojiChooserMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveEmojiChooserMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEmojiChooserMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveEmojiChooserMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveEmojiChooserMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveEmojiChooserMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveEmojiChooserMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveEmojiChooserMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveEmojiChooserMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveEmojiChooserMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveEmojiChooserMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveEmojiChooserMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveEmojiChooserMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveEmojiChooserMethod "getHasArrow" o = Gtk.Popover.PopoverGetHasArrowMethodInfo
    ResolveEmojiChooserMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveEmojiChooserMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveEmojiChooserMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveEmojiChooserMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveEmojiChooserMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveEmojiChooserMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveEmojiChooserMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveEmojiChooserMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveEmojiChooserMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveEmojiChooserMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveEmojiChooserMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveEmojiChooserMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveEmojiChooserMethod "getMnemonicsVisible" o = Gtk.Popover.PopoverGetMnemonicsVisibleMethodInfo
    ResolveEmojiChooserMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveEmojiChooserMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveEmojiChooserMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveEmojiChooserMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveEmojiChooserMethod "getOffset" o = Gtk.Popover.PopoverGetOffsetMethodInfo
    ResolveEmojiChooserMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveEmojiChooserMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveEmojiChooserMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveEmojiChooserMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveEmojiChooserMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveEmojiChooserMethod "getPointingTo" o = Gtk.Popover.PopoverGetPointingToMethodInfo
    ResolveEmojiChooserMethod "getPosition" o = Gtk.Popover.PopoverGetPositionMethodInfo
    ResolveEmojiChooserMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveEmojiChooserMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveEmojiChooserMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveEmojiChooserMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEmojiChooserMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEmojiChooserMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveEmojiChooserMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveEmojiChooserMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolveEmojiChooserMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveEmojiChooserMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveEmojiChooserMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveEmojiChooserMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveEmojiChooserMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveEmojiChooserMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveEmojiChooserMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveEmojiChooserMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveEmojiChooserMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveEmojiChooserMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolveEmojiChooserMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolveEmojiChooserMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveEmojiChooserMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveEmojiChooserMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveEmojiChooserMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveEmojiChooserMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveEmojiChooserMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveEmojiChooserMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveEmojiChooserMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveEmojiChooserMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveEmojiChooserMethod "setAutohide" o = Gtk.Popover.PopoverSetAutohideMethodInfo
    ResolveEmojiChooserMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveEmojiChooserMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveEmojiChooserMethod "setCascadePopdown" o = Gtk.Popover.PopoverSetCascadePopdownMethodInfo
    ResolveEmojiChooserMethod "setChild" o = Gtk.Popover.PopoverSetChildMethodInfo
    ResolveEmojiChooserMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveEmojiChooserMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveEmojiChooserMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveEmojiChooserMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveEmojiChooserMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEmojiChooserMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEmojiChooserMethod "setDefaultWidget" o = Gtk.Popover.PopoverSetDefaultWidgetMethodInfo
    ResolveEmojiChooserMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveEmojiChooserMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveEmojiChooserMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveEmojiChooserMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveEmojiChooserMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveEmojiChooserMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveEmojiChooserMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveEmojiChooserMethod "setHasArrow" o = Gtk.Popover.PopoverSetHasArrowMethodInfo
    ResolveEmojiChooserMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveEmojiChooserMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveEmojiChooserMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveEmojiChooserMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveEmojiChooserMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveEmojiChooserMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveEmojiChooserMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveEmojiChooserMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveEmojiChooserMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveEmojiChooserMethod "setMnemonicsVisible" o = Gtk.Popover.PopoverSetMnemonicsVisibleMethodInfo
    ResolveEmojiChooserMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveEmojiChooserMethod "setOffset" o = Gtk.Popover.PopoverSetOffsetMethodInfo
    ResolveEmojiChooserMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveEmojiChooserMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveEmojiChooserMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveEmojiChooserMethod "setPointingTo" o = Gtk.Popover.PopoverSetPointingToMethodInfo
    ResolveEmojiChooserMethod "setPosition" o = Gtk.Popover.PopoverSetPositionMethodInfo
    ResolveEmojiChooserMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEmojiChooserMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveEmojiChooserMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveEmojiChooserMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveEmojiChooserMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveEmojiChooserMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveEmojiChooserMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveEmojiChooserMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveEmojiChooserMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveEmojiChooserMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveEmojiChooserMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveEmojiChooserMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEmojiChooserMethod t EmojiChooser, O.OverloadedMethod info EmojiChooser p) => OL.IsLabel t (EmojiChooser -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEmojiChooserMethod t EmojiChooser, O.OverloadedMethod info EmojiChooser p, R.HasField t EmojiChooser p) => R.HasField t EmojiChooser p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEmojiChooserMethod t EmojiChooser, O.OverloadedMethodInfo info EmojiChooser) => OL.IsLabel t (O.MethodProxy info EmojiChooser) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal EmojiChooser::emoji-picked
-- | Emitted when the user selects an Emoji.
type EmojiChooserEmojiPickedCallback =
    T.Text
    -- ^ /@text@/: the Unicode sequence for the picked Emoji, in UTF-8
    -> IO ()

type C_EmojiChooserEmojiPickedCallback =
    Ptr EmojiChooser ->                     -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_EmojiChooserEmojiPickedCallback`.
foreign import ccall "wrapper"
    mk_EmojiChooserEmojiPickedCallback :: C_EmojiChooserEmojiPickedCallback -> IO (FunPtr C_EmojiChooserEmojiPickedCallback)

wrap_EmojiChooserEmojiPickedCallback :: 
    GObject a => (a -> EmojiChooserEmojiPickedCallback) ->
    C_EmojiChooserEmojiPickedCallback
wrap_EmojiChooserEmojiPickedCallback gi'cb gi'selfPtr text _ = do
    text' <- cstringToText text
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  text'


-- | Connect a signal handler for the [emojiPicked](#signal:emojiPicked) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' emojiChooser #emojiPicked callback
-- @
-- 
-- 
onEmojiChooserEmojiPicked :: (IsEmojiChooser a, MonadIO m) => a -> ((?self :: a) => EmojiChooserEmojiPickedCallback) -> m SignalHandlerId
onEmojiChooserEmojiPicked obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EmojiChooserEmojiPickedCallback wrapped
    wrapped'' <- mk_EmojiChooserEmojiPickedCallback wrapped'
    connectSignalFunPtr obj "emoji-picked" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [emojiPicked](#signal:emojiPicked) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' emojiChooser #emojiPicked callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterEmojiChooserEmojiPicked :: (IsEmojiChooser a, MonadIO m) => a -> ((?self :: a) => EmojiChooserEmojiPickedCallback) -> m SignalHandlerId
afterEmojiChooserEmojiPicked obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_EmojiChooserEmojiPickedCallback wrapped
    wrapped'' <- mk_EmojiChooserEmojiPickedCallback wrapped'
    connectSignalFunPtr obj "emoji-picked" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data EmojiChooserEmojiPickedSignalInfo
instance SignalInfo EmojiChooserEmojiPickedSignalInfo where
    type HaskellCallbackType EmojiChooserEmojiPickedSignalInfo = EmojiChooserEmojiPickedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_EmojiChooserEmojiPickedCallback cb
        cb'' <- mk_EmojiChooserEmojiPickedCallback cb'
        connectSignalFunPtr obj "emoji-picked" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.EmojiChooser::emoji-picked"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-EmojiChooser.html#g:signal:emojiPicked"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EmojiChooser
type instance O.AttributeList EmojiChooser = EmojiChooserAttributeList
type EmojiChooserAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("autohide", Gtk.Popover.PopoverAutohidePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cascadePopdown", Gtk.Popover.PopoverCascadePopdownPropertyInfo), '("child", Gtk.Popover.PopoverChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("defaultWidget", Gtk.Popover.PopoverDefaultWidgetPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasArrow", Gtk.Popover.PopoverHasArrowPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("mnemonicsVisible", Gtk.Popover.PopoverMnemonicsVisiblePropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("pointingTo", Gtk.Popover.PopoverPointingToPropertyInfo), '("position", Gtk.Popover.PopoverPositionPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList EmojiChooser = EmojiChooserSignalList
type EmojiChooserSignalList = ('[ '("activateDefault", Gtk.Popover.PopoverActivateDefaultSignalInfo), '("closed", Gtk.Popover.PopoverClosedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("emojiPicked", EmojiChooserEmojiPickedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method EmojiChooser::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "EmojiChooser" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_emoji_chooser_new" gtk_emoji_chooser_new :: 
    IO (Ptr EmojiChooser)

-- | Creates a new @GtkEmojiChooser@.
emojiChooserNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m EmojiChooser
    -- ^ __Returns:__ a new @GtkEmojiChooser@
emojiChooserNew  = liftIO $ do
    result <- gtk_emoji_chooser_new
    checkUnexpectedReturnNULL "emojiChooserNew" result
    result' <- (newObject EmojiChooser) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


