{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Allows the user to choose an item from a list of options.
-- 
-- \<picture>
--   \<source srcset=\"drop-down-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkDropDown\" src=\"drop-down.png\">
-- \<\/picture>
-- 
-- The @GtkDropDown@ displays the [selected][DropDown:selected]("GI.Gtk.Objects.DropDown#g:attr:selected")
-- choice.
-- 
-- The options are given to @GtkDropDown@ in the form of @GListModel@
-- and how the individual options are represented is determined by
-- a t'GI.Gtk.Objects.ListItemFactory.ListItemFactory'. The default factory displays simple strings,
-- and adds a checkmark to the selected item in the popup.
-- 
-- To set your own factory, use 'GI.Gtk.Objects.DropDown.dropDownSetFactory'. It is
-- possible to use a separate factory for the items in the popup, with
-- 'GI.Gtk.Objects.DropDown.dropDownSetListFactory'.
-- 
-- @GtkDropDown@ knows how to obtain strings from the items in a
-- t'GI.Gtk.Objects.StringList.StringList'; for other models, you have to provide an expression
-- to find the strings via 'GI.Gtk.Objects.DropDown.dropDownSetExpression'.
-- 
-- @GtkDropDown@ can optionally allow search in the popup, which is
-- useful if the list of options is long. To enable the search entry,
-- use 'GI.Gtk.Objects.DropDown.dropDownSetEnableSearch'.
-- 
-- Here is a UI definition example for @GtkDropDown@ with a simple model:
-- 
-- 
-- === /xml code/
-- ><object class="GtkDropDown">
-- >  <property name="model">
-- >    <object class="GtkStringList">
-- >      <items>
-- >        <item translatable="yes">Factory</item>
-- >        <item translatable="yes">Home</item>
-- >        <item translatable="yes">Subway</item>
-- >      </items>
-- >    </object>
-- >  </property>
-- ></object>
-- 
-- 
-- If a @GtkDropDown@ is created in this manner, or with
-- 'GI.Gtk.Objects.DropDown.dropDownNewFromStrings', for instance, the object returned from
-- 'GI.Gtk.Objects.DropDown.dropDownGetSelectedItem' will be a t'GI.Gtk.Objects.StringObject.StringObject'.
-- 
-- To learn more about the list widget framework, see the
-- <https://docs.gtk.org/gtk4/section-list-widget.html overview>.
-- 
-- == CSS nodes
-- 
-- @GtkDropDown@ has a single CSS node with name dropdown,
-- with the button and popover nodes as children.
-- 
-- == Accessibility
-- 
-- @GtkDropDown@ uses the [enum/@gtk@/.AccessibleRole.combo_box] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.DropDown
    ( 

-- * Exported types
    DropDown(..)                            ,
    IsDropDown                              ,
    toDropDown                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEnableSearch]("GI.Gtk.Objects.DropDown#g:method:getEnableSearch"), [getExpression]("GI.Gtk.Objects.DropDown#g:method:getExpression"), [getFactory]("GI.Gtk.Objects.DropDown#g:method:getFactory"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeaderFactory]("GI.Gtk.Objects.DropDown#g:method:getHeaderFactory"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getListFactory]("GI.Gtk.Objects.DropDown#g:method:getListFactory"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getModel]("GI.Gtk.Objects.DropDown#g:method:getModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSearchMatchMode]("GI.Gtk.Objects.DropDown#g:method:getSearchMatchMode"), [getSelected]("GI.Gtk.Objects.DropDown#g:method:getSelected"), [getSelectedItem]("GI.Gtk.Objects.DropDown#g:method:getSelectedItem"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowArrow]("GI.Gtk.Objects.DropDown#g:method:getShowArrow"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEnableSearch]("GI.Gtk.Objects.DropDown#g:method:setEnableSearch"), [setExpression]("GI.Gtk.Objects.DropDown#g:method:setExpression"), [setFactory]("GI.Gtk.Objects.DropDown#g:method:setFactory"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHeaderFactory]("GI.Gtk.Objects.DropDown#g:method:setHeaderFactory"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setListFactory]("GI.Gtk.Objects.DropDown#g:method:setListFactory"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setModel]("GI.Gtk.Objects.DropDown#g:method:setModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSearchMatchMode]("GI.Gtk.Objects.DropDown#g:method:setSearchMatchMode"), [setSelected]("GI.Gtk.Objects.DropDown#g:method:setSelected"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowArrow]("GI.Gtk.Objects.DropDown#g:method:setShowArrow"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveDropDownMethod                   ,
#endif

-- ** getEnableSearch #method:getEnableSearch#

#if defined(ENABLE_OVERLOADING)
    DropDownGetEnableSearchMethodInfo       ,
#endif
    dropDownGetEnableSearch                 ,


-- ** getExpression #method:getExpression#

#if defined(ENABLE_OVERLOADING)
    DropDownGetExpressionMethodInfo         ,
#endif
    dropDownGetExpression                   ,


-- ** getFactory #method:getFactory#

#if defined(ENABLE_OVERLOADING)
    DropDownGetFactoryMethodInfo            ,
#endif
    dropDownGetFactory                      ,


-- ** getHeaderFactory #method:getHeaderFactory#

#if defined(ENABLE_OVERLOADING)
    DropDownGetHeaderFactoryMethodInfo      ,
#endif
    dropDownGetHeaderFactory                ,


-- ** getListFactory #method:getListFactory#

#if defined(ENABLE_OVERLOADING)
    DropDownGetListFactoryMethodInfo        ,
#endif
    dropDownGetListFactory                  ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    DropDownGetModelMethodInfo              ,
#endif
    dropDownGetModel                        ,


-- ** getSearchMatchMode #method:getSearchMatchMode#

#if defined(ENABLE_OVERLOADING)
    DropDownGetSearchMatchModeMethodInfo    ,
#endif
    dropDownGetSearchMatchMode              ,


-- ** getSelected #method:getSelected#

#if defined(ENABLE_OVERLOADING)
    DropDownGetSelectedMethodInfo           ,
#endif
    dropDownGetSelected                     ,


-- ** getSelectedItem #method:getSelectedItem#

#if defined(ENABLE_OVERLOADING)
    DropDownGetSelectedItemMethodInfo       ,
#endif
    dropDownGetSelectedItem                 ,


-- ** getShowArrow #method:getShowArrow#

#if defined(ENABLE_OVERLOADING)
    DropDownGetShowArrowMethodInfo          ,
#endif
    dropDownGetShowArrow                    ,


-- ** new #method:new#

    dropDownNew                             ,


-- ** newFromStrings #method:newFromStrings#

    dropDownNewFromStrings                  ,


-- ** setEnableSearch #method:setEnableSearch#

#if defined(ENABLE_OVERLOADING)
    DropDownSetEnableSearchMethodInfo       ,
#endif
    dropDownSetEnableSearch                 ,


-- ** setExpression #method:setExpression#

#if defined(ENABLE_OVERLOADING)
    DropDownSetExpressionMethodInfo         ,
#endif
    dropDownSetExpression                   ,


-- ** setFactory #method:setFactory#

#if defined(ENABLE_OVERLOADING)
    DropDownSetFactoryMethodInfo            ,
#endif
    dropDownSetFactory                      ,


-- ** setHeaderFactory #method:setHeaderFactory#

#if defined(ENABLE_OVERLOADING)
    DropDownSetHeaderFactoryMethodInfo      ,
#endif
    dropDownSetHeaderFactory                ,


-- ** setListFactory #method:setListFactory#

#if defined(ENABLE_OVERLOADING)
    DropDownSetListFactoryMethodInfo        ,
#endif
    dropDownSetListFactory                  ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    DropDownSetModelMethodInfo              ,
#endif
    dropDownSetModel                        ,


-- ** setSearchMatchMode #method:setSearchMatchMode#

#if defined(ENABLE_OVERLOADING)
    DropDownSetSearchMatchModeMethodInfo    ,
#endif
    dropDownSetSearchMatchMode              ,


-- ** setSelected #method:setSelected#

#if defined(ENABLE_OVERLOADING)
    DropDownSetSelectedMethodInfo           ,
#endif
    dropDownSetSelected                     ,


-- ** setShowArrow #method:setShowArrow#

#if defined(ENABLE_OVERLOADING)
    DropDownSetShowArrowMethodInfo          ,
#endif
    dropDownSetShowArrow                    ,




 -- * Properties


-- ** enableSearch #attr:enableSearch#
-- | Whether to show a search entry in the popup.
-- 
-- Note that search requires [DropDown:expression]("GI.Gtk.Objects.DropDown#g:attr:expression")
-- to be set.

#if defined(ENABLE_OVERLOADING)
    DropDownEnableSearchPropertyInfo        ,
#endif
    constructDropDownEnableSearch           ,
#if defined(ENABLE_OVERLOADING)
    dropDownEnableSearch                    ,
#endif
    getDropDownEnableSearch                 ,
    setDropDownEnableSearch                 ,


-- ** expression #attr:expression#
-- | An expression to evaluate to obtain strings to match against the search
-- term.
-- 
-- See [DropDown:enableSearch]("GI.Gtk.Objects.DropDown#g:attr:enableSearch") for how to enable search.
-- If [DropDown:factory]("GI.Gtk.Objects.DropDown#g:attr:factory") is not set, the expression is also
-- used to bind strings to labels produced by a default factory.

#if defined(ENABLE_OVERLOADING)
    DropDownExpressionPropertyInfo          ,
#endif
    clearDropDownExpression                 ,
    constructDropDownExpression             ,
#if defined(ENABLE_OVERLOADING)
    dropDownExpression                      ,
#endif
    getDropDownExpression                   ,
    setDropDownExpression                   ,


-- ** factory #attr:factory#
-- | Factory for populating list items.

#if defined(ENABLE_OVERLOADING)
    DropDownFactoryPropertyInfo             ,
#endif
    clearDropDownFactory                    ,
    constructDropDownFactory                ,
#if defined(ENABLE_OVERLOADING)
    dropDownFactory                         ,
#endif
    getDropDownFactory                      ,
    setDropDownFactory                      ,


-- ** headerFactory #attr:headerFactory#
-- | The factory for creating header widgets for the popup.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    DropDownHeaderFactoryPropertyInfo       ,
#endif
    clearDropDownHeaderFactory              ,
    constructDropDownHeaderFactory          ,
#if defined(ENABLE_OVERLOADING)
    dropDownHeaderFactory                   ,
#endif
    getDropDownHeaderFactory                ,
    setDropDownHeaderFactory                ,


-- ** listFactory #attr:listFactory#
-- | The factory for populating list items in the popup.
-- 
-- If this is not set, [DropDown:factory]("GI.Gtk.Objects.DropDown#g:attr:factory") is used.

#if defined(ENABLE_OVERLOADING)
    DropDownListFactoryPropertyInfo         ,
#endif
    clearDropDownListFactory                ,
    constructDropDownListFactory            ,
#if defined(ENABLE_OVERLOADING)
    dropDownListFactory                     ,
#endif
    getDropDownListFactory                  ,
    setDropDownListFactory                  ,


-- ** model #attr:model#
-- | Model for the displayed items.

#if defined(ENABLE_OVERLOADING)
    DropDownModelPropertyInfo               ,
#endif
    clearDropDownModel                      ,
    constructDropDownModel                  ,
#if defined(ENABLE_OVERLOADING)
    dropDownModel                           ,
#endif
    getDropDownModel                        ,
    setDropDownModel                        ,


-- ** searchMatchMode #attr:searchMatchMode#
-- | The match mode for the search filter.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    DropDownSearchMatchModePropertyInfo     ,
#endif
    constructDropDownSearchMatchMode        ,
#if defined(ENABLE_OVERLOADING)
    dropDownSearchMatchMode                 ,
#endif
    getDropDownSearchMatchMode              ,
    setDropDownSearchMatchMode              ,


-- ** selected #attr:selected#
-- | The position of the selected item.
-- 
-- If no item is selected, the property has the value
-- 'GI.Gtk.Constants.INVALID_LIST_POSITION'.

#if defined(ENABLE_OVERLOADING)
    DropDownSelectedPropertyInfo            ,
#endif
    constructDropDownSelected               ,
#if defined(ENABLE_OVERLOADING)
    dropDownSelected                        ,
#endif
    getDropDownSelected                     ,
    setDropDownSelected                     ,


-- ** selectedItem #attr:selectedItem#
-- | The selected item.

#if defined(ENABLE_OVERLOADING)
    DropDownSelectedItemPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    dropDownSelectedItem                    ,
#endif
    getDropDownSelectedItem                 ,


-- ** showArrow #attr:showArrow#
-- | Whether to show an arrow within the GtkDropDown widget.
-- 
-- /Since: 4.6/

#if defined(ENABLE_OVERLOADING)
    DropDownShowArrowPropertyInfo           ,
#endif
    constructDropDownShowArrow              ,
#if defined(ENABLE_OVERLOADING)
    dropDownShowArrow                       ,
#endif
    getDropDownShowArrow                    ,
    setDropDownShowArrow                    ,




 -- * Signals


-- ** activate #signal:activate#

    DropDownActivateCallback                ,
#if defined(ENABLE_OVERLOADING)
    DropDownActivateSignalInfo              ,
#endif
    afterDropDownActivate                   ,
    onDropDownActivate                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype DropDown = DropDown (SP.ManagedPtr DropDown)
    deriving (Eq)

instance SP.ManagedPtrNewtype DropDown where
    toManagedPtr (DropDown p) = p

foreign import ccall "gtk_drop_down_get_type"
    c_gtk_drop_down_get_type :: IO B.Types.GType

instance B.Types.TypedObject DropDown where
    glibType = c_gtk_drop_down_get_type

instance B.Types.GObject DropDown

-- | Type class for types which can be safely cast to `DropDown`, for instance with `toDropDown`.
class (SP.GObject o, O.IsDescendantOf DropDown o) => IsDropDown o
instance (SP.GObject o, O.IsDescendantOf DropDown o) => IsDropDown o

instance O.HasParentTypes DropDown
type instance O.ParentTypes DropDown = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `DropDown`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDropDown :: (MIO.MonadIO m, IsDropDown o) => o -> m DropDown
toDropDown = MIO.liftIO . B.ManagedPtr.unsafeCastTo DropDown

-- | Convert 'DropDown' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DropDown) where
    gvalueGType_ = c_gtk_drop_down_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DropDown)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DropDown)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DropDown ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDropDownMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDropDownMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveDropDownMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveDropDownMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveDropDownMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveDropDownMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveDropDownMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveDropDownMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveDropDownMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveDropDownMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveDropDownMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveDropDownMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDropDownMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDropDownMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveDropDownMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveDropDownMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveDropDownMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveDropDownMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveDropDownMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveDropDownMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveDropDownMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveDropDownMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveDropDownMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveDropDownMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveDropDownMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDropDownMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDropDownMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDropDownMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveDropDownMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveDropDownMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveDropDownMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveDropDownMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveDropDownMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveDropDownMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveDropDownMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveDropDownMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveDropDownMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveDropDownMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveDropDownMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveDropDownMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveDropDownMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDropDownMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveDropDownMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveDropDownMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveDropDownMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveDropDownMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveDropDownMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveDropDownMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveDropDownMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveDropDownMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDropDownMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDropDownMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveDropDownMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveDropDownMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveDropDownMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveDropDownMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveDropDownMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveDropDownMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveDropDownMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDropDownMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDropDownMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveDropDownMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveDropDownMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveDropDownMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveDropDownMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveDropDownMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveDropDownMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveDropDownMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDropDownMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveDropDownMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveDropDownMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveDropDownMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveDropDownMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDropDownMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDropDownMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDropDownMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveDropDownMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveDropDownMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveDropDownMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveDropDownMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveDropDownMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDropDownMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveDropDownMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveDropDownMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveDropDownMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveDropDownMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveDropDownMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveDropDownMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDropDownMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveDropDownMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveDropDownMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveDropDownMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveDropDownMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveDropDownMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveDropDownMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveDropDownMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveDropDownMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveDropDownMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveDropDownMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveDropDownMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveDropDownMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveDropDownMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveDropDownMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveDropDownMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveDropDownMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveDropDownMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveDropDownMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveDropDownMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDropDownMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveDropDownMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveDropDownMethod "getEnableSearch" o = DropDownGetEnableSearchMethodInfo
    ResolveDropDownMethod "getExpression" o = DropDownGetExpressionMethodInfo
    ResolveDropDownMethod "getFactory" o = DropDownGetFactoryMethodInfo
    ResolveDropDownMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveDropDownMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveDropDownMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveDropDownMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveDropDownMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveDropDownMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveDropDownMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveDropDownMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveDropDownMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveDropDownMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveDropDownMethod "getHeaderFactory" o = DropDownGetHeaderFactoryMethodInfo
    ResolveDropDownMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveDropDownMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveDropDownMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveDropDownMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveDropDownMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveDropDownMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveDropDownMethod "getListFactory" o = DropDownGetListFactoryMethodInfo
    ResolveDropDownMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveDropDownMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveDropDownMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveDropDownMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveDropDownMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveDropDownMethod "getModel" o = DropDownGetModelMethodInfo
    ResolveDropDownMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveDropDownMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveDropDownMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveDropDownMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveDropDownMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveDropDownMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveDropDownMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveDropDownMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveDropDownMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveDropDownMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveDropDownMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveDropDownMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveDropDownMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDropDownMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDropDownMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveDropDownMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveDropDownMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveDropDownMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveDropDownMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveDropDownMethod "getSearchMatchMode" o = DropDownGetSearchMatchModeMethodInfo
    ResolveDropDownMethod "getSelected" o = DropDownGetSelectedMethodInfo
    ResolveDropDownMethod "getSelectedItem" o = DropDownGetSelectedItemMethodInfo
    ResolveDropDownMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveDropDownMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveDropDownMethod "getShowArrow" o = DropDownGetShowArrowMethodInfo
    ResolveDropDownMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveDropDownMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveDropDownMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveDropDownMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveDropDownMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveDropDownMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveDropDownMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveDropDownMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveDropDownMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveDropDownMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveDropDownMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveDropDownMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveDropDownMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveDropDownMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveDropDownMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveDropDownMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveDropDownMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveDropDownMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveDropDownMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveDropDownMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDropDownMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDropDownMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveDropDownMethod "setEnableSearch" o = DropDownSetEnableSearchMethodInfo
    ResolveDropDownMethod "setExpression" o = DropDownSetExpressionMethodInfo
    ResolveDropDownMethod "setFactory" o = DropDownSetFactoryMethodInfo
    ResolveDropDownMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveDropDownMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveDropDownMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveDropDownMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveDropDownMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveDropDownMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveDropDownMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveDropDownMethod "setHeaderFactory" o = DropDownSetHeaderFactoryMethodInfo
    ResolveDropDownMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveDropDownMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveDropDownMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveDropDownMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveDropDownMethod "setListFactory" o = DropDownSetListFactoryMethodInfo
    ResolveDropDownMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveDropDownMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveDropDownMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveDropDownMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveDropDownMethod "setModel" o = DropDownSetModelMethodInfo
    ResolveDropDownMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveDropDownMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveDropDownMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveDropDownMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveDropDownMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDropDownMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveDropDownMethod "setSearchMatchMode" o = DropDownSetSearchMatchModeMethodInfo
    ResolveDropDownMethod "setSelected" o = DropDownSetSelectedMethodInfo
    ResolveDropDownMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveDropDownMethod "setShowArrow" o = DropDownSetShowArrowMethodInfo
    ResolveDropDownMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveDropDownMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveDropDownMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveDropDownMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveDropDownMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveDropDownMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveDropDownMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveDropDownMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveDropDownMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDropDownMethod t DropDown, O.OverloadedMethod info DropDown p) => OL.IsLabel t (DropDown -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDropDownMethod t DropDown, O.OverloadedMethod info DropDown p, R.HasField t DropDown p) => R.HasField t DropDown p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDropDownMethod t DropDown, O.OverloadedMethodInfo info DropDown) => OL.IsLabel t (O.MethodProxy info DropDown) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal DropDown::activate
-- | Emitted to when the drop down is activated.
-- 
-- The @::activate@ signal on @GtkDropDown@ is an action signal and
-- emitting it causes the drop down to pop up its dropdown.
-- 
-- /Since: 4.6/
type DropDownActivateCallback =
    IO ()

type C_DropDownActivateCallback =
    Ptr DropDown ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DropDownActivateCallback`.
foreign import ccall "wrapper"
    mk_DropDownActivateCallback :: C_DropDownActivateCallback -> IO (FunPtr C_DropDownActivateCallback)

wrap_DropDownActivateCallback :: 
    GObject a => (a -> DropDownActivateCallback) ->
    C_DropDownActivateCallback
wrap_DropDownActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dropDown #activate callback
-- @
-- 
-- 
onDropDownActivate :: (IsDropDown a, MonadIO m) => a -> ((?self :: a) => DropDownActivateCallback) -> m SignalHandlerId
onDropDownActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropDownActivateCallback wrapped
    wrapped'' <- mk_DropDownActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dropDown #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDropDownActivate :: (IsDropDown a, MonadIO m) => a -> ((?self :: a) => DropDownActivateCallback) -> m SignalHandlerId
afterDropDownActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropDownActivateCallback wrapped
    wrapped'' <- mk_DropDownActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DropDownActivateSignalInfo
instance SignalInfo DropDownActivateSignalInfo where
    type HaskellCallbackType DropDownActivateSignalInfo = DropDownActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DropDownActivateCallback cb
        cb'' <- mk_DropDownActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:signal:activate"})

#endif

-- VVV Prop "enable-search"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@enable-search@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #enableSearch
-- @
getDropDownEnableSearch :: (MonadIO m, IsDropDown o) => o -> m Bool
getDropDownEnableSearch obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enable-search"

-- | Set the value of the “@enable-search@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #enableSearch 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownEnableSearch :: (MonadIO m, IsDropDown o) => o -> Bool -> m ()
setDropDownEnableSearch obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enable-search" val

-- | Construct a `GValueConstruct` with valid value for the “@enable-search@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownEnableSearch :: (IsDropDown o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructDropDownEnableSearch val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enable-search" val

#if defined(ENABLE_OVERLOADING)
data DropDownEnableSearchPropertyInfo
instance AttrInfo DropDownEnableSearchPropertyInfo where
    type AttrAllowedOps DropDownEnableSearchPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DropDownEnableSearchPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownEnableSearchPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint DropDownEnableSearchPropertyInfo = (~) Bool
    type AttrTransferType DropDownEnableSearchPropertyInfo = Bool
    type AttrGetType DropDownEnableSearchPropertyInfo = Bool
    type AttrLabel DropDownEnableSearchPropertyInfo = "enable-search"
    type AttrOrigin DropDownEnableSearchPropertyInfo = DropDown
    attrGet = getDropDownEnableSearch
    attrSet = setDropDownEnableSearch
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropDownEnableSearch
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.enableSearch"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:enableSearch"
        })
#endif

-- VVV Prop "expression"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Expression"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #expression
-- @
getDropDownExpression :: (MonadIO m, IsDropDown o) => o -> m (Maybe Gtk.Expression.Expression)
getDropDownExpression obj = MIO.liftIO $ B.Properties.getObjectPropertyIsGValueInstance obj "expression"

-- | Set the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #expression 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownExpression :: (MonadIO m, IsDropDown o, Gtk.Expression.IsExpression a) => o -> a -> m ()
setDropDownExpression obj val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Just val')

-- | Construct a `GValueConstruct` with valid value for the “@expression@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownExpression :: (IsDropDown o, MIO.MonadIO m, Gtk.Expression.IsExpression a) => a -> m (GValueConstruct o)
constructDropDownExpression val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    MIO.liftIO $ B.Properties.constructObjectPropertyIsGValueInstance "expression" (P.Just val')

-- | Set the value of the “@expression@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #expression
-- @
clearDropDownExpression :: (MonadIO m, IsDropDown o) => o -> m ()
clearDropDownExpression obj = liftIO $ B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Nothing :: Maybe Gtk.Expression.Expression)

#if defined(ENABLE_OVERLOADING)
data DropDownExpressionPropertyInfo
instance AttrInfo DropDownExpressionPropertyInfo where
    type AttrAllowedOps DropDownExpressionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDownExpressionPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferTypeConstraint DropDownExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferType DropDownExpressionPropertyInfo = Gtk.Expression.Expression
    type AttrGetType DropDownExpressionPropertyInfo = (Maybe Gtk.Expression.Expression)
    type AttrLabel DropDownExpressionPropertyInfo = "expression"
    type AttrOrigin DropDownExpressionPropertyInfo = DropDown
    attrGet = getDropDownExpression
    attrSet = setDropDownExpression
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropDownExpression
    attrClear = clearDropDownExpression
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.expression"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:expression"
        })
#endif

-- VVV Prop "factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #factory
-- @
getDropDownFactory :: (MonadIO m, IsDropDown o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getDropDownFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #factory 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownFactory :: (MonadIO m, IsDropDown o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setDropDownFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "factory" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownFactory :: (IsDropDown o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructDropDownFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "factory" (P.Just val)

-- | Set the value of the “@factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #factory
-- @
clearDropDownFactory :: (MonadIO m, IsDropDown o) => o -> m ()
clearDropDownFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data DropDownFactoryPropertyInfo
instance AttrInfo DropDownFactoryPropertyInfo where
    type AttrAllowedOps DropDownFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDownFactoryPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint DropDownFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType DropDownFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType DropDownFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel DropDownFactoryPropertyInfo = "factory"
    type AttrOrigin DropDownFactoryPropertyInfo = DropDown
    attrGet = getDropDownFactory
    attrSet = setDropDownFactory
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructDropDownFactory
    attrClear = clearDropDownFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.factory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:factory"
        })
#endif

-- VVV Prop "header-factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@header-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #headerFactory
-- @
getDropDownHeaderFactory :: (MonadIO m, IsDropDown o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getDropDownHeaderFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "header-factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@header-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #headerFactory 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownHeaderFactory :: (MonadIO m, IsDropDown o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setDropDownHeaderFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "header-factory" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@header-factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownHeaderFactory :: (IsDropDown o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructDropDownHeaderFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "header-factory" (P.Just val)

-- | Set the value of the “@header-factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #headerFactory
-- @
clearDropDownHeaderFactory :: (MonadIO m, IsDropDown o) => o -> m ()
clearDropDownHeaderFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "header-factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data DropDownHeaderFactoryPropertyInfo
instance AttrInfo DropDownHeaderFactoryPropertyInfo where
    type AttrAllowedOps DropDownHeaderFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDownHeaderFactoryPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownHeaderFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint DropDownHeaderFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType DropDownHeaderFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType DropDownHeaderFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel DropDownHeaderFactoryPropertyInfo = "header-factory"
    type AttrOrigin DropDownHeaderFactoryPropertyInfo = DropDown
    attrGet = getDropDownHeaderFactory
    attrSet = setDropDownHeaderFactory
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructDropDownHeaderFactory
    attrClear = clearDropDownHeaderFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.headerFactory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:headerFactory"
        })
#endif

-- VVV Prop "list-factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@list-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #listFactory
-- @
getDropDownListFactory :: (MonadIO m, IsDropDown o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getDropDownListFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "list-factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@list-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #listFactory 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownListFactory :: (MonadIO m, IsDropDown o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setDropDownListFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "list-factory" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@list-factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownListFactory :: (IsDropDown o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructDropDownListFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "list-factory" (P.Just val)

-- | Set the value of the “@list-factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #listFactory
-- @
clearDropDownListFactory :: (MonadIO m, IsDropDown o) => o -> m ()
clearDropDownListFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "list-factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data DropDownListFactoryPropertyInfo
instance AttrInfo DropDownListFactoryPropertyInfo where
    type AttrAllowedOps DropDownListFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDownListFactoryPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownListFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint DropDownListFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType DropDownListFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType DropDownListFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel DropDownListFactoryPropertyInfo = "list-factory"
    type AttrOrigin DropDownListFactoryPropertyInfo = DropDown
    attrGet = getDropDownListFactory
    attrSet = setDropDownListFactory
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructDropDownListFactory
    attrClear = clearDropDownListFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.listFactory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:listFactory"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #model
-- @
getDropDownModel :: (MonadIO m, IsDropDown o) => o -> m (Maybe Gio.ListModel.ListModel)
getDropDownModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gio.ListModel.ListModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownModel :: (MonadIO m, IsDropDown o, Gio.ListModel.IsListModel a) => o -> a -> m ()
setDropDownModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownModel :: (IsDropDown o, MIO.MonadIO m, Gio.ListModel.IsListModel a) => a -> m (GValueConstruct o)
constructDropDownModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearDropDownModel :: (MonadIO m, IsDropDown o) => o -> m ()
clearDropDownModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gio.ListModel.ListModel)

#if defined(ENABLE_OVERLOADING)
data DropDownModelPropertyInfo
instance AttrInfo DropDownModelPropertyInfo where
    type AttrAllowedOps DropDownModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDownModelPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferTypeConstraint DropDownModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferType DropDownModelPropertyInfo = Gio.ListModel.ListModel
    type AttrGetType DropDownModelPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel DropDownModelPropertyInfo = "model"
    type AttrOrigin DropDownModelPropertyInfo = DropDown
    attrGet = getDropDownModel
    attrSet = setDropDownModel
    attrTransfer _ v = do
        unsafeCastTo Gio.ListModel.ListModel v
    attrConstruct = constructDropDownModel
    attrClear = clearDropDownModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:model"
        })
#endif

-- VVV Prop "search-match-mode"
   -- Type: TInterface (Name {namespace = "Gtk", name = "StringFilterMatchMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@search-match-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #searchMatchMode
-- @
getDropDownSearchMatchMode :: (MonadIO m, IsDropDown o) => o -> m Gtk.Enums.StringFilterMatchMode
getDropDownSearchMatchMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "search-match-mode"

-- | Set the value of the “@search-match-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #searchMatchMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownSearchMatchMode :: (MonadIO m, IsDropDown o) => o -> Gtk.Enums.StringFilterMatchMode -> m ()
setDropDownSearchMatchMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "search-match-mode" val

-- | Construct a `GValueConstruct` with valid value for the “@search-match-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownSearchMatchMode :: (IsDropDown o, MIO.MonadIO m) => Gtk.Enums.StringFilterMatchMode -> m (GValueConstruct o)
constructDropDownSearchMatchMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "search-match-mode" val

#if defined(ENABLE_OVERLOADING)
data DropDownSearchMatchModePropertyInfo
instance AttrInfo DropDownSearchMatchModePropertyInfo where
    type AttrAllowedOps DropDownSearchMatchModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DropDownSearchMatchModePropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownSearchMatchModePropertyInfo = (~) Gtk.Enums.StringFilterMatchMode
    type AttrTransferTypeConstraint DropDownSearchMatchModePropertyInfo = (~) Gtk.Enums.StringFilterMatchMode
    type AttrTransferType DropDownSearchMatchModePropertyInfo = Gtk.Enums.StringFilterMatchMode
    type AttrGetType DropDownSearchMatchModePropertyInfo = Gtk.Enums.StringFilterMatchMode
    type AttrLabel DropDownSearchMatchModePropertyInfo = "search-match-mode"
    type AttrOrigin DropDownSearchMatchModePropertyInfo = DropDown
    attrGet = getDropDownSearchMatchMode
    attrSet = setDropDownSearchMatchMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropDownSearchMatchMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.searchMatchMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:searchMatchMode"
        })
#endif

-- VVV Prop "selected"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@selected@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #selected
-- @
getDropDownSelected :: (MonadIO m, IsDropDown o) => o -> m Word32
getDropDownSelected obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "selected"

-- | Set the value of the “@selected@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #selected 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownSelected :: (MonadIO m, IsDropDown o) => o -> Word32 -> m ()
setDropDownSelected obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "selected" val

-- | Construct a `GValueConstruct` with valid value for the “@selected@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownSelected :: (IsDropDown o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructDropDownSelected val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "selected" val

#if defined(ENABLE_OVERLOADING)
data DropDownSelectedPropertyInfo
instance AttrInfo DropDownSelectedPropertyInfo where
    type AttrAllowedOps DropDownSelectedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DropDownSelectedPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownSelectedPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint DropDownSelectedPropertyInfo = (~) Word32
    type AttrTransferType DropDownSelectedPropertyInfo = Word32
    type AttrGetType DropDownSelectedPropertyInfo = Word32
    type AttrLabel DropDownSelectedPropertyInfo = "selected"
    type AttrOrigin DropDownSelectedPropertyInfo = DropDown
    attrGet = getDropDownSelected
    attrSet = setDropDownSelected
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropDownSelected
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.selected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:selected"
        })
#endif

-- VVV Prop "selected-item"
   -- Type: TInterface (Name {namespace = "GObject", name = "Object"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@selected-item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #selectedItem
-- @
getDropDownSelectedItem :: (MonadIO m, IsDropDown o) => o -> m (Maybe GObject.Object.Object)
getDropDownSelectedItem obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "selected-item" GObject.Object.Object

#if defined(ENABLE_OVERLOADING)
data DropDownSelectedItemPropertyInfo
instance AttrInfo DropDownSelectedItemPropertyInfo where
    type AttrAllowedOps DropDownSelectedItemPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDownSelectedItemPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownSelectedItemPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DropDownSelectedItemPropertyInfo = (~) ()
    type AttrTransferType DropDownSelectedItemPropertyInfo = ()
    type AttrGetType DropDownSelectedItemPropertyInfo = (Maybe GObject.Object.Object)
    type AttrLabel DropDownSelectedItemPropertyInfo = "selected-item"
    type AttrOrigin DropDownSelectedItemPropertyInfo = DropDown
    attrGet = getDropDownSelectedItem
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.selectedItem"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:selectedItem"
        })
#endif

-- VVV Prop "show-arrow"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-arrow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropDown #showArrow
-- @
getDropDownShowArrow :: (MonadIO m, IsDropDown o) => o -> m Bool
getDropDownShowArrow obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-arrow"

-- | Set the value of the “@show-arrow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropDown [ #showArrow 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropDownShowArrow :: (MonadIO m, IsDropDown o) => o -> Bool -> m ()
setDropDownShowArrow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-arrow" val

-- | Construct a `GValueConstruct` with valid value for the “@show-arrow@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDownShowArrow :: (IsDropDown o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructDropDownShowArrow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-arrow" val

#if defined(ENABLE_OVERLOADING)
data DropDownShowArrowPropertyInfo
instance AttrInfo DropDownShowArrowPropertyInfo where
    type AttrAllowedOps DropDownShowArrowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DropDownShowArrowPropertyInfo = IsDropDown
    type AttrSetTypeConstraint DropDownShowArrowPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint DropDownShowArrowPropertyInfo = (~) Bool
    type AttrTransferType DropDownShowArrowPropertyInfo = Bool
    type AttrGetType DropDownShowArrowPropertyInfo = Bool
    type AttrLabel DropDownShowArrowPropertyInfo = "show-arrow"
    type AttrOrigin DropDownShowArrowPropertyInfo = DropDown
    attrGet = getDropDownShowArrow
    attrSet = setDropDownShowArrow
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropDownShowArrow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.showArrow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#g:attr:showArrow"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DropDown
type instance O.AttributeList DropDown = DropDownAttributeList
type DropDownAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("enableSearch", DropDownEnableSearchPropertyInfo), '("expression", DropDownExpressionPropertyInfo), '("factory", DropDownFactoryPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("headerFactory", DropDownHeaderFactoryPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("listFactory", DropDownListFactoryPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("model", DropDownModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("searchMatchMode", DropDownSearchMatchModePropertyInfo), '("selected", DropDownSelectedPropertyInfo), '("selectedItem", DropDownSelectedItemPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showArrow", DropDownShowArrowPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dropDownEnableSearch :: AttrLabelProxy "enableSearch"
dropDownEnableSearch = AttrLabelProxy

dropDownExpression :: AttrLabelProxy "expression"
dropDownExpression = AttrLabelProxy

dropDownFactory :: AttrLabelProxy "factory"
dropDownFactory = AttrLabelProxy

dropDownHeaderFactory :: AttrLabelProxy "headerFactory"
dropDownHeaderFactory = AttrLabelProxy

dropDownListFactory :: AttrLabelProxy "listFactory"
dropDownListFactory = AttrLabelProxy

dropDownModel :: AttrLabelProxy "model"
dropDownModel = AttrLabelProxy

dropDownSearchMatchMode :: AttrLabelProxy "searchMatchMode"
dropDownSearchMatchMode = AttrLabelProxy

dropDownSelected :: AttrLabelProxy "selected"
dropDownSelected = AttrLabelProxy

dropDownSelectedItem :: AttrLabelProxy "selectedItem"
dropDownSelectedItem = AttrLabelProxy

dropDownShowArrow :: AttrLabelProxy "showArrow"
dropDownShowArrow = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DropDown = DropDownSignalList
type DropDownSignalList = ('[ '("activate", DropDownActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DropDown::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expression to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "DropDown" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_new" gtk_drop_down_new :: 
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO (Ptr DropDown)

-- | Creates a new @GtkDropDown@.
-- 
-- You may want to call 'GI.Gtk.Objects.DropDown.dropDownSetFactory'
-- to set up a way to map its items to widgets.
dropDownNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.ListModel.IsListModel a, Gtk.Expression.IsExpression b) =>
    Maybe (a)
    -- ^ /@model@/: the model to use
    -> Maybe (b)
    -- ^ /@expression@/: the expression to use
    -> m DropDown
    -- ^ __Returns:__ a new @GtkDropDown@
dropDownNew model expression = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- B.ManagedPtr.disownManagedPtr jExpression
            return jExpression'
    result <- gtk_drop_down_new maybeModel maybeExpression
    checkUnexpectedReturnNULL "dropDownNew" result
    result' <- (newObject DropDown) result
    whenJust model touchManagedPtr
    whenJust expression touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DropDown::new_from_strings
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "strings"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The strings to put in the dropdown"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "DropDown" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_new_from_strings" gtk_drop_down_new_from_strings :: 
    Ptr CString ->                          -- strings : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr DropDown)

-- | Creates a new @GtkDropDown@ that is populated with
-- the strings.
dropDownNewFromStrings ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@strings@/: The strings to put in the dropdown
    -> m DropDown
    -- ^ __Returns:__ a new @GtkDropDown@
dropDownNewFromStrings strings = liftIO $ do
    strings' <- packZeroTerminatedUTF8CArray strings
    result <- gtk_drop_down_new_from_strings strings'
    checkUnexpectedReturnNULL "dropDownNewFromStrings" result
    result' <- (newObject DropDown) result
    mapZeroTerminatedCArray freeMem strings'
    freeMem strings'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DropDown::get_enable_search
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_enable_search" gtk_drop_down_get_enable_search :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO CInt

-- | Returns whether search is enabled.
dropDownGetEnableSearch ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the popup includes a search entry
dropDownGetEnableSearch self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_enable_search self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropDownGetEnableSearchMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetEnableSearchMethodInfo a signature where
    overloadedMethod = dropDownGetEnableSearch

instance O.OverloadedMethodInfo DropDownGetEnableSearchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetEnableSearch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetEnableSearch"
        })


#endif

-- method DropDown::get_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_expression" gtk_drop_down_get_expression :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO (Ptr Gtk.Expression.Expression)

-- | Gets the expression set that is used to obtain strings from items.
-- 
-- See 'GI.Gtk.Objects.DropDown.dropDownSetExpression'.
dropDownGetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m (Maybe Gtk.Expression.Expression)
    -- ^ __Returns:__ a @GtkExpression@
dropDownGetExpression self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_expression self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gtk.Expression.Expression) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropDownGetExpressionMethodInfo
instance (signature ~ (m (Maybe Gtk.Expression.Expression)), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetExpressionMethodInfo a signature where
    overloadedMethod = dropDownGetExpression

instance O.OverloadedMethodInfo DropDownGetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetExpression"
        })


#endif

-- method DropDown::get_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_factory" gtk_drop_down_get_factory :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory that\'s currently used to populate list items.
-- 
-- The factory returned by this function is always used for the
-- item in the button. It is also used for items in the popup
-- if [DropDown:listFactory]("GI.Gtk.Objects.DropDown#g:attr:listFactory") is not set.
dropDownGetFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory in use
dropDownGetFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropDownGetFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetFactoryMethodInfo a signature where
    overloadedMethod = dropDownGetFactory

instance O.OverloadedMethodInfo DropDownGetFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetFactory"
        })


#endif

-- method DropDown::get_header_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_header_factory" gtk_drop_down_get_header_factory :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory that\'s currently used to create header widgets for the popup.
-- 
-- /Since: 4.12/
dropDownGetHeaderFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory in use
dropDownGetHeaderFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_header_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropDownGetHeaderFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetHeaderFactoryMethodInfo a signature where
    overloadedMethod = dropDownGetHeaderFactory

instance O.OverloadedMethodInfo DropDownGetHeaderFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetHeaderFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetHeaderFactory"
        })


#endif

-- method DropDown::get_list_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_list_factory" gtk_drop_down_get_list_factory :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory that\'s currently used to populate list items in the popup.
dropDownGetListFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory in use
dropDownGetListFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_list_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropDownGetListFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetListFactoryMethodInfo a signature where
    overloadedMethod = dropDownGetListFactory

instance O.OverloadedMethodInfo DropDownGetListFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetListFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetListFactory"
        })


#endif

-- method DropDown::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_model" gtk_drop_down_get_model :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Gets the model that provides the displayed items.
dropDownGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model in use
dropDownGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropDownGetModelMethodInfo
instance (signature ~ (m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetModelMethodInfo a signature where
    overloadedMethod = dropDownGetModel

instance O.OverloadedMethodInfo DropDownGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetModel"
        })


#endif

-- method DropDown::get_search_match_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "StringFilterMatchMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_search_match_mode" gtk_drop_down_get_search_match_mode :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO CUInt

-- | Returns the match mode that the search filter is using.
-- 
-- /Since: 4.12/
dropDownGetSearchMatchMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m Gtk.Enums.StringFilterMatchMode
    -- ^ __Returns:__ the match mode of the search filter
dropDownGetSearchMatchMode self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_search_match_mode self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropDownGetSearchMatchModeMethodInfo
instance (signature ~ (m Gtk.Enums.StringFilterMatchMode), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetSearchMatchModeMethodInfo a signature where
    overloadedMethod = dropDownGetSearchMatchMode

instance O.OverloadedMethodInfo DropDownGetSearchMatchModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetSearchMatchMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetSearchMatchMode"
        })


#endif

-- method DropDown::get_selected
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_selected" gtk_drop_down_get_selected :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO Word32

-- | Gets the position of the selected item.
dropDownGetSelected ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m Word32
    -- ^ __Returns:__ the position of the selected item, or 'GI.Gtk.Constants.INVALID_LIST_POSITION'
    --   if no item is selected
dropDownGetSelected self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_selected self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data DropDownGetSelectedMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetSelectedMethodInfo a signature where
    overloadedMethod = dropDownGetSelected

instance O.OverloadedMethodInfo DropDownGetSelectedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetSelected",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetSelected"
        })


#endif

-- method DropDown::get_selected_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_selected_item" gtk_drop_down_get_selected_item :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO (Ptr GObject.Object.Object)

-- | Gets the selected item. If no item is selected, 'P.Nothing' is returned.
dropDownGetSelectedItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m (Maybe GObject.Object.Object)
    -- ^ __Returns:__ The selected item
dropDownGetSelectedItem self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_selected_item self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject GObject.Object.Object) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropDownGetSelectedItemMethodInfo
instance (signature ~ (m (Maybe GObject.Object.Object)), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetSelectedItemMethodInfo a signature where
    overloadedMethod = dropDownGetSelectedItem

instance O.OverloadedMethodInfo DropDownGetSelectedItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetSelectedItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetSelectedItem"
        })


#endif

-- method DropDown::get_show_arrow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_get_show_arrow" gtk_drop_down_get_show_arrow :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    IO CInt

-- | Returns whether to show an arrow within the widget.
-- 
-- /Since: 4.6/
dropDownGetShowArrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if an arrow will be shown.
dropDownGetShowArrow self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_down_get_show_arrow self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropDownGetShowArrowMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownGetShowArrowMethodInfo a signature where
    overloadedMethod = dropDownGetShowArrow

instance O.OverloadedMethodInfo DropDownGetShowArrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownGetShowArrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownGetShowArrow"
        })


#endif

-- method DropDown::set_enable_search
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enable_search"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to enable search"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_enable_search" gtk_drop_down_set_enable_search :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    CInt ->                                 -- enable_search : TBasicType TBoolean
    IO ()

-- | Sets whether a search entry will be shown in the popup that
-- allows to search for items in the list.
-- 
-- Note that [DropDown:expression]("GI.Gtk.Objects.DropDown#g:attr:expression") must be set for
-- search to work.
dropDownSetEnableSearch ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Bool
    -- ^ /@enableSearch@/: whether to enable search
    -> m ()
dropDownSetEnableSearch self enableSearch = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let enableSearch' = (P.fromIntegral . P.fromEnum) enableSearch
    gtk_drop_down_set_enable_search self' enableSearch'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetEnableSearchMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownSetEnableSearchMethodInfo a signature where
    overloadedMethod = dropDownSetEnableSearch

instance O.OverloadedMethodInfo DropDownSetEnableSearchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetEnableSearch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetEnableSearch"
        })


#endif

-- method DropDown::set_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpression`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_expression" gtk_drop_down_set_expression :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO ()

-- | Sets the expression that gets evaluated to obtain strings from items.
-- 
-- This is used for search in the popup. The expression must have
-- a value type of @/G_TYPE_STRING/@.
dropDownSetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a, Gtk.Expression.IsExpression b) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Maybe (b)
    -- ^ /@expression@/: a @GtkExpression@
    -> m ()
dropDownSetExpression self expression = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- unsafeManagedPtrCastPtr jExpression
            return jExpression'
    gtk_drop_down_set_expression self' maybeExpression
    touchManagedPtr self
    whenJust expression touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetExpressionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDropDown a, Gtk.Expression.IsExpression b) => O.OverloadedMethod DropDownSetExpressionMethodInfo a signature where
    overloadedMethod = dropDownSetExpression

instance O.OverloadedMethodInfo DropDownSetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetExpression"
        })


#endif

-- method DropDown::set_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the factory to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_factory" gtk_drop_down_set_factory :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the @GtkListItemFactory@ to use for populating list items.
dropDownSetFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Maybe (b)
    -- ^ /@factory@/: the factory to use
    -> m ()
dropDownSetFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_drop_down_set_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDropDown a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod DropDownSetFactoryMethodInfo a signature where
    overloadedMethod = dropDownSetFactory

instance O.OverloadedMethodInfo DropDownSetFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetFactory"
        })


#endif

-- method DropDown::set_header_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the factory to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_header_factory" gtk_drop_down_set_header_factory :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the @GtkListItemFactory@ to use for creating header widgets for the popup.
-- 
-- /Since: 4.12/
dropDownSetHeaderFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Maybe (b)
    -- ^ /@factory@/: the factory to use
    -> m ()
dropDownSetHeaderFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_drop_down_set_header_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetHeaderFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDropDown a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod DropDownSetHeaderFactoryMethodInfo a signature where
    overloadedMethod = dropDownSetHeaderFactory

instance O.OverloadedMethodInfo DropDownSetHeaderFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetHeaderFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetHeaderFactory"
        })


#endif

-- method DropDown::set_list_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the factory to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_list_factory" gtk_drop_down_set_list_factory :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the @GtkListItemFactory@ to use for populating list items in the popup.
dropDownSetListFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Maybe (b)
    -- ^ /@factory@/: the factory to use
    -> m ()
dropDownSetListFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_drop_down_set_list_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetListFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDropDown a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod DropDownSetListFactoryMethodInfo a signature where
    overloadedMethod = dropDownSetListFactory

instance O.OverloadedMethodInfo DropDownSetListFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetListFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetListFactory"
        })


#endif

-- method DropDown::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_model" gtk_drop_down_set_model :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO ()

-- | Sets the @GListModel@ to use.
dropDownSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a, Gio.ListModel.IsListModel b) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Maybe (b)
    -- ^ /@model@/: the model to use
    -> m ()
dropDownSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_drop_down_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDropDown a, Gio.ListModel.IsListModel b) => O.OverloadedMethod DropDownSetModelMethodInfo a signature where
    overloadedMethod = dropDownSetModel

instance O.OverloadedMethodInfo DropDownSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetModel"
        })


#endif

-- method DropDown::set_search_match_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "search_match_mode"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "StringFilterMatchMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new match mode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_search_match_mode" gtk_drop_down_set_search_match_mode :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    CUInt ->                                -- search_match_mode : TInterface (Name {namespace = "Gtk", name = "StringFilterMatchMode"})
    IO ()

-- | Sets the match mode for the search filter.
-- 
-- /Since: 4.12/
dropDownSetSearchMatchMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Gtk.Enums.StringFilterMatchMode
    -- ^ /@searchMatchMode@/: the new match mode
    -> m ()
dropDownSetSearchMatchMode self searchMatchMode = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let searchMatchMode' = (fromIntegral . fromEnum) searchMatchMode
    gtk_drop_down_set_search_match_mode self' searchMatchMode'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetSearchMatchModeMethodInfo
instance (signature ~ (Gtk.Enums.StringFilterMatchMode -> m ()), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownSetSearchMatchModeMethodInfo a signature where
    overloadedMethod = dropDownSetSearchMatchMode

instance O.OverloadedMethodInfo DropDownSetSearchMatchModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetSearchMatchMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetSearchMatchMode"
        })


#endif

-- method DropDown::set_selected
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the position of the item to select, or %GTK_INVALID_LIST_POSITION"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_selected" gtk_drop_down_set_selected :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    Word32 ->                               -- position : TBasicType TUInt
    IO ()

-- | Selects the item at the given position.
dropDownSetSelected ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Word32
    -- ^ /@position@/: the position of the item to select, or 'GI.Gtk.Constants.INVALID_LIST_POSITION'
    -> m ()
dropDownSetSelected self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_drop_down_set_selected self' position
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetSelectedMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownSetSelectedMethodInfo a signature where
    overloadedMethod = dropDownSetSelected

instance O.OverloadedMethodInfo DropDownSetSelectedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetSelected",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetSelected"
        })


#endif

-- method DropDown::set_show_arrow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropDown" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropDown`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_arrow"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show an arrow within the widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_down_set_show_arrow" gtk_drop_down_set_show_arrow :: 
    Ptr DropDown ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DropDown"})
    CInt ->                                 -- show_arrow : TBasicType TBoolean
    IO ()

-- | Sets whether an arrow will be displayed within the widget.
-- 
-- /Since: 4.6/
dropDownSetShowArrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropDown a) =>
    a
    -- ^ /@self@/: a @GtkDropDown@
    -> Bool
    -- ^ /@showArrow@/: whether to show an arrow within the widget
    -> m ()
dropDownSetShowArrow self showArrow = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let showArrow' = (P.fromIntegral . P.fromEnum) showArrow
    gtk_drop_down_set_show_arrow self' showArrow'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DropDownSetShowArrowMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsDropDown a) => O.OverloadedMethod DropDownSetShowArrowMethodInfo a signature where
    overloadedMethod = dropDownSetShowArrow

instance O.OverloadedMethodInfo DropDownSetShowArrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropDown.dropDownSetShowArrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DropDown.html#v:dropDownSetShowArrow"
        })


#endif


