{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkRoot@ implementation for drag icons.
-- 
-- A drag icon moves with the pointer during a Drag-and-Drop operation
-- and is destroyed when the drag ends.
-- 
-- To set up a drag icon and associate it with an ongoing drag operation,
-- use 'GI.Gtk.Objects.DragIcon.dragIconGetForDrag' to get the icon for a drag. You can
-- then use it like any other widget and use 'GI.Gtk.Objects.DragIcon.dragIconSetChild'
-- to set whatever widget should be used for the drag icon.
-- 
-- Keep in mind that drag icons do not allow user input.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.DragIcon
    ( 

-- * Exported types
    DragIcon(..)                            ,
    IsDragIcon                              ,
    toDragIcon                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.DragIcon#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Interfaces.Root#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.DragIcon#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocus]("GI.Gtk.Interfaces.Root#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveDragIconMethod                   ,
#endif

-- ** createWidgetForValue #method:createWidgetForValue#

    dragIconCreateWidgetForValue            ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    DragIconGetChildMethodInfo              ,
#endif
    dragIconGetChild                        ,


-- ** getForDrag #method:getForDrag#

    dragIconGetForDrag                      ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    DragIconSetChildMethodInfo              ,
#endif
    dragIconSetChild                        ,


-- ** setFromPaintable #method:setFromPaintable#

    dragIconSetFromPaintable                ,




 -- * Properties


-- ** child #attr:child#
-- | The widget to display as drag icon.

#if defined(ENABLE_OVERLOADING)
    DragIconChildPropertyInfo               ,
#endif
    clearDragIconChild                      ,
    constructDragIconChild                  ,
#if defined(ENABLE_OVERLOADING)
    dragIconChild                           ,
#endif
    getDragIconChild                        ,
    setDragIconChild                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Drag as Gdk.Drag
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Drag as Gdk.Drag
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype DragIcon = DragIcon (SP.ManagedPtr DragIcon)
    deriving (Eq)

instance SP.ManagedPtrNewtype DragIcon where
    toManagedPtr (DragIcon p) = p

foreign import ccall "gtk_drag_icon_get_type"
    c_gtk_drag_icon_get_type :: IO B.Types.GType

instance B.Types.TypedObject DragIcon where
    glibType = c_gtk_drag_icon_get_type

instance B.Types.GObject DragIcon

-- | Type class for types which can be safely cast to `DragIcon`, for instance with `toDragIcon`.
class (SP.GObject o, O.IsDescendantOf DragIcon o) => IsDragIcon o
instance (SP.GObject o, O.IsDescendantOf DragIcon o) => IsDragIcon o

instance O.HasParentTypes DragIcon
type instance O.ParentTypes DragIcon = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root]

-- | Cast to `DragIcon`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDragIcon :: (MIO.MonadIO m, IsDragIcon o) => o -> m DragIcon
toDragIcon = MIO.liftIO . B.ManagedPtr.unsafeCastTo DragIcon

-- | Convert 'DragIcon' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DragIcon) where
    gvalueGType_ = c_gtk_drag_icon_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DragIcon)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DragIcon)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DragIcon ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDragIconMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDragIconMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveDragIconMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveDragIconMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveDragIconMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveDragIconMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveDragIconMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveDragIconMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveDragIconMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveDragIconMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveDragIconMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveDragIconMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDragIconMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDragIconMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveDragIconMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveDragIconMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveDragIconMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveDragIconMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveDragIconMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveDragIconMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveDragIconMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveDragIconMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveDragIconMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveDragIconMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveDragIconMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDragIconMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDragIconMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDragIconMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveDragIconMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveDragIconMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveDragIconMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveDragIconMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveDragIconMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveDragIconMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveDragIconMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveDragIconMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveDragIconMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveDragIconMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveDragIconMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveDragIconMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveDragIconMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDragIconMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveDragIconMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveDragIconMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveDragIconMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveDragIconMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveDragIconMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveDragIconMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveDragIconMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveDragIconMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDragIconMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDragIconMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveDragIconMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveDragIconMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveDragIconMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveDragIconMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveDragIconMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveDragIconMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveDragIconMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDragIconMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDragIconMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveDragIconMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveDragIconMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveDragIconMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveDragIconMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveDragIconMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveDragIconMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveDragIconMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDragIconMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveDragIconMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveDragIconMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveDragIconMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveDragIconMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDragIconMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDragIconMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDragIconMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveDragIconMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveDragIconMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveDragIconMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveDragIconMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveDragIconMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDragIconMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveDragIconMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveDragIconMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveDragIconMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveDragIconMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveDragIconMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveDragIconMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDragIconMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveDragIconMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveDragIconMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveDragIconMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveDragIconMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveDragIconMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveDragIconMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveDragIconMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveDragIconMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveDragIconMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveDragIconMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveDragIconMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveDragIconMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveDragIconMethod "getChild" o = DragIconGetChildMethodInfo
    ResolveDragIconMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveDragIconMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveDragIconMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveDragIconMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveDragIconMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveDragIconMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveDragIconMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDragIconMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveDragIconMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveDragIconMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveDragIconMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveDragIconMethod "getFocus" o = Gtk.Root.RootGetFocusMethodInfo
    ResolveDragIconMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveDragIconMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveDragIconMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveDragIconMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveDragIconMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveDragIconMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveDragIconMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveDragIconMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveDragIconMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveDragIconMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveDragIconMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveDragIconMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveDragIconMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveDragIconMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveDragIconMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveDragIconMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveDragIconMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveDragIconMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveDragIconMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveDragIconMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveDragIconMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveDragIconMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveDragIconMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveDragIconMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveDragIconMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveDragIconMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveDragIconMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveDragIconMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveDragIconMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveDragIconMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveDragIconMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveDragIconMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDragIconMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDragIconMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveDragIconMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveDragIconMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolveDragIconMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveDragIconMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveDragIconMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveDragIconMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveDragIconMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveDragIconMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveDragIconMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveDragIconMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveDragIconMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveDragIconMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolveDragIconMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolveDragIconMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveDragIconMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveDragIconMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveDragIconMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveDragIconMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveDragIconMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveDragIconMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveDragIconMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveDragIconMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveDragIconMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveDragIconMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveDragIconMethod "setChild" o = DragIconSetChildMethodInfo
    ResolveDragIconMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveDragIconMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveDragIconMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveDragIconMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveDragIconMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDragIconMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDragIconMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveDragIconMethod "setFocus" o = Gtk.Root.RootSetFocusMethodInfo
    ResolveDragIconMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveDragIconMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveDragIconMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveDragIconMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveDragIconMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveDragIconMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveDragIconMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveDragIconMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveDragIconMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveDragIconMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveDragIconMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveDragIconMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveDragIconMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveDragIconMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveDragIconMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveDragIconMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveDragIconMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveDragIconMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveDragIconMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveDragIconMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDragIconMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveDragIconMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveDragIconMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveDragIconMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveDragIconMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveDragIconMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveDragIconMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveDragIconMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveDragIconMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveDragIconMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveDragIconMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDragIconMethod t DragIcon, O.OverloadedMethod info DragIcon p) => OL.IsLabel t (DragIcon -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDragIconMethod t DragIcon, O.OverloadedMethod info DragIcon p, R.HasField t DragIcon p) => R.HasField t DragIcon p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDragIconMethod t DragIcon, O.OverloadedMethodInfo info DragIcon) => OL.IsLabel t (O.MethodProxy info DragIcon) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dragIcon #child
-- @
getDragIconChild :: (MonadIO m, IsDragIcon o) => o -> m (Maybe Gtk.Widget.Widget)
getDragIconChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dragIcon [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setDragIconChild :: (MonadIO m, IsDragIcon o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setDragIconChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDragIconChild :: (IsDragIcon o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructDragIconChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearDragIconChild :: (MonadIO m, IsDragIcon o) => o -> m ()
clearDragIconChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data DragIconChildPropertyInfo
instance AttrInfo DragIconChildPropertyInfo where
    type AttrAllowedOps DragIconChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DragIconChildPropertyInfo = IsDragIcon
    type AttrSetTypeConstraint DragIconChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint DragIconChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType DragIconChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType DragIconChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel DragIconChildPropertyInfo = "child"
    type AttrOrigin DragIconChildPropertyInfo = DragIcon
    attrGet = getDragIconChild
    attrSet = setDragIconChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructDragIconChild
    attrClear = clearDragIconChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DragIcon.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DragIcon.html#g:attr:child"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DragIcon
type instance O.AttributeList DragIcon = DragIconAttributeList
type DragIconAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", DragIconChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dragIconChild :: AttrLabelProxy "child"
dragIconChild = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DragIcon = DragIconSignalList
type DragIconSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DragIcon::get_for_drag
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "DragIcon" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drag_icon_get_for_drag" gtk_drag_icon_get_for_drag :: 
    Ptr Gdk.Drag.Drag ->                    -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    IO (Ptr DragIcon)

-- | Gets the @GtkDragIcon@ in use with /@drag@/.
-- 
-- If no drag icon exists yet, a new one will be created
-- and shown.
dragIconGetForDrag ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Drag.IsDrag a) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> m DragIcon
    -- ^ __Returns:__ the @GtkDragIcon@
dragIconGetForDrag drag = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    result <- gtk_drag_icon_get_for_drag drag'
    checkUnexpectedReturnNULL "dragIconGetForDrag" result
    result' <- (newObject DragIcon) result
    touchManagedPtr drag
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DragIcon::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DragIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDragIcon`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drag_icon_get_child" gtk_drag_icon_get_child :: 
    Ptr DragIcon ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DragIcon"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the widget currently used as drag icon.
dragIconGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragIcon a) =>
    a
    -- ^ /@self@/: a @GtkDragIcon@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ The drag icon
dragIconGetChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drag_icon_get_child self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DragIconGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsDragIcon a) => O.OverloadedMethod DragIconGetChildMethodInfo a signature where
    overloadedMethod = dragIconGetChild

instance O.OverloadedMethodInfo DragIconGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DragIcon.dragIconGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DragIcon.html#v:dragIconGetChild"
        })


#endif

-- method DragIcon::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DragIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDragIcon`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drag_icon_set_child" gtk_drag_icon_set_child :: 
    Ptr DragIcon ->                         -- self : TInterface (Name {namespace = "Gtk", name = "DragIcon"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the widget to display as the drag icon.
dragIconSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragIcon a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkDragIcon@
    -> Maybe (b)
    -- ^ /@child@/: a @GtkWidget@
    -> m ()
dragIconSetChild self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_drag_icon_set_child self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DragIconSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDragIcon a, Gtk.Widget.IsWidget b) => O.OverloadedMethod DragIconSetChildMethodInfo a signature where
    overloadedMethod = dragIconSetChild

instance O.OverloadedMethodInfo DragIconSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DragIcon.dragIconSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-DragIcon.html#v:dragIconSetChild"
        })


#endif

-- method DragIcon::create_widget_for_value
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GValue`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drag_icon_create_widget_for_value" gtk_drag_icon_create_widget_for_value :: 
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr Gtk.Widget.Widget)

-- | Creates a widget that can be used as a drag icon for the given
-- /@value@/.
-- 
-- Supported types include strings, @GdkRGBA@ and @GtkTextBuffer@.
-- If GTK does not know how to create a widget for a given value,
-- it will return 'P.Nothing'.
-- 
-- This method is used to set the default drag icon on drag-and-drop
-- operations started by @GtkDragSource@, so you don\'t need to set
-- a drag icon using this function there.
dragIconCreateWidgetForValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a @GValue@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ A new @GtkWidget@
    --   for displaying /@value@/ as a drag icon.
dragIconCreateWidgetForValue value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- gtk_drag_icon_create_widget_for_value value'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr value
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method DragIcon::set_from_paintable
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "drag"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drag" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrag`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paintable"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Paintable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPaintable` to display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hot_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate of the hotspot"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hot_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate of the hotspot"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drag_icon_set_from_paintable" gtk_drag_icon_set_from_paintable :: 
    Ptr Gdk.Drag.Drag ->                    -- drag : TInterface (Name {namespace = "Gdk", name = "Drag"})
    Ptr Gdk.Paintable.Paintable ->          -- paintable : TInterface (Name {namespace = "Gdk", name = "Paintable"})
    Int32 ->                                -- hot_x : TBasicType TInt
    Int32 ->                                -- hot_y : TBasicType TInt
    IO ()

-- | Creates a @GtkDragIcon@ that shows /@paintable@/, and associates
-- it with the drag operation.
-- 
-- The hotspot position on the paintable is aligned with the
-- hotspot of the cursor.
dragIconSetFromPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Drag.IsDrag a, Gdk.Paintable.IsPaintable b) =>
    a
    -- ^ /@drag@/: a @GdkDrag@
    -> b
    -- ^ /@paintable@/: a @GdkPaintable@ to display
    -> Int32
    -- ^ /@hotX@/: X coordinate of the hotspot
    -> Int32
    -- ^ /@hotY@/: Y coordinate of the hotspot
    -> m ()
dragIconSetFromPaintable drag paintable hotX hotY = liftIO $ do
    drag' <- unsafeManagedPtrCastPtr drag
    paintable' <- unsafeManagedPtrCastPtr paintable
    gtk_drag_icon_set_from_paintable drag' paintable' hotX hotY
    touchManagedPtr drag
    touchManagedPtr paintable
    return ()

#if defined(ENABLE_OVERLOADING)
#endif


