{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkComboBoxText@ is a simple variant of @GtkComboBox@ for text-only
-- use cases.
-- 
-- \<picture>
--   \<source srcset=\"combo-box-text-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkComboBoxText\" src=\"combo-box-text.png\">
-- \<\/picture>
-- 
-- @GtkComboBoxText@ hides the model-view complexity of @GtkComboBox@.
-- 
-- To create a @GtkComboBoxText@, use 'GI.Gtk.Objects.ComboBoxText.comboBoxTextNew' or
-- 'GI.Gtk.Objects.ComboBoxText.comboBoxTextNewWithEntry'.
-- 
-- You can add items to a @GtkComboBoxText@ with
-- 'GI.Gtk.Objects.ComboBoxText.comboBoxTextAppendText',
-- 'GI.Gtk.Objects.ComboBoxText.comboBoxTextInsertText' or
-- 'GI.Gtk.Objects.ComboBoxText.comboBoxTextPrependText' and remove options with
-- 'GI.Gtk.Objects.ComboBoxText.comboBoxTextRemove'.
-- 
-- If the @GtkComboBoxText@ contains an entry (via the
-- [ComboBox:hasEntry]("GI.Gtk.Objects.ComboBox#g:attr:hasEntry") property), its contents can be retrieved
-- using 'GI.Gtk.Objects.ComboBoxText.comboBoxTextGetActiveText'.
-- 
-- You should not call 'GI.Gtk.Objects.ComboBox.comboBoxSetModel' or attempt to pack more
-- cells into this combo box via its t'GI.Gtk.Interfaces.CellLayout.CellLayout' interface.
-- 
-- == GtkComboBoxText as GtkBuildable
-- 
-- The @GtkComboBoxText@ implementation of the @GtkBuildable@ interface supports
-- adding items directly using the @\<items>@ element and specifying @\<item>@
-- elements for each item. Each @\<item>@ element can specify the “id”
-- corresponding to the appended text and also supports the regular
-- translation attributes “translatable”, “context” and “comments”.
-- 
-- Here is a UI definition fragment specifying @GtkComboBoxText@ items:
-- 
-- === /xml code/
-- ><object class="GtkComboBoxText">
-- >  <items>
-- >    <item translatable="yes" id="factory">Factory</item>
-- >    <item translatable="yes" id="home">Home</item>
-- >    <item translatable="yes" id="subway">Subway</item>
-- >  </items>
-- ></object>
-- 
-- 
-- == CSS nodes
-- 
-- >combobox
-- >╰── box.linked
-- >    ├── entry.combo
-- >    ├── button.combo
-- >    ╰── window.popup
-- 
-- 
-- @GtkComboBoxText@ has a single CSS node with name combobox. It adds
-- the style class .combo to the main CSS nodes of its entry and button
-- children, and the .linked class to the node of its internal box.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ComboBoxText
    ( 

-- * Exported types
    ComboBoxText(..)                        ,
    IsComboBoxText                          ,
    toComboBoxText                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addAttribute]("GI.Gtk.Interfaces.CellLayout#g:method:addAttribute"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [append]("GI.Gtk.Objects.ComboBoxText#g:method:append"), [appendText]("GI.Gtk.Objects.ComboBoxText#g:method:appendText"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [clear]("GI.Gtk.Interfaces.CellLayout#g:method:clear"), [clearAttributes]("GI.Gtk.Interfaces.CellLayout#g:method:clearAttributes"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [editingDone]("GI.Gtk.Interfaces.CellEditable#g:method:editingDone"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insert]("GI.Gtk.Objects.ComboBoxText#g:method:insert"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertText]("GI.Gtk.Objects.ComboBoxText#g:method:insertText"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [packEnd]("GI.Gtk.Interfaces.CellLayout#g:method:packEnd"), [packStart]("GI.Gtk.Interfaces.CellLayout#g:method:packStart"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [popdown]("GI.Gtk.Objects.ComboBox#g:method:popdown"), [popup]("GI.Gtk.Objects.ComboBox#g:method:popup"), [popupForDevice]("GI.Gtk.Objects.ComboBox#g:method:popupForDevice"), [prepend]("GI.Gtk.Objects.ComboBoxText#g:method:prepend"), [prependText]("GI.Gtk.Objects.ComboBoxText#g:method:prependText"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.ComboBoxText#g:method:remove"), [removeAll]("GI.Gtk.Objects.ComboBoxText#g:method:removeAll"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [removeWidget]("GI.Gtk.Interfaces.CellEditable#g:method:removeWidget"), [reorder]("GI.Gtk.Interfaces.CellLayout#g:method:reorder"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [startEditing]("GI.Gtk.Interfaces.CellEditable#g:method:startEditing"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActive]("GI.Gtk.Objects.ComboBox#g:method:getActive"), [getActiveId]("GI.Gtk.Objects.ComboBox#g:method:getActiveId"), [getActiveIter]("GI.Gtk.Objects.ComboBox#g:method:getActiveIter"), [getActiveText]("GI.Gtk.Objects.ComboBoxText#g:method:getActiveText"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getArea]("GI.Gtk.Interfaces.CellLayout#g:method:getArea"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getButtonSensitivity]("GI.Gtk.Objects.ComboBox#g:method:getButtonSensitivity"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCells]("GI.Gtk.Interfaces.CellLayout#g:method:getCells"), [getChild]("GI.Gtk.Objects.ComboBox#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEntryTextColumn]("GI.Gtk.Objects.ComboBox#g:method:getEntryTextColumn"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasEntry]("GI.Gtk.Objects.ComboBox#g:method:getHasEntry"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getIdColumn]("GI.Gtk.Objects.ComboBox#g:method:getIdColumn"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getModel]("GI.Gtk.Objects.ComboBox#g:method:getModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPopupFixedWidth]("GI.Gtk.Objects.ComboBox#g:method:getPopupFixedWidth"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActive]("GI.Gtk.Objects.ComboBox#g:method:setActive"), [setActiveId]("GI.Gtk.Objects.ComboBox#g:method:setActiveId"), [setActiveIter]("GI.Gtk.Objects.ComboBox#g:method:setActiveIter"), [setButtonSensitivity]("GI.Gtk.Objects.ComboBox#g:method:setButtonSensitivity"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCellDataFunc]("GI.Gtk.Interfaces.CellLayout#g:method:setCellDataFunc"), [setChild]("GI.Gtk.Objects.ComboBox#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEntryTextColumn]("GI.Gtk.Objects.ComboBox#g:method:setEntryTextColumn"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIdColumn]("GI.Gtk.Objects.ComboBox#g:method:setIdColumn"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setModel]("GI.Gtk.Objects.ComboBox#g:method:setModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPopupFixedWidth]("GI.Gtk.Objects.ComboBox#g:method:setPopupFixedWidth"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRowSeparatorFunc]("GI.Gtk.Objects.ComboBox#g:method:setRowSeparatorFunc"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveComboBoxTextMethod               ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextAppendMethodInfo            ,
#endif
    comboBoxTextAppend                      ,


-- ** appendText #method:appendText#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextAppendTextMethodInfo        ,
#endif
    comboBoxTextAppendText                  ,


-- ** getActiveText #method:getActiveText#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextGetActiveTextMethodInfo     ,
#endif
    comboBoxTextGetActiveText               ,


-- ** insert #method:insert#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextInsertMethodInfo            ,
#endif
    comboBoxTextInsert                      ,


-- ** insertText #method:insertText#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextInsertTextMethodInfo        ,
#endif
    comboBoxTextInsertText                  ,


-- ** new #method:new#

    comboBoxTextNew                         ,


-- ** newWithEntry #method:newWithEntry#

    comboBoxTextNewWithEntry                ,


-- ** prepend #method:prepend#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextPrependMethodInfo           ,
#endif
    comboBoxTextPrepend                     ,


-- ** prependText #method:prependText#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextPrependTextMethodInfo       ,
#endif
    comboBoxTextPrependText                 ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextRemoveMethodInfo            ,
#endif
    comboBoxTextRemove                      ,


-- ** removeAll #method:removeAll#

#if defined(ENABLE_OVERLOADING)
    ComboBoxTextRemoveAllMethodInfo         ,
#endif
    comboBoxTextRemoveAll                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellArea as Gtk.CellArea
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellAreaContext as Gtk.CellAreaContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer
import {-# SOURCE #-} qualified GI.Gtk.Objects.ComboBox as Gtk.ComboBox
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellLayout as Gtk.CellLayout
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.ComboBox as Gtk.ComboBox
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ComboBoxText = ComboBoxText (SP.ManagedPtr ComboBoxText)
    deriving (Eq)

instance SP.ManagedPtrNewtype ComboBoxText where
    toManagedPtr (ComboBoxText p) = p

foreign import ccall "gtk_combo_box_text_get_type"
    c_gtk_combo_box_text_get_type :: IO B.Types.GType

instance B.Types.TypedObject ComboBoxText where
    glibType = c_gtk_combo_box_text_get_type

instance B.Types.GObject ComboBoxText

-- | Type class for types which can be safely cast to `ComboBoxText`, for instance with `toComboBoxText`.
class (SP.GObject o, O.IsDescendantOf ComboBoxText o) => IsComboBoxText o
instance (SP.GObject o, O.IsDescendantOf ComboBoxText o) => IsComboBoxText o

instance O.HasParentTypes ComboBoxText
type instance O.ParentTypes ComboBoxText = '[Gtk.ComboBox.ComboBox, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.CellEditable.CellEditable, Gtk.CellLayout.CellLayout, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `ComboBoxText`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toComboBoxText :: (MIO.MonadIO m, IsComboBoxText o) => o -> m ComboBoxText
toComboBoxText = MIO.liftIO . B.ManagedPtr.unsafeCastTo ComboBoxText

-- | Convert 'ComboBoxText' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ComboBoxText) where
    gvalueGType_ = c_gtk_combo_box_text_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ComboBoxText)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ComboBoxText)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ComboBoxText ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveComboBoxTextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveComboBoxTextMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveComboBoxTextMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveComboBoxTextMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveComboBoxTextMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveComboBoxTextMethod "addAttribute" o = Gtk.CellLayout.CellLayoutAddAttributeMethodInfo
    ResolveComboBoxTextMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveComboBoxTextMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveComboBoxTextMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveComboBoxTextMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveComboBoxTextMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveComboBoxTextMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveComboBoxTextMethod "append" o = ComboBoxTextAppendMethodInfo
    ResolveComboBoxTextMethod "appendText" o = ComboBoxTextAppendTextMethodInfo
    ResolveComboBoxTextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveComboBoxTextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveComboBoxTextMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveComboBoxTextMethod "clear" o = Gtk.CellLayout.CellLayoutClearMethodInfo
    ResolveComboBoxTextMethod "clearAttributes" o = Gtk.CellLayout.CellLayoutClearAttributesMethodInfo
    ResolveComboBoxTextMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveComboBoxTextMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveComboBoxTextMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveComboBoxTextMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveComboBoxTextMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveComboBoxTextMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveComboBoxTextMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveComboBoxTextMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveComboBoxTextMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveComboBoxTextMethod "editingDone" o = Gtk.CellEditable.CellEditableEditingDoneMethodInfo
    ResolveComboBoxTextMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveComboBoxTextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveComboBoxTextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveComboBoxTextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveComboBoxTextMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveComboBoxTextMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveComboBoxTextMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveComboBoxTextMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveComboBoxTextMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveComboBoxTextMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveComboBoxTextMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveComboBoxTextMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveComboBoxTextMethod "insert" o = ComboBoxTextInsertMethodInfo
    ResolveComboBoxTextMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveComboBoxTextMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveComboBoxTextMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveComboBoxTextMethod "insertText" o = ComboBoxTextInsertTextMethodInfo
    ResolveComboBoxTextMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveComboBoxTextMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveComboBoxTextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveComboBoxTextMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveComboBoxTextMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveComboBoxTextMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveComboBoxTextMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveComboBoxTextMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveComboBoxTextMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveComboBoxTextMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveComboBoxTextMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveComboBoxTextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveComboBoxTextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveComboBoxTextMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveComboBoxTextMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveComboBoxTextMethod "packEnd" o = Gtk.CellLayout.CellLayoutPackEndMethodInfo
    ResolveComboBoxTextMethod "packStart" o = Gtk.CellLayout.CellLayoutPackStartMethodInfo
    ResolveComboBoxTextMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveComboBoxTextMethod "popdown" o = Gtk.ComboBox.ComboBoxPopdownMethodInfo
    ResolveComboBoxTextMethod "popup" o = Gtk.ComboBox.ComboBoxPopupMethodInfo
    ResolveComboBoxTextMethod "popupForDevice" o = Gtk.ComboBox.ComboBoxPopupForDeviceMethodInfo
    ResolveComboBoxTextMethod "prepend" o = ComboBoxTextPrependMethodInfo
    ResolveComboBoxTextMethod "prependText" o = ComboBoxTextPrependTextMethodInfo
    ResolveComboBoxTextMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveComboBoxTextMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveComboBoxTextMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveComboBoxTextMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveComboBoxTextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveComboBoxTextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveComboBoxTextMethod "remove" o = ComboBoxTextRemoveMethodInfo
    ResolveComboBoxTextMethod "removeAll" o = ComboBoxTextRemoveAllMethodInfo
    ResolveComboBoxTextMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveComboBoxTextMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveComboBoxTextMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveComboBoxTextMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveComboBoxTextMethod "removeWidget" o = Gtk.CellEditable.CellEditableRemoveWidgetMethodInfo
    ResolveComboBoxTextMethod "reorder" o = Gtk.CellLayout.CellLayoutReorderMethodInfo
    ResolveComboBoxTextMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveComboBoxTextMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveComboBoxTextMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveComboBoxTextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveComboBoxTextMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveComboBoxTextMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveComboBoxTextMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveComboBoxTextMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveComboBoxTextMethod "startEditing" o = Gtk.CellEditable.CellEditableStartEditingMethodInfo
    ResolveComboBoxTextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveComboBoxTextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveComboBoxTextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveComboBoxTextMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveComboBoxTextMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveComboBoxTextMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveComboBoxTextMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveComboBoxTextMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveComboBoxTextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveComboBoxTextMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveComboBoxTextMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveComboBoxTextMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveComboBoxTextMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveComboBoxTextMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveComboBoxTextMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveComboBoxTextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveComboBoxTextMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveComboBoxTextMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveComboBoxTextMethod "getActive" o = Gtk.ComboBox.ComboBoxGetActiveMethodInfo
    ResolveComboBoxTextMethod "getActiveId" o = Gtk.ComboBox.ComboBoxGetActiveIdMethodInfo
    ResolveComboBoxTextMethod "getActiveIter" o = Gtk.ComboBox.ComboBoxGetActiveIterMethodInfo
    ResolveComboBoxTextMethod "getActiveText" o = ComboBoxTextGetActiveTextMethodInfo
    ResolveComboBoxTextMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveComboBoxTextMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveComboBoxTextMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveComboBoxTextMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveComboBoxTextMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveComboBoxTextMethod "getArea" o = Gtk.CellLayout.CellLayoutGetAreaMethodInfo
    ResolveComboBoxTextMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveComboBoxTextMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveComboBoxTextMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveComboBoxTextMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveComboBoxTextMethod "getButtonSensitivity" o = Gtk.ComboBox.ComboBoxGetButtonSensitivityMethodInfo
    ResolveComboBoxTextMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveComboBoxTextMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveComboBoxTextMethod "getCells" o = Gtk.CellLayout.CellLayoutGetCellsMethodInfo
    ResolveComboBoxTextMethod "getChild" o = Gtk.ComboBox.ComboBoxGetChildMethodInfo
    ResolveComboBoxTextMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveComboBoxTextMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveComboBoxTextMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveComboBoxTextMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveComboBoxTextMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveComboBoxTextMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveComboBoxTextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveComboBoxTextMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveComboBoxTextMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveComboBoxTextMethod "getEntryTextColumn" o = Gtk.ComboBox.ComboBoxGetEntryTextColumnMethodInfo
    ResolveComboBoxTextMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveComboBoxTextMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveComboBoxTextMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveComboBoxTextMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveComboBoxTextMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveComboBoxTextMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveComboBoxTextMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveComboBoxTextMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveComboBoxTextMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveComboBoxTextMethod "getHasEntry" o = Gtk.ComboBox.ComboBoxGetHasEntryMethodInfo
    ResolveComboBoxTextMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveComboBoxTextMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveComboBoxTextMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveComboBoxTextMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveComboBoxTextMethod "getIdColumn" o = Gtk.ComboBox.ComboBoxGetIdColumnMethodInfo
    ResolveComboBoxTextMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveComboBoxTextMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveComboBoxTextMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveComboBoxTextMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveComboBoxTextMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveComboBoxTextMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveComboBoxTextMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveComboBoxTextMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveComboBoxTextMethod "getModel" o = Gtk.ComboBox.ComboBoxGetModelMethodInfo
    ResolveComboBoxTextMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveComboBoxTextMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveComboBoxTextMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveComboBoxTextMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveComboBoxTextMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveComboBoxTextMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveComboBoxTextMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveComboBoxTextMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveComboBoxTextMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveComboBoxTextMethod "getPopupFixedWidth" o = Gtk.ComboBox.ComboBoxGetPopupFixedWidthMethodInfo
    ResolveComboBoxTextMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveComboBoxTextMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveComboBoxTextMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveComboBoxTextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveComboBoxTextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveComboBoxTextMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveComboBoxTextMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveComboBoxTextMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveComboBoxTextMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveComboBoxTextMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveComboBoxTextMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveComboBoxTextMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveComboBoxTextMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveComboBoxTextMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveComboBoxTextMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveComboBoxTextMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveComboBoxTextMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveComboBoxTextMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveComboBoxTextMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveComboBoxTextMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveComboBoxTextMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveComboBoxTextMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveComboBoxTextMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveComboBoxTextMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveComboBoxTextMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveComboBoxTextMethod "setActive" o = Gtk.ComboBox.ComboBoxSetActiveMethodInfo
    ResolveComboBoxTextMethod "setActiveId" o = Gtk.ComboBox.ComboBoxSetActiveIdMethodInfo
    ResolveComboBoxTextMethod "setActiveIter" o = Gtk.ComboBox.ComboBoxSetActiveIterMethodInfo
    ResolveComboBoxTextMethod "setButtonSensitivity" o = Gtk.ComboBox.ComboBoxSetButtonSensitivityMethodInfo
    ResolveComboBoxTextMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveComboBoxTextMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveComboBoxTextMethod "setCellDataFunc" o = Gtk.CellLayout.CellLayoutSetCellDataFuncMethodInfo
    ResolveComboBoxTextMethod "setChild" o = Gtk.ComboBox.ComboBoxSetChildMethodInfo
    ResolveComboBoxTextMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveComboBoxTextMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveComboBoxTextMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveComboBoxTextMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveComboBoxTextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveComboBoxTextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveComboBoxTextMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveComboBoxTextMethod "setEntryTextColumn" o = Gtk.ComboBox.ComboBoxSetEntryTextColumnMethodInfo
    ResolveComboBoxTextMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveComboBoxTextMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveComboBoxTextMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveComboBoxTextMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveComboBoxTextMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveComboBoxTextMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveComboBoxTextMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveComboBoxTextMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveComboBoxTextMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveComboBoxTextMethod "setIdColumn" o = Gtk.ComboBox.ComboBoxSetIdColumnMethodInfo
    ResolveComboBoxTextMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveComboBoxTextMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveComboBoxTextMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveComboBoxTextMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveComboBoxTextMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveComboBoxTextMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveComboBoxTextMethod "setModel" o = Gtk.ComboBox.ComboBoxSetModelMethodInfo
    ResolveComboBoxTextMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveComboBoxTextMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveComboBoxTextMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveComboBoxTextMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveComboBoxTextMethod "setPopupFixedWidth" o = Gtk.ComboBox.ComboBoxSetPopupFixedWidthMethodInfo
    ResolveComboBoxTextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveComboBoxTextMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveComboBoxTextMethod "setRowSeparatorFunc" o = Gtk.ComboBox.ComboBoxSetRowSeparatorFuncMethodInfo
    ResolveComboBoxTextMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveComboBoxTextMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveComboBoxTextMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveComboBoxTextMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveComboBoxTextMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveComboBoxTextMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveComboBoxTextMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveComboBoxTextMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveComboBoxTextMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveComboBoxTextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveComboBoxTextMethod t ComboBoxText, O.OverloadedMethod info ComboBoxText p) => OL.IsLabel t (ComboBoxText -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveComboBoxTextMethod t ComboBoxText, O.OverloadedMethod info ComboBoxText p, R.HasField t ComboBoxText p) => R.HasField t ComboBoxText p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveComboBoxTextMethod t ComboBoxText, O.OverloadedMethodInfo info ComboBoxText) => OL.IsLabel t (O.MethodProxy info ComboBoxText) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ComboBoxText
type instance O.AttributeList ComboBoxText = ComboBoxTextAttributeList
type ComboBoxTextAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("active", Gtk.ComboBox.ComboBoxActivePropertyInfo), '("activeId", Gtk.ComboBox.ComboBoxActiveIdPropertyInfo), '("buttonSensitivity", Gtk.ComboBox.ComboBoxButtonSensitivityPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", Gtk.ComboBox.ComboBoxChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("editingCanceled", Gtk.CellEditable.CellEditableEditingCanceledPropertyInfo), '("entryTextColumn", Gtk.ComboBox.ComboBoxEntryTextColumnPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasEntry", Gtk.ComboBox.ComboBoxHasEntryPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasFrame", Gtk.ComboBox.ComboBoxHasFramePropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("idColumn", Gtk.ComboBox.ComboBoxIdColumnPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("model", Gtk.ComboBox.ComboBoxModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("popupFixedWidth", Gtk.ComboBox.ComboBoxPopupFixedWidthPropertyInfo), '("popupShown", Gtk.ComboBox.ComboBoxPopupShownPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ComboBoxText = ComboBoxTextSignalList
type ComboBoxTextSignalList = ('[ '("activate", Gtk.ComboBox.ComboBoxActivateSignalInfo), '("changed", Gtk.ComboBox.ComboBoxChangedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("editingDone", Gtk.CellEditable.CellEditableEditingDoneSignalInfo), '("formatEntryText", Gtk.ComboBox.ComboBoxFormatEntryTextSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveActive", Gtk.ComboBox.ComboBoxMoveActiveSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("popdown", Gtk.ComboBox.ComboBoxPopdownSignalInfo), '("popup", Gtk.ComboBox.ComboBoxPopupSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("removeWidget", Gtk.CellEditable.CellEditableRemoveWidgetSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ComboBoxText::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ComboBoxText" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_new" gtk_combo_box_text_new :: 
    IO (Ptr ComboBoxText)

{-# DEPRECATED comboBoxTextNew ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Creates a new @GtkComboBoxText@.
comboBoxTextNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ComboBoxText
    -- ^ __Returns:__ A new @GtkComboBoxText@
comboBoxTextNew  = liftIO $ do
    result <- gtk_combo_box_text_new
    checkUnexpectedReturnNULL "comboBoxTextNew" result
    result' <- (newObject ComboBoxText) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ComboBoxText::new_with_entry
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ComboBoxText" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_new_with_entry" gtk_combo_box_text_new_with_entry :: 
    IO (Ptr ComboBoxText)

{-# DEPRECATED comboBoxTextNewWithEntry ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Creates a new @GtkComboBoxText@ with an entry.
comboBoxTextNewWithEntry ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ComboBoxText
    -- ^ __Returns:__ a new @GtkComboBoxText@
comboBoxTextNewWithEntry  = liftIO $ do
    result <- gtk_combo_box_text_new_with_entry
    checkUnexpectedReturnNULL "comboBoxTextNewWithEntry" result
    result' <- (newObject ComboBoxText) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ComboBoxText::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBoxText`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string ID for this value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_append" gtk_combo_box_text_append :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    CString ->                              -- id : TBasicType TUTF8
    CString ->                              -- text : TBasicType TUTF8
    IO ()

{-# DEPRECATED comboBoxTextAppend ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Appends /@text@/ to the list of strings stored in /@comboBox@/.
-- 
-- If /@id@/ is non-'P.Nothing' then it is used as the ID of the row.
-- 
-- This is the same as calling 'GI.Gtk.Objects.ComboBoxText.comboBoxTextInsert'
-- with a position of -1.
comboBoxTextAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBoxText@
    -> Maybe (T.Text)
    -- ^ /@id@/: a string ID for this value
    -> T.Text
    -- ^ /@text@/: A string
    -> m ()
comboBoxTextAppend comboBox id text = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeId <- case id of
        Nothing -> return FP.nullPtr
        Just jId -> do
            jId' <- textToCString jId
            return jId'
    text' <- textToCString text
    gtk_combo_box_text_append comboBox' maybeId text'
    touchManagedPtr comboBox
    freeMem maybeId
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextAppendMethodInfo
instance (signature ~ (Maybe (T.Text) -> T.Text -> m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextAppendMethodInfo a signature where
    overloadedMethod = comboBoxTextAppend

instance O.OverloadedMethodInfo ComboBoxTextAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextAppend"
        })


#endif

-- method ComboBoxText::append_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBoxText`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_append_text" gtk_combo_box_text_append_text :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    CString ->                              -- text : TBasicType TUTF8
    IO ()

{-# DEPRECATED comboBoxTextAppendText ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Appends /@text@/ to the list of strings stored in /@comboBox@/.
-- 
-- This is the same as calling 'GI.Gtk.Objects.ComboBoxText.comboBoxTextInsertText'
-- with a position of -1.
comboBoxTextAppendText ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBoxText@
    -> T.Text
    -- ^ /@text@/: A string
    -> m ()
comboBoxTextAppendText comboBox text = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    text' <- textToCString text
    gtk_combo_box_text_append_text comboBox' text'
    touchManagedPtr comboBox
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextAppendTextMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextAppendTextMethodInfo a signature where
    overloadedMethod = comboBoxTextAppendText

instance O.OverloadedMethodInfo ComboBoxTextAppendTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextAppendText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextAppendText"
        })


#endif

-- method ComboBoxText::get_active_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBoxText`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_get_active_text" gtk_combo_box_text_get_active_text :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    IO CString

{-# DEPRECATED comboBoxTextGetActiveText ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Returns the currently active string in /@comboBox@/.
-- 
-- If no row is currently selected, 'P.Nothing' is returned.
-- If /@comboBox@/ contains an entry, this function will
-- return its contents (which will not necessarily
-- be an item from the list).
comboBoxTextGetActiveText ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBoxText@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a newly allocated
    --   string containing the currently active text.
    --   Must be freed with 'GI.GLib.Functions.free'.
comboBoxTextGetActiveText comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    result <- gtk_combo_box_text_get_active_text comboBox'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr comboBox
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextGetActiveTextMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextGetActiveTextMethodInfo a signature where
    overloadedMethod = comboBoxTextGetActiveText

instance O.OverloadedMethodInfo ComboBoxTextGetActiveTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextGetActiveText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextGetActiveText"
        })


#endif

-- method ComboBoxText::insert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBoxText`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An index to insert @text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string ID for this value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string to display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_insert" gtk_combo_box_text_insert :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    Int32 ->                                -- position : TBasicType TInt
    CString ->                              -- id : TBasicType TUTF8
    CString ->                              -- text : TBasicType TUTF8
    IO ()

{-# DEPRECATED comboBoxTextInsert ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Inserts /@text@/ at /@position@/ in the list of strings stored in /@comboBox@/.
-- 
-- If /@id@/ is non-'P.Nothing' then it is used as the ID of the row.
-- See [ComboBox:idColumn]("GI.Gtk.Objects.ComboBox#g:attr:idColumn").
-- 
-- If /@position@/ is negative then /@text@/ is appended.
comboBoxTextInsert ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBoxText@
    -> Int32
    -- ^ /@position@/: An index to insert /@text@/
    -> Maybe (T.Text)
    -- ^ /@id@/: a string ID for this value
    -> T.Text
    -- ^ /@text@/: A string to display
    -> m ()
comboBoxTextInsert comboBox position id text = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeId <- case id of
        Nothing -> return FP.nullPtr
        Just jId -> do
            jId' <- textToCString jId
            return jId'
    text' <- textToCString text
    gtk_combo_box_text_insert comboBox' position maybeId text'
    touchManagedPtr comboBox
    freeMem maybeId
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextInsertMethodInfo
instance (signature ~ (Int32 -> Maybe (T.Text) -> T.Text -> m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextInsertMethodInfo a signature where
    overloadedMethod = comboBoxTextInsert

instance O.OverloadedMethodInfo ComboBoxTextInsertMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextInsert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextInsert"
        })


#endif

-- method ComboBoxText::insert_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBoxText`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An index to insert @text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_insert_text" gtk_combo_box_text_insert_text :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    Int32 ->                                -- position : TBasicType TInt
    CString ->                              -- text : TBasicType TUTF8
    IO ()

{-# DEPRECATED comboBoxTextInsertText ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Inserts /@text@/ at /@position@/ in the list of strings stored in /@comboBox@/.
-- 
-- If /@position@/ is negative then /@text@/ is appended.
-- 
-- This is the same as calling 'GI.Gtk.Objects.ComboBoxText.comboBoxTextInsert'
-- with a 'P.Nothing' ID string.
comboBoxTextInsertText ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBoxText@
    -> Int32
    -- ^ /@position@/: An index to insert /@text@/
    -> T.Text
    -- ^ /@text@/: A string
    -> m ()
comboBoxTextInsertText comboBox position text = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    text' <- textToCString text
    gtk_combo_box_text_insert_text comboBox' position text'
    touchManagedPtr comboBox
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextInsertTextMethodInfo
instance (signature ~ (Int32 -> T.Text -> m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextInsertTextMethodInfo a signature where
    overloadedMethod = comboBoxTextInsertText

instance O.OverloadedMethodInfo ComboBoxTextInsertTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextInsertText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextInsertText"
        })


#endif

-- method ComboBoxText::prepend
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string ID for this value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_prepend" gtk_combo_box_text_prepend :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    CString ->                              -- id : TBasicType TUTF8
    CString ->                              -- text : TBasicType TUTF8
    IO ()

{-# DEPRECATED comboBoxTextPrepend ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Prepends /@text@/ to the list of strings stored in /@comboBox@/.
-- 
-- If /@id@/ is non-'P.Nothing' then it is used as the ID of the row.
-- 
-- This is the same as calling 'GI.Gtk.Objects.ComboBoxText.comboBoxTextInsert'
-- with a position of 0.
comboBoxTextPrepend ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> Maybe (T.Text)
    -- ^ /@id@/: a string ID for this value
    -> T.Text
    -- ^ /@text@/: a string
    -> m ()
comboBoxTextPrepend comboBox id text = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    maybeId <- case id of
        Nothing -> return FP.nullPtr
        Just jId -> do
            jId' <- textToCString jId
            return jId'
    text' <- textToCString text
    gtk_combo_box_text_prepend comboBox' maybeId text'
    touchManagedPtr comboBox
    freeMem maybeId
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextPrependMethodInfo
instance (signature ~ (Maybe (T.Text) -> T.Text -> m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextPrependMethodInfo a signature where
    overloadedMethod = comboBoxTextPrepend

instance O.OverloadedMethodInfo ComboBoxTextPrependMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextPrepend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextPrepend"
        })


#endif

-- method ComboBoxText::prepend_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_prepend_text" gtk_combo_box_text_prepend_text :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    CString ->                              -- text : TBasicType TUTF8
    IO ()

{-# DEPRECATED comboBoxTextPrependText ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Prepends /@text@/ to the list of strings stored in /@comboBox@/.
-- 
-- This is the same as calling 'GI.Gtk.Objects.ComboBoxText.comboBoxTextInsertText'
-- with a position of 0.
comboBoxTextPrependText ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> T.Text
    -- ^ /@text@/: A string
    -> m ()
comboBoxTextPrependText comboBox text = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    text' <- textToCString text
    gtk_combo_box_text_prepend_text comboBox' text'
    touchManagedPtr comboBox
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextPrependTextMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextPrependTextMethodInfo a signature where
    overloadedMethod = comboBoxTextPrependText

instance O.OverloadedMethodInfo ComboBoxTextPrependTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextPrependText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextPrependText"
        })


#endif

-- method ComboBoxText::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Index of the item to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_remove" gtk_combo_box_text_remove :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

{-# DEPRECATED comboBoxTextRemove ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Removes the string at /@position@/ from /@comboBox@/.
comboBoxTextRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBox@
    -> Int32
    -- ^ /@position@/: Index of the item to remove
    -> m ()
comboBoxTextRemove comboBox position = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    gtk_combo_box_text_remove comboBox' position
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextRemoveMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextRemoveMethodInfo a signature where
    overloadedMethod = comboBoxTextRemove

instance O.OverloadedMethodInfo ComboBoxTextRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextRemove"
        })


#endif

-- method ComboBoxText::remove_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "combo_box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ComboBoxText" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkComboBoxText`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_combo_box_text_remove_all" gtk_combo_box_text_remove_all :: 
    Ptr ComboBoxText ->                     -- combo_box : TInterface (Name {namespace = "Gtk", name = "ComboBoxText"})
    IO ()

{-# DEPRECATED comboBoxTextRemoveAll ["(Since version 4.10)","Use t'GI.Gtk.Objects.DropDown.DropDown'"] #-}
-- | Removes all the text entries from the combo box.
comboBoxTextRemoveAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsComboBoxText a) =>
    a
    -- ^ /@comboBox@/: A @GtkComboBoxText@
    -> m ()
comboBoxTextRemoveAll comboBox = liftIO $ do
    comboBox' <- unsafeManagedPtrCastPtr comboBox
    gtk_combo_box_text_remove_all comboBox'
    touchManagedPtr comboBox
    return ()

#if defined(ENABLE_OVERLOADING)
data ComboBoxTextRemoveAllMethodInfo
instance (signature ~ (m ()), MonadIO m, IsComboBoxText a) => O.OverloadedMethod ComboBoxTextRemoveAllMethodInfo a signature where
    overloadedMethod = comboBoxTextRemoveAll

instance O.OverloadedMethodInfo ComboBoxTextRemoveAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ComboBoxText.comboBoxTextRemoveAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ComboBoxText.html#v:comboBoxTextRemoveAll"
        })


#endif


