{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Asynchronous API to present a color chooser dialog.
-- 
-- @GtkColorDialog@ collects the arguments that are needed to present
-- the dialog to the user, such as a title for the dialog and whether
-- it should be modal.
-- 
-- The dialog is shown with the 'GI.Gtk.Objects.ColorDialog.colorDialogChooseRgba'
-- function.
-- 
-- See t'GI.Gtk.Objects.ColorDialogButton.ColorDialogButton' for a convenient control
-- that uses @GtkColorDialog@ and presents the results.
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ColorDialog
    ( 

-- * Exported types
    ColorDialog(..)                         ,
    IsColorDialog                           ,
    toColorDialog                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [chooseRgba]("GI.Gtk.Objects.ColorDialog#g:method:chooseRgba"), [chooseRgbaFinish]("GI.Gtk.Objects.ColorDialog#g:method:chooseRgbaFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getModal]("GI.Gtk.Objects.ColorDialog#g:method:getModal"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTitle]("GI.Gtk.Objects.ColorDialog#g:method:getTitle"), [getWithAlpha]("GI.Gtk.Objects.ColorDialog#g:method:getWithAlpha").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setModal]("GI.Gtk.Objects.ColorDialog#g:method:setModal"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTitle]("GI.Gtk.Objects.ColorDialog#g:method:setTitle"), [setWithAlpha]("GI.Gtk.Objects.ColorDialog#g:method:setWithAlpha").

#if defined(ENABLE_OVERLOADING)
    ResolveColorDialogMethod                ,
#endif

-- ** chooseRgba #method:chooseRgba#

#if defined(ENABLE_OVERLOADING)
    ColorDialogChooseRgbaMethodInfo         ,
#endif
    colorDialogChooseRgba                   ,


-- ** chooseRgbaFinish #method:chooseRgbaFinish#

#if defined(ENABLE_OVERLOADING)
    ColorDialogChooseRgbaFinishMethodInfo   ,
#endif
    colorDialogChooseRgbaFinish             ,


-- ** getModal #method:getModal#

#if defined(ENABLE_OVERLOADING)
    ColorDialogGetModalMethodInfo           ,
#endif
    colorDialogGetModal                     ,


-- ** getTitle #method:getTitle#

#if defined(ENABLE_OVERLOADING)
    ColorDialogGetTitleMethodInfo           ,
#endif
    colorDialogGetTitle                     ,


-- ** getWithAlpha #method:getWithAlpha#

#if defined(ENABLE_OVERLOADING)
    ColorDialogGetWithAlphaMethodInfo       ,
#endif
    colorDialogGetWithAlpha                 ,


-- ** new #method:new#

    colorDialogNew                          ,


-- ** setModal #method:setModal#

#if defined(ENABLE_OVERLOADING)
    ColorDialogSetModalMethodInfo           ,
#endif
    colorDialogSetModal                     ,


-- ** setTitle #method:setTitle#

#if defined(ENABLE_OVERLOADING)
    ColorDialogSetTitleMethodInfo           ,
#endif
    colorDialogSetTitle                     ,


-- ** setWithAlpha #method:setWithAlpha#

#if defined(ENABLE_OVERLOADING)
    ColorDialogSetWithAlphaMethodInfo       ,
#endif
    colorDialogSetWithAlpha                 ,




 -- * Properties


-- ** modal #attr:modal#
-- | Whether the color chooser dialog is modal.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ColorDialogModalPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    colorDialogModal                        ,
#endif
    constructColorDialogModal               ,
    getColorDialogModal                     ,
    setColorDialogModal                     ,


-- ** title #attr:title#
-- | A title that may be shown on the color chooser dialog.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ColorDialogTitlePropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    colorDialogTitle                        ,
#endif
    constructColorDialogTitle               ,
    getColorDialogTitle                     ,
    setColorDialogTitle                     ,


-- ** withAlpha #attr:withAlpha#
-- | Whether colors may have alpha (translucency).
-- 
-- When with-alpha is false, the color that is selected
-- will be forced to have alpha == 1.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ColorDialogWithAlphaPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    colorDialogWithAlpha                    ,
#endif
    constructColorDialogWithAlpha           ,
    getColorDialogWithAlpha                 ,
    setColorDialogWithAlpha                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype ColorDialog = ColorDialog (SP.ManagedPtr ColorDialog)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorDialog where
    toManagedPtr (ColorDialog p) = p

foreign import ccall "gtk_color_dialog_get_type"
    c_gtk_color_dialog_get_type :: IO B.Types.GType

instance B.Types.TypedObject ColorDialog where
    glibType = c_gtk_color_dialog_get_type

instance B.Types.GObject ColorDialog

-- | Type class for types which can be safely cast to `ColorDialog`, for instance with `toColorDialog`.
class (SP.GObject o, O.IsDescendantOf ColorDialog o) => IsColorDialog o
instance (SP.GObject o, O.IsDescendantOf ColorDialog o) => IsColorDialog o

instance O.HasParentTypes ColorDialog
type instance O.ParentTypes ColorDialog = '[GObject.Object.Object]

-- | Cast to `ColorDialog`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toColorDialog :: (MIO.MonadIO m, IsColorDialog o) => o -> m ColorDialog
toColorDialog = MIO.liftIO . B.ManagedPtr.unsafeCastTo ColorDialog

-- | Convert 'ColorDialog' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ColorDialog) where
    gvalueGType_ = c_gtk_color_dialog_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ColorDialog)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ColorDialog)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ColorDialog ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveColorDialogMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorDialogMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveColorDialogMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveColorDialogMethod "chooseRgba" o = ColorDialogChooseRgbaMethodInfo
    ResolveColorDialogMethod "chooseRgbaFinish" o = ColorDialogChooseRgbaFinishMethodInfo
    ResolveColorDialogMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveColorDialogMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveColorDialogMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveColorDialogMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveColorDialogMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveColorDialogMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveColorDialogMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveColorDialogMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveColorDialogMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveColorDialogMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveColorDialogMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveColorDialogMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveColorDialogMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveColorDialogMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveColorDialogMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveColorDialogMethod "getModal" o = ColorDialogGetModalMethodInfo
    ResolveColorDialogMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveColorDialogMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveColorDialogMethod "getTitle" o = ColorDialogGetTitleMethodInfo
    ResolveColorDialogMethod "getWithAlpha" o = ColorDialogGetWithAlphaMethodInfo
    ResolveColorDialogMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveColorDialogMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveColorDialogMethod "setModal" o = ColorDialogSetModalMethodInfo
    ResolveColorDialogMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveColorDialogMethod "setTitle" o = ColorDialogSetTitleMethodInfo
    ResolveColorDialogMethod "setWithAlpha" o = ColorDialogSetWithAlphaMethodInfo
    ResolveColorDialogMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorDialogMethod t ColorDialog, O.OverloadedMethod info ColorDialog p) => OL.IsLabel t (ColorDialog -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorDialogMethod t ColorDialog, O.OverloadedMethod info ColorDialog p, R.HasField t ColorDialog p) => R.HasField t ColorDialog p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorDialogMethod t ColorDialog, O.OverloadedMethodInfo info ColorDialog) => OL.IsLabel t (O.MethodProxy info ColorDialog) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "modal"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorDialog #modal
-- @
getColorDialogModal :: (MonadIO m, IsColorDialog o) => o -> m Bool
getColorDialogModal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "modal"

-- | Set the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorDialog [ #modal 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorDialogModal :: (MonadIO m, IsColorDialog o) => o -> Bool -> m ()
setColorDialogModal obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "modal" val

-- | Construct a `GValueConstruct` with valid value for the “@modal@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColorDialogModal :: (IsColorDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructColorDialogModal val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "modal" val

#if defined(ENABLE_OVERLOADING)
data ColorDialogModalPropertyInfo
instance AttrInfo ColorDialogModalPropertyInfo where
    type AttrAllowedOps ColorDialogModalPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ColorDialogModalPropertyInfo = IsColorDialog
    type AttrSetTypeConstraint ColorDialogModalPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ColorDialogModalPropertyInfo = (~) Bool
    type AttrTransferType ColorDialogModalPropertyInfo = Bool
    type AttrGetType ColorDialogModalPropertyInfo = Bool
    type AttrLabel ColorDialogModalPropertyInfo = "modal"
    type AttrOrigin ColorDialogModalPropertyInfo = ColorDialog
    attrGet = getColorDialogModal
    attrSet = setColorDialogModal
    attrTransfer _ v = do
        return v
    attrConstruct = constructColorDialogModal
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.modal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#g:attr:modal"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorDialog #title
-- @
getColorDialogTitle :: (MonadIO m, IsColorDialog o) => o -> m T.Text
getColorDialogTitle obj = MIO.liftIO $ checkUnexpectedNothing "getColorDialogTitle" $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorDialog [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorDialogTitle :: (MonadIO m, IsColorDialog o) => o -> T.Text -> m ()
setColorDialogTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColorDialogTitle :: (IsColorDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructColorDialogTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ColorDialogTitlePropertyInfo
instance AttrInfo ColorDialogTitlePropertyInfo where
    type AttrAllowedOps ColorDialogTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ColorDialogTitlePropertyInfo = IsColorDialog
    type AttrSetTypeConstraint ColorDialogTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ColorDialogTitlePropertyInfo = (~) T.Text
    type AttrTransferType ColorDialogTitlePropertyInfo = T.Text
    type AttrGetType ColorDialogTitlePropertyInfo = T.Text
    type AttrLabel ColorDialogTitlePropertyInfo = "title"
    type AttrOrigin ColorDialogTitlePropertyInfo = ColorDialog
    attrGet = getColorDialogTitle
    attrSet = setColorDialogTitle
    attrTransfer _ v = do
        return v
    attrConstruct = constructColorDialogTitle
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#g:attr:title"
        })
#endif

-- VVV Prop "with-alpha"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@with-alpha@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorDialog #withAlpha
-- @
getColorDialogWithAlpha :: (MonadIO m, IsColorDialog o) => o -> m Bool
getColorDialogWithAlpha obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "with-alpha"

-- | Set the value of the “@with-alpha@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorDialog [ #withAlpha 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorDialogWithAlpha :: (MonadIO m, IsColorDialog o) => o -> Bool -> m ()
setColorDialogWithAlpha obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "with-alpha" val

-- | Construct a `GValueConstruct` with valid value for the “@with-alpha@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColorDialogWithAlpha :: (IsColorDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructColorDialogWithAlpha val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "with-alpha" val

#if defined(ENABLE_OVERLOADING)
data ColorDialogWithAlphaPropertyInfo
instance AttrInfo ColorDialogWithAlphaPropertyInfo where
    type AttrAllowedOps ColorDialogWithAlphaPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ColorDialogWithAlphaPropertyInfo = IsColorDialog
    type AttrSetTypeConstraint ColorDialogWithAlphaPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ColorDialogWithAlphaPropertyInfo = (~) Bool
    type AttrTransferType ColorDialogWithAlphaPropertyInfo = Bool
    type AttrGetType ColorDialogWithAlphaPropertyInfo = Bool
    type AttrLabel ColorDialogWithAlphaPropertyInfo = "with-alpha"
    type AttrOrigin ColorDialogWithAlphaPropertyInfo = ColorDialog
    attrGet = getColorDialogWithAlpha
    attrSet = setColorDialogWithAlpha
    attrTransfer _ v = do
        return v
    attrConstruct = constructColorDialogWithAlpha
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.withAlpha"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#g:attr:withAlpha"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColorDialog
type instance O.AttributeList ColorDialog = ColorDialogAttributeList
type ColorDialogAttributeList = ('[ '("modal", ColorDialogModalPropertyInfo), '("title", ColorDialogTitlePropertyInfo), '("withAlpha", ColorDialogWithAlphaPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
colorDialogModal :: AttrLabelProxy "modal"
colorDialogModal = AttrLabelProxy

colorDialogTitle :: AttrLabelProxy "title"
colorDialogTitle = AttrLabelProxy

colorDialogWithAlpha :: AttrLabelProxy "withAlpha"
colorDialogWithAlpha = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ColorDialog = ColorDialogSignalList
type ColorDialogSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ColorDialog::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ColorDialog" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_new" gtk_color_dialog_new :: 
    IO (Ptr ColorDialog)

-- | Creates a new @GtkColorDialog@ object.
-- 
-- /Since: 4.10/
colorDialogNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ColorDialog
    -- ^ __Returns:__ the new @GtkColorDialog@
colorDialogNew  = liftIO $ do
    result <- gtk_color_dialog_new
    checkUnexpectedReturnNULL "colorDialogNew" result
    result' <- (wrapObject ColorDialog) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorDialog::choose_rgba
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "initial_color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the color to select initially"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cancellable to cancel the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a callback to call\n  when the operation is complete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_choose_rgba" gtk_color_dialog_choose_rgba :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gdk.RGBA.RGBA ->                    -- initial_color : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Presents a color chooser dialog to the user.
-- 
-- /Since: 4.10/
colorDialogChooseRgba ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@self@/: a color dialog
    -> Maybe (b)
    -- ^ /@parent@/: the parent window
    -> Maybe (Gdk.RGBA.RGBA)
    -- ^ /@initialColor@/: the color to select initially
    -> Maybe (c)
    -- ^ /@cancellable@/: a cancellable to cancel the operation
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a callback to call
    --   when the operation is complete
    -> m ()
colorDialogChooseRgba self parent initialColor cancellable callback = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    maybeInitialColor <- case initialColor of
        Nothing -> return FP.nullPtr
        Just jInitialColor -> do
            jInitialColor' <- unsafeManagedPtrGetPtr jInitialColor
            return jInitialColor'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gtk_color_dialog_choose_rgba self' maybeParent maybeInitialColor maybeCancellable maybeCallback userData
    touchManagedPtr self
    whenJust parent touchManagedPtr
    whenJust initialColor touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorDialogChooseRgbaMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gdk.RGBA.RGBA) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsColorDialog a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod ColorDialogChooseRgbaMethodInfo a signature where
    overloadedMethod = colorDialogChooseRgba

instance O.OverloadedMethodInfo ColorDialogChooseRgbaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogChooseRgba",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogChooseRgba"
        })


#endif

-- method ColorDialog::choose_rgba_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "RGBA" })
-- throws : True
-- Skip return : False

foreign import ccall "gtk_color_dialog_choose_rgba_finish" gtk_color_dialog_choose_rgba_finish :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gdk.RGBA.RGBA)

-- | Finishes the 'GI.Gtk.Objects.ColorDialog.colorDialogChooseRgba' call
-- 
-- /Since: 4.10/
colorDialogChooseRgbaFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@self@/: a color dialog
    -> b
    -- ^ /@result@/: the result
    -> m (Maybe Gdk.RGBA.RGBA)
    -- ^ __Returns:__ the selected color /(Can throw 'Data.GI.Base.GError.GError')/
colorDialogChooseRgbaFinish self result_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ gtk_color_dialog_choose_rgba_finish self' result_'
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapBoxed Gdk.RGBA.RGBA) result'
            return result''
        touchManagedPtr self
        touchManagedPtr result_
        return maybeResult
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data ColorDialogChooseRgbaFinishMethodInfo
instance (signature ~ (b -> m (Maybe Gdk.RGBA.RGBA)), MonadIO m, IsColorDialog a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod ColorDialogChooseRgbaFinishMethodInfo a signature where
    overloadedMethod = colorDialogChooseRgbaFinish

instance O.OverloadedMethodInfo ColorDialogChooseRgbaFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogChooseRgbaFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogChooseRgbaFinish"
        })


#endif

-- method ColorDialog::get_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_get_modal" gtk_color_dialog_get_modal :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    IO CInt

-- | Returns whether the color chooser dialog
-- blocks interaction with the parent window
-- while it is presented.
-- 
-- /Since: 4.10/
colorDialogGetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a) =>
    a
    -- ^ /@self@/: a color dialog
    -> m Bool
    -- ^ __Returns:__ true if the color chooser dialog is modal
colorDialogGetModal self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_color_dialog_get_modal self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorDialogGetModalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsColorDialog a) => O.OverloadedMethod ColorDialogGetModalMethodInfo a signature where
    overloadedMethod = colorDialogGetModal

instance O.OverloadedMethodInfo ColorDialogGetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogGetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogGetModal"
        })


#endif

-- method ColorDialog::get_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_get_title" gtk_color_dialog_get_title :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    IO CString

-- | Returns the title that will be shown on the
-- color chooser dialog.
-- 
-- /Since: 4.10/
colorDialogGetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a) =>
    a
    -- ^ /@self@/: a color dialog
    -> m T.Text
    -- ^ __Returns:__ the title
colorDialogGetTitle self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_color_dialog_get_title self'
    checkUnexpectedReturnNULL "colorDialogGetTitle" result
    result' <- cstringToText result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorDialogGetTitleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsColorDialog a) => O.OverloadedMethod ColorDialogGetTitleMethodInfo a signature where
    overloadedMethod = colorDialogGetTitle

instance O.OverloadedMethodInfo ColorDialogGetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogGetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogGetTitle"
        })


#endif

-- method ColorDialog::get_with_alpha
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dailog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_get_with_alpha" gtk_color_dialog_get_with_alpha :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    IO CInt

-- | Returns whether colors may have alpha.
-- 
-- /Since: 4.10/
colorDialogGetWithAlpha ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a) =>
    a
    -- ^ /@self@/: a color dailog
    -> m Bool
    -- ^ __Returns:__ true if colors may have alpha
colorDialogGetWithAlpha self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_color_dialog_get_with_alpha self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorDialogGetWithAlphaMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsColorDialog a) => O.OverloadedMethod ColorDialogGetWithAlphaMethodInfo a signature where
    overloadedMethod = colorDialogGetWithAlpha

instance O.OverloadedMethodInfo ColorDialogGetWithAlphaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogGetWithAlpha",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogGetWithAlpha"
        })


#endif

-- method ColorDialog::set_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_set_modal" gtk_color_dialog_set_modal :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    CInt ->                                 -- modal : TBasicType TBoolean
    IO ()

-- | Sets whether the color chooser dialog
-- blocks interaction with the parent window
-- while it is presented.
-- 
-- /Since: 4.10/
colorDialogSetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a) =>
    a
    -- ^ /@self@/: a color dialog
    -> Bool
    -- ^ /@modal@/: the new value
    -> m ()
colorDialogSetModal self modal = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let modal' = (P.fromIntegral . P.fromEnum) modal
    gtk_color_dialog_set_modal self' modal'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorDialogSetModalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsColorDialog a) => O.OverloadedMethod ColorDialogSetModalMethodInfo a signature where
    overloadedMethod = colorDialogSetModal

instance O.OverloadedMethodInfo ColorDialogSetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogSetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogSetModal"
        })


#endif

-- method ColorDialog::set_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new title" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_set_title" gtk_color_dialog_set_title :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    CString ->                              -- title : TBasicType TUTF8
    IO ()

-- | Sets the title that will be shown on the
-- color chooser dialog.
-- 
-- /Since: 4.10/
colorDialogSetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a) =>
    a
    -- ^ /@self@/: a color dialog
    -> T.Text
    -- ^ /@title@/: the new title
    -> m ()
colorDialogSetTitle self title = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    title' <- textToCString title
    gtk_color_dialog_set_title self' title'
    touchManagedPtr self
    freeMem title'
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorDialogSetTitleMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsColorDialog a) => O.OverloadedMethod ColorDialogSetTitleMethodInfo a signature where
    overloadedMethod = colorDialogSetTitle

instance O.OverloadedMethodInfo ColorDialogSetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogSetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogSetTitle"
        })


#endif

-- method ColorDialog::set_with_alpha
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColorDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "with_alpha"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_color_dialog_set_with_alpha" gtk_color_dialog_set_with_alpha :: 
    Ptr ColorDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "ColorDialog"})
    CInt ->                                 -- with_alpha : TBasicType TBoolean
    IO ()

-- | Sets whether colors may have alpha.
-- 
-- /Since: 4.10/
colorDialogSetWithAlpha ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorDialog a) =>
    a
    -- ^ /@self@/: a color dialog
    -> Bool
    -- ^ /@withAlpha@/: the new value
    -> m ()
colorDialogSetWithAlpha self withAlpha = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let withAlpha' = (P.fromIntegral . P.fromEnum) withAlpha
    gtk_color_dialog_set_with_alpha self' withAlpha'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorDialogSetWithAlphaMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsColorDialog a) => O.OverloadedMethod ColorDialogSetWithAlphaMethodInfo a signature where
    overloadedMethod = colorDialogSetWithAlpha

instance O.OverloadedMethodInfo ColorDialogSetWithAlphaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColorDialog.colorDialogSetWithAlpha",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ColorDialog.html#v:colorDialogSetWithAlpha"
        })


#endif


