{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An expression using a custom @GClosure@ to compute the value from
-- its parameters.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ClosureExpression
    ( 

-- * Exported types
    ClosureExpression(..)                   ,
    IsClosureExpression                     ,
    toClosureExpression                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bind]("GI.Gtk.Objects.Expression#g:method:bind"), [evaluate]("GI.Gtk.Objects.Expression#g:method:evaluate"), [isStatic]("GI.Gtk.Objects.Expression#g:method:isStatic"), [ref]("GI.Gtk.Objects.Expression#g:method:ref"), [unref]("GI.Gtk.Objects.Expression#g:method:unref"), [watch]("GI.Gtk.Objects.Expression#g:method:watch").
-- 
-- ==== Getters
-- [getValueType]("GI.Gtk.Objects.Expression#g:method:getValueType").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveClosureExpressionMethod          ,
#endif

-- ** new #method:new#

    closureExpressionNew                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch

#else
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression

#endif

-- | Memory-managed wrapper type.
newtype ClosureExpression = ClosureExpression (SP.ManagedPtr ClosureExpression)
    deriving (Eq)

instance SP.ManagedPtrNewtype ClosureExpression where
    toManagedPtr (ClosureExpression p) = p

foreign import ccall "gtk_closure_expression_get_type"
    c_gtk_closure_expression_get_type :: IO B.Types.GType

instance B.Types.TypedObject ClosureExpression where
    glibType = c_gtk_closure_expression_get_type

-- | Type class for types which can be safely cast to `ClosureExpression`, for instance with `toClosureExpression`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ClosureExpression o) => IsClosureExpression o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ClosureExpression o) => IsClosureExpression o

instance O.HasParentTypes ClosureExpression
type instance O.ParentTypes ClosureExpression = '[Gtk.Expression.Expression]

-- | Cast to `ClosureExpression`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toClosureExpression :: (MIO.MonadIO m, IsClosureExpression o) => o -> m ClosureExpression
toClosureExpression = MIO.liftIO . B.ManagedPtr.unsafeCastTo ClosureExpression

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveClosureExpressionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveClosureExpressionMethod "bind" o = Gtk.Expression.ExpressionBindMethodInfo
    ResolveClosureExpressionMethod "evaluate" o = Gtk.Expression.ExpressionEvaluateMethodInfo
    ResolveClosureExpressionMethod "isStatic" o = Gtk.Expression.ExpressionIsStaticMethodInfo
    ResolveClosureExpressionMethod "ref" o = Gtk.Expression.ExpressionRefMethodInfo
    ResolveClosureExpressionMethod "unref" o = Gtk.Expression.ExpressionUnrefMethodInfo
    ResolveClosureExpressionMethod "watch" o = Gtk.Expression.ExpressionWatchMethodInfo
    ResolveClosureExpressionMethod "getValueType" o = Gtk.Expression.ExpressionGetValueTypeMethodInfo
    ResolveClosureExpressionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveClosureExpressionMethod t ClosureExpression, O.OverloadedMethod info ClosureExpression p) => OL.IsLabel t (ClosureExpression -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveClosureExpressionMethod t ClosureExpression, O.OverloadedMethod info ClosureExpression p, R.HasField t ClosureExpression p) => R.HasField t ClosureExpression p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveClosureExpressionMethod t ClosureExpression, O.OverloadedMethodInfo info ClosureExpression) => OL.IsLabel t (O.MethodProxy info ClosureExpression) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ClosureExpression where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ClosureExpression::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "value_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the type of the value that this expression evaluates to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "closure to call when evaluating this expression. If closure is floating, it is adopted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_params"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of params needed for evaluating `closure`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "params"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Gtk" , name = "Expression" })
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "expressions for each parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_params"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number of params needed for evaluating `closure`"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "ClosureExpression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_closure_expression_new" gtk_closure_expression_new :: 
    CGType ->                               -- value_type : TBasicType TGType
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Word32 ->                               -- n_params : TBasicType TUInt
    Ptr (Ptr Gtk.Expression.Expression) ->  -- params : TCArray False (-1) 2 (TInterface (Name {namespace = "Gtk", name = "Expression"}))
    IO (Ptr ClosureExpression)

-- | Creates a @GtkExpression@ that calls @closure@ when it is evaluated.
-- 
-- @closure@ is called with the @this@ object and the results of evaluating
-- the @params@ expressions.
closureExpressionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@valueType@/: the type of the value that this expression evaluates to
    -> GClosure a
    -- ^ /@closure@/: closure to call when evaluating this expression. If closure is floating, it is adopted
    -> Maybe ([Gtk.Expression.Expression])
    -- ^ /@params@/: expressions for each parameter
    -> m ClosureExpression
    -- ^ __Returns:__ a new @GtkExpression@
closureExpressionNew valueType closure params = liftIO $ do
    let nParams = case params of
            Nothing -> 0
            Just jParams -> fromIntegral $ P.length jParams
    let valueType' = gtypeToCGType valueType
    closure' <- unsafeManagedPtrCastPtr closure
    maybeParams <- case params of
        Nothing -> return FP.nullPtr
        Just jParams -> do
            jParams' <- mapM B.ManagedPtr.disownManagedPtr jParams
            jParams'' <- packPtrArray jParams'
            return jParams''
    result <- gtk_closure_expression_new valueType' closure' nParams maybeParams
    checkUnexpectedReturnNULL "closureExpressionNew" result
    result' <- (wrapPtr ClosureExpression) result
    touchManagedPtr closure
    whenJust params (mapM_ touchManagedPtr)
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


