{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Arranges three children in a row, keeping the middle child
-- centered as well as possible.
-- 
-- \<picture>
--   \<source srcset=\"centerbox-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkCenterBox\" src=\"centerbox.png\">
-- \<\/picture>
-- 
-- To add children to @GtkCenterBox@, use 'GI.Gtk.Objects.CenterBox.centerBoxSetStartWidget',
-- 'GI.Gtk.Objects.CenterBox.centerBoxSetCenterWidget' and
-- 'GI.Gtk.Objects.CenterBox.centerBoxSetEndWidget'.
-- 
-- The sizing and positioning of children can be influenced with the
-- align and expand properties of the children.
-- 
-- = GtkCenterBox as GtkBuildable
-- 
-- The @GtkCenterBox@ implementation of the @GtkBuildable@ interface
-- supports placing children in the 3 positions by specifying “start”, “center”
-- or “end” as the “type” attribute of a @\<child>@ element.
-- 
-- = CSS nodes
-- 
-- @GtkCenterBox@ uses a single CSS node with the name “box”,
-- 
-- The first child of the @GtkCenterBox@ will be allocated depending on the
-- text direction, i.e. in left-to-right layouts it will be allocated on the
-- left and in right-to-left layouts on the right.
-- 
-- In vertical orientation, the nodes of the children are arranged from top to
-- bottom.
-- 
-- = Accessibility
-- 
-- Until GTK 4.10, @GtkCenterBox@ used the [enum/@gtk@/.AccessibleRole.group] role.
-- 
-- Starting from GTK 4.12, @GtkCenterBox@ uses the [enum/@gtk@/.AccessibleRole.generic]
-- role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CenterBox
    ( 

-- * Exported types
    CenterBox(..)                           ,
    IsCenterBox                             ,
    toCenterBox                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBaselinePosition]("GI.Gtk.Objects.CenterBox#g:method:getBaselinePosition"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCenterWidget]("GI.Gtk.Objects.CenterBox#g:method:getCenterWidget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEndWidget]("GI.Gtk.Objects.CenterBox#g:method:getEndWidget"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShrinkCenterLast]("GI.Gtk.Objects.CenterBox#g:method:getShrinkCenterLast"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStartWidget]("GI.Gtk.Objects.CenterBox#g:method:getStartWidget"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setBaselinePosition]("GI.Gtk.Objects.CenterBox#g:method:setBaselinePosition"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCenterWidget]("GI.Gtk.Objects.CenterBox#g:method:setCenterWidget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEndWidget]("GI.Gtk.Objects.CenterBox#g:method:setEndWidget"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShrinkCenterLast]("GI.Gtk.Objects.CenterBox#g:method:setShrinkCenterLast"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartWidget]("GI.Gtk.Objects.CenterBox#g:method:setStartWidget"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveCenterBoxMethod                  ,
#endif

-- ** getBaselinePosition #method:getBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    CenterBoxGetBaselinePositionMethodInfo  ,
#endif
    centerBoxGetBaselinePosition            ,


-- ** getCenterWidget #method:getCenterWidget#

#if defined(ENABLE_OVERLOADING)
    CenterBoxGetCenterWidgetMethodInfo      ,
#endif
    centerBoxGetCenterWidget                ,


-- ** getEndWidget #method:getEndWidget#

#if defined(ENABLE_OVERLOADING)
    CenterBoxGetEndWidgetMethodInfo         ,
#endif
    centerBoxGetEndWidget                   ,


-- ** getShrinkCenterLast #method:getShrinkCenterLast#

#if defined(ENABLE_OVERLOADING)
    CenterBoxGetShrinkCenterLastMethodInfo  ,
#endif
    centerBoxGetShrinkCenterLast            ,


-- ** getStartWidget #method:getStartWidget#

#if defined(ENABLE_OVERLOADING)
    CenterBoxGetStartWidgetMethodInfo       ,
#endif
    centerBoxGetStartWidget                 ,


-- ** new #method:new#

    centerBoxNew                            ,


-- ** setBaselinePosition #method:setBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    CenterBoxSetBaselinePositionMethodInfo  ,
#endif
    centerBoxSetBaselinePosition            ,


-- ** setCenterWidget #method:setCenterWidget#

#if defined(ENABLE_OVERLOADING)
    CenterBoxSetCenterWidgetMethodInfo      ,
#endif
    centerBoxSetCenterWidget                ,


-- ** setEndWidget #method:setEndWidget#

#if defined(ENABLE_OVERLOADING)
    CenterBoxSetEndWidgetMethodInfo         ,
#endif
    centerBoxSetEndWidget                   ,


-- ** setShrinkCenterLast #method:setShrinkCenterLast#

#if defined(ENABLE_OVERLOADING)
    CenterBoxSetShrinkCenterLastMethodInfo  ,
#endif
    centerBoxSetShrinkCenterLast            ,


-- ** setStartWidget #method:setStartWidget#

#if defined(ENABLE_OVERLOADING)
    CenterBoxSetStartWidgetMethodInfo       ,
#endif
    centerBoxSetStartWidget                 ,




 -- * Properties


-- ** baselinePosition #attr:baselinePosition#
-- | The position of the baseline aligned widget if extra space is available.

#if defined(ENABLE_OVERLOADING)
    CenterBoxBaselinePositionPropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    centerBoxBaselinePosition               ,
#endif
    constructCenterBoxBaselinePosition      ,
    getCenterBoxBaselinePosition            ,
    setCenterBoxBaselinePosition            ,


-- ** centerWidget #attr:centerWidget#
-- | The widget that is placed at the center position.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    CenterBoxCenterWidgetPropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    centerBoxCenterWidget                   ,
#endif
    clearCenterBoxCenterWidget              ,
    constructCenterBoxCenterWidget          ,
    getCenterBoxCenterWidget                ,
    setCenterBoxCenterWidget                ,


-- ** endWidget #attr:endWidget#
-- | The widget that is placed at the end position.
-- 
-- In vertical orientation, the end position is at the bottom.
-- In horizontal orientation, the end position is at the trailing
-- edge with respect to the text direction.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    CenterBoxEndWidgetPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    centerBoxEndWidget                      ,
#endif
    clearCenterBoxEndWidget                 ,
    constructCenterBoxEndWidget             ,
    getCenterBoxEndWidget                   ,
    setCenterBoxEndWidget                   ,


-- ** shrinkCenterLast #attr:shrinkCenterLast#
-- | Whether to shrink the center widget after other children.
-- 
-- By default, when there\'s no space to give all three children their
-- natural widths, the start and end widgets start shrinking and the
-- center child keeps natural width until they reach minimum width.
-- 
-- If false, start and end widgets keep natural width and the
-- center widget starts shrinking instead.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    CenterBoxShrinkCenterLastPropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    centerBoxShrinkCenterLast               ,
#endif
    constructCenterBoxShrinkCenterLast      ,
    getCenterBoxShrinkCenterLast            ,
    setCenterBoxShrinkCenterLast            ,


-- ** startWidget #attr:startWidget#
-- | The widget that is placed at the start position.
-- 
-- In vertical orientation, the start position is at the top.
-- In horizontal orientation, the start position is at the leading
-- edge with respect to the text direction.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    CenterBoxStartWidgetPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    centerBoxStartWidget                    ,
#endif
    clearCenterBoxStartWidget               ,
    constructCenterBoxStartWidget           ,
    getCenterBoxStartWidget                 ,
    setCenterBoxStartWidget                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype CenterBox = CenterBox (SP.ManagedPtr CenterBox)
    deriving (Eq)

instance SP.ManagedPtrNewtype CenterBox where
    toManagedPtr (CenterBox p) = p

foreign import ccall "gtk_center_box_get_type"
    c_gtk_center_box_get_type :: IO B.Types.GType

instance B.Types.TypedObject CenterBox where
    glibType = c_gtk_center_box_get_type

instance B.Types.GObject CenterBox

-- | Type class for types which can be safely cast to `CenterBox`, for instance with `toCenterBox`.
class (SP.GObject o, O.IsDescendantOf CenterBox o) => IsCenterBox o
instance (SP.GObject o, O.IsDescendantOf CenterBox o) => IsCenterBox o

instance O.HasParentTypes CenterBox
type instance O.ParentTypes CenterBox = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to `CenterBox`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toCenterBox :: (MIO.MonadIO m, IsCenterBox o) => o -> m CenterBox
toCenterBox = MIO.liftIO . B.ManagedPtr.unsafeCastTo CenterBox

-- | Convert 'CenterBox' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CenterBox) where
    gvalueGType_ = c_gtk_center_box_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CenterBox)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CenterBox)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CenterBox ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCenterBoxMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCenterBoxMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveCenterBoxMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveCenterBoxMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveCenterBoxMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveCenterBoxMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveCenterBoxMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveCenterBoxMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveCenterBoxMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveCenterBoxMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveCenterBoxMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveCenterBoxMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCenterBoxMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCenterBoxMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveCenterBoxMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveCenterBoxMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveCenterBoxMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveCenterBoxMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveCenterBoxMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveCenterBoxMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveCenterBoxMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveCenterBoxMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveCenterBoxMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveCenterBoxMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveCenterBoxMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCenterBoxMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCenterBoxMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCenterBoxMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveCenterBoxMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveCenterBoxMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveCenterBoxMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveCenterBoxMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveCenterBoxMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveCenterBoxMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveCenterBoxMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveCenterBoxMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveCenterBoxMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveCenterBoxMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveCenterBoxMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveCenterBoxMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveCenterBoxMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCenterBoxMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveCenterBoxMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveCenterBoxMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveCenterBoxMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveCenterBoxMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveCenterBoxMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveCenterBoxMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveCenterBoxMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveCenterBoxMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCenterBoxMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCenterBoxMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveCenterBoxMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveCenterBoxMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveCenterBoxMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveCenterBoxMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveCenterBoxMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveCenterBoxMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveCenterBoxMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCenterBoxMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCenterBoxMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveCenterBoxMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveCenterBoxMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveCenterBoxMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveCenterBoxMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveCenterBoxMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveCenterBoxMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveCenterBoxMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCenterBoxMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveCenterBoxMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveCenterBoxMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveCenterBoxMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveCenterBoxMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCenterBoxMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCenterBoxMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCenterBoxMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveCenterBoxMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveCenterBoxMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveCenterBoxMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveCenterBoxMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveCenterBoxMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCenterBoxMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveCenterBoxMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveCenterBoxMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveCenterBoxMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveCenterBoxMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveCenterBoxMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveCenterBoxMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCenterBoxMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveCenterBoxMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveCenterBoxMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveCenterBoxMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveCenterBoxMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveCenterBoxMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveCenterBoxMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveCenterBoxMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveCenterBoxMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveCenterBoxMethod "getBaselinePosition" o = CenterBoxGetBaselinePositionMethodInfo
    ResolveCenterBoxMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveCenterBoxMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveCenterBoxMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveCenterBoxMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveCenterBoxMethod "getCenterWidget" o = CenterBoxGetCenterWidgetMethodInfo
    ResolveCenterBoxMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveCenterBoxMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveCenterBoxMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveCenterBoxMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveCenterBoxMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveCenterBoxMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveCenterBoxMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCenterBoxMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveCenterBoxMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveCenterBoxMethod "getEndWidget" o = CenterBoxGetEndWidgetMethodInfo
    ResolveCenterBoxMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveCenterBoxMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveCenterBoxMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveCenterBoxMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveCenterBoxMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveCenterBoxMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveCenterBoxMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveCenterBoxMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveCenterBoxMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveCenterBoxMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveCenterBoxMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveCenterBoxMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveCenterBoxMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveCenterBoxMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveCenterBoxMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveCenterBoxMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveCenterBoxMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveCenterBoxMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveCenterBoxMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveCenterBoxMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveCenterBoxMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveCenterBoxMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveCenterBoxMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveCenterBoxMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveCenterBoxMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveCenterBoxMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveCenterBoxMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveCenterBoxMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveCenterBoxMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveCenterBoxMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveCenterBoxMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveCenterBoxMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveCenterBoxMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveCenterBoxMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveCenterBoxMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCenterBoxMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCenterBoxMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveCenterBoxMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveCenterBoxMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveCenterBoxMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveCenterBoxMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveCenterBoxMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveCenterBoxMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveCenterBoxMethod "getShrinkCenterLast" o = CenterBoxGetShrinkCenterLastMethodInfo
    ResolveCenterBoxMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveCenterBoxMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveCenterBoxMethod "getStartWidget" o = CenterBoxGetStartWidgetMethodInfo
    ResolveCenterBoxMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveCenterBoxMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveCenterBoxMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveCenterBoxMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveCenterBoxMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveCenterBoxMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveCenterBoxMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveCenterBoxMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveCenterBoxMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveCenterBoxMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveCenterBoxMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveCenterBoxMethod "setBaselinePosition" o = CenterBoxSetBaselinePositionMethodInfo
    ResolveCenterBoxMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveCenterBoxMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveCenterBoxMethod "setCenterWidget" o = CenterBoxSetCenterWidgetMethodInfo
    ResolveCenterBoxMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveCenterBoxMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveCenterBoxMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveCenterBoxMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveCenterBoxMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCenterBoxMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCenterBoxMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveCenterBoxMethod "setEndWidget" o = CenterBoxSetEndWidgetMethodInfo
    ResolveCenterBoxMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveCenterBoxMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveCenterBoxMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveCenterBoxMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveCenterBoxMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveCenterBoxMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveCenterBoxMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveCenterBoxMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveCenterBoxMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveCenterBoxMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveCenterBoxMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveCenterBoxMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveCenterBoxMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveCenterBoxMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveCenterBoxMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveCenterBoxMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveCenterBoxMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveCenterBoxMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveCenterBoxMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveCenterBoxMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveCenterBoxMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCenterBoxMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveCenterBoxMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveCenterBoxMethod "setShrinkCenterLast" o = CenterBoxSetShrinkCenterLastMethodInfo
    ResolveCenterBoxMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveCenterBoxMethod "setStartWidget" o = CenterBoxSetStartWidgetMethodInfo
    ResolveCenterBoxMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveCenterBoxMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveCenterBoxMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveCenterBoxMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveCenterBoxMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveCenterBoxMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveCenterBoxMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveCenterBoxMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCenterBoxMethod t CenterBox, O.OverloadedMethod info CenterBox p) => OL.IsLabel t (CenterBox -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCenterBoxMethod t CenterBox, O.OverloadedMethod info CenterBox p, R.HasField t CenterBox p) => R.HasField t CenterBox p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCenterBoxMethod t CenterBox, O.OverloadedMethodInfo info CenterBox) => OL.IsLabel t (O.MethodProxy info CenterBox) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "baseline-position"
   -- Type: TInterface (Name {namespace = "Gtk", name = "BaselinePosition"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@baseline-position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' centerBox #baselinePosition
-- @
getCenterBoxBaselinePosition :: (MonadIO m, IsCenterBox o) => o -> m Gtk.Enums.BaselinePosition
getCenterBoxBaselinePosition obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "baseline-position"

-- | Set the value of the “@baseline-position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' centerBox [ #baselinePosition 'Data.GI.Base.Attributes.:=' value ]
-- @
setCenterBoxBaselinePosition :: (MonadIO m, IsCenterBox o) => o -> Gtk.Enums.BaselinePosition -> m ()
setCenterBoxBaselinePosition obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "baseline-position" val

-- | Construct a `GValueConstruct` with valid value for the “@baseline-position@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCenterBoxBaselinePosition :: (IsCenterBox o, MIO.MonadIO m) => Gtk.Enums.BaselinePosition -> m (GValueConstruct o)
constructCenterBoxBaselinePosition val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "baseline-position" val

#if defined(ENABLE_OVERLOADING)
data CenterBoxBaselinePositionPropertyInfo
instance AttrInfo CenterBoxBaselinePositionPropertyInfo where
    type AttrAllowedOps CenterBoxBaselinePositionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CenterBoxBaselinePositionPropertyInfo = IsCenterBox
    type AttrSetTypeConstraint CenterBoxBaselinePositionPropertyInfo = (~) Gtk.Enums.BaselinePosition
    type AttrTransferTypeConstraint CenterBoxBaselinePositionPropertyInfo = (~) Gtk.Enums.BaselinePosition
    type AttrTransferType CenterBoxBaselinePositionPropertyInfo = Gtk.Enums.BaselinePosition
    type AttrGetType CenterBoxBaselinePositionPropertyInfo = Gtk.Enums.BaselinePosition
    type AttrLabel CenterBoxBaselinePositionPropertyInfo = "baseline-position"
    type AttrOrigin CenterBoxBaselinePositionPropertyInfo = CenterBox
    attrGet = getCenterBoxBaselinePosition
    attrSet = setCenterBoxBaselinePosition
    attrTransfer _ v = do
        return v
    attrConstruct = constructCenterBoxBaselinePosition
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.baselinePosition"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#g:attr:baselinePosition"
        })
#endif

-- VVV Prop "center-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@center-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' centerBox #centerWidget
-- @
getCenterBoxCenterWidget :: (MonadIO m, IsCenterBox o) => o -> m (Maybe Gtk.Widget.Widget)
getCenterBoxCenterWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "center-widget" Gtk.Widget.Widget

-- | Set the value of the “@center-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' centerBox [ #centerWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setCenterBoxCenterWidget :: (MonadIO m, IsCenterBox o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setCenterBoxCenterWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "center-widget" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@center-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCenterBoxCenterWidget :: (IsCenterBox o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructCenterBoxCenterWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "center-widget" (P.Just val)

-- | Set the value of the “@center-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #centerWidget
-- @
clearCenterBoxCenterWidget :: (MonadIO m, IsCenterBox o) => o -> m ()
clearCenterBoxCenterWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "center-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data CenterBoxCenterWidgetPropertyInfo
instance AttrInfo CenterBoxCenterWidgetPropertyInfo where
    type AttrAllowedOps CenterBoxCenterWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CenterBoxCenterWidgetPropertyInfo = IsCenterBox
    type AttrSetTypeConstraint CenterBoxCenterWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint CenterBoxCenterWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType CenterBoxCenterWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType CenterBoxCenterWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel CenterBoxCenterWidgetPropertyInfo = "center-widget"
    type AttrOrigin CenterBoxCenterWidgetPropertyInfo = CenterBox
    attrGet = getCenterBoxCenterWidget
    attrSet = setCenterBoxCenterWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructCenterBoxCenterWidget
    attrClear = clearCenterBoxCenterWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#g:attr:centerWidget"
        })
#endif

-- VVV Prop "end-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@end-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' centerBox #endWidget
-- @
getCenterBoxEndWidget :: (MonadIO m, IsCenterBox o) => o -> m (Maybe Gtk.Widget.Widget)
getCenterBoxEndWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "end-widget" Gtk.Widget.Widget

-- | Set the value of the “@end-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' centerBox [ #endWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setCenterBoxEndWidget :: (MonadIO m, IsCenterBox o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setCenterBoxEndWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "end-widget" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@end-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCenterBoxEndWidget :: (IsCenterBox o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructCenterBoxEndWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "end-widget" (P.Just val)

-- | Set the value of the “@end-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #endWidget
-- @
clearCenterBoxEndWidget :: (MonadIO m, IsCenterBox o) => o -> m ()
clearCenterBoxEndWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "end-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data CenterBoxEndWidgetPropertyInfo
instance AttrInfo CenterBoxEndWidgetPropertyInfo where
    type AttrAllowedOps CenterBoxEndWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CenterBoxEndWidgetPropertyInfo = IsCenterBox
    type AttrSetTypeConstraint CenterBoxEndWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint CenterBoxEndWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType CenterBoxEndWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType CenterBoxEndWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel CenterBoxEndWidgetPropertyInfo = "end-widget"
    type AttrOrigin CenterBoxEndWidgetPropertyInfo = CenterBox
    attrGet = getCenterBoxEndWidget
    attrSet = setCenterBoxEndWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructCenterBoxEndWidget
    attrClear = clearCenterBoxEndWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.endWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#g:attr:endWidget"
        })
#endif

-- VVV Prop "shrink-center-last"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@shrink-center-last@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' centerBox #shrinkCenterLast
-- @
getCenterBoxShrinkCenterLast :: (MonadIO m, IsCenterBox o) => o -> m Bool
getCenterBoxShrinkCenterLast obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "shrink-center-last"

-- | Set the value of the “@shrink-center-last@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' centerBox [ #shrinkCenterLast 'Data.GI.Base.Attributes.:=' value ]
-- @
setCenterBoxShrinkCenterLast :: (MonadIO m, IsCenterBox o) => o -> Bool -> m ()
setCenterBoxShrinkCenterLast obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "shrink-center-last" val

-- | Construct a `GValueConstruct` with valid value for the “@shrink-center-last@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCenterBoxShrinkCenterLast :: (IsCenterBox o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCenterBoxShrinkCenterLast val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "shrink-center-last" val

#if defined(ENABLE_OVERLOADING)
data CenterBoxShrinkCenterLastPropertyInfo
instance AttrInfo CenterBoxShrinkCenterLastPropertyInfo where
    type AttrAllowedOps CenterBoxShrinkCenterLastPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CenterBoxShrinkCenterLastPropertyInfo = IsCenterBox
    type AttrSetTypeConstraint CenterBoxShrinkCenterLastPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CenterBoxShrinkCenterLastPropertyInfo = (~) Bool
    type AttrTransferType CenterBoxShrinkCenterLastPropertyInfo = Bool
    type AttrGetType CenterBoxShrinkCenterLastPropertyInfo = Bool
    type AttrLabel CenterBoxShrinkCenterLastPropertyInfo = "shrink-center-last"
    type AttrOrigin CenterBoxShrinkCenterLastPropertyInfo = CenterBox
    attrGet = getCenterBoxShrinkCenterLast
    attrSet = setCenterBoxShrinkCenterLast
    attrTransfer _ v = do
        return v
    attrConstruct = constructCenterBoxShrinkCenterLast
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.shrinkCenterLast"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#g:attr:shrinkCenterLast"
        })
#endif

-- VVV Prop "start-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@start-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' centerBox #startWidget
-- @
getCenterBoxStartWidget :: (MonadIO m, IsCenterBox o) => o -> m (Maybe Gtk.Widget.Widget)
getCenterBoxStartWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "start-widget" Gtk.Widget.Widget

-- | Set the value of the “@start-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' centerBox [ #startWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setCenterBoxStartWidget :: (MonadIO m, IsCenterBox o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setCenterBoxStartWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "start-widget" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@start-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCenterBoxStartWidget :: (IsCenterBox o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructCenterBoxStartWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "start-widget" (P.Just val)

-- | Set the value of the “@start-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #startWidget
-- @
clearCenterBoxStartWidget :: (MonadIO m, IsCenterBox o) => o -> m ()
clearCenterBoxStartWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "start-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data CenterBoxStartWidgetPropertyInfo
instance AttrInfo CenterBoxStartWidgetPropertyInfo where
    type AttrAllowedOps CenterBoxStartWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CenterBoxStartWidgetPropertyInfo = IsCenterBox
    type AttrSetTypeConstraint CenterBoxStartWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint CenterBoxStartWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType CenterBoxStartWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType CenterBoxStartWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel CenterBoxStartWidgetPropertyInfo = "start-widget"
    type AttrOrigin CenterBoxStartWidgetPropertyInfo = CenterBox
    attrGet = getCenterBoxStartWidget
    attrSet = setCenterBoxStartWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructCenterBoxStartWidget
    attrClear = clearCenterBoxStartWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.startWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#g:attr:startWidget"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CenterBox
type instance O.AttributeList CenterBox = CenterBoxAttributeList
type CenterBoxAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("baselinePosition", CenterBoxBaselinePositionPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("centerWidget", CenterBoxCenterWidgetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("endWidget", CenterBoxEndWidgetPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("shrinkCenterLast", CenterBoxShrinkCenterLastPropertyInfo), '("startWidget", CenterBoxStartWidgetPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
centerBoxBaselinePosition :: AttrLabelProxy "baselinePosition"
centerBoxBaselinePosition = AttrLabelProxy

centerBoxCenterWidget :: AttrLabelProxy "centerWidget"
centerBoxCenterWidget = AttrLabelProxy

centerBoxEndWidget :: AttrLabelProxy "endWidget"
centerBoxEndWidget = AttrLabelProxy

centerBoxShrinkCenterLast :: AttrLabelProxy "shrinkCenterLast"
centerBoxShrinkCenterLast = AttrLabelProxy

centerBoxStartWidget :: AttrLabelProxy "startWidget"
centerBoxStartWidget = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CenterBox = CenterBoxSignalList
type CenterBoxSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CenterBox::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "CenterBox" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_new" gtk_center_box_new :: 
    IO (Ptr CenterBox)

-- | Creates a new @GtkCenterBox@.
centerBoxNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m CenterBox
    -- ^ __Returns:__ the new @GtkCenterBox@
centerBoxNew  = liftIO $ do
    result <- gtk_center_box_new
    checkUnexpectedReturnNULL "centerBoxNew" result
    result' <- (newObject CenterBox) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CenterBox::get_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BaselinePosition" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_get_baseline_position" gtk_center_box_get_baseline_position :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    IO CUInt

-- | Gets the baseline position of the center box.
-- 
-- See 'GI.Gtk.Objects.CenterBox.centerBoxSetBaselinePosition'.
centerBoxGetBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a) =>
    a
    -- ^ /@self@/: a center box
    -> m Gtk.Enums.BaselinePosition
    -- ^ __Returns:__ the baseline position
centerBoxGetBaselinePosition self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_box_get_baseline_position self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CenterBoxGetBaselinePositionMethodInfo
instance (signature ~ (m Gtk.Enums.BaselinePosition), MonadIO m, IsCenterBox a) => O.OverloadedMethod CenterBoxGetBaselinePositionMethodInfo a signature where
    overloadedMethod = centerBoxGetBaselinePosition

instance O.OverloadedMethodInfo CenterBoxGetBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxGetBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxGetBaselinePosition"
        })


#endif

-- method CenterBox::get_center_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_get_center_widget" gtk_center_box_get_center_widget :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the center widget.
centerBoxGetCenterWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a) =>
    a
    -- ^ /@self@/: a center box
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the center widget
centerBoxGetCenterWidget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_box_get_center_widget self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CenterBoxGetCenterWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsCenterBox a) => O.OverloadedMethod CenterBoxGetCenterWidgetMethodInfo a signature where
    overloadedMethod = centerBoxGetCenterWidget

instance O.OverloadedMethodInfo CenterBoxGetCenterWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxGetCenterWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxGetCenterWidget"
        })


#endif

-- method CenterBox::get_end_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_get_end_widget" gtk_center_box_get_end_widget :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the end widget.
centerBoxGetEndWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a) =>
    a
    -- ^ /@self@/: a center box
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the end widget
centerBoxGetEndWidget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_box_get_end_widget self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CenterBoxGetEndWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsCenterBox a) => O.OverloadedMethod CenterBoxGetEndWidgetMethodInfo a signature where
    overloadedMethod = centerBoxGetEndWidget

instance O.OverloadedMethodInfo CenterBoxGetEndWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxGetEndWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxGetEndWidget"
        })


#endif

-- method CenterBox::get_shrink_center_last
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_get_shrink_center_last" gtk_center_box_get_shrink_center_last :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    IO CInt

-- | Gets whether the center widget shrinks after other children.
-- 
-- /Since: 4.12/
centerBoxGetShrinkCenterLast ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a) =>
    a
    -- ^ /@self@/: a center box
    -> m Bool
    -- ^ __Returns:__ whether to shrink the center widget after others
centerBoxGetShrinkCenterLast self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_box_get_shrink_center_last self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CenterBoxGetShrinkCenterLastMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCenterBox a) => O.OverloadedMethod CenterBoxGetShrinkCenterLastMethodInfo a signature where
    overloadedMethod = centerBoxGetShrinkCenterLast

instance O.OverloadedMethodInfo CenterBoxGetShrinkCenterLastMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxGetShrinkCenterLast",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxGetShrinkCenterLast"
        })


#endif

-- method CenterBox::get_start_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_get_start_widget" gtk_center_box_get_start_widget :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the start widget.
centerBoxGetStartWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a) =>
    a
    -- ^ /@self@/: a center box
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the start widget
centerBoxGetStartWidget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_box_get_start_widget self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CenterBoxGetStartWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsCenterBox a) => O.OverloadedMethod CenterBoxGetStartWidgetMethodInfo a signature where
    overloadedMethod = centerBoxGetStartWidget

instance O.OverloadedMethodInfo CenterBoxGetStartWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxGetStartWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxGetStartWidget"
        })


#endif

-- method CenterBox::set_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BaselinePosition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the baseline position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_set_baseline_position" gtk_center_box_set_baseline_position :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    CUInt ->                                -- position : TInterface (Name {namespace = "Gtk", name = "BaselinePosition"})
    IO ()

-- | Sets the baseline position of a center box.
-- 
-- This affects only horizontal boxes with at least one baseline
-- aligned child. If there is more vertical space available than
-- requested, and the baseline is not allocated by the parent then
-- /@position@/ is used to allocate the baseline with respect to the
-- extra space available.
centerBoxSetBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a) =>
    a
    -- ^ /@self@/: a center box
    -> Gtk.Enums.BaselinePosition
    -- ^ /@position@/: the baseline position
    -> m ()
centerBoxSetBaselinePosition self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let position' = (fromIntegral . fromEnum) position
    gtk_center_box_set_baseline_position self' position'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterBoxSetBaselinePositionMethodInfo
instance (signature ~ (Gtk.Enums.BaselinePosition -> m ()), MonadIO m, IsCenterBox a) => O.OverloadedMethod CenterBoxSetBaselinePositionMethodInfo a signature where
    overloadedMethod = centerBoxSetBaselinePosition

instance O.OverloadedMethodInfo CenterBoxSetBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxSetBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxSetBaselinePosition"
        })


#endif

-- method CenterBox::set_center_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new center widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_set_center_widget" gtk_center_box_set_center_widget :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the center widget.
-- 
-- To remove the existing center widget, pass @NULL@.
centerBoxSetCenterWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a center box
    -> Maybe (b)
    -- ^ /@child@/: the new center widget
    -> m ()
centerBoxSetCenterWidget self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_center_box_set_center_widget self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterBoxSetCenterWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCenterBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod CenterBoxSetCenterWidgetMethodInfo a signature where
    overloadedMethod = centerBoxSetCenterWidget

instance O.OverloadedMethodInfo CenterBoxSetCenterWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxSetCenterWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxSetCenterWidget"
        })


#endif

-- method CenterBox::set_end_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new end widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_set_end_widget" gtk_center_box_set_end_widget :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the end widget.
-- 
-- To remove the existing end widget, pass @NULL@.
centerBoxSetEndWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a center box
    -> Maybe (b)
    -- ^ /@child@/: the new end widget
    -> m ()
centerBoxSetEndWidget self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_center_box_set_end_widget self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterBoxSetEndWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCenterBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod CenterBoxSetEndWidgetMethodInfo a signature where
    overloadedMethod = centerBoxSetEndWidget

instance O.OverloadedMethodInfo CenterBoxSetEndWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxSetEndWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxSetEndWidget"
        })


#endif

-- method CenterBox::set_shrink_center_last
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cener box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shrink_center_last"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to shrink the center widget after others"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_set_shrink_center_last" gtk_center_box_set_shrink_center_last :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    CInt ->                                 -- shrink_center_last : TBasicType TBoolean
    IO ()

-- | Sets whether to shrink the center widget after other children.
-- 
-- By default, when there\'s no space to give all three children their
-- natural widths, the start and end widgets start shrinking and the
-- center child keeps natural width until they reach minimum width.
-- 
-- If /@shrinkCenterLast@/ is false, start and end widgets keep natural
-- width and the center widget starts shrinking instead.
-- 
-- /Since: 4.12/
centerBoxSetShrinkCenterLast ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a) =>
    a
    -- ^ /@self@/: a cener box
    -> Bool
    -- ^ /@shrinkCenterLast@/: whether to shrink the center widget after others
    -> m ()
centerBoxSetShrinkCenterLast self shrinkCenterLast = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let shrinkCenterLast' = (P.fromIntegral . P.fromEnum) shrinkCenterLast
    gtk_center_box_set_shrink_center_last self' shrinkCenterLast'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterBoxSetShrinkCenterLastMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCenterBox a) => O.OverloadedMethod CenterBoxSetShrinkCenterLastMethodInfo a signature where
    overloadedMethod = centerBoxSetShrinkCenterLast

instance O.OverloadedMethodInfo CenterBoxSetShrinkCenterLastMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxSetShrinkCenterLast",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxSetShrinkCenterLast"
        })


#endif

-- method CenterBox::set_start_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a center box" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new start widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_box_set_start_widget" gtk_center_box_set_start_widget :: 
    Ptr CenterBox ->                        -- self : TInterface (Name {namespace = "Gtk", name = "CenterBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the start widget.
-- 
-- To remove the existing start widget, pass @NULL@.
centerBoxSetStartWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a center box
    -> Maybe (b)
    -- ^ /@child@/: the new start widget
    -> m ()
centerBoxSetStartWidget self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_center_box_set_start_widget self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterBoxSetStartWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCenterBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod CenterBoxSetStartWidgetMethodInfo a signature where
    overloadedMethod = centerBoxSetStartWidget

instance O.OverloadedMethodInfo CenterBoxSetStartWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterBox.centerBoxSetStartWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-CenterBox.html#v:centerBoxSetStartWidget"
        })


#endif


