{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Invokes a callback.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CallbackAction
    ( 

-- * Exported types
    CallbackAction(..)                      ,
    IsCallbackAction                        ,
    toCallbackAction                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [activate]("GI.Gtk.Objects.ShortcutAction#g:method:activate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [print]("GI.Gtk.Objects.ShortcutAction#g:method:print"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gtk.Objects.ShortcutAction#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveCallbackActionMethod             ,
#endif

-- ** new #method:new#

    callbackActionNew                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction

#endif

-- | Memory-managed wrapper type.
newtype CallbackAction = CallbackAction (SP.ManagedPtr CallbackAction)
    deriving (Eq)

instance SP.ManagedPtrNewtype CallbackAction where
    toManagedPtr (CallbackAction p) = p

foreign import ccall "gtk_callback_action_get_type"
    c_gtk_callback_action_get_type :: IO B.Types.GType

instance B.Types.TypedObject CallbackAction where
    glibType = c_gtk_callback_action_get_type

instance B.Types.GObject CallbackAction

-- | Type class for types which can be safely cast to `CallbackAction`, for instance with `toCallbackAction`.
class (SP.GObject o, O.IsDescendantOf CallbackAction o) => IsCallbackAction o
instance (SP.GObject o, O.IsDescendantOf CallbackAction o) => IsCallbackAction o

instance O.HasParentTypes CallbackAction
type instance O.ParentTypes CallbackAction = '[Gtk.ShortcutAction.ShortcutAction, GObject.Object.Object]

-- | Cast to `CallbackAction`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toCallbackAction :: (MIO.MonadIO m, IsCallbackAction o) => o -> m CallbackAction
toCallbackAction = MIO.liftIO . B.ManagedPtr.unsafeCastTo CallbackAction

-- | Convert 'CallbackAction' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CallbackAction) where
    gvalueGType_ = c_gtk_callback_action_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CallbackAction)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CallbackAction)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CallbackAction ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCallbackActionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCallbackActionMethod "activate" o = Gtk.ShortcutAction.ShortcutActionActivateMethodInfo
    ResolveCallbackActionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCallbackActionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCallbackActionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCallbackActionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCallbackActionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCallbackActionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCallbackActionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCallbackActionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCallbackActionMethod "print" o = Gtk.ShortcutAction.ShortcutActionPrintMethodInfo
    ResolveCallbackActionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCallbackActionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCallbackActionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCallbackActionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCallbackActionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCallbackActionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCallbackActionMethod "toString" o = Gtk.ShortcutAction.ShortcutActionToStringMethodInfo
    ResolveCallbackActionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCallbackActionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCallbackActionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCallbackActionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCallbackActionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCallbackActionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCallbackActionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCallbackActionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCallbackActionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCallbackActionMethod t CallbackAction, O.OverloadedMethod info CallbackAction p) => OL.IsLabel t (CallbackAction -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCallbackActionMethod t CallbackAction, O.OverloadedMethod info CallbackAction p, R.HasField t CallbackAction p) => R.HasField t CallbackAction p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCallbackActionMethod t CallbackAction, O.OverloadedMethodInfo info CallbackAction) => OL.IsLabel t (O.MethodProxy info CallbackAction) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CallbackAction
type instance O.AttributeList CallbackAction = CallbackActionAttributeList
type CallbackActionAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CallbackAction = CallbackActionSignalList
type CallbackActionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CallbackAction::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the callback\n  to call when the action is activated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 2
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to be passed to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the function to be called when the callback action is finalized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "CallbackAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_callback_action_new" gtk_callback_action_new :: 
    FunPtr Gtk.Callbacks.C_ShortcutFunc ->  -- callback : TInterface (Name {namespace = "Gtk", name = "ShortcutFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr CallbackAction)

-- | Create a custom action that calls the given /@callback@/ when
-- activated.
callbackActionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gtk.Callbacks.ShortcutFunc
    -- ^ /@callback@/: the callback
    --   to call when the action is activated
    -> m CallbackAction
    -- ^ __Returns:__ A new shortcut action
callbackActionNew callback = liftIO $ do
    callback' <- Gtk.Callbacks.mk_ShortcutFunc (Gtk.Callbacks.wrap_ShortcutFunc Nothing (Gtk.Callbacks.drop_closures_ShortcutFunc callback))
    let data_ = castFunPtrToPtr callback'
    let destroy = SP.safeFreeFunPtrPtr
    result <- gtk_callback_action_new callback' data_ destroy
    checkUnexpectedReturnNULL "callbackActionNew" result
    result' <- (wrapObject CallbackAction) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


