{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkBuilderScope@ implementation for the C language.
-- 
-- @GtkBuilderCScope@ instances use symbols explicitly added to /@builder@/
-- with prior calls to 'GI.Gtk.Objects.BuilderCScope.builderCScopeAddCallbackSymbol'.
-- If developers want to do that, they are encouraged to create their
-- own scopes for that purpose.
-- 
-- In the case that symbols are not explicitly added; GTK will uses
-- @GModule@’s introspective features (by opening the module 'P.Nothing') to
-- look at the application’s symbol table. From here it tries to match
-- the signal function names given in the interface description with
-- symbols in the application.
-- 
-- Note that unless 'GI.Gtk.Objects.BuilderCScope.builderCScopeAddCallbackSymbol' is
-- called for all signal callbacks which are referenced by the loaded XML,
-- this functionality will require that @GModule@ be supported on the platform.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.BuilderCScope
    ( 

-- * Exported types
    BuilderCScope(..)                       ,
    IsBuilderCScope                         ,
    toBuilderCScope                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addCallbackSymbol]("GI.Gtk.Objects.BuilderCScope#g:method:addCallbackSymbol"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBuilderCScopeMethod              ,
#endif

-- ** addCallbackSymbol #method:addCallbackSymbol#

#if defined(ENABLE_OVERLOADING)
    BuilderCScopeAddCallbackSymbolMethodInfo,
#endif
    builderCScopeAddCallbackSymbol          ,


-- ** new #method:new#

    builderCScopeNew                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.BuilderScope as Gtk.BuilderScope

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.BuilderScope as Gtk.BuilderScope

#endif

-- | Memory-managed wrapper type.
newtype BuilderCScope = BuilderCScope (SP.ManagedPtr BuilderCScope)
    deriving (Eq)

instance SP.ManagedPtrNewtype BuilderCScope where
    toManagedPtr (BuilderCScope p) = p

foreign import ccall "gtk_builder_cscope_get_type"
    c_gtk_builder_cscope_get_type :: IO B.Types.GType

instance B.Types.TypedObject BuilderCScope where
    glibType = c_gtk_builder_cscope_get_type

instance B.Types.GObject BuilderCScope

-- | Type class for types which can be safely cast to `BuilderCScope`, for instance with `toBuilderCScope`.
class (SP.GObject o, O.IsDescendantOf BuilderCScope o) => IsBuilderCScope o
instance (SP.GObject o, O.IsDescendantOf BuilderCScope o) => IsBuilderCScope o

instance O.HasParentTypes BuilderCScope
type instance O.ParentTypes BuilderCScope = '[GObject.Object.Object, Gtk.BuilderScope.BuilderScope]

-- | Cast to `BuilderCScope`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toBuilderCScope :: (MIO.MonadIO m, IsBuilderCScope o) => o -> m BuilderCScope
toBuilderCScope = MIO.liftIO . B.ManagedPtr.unsafeCastTo BuilderCScope

-- | Convert 'BuilderCScope' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BuilderCScope) where
    gvalueGType_ = c_gtk_builder_cscope_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BuilderCScope)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BuilderCScope)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BuilderCScope ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBuilderCScopeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBuilderCScopeMethod "addCallbackSymbol" o = BuilderCScopeAddCallbackSymbolMethodInfo
    ResolveBuilderCScopeMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBuilderCScopeMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBuilderCScopeMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBuilderCScopeMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBuilderCScopeMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBuilderCScopeMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBuilderCScopeMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBuilderCScopeMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBuilderCScopeMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBuilderCScopeMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBuilderCScopeMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBuilderCScopeMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBuilderCScopeMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBuilderCScopeMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBuilderCScopeMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBuilderCScopeMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBuilderCScopeMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBuilderCScopeMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBuilderCScopeMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBuilderCScopeMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBuilderCScopeMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBuilderCScopeMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBuilderCScopeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBuilderCScopeMethod t BuilderCScope, O.OverloadedMethod info BuilderCScope p) => OL.IsLabel t (BuilderCScope -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBuilderCScopeMethod t BuilderCScope, O.OverloadedMethod info BuilderCScope p, R.HasField t BuilderCScope p) => R.HasField t BuilderCScope p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBuilderCScopeMethod t BuilderCScope, O.OverloadedMethodInfo info BuilderCScope) => OL.IsLabel t (O.MethodProxy info BuilderCScope) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BuilderCScope
type instance O.AttributeList BuilderCScope = BuilderCScopeAttributeList
type BuilderCScopeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BuilderCScope = BuilderCScopeSignalList
type BuilderCScopeSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BuilderCScope::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BuilderCScope" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_builder_cscope_new" gtk_builder_cscope_new :: 
    IO (Ptr BuilderCScope)

-- | Creates a new @GtkBuilderCScope@ object to use with future
-- @GtkBuilder@ instances.
-- 
-- Calling this function is only necessary if you want to add
-- custom callbacks via 'GI.Gtk.Objects.BuilderCScope.builderCScopeAddCallbackSymbol'.
builderCScopeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m BuilderCScope
    -- ^ __Returns:__ a new @GtkBuilderCScope@
builderCScopeNew  = liftIO $ do
    result <- gtk_builder_cscope_new
    checkUnexpectedReturnNULL "builderCScopeNew" result
    result' <- (wrapObject BuilderCScope) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BuilderCScope::add_callback_symbol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BuilderCScope" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBuilderCScope`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The name of the callback, as expected in the XML"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback_symbol"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Callback" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The callback pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_builder_cscope_add_callback_symbol" gtk_builder_cscope_add_callback_symbol :: 
    Ptr BuilderCScope ->                    -- self : TInterface (Name {namespace = "Gtk", name = "BuilderCScope"})
    CString ->                              -- callback_name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback_symbol : TInterface (Name {namespace = "GObject", name = "Callback"})
    IO ()

-- | Adds the /@callbackSymbol@/ to the scope of /@builder@/ under the
-- given /@callbackName@/.
-- 
-- Using this function overrides the behavior of
-- 'GI.Gtk.Objects.Builder.builderCreateClosure' for any callback symbols that
-- are added. Using this method allows for better encapsulation as it
-- does not require that callback symbols be declared in the global
-- namespace.
builderCScopeAddCallbackSymbol ::
    (B.CallStack.HasCallStack, MonadIO m, IsBuilderCScope a) =>
    a
    -- ^ /@self@/: a @GtkBuilderCScope@
    -> T.Text
    -- ^ /@callbackName@/: The name of the callback, as expected in the XML
    -> GObject.Callbacks.Callback
    -- ^ /@callbackSymbol@/: The callback pointer
    -> m ()
builderCScopeAddCallbackSymbol self callbackName callbackSymbol = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    callbackName' <- textToCString callbackName
    ptrcallbackSymbol <- callocMem :: IO (Ptr (FunPtr GObject.Callbacks.C_Callback))
    callbackSymbol' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback (Just ptrcallbackSymbol) callbackSymbol)
    poke ptrcallbackSymbol callbackSymbol'
    gtk_builder_cscope_add_callback_symbol self' callbackName' callbackSymbol'
    touchManagedPtr self
    freeMem callbackName'
    return ()

#if defined(ENABLE_OVERLOADING)
data BuilderCScopeAddCallbackSymbolMethodInfo
instance (signature ~ (T.Text -> GObject.Callbacks.Callback -> m ()), MonadIO m, IsBuilderCScope a) => O.OverloadedMethod BuilderCScopeAddCallbackSymbolMethodInfo a signature where
    overloadedMethod = builderCScopeAddCallbackSymbol

instance O.OverloadedMethodInfo BuilderCScopeAddCallbackSymbolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BuilderCScope.builderCScopeAddCallbackSymbol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BuilderCScope.html#v:builderCScopeAddCallbackSymbol"
        })


#endif


