{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Evaluates a boolean expression to determine whether to include items.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.BoolFilter
    ( 

-- * Exported types
    BoolFilter(..)                          ,
    IsBoolFilter                            ,
    toBoolFilter                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Filter#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [match]("GI.Gtk.Objects.Filter#g:method:match"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getExpression]("GI.Gtk.Objects.BoolFilter#g:method:getExpression"), [getInvert]("GI.Gtk.Objects.BoolFilter#g:method:getInvert"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStrictness]("GI.Gtk.Objects.Filter#g:method:getStrictness").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setExpression]("GI.Gtk.Objects.BoolFilter#g:method:setExpression"), [setInvert]("GI.Gtk.Objects.BoolFilter#g:method:setInvert"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBoolFilterMethod                 ,
#endif

-- ** getExpression #method:getExpression#

#if defined(ENABLE_OVERLOADING)
    BoolFilterGetExpressionMethodInfo       ,
#endif
    boolFilterGetExpression                 ,


-- ** getInvert #method:getInvert#

#if defined(ENABLE_OVERLOADING)
    BoolFilterGetInvertMethodInfo           ,
#endif
    boolFilterGetInvert                     ,


-- ** new #method:new#

    boolFilterNew                           ,


-- ** setExpression #method:setExpression#

#if defined(ENABLE_OVERLOADING)
    BoolFilterSetExpressionMethodInfo       ,
#endif
    boolFilterSetExpression                 ,


-- ** setInvert #method:setInvert#

#if defined(ENABLE_OVERLOADING)
    BoolFilterSetInvertMethodInfo           ,
#endif
    boolFilterSetInvert                     ,




 -- * Properties


-- ** expression #attr:expression#
-- | The boolean expression to evaluate on each item.

#if defined(ENABLE_OVERLOADING)
    BoolFilterExpressionPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    boolFilterExpression                    ,
#endif
    clearBoolFilterExpression               ,
    constructBoolFilterExpression           ,
    getBoolFilterExpression                 ,
    setBoolFilterExpression                 ,


-- ** invert #attr:invert#
-- | If the expression result should be inverted.

#if defined(ENABLE_OVERLOADING)
    BoolFilterInvertPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    boolFilterInvert                        ,
#endif
    constructBoolFilterInvert               ,
    getBoolFilterInvert                     ,
    setBoolFilterInvert                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter

#endif

-- | Memory-managed wrapper type.
newtype BoolFilter = BoolFilter (SP.ManagedPtr BoolFilter)
    deriving (Eq)

instance SP.ManagedPtrNewtype BoolFilter where
    toManagedPtr (BoolFilter p) = p

foreign import ccall "gtk_bool_filter_get_type"
    c_gtk_bool_filter_get_type :: IO B.Types.GType

instance B.Types.TypedObject BoolFilter where
    glibType = c_gtk_bool_filter_get_type

instance B.Types.GObject BoolFilter

-- | Type class for types which can be safely cast to `BoolFilter`, for instance with `toBoolFilter`.
class (SP.GObject o, O.IsDescendantOf BoolFilter o) => IsBoolFilter o
instance (SP.GObject o, O.IsDescendantOf BoolFilter o) => IsBoolFilter o

instance O.HasParentTypes BoolFilter
type instance O.ParentTypes BoolFilter = '[Gtk.Filter.Filter, GObject.Object.Object]

-- | Cast to `BoolFilter`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toBoolFilter :: (MIO.MonadIO m, IsBoolFilter o) => o -> m BoolFilter
toBoolFilter = MIO.liftIO . B.ManagedPtr.unsafeCastTo BoolFilter

-- | Convert 'BoolFilter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BoolFilter) where
    gvalueGType_ = c_gtk_bool_filter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BoolFilter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BoolFilter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BoolFilter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBoolFilterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBoolFilterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBoolFilterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBoolFilterMethod "changed" o = Gtk.Filter.FilterChangedMethodInfo
    ResolveBoolFilterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBoolFilterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBoolFilterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBoolFilterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBoolFilterMethod "match" o = Gtk.Filter.FilterMatchMethodInfo
    ResolveBoolFilterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBoolFilterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBoolFilterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBoolFilterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBoolFilterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBoolFilterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBoolFilterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBoolFilterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBoolFilterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBoolFilterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBoolFilterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBoolFilterMethod "getExpression" o = BoolFilterGetExpressionMethodInfo
    ResolveBoolFilterMethod "getInvert" o = BoolFilterGetInvertMethodInfo
    ResolveBoolFilterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBoolFilterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBoolFilterMethod "getStrictness" o = Gtk.Filter.FilterGetStrictnessMethodInfo
    ResolveBoolFilterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBoolFilterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBoolFilterMethod "setExpression" o = BoolFilterSetExpressionMethodInfo
    ResolveBoolFilterMethod "setInvert" o = BoolFilterSetInvertMethodInfo
    ResolveBoolFilterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBoolFilterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBoolFilterMethod t BoolFilter, O.OverloadedMethod info BoolFilter p) => OL.IsLabel t (BoolFilter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBoolFilterMethod t BoolFilter, O.OverloadedMethod info BoolFilter p, R.HasField t BoolFilter p) => R.HasField t BoolFilter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBoolFilterMethod t BoolFilter, O.OverloadedMethodInfo info BoolFilter) => OL.IsLabel t (O.MethodProxy info BoolFilter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "expression"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Expression"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' boolFilter #expression
-- @
getBoolFilterExpression :: (MonadIO m, IsBoolFilter o) => o -> m (Maybe Gtk.Expression.Expression)
getBoolFilterExpression obj = MIO.liftIO $ B.Properties.getObjectPropertyIsGValueInstance obj "expression"

-- | Set the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' boolFilter [ #expression 'Data.GI.Base.Attributes.:=' value ]
-- @
setBoolFilterExpression :: (MonadIO m, IsBoolFilter o, Gtk.Expression.IsExpression a) => o -> a -> m ()
setBoolFilterExpression obj val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Just val')

-- | Construct a `GValueConstruct` with valid value for the “@expression@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBoolFilterExpression :: (IsBoolFilter o, MIO.MonadIO m, Gtk.Expression.IsExpression a) => a -> m (GValueConstruct o)
constructBoolFilterExpression val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    MIO.liftIO $ B.Properties.constructObjectPropertyIsGValueInstance "expression" (P.Just val')

-- | Set the value of the “@expression@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #expression
-- @
clearBoolFilterExpression :: (MonadIO m, IsBoolFilter o) => o -> m ()
clearBoolFilterExpression obj = liftIO $ B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Nothing :: Maybe Gtk.Expression.Expression)

#if defined(ENABLE_OVERLOADING)
data BoolFilterExpressionPropertyInfo
instance AttrInfo BoolFilterExpressionPropertyInfo where
    type AttrAllowedOps BoolFilterExpressionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint BoolFilterExpressionPropertyInfo = IsBoolFilter
    type AttrSetTypeConstraint BoolFilterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferTypeConstraint BoolFilterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferType BoolFilterExpressionPropertyInfo = Gtk.Expression.Expression
    type AttrGetType BoolFilterExpressionPropertyInfo = (Maybe Gtk.Expression.Expression)
    type AttrLabel BoolFilterExpressionPropertyInfo = "expression"
    type AttrOrigin BoolFilterExpressionPropertyInfo = BoolFilter
    attrGet = getBoolFilterExpression
    attrSet = setBoolFilterExpression
    attrTransfer _ v = do
        return v
    attrConstruct = constructBoolFilterExpression
    attrClear = clearBoolFilterExpression
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoolFilter.expression"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BoolFilter.html#g:attr:expression"
        })
#endif

-- VVV Prop "invert"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@invert@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' boolFilter #invert
-- @
getBoolFilterInvert :: (MonadIO m, IsBoolFilter o) => o -> m Bool
getBoolFilterInvert obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "invert"

-- | Set the value of the “@invert@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' boolFilter [ #invert 'Data.GI.Base.Attributes.:=' value ]
-- @
setBoolFilterInvert :: (MonadIO m, IsBoolFilter o) => o -> Bool -> m ()
setBoolFilterInvert obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "invert" val

-- | Construct a `GValueConstruct` with valid value for the “@invert@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBoolFilterInvert :: (IsBoolFilter o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructBoolFilterInvert val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "invert" val

#if defined(ENABLE_OVERLOADING)
data BoolFilterInvertPropertyInfo
instance AttrInfo BoolFilterInvertPropertyInfo where
    type AttrAllowedOps BoolFilterInvertPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint BoolFilterInvertPropertyInfo = IsBoolFilter
    type AttrSetTypeConstraint BoolFilterInvertPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint BoolFilterInvertPropertyInfo = (~) Bool
    type AttrTransferType BoolFilterInvertPropertyInfo = Bool
    type AttrGetType BoolFilterInvertPropertyInfo = Bool
    type AttrLabel BoolFilterInvertPropertyInfo = "invert"
    type AttrOrigin BoolFilterInvertPropertyInfo = BoolFilter
    attrGet = getBoolFilterInvert
    attrSet = setBoolFilterInvert
    attrTransfer _ v = do
        return v
    attrConstruct = constructBoolFilterInvert
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoolFilter.invert"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BoolFilter.html#g:attr:invert"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BoolFilter
type instance O.AttributeList BoolFilter = BoolFilterAttributeList
type BoolFilterAttributeList = ('[ '("expression", BoolFilterExpressionPropertyInfo), '("invert", BoolFilterInvertPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
boolFilterExpression :: AttrLabelProxy "expression"
boolFilterExpression = AttrLabelProxy

boolFilterInvert :: AttrLabelProxy "invert"
boolFilterInvert = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BoolFilter = BoolFilterSignalList
type BoolFilterSignalList = ('[ '("changed", Gtk.Filter.FilterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BoolFilter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expression to evaluate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "BoolFilter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bool_filter_new" gtk_bool_filter_new :: 
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO (Ptr BoolFilter)

-- | Creates a new bool filter.
boolFilterNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Expression.IsExpression a) =>
    Maybe (a)
    -- ^ /@expression@/: the expression to evaluate
    -> m BoolFilter
    -- ^ __Returns:__ a new @GtkBoolFilter@
boolFilterNew expression = liftIO $ do
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- B.ManagedPtr.disownManagedPtr jExpression
            return jExpression'
    result <- gtk_bool_filter_new maybeExpression
    checkUnexpectedReturnNULL "boolFilterNew" result
    result' <- (wrapObject BoolFilter) result
    whenJust expression touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BoolFilter::get_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoolFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bool filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bool_filter_get_expression" gtk_bool_filter_get_expression :: 
    Ptr BoolFilter ->                       -- self : TInterface (Name {namespace = "Gtk", name = "BoolFilter"})
    IO (Ptr Gtk.Expression.Expression)

-- | Gets the expression that the filter evaluates for
-- each item.
boolFilterGetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoolFilter a) =>
    a
    -- ^ /@self@/: a bool filter
    -> m (Maybe Gtk.Expression.Expression)
    -- ^ __Returns:__ the expression
boolFilterGetExpression self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_bool_filter_get_expression self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gtk.Expression.Expression) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data BoolFilterGetExpressionMethodInfo
instance (signature ~ (m (Maybe Gtk.Expression.Expression)), MonadIO m, IsBoolFilter a) => O.OverloadedMethod BoolFilterGetExpressionMethodInfo a signature where
    overloadedMethod = boolFilterGetExpression

instance O.OverloadedMethodInfo BoolFilterGetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoolFilter.boolFilterGetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BoolFilter.html#v:boolFilterGetExpression"
        })


#endif

-- method BoolFilter::get_invert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoolFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bool filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bool_filter_get_invert" gtk_bool_filter_get_invert :: 
    Ptr BoolFilter ->                       -- self : TInterface (Name {namespace = "Gtk", name = "BoolFilter"})
    IO CInt

-- | Returns whether the filter inverts the expression.
boolFilterGetInvert ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoolFilter a) =>
    a
    -- ^ /@self@/: a bool filter
    -> m Bool
    -- ^ __Returns:__ true if the filter inverts
boolFilterGetInvert self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_bool_filter_get_invert self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data BoolFilterGetInvertMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsBoolFilter a) => O.OverloadedMethod BoolFilterGetInvertMethodInfo a signature where
    overloadedMethod = boolFilterGetInvert

instance O.OverloadedMethodInfo BoolFilterGetInvertMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoolFilter.boolFilterGetInvert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BoolFilter.html#v:boolFilterGetInvert"
        })


#endif

-- method BoolFilter::set_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoolFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bool filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expression" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bool_filter_set_expression" gtk_bool_filter_set_expression :: 
    Ptr BoolFilter ->                       -- self : TInterface (Name {namespace = "Gtk", name = "BoolFilter"})
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO ()

-- | Sets the expression that the filter uses to check if items
-- should be filtered.
-- 
-- The expression must have a value type of @G_TYPE_BOOLEAN@.
boolFilterSetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoolFilter a, Gtk.Expression.IsExpression b) =>
    a
    -- ^ /@self@/: a bool filter
    -> Maybe (b)
    -- ^ /@expression@/: the expression
    -> m ()
boolFilterSetExpression self expression = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- unsafeManagedPtrCastPtr jExpression
            return jExpression'
    gtk_bool_filter_set_expression self' maybeExpression
    touchManagedPtr self
    whenJust expression touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data BoolFilterSetExpressionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsBoolFilter a, Gtk.Expression.IsExpression b) => O.OverloadedMethod BoolFilterSetExpressionMethodInfo a signature where
    overloadedMethod = boolFilterSetExpression

instance O.OverloadedMethodInfo BoolFilterSetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoolFilter.boolFilterSetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BoolFilter.html#v:boolFilterSetExpression"
        })


#endif

-- method BoolFilter::set_invert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BoolFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bool filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invert"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to invert" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bool_filter_set_invert" gtk_bool_filter_set_invert :: 
    Ptr BoolFilter ->                       -- self : TInterface (Name {namespace = "Gtk", name = "BoolFilter"})
    CInt ->                                 -- invert : TBasicType TBoolean
    IO ()

-- | Sets whether the filter should invert the expression.
boolFilterSetInvert ::
    (B.CallStack.HasCallStack, MonadIO m, IsBoolFilter a) =>
    a
    -- ^ /@self@/: a bool filter
    -> Bool
    -- ^ /@invert@/: true to invert
    -> m ()
boolFilterSetInvert self invert = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let invert' = (P.fromIntegral . P.fromEnum) invert
    gtk_bool_filter_set_invert self' invert'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data BoolFilterSetInvertMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsBoolFilter a) => O.OverloadedMethod BoolFilterSetInvertMethodInfo a signature where
    overloadedMethod = boolFilterSetInvert

instance O.OverloadedMethodInfo BoolFilterSetInvertMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BoolFilter.boolFilterSetInvert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BoolFilter.html#v:boolFilterSetInvert"
        })


#endif


