{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A list model that wraps @GBookmarkFile@.
-- 
-- It presents a @GListModel@ and fills it asynchronously with the
-- @GFileInfo@s returned from that function.
-- 
-- The @GFileInfo@s in the list have some attributes in the recent
-- namespace added: @recent::private@ (boolean) and @recent:applications@
-- (stringv).

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.BookmarkList
    ( 

-- * Exported types
    BookmarkList(..)                        ,
    IsBookmarkList                          ,
    toBookmarkList                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isLoading]("GI.Gtk.Objects.BookmarkList#g:method:isLoading"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAttributes]("GI.Gtk.Objects.BookmarkList#g:method:getAttributes"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFilename]("GI.Gtk.Objects.BookmarkList#g:method:getFilename"), [getIoPriority]("GI.Gtk.Objects.BookmarkList#g:method:getIoPriority"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setAttributes]("GI.Gtk.Objects.BookmarkList#g:method:setAttributes"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setIoPriority]("GI.Gtk.Objects.BookmarkList#g:method:setIoPriority"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBookmarkListMethod               ,
#endif

-- ** getAttributes #method:getAttributes#

#if defined(ENABLE_OVERLOADING)
    BookmarkListGetAttributesMethodInfo     ,
#endif
    bookmarkListGetAttributes               ,


-- ** getFilename #method:getFilename#

#if defined(ENABLE_OVERLOADING)
    BookmarkListGetFilenameMethodInfo       ,
#endif
    bookmarkListGetFilename                 ,


-- ** getIoPriority #method:getIoPriority#

#if defined(ENABLE_OVERLOADING)
    BookmarkListGetIoPriorityMethodInfo     ,
#endif
    bookmarkListGetIoPriority               ,


-- ** isLoading #method:isLoading#

#if defined(ENABLE_OVERLOADING)
    BookmarkListIsLoadingMethodInfo         ,
#endif
    bookmarkListIsLoading                   ,


-- ** new #method:new#

    bookmarkListNew                         ,


-- ** setAttributes #method:setAttributes#

#if defined(ENABLE_OVERLOADING)
    BookmarkListSetAttributesMethodInfo     ,
#endif
    bookmarkListSetAttributes               ,


-- ** setIoPriority #method:setIoPriority#

#if defined(ENABLE_OVERLOADING)
    BookmarkListSetIoPriorityMethodInfo     ,
#endif
    bookmarkListSetIoPriority               ,




 -- * Properties


-- ** attributes #attr:attributes#
-- | The attributes to query.

#if defined(ENABLE_OVERLOADING)
    BookmarkListAttributesPropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    bookmarkListAttributes                  ,
#endif
    clearBookmarkListAttributes             ,
    constructBookmarkListAttributes         ,
    getBookmarkListAttributes               ,
    setBookmarkListAttributes               ,


-- ** filename #attr:filename#
-- | The bookmark file to load.

#if defined(ENABLE_OVERLOADING)
    BookmarkListFilenamePropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    bookmarkListFilename                    ,
#endif
    constructBookmarkListFilename           ,
    getBookmarkListFilename                 ,


-- ** ioPriority #attr:ioPriority#
-- | Priority used when loading.

#if defined(ENABLE_OVERLOADING)
    BookmarkListIoPriorityPropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    bookmarkListIoPriority                  ,
#endif
    constructBookmarkListIoPriority         ,
    getBookmarkListIoPriority               ,
    setBookmarkListIoPriority               ,


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    BookmarkListItemTypePropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    bookmarkListItemType                    ,
#endif
    getBookmarkListItemType                 ,


-- ** loading #attr:loading#
-- | 'P.True' if files are being loaded.

#if defined(ENABLE_OVERLOADING)
    BookmarkListLoadingPropertyInfo         ,
#endif
#if defined(ENABLE_OVERLOADING)
    bookmarkListLoading                     ,
#endif
    getBookmarkListLoading                  ,


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    BookmarkListNItemsPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    bookmarkListNItems                      ,
#endif
    getBookmarkListNItems                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel

#endif

-- | Memory-managed wrapper type.
newtype BookmarkList = BookmarkList (SP.ManagedPtr BookmarkList)
    deriving (Eq)

instance SP.ManagedPtrNewtype BookmarkList where
    toManagedPtr (BookmarkList p) = p

foreign import ccall "gtk_bookmark_list_get_type"
    c_gtk_bookmark_list_get_type :: IO B.Types.GType

instance B.Types.TypedObject BookmarkList where
    glibType = c_gtk_bookmark_list_get_type

instance B.Types.GObject BookmarkList

-- | Type class for types which can be safely cast to `BookmarkList`, for instance with `toBookmarkList`.
class (SP.GObject o, O.IsDescendantOf BookmarkList o) => IsBookmarkList o
instance (SP.GObject o, O.IsDescendantOf BookmarkList o) => IsBookmarkList o

instance O.HasParentTypes BookmarkList
type instance O.ParentTypes BookmarkList = '[GObject.Object.Object, Gio.ListModel.ListModel]

-- | Cast to `BookmarkList`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toBookmarkList :: (MIO.MonadIO m, IsBookmarkList o) => o -> m BookmarkList
toBookmarkList = MIO.liftIO . B.ManagedPtr.unsafeCastTo BookmarkList

-- | Convert 'BookmarkList' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BookmarkList) where
    gvalueGType_ = c_gtk_bookmark_list_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BookmarkList)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BookmarkList)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BookmarkList ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBookmarkListMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBookmarkListMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBookmarkListMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBookmarkListMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBookmarkListMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBookmarkListMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBookmarkListMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBookmarkListMethod "isLoading" o = BookmarkListIsLoadingMethodInfo
    ResolveBookmarkListMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveBookmarkListMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBookmarkListMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBookmarkListMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBookmarkListMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBookmarkListMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBookmarkListMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBookmarkListMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBookmarkListMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBookmarkListMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBookmarkListMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBookmarkListMethod "getAttributes" o = BookmarkListGetAttributesMethodInfo
    ResolveBookmarkListMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBookmarkListMethod "getFilename" o = BookmarkListGetFilenameMethodInfo
    ResolveBookmarkListMethod "getIoPriority" o = BookmarkListGetIoPriorityMethodInfo
    ResolveBookmarkListMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveBookmarkListMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveBookmarkListMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveBookmarkListMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBookmarkListMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBookmarkListMethod "setAttributes" o = BookmarkListSetAttributesMethodInfo
    ResolveBookmarkListMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBookmarkListMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBookmarkListMethod "setIoPriority" o = BookmarkListSetIoPriorityMethodInfo
    ResolveBookmarkListMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBookmarkListMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBookmarkListMethod t BookmarkList, O.OverloadedMethod info BookmarkList p) => OL.IsLabel t (BookmarkList -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBookmarkListMethod t BookmarkList, O.OverloadedMethod info BookmarkList p, R.HasField t BookmarkList p) => R.HasField t BookmarkList p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBookmarkListMethod t BookmarkList, O.OverloadedMethodInfo info BookmarkList) => OL.IsLabel t (O.MethodProxy info BookmarkList) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "attributes"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@attributes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bookmarkList #attributes
-- @
getBookmarkListAttributes :: (MonadIO m, IsBookmarkList o) => o -> m (Maybe T.Text)
getBookmarkListAttributes obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "attributes"

-- | Set the value of the “@attributes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' bookmarkList [ #attributes 'Data.GI.Base.Attributes.:=' value ]
-- @
setBookmarkListAttributes :: (MonadIO m, IsBookmarkList o) => o -> T.Text -> m ()
setBookmarkListAttributes obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "attributes" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@attributes@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBookmarkListAttributes :: (IsBookmarkList o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructBookmarkListAttributes val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "attributes" (P.Just val)

-- | Set the value of the “@attributes@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #attributes
-- @
clearBookmarkListAttributes :: (MonadIO m, IsBookmarkList o) => o -> m ()
clearBookmarkListAttributes obj = liftIO $ B.Properties.setObjectPropertyString obj "attributes" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data BookmarkListAttributesPropertyInfo
instance AttrInfo BookmarkListAttributesPropertyInfo where
    type AttrAllowedOps BookmarkListAttributesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint BookmarkListAttributesPropertyInfo = IsBookmarkList
    type AttrSetTypeConstraint BookmarkListAttributesPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint BookmarkListAttributesPropertyInfo = (~) T.Text
    type AttrTransferType BookmarkListAttributesPropertyInfo = T.Text
    type AttrGetType BookmarkListAttributesPropertyInfo = (Maybe T.Text)
    type AttrLabel BookmarkListAttributesPropertyInfo = "attributes"
    type AttrOrigin BookmarkListAttributesPropertyInfo = BookmarkList
    attrGet = getBookmarkListAttributes
    attrSet = setBookmarkListAttributes
    attrTransfer _ v = do
        return v
    attrConstruct = constructBookmarkListAttributes
    attrClear = clearBookmarkListAttributes
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.attributes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#g:attr:attributes"
        })
#endif

-- VVV Prop "filename"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@filename@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bookmarkList #filename
-- @
getBookmarkListFilename :: (MonadIO m, IsBookmarkList o) => o -> m (Maybe T.Text)
getBookmarkListFilename obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "filename"

-- | Construct a `GValueConstruct` with valid value for the “@filename@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBookmarkListFilename :: (IsBookmarkList o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructBookmarkListFilename val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "filename" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data BookmarkListFilenamePropertyInfo
instance AttrInfo BookmarkListFilenamePropertyInfo where
    type AttrAllowedOps BookmarkListFilenamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint BookmarkListFilenamePropertyInfo = IsBookmarkList
    type AttrSetTypeConstraint BookmarkListFilenamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint BookmarkListFilenamePropertyInfo = (~) T.Text
    type AttrTransferType BookmarkListFilenamePropertyInfo = T.Text
    type AttrGetType BookmarkListFilenamePropertyInfo = (Maybe T.Text)
    type AttrLabel BookmarkListFilenamePropertyInfo = "filename"
    type AttrOrigin BookmarkListFilenamePropertyInfo = BookmarkList
    attrGet = getBookmarkListFilename
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructBookmarkListFilename
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.filename"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#g:attr:filename"
        })
#endif

-- VVV Prop "io-priority"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@io-priority@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bookmarkList #ioPriority
-- @
getBookmarkListIoPriority :: (MonadIO m, IsBookmarkList o) => o -> m Int32
getBookmarkListIoPriority obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "io-priority"

-- | Set the value of the “@io-priority@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' bookmarkList [ #ioPriority 'Data.GI.Base.Attributes.:=' value ]
-- @
setBookmarkListIoPriority :: (MonadIO m, IsBookmarkList o) => o -> Int32 -> m ()
setBookmarkListIoPriority obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "io-priority" val

-- | Construct a `GValueConstruct` with valid value for the “@io-priority@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBookmarkListIoPriority :: (IsBookmarkList o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructBookmarkListIoPriority val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "io-priority" val

#if defined(ENABLE_OVERLOADING)
data BookmarkListIoPriorityPropertyInfo
instance AttrInfo BookmarkListIoPriorityPropertyInfo where
    type AttrAllowedOps BookmarkListIoPriorityPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint BookmarkListIoPriorityPropertyInfo = IsBookmarkList
    type AttrSetTypeConstraint BookmarkListIoPriorityPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint BookmarkListIoPriorityPropertyInfo = (~) Int32
    type AttrTransferType BookmarkListIoPriorityPropertyInfo = Int32
    type AttrGetType BookmarkListIoPriorityPropertyInfo = Int32
    type AttrLabel BookmarkListIoPriorityPropertyInfo = "io-priority"
    type AttrOrigin BookmarkListIoPriorityPropertyInfo = BookmarkList
    attrGet = getBookmarkListIoPriority
    attrSet = setBookmarkListIoPriority
    attrTransfer _ v = do
        return v
    attrConstruct = constructBookmarkListIoPriority
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.ioPriority"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#g:attr:ioPriority"
        })
#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bookmarkList #itemType
-- @
getBookmarkListItemType :: (MonadIO m, IsBookmarkList o) => o -> m GType
getBookmarkListItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data BookmarkListItemTypePropertyInfo
instance AttrInfo BookmarkListItemTypePropertyInfo where
    type AttrAllowedOps BookmarkListItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint BookmarkListItemTypePropertyInfo = IsBookmarkList
    type AttrSetTypeConstraint BookmarkListItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint BookmarkListItemTypePropertyInfo = (~) ()
    type AttrTransferType BookmarkListItemTypePropertyInfo = ()
    type AttrGetType BookmarkListItemTypePropertyInfo = GType
    type AttrLabel BookmarkListItemTypePropertyInfo = "item-type"
    type AttrOrigin BookmarkListItemTypePropertyInfo = BookmarkList
    attrGet = getBookmarkListItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#g:attr:itemType"
        })
#endif

-- VVV Prop "loading"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@loading@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bookmarkList #loading
-- @
getBookmarkListLoading :: (MonadIO m, IsBookmarkList o) => o -> m Bool
getBookmarkListLoading obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "loading"

#if defined(ENABLE_OVERLOADING)
data BookmarkListLoadingPropertyInfo
instance AttrInfo BookmarkListLoadingPropertyInfo where
    type AttrAllowedOps BookmarkListLoadingPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint BookmarkListLoadingPropertyInfo = IsBookmarkList
    type AttrSetTypeConstraint BookmarkListLoadingPropertyInfo = (~) ()
    type AttrTransferTypeConstraint BookmarkListLoadingPropertyInfo = (~) ()
    type AttrTransferType BookmarkListLoadingPropertyInfo = ()
    type AttrGetType BookmarkListLoadingPropertyInfo = Bool
    type AttrLabel BookmarkListLoadingPropertyInfo = "loading"
    type AttrOrigin BookmarkListLoadingPropertyInfo = BookmarkList
    attrGet = getBookmarkListLoading
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.loading"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#g:attr:loading"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bookmarkList #nItems
-- @
getBookmarkListNItems :: (MonadIO m, IsBookmarkList o) => o -> m Word32
getBookmarkListNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data BookmarkListNItemsPropertyInfo
instance AttrInfo BookmarkListNItemsPropertyInfo where
    type AttrAllowedOps BookmarkListNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint BookmarkListNItemsPropertyInfo = IsBookmarkList
    type AttrSetTypeConstraint BookmarkListNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint BookmarkListNItemsPropertyInfo = (~) ()
    type AttrTransferType BookmarkListNItemsPropertyInfo = ()
    type AttrGetType BookmarkListNItemsPropertyInfo = Word32
    type AttrLabel BookmarkListNItemsPropertyInfo = "n-items"
    type AttrOrigin BookmarkListNItemsPropertyInfo = BookmarkList
    attrGet = getBookmarkListNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BookmarkList
type instance O.AttributeList BookmarkList = BookmarkListAttributeList
type BookmarkListAttributeList = ('[ '("attributes", BookmarkListAttributesPropertyInfo), '("filename", BookmarkListFilenamePropertyInfo), '("ioPriority", BookmarkListIoPriorityPropertyInfo), '("itemType", BookmarkListItemTypePropertyInfo), '("loading", BookmarkListLoadingPropertyInfo), '("nItems", BookmarkListNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
bookmarkListAttributes :: AttrLabelProxy "attributes"
bookmarkListAttributes = AttrLabelProxy

bookmarkListFilename :: AttrLabelProxy "filename"
bookmarkListFilename = AttrLabelProxy

bookmarkListIoPriority :: AttrLabelProxy "ioPriority"
bookmarkListIoPriority = AttrLabelProxy

bookmarkListItemType :: AttrLabelProxy "itemType"
bookmarkListItemType = AttrLabelProxy

bookmarkListLoading :: AttrLabelProxy "loading"
bookmarkListLoading = AttrLabelProxy

bookmarkListNItems :: AttrLabelProxy "nItems"
bookmarkListNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BookmarkList = BookmarkListSignalList
type BookmarkListSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BookmarkList::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The bookmark file to load"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attributes"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The attributes to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BookmarkList" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bookmark_list_new" gtk_bookmark_list_new :: 
    CString ->                              -- filename : TBasicType TFileName
    CString ->                              -- attributes : TBasicType TUTF8
    IO (Ptr BookmarkList)

-- | Creates a new @GtkBookmarkList@ with the given /@attributes@/.
bookmarkListNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@filename@/: The bookmark file to load
    -> Maybe (T.Text)
    -- ^ /@attributes@/: The attributes to query
    -> m BookmarkList
    -- ^ __Returns:__ a new @GtkBookmarkList@
bookmarkListNew filename attributes = liftIO $ do
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    maybeAttributes <- case attributes of
        Nothing -> return FP.nullPtr
        Just jAttributes -> do
            jAttributes' <- textToCString jAttributes
            return jAttributes'
    result <- gtk_bookmark_list_new maybeFilename maybeAttributes
    checkUnexpectedReturnNULL "bookmarkListNew" result
    result' <- (wrapObject BookmarkList) result
    freeMem maybeFilename
    freeMem maybeAttributes
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BookmarkList::get_attributes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BookmarkList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBookmarkList`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bookmark_list_get_attributes" gtk_bookmark_list_get_attributes :: 
    Ptr BookmarkList ->                     -- self : TInterface (Name {namespace = "Gtk", name = "BookmarkList"})
    IO CString

-- | Gets the attributes queried on the children.
bookmarkListGetAttributes ::
    (B.CallStack.HasCallStack, MonadIO m, IsBookmarkList a) =>
    a
    -- ^ /@self@/: a @GtkBookmarkList@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The queried attributes
bookmarkListGetAttributes self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_bookmark_list_get_attributes self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data BookmarkListGetAttributesMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsBookmarkList a) => O.OverloadedMethod BookmarkListGetAttributesMethodInfo a signature where
    overloadedMethod = bookmarkListGetAttributes

instance O.OverloadedMethodInfo BookmarkListGetAttributesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.bookmarkListGetAttributes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#v:bookmarkListGetAttributes"
        })


#endif

-- method BookmarkList::get_filename
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BookmarkList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBookmarkList`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bookmark_list_get_filename" gtk_bookmark_list_get_filename :: 
    Ptr BookmarkList ->                     -- self : TInterface (Name {namespace = "Gtk", name = "BookmarkList"})
    IO CString

-- | Returns the filename of the bookmark file that
-- this list is loading.
bookmarkListGetFilename ::
    (B.CallStack.HasCallStack, MonadIO m, IsBookmarkList a) =>
    a
    -- ^ /@self@/: a @GtkBookmarkList@
    -> m [Char]
    -- ^ __Returns:__ the filename of the .xbel file
bookmarkListGetFilename self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_bookmark_list_get_filename self'
    checkUnexpectedReturnNULL "bookmarkListGetFilename" result
    result' <- cstringToString result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data BookmarkListGetFilenameMethodInfo
instance (signature ~ (m [Char]), MonadIO m, IsBookmarkList a) => O.OverloadedMethod BookmarkListGetFilenameMethodInfo a signature where
    overloadedMethod = bookmarkListGetFilename

instance O.OverloadedMethodInfo BookmarkListGetFilenameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.bookmarkListGetFilename",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#v:bookmarkListGetFilename"
        })


#endif

-- method BookmarkList::get_io_priority
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BookmarkList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBookmarkList`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bookmark_list_get_io_priority" gtk_bookmark_list_get_io_priority :: 
    Ptr BookmarkList ->                     -- self : TInterface (Name {namespace = "Gtk", name = "BookmarkList"})
    IO Int32

-- | Gets the IO priority to use while loading file.
bookmarkListGetIoPriority ::
    (B.CallStack.HasCallStack, MonadIO m, IsBookmarkList a) =>
    a
    -- ^ /@self@/: a @GtkBookmarkList@
    -> m Int32
    -- ^ __Returns:__ The IO priority.
bookmarkListGetIoPriority self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_bookmark_list_get_io_priority self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data BookmarkListGetIoPriorityMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsBookmarkList a) => O.OverloadedMethod BookmarkListGetIoPriorityMethodInfo a signature where
    overloadedMethod = bookmarkListGetIoPriority

instance O.OverloadedMethodInfo BookmarkListGetIoPriorityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.bookmarkListGetIoPriority",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#v:bookmarkListGetIoPriority"
        })


#endif

-- method BookmarkList::is_loading
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BookmarkList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBookmarkList`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bookmark_list_is_loading" gtk_bookmark_list_is_loading :: 
    Ptr BookmarkList ->                     -- self : TInterface (Name {namespace = "Gtk", name = "BookmarkList"})
    IO CInt

-- | Returns 'P.True' if the files are currently being loaded.
-- 
-- Files will be added to /@self@/ from time to time while loading is
-- going on. The order in which are added is undefined and may change
-- in between runs.
bookmarkListIsLoading ::
    (B.CallStack.HasCallStack, MonadIO m, IsBookmarkList a) =>
    a
    -- ^ /@self@/: a @GtkBookmarkList@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@self@/ is loading
bookmarkListIsLoading self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_bookmark_list_is_loading self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data BookmarkListIsLoadingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsBookmarkList a) => O.OverloadedMethod BookmarkListIsLoadingMethodInfo a signature where
    overloadedMethod = bookmarkListIsLoading

instance O.OverloadedMethodInfo BookmarkListIsLoadingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.bookmarkListIsLoading",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#v:bookmarkListIsLoading"
        })


#endif

-- method BookmarkList::set_attributes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BookmarkList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBookmarkList`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attributes"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the attributes to enumerate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bookmark_list_set_attributes" gtk_bookmark_list_set_attributes :: 
    Ptr BookmarkList ->                     -- self : TInterface (Name {namespace = "Gtk", name = "BookmarkList"})
    CString ->                              -- attributes : TBasicType TUTF8
    IO ()

-- | Sets the /@attributes@/ to be enumerated and starts the enumeration.
-- 
-- If /@attributes@/ is 'P.Nothing', no attributes will be queried, but a list
-- of @GFileInfo@s will still be created.
bookmarkListSetAttributes ::
    (B.CallStack.HasCallStack, MonadIO m, IsBookmarkList a) =>
    a
    -- ^ /@self@/: a @GtkBookmarkList@
    -> Maybe (T.Text)
    -- ^ /@attributes@/: the attributes to enumerate
    -> m ()
bookmarkListSetAttributes self attributes = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeAttributes <- case attributes of
        Nothing -> return FP.nullPtr
        Just jAttributes -> do
            jAttributes' <- textToCString jAttributes
            return jAttributes'
    gtk_bookmark_list_set_attributes self' maybeAttributes
    touchManagedPtr self
    freeMem maybeAttributes
    return ()

#if defined(ENABLE_OVERLOADING)
data BookmarkListSetAttributesMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsBookmarkList a) => O.OverloadedMethod BookmarkListSetAttributesMethodInfo a signature where
    overloadedMethod = bookmarkListSetAttributes

instance O.OverloadedMethodInfo BookmarkListSetAttributesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.bookmarkListSetAttributes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#v:bookmarkListSetAttributes"
        })


#endif

-- method BookmarkList::set_io_priority
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BookmarkList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBookmarkList`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "IO priority to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_bookmark_list_set_io_priority" gtk_bookmark_list_set_io_priority :: 
    Ptr BookmarkList ->                     -- self : TInterface (Name {namespace = "Gtk", name = "BookmarkList"})
    Int32 ->                                -- io_priority : TBasicType TInt
    IO ()

-- | Sets the IO priority to use while loading files.
-- 
-- The default IO priority is 'GI.GLib.Constants.PRIORITY_DEFAULT'.
bookmarkListSetIoPriority ::
    (B.CallStack.HasCallStack, MonadIO m, IsBookmarkList a) =>
    a
    -- ^ /@self@/: a @GtkBookmarkList@
    -> Int32
    -- ^ /@ioPriority@/: IO priority to use
    -> m ()
bookmarkListSetIoPriority self ioPriority = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_bookmark_list_set_io_priority self' ioPriority
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data BookmarkListSetIoPriorityMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsBookmarkList a) => O.OverloadedMethod BookmarkListSetIoPriorityMethodInfo a signature where
    overloadedMethod = bookmarkListSetIoPriority

instance O.OverloadedMethodInfo BookmarkListSetIoPriorityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BookmarkList.bookmarkListSetIoPriority",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-BookmarkList.html#v:bookmarkListSetIoPriority"
        })


#endif


