{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Matches an item when at least one of its filters matches.
-- 
-- To add filters to a @GtkAnyFilter@, use 'GI.Gtk.Objects.MultiFilter.multiFilterAppend'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AnyFilter
    ( 

-- * Exported types
    AnyFilter(..)                           ,
    IsAnyFilter                             ,
    toAnyFilter                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.Gtk.Objects.MultiFilter#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Filter#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [match]("GI.Gtk.Objects.Filter#g:method:match"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.MultiFilter#g:method:remove"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStrictness]("GI.Gtk.Objects.Filter#g:method:getStrictness").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAnyFilterMethod                  ,
#endif

-- ** new #method:new#

    anyFilterNew                            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Objects.MultiFilter as Gtk.MultiFilter

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter
import {-# SOURCE #-} qualified GI.Gtk.Objects.MultiFilter as Gtk.MultiFilter

#endif

-- | Memory-managed wrapper type.
newtype AnyFilter = AnyFilter (SP.ManagedPtr AnyFilter)
    deriving (Eq)

instance SP.ManagedPtrNewtype AnyFilter where
    toManagedPtr (AnyFilter p) = p

foreign import ccall "gtk_any_filter_get_type"
    c_gtk_any_filter_get_type :: IO B.Types.GType

instance B.Types.TypedObject AnyFilter where
    glibType = c_gtk_any_filter_get_type

instance B.Types.GObject AnyFilter

-- | Type class for types which can be safely cast to `AnyFilter`, for instance with `toAnyFilter`.
class (SP.GObject o, O.IsDescendantOf AnyFilter o) => IsAnyFilter o
instance (SP.GObject o, O.IsDescendantOf AnyFilter o) => IsAnyFilter o

instance O.HasParentTypes AnyFilter
type instance O.ParentTypes AnyFilter = '[Gtk.MultiFilter.MultiFilter, Gtk.Filter.Filter, GObject.Object.Object, Gio.ListModel.ListModel, Gtk.Buildable.Buildable]

-- | Cast to `AnyFilter`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toAnyFilter :: (MIO.MonadIO m, IsAnyFilter o) => o -> m AnyFilter
toAnyFilter = MIO.liftIO . B.ManagedPtr.unsafeCastTo AnyFilter

-- | Convert 'AnyFilter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AnyFilter) where
    gvalueGType_ = c_gtk_any_filter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AnyFilter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AnyFilter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AnyFilter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAnyFilterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAnyFilterMethod "append" o = Gtk.MultiFilter.MultiFilterAppendMethodInfo
    ResolveAnyFilterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAnyFilterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAnyFilterMethod "changed" o = Gtk.Filter.FilterChangedMethodInfo
    ResolveAnyFilterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAnyFilterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAnyFilterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAnyFilterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAnyFilterMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveAnyFilterMethod "match" o = Gtk.Filter.FilterMatchMethodInfo
    ResolveAnyFilterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAnyFilterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAnyFilterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAnyFilterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAnyFilterMethod "remove" o = Gtk.MultiFilter.MultiFilterRemoveMethodInfo
    ResolveAnyFilterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAnyFilterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAnyFilterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAnyFilterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAnyFilterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAnyFilterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAnyFilterMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveAnyFilterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAnyFilterMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveAnyFilterMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveAnyFilterMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveAnyFilterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAnyFilterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAnyFilterMethod "getStrictness" o = Gtk.Filter.FilterGetStrictnessMethodInfo
    ResolveAnyFilterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAnyFilterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAnyFilterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAnyFilterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAnyFilterMethod t AnyFilter, O.OverloadedMethod info AnyFilter p) => OL.IsLabel t (AnyFilter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAnyFilterMethod t AnyFilter, O.OverloadedMethod info AnyFilter p, R.HasField t AnyFilter p) => R.HasField t AnyFilter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAnyFilterMethod t AnyFilter, O.OverloadedMethodInfo info AnyFilter) => OL.IsLabel t (O.MethodProxy info AnyFilter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AnyFilter
type instance O.AttributeList AnyFilter = AnyFilterAttributeList
type AnyFilterAttributeList = ('[ '("itemType", Gtk.MultiFilter.MultiFilterItemTypePropertyInfo), '("nItems", Gtk.MultiFilter.MultiFilterNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AnyFilter = AnyFilterSignalList
type AnyFilterSignalList = ('[ '("changed", Gtk.Filter.FilterChangedSignalInfo), '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AnyFilter::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "AnyFilter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_any_filter_new" gtk_any_filter_new :: 
    IO (Ptr AnyFilter)

-- | Creates a new empty \"any\" filter.
-- 
-- Use 'GI.Gtk.Objects.MultiFilter.multiFilterAppend' to add filters to it.
-- 
-- This filter matches an item if any of the filters added to it
-- matches the item. In particular, this means that if no filter
-- has been added to it, the filter matches no item.
anyFilterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m AnyFilter
    -- ^ __Returns:__ a new @GtkAnyFilter@
anyFilterNew  = liftIO $ do
    result <- gtk_any_filter_new
    checkUnexpectedReturnNULL "anyFilterNew" result
    result' <- (wrapObject AnyFilter) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


