{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface that supports symbolic colors in paintables.
-- 
-- @GdkPaintable@s implementing the interface will have the
-- t'GI.Gtk.Interfaces.SymbolicPaintable.SymbolicPaintable'.@/snapshot_symbolic/@() function called and
-- have the colors for drawing symbolic icons passed. At least 4 colors are guaranteed
-- to be passed every time.
-- 
-- These 4 colors are the foreground color, and the colors to use for errors, warnings
-- and success information in that order.
-- 
-- More colors may be added in the future.
-- 
-- /Since: 4.6/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.SymbolicPaintable
    ( 

-- * Exported types
    SymbolicPaintable(..)                   ,
    IsSymbolicPaintable                     ,
    toSymbolicPaintable                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [computeConcreteSize]("GI.Gdk.Interfaces.Paintable#g:method:computeConcreteSize"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [invalidateContents]("GI.Gdk.Interfaces.Paintable#g:method:invalidateContents"), [invalidateSize]("GI.Gdk.Interfaces.Paintable#g:method:invalidateSize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [snapshot]("GI.Gdk.Interfaces.Paintable#g:method:snapshot"), [snapshotSymbolic]("GI.Gtk.Interfaces.SymbolicPaintable#g:method:snapshotSymbolic"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentImage]("GI.Gdk.Interfaces.Paintable#g:method:getCurrentImage"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFlags]("GI.Gdk.Interfaces.Paintable#g:method:getFlags"), [getIntrinsicAspectRatio]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicAspectRatio"), [getIntrinsicHeight]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicHeight"), [getIntrinsicWidth]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicWidth"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSymbolicPaintableMethod          ,
#endif

-- ** snapshotSymbolic #method:snapshotSymbolic#

#if defined(ENABLE_OVERLOADING)
    SymbolicPaintableSnapshotSymbolicMethodInfo,
#endif
    symbolicPaintableSnapshotSymbolic       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA

#endif

-- interface SymbolicPaintable 
-- | Memory-managed wrapper type.
newtype SymbolicPaintable = SymbolicPaintable (SP.ManagedPtr SymbolicPaintable)
    deriving (Eq)

instance SP.ManagedPtrNewtype SymbolicPaintable where
    toManagedPtr (SymbolicPaintable p) = p

foreign import ccall "gtk_symbolic_paintable_get_type"
    c_gtk_symbolic_paintable_get_type :: IO B.Types.GType

instance B.Types.TypedObject SymbolicPaintable where
    glibType = c_gtk_symbolic_paintable_get_type

instance B.Types.GObject SymbolicPaintable

-- | Type class for types which can be safely cast to `SymbolicPaintable`, for instance with `toSymbolicPaintable`.
class (SP.GObject o, O.IsDescendantOf SymbolicPaintable o) => IsSymbolicPaintable o
instance (SP.GObject o, O.IsDescendantOf SymbolicPaintable o) => IsSymbolicPaintable o

instance O.HasParentTypes SymbolicPaintable
type instance O.ParentTypes SymbolicPaintable = '[Gdk.Paintable.Paintable, GObject.Object.Object]

-- | Cast to `SymbolicPaintable`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSymbolicPaintable :: (MIO.MonadIO m, IsSymbolicPaintable o) => o -> m SymbolicPaintable
toSymbolicPaintable = MIO.liftIO . B.ManagedPtr.unsafeCastTo SymbolicPaintable

-- | Convert 'SymbolicPaintable' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SymbolicPaintable) where
    gvalueGType_ = c_gtk_symbolic_paintable_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SymbolicPaintable)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SymbolicPaintable)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SymbolicPaintable ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SymbolicPaintable
type instance O.AttributeList SymbolicPaintable = SymbolicPaintableAttributeList
type SymbolicPaintableAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSymbolicPaintableMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSymbolicPaintableMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSymbolicPaintableMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSymbolicPaintableMethod "computeConcreteSize" o = Gdk.Paintable.PaintableComputeConcreteSizeMethodInfo
    ResolveSymbolicPaintableMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSymbolicPaintableMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSymbolicPaintableMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSymbolicPaintableMethod "invalidateContents" o = Gdk.Paintable.PaintableInvalidateContentsMethodInfo
    ResolveSymbolicPaintableMethod "invalidateSize" o = Gdk.Paintable.PaintableInvalidateSizeMethodInfo
    ResolveSymbolicPaintableMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSymbolicPaintableMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSymbolicPaintableMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSymbolicPaintableMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSymbolicPaintableMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSymbolicPaintableMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSymbolicPaintableMethod "snapshot" o = Gdk.Paintable.PaintableSnapshotMethodInfo
    ResolveSymbolicPaintableMethod "snapshotSymbolic" o = SymbolicPaintableSnapshotSymbolicMethodInfo
    ResolveSymbolicPaintableMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSymbolicPaintableMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSymbolicPaintableMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSymbolicPaintableMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSymbolicPaintableMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSymbolicPaintableMethod "getCurrentImage" o = Gdk.Paintable.PaintableGetCurrentImageMethodInfo
    ResolveSymbolicPaintableMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSymbolicPaintableMethod "getFlags" o = Gdk.Paintable.PaintableGetFlagsMethodInfo
    ResolveSymbolicPaintableMethod "getIntrinsicAspectRatio" o = Gdk.Paintable.PaintableGetIntrinsicAspectRatioMethodInfo
    ResolveSymbolicPaintableMethod "getIntrinsicHeight" o = Gdk.Paintable.PaintableGetIntrinsicHeightMethodInfo
    ResolveSymbolicPaintableMethod "getIntrinsicWidth" o = Gdk.Paintable.PaintableGetIntrinsicWidthMethodInfo
    ResolveSymbolicPaintableMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSymbolicPaintableMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSymbolicPaintableMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSymbolicPaintableMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSymbolicPaintableMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSymbolicPaintableMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSymbolicPaintableMethod t SymbolicPaintable, O.OverloadedMethod info SymbolicPaintable p) => OL.IsLabel t (SymbolicPaintable -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSymbolicPaintableMethod t SymbolicPaintable, O.OverloadedMethod info SymbolicPaintable p, R.HasField t SymbolicPaintable p) => R.HasField t SymbolicPaintable p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSymbolicPaintableMethod t SymbolicPaintable, O.OverloadedMethodInfo info SymbolicPaintable) => OL.IsLabel t (O.MethodProxy info SymbolicPaintable) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method SymbolicPaintable::snapshot_symbolic
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paintable"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicPaintable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSymbolicPaintable`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "snapshot"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Snapshot" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkSnapshot` to snapshot to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "width to snapshot in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "height to snapshot in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "colors"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 5
--                 (TInterface Name { namespace = "Gdk" , name = "RGBA" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to an array of colors"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_colors"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The number of colors"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_colors"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "The number of colors"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_paintable_snapshot_symbolic" gtk_symbolic_paintable_snapshot_symbolic :: 
    Ptr SymbolicPaintable ->                -- paintable : TInterface (Name {namespace = "Gtk", name = "SymbolicPaintable"})
    Ptr Gdk.Snapshot.Snapshot ->            -- snapshot : TInterface (Name {namespace = "Gdk", name = "Snapshot"})
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    Ptr Gdk.RGBA.RGBA ->                    -- colors : TCArray False (-1) 5 (TInterface (Name {namespace = "Gdk", name = "RGBA"}))
    FCT.CSize ->                            -- n_colors : TBasicType TSize
    IO ()

-- | Snapshots the paintable with the given colors.
-- 
-- If less than 4 colors are provided, GTK will pad the array with default
-- colors.
-- 
-- /Since: 4.6/
symbolicPaintableSnapshotSymbolic ::
    (B.CallStack.HasCallStack, MonadIO m, IsSymbolicPaintable a, Gdk.Snapshot.IsSnapshot b) =>
    a
    -- ^ /@paintable@/: a @GtkSymbolicPaintable@
    -> b
    -- ^ /@snapshot@/: a @GdkSnapshot@ to snapshot to
    -> Double
    -- ^ /@width@/: width to snapshot in
    -> Double
    -- ^ /@height@/: height to snapshot in
    -> [Gdk.RGBA.RGBA]
    -- ^ /@colors@/: a pointer to an array of colors
    -> m ()
symbolicPaintableSnapshotSymbolic paintable snapshot width height colors = liftIO $ do
    let nColors = fromIntegral $ P.length colors
    paintable' <- unsafeManagedPtrCastPtr paintable
    snapshot' <- unsafeManagedPtrCastPtr snapshot
    let width' = realToFrac width
    let height' = realToFrac height
    colors' <- mapM unsafeManagedPtrGetPtr colors
    colors'' <- packBlockArray 16 colors'
    gtk_symbolic_paintable_snapshot_symbolic paintable' snapshot' width' height' colors'' nColors
    touchManagedPtr paintable
    touchManagedPtr snapshot
    mapM_ touchManagedPtr colors
    freeMem colors''
    return ()

#if defined(ENABLE_OVERLOADING)
data SymbolicPaintableSnapshotSymbolicMethodInfo
instance (signature ~ (b -> Double -> Double -> [Gdk.RGBA.RGBA] -> m ()), MonadIO m, IsSymbolicPaintable a, Gdk.Snapshot.IsSnapshot b) => O.OverloadedMethod SymbolicPaintableSnapshotSymbolicMethodInfo a signature where
    overloadedMethod = symbolicPaintableSnapshotSymbolic

instance O.OverloadedMethodInfo SymbolicPaintableSnapshotSymbolicMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.SymbolicPaintable.symbolicPaintableSnapshotSymbolic",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-SymbolicPaintable.html#v:symbolicPaintableSnapshotSymbolic"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SymbolicPaintable = SymbolicPaintableSignalList
type SymbolicPaintableSignalList = ('[ '("invalidateContents", Gdk.Paintable.PaintableInvalidateContentsSignalInfo), '("invalidateSize", Gdk.Paintable.PaintableInvalidateSizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


