{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface for widgets that have their own t'GI.Gdk.Objects.Surface.Surface'.
-- 
-- The obvious example of a @GtkNative@ is @GtkWindow@.
-- 
-- Every widget that is not itself a @GtkNative@ is contained in one,
-- and you can get it with 'GI.Gtk.Objects.Widget.widgetGetNative'.
-- 
-- To get the surface of a @GtkNative@, use 'GI.Gtk.Interfaces.Native.nativeGetSurface'.
-- It is also possible to find the @GtkNative@ to which a surface
-- belongs, with [func/@gtk@/.Native.get_for_surface].
-- 
-- In addition to a t'GI.Gdk.Objects.Surface.Surface', a @GtkNative@ also provides
-- a t'GI.Gsk.Objects.Renderer.Renderer' for rendering on that surface. To get the
-- renderer, use 'GI.Gtk.Interfaces.Native.nativeGetRenderer'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.Native
    ( 

-- * Exported types
    Native(..)                              ,
    IsNative                                ,
    toNative                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Interfaces.Native#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Interfaces.Native#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveNativeMethod                     ,
#endif

-- ** getForSurface #method:getForSurface#

    nativeGetForSurface                     ,


-- ** getRenderer #method:getRenderer#

#if defined(ENABLE_OVERLOADING)
    NativeGetRendererMethodInfo             ,
#endif
    nativeGetRenderer                       ,


-- ** getSurface #method:getSurface#

#if defined(ENABLE_OVERLOADING)
    NativeGetSurfaceMethodInfo              ,
#endif
    nativeGetSurface                        ,


-- ** getSurfaceTransform #method:getSurfaceTransform#

#if defined(ENABLE_OVERLOADING)
    NativeGetSurfaceTransformMethodInfo     ,
#endif
    nativeGetSurfaceTransform               ,


-- ** realize #method:realize#

#if defined(ENABLE_OVERLOADING)
    NativeRealizeMethodInfo                 ,
#endif
    nativeRealize                           ,


-- ** unrealize #method:unrealize#

#if defined(ENABLE_OVERLOADING)
    NativeUnrealizeMethodInfo               ,
#endif
    nativeUnrealize                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- interface Native 
-- | Memory-managed wrapper type.
newtype Native = Native (SP.ManagedPtr Native)
    deriving (Eq)

instance SP.ManagedPtrNewtype Native where
    toManagedPtr (Native p) = p

foreign import ccall "gtk_native_get_type"
    c_gtk_native_get_type :: IO B.Types.GType

instance B.Types.TypedObject Native where
    glibType = c_gtk_native_get_type

instance B.Types.GObject Native

-- | Type class for types which can be safely cast to `Native`, for instance with `toNative`.
class (SP.GObject o, O.IsDescendantOf Native o) => IsNative o
instance (SP.GObject o, O.IsDescendantOf Native o) => IsNative o

instance O.HasParentTypes Native
type instance O.ParentTypes Native = '[Gtk.Widget.Widget, GObject.Object.Object]

-- | Cast to `Native`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toNative :: (MIO.MonadIO m, IsNative o) => o -> m Native
toNative = MIO.liftIO . B.ManagedPtr.unsafeCastTo Native

-- | Convert 'Native' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Native) where
    gvalueGType_ = c_gtk_native_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Native)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Native)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Native ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Native
type instance O.AttributeList Native = NativeAttributeList
type NativeAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveNativeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNativeMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveNativeMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveNativeMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveNativeMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveNativeMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveNativeMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveNativeMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveNativeMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveNativeMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveNativeMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveNativeMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNativeMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNativeMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveNativeMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveNativeMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveNativeMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveNativeMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveNativeMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveNativeMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveNativeMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveNativeMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveNativeMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveNativeMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveNativeMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNativeMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNativeMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNativeMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveNativeMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveNativeMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveNativeMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveNativeMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveNativeMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveNativeMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveNativeMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveNativeMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveNativeMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveNativeMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveNativeMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveNativeMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveNativeMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNativeMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveNativeMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveNativeMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveNativeMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveNativeMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveNativeMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveNativeMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveNativeMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveNativeMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNativeMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNativeMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveNativeMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveNativeMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveNativeMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveNativeMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveNativeMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveNativeMethod "realize" o = NativeRealizeMethodInfo
    ResolveNativeMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNativeMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNativeMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveNativeMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveNativeMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveNativeMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveNativeMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveNativeMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveNativeMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveNativeMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNativeMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveNativeMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveNativeMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveNativeMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveNativeMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNativeMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNativeMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNativeMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveNativeMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveNativeMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveNativeMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveNativeMethod "unrealize" o = NativeUnrealizeMethodInfo
    ResolveNativeMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNativeMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveNativeMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveNativeMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveNativeMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveNativeMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveNativeMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveNativeMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNativeMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveNativeMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveNativeMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveNativeMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveNativeMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveNativeMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveNativeMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveNativeMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveNativeMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveNativeMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveNativeMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveNativeMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveNativeMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveNativeMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveNativeMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveNativeMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveNativeMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveNativeMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveNativeMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveNativeMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNativeMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveNativeMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveNativeMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveNativeMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveNativeMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveNativeMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveNativeMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveNativeMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveNativeMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveNativeMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveNativeMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveNativeMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveNativeMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveNativeMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveNativeMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveNativeMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveNativeMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveNativeMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveNativeMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveNativeMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveNativeMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveNativeMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveNativeMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveNativeMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveNativeMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveNativeMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveNativeMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveNativeMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveNativeMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveNativeMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveNativeMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveNativeMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveNativeMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveNativeMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveNativeMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveNativeMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNativeMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNativeMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveNativeMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveNativeMethod "getRenderer" o = NativeGetRendererMethodInfo
    ResolveNativeMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveNativeMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveNativeMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveNativeMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveNativeMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveNativeMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveNativeMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveNativeMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveNativeMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveNativeMethod "getSurface" o = NativeGetSurfaceMethodInfo
    ResolveNativeMethod "getSurfaceTransform" o = NativeGetSurfaceTransformMethodInfo
    ResolveNativeMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveNativeMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveNativeMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveNativeMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveNativeMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveNativeMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveNativeMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveNativeMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveNativeMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveNativeMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveNativeMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveNativeMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveNativeMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveNativeMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveNativeMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveNativeMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNativeMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNativeMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveNativeMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveNativeMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveNativeMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveNativeMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveNativeMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveNativeMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveNativeMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveNativeMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveNativeMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveNativeMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveNativeMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveNativeMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveNativeMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveNativeMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveNativeMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveNativeMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveNativeMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveNativeMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveNativeMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveNativeMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNativeMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveNativeMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveNativeMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveNativeMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveNativeMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveNativeMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveNativeMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveNativeMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveNativeMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveNativeMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveNativeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNativeMethod t Native, O.OverloadedMethod info Native p) => OL.IsLabel t (Native -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNativeMethod t Native, O.OverloadedMethod info Native p, R.HasField t Native p) => R.HasField t Native p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNativeMethod t Native, O.OverloadedMethodInfo info Native) => OL.IsLabel t (O.MethodProxy info Native) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Native::get_renderer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Native" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNative`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "Renderer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_native_get_renderer" gtk_native_get_renderer :: 
    Ptr Native ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Native"})
    IO (Ptr Gsk.Renderer.Renderer)

-- | Returns the renderer that is used for this @GtkNative@.
nativeGetRenderer ::
    (B.CallStack.HasCallStack, MonadIO m, IsNative a) =>
    a
    -- ^ /@self@/: a @GtkNative@
    -> m (Maybe Gsk.Renderer.Renderer)
    -- ^ __Returns:__ the renderer for /@self@/
nativeGetRenderer self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_native_get_renderer self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gsk.Renderer.Renderer) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NativeGetRendererMethodInfo
instance (signature ~ (m (Maybe Gsk.Renderer.Renderer)), MonadIO m, IsNative a) => O.OverloadedMethod NativeGetRendererMethodInfo a signature where
    overloadedMethod = nativeGetRenderer

instance O.OverloadedMethodInfo NativeGetRendererMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.Native.nativeGetRenderer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-Native.html#v:nativeGetRenderer"
        })


#endif

-- method Native::get_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Native" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNative`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_native_get_surface" gtk_native_get_surface :: 
    Ptr Native ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Native"})
    IO (Ptr Gdk.Surface.Surface)

-- | Returns the surface of this @GtkNative@.
nativeGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsNative a) =>
    a
    -- ^ /@self@/: a @GtkNative@
    -> m (Maybe Gdk.Surface.Surface)
    -- ^ __Returns:__ the surface of /@self@/
nativeGetSurface self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_native_get_surface self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Surface.Surface) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data NativeGetSurfaceMethodInfo
instance (signature ~ (m (Maybe Gdk.Surface.Surface)), MonadIO m, IsNative a) => O.OverloadedMethod NativeGetSurfaceMethodInfo a signature where
    overloadedMethod = nativeGetSurface

instance O.OverloadedMethodInfo NativeGetSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.Native.nativeGetSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-Native.html#v:nativeGetSurface"
        })


#endif

-- method Native::get_surface_transform
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Native" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNative`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the x coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_native_get_surface_transform" gtk_native_get_surface_transform :: 
    Ptr Native ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Native"})
    Ptr CDouble ->                          -- x : TBasicType TDouble
    Ptr CDouble ->                          -- y : TBasicType TDouble
    IO ()

-- | Retrieves the surface transform of /@self@/.
-- 
-- This is the translation from /@self@/\'s surface coordinates into
-- /@self@/\'s widget coordinates.
nativeGetSurfaceTransform ::
    (B.CallStack.HasCallStack, MonadIO m, IsNative a) =>
    a
    -- ^ /@self@/: a @GtkNative@
    -> m ((Double, Double))
nativeGetSurfaceTransform self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    x <- allocMem :: IO (Ptr CDouble)
    y <- allocMem :: IO (Ptr CDouble)
    gtk_native_get_surface_transform self' x y
    x' <- peek x
    let x'' = realToFrac x'
    y' <- peek y
    let y'' = realToFrac y'
    touchManagedPtr self
    freeMem x
    freeMem y
    return (x'', y'')

#if defined(ENABLE_OVERLOADING)
data NativeGetSurfaceTransformMethodInfo
instance (signature ~ (m ((Double, Double))), MonadIO m, IsNative a) => O.OverloadedMethod NativeGetSurfaceTransformMethodInfo a signature where
    overloadedMethod = nativeGetSurfaceTransform

instance O.OverloadedMethodInfo NativeGetSurfaceTransformMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.Native.nativeGetSurfaceTransform",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-Native.html#v:nativeGetSurfaceTransform"
        })


#endif

-- method Native::realize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Native" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNative`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_native_realize" gtk_native_realize :: 
    Ptr Native ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Native"})
    IO ()

-- | Realizes a @GtkNative@.
-- 
-- This should only be used by subclasses.
nativeRealize ::
    (B.CallStack.HasCallStack, MonadIO m, IsNative a) =>
    a
    -- ^ /@self@/: a @GtkNative@
    -> m ()
nativeRealize self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_native_realize self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data NativeRealizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsNative a) => O.OverloadedMethod NativeRealizeMethodInfo a signature where
    overloadedMethod = nativeRealize

instance O.OverloadedMethodInfo NativeRealizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.Native.nativeRealize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-Native.html#v:nativeRealize"
        })


#endif

-- method Native::unrealize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Native" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNative`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_native_unrealize" gtk_native_unrealize :: 
    Ptr Native ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Native"})
    IO ()

-- | Unrealizes a @GtkNative@.
-- 
-- This should only be used by subclasses.
nativeUnrealize ::
    (B.CallStack.HasCallStack, MonadIO m, IsNative a) =>
    a
    -- ^ /@self@/: a @GtkNative@
    -> m ()
nativeUnrealize self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_native_unrealize self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data NativeUnrealizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsNative a) => O.OverloadedMethod NativeUnrealizeMethodInfo a signature where
    overloadedMethod = nativeUnrealize

instance O.OverloadedMethodInfo NativeUnrealizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.Native.nativeUnrealize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-Native.html#v:nativeUnrealize"
        })


#endif

-- method Native::get_for_surface
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkSurface`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Native" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_native_get_for_surface" gtk_native_get_for_surface :: 
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    IO (Ptr Native)

-- | Finds the @GtkNative@ associated with the surface.
nativeGetForSurface ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Surface.IsSurface a) =>
    a
    -- ^ /@surface@/: a @GdkSurface@
    -> m (Maybe Native)
    -- ^ __Returns:__ the @GtkNative@ that is associated with /@surface@/
nativeGetForSurface surface = liftIO $ do
    surface' <- unsafeManagedPtrCastPtr surface
    result <- gtk_native_get_for_surface surface'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Native) result'
        return result''
    touchManagedPtr surface
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Native = NativeSignalList
type NativeSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif


