{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Makes it possible to use an object as source or target in a
-- t'GI.Gtk.Objects.Constraint.Constraint'.
-- 
-- Besides @GtkWidget@, it is also implemented by @GtkConstraintGuide@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.ConstraintTarget
    ( 

-- * Exported types
    ConstraintTarget(..)                    ,
    IsConstraintTarget                      ,
    toConstraintTarget                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveConstraintTargetMethod           ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface ConstraintTarget 
-- | Memory-managed wrapper type.
newtype ConstraintTarget = ConstraintTarget (SP.ManagedPtr ConstraintTarget)
    deriving (Eq)

instance SP.ManagedPtrNewtype ConstraintTarget where
    toManagedPtr (ConstraintTarget p) = p

foreign import ccall "gtk_constraint_target_get_type"
    c_gtk_constraint_target_get_type :: IO B.Types.GType

instance B.Types.TypedObject ConstraintTarget where
    glibType = c_gtk_constraint_target_get_type

instance B.Types.GObject ConstraintTarget

-- | Type class for types which can be safely cast to `ConstraintTarget`, for instance with `toConstraintTarget`.
class (SP.GObject o, O.IsDescendantOf ConstraintTarget o) => IsConstraintTarget o
instance (SP.GObject o, O.IsDescendantOf ConstraintTarget o) => IsConstraintTarget o

instance O.HasParentTypes ConstraintTarget
type instance O.ParentTypes ConstraintTarget = '[GObject.Object.Object]

-- | Cast to `ConstraintTarget`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toConstraintTarget :: (MIO.MonadIO m, IsConstraintTarget o) => o -> m ConstraintTarget
toConstraintTarget = MIO.liftIO . B.ManagedPtr.unsafeCastTo ConstraintTarget

-- | Convert 'ConstraintTarget' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ConstraintTarget) where
    gvalueGType_ = c_gtk_constraint_target_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ConstraintTarget)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ConstraintTarget)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ConstraintTarget ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ConstraintTarget
type instance O.AttributeList ConstraintTarget = ConstraintTargetAttributeList
type ConstraintTargetAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveConstraintTargetMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveConstraintTargetMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveConstraintTargetMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveConstraintTargetMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveConstraintTargetMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveConstraintTargetMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveConstraintTargetMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveConstraintTargetMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveConstraintTargetMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveConstraintTargetMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveConstraintTargetMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveConstraintTargetMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveConstraintTargetMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveConstraintTargetMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveConstraintTargetMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveConstraintTargetMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveConstraintTargetMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveConstraintTargetMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveConstraintTargetMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveConstraintTargetMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveConstraintTargetMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveConstraintTargetMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveConstraintTargetMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveConstraintTargetMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveConstraintTargetMethod t ConstraintTarget, O.OverloadedMethod info ConstraintTarget p) => OL.IsLabel t (ConstraintTarget -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveConstraintTargetMethod t ConstraintTarget, O.OverloadedMethod info ConstraintTarget p, R.HasField t ConstraintTarget p) => R.HasField t ConstraintTarget p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveConstraintTargetMethod t ConstraintTarget, O.OverloadedMethodInfo info ConstraintTarget) => OL.IsLabel t (O.MethodProxy info ConstraintTarget) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ConstraintTarget = ConstraintTargetSignalList
type ConstraintTargetSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


