{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Interface for widgets that can be used for editing cells
-- 
-- The @GtkCellEditable@ interface must be implemented for widgets to be usable
-- to edit the contents of a @GtkTreeView@ cell. It provides a way to specify how
-- temporary widgets should be configured for editing, get the new value, etc.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.CellEditable
    ( 

-- * Exported types
    CellEditable(..)                        ,
    IsCellEditable                          ,
    toCellEditable                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [editingDone]("GI.Gtk.Interfaces.CellEditable#g:method:editingDone"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [removeWidget]("GI.Gtk.Interfaces.CellEditable#g:method:removeWidget"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [startEditing]("GI.Gtk.Interfaces.CellEditable#g:method:startEditing"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveCellEditableMethod               ,
#endif

-- ** editingDone #method:editingDone#

#if defined(ENABLE_OVERLOADING)
    CellEditableEditingDoneMethodInfo       ,
#endif
    cellEditableEditingDone                 ,


-- ** removeWidget #method:removeWidget#

#if defined(ENABLE_OVERLOADING)
    CellEditableRemoveWidgetMethodInfo      ,
#endif
    cellEditableRemoveWidget                ,


-- ** startEditing #method:startEditing#

#if defined(ENABLE_OVERLOADING)
    CellEditableStartEditingMethodInfo      ,
#endif
    cellEditableStartEditing                ,




 -- * Properties


-- ** editingCanceled #attr:editingCanceled#
-- | Indicates whether editing on the cell has been canceled.

#if defined(ENABLE_OVERLOADING)
    CellEditableEditingCanceledPropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    cellEditableEditingCanceled             ,
#endif
    constructCellEditableEditingCanceled    ,
    getCellEditableEditingCanceled          ,
    setCellEditableEditingCanceled          ,




 -- * Signals


-- ** editingDone #signal:editingDone#

    CellEditableEditingDoneCallback         ,
#if defined(ENABLE_OVERLOADING)
    CellEditableEditingDoneSignalInfo       ,
#endif
    afterCellEditableEditingDone            ,
    onCellEditableEditingDone               ,


-- ** removeWidget #signal:removeWidget#

    CellEditableRemoveWidgetCallback        ,
#if defined(ENABLE_OVERLOADING)
    CellEditableRemoveWidgetSignalInfo      ,
#endif
    afterCellEditableRemoveWidget           ,
    onCellEditableRemoveWidget              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- interface CellEditable 
-- | Memory-managed wrapper type.
{-# DEPRECATED CellEditable ["(Since version 4.10)","List views use widgets for displaying their","  contents. See t'GI.Gtk.Interfaces.Editable.Editable' for editable text widgets"] #-}
newtype CellEditable = CellEditable (SP.ManagedPtr CellEditable)
    deriving (Eq)

instance SP.ManagedPtrNewtype CellEditable where
    toManagedPtr (CellEditable p) = p

foreign import ccall "gtk_cell_editable_get_type"
    c_gtk_cell_editable_get_type :: IO B.Types.GType

instance B.Types.TypedObject CellEditable where
    glibType = c_gtk_cell_editable_get_type

instance B.Types.GObject CellEditable

-- | Type class for types which can be safely cast to `CellEditable`, for instance with `toCellEditable`.
class (SP.GObject o, O.IsDescendantOf CellEditable o) => IsCellEditable o
instance (SP.GObject o, O.IsDescendantOf CellEditable o) => IsCellEditable o

instance O.HasParentTypes CellEditable
type instance O.ParentTypes CellEditable = '[GObject.Object.Object, Gtk.Widget.Widget]

-- | Cast to `CellEditable`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toCellEditable :: (MIO.MonadIO m, IsCellEditable o) => o -> m CellEditable
toCellEditable = MIO.liftIO . B.ManagedPtr.unsafeCastTo CellEditable

-- | Convert 'CellEditable' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CellEditable) where
    gvalueGType_ = c_gtk_cell_editable_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CellEditable)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CellEditable)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CellEditable ptr
        else return P.Nothing
        
    

-- VVV Prop "editing-canceled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@editing-canceled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cellEditable #editingCanceled
-- @
getCellEditableEditingCanceled :: (MonadIO m, IsCellEditable o) => o -> m Bool
getCellEditableEditingCanceled obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "editing-canceled"

-- | Set the value of the “@editing-canceled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellEditable [ #editingCanceled 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellEditableEditingCanceled :: (MonadIO m, IsCellEditable o) => o -> Bool -> m ()
setCellEditableEditingCanceled obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "editing-canceled" val

-- | Construct a `GValueConstruct` with valid value for the “@editing-canceled@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellEditableEditingCanceled :: (IsCellEditable o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCellEditableEditingCanceled val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "editing-canceled" val

#if defined(ENABLE_OVERLOADING)
data CellEditableEditingCanceledPropertyInfo
instance AttrInfo CellEditableEditingCanceledPropertyInfo where
    type AttrAllowedOps CellEditableEditingCanceledPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CellEditableEditingCanceledPropertyInfo = IsCellEditable
    type AttrSetTypeConstraint CellEditableEditingCanceledPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CellEditableEditingCanceledPropertyInfo = (~) Bool
    type AttrTransferType CellEditableEditingCanceledPropertyInfo = Bool
    type AttrGetType CellEditableEditingCanceledPropertyInfo = Bool
    type AttrLabel CellEditableEditingCanceledPropertyInfo = "editing-canceled"
    type AttrOrigin CellEditableEditingCanceledPropertyInfo = CellEditable
    attrGet = getCellEditableEditingCanceled
    attrSet = setCellEditableEditingCanceled
    attrTransfer _ v = do
        return v
    attrConstruct = constructCellEditableEditingCanceled
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.CellEditable.editingCanceled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-CellEditable.html#g:attr:editingCanceled"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CellEditable
type instance O.AttributeList CellEditable = CellEditableAttributeList
type CellEditableAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("editingCanceled", CellEditableEditingCanceledPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
cellEditableEditingCanceled :: AttrLabelProxy "editingCanceled"
cellEditableEditingCanceled = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveCellEditableMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCellEditableMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveCellEditableMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveCellEditableMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveCellEditableMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveCellEditableMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveCellEditableMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveCellEditableMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveCellEditableMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveCellEditableMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveCellEditableMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveCellEditableMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCellEditableMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCellEditableMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveCellEditableMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveCellEditableMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveCellEditableMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveCellEditableMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveCellEditableMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveCellEditableMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveCellEditableMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveCellEditableMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveCellEditableMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveCellEditableMethod "editingDone" o = CellEditableEditingDoneMethodInfo
    ResolveCellEditableMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveCellEditableMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCellEditableMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCellEditableMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCellEditableMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveCellEditableMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveCellEditableMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveCellEditableMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveCellEditableMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveCellEditableMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveCellEditableMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveCellEditableMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveCellEditableMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveCellEditableMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveCellEditableMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveCellEditableMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveCellEditableMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveCellEditableMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCellEditableMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveCellEditableMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveCellEditableMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveCellEditableMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveCellEditableMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveCellEditableMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveCellEditableMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveCellEditableMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveCellEditableMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCellEditableMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCellEditableMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveCellEditableMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveCellEditableMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveCellEditableMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveCellEditableMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveCellEditableMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveCellEditableMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveCellEditableMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCellEditableMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCellEditableMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveCellEditableMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveCellEditableMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveCellEditableMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveCellEditableMethod "removeWidget" o = CellEditableRemoveWidgetMethodInfo
    ResolveCellEditableMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveCellEditableMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveCellEditableMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveCellEditableMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCellEditableMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveCellEditableMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveCellEditableMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveCellEditableMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveCellEditableMethod "startEditing" o = CellEditableStartEditingMethodInfo
    ResolveCellEditableMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCellEditableMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCellEditableMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCellEditableMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveCellEditableMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveCellEditableMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveCellEditableMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveCellEditableMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveCellEditableMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCellEditableMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveCellEditableMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveCellEditableMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveCellEditableMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveCellEditableMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveCellEditableMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveCellEditableMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCellEditableMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveCellEditableMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveCellEditableMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveCellEditableMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveCellEditableMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveCellEditableMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveCellEditableMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveCellEditableMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveCellEditableMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveCellEditableMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveCellEditableMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveCellEditableMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveCellEditableMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveCellEditableMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveCellEditableMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveCellEditableMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveCellEditableMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveCellEditableMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveCellEditableMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveCellEditableMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCellEditableMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveCellEditableMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveCellEditableMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveCellEditableMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveCellEditableMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveCellEditableMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveCellEditableMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveCellEditableMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveCellEditableMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveCellEditableMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveCellEditableMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveCellEditableMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveCellEditableMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveCellEditableMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveCellEditableMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveCellEditableMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveCellEditableMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveCellEditableMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveCellEditableMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveCellEditableMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveCellEditableMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveCellEditableMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveCellEditableMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveCellEditableMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveCellEditableMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveCellEditableMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveCellEditableMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveCellEditableMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveCellEditableMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveCellEditableMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveCellEditableMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveCellEditableMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveCellEditableMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveCellEditableMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveCellEditableMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveCellEditableMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCellEditableMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCellEditableMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveCellEditableMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveCellEditableMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveCellEditableMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveCellEditableMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveCellEditableMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveCellEditableMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveCellEditableMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveCellEditableMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveCellEditableMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveCellEditableMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveCellEditableMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveCellEditableMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveCellEditableMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveCellEditableMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveCellEditableMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveCellEditableMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveCellEditableMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveCellEditableMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveCellEditableMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveCellEditableMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveCellEditableMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveCellEditableMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveCellEditableMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveCellEditableMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveCellEditableMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveCellEditableMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCellEditableMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCellEditableMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveCellEditableMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveCellEditableMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveCellEditableMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveCellEditableMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveCellEditableMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveCellEditableMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveCellEditableMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveCellEditableMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveCellEditableMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveCellEditableMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveCellEditableMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveCellEditableMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveCellEditableMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveCellEditableMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveCellEditableMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveCellEditableMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveCellEditableMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveCellEditableMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveCellEditableMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveCellEditableMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCellEditableMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveCellEditableMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveCellEditableMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveCellEditableMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveCellEditableMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveCellEditableMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveCellEditableMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveCellEditableMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveCellEditableMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveCellEditableMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveCellEditableMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCellEditableMethod t CellEditable, O.OverloadedMethod info CellEditable p) => OL.IsLabel t (CellEditable -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCellEditableMethod t CellEditable, O.OverloadedMethod info CellEditable p, R.HasField t CellEditable p) => R.HasField t CellEditable p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCellEditableMethod t CellEditable, O.OverloadedMethodInfo info CellEditable) => OL.IsLabel t (O.MethodProxy info CellEditable) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method CellEditable::editing_done
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell_editable"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellEditable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkCellEditable`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_cell_editable_editing_done" gtk_cell_editable_editing_done :: 
    Ptr CellEditable ->                     -- cell_editable : TInterface (Name {namespace = "Gtk", name = "CellEditable"})
    IO ()

{-# DEPRECATED cellEditableEditingDone ["(Since version 4.10)"] #-}
-- | Emits the @GtkCellEditable::editing-done@ signal.
cellEditableEditingDone ::
    (B.CallStack.HasCallStack, MonadIO m, IsCellEditable a) =>
    a
    -- ^ /@cellEditable@/: A @GtkCellEditable@
    -> m ()
cellEditableEditingDone cellEditable = liftIO $ do
    cellEditable' <- unsafeManagedPtrCastPtr cellEditable
    gtk_cell_editable_editing_done cellEditable'
    touchManagedPtr cellEditable
    return ()

#if defined(ENABLE_OVERLOADING)
data CellEditableEditingDoneMethodInfo
instance (signature ~ (m ()), MonadIO m, IsCellEditable a) => O.OverloadedMethod CellEditableEditingDoneMethodInfo a signature where
    overloadedMethod = cellEditableEditingDone

instance O.OverloadedMethodInfo CellEditableEditingDoneMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.CellEditable.cellEditableEditingDone",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-CellEditable.html#v:cellEditableEditingDone"
        })


#endif

-- method CellEditable::remove_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell_editable"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellEditable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkCellEditable`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_cell_editable_remove_widget" gtk_cell_editable_remove_widget :: 
    Ptr CellEditable ->                     -- cell_editable : TInterface (Name {namespace = "Gtk", name = "CellEditable"})
    IO ()

{-# DEPRECATED cellEditableRemoveWidget ["(Since version 4.10)"] #-}
-- | Emits the @GtkCellEditable::remove-widget@ signal.
cellEditableRemoveWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCellEditable a) =>
    a
    -- ^ /@cellEditable@/: A @GtkCellEditable@
    -> m ()
cellEditableRemoveWidget cellEditable = liftIO $ do
    cellEditable' <- unsafeManagedPtrCastPtr cellEditable
    gtk_cell_editable_remove_widget cellEditable'
    touchManagedPtr cellEditable
    return ()

#if defined(ENABLE_OVERLOADING)
data CellEditableRemoveWidgetMethodInfo
instance (signature ~ (m ()), MonadIO m, IsCellEditable a) => O.OverloadedMethod CellEditableRemoveWidgetMethodInfo a signature where
    overloadedMethod = cellEditableRemoveWidget

instance O.OverloadedMethodInfo CellEditableRemoveWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.CellEditable.cellEditableRemoveWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-CellEditable.html#v:cellEditableRemoveWidget"
        })


#endif

-- method CellEditable::start_editing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell_editable"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CellEditable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkCellEditable`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The `GdkEvent` that began the editing process, or\n  %NULL if editing was initiated programmatically"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_cell_editable_start_editing" gtk_cell_editable_start_editing :: 
    Ptr CellEditable ->                     -- cell_editable : TInterface (Name {namespace = "Gtk", name = "CellEditable"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO ()

-- | Begins editing on a /@cellEditable@/.
-- 
-- The @GtkCellRenderer@ for the cell creates and returns a @GtkCellEditable@ from
-- 'GI.Gtk.Objects.CellRenderer.cellRendererStartEditing', configured for the @GtkCellRenderer@ type.
-- 
-- 'GI.Gtk.Interfaces.CellEditable.cellEditableStartEditing' can then set up /@cellEditable@/ suitably for
-- editing a cell, e.g. making the Esc key emit @GtkCellEditable::editing-done@.
-- 
-- Note that the /@cellEditable@/ is created on-demand for the current edit; its
-- lifetime is temporary and does not persist across other edits and\/or cells.
cellEditableStartEditing ::
    (B.CallStack.HasCallStack, MonadIO m, IsCellEditable a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@cellEditable@/: A @GtkCellEditable@
    -> Maybe (b)
    -- ^ /@event@/: The @GdkEvent@ that began the editing process, or
    --   'P.Nothing' if editing was initiated programmatically
    -> m ()
cellEditableStartEditing cellEditable event = liftIO $ do
    cellEditable' <- unsafeManagedPtrCastPtr cellEditable
    maybeEvent <- case event of
        Nothing -> return FP.nullPtr
        Just jEvent -> do
            jEvent' <- unsafeManagedPtrCastPtr jEvent
            return jEvent'
    gtk_cell_editable_start_editing cellEditable' maybeEvent
    touchManagedPtr cellEditable
    whenJust event touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CellEditableStartEditingMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCellEditable a, Gdk.Event.IsEvent b) => O.OverloadedMethod CellEditableStartEditingMethodInfo a signature where
    overloadedMethod = cellEditableStartEditing

instance O.OverloadedMethodInfo CellEditableStartEditingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.CellEditable.cellEditableStartEditing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-CellEditable.html#v:cellEditableStartEditing"
        })


#endif

-- signal CellEditable::editing-done
-- | This signal is a sign for the cell renderer to update its
-- value from the /@cellEditable@/.
-- 
-- Implementations of @GtkCellEditable@ are responsible for
-- emitting this signal when they are done editing, e.g.
-- @GtkEntry@ emits this signal when the user presses Enter. Typical things to
-- do in a handler for [editingDone](#g:signal:editingDone) are to capture the edited value,
-- disconnect the /@cellEditable@/ from signals on the @GtkCellRenderer@, etc.
-- 
-- 'GI.Gtk.Interfaces.CellEditable.cellEditableEditingDone' is a convenience method
-- for emitting @GtkCellEditable::editing-done@.
type CellEditableEditingDoneCallback =
    IO ()

type C_CellEditableEditingDoneCallback =
    Ptr CellEditable ->                     -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CellEditableEditingDoneCallback`.
foreign import ccall "wrapper"
    mk_CellEditableEditingDoneCallback :: C_CellEditableEditingDoneCallback -> IO (FunPtr C_CellEditableEditingDoneCallback)

wrap_CellEditableEditingDoneCallback :: 
    GObject a => (a -> CellEditableEditingDoneCallback) ->
    C_CellEditableEditingDoneCallback
wrap_CellEditableEditingDoneCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [editingDone](#signal:editingDone) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' cellEditable #editingDone callback
-- @
-- 
-- 
onCellEditableEditingDone :: (IsCellEditable a, MonadIO m) => a -> ((?self :: a) => CellEditableEditingDoneCallback) -> m SignalHandlerId
onCellEditableEditingDone obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CellEditableEditingDoneCallback wrapped
    wrapped'' <- mk_CellEditableEditingDoneCallback wrapped'
    connectSignalFunPtr obj "editing-done" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [editingDone](#signal:editingDone) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' cellEditable #editingDone callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCellEditableEditingDone :: (IsCellEditable a, MonadIO m) => a -> ((?self :: a) => CellEditableEditingDoneCallback) -> m SignalHandlerId
afterCellEditableEditingDone obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CellEditableEditingDoneCallback wrapped
    wrapped'' <- mk_CellEditableEditingDoneCallback wrapped'
    connectSignalFunPtr obj "editing-done" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CellEditableEditingDoneSignalInfo
instance SignalInfo CellEditableEditingDoneSignalInfo where
    type HaskellCallbackType CellEditableEditingDoneSignalInfo = CellEditableEditingDoneCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CellEditableEditingDoneCallback cb
        cb'' <- mk_CellEditableEditingDoneCallback cb'
        connectSignalFunPtr obj "editing-done" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.CellEditable::editing-done"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-CellEditable.html#g:signal:editingDone"})

#endif

-- signal CellEditable::remove-widget
-- | This signal is meant to indicate that the cell is finished
-- editing, and the /@cellEditable@/ widget is being removed and may
-- subsequently be destroyed.
-- 
-- Implementations of @GtkCellEditable@ are responsible for
-- emitting this signal when they are done editing. It must
-- be emitted after the @GtkCellEditable::editing-done@ signal,
-- to give the cell renderer a chance to update the cell\'s value
-- before the widget is removed.
-- 
-- 'GI.Gtk.Interfaces.CellEditable.cellEditableRemoveWidget' is a convenience method
-- for emitting @GtkCellEditable::remove-widget@.
type CellEditableRemoveWidgetCallback =
    IO ()

type C_CellEditableRemoveWidgetCallback =
    Ptr CellEditable ->                     -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CellEditableRemoveWidgetCallback`.
foreign import ccall "wrapper"
    mk_CellEditableRemoveWidgetCallback :: C_CellEditableRemoveWidgetCallback -> IO (FunPtr C_CellEditableRemoveWidgetCallback)

wrap_CellEditableRemoveWidgetCallback :: 
    GObject a => (a -> CellEditableRemoveWidgetCallback) ->
    C_CellEditableRemoveWidgetCallback
wrap_CellEditableRemoveWidgetCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [removeWidget](#signal:removeWidget) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' cellEditable #removeWidget callback
-- @
-- 
-- 
onCellEditableRemoveWidget :: (IsCellEditable a, MonadIO m) => a -> ((?self :: a) => CellEditableRemoveWidgetCallback) -> m SignalHandlerId
onCellEditableRemoveWidget obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CellEditableRemoveWidgetCallback wrapped
    wrapped'' <- mk_CellEditableRemoveWidgetCallback wrapped'
    connectSignalFunPtr obj "remove-widget" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [removeWidget](#signal:removeWidget) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' cellEditable #removeWidget callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCellEditableRemoveWidget :: (IsCellEditable a, MonadIO m) => a -> ((?self :: a) => CellEditableRemoveWidgetCallback) -> m SignalHandlerId
afterCellEditableRemoveWidget obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CellEditableRemoveWidgetCallback wrapped
    wrapped'' <- mk_CellEditableRemoveWidgetCallback wrapped'
    connectSignalFunPtr obj "remove-widget" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CellEditableRemoveWidgetSignalInfo
instance SignalInfo CellEditableRemoveWidgetSignalInfo where
    type HaskellCallbackType CellEditableRemoveWidgetSignalInfo = CellEditableRemoveWidgetCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CellEditableRemoveWidgetCallback cb
        cb'' <- mk_CellEditableRemoveWidgetCallback cb'
        connectSignalFunPtr obj "remove-widget" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.CellEditable::remove-widget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Interfaces-CellEditable.html#g:signal:removeWidget"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CellEditable = CellEditableSignalList
type CellEditableSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("editingDone", CellEditableEditingDoneSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("removeWidget", CellEditableRemoveWidgetSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif


