

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Functions
    ( 

 -- * Methods


-- ** acceleratorGetDefaultModMask #method:acceleratorGetDefaultModMask#

    acceleratorGetDefaultModMask            ,


-- ** acceleratorGetLabel #method:acceleratorGetLabel#

    acceleratorGetLabel                     ,


-- ** acceleratorGetLabelWithKeycode #method:acceleratorGetLabelWithKeycode#

    acceleratorGetLabelWithKeycode          ,


-- ** acceleratorName #method:acceleratorName#

    acceleratorName                         ,


-- ** acceleratorNameWithKeycode #method:acceleratorNameWithKeycode#

    acceleratorNameWithKeycode              ,


-- ** acceleratorParse #method:acceleratorParse#

    acceleratorParse                        ,


-- ** acceleratorParseWithKeycode #method:acceleratorParseWithKeycode#

    acceleratorParseWithKeycode             ,


-- ** acceleratorValid #method:acceleratorValid#

    acceleratorValid                        ,


-- ** checkVersion #method:checkVersion#

    checkVersion                            ,


-- ** cssParserErrorQuark #method:cssParserErrorQuark#

    cssParserErrorQuark                     ,


-- ** cssParserWarningQuark #method:cssParserWarningQuark#

    cssParserWarningQuark                   ,


-- ** disablePortals #method:disablePortals#

    disablePortals                          ,


-- ** disableSetlocale #method:disableSetlocale#

    disableSetlocale                        ,


-- ** distributeNaturalAllocation #method:distributeNaturalAllocation#

    distributeNaturalAllocation             ,


-- ** enumeratePrinters #method:enumeratePrinters#

    enumeratePrinters                       ,


-- ** getBinaryAge #method:getBinaryAge#

    getBinaryAge                            ,


-- ** getDebugFlags #method:getDebugFlags#

    getDebugFlags                           ,


-- ** getDefaultLanguage #method:getDefaultLanguage#

    getDefaultLanguage                      ,


-- ** getInterfaceAge #method:getInterfaceAge#

    getInterfaceAge                         ,


-- ** getLocaleDirection #method:getLocaleDirection#

    getLocaleDirection                      ,


-- ** getMajorVersion #method:getMajorVersion#

    getMajorVersion                         ,


-- ** getMicroVersion #method:getMicroVersion#

    getMicroVersion                         ,


-- ** getMinorVersion #method:getMinorVersion#

    getMinorVersion                         ,


-- ** hsvToRgb #method:hsvToRgb#

    hsvToRgb                                ,


-- ** init #method:init#

    init                                    ,


-- ** initCheck #method:initCheck#

    initCheck                               ,


-- ** isInitialized #method:isInitialized#

    isInitialized                           ,


-- ** paramSpecExpression #method:paramSpecExpression#

    paramSpecExpression                     ,


-- ** printRunPageSetupDialog #method:printRunPageSetupDialog#

    printRunPageSetupDialog                 ,


-- ** printRunPageSetupDialogAsync #method:printRunPageSetupDialogAsync#

    printRunPageSetupDialogAsync            ,


-- ** renderActivity #method:renderActivity#

    renderActivity                          ,


-- ** renderArrow #method:renderArrow#

    renderArrow                             ,


-- ** renderBackground #method:renderBackground#

    renderBackground                        ,


-- ** renderCheck #method:renderCheck#

    renderCheck                             ,


-- ** renderExpander #method:renderExpander#

    renderExpander                          ,


-- ** renderFocus #method:renderFocus#

    renderFocus                             ,


-- ** renderFrame #method:renderFrame#

    renderFrame                             ,


-- ** renderHandle #method:renderHandle#

    renderHandle                            ,


-- ** renderIcon #method:renderIcon#

    renderIcon                              ,


-- ** renderLayout #method:renderLayout#

    renderLayout                            ,


-- ** renderLine #method:renderLine#

    renderLine                              ,


-- ** renderOption #method:renderOption#

    renderOption                            ,


-- ** rgbToHsv #method:rgbToHsv#

    rgbToHsv                                ,


-- ** setDebugFlags #method:setDebugFlags#

    setDebugFlags                           ,


-- ** showUri #method:showUri#

    showUri                                 ,


-- ** showUriFull #method:showUriFull#

    showUriFull                             ,


-- ** showUriFullFinish #method:showUriFullFinish#

    showUriFullFinish                       ,


-- ** testAccessibleAssertionMessageRole #method:testAccessibleAssertionMessageRole#

    testAccessibleAssertionMessageRole      ,


-- ** testAccessibleHasProperty #method:testAccessibleHasProperty#

    testAccessibleHasProperty               ,


-- ** testAccessibleHasRelation #method:testAccessibleHasRelation#

    testAccessibleHasRelation               ,


-- ** testAccessibleHasRole #method:testAccessibleHasRole#

    testAccessibleHasRole                   ,


-- ** testAccessibleHasState #method:testAccessibleHasState#

    testAccessibleHasState                  ,


-- ** testListAllTypes #method:testListAllTypes#

    testListAllTypes                        ,


-- ** testRegisterAllTypes #method:testRegisterAllTypes#

    testRegisterAllTypes                    ,


-- ** testWidgetWaitForDraw #method:testWidgetWaitForDraw#

    testWidgetWaitForDraw                   ,


-- ** treeCreateRowDragContent #method:treeCreateRowDragContent#

    treeCreateRowDragContent                ,


-- ** treeGetRowDragData #method:treeGetRowDragData#

    treeGetRowDragData                      ,


-- ** valueDupExpression #method:valueDupExpression#

    valueDupExpression                      ,


-- ** valueGetExpression #method:valueGetExpression#

    valueGetExpression                      ,


-- ** valueSetExpression #method:valueSetExpression#

    valueSetExpression                      ,


-- ** valueTakeExpression #method:valueTakeExpression#

    valueTakeExpression                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.KeyFile as GLib.KeyFile
import qualified GI.GObject.Flags as GObject.Flags
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch
import {-# SOURCE #-} qualified GI.Gtk.Structs.PageRange as Gtk.PageRange
import {-# SOURCE #-} qualified GI.Gtk.Structs.PaperSize as Gtk.PaperSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.RequestedSize as Gtk.RequestedSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreeIter as Gtk.TreeIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.Language as Pango.Language

#else
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Flags as GObject.Flags
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.TreeModel as Gtk.TreeModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Structs.RequestedSize as Gtk.RequestedSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.TreePath as Gtk.TreePath
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.Language as Pango.Language

#endif

-- function value_take_expression
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GValue` initialized with type `GTK_TYPE_EXPRESSION`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpression`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_value_take_expression" gtk_value_take_expression :: 
    Ptr GValue ->                           -- value : TGValue
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO ()

-- | Stores the given @GtkExpression@ inside @value@.
-- 
-- This function transfers the ownership of the @expression@ to the @GValue@.
valueTakeExpression ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Expression.IsExpression a) =>
    GValue
    -- ^ /@value@/: a @GValue@ initialized with type @GTK_TYPE_EXPRESSION@
    -> Maybe (a)
    -- ^ /@expression@/: a @GtkExpression@
    -> m ()
valueTakeExpression value expression = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- B.ManagedPtr.disownManagedPtr jExpression
            return jExpression'
    gtk_value_take_expression value' maybeExpression
    touchManagedPtr value
    whenJust expression touchManagedPtr
    return ()


-- function value_set_expression
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GValue` initialized with type `GTK_TYPE_EXPRESSION`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpression`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_value_set_expression" gtk_value_set_expression :: 
    Ptr GValue ->                           -- value : TGValue
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO ()

-- | Stores the given @GtkExpression@ inside @value@.
-- 
-- The @GValue@ will acquire a reference to the @expression@.
valueSetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Expression.IsExpression a) =>
    GValue
    -- ^ /@value@/: a @GValue@ initialized with type @GTK_TYPE_EXPRESSION@
    -> a
    -- ^ /@expression@/: a @GtkExpression@
    -> m ()
valueSetExpression value expression = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    expression' <- unsafeManagedPtrCastPtr expression
    gtk_value_set_expression value' expression'
    touchManagedPtr value
    touchManagedPtr expression
    return ()


-- function value_get_expression
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GValue` initialized with type `GTK_TYPE_EXPRESSION`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_value_get_expression" gtk_value_get_expression :: 
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr Gtk.Expression.Expression)

-- | Retrieves the @GtkExpression@ stored inside the given @value@.
valueGetExpression ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a @GValue@ initialized with type @GTK_TYPE_EXPRESSION@
    -> m (Maybe Gtk.Expression.Expression)
    -- ^ __Returns:__ a @GtkExpression@
valueGetExpression value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- gtk_value_get_expression value'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gtk.Expression.Expression) result'
        return result''
    touchManagedPtr value
    return maybeResult


-- function value_dup_expression
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GValue` initialized with type `GTK_TYPE_EXPRESSION`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_value_dup_expression" gtk_value_dup_expression :: 
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr Gtk.Expression.Expression)

-- | Retrieves the @GtkExpression@ stored inside the given @value@, and acquires
-- a reference to it.
valueDupExpression ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a @GValue@ initialized with type @GTK_TYPE_EXPRESSION@
    -> m (Maybe Gtk.Expression.Expression)
    -- ^ __Returns:__ a @GtkExpression@
valueDupExpression value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- gtk_value_dup_expression value'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapPtr Gtk.Expression.Expression) result'
        return result''
    touchManagedPtr value
    return maybeResult


-- function tree_get_row_drag_data
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GValue`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tree_model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "row in @tree_model" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_get_row_drag_data" gtk_tree_get_row_drag_data :: 
    Ptr GValue ->                           -- value : TGValue
    Ptr (Ptr Gtk.TreeModel.TreeModel) ->    -- tree_model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    Ptr (Ptr Gtk.TreePath.TreePath) ->      -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO CInt

{-# DEPRECATED treeGetRowDragData ["(Since version 4.10)","Use list models instead"] #-}
-- | Obtains a /@treeModel@/ and /@path@/ from value of target type
-- @/GTK_TYPE_TREE_ROW_DATA/@.
-- 
-- The returned path must be freed with 'GI.Gtk.Structs.TreePath.treePathFree'.
treeGetRowDragData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a @GValue@
    -> m ((Bool, Maybe Gtk.TreeModel.TreeModel, Maybe Gtk.TreePath.TreePath))
    -- ^ __Returns:__ 'P.True' if /@selectionData@/ had target type @/GTK_TYPE_TREE_ROW_DATA/@
    --  is otherwise valid
treeGetRowDragData value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    treeModel <- callocMem :: IO (Ptr (Ptr Gtk.TreeModel.TreeModel))
    path <- callocMem :: IO (Ptr (Ptr Gtk.TreePath.TreePath))
    result <- gtk_tree_get_row_drag_data value' treeModel path
    let result' = (/= 0) result
    treeModel' <- peek treeModel
    maybeTreeModel' <- convertIfNonNull treeModel' $ \treeModel'' -> do
        treeModel''' <- (newObject Gtk.TreeModel.TreeModel) treeModel''
        return treeModel'''
    path' <- peek path
    maybePath' <- convertIfNonNull path' $ \path'' -> do
        path''' <- (wrapBoxed Gtk.TreePath.TreePath) path''
        return path'''
    touchManagedPtr value
    freeMem treeModel
    freeMem path
    return (result', maybeTreeModel', maybePath')


-- function tree_create_row_drag_content
-- Args: [ Arg
--           { argCName = "tree_model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreePath" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a row in @tree_model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentProvider" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_create_row_drag_content" gtk_tree_create_row_drag_content :: 
    Ptr Gtk.TreeModel.TreeModel ->          -- tree_model : TInterface (Name {namespace = "Gtk", name = "TreeModel"})
    Ptr Gtk.TreePath.TreePath ->            -- path : TInterface (Name {namespace = "Gtk", name = "TreePath"})
    IO (Ptr Gdk.ContentProvider.ContentProvider)

{-# DEPRECATED treeCreateRowDragContent ["(Since version 4.10)","Use list models instead"] #-}
-- | Creates a content provider for dragging /@path@/ from /@treeModel@/.
treeCreateRowDragContent ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TreeModel.IsTreeModel a) =>
    a
    -- ^ /@treeModel@/: a @GtkTreeModel@
    -> Gtk.TreePath.TreePath
    -- ^ /@path@/: a row in /@treeModel@/
    -> m Gdk.ContentProvider.ContentProvider
    -- ^ __Returns:__ a new @GdkContentProvider@
treeCreateRowDragContent treeModel path = liftIO $ do
    treeModel' <- unsafeManagedPtrCastPtr treeModel
    path' <- unsafeManagedPtrGetPtr path
    result <- gtk_tree_create_row_drag_content treeModel' path'
    checkUnexpectedReturnNULL "treeCreateRowDragContent" result
    result' <- (wrapObject Gdk.ContentProvider.ContentProvider) result
    touchManagedPtr treeModel
    touchManagedPtr path
    return result'


-- function test_widget_wait_for_draw
-- Args: [ Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to wait for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_widget_wait_for_draw" gtk_test_widget_wait_for_draw :: 
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Enters the main loop and waits for /@widget@/ to be “drawn”.
-- 
-- In this context that means it waits for the frame clock of
-- /@widget@/ to have run a full styling, layout and drawing cycle.
-- 
-- This function is intended to be used for syncing with actions that
-- depend on /@widget@/ relayouting or on interaction with the display
-- server.
testWidgetWaitForDraw ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Widget.IsWidget a) =>
    a
    -- ^ /@widget@/: the widget to wait for
    -> m ()
testWidgetWaitForDraw widget = liftIO $ do
    widget' <- unsafeManagedPtrCastPtr widget
    gtk_test_widget_wait_for_draw widget'
    touchManagedPtr widget
    return ()


-- function test_register_all_types
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_register_all_types" gtk_test_register_all_types :: 
    IO ()

-- | Force registration of all core GTK object types.
-- 
-- This allows to refer to any of those object types via
-- 'GI.GObject.Functions.typeFromName' after calling this function.
testRegisterAllTypes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
testRegisterAllTypes  = liftIO $ do
    gtk_test_register_all_types
    return ()


-- function test_list_all_types
-- Args: [ Arg
--           { argCName = "n_types"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store number of types"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) 0 (TBasicType TGType))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_list_all_types" gtk_test_list_all_types :: 
    Ptr Word32 ->                           -- n_types : TBasicType TUInt
    IO (Ptr CGType)

-- | Return the type ids that have been registered after
-- calling 'GI.Gtk.Functions.testRegisterAllTypes'.
testListAllTypes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (([GType], Word32))
    -- ^ __Returns:__ 
    --    0-terminated array of type ids
testListAllTypes  = liftIO $ do
    nTypes <- allocMem :: IO (Ptr Word32)
    result <- gtk_test_list_all_types nTypes
    checkUnexpectedReturnNULL "testListAllTypes" result
    result' <- (unpackMapZeroTerminatedStorableArray GType) result
    nTypes' <- peek nTypes
    freeMem nTypes
    return (result', nTypes')


-- function test_accessible_has_state
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Accessible" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessible`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessibleState`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_accessible_has_state" gtk_test_accessible_has_state :: 
    Ptr Gtk.Accessible.Accessible ->        -- accessible : TInterface (Name {namespace = "Gtk", name = "Accessible"})
    CUInt ->                                -- state : TInterface (Name {namespace = "Gtk", name = "AccessibleState"})
    IO CInt

-- | Checks whether the @GtkAccessible@ has /@state@/ set.
testAccessibleHasState ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Accessible.IsAccessible a) =>
    a
    -- ^ /@accessible@/: a @GtkAccessible@
    -> Gtk.Enums.AccessibleState
    -- ^ /@state@/: a @GtkAccessibleState@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@state@/ is set in the /@accessible@/
testAccessibleHasState accessible state = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    let state' = (fromIntegral . fromEnum) state
    result <- gtk_test_accessible_has_state accessible' state'
    let result' = (/= 0) result
    touchManagedPtr accessible
    return result'


-- function test_accessible_has_role
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Accessible" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessible`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "role"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleRole" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessibleRole`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_accessible_has_role" gtk_test_accessible_has_role :: 
    Ptr Gtk.Accessible.Accessible ->        -- accessible : TInterface (Name {namespace = "Gtk", name = "Accessible"})
    CUInt ->                                -- role : TInterface (Name {namespace = "Gtk", name = "AccessibleRole"})
    IO CInt

-- | Checks whether the @GtkAccessible:accessible-role@ of the accessible
-- is /@role@/.
testAccessibleHasRole ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Accessible.IsAccessible a) =>
    a
    -- ^ /@accessible@/: a @GtkAccessible@
    -> Gtk.Enums.AccessibleRole
    -- ^ /@role@/: a @GtkAccessibleRole@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the role matches
testAccessibleHasRole accessible role = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    let role' = (fromIntegral . fromEnum) role
    result <- gtk_test_accessible_has_role accessible' role'
    let result' = (/= 0) result
    touchManagedPtr accessible
    return result'


-- function test_accessible_has_relation
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Accessible" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessible`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "relation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleRelation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessibleRelation`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_accessible_has_relation" gtk_test_accessible_has_relation :: 
    Ptr Gtk.Accessible.Accessible ->        -- accessible : TInterface (Name {namespace = "Gtk", name = "Accessible"})
    CUInt ->                                -- relation : TInterface (Name {namespace = "Gtk", name = "AccessibleRelation"})
    IO CInt

-- | Checks whether the @GtkAccessible@ has /@relation@/ set.
testAccessibleHasRelation ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Accessible.IsAccessible a) =>
    a
    -- ^ /@accessible@/: a @GtkAccessible@
    -> Gtk.Enums.AccessibleRelation
    -- ^ /@relation@/: a @GtkAccessibleRelation@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@relation@/ is set in the /@accessible@/
testAccessibleHasRelation accessible relation = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    let relation' = (fromIntegral . fromEnum) relation
    result <- gtk_test_accessible_has_relation accessible' relation'
    let result' = (/= 0) result
    touchManagedPtr accessible
    return result'


-- function test_accessible_has_property
-- Args: [ Arg
--           { argCName = "accessible"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Accessible" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessible`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleProperty" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessibleProperty`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_accessible_has_property" gtk_test_accessible_has_property :: 
    Ptr Gtk.Accessible.Accessible ->        -- accessible : TInterface (Name {namespace = "Gtk", name = "Accessible"})
    CUInt ->                                -- property : TInterface (Name {namespace = "Gtk", name = "AccessibleProperty"})
    IO CInt

-- | Checks whether the @GtkAccessible@ has /@property@/ set.
testAccessibleHasProperty ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Accessible.IsAccessible a) =>
    a
    -- ^ /@accessible@/: a @GtkAccessible@
    -> Gtk.Enums.AccessibleProperty
    -- ^ /@property@/: a @GtkAccessibleProperty@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@property@/ is set in the /@accessible@/
testAccessibleHasProperty accessible property = liftIO $ do
    accessible' <- unsafeManagedPtrCastPtr accessible
    let property' = (fromIntegral . fromEnum) property
    result <- gtk_test_accessible_has_property accessible' property'
    let result' = (/= 0) result
    touchManagedPtr accessible
    return result'


-- function test_accessible_assertion_message_role
-- Args: [ Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a domain" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the line in @file" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a function name in @file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expr"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expression being tested"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accessible"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Accessible" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAccessible`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expected_role"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleRole" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expected `GtkAccessibleRole`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "actual_role"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleRole" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the actual `GtkAccessibleRole`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_test_accessible_assertion_message_role" gtk_test_accessible_assertion_message_role :: 
    CString ->                              -- domain : TBasicType TUTF8
    CString ->                              -- file : TBasicType TUTF8
    Int32 ->                                -- line : TBasicType TInt
    CString ->                              -- func : TBasicType TUTF8
    CString ->                              -- expr : TBasicType TUTF8
    Ptr Gtk.Accessible.Accessible ->        -- accessible : TInterface (Name {namespace = "Gtk", name = "Accessible"})
    CUInt ->                                -- expected_role : TInterface (Name {namespace = "Gtk", name = "AccessibleRole"})
    CUInt ->                                -- actual_role : TInterface (Name {namespace = "Gtk", name = "AccessibleRole"})
    IO ()

-- | Prints an assertion message for @/gtk_test_accessible_assert_role()/@.
testAccessibleAssertionMessageRole ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Accessible.IsAccessible a) =>
    T.Text
    -- ^ /@domain@/: a domain
    -> T.Text
    -- ^ /@file@/: a file name
    -> Int32
    -- ^ /@line@/: the line in /@file@/
    -> T.Text
    -- ^ /@func@/: a function name in /@file@/
    -> T.Text
    -- ^ /@expr@/: the expression being tested
    -> a
    -- ^ /@accessible@/: a @GtkAccessible@
    -> Gtk.Enums.AccessibleRole
    -- ^ /@expectedRole@/: the expected @GtkAccessibleRole@
    -> Gtk.Enums.AccessibleRole
    -- ^ /@actualRole@/: the actual @GtkAccessibleRole@
    -> m ()
testAccessibleAssertionMessageRole domain file line func expr accessible expectedRole actualRole = liftIO $ do
    domain' <- textToCString domain
    file' <- textToCString file
    func' <- textToCString func
    expr' <- textToCString expr
    accessible' <- unsafeManagedPtrCastPtr accessible
    let expectedRole' = (fromIntegral . fromEnum) expectedRole
    let actualRole' = (fromIntegral . fromEnum) actualRole
    gtk_test_accessible_assertion_message_role domain' file' line func' expr' accessible' expectedRole' actualRole'
    touchManagedPtr accessible
    freeMem domain'
    freeMem file'
    freeMem func'
    freeMem expr'
    return ()


-- function show_uri_full_finish
-- Args: [ Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkWindow` passed to gtk_show_uri()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "`GAsyncResult` that was passed to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_show_uri_full_finish" gtk_show_uri_full_finish :: 
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED showUriFullFinish ["(Since version 4.10)","Use 'GI.Gtk.Objects.FileLauncher.fileLauncherLaunch' or","  'GI.Gtk.Objects.UriLauncher.uriLauncherLaunch' instead"] #-}
-- | Finishes the 'GI.Gtk.Functions.showUri' call and returns the result
-- of the operation.
showUriFullFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@parent@/: the @GtkWindow@ passed to 'GI.Gtk.Functions.showUri'
    -> b
    -- ^ /@result@/: @GAsyncResult@ that was passed to /@callback@/
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
showUriFullFinish parent result_ = liftIO $ do
    parent' <- unsafeManagedPtrCastPtr parent
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ gtk_show_uri_full_finish parent' result_'
        touchManagedPtr parent
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )


-- function show_uri_full
-- Args: [ Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the uri to show" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp from the event that triggered this call, or %GDK_CURRENT_TIME"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GCancellable` to cancel the launch"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a callback to call when the action is complete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_show_uri_full" gtk_show_uri_full :: 
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    CString ->                              -- uri : TBasicType TUTF8
    Word32 ->                               -- timestamp : TBasicType TUInt32
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

{-# DEPRECATED showUriFull ["(Since version 4.10)","Use 'GI.Gtk.Objects.FileLauncher.fileLauncherLaunch' or","  'GI.Gtk.Objects.UriLauncher.uriLauncherLaunch' instead"] #-}
-- | This function launches the default application for showing
-- a given uri.
-- 
-- The /@callback@/ will be called when the launch is completed.
-- 
-- This is the recommended call to be used as it passes information
-- necessary for sandbox helpers to parent their dialogs properly.
showUriFull ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a, Gio.Cancellable.IsCancellable b) =>
    Maybe (a)
    -- ^ /@parent@/: parent window
    -> T.Text
    -- ^ /@uri@/: the uri to show
    -> Word32
    -- ^ /@timestamp@/: timestamp from the event that triggered this call, or 'GI.Gdk.Constants.CURRENT_TIME'
    -> Maybe (b)
    -- ^ /@cancellable@/: a @GCancellable@ to cancel the launch
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a callback to call when the action is complete
    -> m ()
showUriFull parent uri timestamp cancellable callback = liftIO $ do
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    uri' <- textToCString uri
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gtk_show_uri_full maybeParent uri' timestamp maybeCancellable maybeCallback userData
    whenJust parent touchManagedPtr
    whenJust cancellable touchManagedPtr
    freeMem uri'
    return ()


-- function show_uri
-- Args: [ Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the uri to show" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp from the event that triggered this call, or %GDK_CURRENT_TIME"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_show_uri" gtk_show_uri :: 
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    CString ->                              -- uri : TBasicType TUTF8
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

{-# DEPRECATED showUri ["(Since version 4.10)","Use 'GI.Gtk.Objects.FileLauncher.fileLauncherLaunch' or","  'GI.Gtk.Objects.UriLauncher.uriLauncherLaunch' instead"] #-}
-- | This function launches the default application for showing
-- a given uri, or shows an error dialog if that fails.
showUri ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a) =>
    Maybe (a)
    -- ^ /@parent@/: parent window
    -> T.Text
    -- ^ /@uri@/: the uri to show
    -> Word32
    -- ^ /@timestamp@/: timestamp from the event that triggered this call, or 'GI.Gdk.Constants.CURRENT_TIME'
    -> m ()
showUri parent uri timestamp = liftIO $ do
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    uri' <- textToCString uri
    gtk_show_uri maybeParent uri' timestamp
    whenJust parent touchManagedPtr
    freeMem uri'
    return ()


-- function set_debug_flags
-- Args: [ Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DebugFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the debug flags to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_set_debug_flags" gtk_set_debug_flags :: 
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "DebugFlags"})
    IO ()

-- | Sets the GTK debug flags.
setDebugFlags ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Gtk.Flags.DebugFlags]
    -- ^ /@flags@/: the debug flags to set
    -> m ()
setDebugFlags flags = liftIO $ do
    let flags' = gflagsToWord flags
    gtk_set_debug_flags flags'
    return ()


-- function rgb_to_hsv
-- Args: [ Arg
--           { argCName = "r"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Just "Red" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "g"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Green" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Just "Blue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "h"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return value for the hue component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "s"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return value for the saturation component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "v"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return value for the value component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_rgb_to_hsv" gtk_rgb_to_hsv :: 
    CFloat ->                               -- r : TBasicType TFloat
    CFloat ->                               -- g : TBasicType TFloat
    CFloat ->                               -- b : TBasicType TFloat
    Ptr CFloat ->                           -- h : TBasicType TFloat
    Ptr CFloat ->                           -- s : TBasicType TFloat
    Ptr CFloat ->                           -- v : TBasicType TFloat
    IO ()

-- | Converts a color from RGB space to HSV.
-- 
-- Input values must be in the [0.0, 1.0] range;
-- output values will be in the same range.
rgbToHsv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Float
    -- ^ /@r@/: Red
    -> Float
    -- ^ /@g@/: Green
    -> Float
    -- ^ /@b@/: Blue
    -> m ((Float, Float, Float))
rgbToHsv r g b = liftIO $ do
    let r' = realToFrac r
    let g' = realToFrac g
    let b' = realToFrac b
    h <- allocMem :: IO (Ptr CFloat)
    s <- allocMem :: IO (Ptr CFloat)
    v <- allocMem :: IO (Ptr CFloat)
    gtk_rgb_to_hsv r' g' b' h s v
    h' <- peek h
    let h'' = realToFrac h'
    s' <- peek s
    let s'' = realToFrac s'
    v' <- peek v
    let v'' = realToFrac v'
    freeMem h
    freeMem s
    freeMem v
    return (h'', s'', v'')


-- function render_option
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_option" gtk_render_option :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderOption ["(Since version 4.10)"] #-}
-- | Renders an option mark (as in a radio button), the 'GI.Gtk.Flags.StateFlagsChecked'
-- state will determine whether the option is on or off, and
-- 'GI.Gtk.Flags.StateFlagsInconsistent' whether it should be marked as undefined.
-- 
-- Typical option mark rendering:
-- 
-- <<https://docs.gtk.org/gtk4/options.png>>
renderOption ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderOption context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_option context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_line
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x0"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate for the origin of the line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y0"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate for the origin of the line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x1"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X coordinate for the end of the line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y1"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y coordinate for the end of the line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_line" gtk_render_line :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x0 : TBasicType TDouble
    CDouble ->                              -- y0 : TBasicType TDouble
    CDouble ->                              -- x1 : TBasicType TDouble
    CDouble ->                              -- y1 : TBasicType TDouble
    IO ()

{-# DEPRECATED renderLine ["(Since version 4.10)"] #-}
-- | Renders a line from (x0, y0) to (x1, y1).
renderLine ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x0@/: X coordinate for the origin of the line
    -> Double
    -- ^ /@y0@/: Y coordinate for the origin of the line
    -> Double
    -- ^ /@x1@/: X coordinate for the end of the line
    -> Double
    -- ^ /@y1@/: Y coordinate for the end of the line
    -> m ()
renderLine context cr x0 y0 x1 y1 = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x0' = realToFrac x0
    let y0' = realToFrac y0
    let x1' = realToFrac x1
    let y1' = realToFrac y1
    gtk_render_line context' cr' x0' y0' x1' y1'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_layout
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Layout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `PangoLayout` to render"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_layout" gtk_render_layout :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    Ptr Pango.Layout.Layout ->              -- layout : TInterface (Name {namespace = "Pango", name = "Layout"})
    IO ()

{-# DEPRECATED renderLayout ["(Since version 4.10)"] #-}
-- | Renders /@layout@/ on the coordinates /@x@/, /@y@/
renderLayout ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a, Pango.Layout.IsLayout b) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin
    -> Double
    -- ^ /@y@/: Y origin
    -> b
    -- ^ /@layout@/: the @PangoLayout@ to render
    -> m ()
renderLayout context cr x y layout = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    layout' <- unsafeManagedPtrCastPtr layout
    gtk_render_layout context' cr' x' y' layout'
    touchManagedPtr context
    touchManagedPtr cr
    touchManagedPtr layout
    return ()


-- function render_icon
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "texture"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Texture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkTexture` containing the icon to draw"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X position for the @texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y position for the @texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_icon" gtk_render_icon :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Texture.Texture ->              -- texture : TInterface (Name {namespace = "Gdk", name = "Texture"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    IO ()

{-# DEPRECATED renderIcon ["(Since version 4.10)"] #-}
-- | Renders the icon in /@texture@/ at the specified /@x@/ and /@y@/ coordinates.
-- 
-- This function will render the icon in /@texture@/ at exactly its size,
-- regardless of scaling factors, which may not be appropriate when
-- drawing on displays with high pixel densities.
renderIcon ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a, Gdk.Texture.IsTexture b) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> b
    -- ^ /@texture@/: a @GdkTexture@ containing the icon to draw
    -> Double
    -- ^ /@x@/: X position for the /@texture@/
    -> Double
    -- ^ /@y@/: Y position for the /@texture@/
    -> m ()
renderIcon context cr texture x y = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    texture' <- unsafeManagedPtrCastPtr texture
    let x' = realToFrac x
    let y' = realToFrac y
    gtk_render_icon context' cr' texture' x' y'
    touchManagedPtr context
    touchManagedPtr cr
    touchManagedPtr texture
    return ()


-- function render_handle
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_handle" gtk_render_handle :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderHandle ["(Since version 4.10)"] #-}
-- | Renders a handle (as in @GtkPaned@ and @GtkWindow@’s resize grip),
-- in the rectangle determined by /@x@/, /@y@/, /@width@/, /@height@/.
-- 
-- Handles rendered for the paned and grip classes:
-- 
-- <<https://docs.gtk.org/gtk4/handles.png>>
renderHandle ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderHandle context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_handle context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_frame
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_frame" gtk_render_frame :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderFrame ["(Since version 4.10)"] #-}
-- | Renders a frame around the rectangle defined by /@x@/, /@y@/, /@width@/, /@height@/.
-- 
-- Examples of frame rendering, showing the effect of @border-image@,
-- @border-color@, @border-width@, @border-radius@ and junctions:
-- 
-- <<https://docs.gtk.org/gtk4/frames.png>>
renderFrame ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderFrame context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_frame context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_focus
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_focus" gtk_render_focus :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderFocus ["(Since version 4.10)"] #-}
-- | Renders a focus indicator on the rectangle determined by /@x@/, /@y@/, /@width@/, /@height@/.
-- 
-- Typical focus rendering:
-- 
-- <<https://docs.gtk.org/gtk4/focus.png>>
renderFocus ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderFocus context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_focus context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_expander
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_expander" gtk_render_expander :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderExpander ["(Since version 4.10)"] #-}
-- | Renders an expander (as used in @GtkTreeView@ and @GtkExpander@) in the area
-- defined by /@x@/, /@y@/, /@width@/, /@height@/. The state 'GI.Gtk.Flags.StateFlagsChecked'
-- determines whether the expander is collapsed or expanded.
-- 
-- Typical expander rendering:
-- 
-- <<https://docs.gtk.org/gtk4/expanders.png>>
renderExpander ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderExpander context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_expander context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_check
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_check" gtk_render_check :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderCheck ["(Since version 4.10)"] #-}
-- | Renders a checkmark (as in a @GtkCheckButton@).
-- 
-- The 'GI.Gtk.Flags.StateFlagsChecked' state determines whether the check is
-- on or off, and 'GI.Gtk.Flags.StateFlagsInconsistent' determines whether it
-- should be marked as undefined.
-- 
-- Typical checkmark rendering:
-- 
-- <<https://docs.gtk.org/gtk4/checks.png>>
renderCheck ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderCheck context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_check context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_background
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_background" gtk_render_background :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderBackground ["(Since version 4.10)"] #-}
-- | Renders the background of an element.
-- 
-- Typical background rendering, showing the effect of
-- @background-image@, @border-width@ and @border-radius@:
-- 
-- <<https://docs.gtk.org/gtk4/background.png>>
renderBackground ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderBackground context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_background context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_arrow
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "angle"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "arrow angle from 0 to 2 * %G_PI, being 0 the arrow pointing to the north"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the render area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the render area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "square side for render area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_arrow" gtk_render_arrow :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- angle : TBasicType TDouble
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- size : TBasicType TDouble
    IO ()

{-# DEPRECATED renderArrow ["(Since version 4.10)"] #-}
-- | Renders an arrow pointing to /@angle@/.
-- 
-- Typical arrow rendering at 0, 1⁄2 π;, π; and 3⁄2 π:
-- 
-- <<https://docs.gtk.org/gtk4/arrows.png>>
renderArrow ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@angle@/: arrow angle from 0 to 2 * 'GI.GLib.Constants.PI', being 0 the arrow pointing to the north
    -> Double
    -- ^ /@x@/: X origin of the render area
    -> Double
    -- ^ /@y@/: Y origin of the render area
    -> Double
    -- ^ /@size@/: square side for render area
    -> m ()
renderArrow context cr angle x y size = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let angle' = realToFrac angle
    let x' = realToFrac x
    let y' = realToFrac y
    let size' = realToFrac size
    gtk_render_arrow context' cr' angle' x' y' size'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function render_activity
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStyleContext`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `cairo_t`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y origin of the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle width" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle height" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_render_activity" gtk_render_activity :: 
    Ptr Gtk.StyleContext.StyleContext ->    -- context : TInterface (Name {namespace = "Gtk", name = "StyleContext"})
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    CDouble ->                              -- width : TBasicType TDouble
    CDouble ->                              -- height : TBasicType TDouble
    IO ()

{-# DEPRECATED renderActivity ["(Since version 4.10)"] #-}
-- | Renders an activity indicator (such as in @GtkSpinner@).
-- The state 'GI.Gtk.Flags.StateFlagsChecked' determines whether there is
-- activity going on.
renderActivity ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleContext.IsStyleContext a) =>
    a
    -- ^ /@context@/: a @GtkStyleContext@
    -> Cairo.Context.Context
    -- ^ /@cr@/: a @cairo_t@
    -> Double
    -- ^ /@x@/: X origin of the rectangle
    -> Double
    -- ^ /@y@/: Y origin of the rectangle
    -> Double
    -- ^ /@width@/: rectangle width
    -> Double
    -- ^ /@height@/: rectangle height
    -> m ()
renderActivity context cr x y width height = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    cr' <- unsafeManagedPtrGetPtr cr
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    gtk_render_activity context' cr' x' y' width' height'
    touchManagedPtr context
    touchManagedPtr cr
    return ()


-- function print_run_page_setup_dialog_async
-- Args: [ Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transient parent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_setup"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSetup" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an existing `GtkPageSetup`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "settings"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintSettings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintSettings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "done_cb"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSetupDoneFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a function to call when the user saves\n   the modified page setup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @done_cb"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_run_page_setup_dialog_async" gtk_print_run_page_setup_dialog_async :: 
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gtk.PageSetup.PageSetup ->          -- page_setup : TInterface (Name {namespace = "Gtk", name = "PageSetup"})
    Ptr Gtk.PrintSettings.PrintSettings ->  -- settings : TInterface (Name {namespace = "Gtk", name = "PrintSettings"})
    FunPtr Gtk.Callbacks.C_PageSetupDoneFunc -> -- done_cb : TInterface (Name {namespace = "Gtk", name = "PageSetupDoneFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Runs a page setup dialog, letting the user modify the values from /@pageSetup@/.
-- 
-- In contrast to 'GI.Gtk.Functions.printRunPageSetupDialog', this function  returns
-- after showing the page setup dialog on platforms that support this, and calls
-- /@doneCb@/ from a signal handler for the [response](#g:signal:response) signal of the dialog.
printRunPageSetupDialogAsync ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a, Gtk.PageSetup.IsPageSetup b, Gtk.PrintSettings.IsPrintSettings c) =>
    Maybe (a)
    -- ^ /@parent@/: transient parent
    -> Maybe (b)
    -- ^ /@pageSetup@/: an existing @GtkPageSetup@
    -> c
    -- ^ /@settings@/: a @GtkPrintSettings@
    -> Gtk.Callbacks.PageSetupDoneFunc
    -- ^ /@doneCb@/: a function to call when the user saves
    --    the modified page setup
    -> m ()
printRunPageSetupDialogAsync parent pageSetup settings doneCb = liftIO $ do
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    maybePageSetup <- case pageSetup of
        Nothing -> return FP.nullPtr
        Just jPageSetup -> do
            jPageSetup' <- unsafeManagedPtrCastPtr jPageSetup
            return jPageSetup'
    settings' <- unsafeManagedPtrCastPtr settings
    ptrdoneCb <- callocMem :: IO (Ptr (FunPtr Gtk.Callbacks.C_PageSetupDoneFunc))
    doneCb' <- Gtk.Callbacks.mk_PageSetupDoneFunc (Gtk.Callbacks.wrap_PageSetupDoneFunc (Just ptrdoneCb) (Gtk.Callbacks.drop_closures_PageSetupDoneFunc doneCb))
    poke ptrdoneCb doneCb'
    let data_ = nullPtr
    gtk_print_run_page_setup_dialog_async maybeParent maybePageSetup settings' doneCb' data_
    whenJust parent touchManagedPtr
    whenJust pageSetup touchManagedPtr
    touchManagedPtr settings
    return ()


-- function print_run_page_setup_dialog
-- Args: [ Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "transient parent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_setup"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSetup" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an existing `GtkPageSetup`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "settings"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintSettings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintSettings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PageSetup" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_run_page_setup_dialog" gtk_print_run_page_setup_dialog :: 
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gtk.PageSetup.PageSetup ->          -- page_setup : TInterface (Name {namespace = "Gtk", name = "PageSetup"})
    Ptr Gtk.PrintSettings.PrintSettings ->  -- settings : TInterface (Name {namespace = "Gtk", name = "PrintSettings"})
    IO (Ptr Gtk.PageSetup.PageSetup)

-- | Runs a page setup dialog, letting the user modify the values from /@pageSetup@/.
-- 
-- If the user cancels the dialog, the returned @GtkPageSetup@ is identical
-- to the passed in /@pageSetup@/, otherwise it contains the modifications
-- done in the dialog.
-- 
-- Note that this function may use a recursive mainloop to show the page
-- setup dialog. See 'GI.Gtk.Functions.printRunPageSetupDialogAsync' if this is
-- a problem.
printRunPageSetupDialog ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a, Gtk.PageSetup.IsPageSetup b, Gtk.PrintSettings.IsPrintSettings c) =>
    Maybe (a)
    -- ^ /@parent@/: transient parent
    -> Maybe (b)
    -- ^ /@pageSetup@/: an existing @GtkPageSetup@
    -> c
    -- ^ /@settings@/: a @GtkPrintSettings@
    -> m Gtk.PageSetup.PageSetup
    -- ^ __Returns:__ a new @GtkPageSetup@
printRunPageSetupDialog parent pageSetup settings = liftIO $ do
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    maybePageSetup <- case pageSetup of
        Nothing -> return FP.nullPtr
        Just jPageSetup -> do
            jPageSetup' <- unsafeManagedPtrCastPtr jPageSetup
            return jPageSetup'
    settings' <- unsafeManagedPtrCastPtr settings
    result <- gtk_print_run_page_setup_dialog maybeParent maybePageSetup settings'
    checkUnexpectedReturnNULL "printRunPageSetupDialog" result
    result' <- (wrapObject Gtk.PageSetup.PageSetup) result
    whenJust parent touchManagedPtr
    whenJust pageSetup touchManagedPtr
    touchManagedPtr settings
    return result'


-- function param_spec_expression
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a user-readable name for the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a user-readable description of the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "gtk_param_spec_expression" gtk_param_spec_expression :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new @GParamSpec@ instance for a property holding a @GtkExpression@.
-- 
-- See @g_param_spec_internal()@ for details on the property strings.
paramSpecExpression ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property
    -> T.Text
    -- ^ /@nick@/: a user-readable name for the property
    -> T.Text
    -- ^ /@blurb@/: a user-readable description of the property
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property
    -> m GParamSpec
    -- ^ __Returns:__ a newly created property specification
paramSpecExpression name nick blurb flags = liftIO $ do
    name' <- textToCString name
    nick' <- textToCString nick
    blurb' <- textToCString blurb
    let flags' = gflagsToWord flags
    result <- gtk_param_spec_expression name' nick' blurb' flags'
    checkUnexpectedReturnNULL "paramSpecExpression" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem nick'
    freeMem blurb'
    return result'


-- function is_initialized
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_is_initialized" gtk_is_initialized :: 
    IO CInt

-- | Returns whether GTK has been initialized.
-- 
-- See 'GI.Gtk.Functions.init'.
isInitialized ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ the initialization status
isInitialized  = liftIO $ do
    result <- gtk_is_initialized
    let result' = (/= 0) result
    return result'


-- function init_check
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_init_check" gtk_init_check :: 
    IO CInt

-- | Initializes GTK.
-- 
-- This function does the same work as 'GI.Gtk.Functions.init' with only a
-- single change: It does not terminate the program if the windowing
-- system can’t be initialized. Instead it returns false on failure.
-- 
-- This way the application can fall back to some other means of
-- communication with the user - for example a curses or command line
-- interface.
initCheck ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ true if the windowing system has been successfully
    --   initialized, false otherwise
initCheck  = liftIO $ do
    result <- gtk_init_check
    let result' = (/= 0) result
    return result'


-- function init
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_init" gtk_init :: 
    IO ()

-- | Initializes GTK.
-- 
-- This function must be called before using any other GTK functions
-- in your GUI applications.
-- 
-- It will initialize everything needed to operate the toolkit. In particular,
-- it will open the default display (see [func/@gdk@/.Display.get_default]).
-- 
-- If you are using t'GI.Gtk.Objects.Application.Application', you usually don\'t have to call this
-- function; the t'GI.Gio.Objects.Application.Application'.@/startup/@() handler does it for you. Though,
-- if you are using @GApplication@ methods that will be invoked before @startup@,
-- such as @local_command_line@, you may need to initialize GTK explicitly.
-- 
-- This function will terminate your program if it was unable to initialize
-- the windowing system for some reason. If you want your program to fall back
-- to a textual interface, call 'GI.Gtk.Functions.initCheck' instead.
-- 
-- GTK calls @signal (SIGPIPE, SIG_IGN)@ during initialization, to ignore
-- SIGPIPE signals, since these are almost never wanted in graphical
-- applications. If you do need to handle SIGPIPE for some reason, reset
-- the handler after 'GI.Gtk.Functions.init', but notice that other libraries (e.g.
-- libdbus or gvfs) might do similar things.
init ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
init  = liftIO $ do
    gtk_init
    return ()


-- function hsv_to_rgb
-- Args: [ Arg
--           { argCName = "h"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Just "Hue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Saturation" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "r"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return value for the red component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "g"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return value for the green component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TFloat
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return value for the blue component"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_hsv_to_rgb" gtk_hsv_to_rgb :: 
    CFloat ->                               -- h : TBasicType TFloat
    CFloat ->                               -- s : TBasicType TFloat
    CFloat ->                               -- v : TBasicType TFloat
    Ptr CFloat ->                           -- r : TBasicType TFloat
    Ptr CFloat ->                           -- g : TBasicType TFloat
    Ptr CFloat ->                           -- b : TBasicType TFloat
    IO ()

-- | Converts a color from HSV space to RGB.
-- 
-- Input values must be in the [0.0, 1.0] range;
-- output values will be in the same range.
hsvToRgb ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Float
    -- ^ /@h@/: Hue
    -> Float
    -- ^ /@s@/: Saturation
    -> Float
    -- ^ /@v@/: Value
    -> m ((Float, Float, Float))
hsvToRgb h s v = liftIO $ do
    let h' = realToFrac h
    let s' = realToFrac s
    let v' = realToFrac v
    r <- allocMem :: IO (Ptr CFloat)
    g <- allocMem :: IO (Ptr CFloat)
    b <- allocMem :: IO (Ptr CFloat)
    gtk_hsv_to_rgb h' s' v' r g b
    r' <- peek r
    let r'' = realToFrac r'
    g' <- peek g
    let g'' = realToFrac g'
    b' <- peek b
    let b'' = realToFrac b'
    freeMem r
    freeMem g
    freeMem b
    return (r'', g'', b'')


-- function get_minor_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_minor_version" gtk_get_minor_version :: 
    IO Word32

-- | Returns the minor version number of the GTK library.
-- 
-- For example, in GTK version 3.1.5 this is 1.
-- 
-- This function is in the library, so it represents the GTK library
-- your code is are running against. Contrast with the
-- 'GI.Gtk.Constants.MINOR_VERSION' macro, which represents the minor version of the
-- GTK headers you have included when compiling your code.
getMinorVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the minor version number of the GTK library
getMinorVersion  = liftIO $ do
    result <- gtk_get_minor_version
    return result


-- function get_micro_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_micro_version" gtk_get_micro_version :: 
    IO Word32

-- | Returns the micro version number of the GTK library.
-- 
-- For example, in GTK version 3.1.5 this is 5.
-- 
-- This function is in the library, so it represents the GTK library
-- your code is are running against. Contrast with the
-- 'GI.Gtk.Constants.MICRO_VERSION' macro, which represents the micro version of the
-- GTK headers you have included when compiling your code.
getMicroVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the micro version number of the GTK library
getMicroVersion  = liftIO $ do
    result <- gtk_get_micro_version
    return result


-- function get_major_version
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_major_version" gtk_get_major_version :: 
    IO Word32

-- | Returns the major version number of the GTK library.
-- 
-- For example, in GTK version 3.1.5 this is 3.
-- 
-- This function is in the library, so it represents the GTK library
-- your code is running against. Contrast with the 'GI.Gtk.Constants.MAJOR_VERSION'
-- macro, which represents the major version of the GTK headers you
-- have included when compiling your code.
getMajorVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the major version number of the GTK library
getMajorVersion  = liftIO $ do
    result <- gtk_get_major_version
    return result


-- function get_locale_direction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "TextDirection" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_locale_direction" gtk_get_locale_direction :: 
    IO CUInt

-- | Gets the direction of the current locale.
-- 
-- This is the expected reading direction for text and UI.
-- 
-- This function depends on the current locale being set with
-- @setlocale()@ and will default to setting the @GTK_TEXT_DIR_LTR@
-- direction otherwise. @GTK_TEXT_DIR_NONE@ will never be returned.
-- 
-- GTK sets the default text direction according to the locale during
-- 'GI.Gtk.Functions.init', and you should normally use 'GI.Gtk.Objects.Widget.widgetGetDirection'
-- or [func/@gtk@/.Widget.get_default_direction] to obtain the current direction.
-- 
-- This function is only needed rare cases when the locale is
-- changed after GTK has already been initialized. In this case,
-- you can use it to update the default text direction as follows:
-- 
-- 
-- === /c code/
-- >#include <locale.h>
-- >
-- >static void
-- >update_locale (const char *new_locale)
-- >{
-- >  setlocale (LC_ALL, new_locale);
-- >  gtk_widget_set_default_direction (gtk_get_locale_direction ());
-- >}
getLocaleDirection ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Gtk.Enums.TextDirection
    -- ^ __Returns:__ the direction of the current locale
getLocaleDirection  = liftIO $ do
    result <- gtk_get_locale_direction
    let result' = (toEnum . fromIntegral) result
    return result'


-- function get_interface_age
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_interface_age" gtk_get_interface_age :: 
    IO Word32

-- | Returns the interface age as passed to @libtool@.
-- 
-- If @libtool@ means nothing to you, don\'t worry about it.
getInterfaceAge ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the interface age of the GTK library
getInterfaceAge  = liftIO $ do
    result <- gtk_get_interface_age
    return result


-- function get_default_language
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Language" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_default_language" gtk_get_default_language :: 
    IO (Ptr Pango.Language.Language)

-- | Returns the @PangoLanguage@ for the default language
-- currently in effect.
-- 
-- Note that this can change over the life of an
-- application.
-- 
-- The default language is derived from the current
-- locale. It determines, for example, whether GTK uses
-- the right-to-left or left-to-right text direction.
-- 
-- This function is equivalent to [func/@pango@/.Language.get_default].
-- See that function for details.
getDefaultLanguage ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Pango.Language.Language
    -- ^ __Returns:__ the default language
getDefaultLanguage  = liftIO $ do
    result <- gtk_get_default_language
    checkUnexpectedReturnNULL "getDefaultLanguage" result
    result' <- (newBoxed Pango.Language.Language) result
    return result'


-- function get_debug_flags
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "DebugFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_debug_flags" gtk_get_debug_flags :: 
    IO CUInt

-- | Returns the GTK debug flags that are currently active.
-- 
-- This function is intended for GTK modules that want
-- to adjust their debug output based on GTK debug flags.
getDebugFlags ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Gtk.Flags.DebugFlags]
    -- ^ __Returns:__ the GTK debug flags.
getDebugFlags  = liftIO $ do
    result <- gtk_get_debug_flags
    let result' = wordToGFlags result
    return result'


-- function get_binary_age
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_get_binary_age" gtk_get_binary_age :: 
    IO Word32

-- | Returns the binary age as passed to @libtool@.
-- 
-- If @libtool@ means nothing to you, don\'t worry about it.
getBinaryAge ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the binary age of the GTK library
getBinaryAge  = liftIO $ do
    result <- gtk_get_binary_age
    return result


-- function enumerate_printers
-- Args: [ Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrinterFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a function to call for each printer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 2
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call if @data is no longer needed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wait"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if true, wait in a recursive mainloop until\n   all printers are enumerated; otherwise return early"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_enumerate_printers" gtk_enumerate_printers :: 
    FunPtr Gtk.Callbacks.C_PrinterFunc ->   -- func : TInterface (Name {namespace = "Gtk", name = "PrinterFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    CInt ->                                 -- wait : TBasicType TBoolean
    IO ()

-- | Calls a function for all printers that are known to GTK.
-- 
-- If /@func@/ returns true, the enumeration is stopped.
enumeratePrinters ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gtk.Callbacks.PrinterFunc
    -- ^ /@func@/: a function to call for each printer
    -> Bool
    -- ^ /@wait@/: if true, wait in a recursive mainloop until
    --    all printers are enumerated; otherwise return early
    -> m ()
enumeratePrinters func wait = liftIO $ do
    func' <- Gtk.Callbacks.mk_PrinterFunc (Gtk.Callbacks.wrap_PrinterFunc Nothing (Gtk.Callbacks.drop_closures_PrinterFunc func))
    let wait' = (P.fromIntegral . P.fromEnum) wait
    let data_ = castFunPtrToPtr func'
    let destroy = SP.safeFreeFunPtrPtr
    gtk_enumerate_printers func' data_ destroy wait'
    return ()


-- function distribute_natural_allocation
-- Args: [ Arg
--           { argCName = "extra_space"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Extra space to redistribute among children after subtracting\n  minimum sizes and any child padding from the overall allocation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_requested_sizes"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Number of requests to fit into the allocation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sizes"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Gtk" , name = "RequestedSize" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of structs with a client pointer and a minimum/natural size\n in the orientation of the allocation."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_requested_sizes"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "Number of requests to fit into the allocation"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_distribute_natural_allocation" gtk_distribute_natural_allocation :: 
    Int32 ->                                -- extra_space : TBasicType TInt
    Word32 ->                               -- n_requested_sizes : TBasicType TUInt
    Ptr Gtk.RequestedSize.RequestedSize ->  -- sizes : TCArray False (-1) 1 (TInterface (Name {namespace = "Gtk", name = "RequestedSize"}))
    IO Int32

-- | Distributes /@extraSpace@/ to child /@sizes@/ by bringing smaller
-- children up to natural size first.
-- 
-- The remaining space will be added to the /@minimumSize@/ member of the
-- @GtkRequestedSize@ struct. If all sizes reach their natural size then
-- the remaining space is returned.
distributeNaturalAllocation ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@extraSpace@/: Extra space to redistribute among children after subtracting
    --   minimum sizes and any child padding from the overall allocation
    -> [Gtk.RequestedSize.RequestedSize]
    -- ^ /@sizes@/: An array of structs with a client pointer and a minimum\/natural size
    --  in the orientation of the allocation.
    -> m Int32
    -- ^ __Returns:__ The remainder of /@extraSpace@/ after redistributing space
    -- to /@sizes@/.
distributeNaturalAllocation extraSpace sizes = liftIO $ do
    let nRequestedSizes = fromIntegral $ P.length sizes
    sizes' <- mapM unsafeManagedPtrGetPtr sizes
    sizes'' <- packBlockArray 16 sizes'
    result <- gtk_distribute_natural_allocation extraSpace nRequestedSizes sizes''
    mapM_ touchManagedPtr sizes
    freeMem sizes''
    return result


-- function disable_setlocale
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_disable_setlocale" gtk_disable_setlocale :: 
    IO ()

-- | Prevents 'GI.Gtk.Functions.init' and 'GI.Gtk.Functions.initCheck' from calling @setlocale()@.
-- 
-- You would want to use this function if you wanted to set the locale for
-- your program to something other than the user’s locale, or if you wanted
-- to set different values for different locale categories.
-- 
-- Most programs should not need to call this function.
disableSetlocale ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
disableSetlocale  = liftIO $ do
    gtk_disable_setlocale
    return ()


-- function disable_portals
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_disable_portals" gtk_disable_portals :: 
    IO ()

-- | Prevents GTK from using portals.
-- 
-- This is equivalent to setting @GDK_DEBUG=no-portals@ in the environment.
-- 
-- This should only be used in portal implementations, apps must not call it.
-- 
-- /Since: 4.18/
disablePortals ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
disablePortals  = liftIO $ do
    gtk_disable_portals
    return ()


-- function css_parser_warning_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_css_parser_warning_quark" gtk_css_parser_warning_quark :: 
    IO Word32

-- | Registers an error quark for CSS parsing warnings.
cssParserWarningQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the warning quark
cssParserWarningQuark  = liftIO $ do
    result <- gtk_css_parser_warning_quark
    return result


-- function css_parser_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_css_parser_error_quark" gtk_css_parser_error_quark :: 
    IO Word32

-- | Registers an error quark for CSS parsing errors.
cssParserErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ the error quark
cssParserErrorQuark  = liftIO $ do
    result <- gtk_css_parser_error_quark
    return result


-- function check_version
-- Args: [ Arg
--           { argCName = "required_major"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the required major version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "required_minor"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the required minor version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "required_micro"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the required micro version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_check_version" gtk_check_version :: 
    Word32 ->                               -- required_major : TBasicType TUInt
    Word32 ->                               -- required_minor : TBasicType TUInt
    Word32 ->                               -- required_micro : TBasicType TUInt
    IO CString

-- | Checks that the GTK library in use is compatible with the
-- given version.
-- 
-- Generally you would pass in the constants 'GI.Gtk.Constants.MAJOR_VERSION',
-- 'GI.Gtk.Constants.MINOR_VERSION', 'GI.Gtk.Constants.MICRO_VERSION' as the three arguments
-- to this function; that produces a check that the library in
-- use is compatible with the version of GTK the application or
-- module was compiled against.
-- 
-- Compatibility is defined by two things: first the version
-- of the running library is newer than the version
-- /@requiredMajor@/.required_minor./@requiredMicro@/. Second
-- the running library must be binary compatible with the
-- version /@requiredMajor@/.required_minor./@requiredMicro@/
-- (same major version.)
-- 
-- This function is primarily for GTK modules; the module
-- can call this function to check that it wasn’t loaded
-- into an incompatible version of GTK. However, such a
-- check isn’t completely reliable, since the module may be
-- linked against an old version of GTK and calling the
-- old version of 'GI.Gtk.Functions.checkVersion', but still get loaded
-- into an application using a newer version of GTK.
checkVersion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@requiredMajor@/: the required major version
    -> Word32
    -- ^ /@requiredMinor@/: the required minor version
    -> Word32
    -- ^ /@requiredMicro@/: the required micro version
    -> m (Maybe T.Text)
    -- ^ __Returns:__ 'P.Nothing' if the GTK library is compatible with the
    --   given version, or a string describing the version mismatch.
    --   The returned string is owned by GTK and should not be modified
    --   or freed.
checkVersion requiredMajor requiredMinor requiredMicro = liftIO $ do
    result <- gtk_check_version requiredMajor requiredMinor requiredMicro
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function accelerator_valid
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a GDK keyval" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "modifier mask" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_valid" gtk_accelerator_valid :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    CUInt ->                                -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Determines whether a given keyval and modifier mask constitute
-- a valid keyboard accelerator.
-- 
-- For example, the @GDK_KEY_a@ keyval plus @GDK_CONTROL_MASK@ mask is valid,
-- and matches the “Ctrl+a” accelerator. But, you can\'t, for instance, use
-- the @GDK_KEY_Control_L@ keyval as an accelerator.
acceleratorValid ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a GDK keyval
    -> [Gdk.Flags.ModifierType]
    -- ^ /@modifiers@/: modifier mask
    -> m Bool
    -- ^ __Returns:__ true if the accelerator is valid
acceleratorValid keyval modifiers = liftIO $ do
    let modifiers' = gflagsToWord modifiers
    result <- gtk_accelerator_valid keyval modifiers'
    let result' = (/= 0) result
    return result'


-- function accelerator_parse_with_keycode
-- Args: [ Arg
--           { argCName = "accelerator"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string representing an accelerator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GdkDisplay` to look up @accelerator_codes in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_key"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for accelerator keyval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "accelerator_codes"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "\n  return location for accelerator keycodes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "accelerator_mods"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for accelerator\n  modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_parse_with_keycode" gtk_accelerator_parse_with_keycode :: 
    CString ->                              -- accelerator : TBasicType TUTF8
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Word32 ->                           -- accelerator_key : TBasicType TUInt
    Ptr (Ptr Word32) ->                     -- accelerator_codes : TCArray True (-1) (-1) (TBasicType TUInt)
    Ptr CUInt ->                            -- accelerator_mods : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Parses a string representing an accelerator.
-- 
-- This is similar to 'GI.Gtk.Functions.acceleratorParse' but handles keycodes as
-- well. This is only useful for system-level components, applications should
-- use 'GI.Gtk.Functions.acceleratorParse' instead.
-- 
-- If /@acceleratorCodes@/ is given and the result stored in it is non-'P.Nothing',
-- the result must be freed with 'GI.GLib.Functions.free'.
-- 
-- If a keycode is present in the accelerator and no /@acceleratorCodes@/
-- is given, the parse will fail.
-- 
-- If the parse fails, /@acceleratorKey@/, /@acceleratorMods@/ and
-- /@acceleratorCodes@/ will be set to 0 (zero).
acceleratorParseWithKeycode ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    T.Text
    -- ^ /@accelerator@/: string representing an accelerator
    -> Maybe (a)
    -- ^ /@display@/: the @GdkDisplay@ to look up /@acceleratorCodes@/ in
    -> m ((Bool, Word32, [Word32], [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ true if parsing succeeded
acceleratorParseWithKeycode accelerator display = liftIO $ do
    accelerator' <- textToCString accelerator
    maybeDisplay <- case display of
        Nothing -> return FP.nullPtr
        Just jDisplay -> do
            jDisplay' <- unsafeManagedPtrCastPtr jDisplay
            return jDisplay'
    acceleratorKey <- allocMem :: IO (Ptr Word32)
    acceleratorCodes <- callocMem :: IO (Ptr (Ptr Word32))
    acceleratorMods <- allocMem :: IO (Ptr CUInt)
    result <- gtk_accelerator_parse_with_keycode accelerator' maybeDisplay acceleratorKey acceleratorCodes acceleratorMods
    let result' = (/= 0) result
    acceleratorKey' <- peek acceleratorKey
    acceleratorCodes' <- peek acceleratorCodes
    acceleratorCodes'' <- unpackZeroTerminatedStorableArray acceleratorCodes'
    freeMem acceleratorCodes'
    acceleratorMods' <- peek acceleratorMods
    let acceleratorMods'' = wordToGFlags acceleratorMods'
    whenJust display touchManagedPtr
    freeMem accelerator'
    freeMem acceleratorKey
    freeMem acceleratorCodes
    freeMem acceleratorMods
    return (result', acceleratorKey', acceleratorCodes'', acceleratorMods'')


-- function accelerator_parse
-- Args: [ Arg
--           { argCName = "accelerator"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string representing an accelerator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_key"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for accelerator keyval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "accelerator_mods"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for accelerator\n  modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_parse" gtk_accelerator_parse :: 
    CString ->                              -- accelerator : TBasicType TUTF8
    Ptr Word32 ->                           -- accelerator_key : TBasicType TUInt
    Ptr CUInt ->                            -- accelerator_mods : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Parses a string representing an accelerator.
-- 
-- The format looks like “@\<Control>a@” or “@\<Shift>\<Alt>F1@”.
-- 
-- The parser is fairly liberal and allows lower or upper case, and also
-- abbreviations such as “@\<Ctl>@” and “@\<Ctrl>@”.
-- 
-- Key names are parsed using 'GI.Gdk.Functions.keyvalFromName'. For character keys
-- the name is not the symbol, but the lowercase name, e.g. one would use
-- “@\<Ctrl>minus@” instead of “@\<Ctrl>-@”.
-- 
-- Modifiers are enclosed in angular brackets @\<>@, and match the
-- [flags/@gdk@/.ModifierType] mask:
-- 
-- * @\<Shift>@ for @GDK_SHIFT_MASK@
-- * @\<Ctrl>@ for @GDK_CONTROL_MASK@
-- * @\<Alt>@ for @GDK_ALT_MASK@
-- * @\<Meta>@ for @GDK_META_MASK@
-- * @\<Super>@ for @GDK_SUPER_MASK@
-- * @\<Hyper>@ for @GDK_HYPER_MASK@
-- 
-- 
-- If the parse operation fails, /@acceleratorKey@/ and /@acceleratorMods@/ will
-- be set to 0 (zero).
acceleratorParse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@accelerator@/: string representing an accelerator
    -> m ((Bool, Word32, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ whether parsing succeeded
acceleratorParse accelerator = liftIO $ do
    accelerator' <- textToCString accelerator
    acceleratorKey <- allocMem :: IO (Ptr Word32)
    acceleratorMods <- allocMem :: IO (Ptr CUInt)
    result <- gtk_accelerator_parse accelerator' acceleratorKey acceleratorMods
    let result' = (/= 0) result
    acceleratorKey' <- peek acceleratorKey
    acceleratorMods' <- peek acceleratorMods
    let acceleratorMods'' = wordToGFlags acceleratorMods'
    freeMem accelerator'
    freeMem acceleratorKey
    freeMem acceleratorMods
    return (result', acceleratorKey', acceleratorMods'')


-- function accelerator_name_with_keycode
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_key"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator keyval" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keycode"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator keycode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_mods"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_name_with_keycode" gtk_accelerator_name_with_keycode :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- accelerator_key : TBasicType TUInt
    Word32 ->                               -- keycode : TBasicType TUInt
    CUInt ->                                -- accelerator_mods : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CString

-- | Converts an accelerator keyval and modifier mask
-- into a string that can be parsed by 'GI.Gtk.Functions.acceleratorParseWithKeycode'.
-- 
-- This is similar to 'GI.Gtk.Functions.acceleratorName' but handling keycodes.
-- This is only useful for system-level components, applications
-- should use 'GI.Gtk.Functions.acceleratorName' instead.
acceleratorNameWithKeycode ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    Maybe (a)
    -- ^ /@display@/: a @GdkDisplay@
    -> Word32
    -- ^ /@acceleratorKey@/: accelerator keyval
    -> Word32
    -- ^ /@keycode@/: accelerator keycode
    -> [Gdk.Flags.ModifierType]
    -- ^ /@acceleratorMods@/: accelerator modifier mask
    -> m T.Text
    -- ^ __Returns:__ a newly allocated accelerator name.
acceleratorNameWithKeycode display acceleratorKey keycode acceleratorMods = liftIO $ do
    maybeDisplay <- case display of
        Nothing -> return FP.nullPtr
        Just jDisplay -> do
            jDisplay' <- unsafeManagedPtrCastPtr jDisplay
            return jDisplay'
    let acceleratorMods' = gflagsToWord acceleratorMods
    result <- gtk_accelerator_name_with_keycode maybeDisplay acceleratorKey keycode acceleratorMods'
    checkUnexpectedReturnNULL "acceleratorNameWithKeycode" result
    result' <- cstringToText result
    freeMem result
    whenJust display touchManagedPtr
    return result'


-- function accelerator_name
-- Args: [ Arg
--           { argCName = "accelerator_key"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator keyval" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_mods"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_name" gtk_accelerator_name :: 
    Word32 ->                               -- accelerator_key : TBasicType TUInt
    CUInt ->                                -- accelerator_mods : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CString

-- | Converts an accelerator keyval and modifier mask into a string
-- that can be parsed by 'GI.Gtk.Functions.acceleratorParse'.
-- 
-- For example, if you pass in @GDK_KEY_q@ and @GDK_CONTROL_MASK@,
-- this function returns @\<Control>q@.
-- 
-- If you need to display accelerators in the user interface,
-- see 'GI.Gtk.Functions.acceleratorGetLabel'.
acceleratorName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@acceleratorKey@/: accelerator keyval
    -> [Gdk.Flags.ModifierType]
    -- ^ /@acceleratorMods@/: accelerator modifier mask
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated accelerator name
acceleratorName acceleratorKey acceleratorMods = liftIO $ do
    let acceleratorMods' = gflagsToWord acceleratorMods
    result <- gtk_accelerator_name acceleratorKey acceleratorMods'
    checkUnexpectedReturnNULL "acceleratorName" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function accelerator_get_label_with_keycode
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_key"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator keyval" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keycode"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator keycode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_mods"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_get_label_with_keycode" gtk_accelerator_get_label_with_keycode :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- accelerator_key : TBasicType TUInt
    Word32 ->                               -- keycode : TBasicType TUInt
    CUInt ->                                -- accelerator_mods : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CString

-- | Converts an accelerator keyval and modifier mask
-- into a string that can be displayed to the user.
-- 
-- The string may be translated.
-- 
-- This function is similar to 'GI.Gtk.Functions.acceleratorGetLabel',
-- but handling keycodes. This is only useful for system-level
-- components, applications should use 'GI.Gtk.Functions.acceleratorGetLabel'
-- instead.
acceleratorGetLabelWithKeycode ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    Maybe (a)
    -- ^ /@display@/: a @GdkDisplay@
    -> Word32
    -- ^ /@acceleratorKey@/: accelerator keyval
    -> Word32
    -- ^ /@keycode@/: accelerator keycode
    -> [Gdk.Flags.ModifierType]
    -- ^ /@acceleratorMods@/: accelerator modifier mask
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated string representing the accelerator
acceleratorGetLabelWithKeycode display acceleratorKey keycode acceleratorMods = liftIO $ do
    maybeDisplay <- case display of
        Nothing -> return FP.nullPtr
        Just jDisplay -> do
            jDisplay' <- unsafeManagedPtrCastPtr jDisplay
            return jDisplay'
    let acceleratorMods' = gflagsToWord acceleratorMods
    result <- gtk_accelerator_get_label_with_keycode maybeDisplay acceleratorKey keycode acceleratorMods'
    checkUnexpectedReturnNULL "acceleratorGetLabelWithKeycode" result
    result' <- cstringToText result
    freeMem result
    whenJust display touchManagedPtr
    return result'


-- function accelerator_get_label
-- Args: [ Arg
--           { argCName = "accelerator_key"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator keyval" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accelerator_mods"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "accelerator modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_get_label" gtk_accelerator_get_label :: 
    Word32 ->                               -- accelerator_key : TBasicType TUInt
    CUInt ->                                -- accelerator_mods : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CString

-- | Converts an accelerator keyval and modifier mask into a string
-- which can be used to represent the accelerator to the user.
acceleratorGetLabel ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@acceleratorKey@/: accelerator keyval
    -> [Gdk.Flags.ModifierType]
    -- ^ /@acceleratorMods@/: accelerator modifier mask
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated string representing the accelerator
acceleratorGetLabel acceleratorKey acceleratorMods = liftIO $ do
    let acceleratorMods' = gflagsToWord acceleratorMods
    result <- gtk_accelerator_get_label acceleratorKey acceleratorMods'
    checkUnexpectedReturnNULL "acceleratorGetLabel" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function accelerator_get_default_mod_mask
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ModifierType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_accelerator_get_default_mod_mask" gtk_accelerator_get_default_mod_mask :: 
    IO CUInt

-- | Gets the modifier mask.
-- 
-- The modifier mask determines which modifiers are considered significant
-- for keyboard accelerators. This includes all keyboard modifiers except
-- for @GDK_LOCK_MASK@.
acceleratorGetDefaultModMask ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Gdk.Flags.ModifierType]
    -- ^ __Returns:__ the modifier mask for accelerators
acceleratorGetDefaultModMask  = liftIO $ do
    result <- gtk_accelerator_get_default_mod_mask
    let result' = wordToGFlags result
    return result'



