{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Constants
    ( 
    pattern TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID,
    pattern TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,
    pattern TEXT_VIEW_PRIORITY_VALIDATE     ,
    pattern STYLE_PROVIDER_PRIORITY_USER    ,
    pattern STYLE_PROVIDER_PRIORITY_THEME   ,
    pattern STYLE_PROVIDER_PRIORITY_SETTINGS,
    pattern STYLE_PROVIDER_PRIORITY_FALLBACK,
    pattern STYLE_PROVIDER_PRIORITY_APPLICATION,
    pattern PRIORITY_RESIZE                 ,
    pattern PRINT_SETTINGS_WIN32_DRIVER_VERSION,
    pattern PRINT_SETTINGS_WIN32_DRIVER_EXTRA,
    pattern PRINT_SETTINGS_USE_COLOR        ,
    pattern PRINT_SETTINGS_SCALE            ,
    pattern PRINT_SETTINGS_REVERSE          ,
    pattern PRINT_SETTINGS_RESOLUTION_Y     ,
    pattern PRINT_SETTINGS_RESOLUTION_X     ,
    pattern PRINT_SETTINGS_RESOLUTION       ,
    pattern PRINT_SETTINGS_QUALITY          ,
    pattern PRINT_SETTINGS_PRINT_PAGES      ,
    pattern PRINT_SETTINGS_PRINTER_LPI      ,
    pattern PRINT_SETTINGS_PRINTER          ,
    pattern PRINT_SETTINGS_PAPER_WIDTH      ,
    pattern PRINT_SETTINGS_PAPER_HEIGHT     ,
    pattern PRINT_SETTINGS_PAPER_FORMAT     ,
    pattern PRINT_SETTINGS_PAGE_SET         ,
    pattern PRINT_SETTINGS_PAGE_RANGES      ,
    pattern PRINT_SETTINGS_OUTPUT_URI       ,
    pattern PRINT_SETTINGS_OUTPUT_FILE_FORMAT,
    pattern PRINT_SETTINGS_OUTPUT_DIR       ,
    pattern PRINT_SETTINGS_OUTPUT_BIN       ,
    pattern PRINT_SETTINGS_OUTPUT_BASENAME  ,
    pattern PRINT_SETTINGS_ORIENTATION      ,
    pattern PRINT_SETTINGS_N_COPIES         ,
    pattern PRINT_SETTINGS_NUMBER_UP_LAYOUT ,
    pattern PRINT_SETTINGS_NUMBER_UP        ,
    pattern PRINT_SETTINGS_MEDIA_TYPE       ,
    pattern PRINT_SETTINGS_FINISHINGS       ,
    pattern PRINT_SETTINGS_DUPLEX           ,
    pattern PRINT_SETTINGS_DITHER           ,
    pattern PRINT_SETTINGS_DEFAULT_SOURCE   ,
    pattern PRINT_SETTINGS_COLLATE          ,
    pattern PAPER_NAME_LETTER               ,
    pattern PAPER_NAME_LEGAL                ,
    pattern PAPER_NAME_EXECUTIVE            ,
    pattern PAPER_NAME_B5                   ,
    pattern PAPER_NAME_A5                   ,
    pattern PAPER_NAME_A4                   ,
    pattern PAPER_NAME_A3                   ,
    pattern MINOR_VERSION                   ,
    pattern MICRO_VERSION                   ,
    pattern MEDIA_FILE_EXTENSION_POINT_NAME ,
    pattern MAX_COMPOSE_LEN                 ,
    pattern MAJOR_VERSION                   ,
    pattern LEVEL_BAR_OFFSET_LOW            ,
    pattern LEVEL_BAR_OFFSET_HIGH           ,
    pattern LEVEL_BAR_OFFSET_FULL           ,
    pattern INVALID_LIST_POSITION           ,
    pattern INTERFACE_AGE                   ,
    pattern INPUT_ERROR                     ,
    pattern IM_MODULE_EXTENSION_POINT_NAME  ,
    pattern BINARY_AGE                      ,
    pattern ACCESSIBLE_VALUE_UNDEFINED      ,
    pattern ACCESSIBLE_ATTRIBUTE_WEIGHT     ,
    pattern ACCESSIBLE_ATTRIBUTE_VARIANT_UNICASE,
    pattern ACCESSIBLE_ATTRIBUTE_VARIANT_TITLE_CAPS,
    pattern ACCESSIBLE_ATTRIBUTE_VARIANT_SMALL_CAPS,
    pattern ACCESSIBLE_ATTRIBUTE_VARIANT_PETITE_CAPS,
    pattern ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_SMALL_CAPS,
    pattern ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_PETITE_CAPS,
    pattern ACCESSIBLE_ATTRIBUTE_VARIANT    ,
    pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_SINGLE,
    pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_NONE,
    pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_ERROR,
    pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_DOUBLE,
    pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE  ,
    pattern ACCESSIBLE_ATTRIBUTE_STYLE_OBLIQUE,
    pattern ACCESSIBLE_ATTRIBUTE_STYLE_NORMAL,
    pattern ACCESSIBLE_ATTRIBUTE_STYLE_ITALIC,
    pattern ACCESSIBLE_ATTRIBUTE_STYLE      ,
    pattern ACCESSIBLE_ATTRIBUTE_STRIKETHROUGH,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_EXPANDED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_CONDENSED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_EXPANDED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_CONDENSED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_NORMAL,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_EXPANDED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_CONDENSED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_EXPANDED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH_CONDENSED,
    pattern ACCESSIBLE_ATTRIBUTE_STRETCH    ,
    pattern ACCESSIBLE_ATTRIBUTE_SIZE       ,
    pattern ACCESSIBLE_ATTRIBUTE_OVERLINE_SINGLE,
    pattern ACCESSIBLE_ATTRIBUTE_OVERLINE_NONE,
    pattern ACCESSIBLE_ATTRIBUTE_OVERLINE   ,
    pattern ACCESSIBLE_ATTRIBUTE_FOREGROUND ,
    pattern ACCESSIBLE_ATTRIBUTE_FAMILY     ,
    pattern ACCESSIBLE_ATTRIBUTE_BACKGROUND ,

    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

{-# DEPRECATED TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID ["(Since version 4.20)","There is no replacement"] #-}
-- | Disables sorting in a t'GI.Gtk.Interfaces.TreeSortable.TreeSortable'.
-- 
-- See also: 'GI.Gtk.Interfaces.TreeSortable.treeSortableSetSortColumnId'
pattern TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID = -2 :: Int32

{-# DEPRECATED TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID ["(Since version 4.20)","There is no replacement"] #-}
-- | Uses the default sort function in a t'GI.Gtk.Interfaces.TreeSortable.TreeSortable'.
-- 
-- See also: 'GI.Gtk.Interfaces.TreeSortable.treeSortableSetSortColumnId'
pattern TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID = -1 :: Int32

-- | The priority at which the text view validates onscreen lines
-- in an idle job in the background.
pattern TEXT_VIEW_PRIORITY_VALIDATE = 125 :: Int32

-- | The priority used for the style information from
-- @$XDG_CONFIG_HOME\/gtk-4.0\/gtk.css@.
-- 
-- You should not use priorities higher than this, to
-- give the user the last word.
pattern STYLE_PROVIDER_PRIORITY_USER = 800 :: Int32

-- | The priority used for style information provided
-- by themes.
pattern STYLE_PROVIDER_PRIORITY_THEME = 200 :: Int32

-- | The priority used for style information provided
-- via @GtkSettings@.
-- 
-- This priority is higher than 'GI.Gtk.Constants.STYLE_PROVIDER_PRIORITY_THEME'
-- to let settings override themes.
pattern STYLE_PROVIDER_PRIORITY_SETTINGS = 400 :: Int32

-- | The priority used for default style information
-- that is used in the absence of themes.
-- 
-- Note that this is not very useful for providing default
-- styling for custom style classes - themes are likely to
-- override styling provided at this priority with
-- catch-all @* {...}@ rules.
pattern STYLE_PROVIDER_PRIORITY_FALLBACK = 1 :: Int32

-- | A priority that can be used when adding a @GtkStyleProvider@
-- for application-specific style information.
pattern STYLE_PROVIDER_PRIORITY_APPLICATION = 600 :: Int32

-- | Use this priority for functionality related to size allocation.
-- 
-- It is used internally by GTK+ to compute the sizes of widgets.
-- This priority is higher than 'GI.Gdk.Constants.PRIORITY_REDRAW' to avoid
-- resizing a widget which was just redrawn.
pattern PRIORITY_RESIZE = 110 :: Int32

-- | The key used by the “Print to file” printer to store the 32-bit Windows
-- driver version.
pattern PRINT_SETTINGS_WIN32_DRIVER_VERSION = "win32-driver-version" :: T.Text

-- | The key used by the “Print to file” printer to store 32-bit Windows extra
-- driver.
pattern PRINT_SETTINGS_WIN32_DRIVER_EXTRA = "win32-driver-extra" :: T.Text

-- | The key used by the “Print to file” printer to store whether to print with
-- colors.
pattern PRINT_SETTINGS_USE_COLOR = "use-color" :: T.Text

-- | The key used by the “Print to file” printer to store the scale.
pattern PRINT_SETTINGS_SCALE = "scale" :: T.Text

-- | The key used by the “Print to file” printer to store whether to reverse the
-- order of the printed pages.
pattern PRINT_SETTINGS_REVERSE = "reverse" :: T.Text

-- | The key used by the “Print to file” printer to store the vertical resolution
-- in DPI.
pattern PRINT_SETTINGS_RESOLUTION_Y = "resolution-y" :: T.Text

-- | The key used by the “Print to file” printer to store the horizontal
-- resolution in DPI.
pattern PRINT_SETTINGS_RESOLUTION_X = "resolution-x" :: T.Text

-- | The key used by the “Print to file” printer to store the resolution in DPI.
pattern PRINT_SETTINGS_RESOLUTION = "resolution" :: T.Text

-- | The key used by the “Print to file” printer to store the printing quality.
pattern PRINT_SETTINGS_QUALITY = "quality" :: T.Text

-- | The key used by the “Print to file” printer to store which pages to print.
pattern PRINT_SETTINGS_PRINT_PAGES = "print-pages" :: T.Text

-- | The key used by the “Print to file” printer to store the resolution in lines
-- per inch.
pattern PRINT_SETTINGS_PRINTER_LPI = "printer-lpi" :: T.Text

-- | The key used by the “Print to file” printer to store the printer name.
pattern PRINT_SETTINGS_PRINTER = "printer" :: T.Text

-- | The key used by the “Print to file” printer to store the paper width.
pattern PRINT_SETTINGS_PAPER_WIDTH = "paper-width" :: T.Text

-- | The key used by the “Print to file” printer to store the page height.
pattern PRINT_SETTINGS_PAPER_HEIGHT = "paper-height" :: T.Text

-- | The key used by the “Print to file” printer to store the page format.
pattern PRINT_SETTINGS_PAPER_FORMAT = "paper-format" :: T.Text

-- | The key used by the “Print to file” printer to store the set of pages to print.
pattern PRINT_SETTINGS_PAGE_SET = "page-set" :: T.Text

-- | The key used by the “Print to file” printer to store the array of page ranges
-- to print.
pattern PRINT_SETTINGS_PAGE_RANGES = "page-ranges" :: T.Text

-- | The key used by the “Print to file” printer to store the URI
-- to which the output should be written. GTK itself supports
-- only “file:\/\/” URIs.
pattern PRINT_SETTINGS_OUTPUT_URI = "output-uri" :: T.Text

-- | The key used by the “Print to file” printer to store the format
-- of the output. The supported values are “PS” and “PDF”.
pattern PRINT_SETTINGS_OUTPUT_FILE_FORMAT = "output-file-format" :: T.Text

-- | The key used by the “Print to file” printer to store the
-- directory to which the output should be written.
pattern PRINT_SETTINGS_OUTPUT_DIR = "output-dir" :: T.Text

-- | The key used by the “Print to file” printer to store the output bin.
pattern PRINT_SETTINGS_OUTPUT_BIN = "output-bin" :: T.Text

-- | The key used by the “Print to file” printer to store the file
-- name of the output without the path to the directory and the
-- file extension.
pattern PRINT_SETTINGS_OUTPUT_BASENAME = "output-basename" :: T.Text

-- | The key used by the “Print to file” printer to store the orientation.
pattern PRINT_SETTINGS_ORIENTATION = "orientation" :: T.Text

-- | The key used by the “Print to file” printer to store the number of copies.
pattern PRINT_SETTINGS_N_COPIES = "n-copies" :: T.Text

-- | The key used by the “Print to file” printer to store the number of pages per
-- sheet in number-up mode.
pattern PRINT_SETTINGS_NUMBER_UP_LAYOUT = "number-up-layout" :: T.Text

-- | The key used by the “Print to file” printer to store the number of pages per
-- sheet.
pattern PRINT_SETTINGS_NUMBER_UP = "number-up" :: T.Text

-- | The key used by the “Print to file” printer to store the media type.
-- 
-- The set of media types is defined in PWG 5101.1-2002 PWG.
pattern PRINT_SETTINGS_MEDIA_TYPE = "media-type" :: T.Text

-- | The key used by the “Print to file” printer to store the finishings.
pattern PRINT_SETTINGS_FINISHINGS = "finishings" :: T.Text

-- | The key used by the “Print to file” printer to store whether to print the
-- output in duplex.
pattern PRINT_SETTINGS_DUPLEX = "duplex" :: T.Text

-- | The key used by the “Print to file” printer to store the dither used.
pattern PRINT_SETTINGS_DITHER = "dither" :: T.Text

-- | The key used by the “Print to file” printer to store the default source.
pattern PRINT_SETTINGS_DEFAULT_SOURCE = "default-source" :: T.Text

-- | The key used by the “Print to file” printer to store whether to collate the
-- printed pages.
pattern PRINT_SETTINGS_COLLATE = "collate" :: T.Text

-- | Name for the Letter paper size.
pattern PAPER_NAME_LETTER = "na_letter" :: T.Text

-- | Name for the Legal paper size.
pattern PAPER_NAME_LEGAL = "na_legal" :: T.Text

-- | Name for the Executive paper size.
pattern PAPER_NAME_EXECUTIVE = "na_executive" :: T.Text

-- | Name for the B5 paper size.
pattern PAPER_NAME_B5 = "iso_b5" :: T.Text

-- | Name for the A5 paper size.
pattern PAPER_NAME_A5 = "iso_a5" :: T.Text

-- | Name for the A4 paper size.
pattern PAPER_NAME_A4 = "iso_a4" :: T.Text

-- | Name for the A3 paper size.
pattern PAPER_NAME_A3 = "iso_a3" :: T.Text

-- | Like [func/@getMinorVersion@/], but from the headers used at
-- application compile time, rather than from the library linked
-- against at application run time.
pattern MINOR_VERSION = 18 :: Int32

-- | Like [func/@getMicroVersion@/], but from the headers used at
-- application compile time, rather than from the library linked
-- against at application run time.
pattern MICRO_VERSION = 5 :: Int32

-- | The default extension point name for media file.
pattern MEDIA_FILE_EXTENSION_POINT_NAME = "gtk-media-file" :: T.Text

-- | Evaluates to the maximum length of a compose sequence.
-- 
-- This macro is longer used by GTK.
pattern MAX_COMPOSE_LEN = 7 :: Int32

-- | Like [func/@getMajorVersion@/], but from the headers used at
-- application compile time, rather than from the library linked
-- against at application run time.
pattern MAJOR_VERSION = 4 :: Int32

-- | The name used for the stock low offset included by @GtkLevelBar@.
pattern LEVEL_BAR_OFFSET_LOW = "low" :: T.Text

-- | The name used for the stock high offset included by @GtkLevelBar@.
pattern LEVEL_BAR_OFFSET_HIGH = "high" :: T.Text

-- | The name used for the stock full offset included by @GtkLevelBar@.
pattern LEVEL_BAR_OFFSET_FULL = "full" :: T.Text

-- | The value used to refer to a guaranteed invalid position
-- in a @GListModel@.
-- 
-- This value may be returned from some functions, others may
-- accept it as input. Its interpretation may differ for different
-- functions.
-- 
-- Refer to each function\'s documentation for if this value is
-- allowed and what it does.
pattern INVALID_LIST_POSITION = 4294967295 :: Word32

-- | Like [func/@getInterfaceAge@/], but from the headers used at
-- application compile time, rather than from the library linked
-- against at application run time.
pattern INTERFACE_AGE = 5 :: Int32

-- | Constant to return from a signal handler for the [input](#g:signal:input)
-- signal in case of conversion failure.
-- 
-- See [SpinButton::input]("GI.Gtk.Objects.SpinButton#g:signal:input").
pattern INPUT_ERROR = -1 :: Int32

-- | The default name of the extension point.
pattern IM_MODULE_EXTENSION_POINT_NAME = "gtk-im-module" :: T.Text

-- | Like [func/@getBinaryAge@/], but from the headers used at
-- application compile time, rather than from the library linked
-- against at application run time.
pattern BINARY_AGE = 1805 :: Int32

-- | An undefined value. The accessible attribute is either unset, or its
-- value is undefined.
pattern ACCESSIBLE_VALUE_UNDEFINED = -1 :: Int32

-- | An attribute for the font weight.
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_WEIGHT = "weight" :: T.Text

-- | The \"unicase\" variant value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_VARIANT_UNICASE = "unicase" :: T.Text

-- | The \"title caps\" variant value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_VARIANT_TITLE_CAPS = "title-caps" :: T.Text

-- | The \"small caps\" variant value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_VARIANT_SMALL_CAPS = "small-caps" :: T.Text

-- | The \"petite caps\" variant value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_VARIANT_PETITE_CAPS = "petite-caps" :: T.Text

-- | The \"all small caps\" variant value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_SMALL_CAPS = "all-small-caps" :: T.Text

-- | The \"all petite caps\" variant value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_PETITE_CAPS = "all-petite-caps" :: T.Text

-- | An attribute for the font variant.
-- 
-- Possible values are:
-- 
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT_SMALL_CAPS]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_SMALL_CAPS]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT_PETITE_CAPS]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_PETITE_CAPS]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT_UNICASE]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_VARIANT_TITLE_CAPS]
-- 
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_VARIANT = "variant" :: T.Text

-- | The \"single\" underline value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_SINGLE = "single" :: T.Text

-- | The \"none\" underline value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_NONE = "none" :: T.Text

-- | The \"error\" underline value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_ERROR = "error" :: T.Text

-- | The \"double\" underline value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE_DOUBLE = "double" :: T.Text

-- | An attribute for the underline style.
-- 
-- Possible values are:
-- 
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE_NONE]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE_SINGLE]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE_DOUBLE]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_UNDERLINE_ERROR]
-- 
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_UNDERLINE = "underline" :: T.Text

-- | The \"oblique\" style value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STYLE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STYLE_OBLIQUE = "oblique" :: T.Text

-- | The \"normal\" style value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STYLE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STYLE_NORMAL = "normal" :: T.Text

-- | The \"italic\" style value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STYLE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STYLE_ITALIC = "italic" :: T.Text

-- | An attribute for the font style.
-- 
-- Possible values are:
-- 
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STYLE_NORMAL]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STYLE_OBLIQUE]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STYLE_ITALIC]
-- 
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STYLE = "style" :: T.Text

-- | An attribute for strikethrough text.
-- 
-- Possible values are @true@ or @false@.
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRIKETHROUGH = "strikethrough" :: T.Text

-- | The \"ultra expanded\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_EXPANDED = "ultra_expanded" :: T.Text

-- | The \"ultra condensed\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_CONDENSED = "ultra_condensed" :: T.Text

-- | The \"semi expanded\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_EXPANDED = "semi_expanded" :: T.Text

-- | The \"semi condensed\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_CONDENSED = "semi_condensed" :: T.Text

-- | The \"normal\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_NORMAL = "normal" :: T.Text

-- | The \"extra expanded\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_EXPANDED = "extra_expanded" :: T.Text

-- | The \"extra condensed\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_CONDENSED = "extra_condensed" :: T.Text

-- | The \"expanded\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_EXPANDED = "expanded" :: T.Text

-- | The \"condensed\" stretch value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH_CONDENSED = "condensed" :: T.Text

-- | An attribute for the font stretch type.
-- 
-- Possible values are:
-- 
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_CONDENSED]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_CONDENSED]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH_CONDENSED]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_CONDENSED]
-- 
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_STRETCH = "stretch" :: T.Text

-- | An attribute for the font size, expressed in points.
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_SIZE = "size" :: T.Text

-- | The \"single\" overline value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_OVERLINE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_OVERLINE_SINGLE = "single" :: T.Text

-- | The \"none\" overline value for [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_OVERLINE].
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_OVERLINE_NONE = "none" :: T.Text

-- | An attribute for the overline style.
-- 
-- Possible values are:
-- 
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_OVERLINE_NONE]
-- * [const/@gtk@/.ACCESSIBLE_ATTRIBUTE_OVERLINE_SINGLE]
-- 
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_OVERLINE = "overline" :: T.Text

-- | An attribute for the foreground color, expressed as an RGB value
-- encoded in a string using the format: @{r8},{g8},{b8}@.
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_FOREGROUND = "fg-color" :: T.Text

-- | An attribute for the font family name.
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_FAMILY = "family-name" :: T.Text

-- | An attribute for the background color, expressed as an RGB value
-- encoded in a string using the format: @{r8},{g8},{b8}@.
-- 
-- /Since: 4.14/
pattern ACCESSIBLE_ATTRIBUTE_BACKGROUND = "bg-color" :: T.Text


