{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Gtk.Config ( overrides ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "C-docs-url Gtk https://docs.gtk.org/gtk4"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (out caller-allocates), but it is just a pointer to a GValue."
 , "set-attr Gtk/TreeModelFilterModifyFunc/@parameters/value direction in"
 , "set-attr Gtk/TreeModelFilterModifyFunc/@parameters/value caller-allocates 0"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (inout transfer=full), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeStore/remove/@parameters/iter direction in"
 , "set-attr Gtk/TreeStore/remove/@parameters/iter transfer-ownership none"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (inout transfer=full), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeModel/iter_next/@parameters/iter direction in"
 , "set-attr Gtk/TreeModel/iter_next/@parameters/iter transfer-ownership none"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (inout transfer=full), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeModel/iter_previous/@parameters/iter direction in"
 , "set-attr Gtk/TreeModel/iter_previous/@parameters/iter transfer-ownership none"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (out caller-allocates), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeModel/iter_nth_child/@parameters/iter direction in"
 , "set-attr Gtk/TreeModel/iter_nth_child/@parameters/iter caller-allocates 0"
 , ""
 , "# It is useful to expose these class structs when deriving new types"
 , "set-attr Gtk/WidgetClass haskell-gi-force-visible 1"
 , "set-attr Gtk/ContainerClass haskell-gi-force-visible 1"]
