{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure holding information for a specific type.
-- 
-- See also: 'GI.GObject.Functions.typeQuery'

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.TypeQuery
    ( 

-- * Exported types
    TypeQuery(..)                           ,
    newZeroTypeQuery                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTypeQueryMethod                  ,
#endif



 -- * Properties


-- ** classSize #attr:classSize#
-- | the size of the class structure

    getTypeQueryClassSize                   ,
    setTypeQueryClassSize                   ,
#if defined(ENABLE_OVERLOADING)
    typeQuery_classSize                     ,
#endif


-- ** instanceSize #attr:instanceSize#
-- | the size of the instance structure

    getTypeQueryInstanceSize                ,
    setTypeQueryInstanceSize                ,
#if defined(ENABLE_OVERLOADING)
    typeQuery_instanceSize                  ,
#endif


-- ** type #attr:type#
-- | the t'GType' value of the type

    getTypeQueryType                        ,
    setTypeQueryType                        ,
#if defined(ENABLE_OVERLOADING)
    typeQuery_type                          ,
#endif


-- ** typeName #attr:typeName#
-- | the name of the type

    clearTypeQueryTypeName                  ,
    getTypeQueryTypeName                    ,
    setTypeQueryTypeName                    ,
#if defined(ENABLE_OVERLOADING)
    typeQuery_typeName                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TypeQuery = TypeQuery (SP.ManagedPtr TypeQuery)
    deriving (Eq)

instance SP.ManagedPtrNewtype TypeQuery where
    toManagedPtr (TypeQuery p) = p

instance BoxedPtr TypeQuery where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr TypeQuery)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TypeQuery where
    boxedPtrCalloc = callocBytes 24


-- | Construct a `TypeQuery` struct initialized to zero.
newZeroTypeQuery :: MonadIO m => m TypeQuery
newZeroTypeQuery = liftIO $ boxedPtrCalloc >>= wrapPtr TypeQuery

instance tag ~ 'AttrSet => Constructible TypeQuery tag where
    new _ attrs = do
        o <- newZeroTypeQuery
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' typeQuery #type
-- @
getTypeQueryType :: MonadIO m => TypeQuery -> m GType
getTypeQueryType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CGType
    let val' = GType val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' typeQuery [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setTypeQueryType :: MonadIO m => TypeQuery -> GType -> m ()
setTypeQueryType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gtypeToCGType val
    poke (ptr `plusPtr` 0) (val' :: CGType)

#if defined(ENABLE_OVERLOADING)
data TypeQueryTypeFieldInfo
instance AttrInfo TypeQueryTypeFieldInfo where
    type AttrBaseTypeConstraint TypeQueryTypeFieldInfo = (~) TypeQuery
    type AttrAllowedOps TypeQueryTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TypeQueryTypeFieldInfo = (~) GType
    type AttrTransferTypeConstraint TypeQueryTypeFieldInfo = (~)GType
    type AttrTransferType TypeQueryTypeFieldInfo = GType
    type AttrGetType TypeQueryTypeFieldInfo = GType
    type AttrLabel TypeQueryTypeFieldInfo = "type"
    type AttrOrigin TypeQueryTypeFieldInfo = TypeQuery
    attrGet = getTypeQueryType
    attrSet = setTypeQueryType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeQuery.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-TypeQuery.html#g:attr:type"
        })

typeQuery_type :: AttrLabelProxy "type"
typeQuery_type = AttrLabelProxy

#endif


-- | Get the value of the “@type_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' typeQuery #typeName
-- @
getTypeQueryTypeName :: MonadIO m => TypeQuery -> m (Maybe T.Text)
getTypeQueryTypeName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@type_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' typeQuery [ #typeName 'Data.GI.Base.Attributes.:=' value ]
-- @
setTypeQueryTypeName :: MonadIO m => TypeQuery -> CString -> m ()
setTypeQueryTypeName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@type_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #typeName
-- @
clearTypeQueryTypeName :: MonadIO m => TypeQuery -> m ()
clearTypeQueryTypeName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data TypeQueryTypeNameFieldInfo
instance AttrInfo TypeQueryTypeNameFieldInfo where
    type AttrBaseTypeConstraint TypeQueryTypeNameFieldInfo = (~) TypeQuery
    type AttrAllowedOps TypeQueryTypeNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TypeQueryTypeNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint TypeQueryTypeNameFieldInfo = (~)CString
    type AttrTransferType TypeQueryTypeNameFieldInfo = CString
    type AttrGetType TypeQueryTypeNameFieldInfo = Maybe T.Text
    type AttrLabel TypeQueryTypeNameFieldInfo = "type_name"
    type AttrOrigin TypeQueryTypeNameFieldInfo = TypeQuery
    attrGet = getTypeQueryTypeName
    attrSet = setTypeQueryTypeName
    attrConstruct = undefined
    attrClear = clearTypeQueryTypeName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeQuery.typeName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-TypeQuery.html#g:attr:typeName"
        })

typeQuery_typeName :: AttrLabelProxy "typeName"
typeQuery_typeName = AttrLabelProxy

#endif


-- | Get the value of the “@class_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' typeQuery #classSize
-- @
getTypeQueryClassSize :: MonadIO m => TypeQuery -> m Word32
getTypeQueryClassSize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Word32
    return val

-- | Set the value of the “@class_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' typeQuery [ #classSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setTypeQueryClassSize :: MonadIO m => TypeQuery -> Word32 -> m ()
setTypeQueryClassSize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TypeQueryClassSizeFieldInfo
instance AttrInfo TypeQueryClassSizeFieldInfo where
    type AttrBaseTypeConstraint TypeQueryClassSizeFieldInfo = (~) TypeQuery
    type AttrAllowedOps TypeQueryClassSizeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TypeQueryClassSizeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TypeQueryClassSizeFieldInfo = (~)Word32
    type AttrTransferType TypeQueryClassSizeFieldInfo = Word32
    type AttrGetType TypeQueryClassSizeFieldInfo = Word32
    type AttrLabel TypeQueryClassSizeFieldInfo = "class_size"
    type AttrOrigin TypeQueryClassSizeFieldInfo = TypeQuery
    attrGet = getTypeQueryClassSize
    attrSet = setTypeQueryClassSize
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeQuery.classSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-TypeQuery.html#g:attr:classSize"
        })

typeQuery_classSize :: AttrLabelProxy "classSize"
typeQuery_classSize = AttrLabelProxy

#endif


-- | Get the value of the “@instance_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' typeQuery #instanceSize
-- @
getTypeQueryInstanceSize :: MonadIO m => TypeQuery -> m Word32
getTypeQueryInstanceSize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@instance_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' typeQuery [ #instanceSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setTypeQueryInstanceSize :: MonadIO m => TypeQuery -> Word32 -> m ()
setTypeQueryInstanceSize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TypeQueryInstanceSizeFieldInfo
instance AttrInfo TypeQueryInstanceSizeFieldInfo where
    type AttrBaseTypeConstraint TypeQueryInstanceSizeFieldInfo = (~) TypeQuery
    type AttrAllowedOps TypeQueryInstanceSizeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TypeQueryInstanceSizeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TypeQueryInstanceSizeFieldInfo = (~)Word32
    type AttrTransferType TypeQueryInstanceSizeFieldInfo = Word32
    type AttrGetType TypeQueryInstanceSizeFieldInfo = Word32
    type AttrLabel TypeQueryInstanceSizeFieldInfo = "instance_size"
    type AttrOrigin TypeQueryInstanceSizeFieldInfo = TypeQuery
    attrGet = getTypeQueryInstanceSize
    attrSet = setTypeQueryInstanceSize
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeQuery.instanceSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-TypeQuery.html#g:attr:instanceSize"
        })

typeQuery_instanceSize :: AttrLabelProxy "instanceSize"
typeQuery_instanceSize = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TypeQuery
type instance O.AttributeList TypeQuery = TypeQueryAttributeList
type TypeQueryAttributeList = ('[ '("type", TypeQueryTypeFieldInfo), '("typeName", TypeQueryTypeNameFieldInfo), '("classSize", TypeQueryClassSizeFieldInfo), '("instanceSize", TypeQueryInstanceSizeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTypeQueryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTypeQueryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTypeQueryMethod t TypeQuery, O.OverloadedMethod info TypeQuery p) => OL.IsLabel t (TypeQuery -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTypeQueryMethod t TypeQuery, O.OverloadedMethod info TypeQuery p, R.HasField t TypeQuery p) => R.HasField t TypeQuery p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTypeQueryMethod t TypeQuery, O.OverloadedMethodInfo info TypeQuery) => OL.IsLabel t (O.MethodProxy info TypeQuery) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


