{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque structure used as the base of all interface types.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.TypeInterface
    ( 

-- * Exported types
    TypeInterface(..)                       ,
    newZeroTypeInterface                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [peekParent]("GI.GObject.Structs.TypeInterface#g:method:peekParent").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTypeInterfaceMethod              ,
#endif

-- ** addPrerequisite #method:addPrerequisite#

    typeInterfaceAddPrerequisite            ,


-- ** getPlugin #method:getPlugin#

    typeInterfaceGetPlugin                  ,


-- ** instantiatablePrerequisite #method:instantiatablePrerequisite#

    typeInterfaceInstantiatablePrerequisite ,


-- ** peek #method:peek#

    typeInterfacePeek                       ,


-- ** peekParent #method:peekParent#

#if defined(ENABLE_OVERLOADING)
    TypeInterfacePeekParentMethodInfo       ,
#endif
    typeInterfacePeekParent                 ,


-- ** prerequisites #method:prerequisites#

    typeInterfacePrerequisites              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeValueTable as GObject.TypeValueTable

#else
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#endif

-- | Memory-managed wrapper type.
newtype TypeInterface = TypeInterface (SP.ManagedPtr TypeInterface)
    deriving (Eq)

instance SP.ManagedPtrNewtype TypeInterface where
    toManagedPtr (TypeInterface p) = p

instance BoxedPtr TypeInterface where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr TypeInterface)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TypeInterface where
    boxedPtrCalloc = callocBytes 16


-- | Construct a `TypeInterface` struct initialized to zero.
newZeroTypeInterface :: MonadIO m => m TypeInterface
newZeroTypeInterface = liftIO $ boxedPtrCalloc >>= wrapPtr TypeInterface

instance tag ~ 'AttrSet => Constructible TypeInterface tag where
    new _ attrs = do
        o <- newZeroTypeInterface
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TypeInterface
type instance O.AttributeList TypeInterface = TypeInterfaceAttributeList
type TypeInterfaceAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method TypeInterface::peek_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "g_iface"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeInterface structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GObject" , name = "TypeInterface" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_interface_peek_parent" g_type_interface_peek_parent :: 
    Ptr TypeInterface ->                    -- g_iface : TInterface (Name {namespace = "GObject", name = "TypeInterface"})
    IO (Ptr TypeInterface)

-- | Returns the corresponding t'GI.GObject.Structs.TypeInterface.TypeInterface' structure of the parent type
-- of the instance type to which /@gIface@/ belongs.
-- 
-- This is useful when deriving the implementation of an interface from the
-- parent type and then possibly overriding some methods.
typeInterfacePeekParent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TypeInterface
    -- ^ /@gIface@/: a t'GI.GObject.Structs.TypeInterface.TypeInterface' structure
    -> m (Maybe TypeInterface)
    -- ^ __Returns:__ the
    --   corresponding t'GI.GObject.Structs.TypeInterface.TypeInterface' structure of the parent type of the
    --   instance type to which /@gIface@/ belongs, or 'P.Nothing' if the parent
    --   type doesn\'t conform to the interface
typeInterfacePeekParent gIface = liftIO $ do
    gIface' <- unsafeManagedPtrGetPtr gIface
    result <- g_type_interface_peek_parent gIface'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr TypeInterface) result'
        return result''
    touchManagedPtr gIface
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TypeInterfacePeekParentMethodInfo
instance (signature ~ (m (Maybe TypeInterface)), MonadIO m) => O.OverloadedMethod TypeInterfacePeekParentMethodInfo TypeInterface signature where
    overloadedMethod = typeInterfacePeekParent

instance O.OverloadedMethodInfo TypeInterfacePeekParentMethodInfo TypeInterface where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeInterface.typeInterfacePeekParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-TypeInterface.html#v:typeInterfacePeekParent"
        })


#endif

-- method TypeInterface::add_prerequisite
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType value of an interface type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "prerequisite_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#GType value of an interface or instantiatable type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_interface_add_prerequisite" g_type_interface_add_prerequisite :: 
    CGType ->                               -- interface_type : TBasicType TGType
    CGType ->                               -- prerequisite_type : TBasicType TGType
    IO ()

-- | Adds /@prerequisiteType@/ to the list of prerequisites of /@interfaceType@/.
-- This means that any type implementing /@interfaceType@/ must also implement
-- /@prerequisiteType@/. Prerequisites can be thought of as an alternative to
-- interface derivation (which GType doesn\'t support). An interface can have
-- at most one instantiatable prerequisite type.
typeInterfaceAddPrerequisite ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@interfaceType@/: t'GType' value of an interface type
    -> GType
    -- ^ /@prerequisiteType@/: t'GType' value of an interface or instantiatable type
    -> m ()
typeInterfaceAddPrerequisite interfaceType prerequisiteType = liftIO $ do
    let interfaceType' = gtypeToCGType interfaceType
    let prerequisiteType' = gtypeToCGType prerequisiteType
    g_type_interface_add_prerequisite interfaceType' prerequisiteType'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeInterface::get_plugin
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "instance_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType of an instantiatable type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType of an interface type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "TypePlugin" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_interface_get_plugin" g_type_interface_get_plugin :: 
    CGType ->                               -- instance_type : TBasicType TGType
    CGType ->                               -- interface_type : TBasicType TGType
    IO (Ptr GObject.TypePlugin.TypePlugin)

-- | Returns the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' structure for the dynamic interface
-- /@interfaceType@/ which has been added to /@instanceType@/, or 'P.Nothing'
-- if /@interfaceType@/ has not been added to /@instanceType@/ or does
-- not have a t'GI.GObject.Interfaces.TypePlugin.TypePlugin' structure. See 'GI.GObject.Functions.typeAddInterfaceDynamic'.
typeInterfaceGetPlugin ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@instanceType@/: t'GType' of an instantiatable type
    -> GType
    -- ^ /@interfaceType@/: t'GType' of an interface type
    -> m GObject.TypePlugin.TypePlugin
    -- ^ __Returns:__ the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' for the dynamic
    --     interface /@interfaceType@/ of /@instanceType@/
typeInterfaceGetPlugin instanceType interfaceType = liftIO $ do
    let instanceType' = gtypeToCGType instanceType
    let interfaceType' = gtypeToCGType interfaceType
    result <- g_type_interface_get_plugin instanceType' interfaceType'
    checkUnexpectedReturnNULL "typeInterfaceGetPlugin" result
    result' <- (newPtr GObject.TypePlugin.TypePlugin) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeInterface::instantiatable_prerequisite
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an interface type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_interface_instantiatable_prerequisite" g_type_interface_instantiatable_prerequisite :: 
    CGType ->                               -- interface_type : TBasicType TGType
    IO CGType

-- | Returns the most specific instantiatable prerequisite of an
-- interface type. If the interface type has no instantiatable
-- prerequisite, @/G_TYPE_INVALID/@ is returned.
-- 
-- See 'GI.GObject.Functions.typeInterfaceAddPrerequisite' for more information
-- about prerequisites.
-- 
-- /Since: 2.68/
typeInterfaceInstantiatablePrerequisite ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@interfaceType@/: an interface type
    -> m GType
    -- ^ __Returns:__ the instantiatable prerequisite type or @/G_TYPE_INVALID/@ if none
typeInterfaceInstantiatablePrerequisite interfaceType = liftIO $ do
    let interfaceType' = gtypeToCGType interfaceType
    result <- g_type_interface_instantiatable_prerequisite interfaceType'
    let result' = GType result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeInterface::peek
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "instance_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTypeClass structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an interface ID which this class conforms to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GObject" , name = "TypeInterface" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_interface_peek" g_type_interface_peek :: 
    Ptr GObject.TypeClass.TypeClass ->      -- instance_class : TInterface (Name {namespace = "GObject", name = "TypeClass"})
    CGType ->                               -- iface_type : TBasicType TGType
    IO (Ptr TypeInterface)

-- | Returns the t'GI.GObject.Structs.TypeInterface.TypeInterface' structure of an interface to which the
-- passed in class conforms.
typeInterfacePeek ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeClass.TypeClass
    -- ^ /@instanceClass@/: a t'GI.GObject.Structs.TypeClass.TypeClass' structure
    -> GType
    -- ^ /@ifaceType@/: an interface ID which this class conforms to
    -> m (Maybe TypeInterface)
    -- ^ __Returns:__ the t'GI.GObject.Structs.TypeInterface.TypeInterface'
    --   structure of /@ifaceType@/ if implemented by /@instanceClass@/, 'P.Nothing'
    --   otherwise
typeInterfacePeek instanceClass ifaceType = liftIO $ do
    instanceClass' <- unsafeManagedPtrGetPtr instanceClass
    let ifaceType' = gtypeToCGType ifaceType
    result <- g_type_interface_peek instanceClass' ifaceType'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr TypeInterface) result'
        return result''
    touchManagedPtr instanceClass
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method TypeInterface::prerequisites
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an interface type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_prerequisites"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to return the number\n    of prerequisites, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_prerequisites"
--              , argType = TBasicType TUInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "location to return the number\n    of prerequisites, or %NULL"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TGType))
-- throws : False
-- Skip return : False

foreign import ccall "g_type_interface_prerequisites" g_type_interface_prerequisites :: 
    CGType ->                               -- interface_type : TBasicType TGType
    Ptr Word32 ->                           -- n_prerequisites : TBasicType TUInt
    IO (Ptr CGType)

-- | Returns the prerequisites of an interfaces type.
-- 
-- /Since: 2.2/
typeInterfacePrerequisites ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@interfaceType@/: an interface type
    -> m [GType]
    -- ^ __Returns:__ a
    --     newly-allocated zero-terminated array of t'GType' containing
    --     the prerequisites of /@interfaceType@/
typeInterfacePrerequisites interfaceType = liftIO $ do
    let interfaceType' = gtypeToCGType interfaceType
    nPrerequisites <- allocMem :: IO (Ptr Word32)
    result <- g_type_interface_prerequisites interfaceType' nPrerequisites
    nPrerequisites' <- peek nPrerequisites
    checkUnexpectedReturnNULL "typeInterfacePrerequisites" result
    result' <- (unpackMapStorableArrayWithLength GType nPrerequisites') result
    freeMem result
    freeMem nPrerequisites
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTypeInterfaceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTypeInterfaceMethod "peekParent" o = TypeInterfacePeekParentMethodInfo
    ResolveTypeInterfaceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTypeInterfaceMethod t TypeInterface, O.OverloadedMethod info TypeInterface p) => OL.IsLabel t (TypeInterface -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTypeInterfaceMethod t TypeInterface, O.OverloadedMethod info TypeInterface p, R.HasField t TypeInterface p) => R.HasField t TypeInterface p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTypeInterfaceMethod t TypeInterface, O.OverloadedMethodInfo info TypeInterface) => OL.IsLabel t (O.MethodProxy info TypeInterface) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


