{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This structure is used to provide the type system with the information
-- required to initialize and destruct (finalize) a parameter\'s class and
-- instances thereof.
-- 
-- The initialized structure is passed to the 'GI.GObject.Functions.paramTypeRegisterStatic'
-- The type system will perform a deep copy of this structure, so its memory
-- does not need to be persistent across invocation of
-- 'GI.GObject.Functions.paramTypeRegisterStatic'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.ParamSpecTypeInfo
    ( 

-- * Exported types
    ParamSpecTypeInfo(..)                   ,
    newZeroParamSpecTypeInfo                ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveParamSpecTypeInfoMethod          ,
#endif



 -- * Properties


-- ** finalize #attr:finalize#
-- | The instance finalization function (optional).

    clearParamSpecTypeInfoFinalize          ,
    getParamSpecTypeInfoFinalize            ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_finalize              ,
#endif
    setParamSpecTypeInfoFinalize            ,


-- ** instanceInit #attr:instanceInit#
-- | Location of the instance initialization function (optional).

    clearParamSpecTypeInfoInstanceInit      ,
    getParamSpecTypeInfoInstanceInit        ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_instanceInit          ,
#endif
    setParamSpecTypeInfoInstanceInit        ,


-- ** instanceSize #attr:instanceSize#
-- | Size of the instance (object) structure.

    getParamSpecTypeInfoInstanceSize        ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_instanceSize          ,
#endif
    setParamSpecTypeInfoInstanceSize        ,


-- ** nPreallocs #attr:nPreallocs#
-- | Prior to GLib 2.10, it specified the number of pre-allocated (cached) instances to reserve memory for (0 indicates no caching). Since GLib 2.10, it is ignored, since instances are allocated with the [slice allocator][glib-Memory-Slices] now.

    getParamSpecTypeInfoNPreallocs          ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_nPreallocs            ,
#endif
    setParamSpecTypeInfoNPreallocs          ,


-- ** valueSetDefault #attr:valueSetDefault#
-- | Resets a /@value@/ to the default value for /@pspec@/
--  (recommended, the default is 'GI.GObject.Structs.Value.valueReset'), see
--  'GI.GObject.Functions.paramValueSetDefault'.

    clearParamSpecTypeInfoValueSetDefault   ,
    getParamSpecTypeInfoValueSetDefault     ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_valueSetDefault       ,
#endif
    setParamSpecTypeInfoValueSetDefault     ,


-- ** valueType #attr:valueType#
-- | The t'GType' of values conforming to this t'GI.GObject.Objects.ParamSpec.ParamSpec'

    getParamSpecTypeInfoValueType           ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_valueType             ,
#endif
    setParamSpecTypeInfoValueType           ,


-- ** valueValidate #attr:valueValidate#
-- | Ensures that the contents of /@value@/ comply with the
--  specifications set out by /@pspec@/ (optional), see
--  'GI.GObject.Functions.paramValueValidate'.

    clearParamSpecTypeInfoValueValidate     ,
    getParamSpecTypeInfoValueValidate       ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_valueValidate         ,
#endif
    setParamSpecTypeInfoValueValidate       ,


-- ** valuesCmp #attr:valuesCmp#
-- | Compares /@value1@/ with /@value2@/ according to /@pspec@/
--  (recommended, the default is @/memcmp()/@), see 'GI.GObject.Functions.paramValuesCmp'.

    clearParamSpecTypeInfoValuesCmp         ,
    getParamSpecTypeInfoValuesCmp           ,
#if defined(ENABLE_OVERLOADING)
    paramSpecTypeInfo_valuesCmp             ,
#endif
    setParamSpecTypeInfoValuesCmp           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Callbacks as GObject.Callbacks

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype ParamSpecTypeInfo = ParamSpecTypeInfo (SP.ManagedPtr ParamSpecTypeInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype ParamSpecTypeInfo where
    toManagedPtr (ParamSpecTypeInfo p) = p

instance BoxedPtr ParamSpecTypeInfo where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr ParamSpecTypeInfo)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ParamSpecTypeInfo where
    boxedPtrCalloc = callocBytes 56


-- | Construct a `ParamSpecTypeInfo` struct initialized to zero.
newZeroParamSpecTypeInfo :: MonadIO m => m ParamSpecTypeInfo
newZeroParamSpecTypeInfo = liftIO $ boxedPtrCalloc >>= wrapPtr ParamSpecTypeInfo

instance tag ~ 'AttrSet => Constructible ParamSpecTypeInfo tag where
    new _ attrs = do
        o <- newZeroParamSpecTypeInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@instance_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #instanceSize
-- @
getParamSpecTypeInfoInstanceSize :: MonadIO m => ParamSpecTypeInfo -> m Word16
getParamSpecTypeInfoInstanceSize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word16
    return val

-- | Set the value of the “@instance_size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #instanceSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoInstanceSize :: MonadIO m => ParamSpecTypeInfo -> Word16 -> m ()
setParamSpecTypeInfoInstanceSize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word16)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoInstanceSizeFieldInfo
instance AttrInfo ParamSpecTypeInfoInstanceSizeFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoInstanceSizeFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoInstanceSizeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParamSpecTypeInfoInstanceSizeFieldInfo = (~) Word16
    type AttrTransferTypeConstraint ParamSpecTypeInfoInstanceSizeFieldInfo = (~)Word16
    type AttrTransferType ParamSpecTypeInfoInstanceSizeFieldInfo = Word16
    type AttrGetType ParamSpecTypeInfoInstanceSizeFieldInfo = Word16
    type AttrLabel ParamSpecTypeInfoInstanceSizeFieldInfo = "instance_size"
    type AttrOrigin ParamSpecTypeInfoInstanceSizeFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoInstanceSize
    attrSet = setParamSpecTypeInfoInstanceSize
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.instanceSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:instanceSize"
        })

paramSpecTypeInfo_instanceSize :: AttrLabelProxy "instanceSize"
paramSpecTypeInfo_instanceSize = AttrLabelProxy

#endif


-- | Get the value of the “@n_preallocs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #nPreallocs
-- @
getParamSpecTypeInfoNPreallocs :: MonadIO m => ParamSpecTypeInfo -> m Word16
getParamSpecTypeInfoNPreallocs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 2) :: IO Word16
    return val

-- | Set the value of the “@n_preallocs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #nPreallocs 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoNPreallocs :: MonadIO m => ParamSpecTypeInfo -> Word16 -> m ()
setParamSpecTypeInfoNPreallocs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 2) (val :: Word16)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoNPreallocsFieldInfo
instance AttrInfo ParamSpecTypeInfoNPreallocsFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoNPreallocsFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoNPreallocsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParamSpecTypeInfoNPreallocsFieldInfo = (~) Word16
    type AttrTransferTypeConstraint ParamSpecTypeInfoNPreallocsFieldInfo = (~)Word16
    type AttrTransferType ParamSpecTypeInfoNPreallocsFieldInfo = Word16
    type AttrGetType ParamSpecTypeInfoNPreallocsFieldInfo = Word16
    type AttrLabel ParamSpecTypeInfoNPreallocsFieldInfo = "n_preallocs"
    type AttrOrigin ParamSpecTypeInfoNPreallocsFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoNPreallocs
    attrSet = setParamSpecTypeInfoNPreallocs
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.nPreallocs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:nPreallocs"
        })

paramSpecTypeInfo_nPreallocs :: AttrLabelProxy "nPreallocs"
paramSpecTypeInfo_nPreallocs = AttrLabelProxy

#endif


-- | Get the value of the “@instance_init@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #instanceInit
-- @
getParamSpecTypeInfoInstanceInit :: MonadIO m => ParamSpecTypeInfo -> m (Maybe GObject.Callbacks.ParamSpecTypeInfoInstanceInitFieldCallback)
getParamSpecTypeInfoInstanceInit s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoInstanceInitFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ParamSpecTypeInfoInstanceInitFieldCallback val'
        return val''
    return result

-- | Set the value of the “@instance_init@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #instanceInit 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoInstanceInit :: MonadIO m => ParamSpecTypeInfo -> FunPtr GObject.Callbacks.C_ParamSpecTypeInfoInstanceInitFieldCallback -> m ()
setParamSpecTypeInfoInstanceInit s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoInstanceInitFieldCallback)

-- | Set the value of the “@instance_init@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #instanceInit
-- @
clearParamSpecTypeInfoInstanceInit :: MonadIO m => ParamSpecTypeInfo -> m ()
clearParamSpecTypeInfoInstanceInit s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoInstanceInitFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoInstanceInitFieldInfo
instance AttrInfo ParamSpecTypeInfoInstanceInitFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoInstanceInitFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoInstanceInitFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ParamSpecTypeInfoInstanceInitFieldInfo = (~) (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoInstanceInitFieldCallback)
    type AttrTransferTypeConstraint ParamSpecTypeInfoInstanceInitFieldInfo = (~)GObject.Callbacks.ParamSpecTypeInfoInstanceInitFieldCallback
    type AttrTransferType ParamSpecTypeInfoInstanceInitFieldInfo = (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoInstanceInitFieldCallback)
    type AttrGetType ParamSpecTypeInfoInstanceInitFieldInfo = Maybe GObject.Callbacks.ParamSpecTypeInfoInstanceInitFieldCallback
    type AttrLabel ParamSpecTypeInfoInstanceInitFieldInfo = "instance_init"
    type AttrOrigin ParamSpecTypeInfoInstanceInitFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoInstanceInit
    attrSet = setParamSpecTypeInfoInstanceInit
    attrConstruct = undefined
    attrClear = clearParamSpecTypeInfoInstanceInit
    attrTransfer _ v = do
        GObject.Callbacks.mk_ParamSpecTypeInfoInstanceInitFieldCallback (GObject.Callbacks.wrap_ParamSpecTypeInfoInstanceInitFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.instanceInit"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:instanceInit"
        })

paramSpecTypeInfo_instanceInit :: AttrLabelProxy "instanceInit"
paramSpecTypeInfo_instanceInit = AttrLabelProxy

#endif


-- | Get the value of the “@value_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #valueType
-- @
getParamSpecTypeInfoValueType :: MonadIO m => ParamSpecTypeInfo -> m GType
getParamSpecTypeInfoValueType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CGType
    let val' = GType val
    return val'

-- | Set the value of the “@value_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #valueType 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoValueType :: MonadIO m => ParamSpecTypeInfo -> GType -> m ()
setParamSpecTypeInfoValueType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gtypeToCGType val
    poke (ptr `plusPtr` 16) (val' :: CGType)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoValueTypeFieldInfo
instance AttrInfo ParamSpecTypeInfoValueTypeFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoValueTypeFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoValueTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParamSpecTypeInfoValueTypeFieldInfo = (~) GType
    type AttrTransferTypeConstraint ParamSpecTypeInfoValueTypeFieldInfo = (~)GType
    type AttrTransferType ParamSpecTypeInfoValueTypeFieldInfo = GType
    type AttrGetType ParamSpecTypeInfoValueTypeFieldInfo = GType
    type AttrLabel ParamSpecTypeInfoValueTypeFieldInfo = "value_type"
    type AttrOrigin ParamSpecTypeInfoValueTypeFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoValueType
    attrSet = setParamSpecTypeInfoValueType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.valueType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:valueType"
        })

paramSpecTypeInfo_valueType :: AttrLabelProxy "valueType"
paramSpecTypeInfo_valueType = AttrLabelProxy

#endif


-- | Get the value of the “@finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #finalize
-- @
getParamSpecTypeInfoFinalize :: MonadIO m => ParamSpecTypeInfo -> m (Maybe GObject.Callbacks.ParamSpecTypeInfoFinalizeFieldCallback)
getParamSpecTypeInfoFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoFinalizeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ParamSpecTypeInfoFinalizeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #finalize 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoFinalize :: MonadIO m => ParamSpecTypeInfo -> FunPtr GObject.Callbacks.C_ParamSpecTypeInfoFinalizeFieldCallback -> m ()
setParamSpecTypeInfoFinalize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoFinalizeFieldCallback)

-- | Set the value of the “@finalize@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #finalize
-- @
clearParamSpecTypeInfoFinalize :: MonadIO m => ParamSpecTypeInfo -> m ()
clearParamSpecTypeInfoFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoFinalizeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoFinalizeFieldInfo
instance AttrInfo ParamSpecTypeInfoFinalizeFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoFinalizeFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoFinalizeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ParamSpecTypeInfoFinalizeFieldInfo = (~) (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoFinalizeFieldCallback)
    type AttrTransferTypeConstraint ParamSpecTypeInfoFinalizeFieldInfo = (~)GObject.Callbacks.ParamSpecTypeInfoFinalizeFieldCallback
    type AttrTransferType ParamSpecTypeInfoFinalizeFieldInfo = (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoFinalizeFieldCallback)
    type AttrGetType ParamSpecTypeInfoFinalizeFieldInfo = Maybe GObject.Callbacks.ParamSpecTypeInfoFinalizeFieldCallback
    type AttrLabel ParamSpecTypeInfoFinalizeFieldInfo = "finalize"
    type AttrOrigin ParamSpecTypeInfoFinalizeFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoFinalize
    attrSet = setParamSpecTypeInfoFinalize
    attrConstruct = undefined
    attrClear = clearParamSpecTypeInfoFinalize
    attrTransfer _ v = do
        GObject.Callbacks.mk_ParamSpecTypeInfoFinalizeFieldCallback (GObject.Callbacks.wrap_ParamSpecTypeInfoFinalizeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.finalize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:finalize"
        })

paramSpecTypeInfo_finalize :: AttrLabelProxy "finalize"
paramSpecTypeInfo_finalize = AttrLabelProxy

#endif


-- | Get the value of the “@value_set_default@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #valueSetDefault
-- @
getParamSpecTypeInfoValueSetDefault :: MonadIO m => ParamSpecTypeInfo -> m (Maybe GObject.Callbacks.ParamSpecTypeInfoValueSetDefaultFieldCallback)
getParamSpecTypeInfoValueSetDefault s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueSetDefaultFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ParamSpecTypeInfoValueSetDefaultFieldCallback val'
        return val''
    return result

-- | Set the value of the “@value_set_default@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #valueSetDefault 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoValueSetDefault :: MonadIO m => ParamSpecTypeInfo -> FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueSetDefaultFieldCallback -> m ()
setParamSpecTypeInfoValueSetDefault s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueSetDefaultFieldCallback)

-- | Set the value of the “@value_set_default@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #valueSetDefault
-- @
clearParamSpecTypeInfoValueSetDefault :: MonadIO m => ParamSpecTypeInfo -> m ()
clearParamSpecTypeInfoValueSetDefault s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueSetDefaultFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoValueSetDefaultFieldInfo
instance AttrInfo ParamSpecTypeInfoValueSetDefaultFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoValueSetDefaultFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoValueSetDefaultFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ParamSpecTypeInfoValueSetDefaultFieldInfo = (~) (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueSetDefaultFieldCallback)
    type AttrTransferTypeConstraint ParamSpecTypeInfoValueSetDefaultFieldInfo = (~)GObject.Callbacks.ParamSpecTypeInfoValueSetDefaultFieldCallback
    type AttrTransferType ParamSpecTypeInfoValueSetDefaultFieldInfo = (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueSetDefaultFieldCallback)
    type AttrGetType ParamSpecTypeInfoValueSetDefaultFieldInfo = Maybe GObject.Callbacks.ParamSpecTypeInfoValueSetDefaultFieldCallback
    type AttrLabel ParamSpecTypeInfoValueSetDefaultFieldInfo = "value_set_default"
    type AttrOrigin ParamSpecTypeInfoValueSetDefaultFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoValueSetDefault
    attrSet = setParamSpecTypeInfoValueSetDefault
    attrConstruct = undefined
    attrClear = clearParamSpecTypeInfoValueSetDefault
    attrTransfer _ v = do
        GObject.Callbacks.mk_ParamSpecTypeInfoValueSetDefaultFieldCallback (GObject.Callbacks.wrap_ParamSpecTypeInfoValueSetDefaultFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.valueSetDefault"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:valueSetDefault"
        })

paramSpecTypeInfo_valueSetDefault :: AttrLabelProxy "valueSetDefault"
paramSpecTypeInfo_valueSetDefault = AttrLabelProxy

#endif


-- | Get the value of the “@value_validate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #valueValidate
-- @
getParamSpecTypeInfoValueValidate :: MonadIO m => ParamSpecTypeInfo -> m (Maybe GObject.Callbacks.ParamSpecTypeInfoValueValidateFieldCallback)
getParamSpecTypeInfoValueValidate s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueValidateFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ParamSpecTypeInfoValueValidateFieldCallback val'
        return val''
    return result

-- | Set the value of the “@value_validate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #valueValidate 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoValueValidate :: MonadIO m => ParamSpecTypeInfo -> FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueValidateFieldCallback -> m ()
setParamSpecTypeInfoValueValidate s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueValidateFieldCallback)

-- | Set the value of the “@value_validate@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #valueValidate
-- @
clearParamSpecTypeInfoValueValidate :: MonadIO m => ParamSpecTypeInfo -> m ()
clearParamSpecTypeInfoValueValidate s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueValidateFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoValueValidateFieldInfo
instance AttrInfo ParamSpecTypeInfoValueValidateFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoValueValidateFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoValueValidateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ParamSpecTypeInfoValueValidateFieldInfo = (~) (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueValidateFieldCallback)
    type AttrTransferTypeConstraint ParamSpecTypeInfoValueValidateFieldInfo = (~)GObject.Callbacks.ParamSpecTypeInfoValueValidateFieldCallback
    type AttrTransferType ParamSpecTypeInfoValueValidateFieldInfo = (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValueValidateFieldCallback)
    type AttrGetType ParamSpecTypeInfoValueValidateFieldInfo = Maybe GObject.Callbacks.ParamSpecTypeInfoValueValidateFieldCallback
    type AttrLabel ParamSpecTypeInfoValueValidateFieldInfo = "value_validate"
    type AttrOrigin ParamSpecTypeInfoValueValidateFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoValueValidate
    attrSet = setParamSpecTypeInfoValueValidate
    attrConstruct = undefined
    attrClear = clearParamSpecTypeInfoValueValidate
    attrTransfer _ v = do
        GObject.Callbacks.mk_ParamSpecTypeInfoValueValidateFieldCallback (GObject.Callbacks.wrap_ParamSpecTypeInfoValueValidateFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.valueValidate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:valueValidate"
        })

paramSpecTypeInfo_valueValidate :: AttrLabelProxy "valueValidate"
paramSpecTypeInfo_valueValidate = AttrLabelProxy

#endif


-- | Get the value of the “@values_cmp@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paramSpecTypeInfo #valuesCmp
-- @
getParamSpecTypeInfoValuesCmp :: MonadIO m => ParamSpecTypeInfo -> m (Maybe GObject.Callbacks.ParamSpecTypeInfoValuesCmpFieldCallback)
getParamSpecTypeInfoValuesCmp s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValuesCmpFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ParamSpecTypeInfoValuesCmpFieldCallback val'
        return val''
    return result

-- | Set the value of the “@values_cmp@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paramSpecTypeInfo [ #valuesCmp 'Data.GI.Base.Attributes.:=' value ]
-- @
setParamSpecTypeInfoValuesCmp :: MonadIO m => ParamSpecTypeInfo -> FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValuesCmpFieldCallback -> m ()
setParamSpecTypeInfoValuesCmp s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValuesCmpFieldCallback)

-- | Set the value of the “@values_cmp@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #valuesCmp
-- @
clearParamSpecTypeInfoValuesCmp :: MonadIO m => ParamSpecTypeInfo -> m ()
clearParamSpecTypeInfoValuesCmp s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValuesCmpFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ParamSpecTypeInfoValuesCmpFieldInfo
instance AttrInfo ParamSpecTypeInfoValuesCmpFieldInfo where
    type AttrBaseTypeConstraint ParamSpecTypeInfoValuesCmpFieldInfo = (~) ParamSpecTypeInfo
    type AttrAllowedOps ParamSpecTypeInfoValuesCmpFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ParamSpecTypeInfoValuesCmpFieldInfo = (~) (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValuesCmpFieldCallback)
    type AttrTransferTypeConstraint ParamSpecTypeInfoValuesCmpFieldInfo = (~)GObject.Callbacks.ParamSpecTypeInfoValuesCmpFieldCallback
    type AttrTransferType ParamSpecTypeInfoValuesCmpFieldInfo = (FunPtr GObject.Callbacks.C_ParamSpecTypeInfoValuesCmpFieldCallback)
    type AttrGetType ParamSpecTypeInfoValuesCmpFieldInfo = Maybe GObject.Callbacks.ParamSpecTypeInfoValuesCmpFieldCallback
    type AttrLabel ParamSpecTypeInfoValuesCmpFieldInfo = "values_cmp"
    type AttrOrigin ParamSpecTypeInfoValuesCmpFieldInfo = ParamSpecTypeInfo
    attrGet = getParamSpecTypeInfoValuesCmp
    attrSet = setParamSpecTypeInfoValuesCmp
    attrConstruct = undefined
    attrClear = clearParamSpecTypeInfoValuesCmp
    attrTransfer _ v = do
        GObject.Callbacks.mk_ParamSpecTypeInfoValuesCmpFieldCallback (GObject.Callbacks.wrap_ParamSpecTypeInfoValuesCmpFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ParamSpecTypeInfo.valuesCmp"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-ParamSpecTypeInfo.html#g:attr:valuesCmp"
        })

paramSpecTypeInfo_valuesCmp :: AttrLabelProxy "valuesCmp"
paramSpecTypeInfo_valuesCmp = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ParamSpecTypeInfo
type instance O.AttributeList ParamSpecTypeInfo = ParamSpecTypeInfoAttributeList
type ParamSpecTypeInfoAttributeList = ('[ '("instanceSize", ParamSpecTypeInfoInstanceSizeFieldInfo), '("nPreallocs", ParamSpecTypeInfoNPreallocsFieldInfo), '("instanceInit", ParamSpecTypeInfoInstanceInitFieldInfo), '("valueType", ParamSpecTypeInfoValueTypeFieldInfo), '("finalize", ParamSpecTypeInfoFinalizeFieldInfo), '("valueSetDefault", ParamSpecTypeInfoValueSetDefaultFieldInfo), '("valueValidate", ParamSpecTypeInfoValueValidateFieldInfo), '("valuesCmp", ParamSpecTypeInfoValuesCmpFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveParamSpecTypeInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveParamSpecTypeInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveParamSpecTypeInfoMethod t ParamSpecTypeInfo, O.OverloadedMethod info ParamSpecTypeInfo p) => OL.IsLabel t (ParamSpecTypeInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveParamSpecTypeInfoMethod t ParamSpecTypeInfo, O.OverloadedMethod info ParamSpecTypeInfo p, R.HasField t ParamSpecTypeInfo p) => R.HasField t ParamSpecTypeInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveParamSpecTypeInfoMethod t ParamSpecTypeInfo, O.OverloadedMethodInfo info ParamSpecTypeInfo) => OL.IsLabel t (O.MethodProxy info ParamSpecTypeInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


