{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.GObject.Objects.ParamSpec.ParamSpec' derived structure that contains the meta data for integer properties.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Objects.ParamSpecInt
    ( 

-- * Exported types
    ParamSpecInt(..)                        ,
    IsParamSpecInt                          ,
    toParamSpecInt                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [sink]("GI.GObject.Objects.ParamSpec#g:method:sink"), [stealQdata]("GI.GObject.Objects.ParamSpec#g:method:stealQdata").
-- 
-- ==== Getters
-- [getBlurb]("GI.GObject.Objects.ParamSpec#g:method:getBlurb"), [getDefaultValue]("GI.GObject.Objects.ParamSpec#g:method:getDefaultValue"), [getName]("GI.GObject.Objects.ParamSpec#g:method:getName"), [getNameQuark]("GI.GObject.Objects.ParamSpec#g:method:getNameQuark"), [getNick]("GI.GObject.Objects.ParamSpec#g:method:getNick"), [getQdata]("GI.GObject.Objects.ParamSpec#g:method:getQdata"), [getRedirectTarget]("GI.GObject.Objects.ParamSpec#g:method:getRedirectTarget").
-- 
-- ==== Setters
-- [setQdata]("GI.GObject.Objects.ParamSpec#g:method:setQdata").

#if defined(ENABLE_OVERLOADING)
    ResolveParamSpecIntMethod               ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GObject.Objects.ParamSpec as GObject.ParamSpec

#else
import {-# SOURCE #-} qualified GI.GObject.Objects.ParamSpec as GObject.ParamSpec

#endif

-- | Memory-managed wrapper type.
newtype ParamSpecInt = ParamSpecInt (SP.ManagedPtr ParamSpecInt)
    deriving (Eq)

instance SP.ManagedPtrNewtype ParamSpecInt where
    toManagedPtr (ParamSpecInt p) = p

foreign import ccall "haskell_gi_pspec_type_init_ParamSpecInt"
    c_haskell_gi_pspec_type_init_ParamSpecInt :: IO B.Types.GType

instance B.Types.TypedObject ParamSpecInt where
    glibType = c_haskell_gi_pspec_type_init_ParamSpecInt

-- | Type class for types which can be safely cast to `ParamSpecInt`, for instance with `toParamSpecInt`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ParamSpecInt o) => IsParamSpecInt o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ParamSpecInt o) => IsParamSpecInt o

instance O.HasParentTypes ParamSpecInt
type instance O.ParentTypes ParamSpecInt = '[GObject.ParamSpec.ParamSpec]

-- | Cast to `ParamSpecInt`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toParamSpecInt :: (MIO.MonadIO m, IsParamSpecInt o) => o -> m ParamSpecInt
toParamSpecInt = MIO.liftIO . B.ManagedPtr.unsafeCastTo ParamSpecInt

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveParamSpecIntMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveParamSpecIntMethod "sink" o = GObject.ParamSpec.ParamSpecSinkMethodInfo
    ResolveParamSpecIntMethod "stealQdata" o = GObject.ParamSpec.ParamSpecStealQdataMethodInfo
    ResolveParamSpecIntMethod "getBlurb" o = GObject.ParamSpec.ParamSpecGetBlurbMethodInfo
    ResolveParamSpecIntMethod "getDefaultValue" o = GObject.ParamSpec.ParamSpecGetDefaultValueMethodInfo
    ResolveParamSpecIntMethod "getName" o = GObject.ParamSpec.ParamSpecGetNameMethodInfo
    ResolveParamSpecIntMethod "getNameQuark" o = GObject.ParamSpec.ParamSpecGetNameQuarkMethodInfo
    ResolveParamSpecIntMethod "getNick" o = GObject.ParamSpec.ParamSpecGetNickMethodInfo
    ResolveParamSpecIntMethod "getQdata" o = GObject.ParamSpec.ParamSpecGetQdataMethodInfo
    ResolveParamSpecIntMethod "getRedirectTarget" o = GObject.ParamSpec.ParamSpecGetRedirectTargetMethodInfo
    ResolveParamSpecIntMethod "setQdata" o = GObject.ParamSpec.ParamSpecSetQdataMethodInfo
    ResolveParamSpecIntMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveParamSpecIntMethod t ParamSpecInt, O.OverloadedMethod info ParamSpecInt p) => OL.IsLabel t (ParamSpecInt -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveParamSpecIntMethod t ParamSpecInt, O.OverloadedMethod info ParamSpecInt p, R.HasField t ParamSpecInt p) => R.HasField t ParamSpecInt p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveParamSpecIntMethod t ParamSpecInt, O.OverloadedMethodInfo info ParamSpecInt) => OL.IsLabel t (O.MethodProxy info ParamSpecInt) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ParamSpecInt where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()



